include doszip.inc
include stdlib.inc
include string.inc
include io.inc

;----------------------------------------------------------------------------
; Ministatus window(s)
;----------------------------------------------------------------------------

.data

DB_VIDISK	db 0
CP_VIDISK	db 'C:\',0
CP_VIFREE	db 'Size:',10
CP_VITOTAL	db 'Free:',0
CP_VIBYTE	db 'byte',0
CP_NONAME	db 'NONAME',0
cp_bselected	db '%s byte in %d file(s)',0
format_20s	db '%20s',0
cp_emptydisk	db '[%c:] Empty disk',0
qrax		label qword
qeax		dd 0	; Selected size
qedx		dd 0

.code

ministatus_putselected proc private uses esi edi x,y:dword, panel:dword
local bstring[64]:byte
	xor eax,eax
	mov qeax,eax
	mov qedx,eax
	mov esi,panel
	mov ecx,[esi].S_PANEL.pn_fcb_count
	.if ecx
	    mov edx,[esi].S_PANEL.pn_wsub
	    .if [edx].S_WSUB.ws_fcb != eax
		mov edi,eax
		mov esi,[edx].S_WSUB.ws_fcb
		.while ecx
		    mov edx,[esi]
		    mov eax,[edx].S_FBLK.fb_flag
		    .if eax & _FB_SELECTED
			inc edi
			.if !(al & _A_SUBDIR)
			    mov eax,dword ptr [edx].S_FBLK.fb_size
			    mov edx,dword ptr [edx].S_FBLK.fb_size[4]
			    add qeax,eax
			    adc qedx,edx
			.endif
		    .endif
		    add esi,4
		    dec ecx
		.endw
		invoke mkbstring,addr bstring,qrax
		mov cl,at_background[B_Panel]
		or  cl,at_foreground[F_Panel]
		mov edx,x
		inc dl
		invoke scputc,edx,y,37,' '
		invoke scputf,edx,y,ecx,0,addr cp_bselected,addr bstring,edi
	    .endif
	.endif
	ret
ministatus_putselected endp

volinfo_clear proc private x,y:dword
	mov	edx,x
	mov	ecx,y
	sub	cl,2
	inc	dl
	test	cflag,_C_HORIZONTAL
	jz	@F
	add	dl,40
     @@:
	call	@F
	inc	cl
	call	@F
	inc	cl
	test	cflag,_C_HORIZONTAL
	jz	toend
	sub	dl,40
	call	@F
  toend:
	ret
     @@:
	mov	ah,at_background[B_Panel]
	or	ah,at_foreground[F_Panel]
	mov	al,' '
	invoke  scputw,edx,ecx,37,eax
	retn
volinfo_clear endp

volinfo_putinfo proc private x,y:dword
	mov	edx,x
	add	edx,1
	test	cflag,_C_HORIZONTAL
	jz	@F
	add	dl,40
     @@:
	mov	ecx,y
	sub	ecx,2
	invoke  scputs,edx,ecx,0,0,addr CP_VIFREE
	add	dl,31
	invoke  scputs,edx,ecx,0,0,addr CP_VIBYTE
	inc	ecx
	invoke  scputs,edx,ecx,0,0,addr CP_VIBYTE
	ret
volinfo_putinfo endp

volinfo_getdisk proc private panel:dword
	mov	eax,panel
	mov	eax,[eax]
	add	eax,S_PATH.wp_path
	mov	eax,[eax]
	mov	CP_VIDISK,al
	mov	DB_VIDISK,0FFh
	test	al,al
	jz	@F
	cmp	ah,':'
	jne	@F
	and	al,not 20h
	mov	CP_VIDISK,al
	sub	al,'A' - 1
	mov	DB_VIDISK,al
     @@:
	ret
volinfo_getdisk endp

volinfo_putvolid proc private x,y:dword, panel:dword
local VolumeID[32]:byte
	invoke volinfo_getdisk,panel
	.if DB_VIDISK != 0FFh
	    .if GetVolumeID(addr CP_VIDISK,addr VolumeID)
		movzx eax,DB_VIDISK
		.if _disk_exist(eax)
		    add eax,S_DISK.di_name[3]
		    mov edx,eax
		    mov byte ptr [eax-1],' '
		    invoke strncpy,edx,addr VolumeID,27
		.endif
		mov cl,at_background[B_Panel]
		or  cl,at_foreground[F_Files]
		mov edx,y
		sub dl,2
		inc x
		.if !(cflag & _C_HORIZONTAL)
		    dec dl
		.endif
		invoke scputs,x,edx,ecx,30,addr VolumeID
	    .endif
	.endif
	ret
volinfo_putvolid endp

volinfo_putlfn proc private uses ebx x,y:dword
local FileSystemName[32]:byte
	.if GetFileSystemName(addr CP_VIDISK,addr FileSystemName)
	    mov cl,at_background[B_Panel]
	    or  cl,at_foreground[F_Subdir]
	    mov ebx,y
	    sub ebx,2
	    mov edx,x
	    add dl,12
	    .if !(cflag & _C_HORIZONTAL)
		dec bl
	    .endif
	    invoke scputf,edx,ebx,ecx,24,"%24s",addr FileSystemName
	.endif
	ret
volinfo_putlfn endp

ministatus_putvolinfo proc private uses ebx x,y:dword, panel:dword
local FreeBytesAvailable:qword
local TotalNumberOfBytes:qword
local TotalNumberOfFreeBytes:qword
local cFreeBytesAvailable[32]:byte
local cTotalNumberOfBytes[32]:byte
	invoke volinfo_clear,x,y
	invoke volinfo_putinfo,x,y
	invoke volinfo_putvolid,x,y,panel
	invoke volinfo_putlfn,x,y
	invoke GetDiskFreeSpaceEx,
	    addr CP_VIDISK,
	    addr FreeBytesAvailable,
	    addr TotalNumberOfBytes,
	    addr TotalNumberOfFreeBytes
	invoke mkbstring,addr cFreeBytesAvailable,FreeBytesAvailable
	invoke mkbstring,addr cTotalNumberOfBytes,TotalNumberOfBytes
	mov cl,at_background[B_Panel]
	or  cl,at_foreground[F_Files]
	mov ebx,y
	sub bl,2
	mov edx,x
	add dl,11
	.if cflag & _C_HORIZONTAL
	    add dl,40
	.endif
	invoke scputf,edx,ebx,ecx,30,addr format_20s,addr cTotalNumberOfBytes
	inc ebx
	invoke scputf,edx,ebx,ecx,30,addr format_20s,addr cFreeBytesAvailable
	ret
ministatus_putvolinfo endp

panel_putmini proc uses esi edi
local l,x,y,fb:dword
	mov esi,eax
	mov edi,[esi].S_PANEL.pn_dialog
	movzx eax,[edi].S_DOBJ.dl_rect.rc_col
	sub eax,2
	mov l,eax
	mov eax,esi
	.if [edi].S_DOBJ.dl_flag & _D_ONSCR
	    .if panel_state()
		movzx eax,[edi].S_DOBJ.dl_rect.rc_x
		inc eax
		mov x,eax
		movzx eax,[edi].S_DOBJ.dl_rect.rc_y
		add al,[edi].S_DOBJ.dl_rect.rc_row
		sub al,2
		mov y,eax
		mov eax,[esi].S_PANEL.pn_path
		mov eax,[eax].S_PATH.wp_flag
		.if eax & _W_MINISTATUS
		    .if eax & _W_DRVINFO
			invoke ministatus_putvolinfo,x,y,esi
		    .endif
		    movzx ecx,[edi].S_DOBJ.dl_rect.rc_col
		    sub ecx,2
		    mov ah,at_background[B_Panel]
		    or  ah,at_foreground[F_Hidden]
		    mov al,' '
		    invoke scputw,x,y,ecx,eax
		    movzx ecx,ah
		    .if [esi].S_PANEL.pn_fcb_count == 0
			mov eax,[esi].S_PANEL.pn_path
			mov al,[eax].S_PATH.wp_path
			invoke scputf,x,y,0,0,addr cp_emptydisk,eax
		    .else
			mov eax,[esi].S_PANEL.pn_fcb_index
			add eax,[esi].S_PANEL.pn_cel_index
			invoke wsfblk,[esi].S_PANEL.pn_wsub,eax
			mov fb,eax
			mov eax,esi
			.if panel_selected()
			    invoke ministatus_putselected,x,y,esi
			.else
			     invoke fbputfile,fb,x,y,l
			     mov eax,fb
			     .if [eax].S_FBLK.fb_flag & _FB_UPDIR
				invoke scputw,x,y,2,' '
				mov esi,[esi]
				invoke strfn,addr [esi].S_PATH.wp_path
				mov cl,at_background[B_Panel]
				or  cl,at_foreground[F_System]
				invoke scputs,x,y,ecx,12,eax
			    .endif
			.endif
		    .endif
		.endif
	    .endif
	.endif
	ret
panel_putmini endp

	END
