include doszip.inc
include string.inc
include io.inc
include alloc.inc
ifdef __ROT__
include tinfo.inc
endif

.data

format_10lu	db "%10lu",0
format_02lX	db 16," VOL-%02u ",17,0
cp_subdir	db 16," SUBDIR ",17,0
cp_updir	db 16," UP-DIR ",17,0

.code

xlen	equ	[ebp+16]
xywp	equ	[ebp+12]
fblk	equ	[ebp+8]

fbputsize:
	push	ebx
	push	edx
	mov	ebx,fblk
	mov	eax,[ebx].S_FBLK.fb_flag
	invoke  fbcolor
	shl	eax,8
	mov	ecx,eax
	mov	eax,offset format_10lu
	.if [ebx].S_FBLK.fb_flag & _A_VOLID
	    mov ch,at_foreground[F_Subdir]
	    or  ch,at_background[B_Panel]
	    mov eax,offset format_02lX
	.endif
	invoke  wcputf,edx,xlen,ecx,eax,[ebx].S_FBLK.fb_size
	pop	edx
	pop	ebx
	ret

fbputsystem:
	push	ebx
	mov	edx,eax
	mov	ebx,fblk
	mov	eax,[ebx].S_FBLK.fb_flag
	.if al & (_A_HIDDEN or _A_SYSTEM)
	    call fbcolor
	    mov ah,al
	    mov al,''
	    invoke wcputw,edx,1,eax
	.endif
	pop	ebx
	ret

fbputmax:
	push	ebx
	mov	ebx,eax
	mov	al,''
	mov	ah,at_foreground[F_Panel]
	or	ah,at_background[B_Panel]
	invoke  wcputw,ebx,1,eax
	pop	ebx
	ret

fbputdatetime:
	push	eax
	add	eax,18
	invoke  fbputtime,fblk,eax
	pop	eax
	invoke  fbputdate,fblk,eax
	ret

fbloadbock:
	mov	eax,fblk
	mov	ebx,eax
	add	eax,S_FBLK.fb_name
	mov	edi,eax
	invoke  strlen,eax
	mov	esi,eax
	mov	eax,[ebx].S_FBLK.fb_flag
	mov	ecx,eax
	call	fbcolor
	shl	eax,8
	ret

fbputdate proc private uses esi edi ebx fb:dword, wp:dword
	mov	ebx,fb
	mov	edi,[ebx].S_FBLK.fb_flag
	movzx	eax,word ptr [ebx].S_FBLK.fb_time+2
	mov	esi,eax
ifdef __ROT__
	.if edi & _FB_ROOTDIR
	    or edi,_A_SYSTEM
	.endif
endif
	shr	eax,9
	.if eax >= 20
	    sub eax,20
	.else
	    add eax,80
	.endif
	push	eax
	mov	eax,esi
	shr	eax,5
	and	eax,000Fh
	push	eax
	mov	eax,esi
	and	eax,001Fh
	push	eax
	mov	eax,edi
	call	fbcolor
	shl	eax,8
	invoke  wcputf,wp,0,eax,addr cp_datefrm
	add	esp,12
	ret
fbputdate endp

fbputtime proc private uses ebx fb, wp
	mov	ebx,fb
	mov	eax,[ebx].S_FBLK.fb_time
	shr	eax,5
	and	eax,003Fh
	push	eax
	mov	eax,[ebx].S_FBLK.fb_time
	shr	eax,11
	and	eax,001Fh
	push	eax
	mov	eax,[ebx].S_FBLK.fb_flag
ifdef __ROT__
	.if eax & _FB_ROOTDIR
	    or eax,_A_SYSTEM
	.endif
endif
	call	fbcolor
	shl	eax,8
	invoke  wcputf,wp,0,eax,addr cp_timefrm
	add	esp,8
	ret
fbputtime endp

fbput83 proc private uses edx xl:dword, wp:dword, at:dword, fname:dword
	mov eax,fname
	.if word ptr [eax] == '..'
	    sub eax,eax
	.else
	    invoke strext,eax
	.endif
	push eax
	mov ecx,xl
	.if !ZERO?
	    sub eax,fname
	    .if al <= cl
		mov cl,al
	    .endif
	.endif
	mov ch,byte ptr at
	invoke wcputs,wp,xlen,ecx,fname
	pop eax
	.if eax
	    inc eax
	    mov edx,wp
	    add edx,xl
	    add edx,xl
	    add edx,2
	    mov cl,3
	    invoke wcputs,edx,0,ecx,eax
	.endif
	ret
fbput83 endp

fbputsl proc uses esi edi ebx fb, wp, l:dword
	call	fbloadbock
	shr	eax,8
	mov	ebx,eax
	mov	eax,l
	.if eax > 30
	    sub eax,30
	.else
	    mov eax,8
	.endif
	invoke  fbput83,eax,wp,ebx,edi
	mov	edx,wp
	mov	eax,l
	add	edx,eax
	add	edx,eax
	.if esi > eax
	    mov eax,edx
	    sub eax,10
	    call fbputmax
	.endif
	mov	eax,edx
	sub	eax,8
	call	fbputsystem
	ret
fbputsl endp

fbputsd proc uses esi edi ebx fb, wp, l:dword
	call	fbloadbock
	mov	ebx,eax
	mov	edx,wp
	add	edx,l
	add	edx,l
	sub	edx,50
	.if ecx & _FB_UPDIR
	    invoke wcputs,edx,0,ebx,addr cp_updir
	.elseif ecx & _A_SUBDIR
	    invoke wcputs,edx,0,ebx,addr cp_subdir
	.else
	    call fbputsize
	.endif
	mov	eax,l
	sub	eax,30
	shr	ebx,8
	invoke  fbput83,eax,wp,ebx,edi
	sub	edx,10
	mov	eax,edx
	call	fbputsystem
	mov	eax,l
	sub	eax,26
	.if esi > eax
	    mov eax,edx
	    sub eax,2
	    call fbputmax
	.endif
	mov eax,edx
	add eax,32
	call fbputdatetime
	ret
fbputsd endp

fbputll proc uses esi edi ebx fb, wp, l:dword
	call	fbloadbock
	mov	ecx,l
	dec	ecx
	mov	ch,ah
	invoke  wcputs,wp,l,ecx,edi
	mov	ch,0
	mov	ebx,wp
	add	ebx,ecx
	add	ebx,ecx
	.if esi > ecx
	    mov eax,ebx
	    sub eax,2
	    call fbputmax
	.endif
	mov	eax,ebx
	call	fbputsystem
	ret
fbputll endp

fbputld proc uses esi edi ebx fb:dword, wp:dword, l:dword
local dist:dword
	mov	dist,0
	.if cflag & _C_HORIZONTAL	; Long Horizontal Detail
	    mov dist,12
	.endif
	call	fbloadbock
	mov	ebx,eax
	mov	edx,wp
	add	edx,l
	add	edx,l
	sub	edx,38			; Long Vertical Detail
	sub	edx,dist
	.if ecx & _FB_UPDIR
	    invoke wcputs,edx,0,ebx,addr cp_updir
	.elseif ecx & _A_SUBDIR
	    invoke wcputs,edx,0,ebx,addr cp_subdir
	.else
	    call fbputsize
	.endif
	sub	edx,10
	mov	eax,edx
	call	fbputsystem
	shr	dist,1
	mov	eax,l
	sub	eax,24
	sub	eax,dist
	shr	ebx,8
	invoke fbput83,eax,wp,ebx,edi
	mov	eax,l
	sub	eax,21
	sub	eax,dist
	.if esi > eax
	    mov eax,edx
	    sub eax,2
	    call fbputmax
	.endif
	mov	eax,wp
	add	eax,l
	add	eax,l
	.if cflag & _C_HORIZONTAL
	    sub eax,28
	    call fbputdatetime
	.else
	    sub eax,16
	    invoke fbputdate,fb,eax
	.endif
	ret
fbputld endp

;
; 0. Clear panel
; 1. moving down: all lines moved up 1	 -- last line cleared
; 2. moving up:	  all lines moved down 1 -- first line cleared
;

prect_clear proc private uses esi edi ebx dialog:dword, rc:S_RECT, ptype:dword
local wl,l:dword
	mov	ebx,dialog
	movzx	eax,rc.rc_col
	mov	l,eax
	add	eax,eax
	mov	wl,eax
	movzx	edi,rc.rc_row
	mov	eax,ptype
	cmp	al,1
	je	moveonelineup
	cmp	al,2
	je	moveonelinedown
	jmp	clearpanel
    moveonelineup:
	mov	ecx,l
	lea	eax,[edi-1]
	mov	edi,ebx
	lea	esi,[edi+ecx*2]
	mul	ecx
	mov	ecx,eax
	rep	movsw
	mov	ebx,edi
	mov	edi,1
	jmp	clearpanel
    moveonelinedown:
	mov	ecx,l
	lea	eax,[edi-1]
	mov	esi,ebx
	lea	edi,[esi+ecx*2]
	mul	ecx
	mov	ecx,eax
	dec	eax
	add	eax,eax
	add	edi,eax
	add	esi,eax
	std
	rep	movsw
	cld
	mov	edi,1
    clearpanel:
	mov	edx,ebx
	mov	ecx,l
	mov	ah,at_foreground[F_Panel]
	or	ah,at_background[B_Panel]
    clearloop:
	mov	al,[edx]
	cmp	al,179
	je	@F
	mov	al,' '
	mov	[edx],ax
      @@:
	add	edx,2
	dec	ecx
	jnz	clearloop
	add	ebx,wl
	dec	edi
	jnz	clearpanel
  break:
	ret
prect_clear endp

panel_putitem proc uses esi edi ebx panel:dword, index:dword
local rc:S_RECT
local rcxc:S_RECT
local dlrc:dword
local result:dword
local count:dword
local dlwp:dword
	mov esi,panel
	mov edi,[esi].S_PANEL.pn_dialog
	.if [edi].S_DOBJ.dl_flag & _D_ONSCR
	    mov eax,[edi].S_DOBJ.dl_rect
	    mov rc,eax
	    movzx eax,ax
	    mov dlrc,eax
	    add rc.rc_y,2
	    inc rc.rc_x
	    sub rc.rc_col,2
	    sub rc.rc_row,3
	    mov eax,[esi].S_PANEL.pn_path
	    mov eax,[eax].S_PATH.wp_flag
	    .if eax & _W_MINISTATUS
		sub rc.rc_row,2
		.if eax & _W_DRVINFO
		    sub rc.rc_row,3
		    .if cflag & _C_HORIZONTAL
			inc rc.rc_row
		    .endif
		.endif
	    .endif
	    .if rcalloc(rc,0)
		mov dlwp,eax
		mov ebx,eax
		mov eax,[esi].S_PANEL.pn_fcb_count
		.if eax
		    invoke dlclose,[esi].S_PANEL.pn_xl
		    mov result,eax
		    mov eax,esi
		    invoke pcell_set
		    invoke rcread,rc,ebx
		    invoke prect_clear,ebx,rc,index
		    sub edi,edi
		    mov count,-1
		    .repeat
			inc count
			mov eax,count
			.if eax >= [esi].S_PANEL.pn_cel_count
			    invoke rcwrite,rc,ebx
			    invoke free,ebx
			    .if result
				mov eax,esi
				invoke pcell_show
			    .endif
			    mov eax,esi
			    invoke panel_putmini
			    .break
			.endif
			invoke pcell_getrect,[esi].S_PANEL.pn_xl,eax
			sub eax,dlrc
			sub eax,00000201h
			mov rcxc,eax
			movzx ecx,rc.rc_col
			invoke rcbprc,eax,dlwp,ecx
			mov edx,eax
			mov eax,index
			.if eax == 1
			    mov ecx,[esi].S_PANEL.pn_xl
			    mov eax,edi
			    add al,[ecx].S_XCEL.xl_rows
			    dec al
			.elseif eax == 2
			    mov eax,edi
			.else
			    mov al,rcxc.rc_y
			.endif
			.if rcxc.rc_y == al
			    mov eax,[esi].S_PANEL.pn_xl
			    movzx eax,[eax].S_XCEL.xl_cpos.rc_col
			    push eax
			    mov eax,[esi].S_PANEL.pn_wsub
			    mov ecx,[eax].S_WSUB.ws_fcb
			    mov eax,[esi].S_PANEL.pn_fcb_index
			    add eax,count
			    mov ecx,[ecx+eax*4]
			    push edx
			    push ecx
			    call [esi].S_PANEL.pn_putfcb
			.endif
		    .until 0
		.else
		    invoke dlclose,[esi].S_PANEL.pn_xl
		    mov eax,esi
		    invoke pcell_set
		    invoke rcread,rc,ebx
		    invoke prect_clear,edi,rc,0
		    invoke free,ebx
		.endif
	    .endif
	.endif
	ret
panel_putitem endp

panel_putinfozx proc
	sub	eax,eax
	mov	[esi].S_PANEL.pn_cel_index,eax
	mov	[esi].S_PANEL.pn_fcb_index,eax
panel_putinfozx endp

panel_putinfoax proc
	push	eax
	mov	eax,esi
	call	panel_putinfo
	pop	eax
panel_putinfoax endp

panel_putitemax proc
	invoke  panel_putitem,esi,eax
	mov	eax,1
	ret
panel_putitemax endp

	END
