include doszip.inc
include string.inc
include io.inc
include errno.inc
include stdlib.inc
include keyb.inc
include process.inc
ifdef __DLL__
include dll.inc
endif

externdef	cp_quote:byte

.data
cp_error_chdir  db "Error open directory",0
cp_chdir_format db "Can't open the directory:",10,"%s",10,10,"%s",0

.code

panelevent_updatecell:
	mov eax,esi
	invoke pcell_update
	ret

panelevent_MOUSEUP:
	mov eax,[esi].S_PANEL.pn_xl
	movzx eax,byte ptr [eax+3]
	.if eax <= [esi].S_PANEL.pn_fcb_index
	    sub [esi].S_PANEL.pn_fcb_index,eax
	    xor eax,eax
	    jmp panel_putitemax
	.endif
	jmp panelevent_UP

panelevent_MOUSEDN:
	mov eax,[esi].S_PANEL.pn_xl
	movzx ecx,byte ptr [eax+3]
	mov eax,[esi].S_PANEL.pn_cel_index
	add eax,[esi].S_PANEL.pn_fcb_index
	add eax,ecx
	.if eax < [esi].S_PANEL.pn_fcb_count
	    add [esi].S_PANEL.pn_fcb_index,ecx
	    xor eax,eax
	    jmp panel_putitemax
	.endif
	jmp panelevent_DOWN

panelevent_LEFT:
	mov ecx,[esi].S_PANEL.pn_xl
	xor eax,eax
	mov edx,eax
	mov al,[ecx+3]
	.if eax <= [esi].S_PANEL.pn_cel_index
	    sub [esi].S_PANEL.pn_cel_index,eax
	    jmp panelevent_updatecell
	.endif
	.if [esi].S_PANEL.pn_cel_index != edx
	    mov [esi].S_PANEL.pn_cel_index,edx
	    jmp panelevent_updatecell
	.endif
	.if [esi].S_PANEL.pn_fcb_index == edx
	    xor eax,eax
	    ret
	.endif
	.if eax <= [esi].S_PANEL.pn_fcb_index
	    sub [esi].S_PANEL.pn_fcb_index,eax
	.else
	    mov [esi].S_PANEL.pn_fcb_index,edx
	.endif
	mov eax,edx
	jmp panel_putitemax

panelevent_RIGHT:
	mov eax,[esi].S_PANEL.pn_xl
	xor ecx,ecx
	mov cl,[eax+3]
	mov eax,[esi].S_PANEL.pn_cel_index
	add eax,ecx
	mov edx,[esi].S_PANEL.pn_cel_count
	dec edx
	.if eax <= edx
	    add [esi].S_PANEL.pn_cel_index,ecx
	    jmp panelevent_updatecell
	.endif
	mov eax,[esi].S_PANEL.pn_cel_index
	add eax,[esi].S_PANEL.pn_fcb_index
	add eax,ecx
	.if eax < [esi].S_PANEL.pn_fcb_count
	    add [esi].S_PANEL.pn_fcb_index,ecx
	    xor eax,eax
	    jmp panel_putitemax
	.endif
	.if [esi].S_PANEL.pn_cel_index < edx
	    mov [esi].S_PANEL.pn_cel_index,edx
	    jmp panelevent_updatecell
	.endif
	xor eax,eax
	ret

panelevent_UP:
	xor eax,eax
	.if [esi].S_PANEL.pn_cel_index != eax
	    dec [esi].S_PANEL.pn_cel_index
	    jmp panelevent_updatecell
	.endif
	.if [esi].S_PANEL.pn_fcb_index == eax
	    ret
	.endif
	dec [esi].S_PANEL.pn_fcb_index
	mov eax,2
	jmp panel_putitemax

panelevent_DOWN:
	mov eax,[esi].S_PANEL.pn_cel_count
	dec eax
	cmp eax,[esi].S_PANEL.pn_cel_index
	jbe @F
	inc [esi].S_PANEL.pn_cel_index
	jmp panelevent_updatecell
      @@:
	jne @F
	mov eax,[esi].S_PANEL.pn_fcb_count
	sub eax,[esi].S_PANEL.pn_fcb_index
	sub eax,[esi].S_PANEL.pn_cel_index
	cmp eax,1
	jle @F
	inc [esi].S_PANEL.pn_fcb_index
	mov eax,1
	jmp panel_putitemax
      @@:
	xor eax,eax
	ret

panelevent_INS:
	mov eax,esi
	.if pcell_select()
	    .if cflag & _C_INSMOVDN
		jmp panelevent_DOWN
	    .endif
	    mov eax,1
	.endif
	ret

panelevent_END:
	mov edx,[esi].S_PANEL.pn_cel_count
	mov eax,[esi].S_PANEL.pn_fcb_count
	.if edx < eax
	    sub eax,edx
	    mov [esi].S_PANEL.pn_fcb_index,eax
	    dec edx
	    mov [esi].S_PANEL.pn_cel_index,edx
	    xor eax,eax
	    jmp panel_putitemax
	.else
	    xor eax,eax
	    dec edx
	    .if edx > [esi].S_PANEL.pn_cel_index
		mov [esi].S_PANEL.pn_cel_index,edx
		mov [esi].S_PANEL.pn_fcb_index,eax
		jmp panel_putitemax
	    .else
		ret
	    .endif
	.endif

panelevent_HOME:
	xor eax,eax
	mov edx,[esi].S_PANEL.pn_cel_index
	or  edx,[esi].S_PANEL.pn_fcb_index
	.if edx
	    mov [esi].S_PANEL.pn_cel_index,eax
	    mov [esi].S_PANEL.pn_fcb_index,eax
	    jmp panel_putitemax
	.endif
	ret

panelevent_PGUP:
	xor eax,eax
	mov edx,[esi].S_PANEL.pn_cel_index
	or  edx,[esi].S_PANEL.pn_fcb_index
	.if edx
	    .if [esi].S_PANEL.pn_cel_index != eax
		mov [esi].S_PANEL.pn_cel_index,eax
		jmp panelevent_updatecell
	    .endif
	    mov ecx,eax
	    mov edx,[esi].S_PANEL.pn_xl
	    mov al,[edx+2]
	    mov cl,[edx+3]
	    imul ecx
	    .if eax <= [esi].S_PANEL.pn_fcb_index
		sub [esi].S_PANEL.pn_fcb_index,eax
	    .else
		mov [esi].S_PANEL.pn_fcb_index,0
	    .endif
	    xor eax,eax
	    jmp panel_putitemax
	.endif
	ret

panelevent_PGDN:
	mov eax,[esi].S_PANEL.pn_cel_count
	dec eax
	.if eax != [esi].S_PANEL.pn_cel_index
	    mov [esi].S_PANEL.pn_cel_index,eax
	    jmp panelevent_updatecell
	.endif
	add eax,[esi].S_PANEL.pn_fcb_index
	inc eax
	.if eax == [esi].S_PANEL.pn_fcb_count
	  @@:
	    xor eax,eax
	    ret
	.endif
	mov eax,[esi].S_PANEL.pn_fcb_index
	add eax,[esi].S_PANEL.pn_cel_count
	cmp eax,[esi].S_PANEL.pn_fcb_count
	jnb @B
	mov eax,[esi].S_PANEL.pn_cel_count
	dec eax
	add [esi].S_PANEL.pn_fcb_index,eax
	xor eax,eax
	mov [esi].S_PANEL.pn_cel_index,eax
	jmp panel_putitemax

ifdef __MOUSE__

panel_scrolldn proc panel:dword
	mov	eax,cpanel
	cmp	eax,panel
	jnz	scrolldn_03
    scrolldn_00:
	mov	edx,panel
	mov	eax,[edx].S_PANEL.pn_cel_count
	dec	eax
	cmp	[edx].S_PANEL.pn_cel_index,eax
	jnl	scrolldn_01
	mov	[edx].S_PANEL.pn_cel_index,eax
	mov	eax,edx
	invoke  pcell_update
	invoke  scroll_delay
	jmp	scrolldn_02
    scrolldn_01:
	invoke  panel_event,panel,KEY_DOWN
    scrolldn_02:
	invoke  scroll_delay
	invoke  mousep
	cmp	eax,1
	je	scrolldn_00
	mov	eax,1
	jmp	scrolldn_04
    scrolldn_03:
	mov	eax,panel
	invoke  panel_setactive
	xor	eax,eax
    scrolldn_04:
	ret
panel_scrolldn endp

panel_scrollup proc panel:dword
	mov	eax,cpanel
	cmp	eax,panel
	jnz	scrollup_03
    scrollup_00:
	xor	eax,eax
	mov	edx,panel
	cmp	[edx].S_PANEL.pn_cel_index,eax
	jz	scrollup_01
	mov	[edx].S_PANEL.pn_cel_index,eax
	mov	eax,edx
	invoke  pcell_update
	invoke  scroll_delay
	jmp	scrollup_02
    scrollup_01:
	invoke  panel_event,panel,KEY_UP
    scrollup_02:
	invoke  scroll_delay
	invoke  mousep
	cmp	eax,1
	je	scrollup_00
	mov	eax,1
	jmp	scrollup_04
    scrollup_03:
	mov	eax,panel
	invoke  panel_setactive
	xor	ax,ax
    scrollup_04:
	ret
panel_scrollup endp

endif

;----------------------------------------------------------------------------
; Panel Event ENTER
;----------------------------------------------------------------------------

S_PEVENT STRUC
pe_fblk  dd ?
pe_name  dd ?
pe_flag  dd ?
pe_panel dd ?
pe_event dd ?
pe_file  db WMAXPATH dup(?)
pe_path  db WMAXPATH dup(?)
S_PEVENT ENDS

panel_savepath proc private uses ecx edx
	mov	eax,edi
	mov	ecx,[edi].S_PATH.wp_flag
ifdef __ARC__
	.if ecx & _W_ARCHIVE or _W_ROOTDIR
	    .if [edi].S_PATH.wp_arch
		add eax,S_PATH.wp_arch
		jmp panel_savepath_00
	    .else
		add eax,S_PATH.wp_file
		jmp panel_savepath_01
	    .endif
	.endif
endif
	add	eax,S_PATH.wp_path
    panel_savepath_00:
	invoke  strfn,eax
    panel_savepath_01:
	lea	edx,[ebp].S_PEVENT.pe_file
	invoke  strcpy,edx,eax
	ret
panel_savepath endp

ifdef __ROT__
panel_enter_rootdir:
	mov [edi].S_PATH.wp_arch,0
	.if !(ecx & _FB_UPDIR)
	    invoke strcpy,addr [edi].S_PATH.wp_arch,[ebp].S_PEVENT.pe_name
	.endif
	or [edi].S_PATH.wp_flag,_W_ROOTDIR
	jmp panel_enter_read
endif

panel_enter_local:
ifdef __ROT__
	test	[ebp].S_PEVENT.pe_flag,_FB_ROOTDIR
	jnz	panel_enter_rootdir
endif
	invoke strfcat,addr [ebp].S_PEVENT.pe_path,addr [edi].S_PATH.wp_path,[ebp].S_PEVENT.pe_name
	.if SetCurrentDirectory(eax)
	    .if GetCurrentDirectory(WMAXPATH,addr [edi].S_PATH.wp_path)
		jmp panel_enter_read
	    .endif
	.endif
	ret

panel_enter_read:
	invoke  cominit,[esi].S_PANEL.pn_wsub
	mov	eax,esi
	invoke  panel_read
	test	esi,esi
	ret

panel_add_to_path:
	add edx,S_FBLK.fb_name
	xor eax,eax
	.if [edi] == al
	    invoke strcpy,edi,edx
	.else
	    invoke strfcat,edi,eax,edx
	.endif
	ret

panel_reduce_path:
	invoke strrchr,edi,'\'
	mov edx,edi
	.if eax
	    mov edx,eax
	    xor eax,eax
	.endif
	mov [edx],al
	ret

panel_enter_network:
	add edi,S_PATH.wp_path
	.if ecx & _FB_UPDIR
	    mov eax,edi
	    add eax,2
	    .if strrchr(eax,'\')
		call panel_reduce_path
	    .endif
	.else
	    call panel_add_to_path
	.endif
	jmp panel_enter_read


ifdef __ARC__

panel_enter_archive:
	.if ecx & _FB_UPDIR
	    .if ![edi].S_PATH.wp_arch
		and [edi].S_PATH.wp_flag,not (_W_ARCHIVE or _W_ROOTDIR)
ifdef __DLL__
		mov dll_active,0
endif
	    .else
		add edi,S_PATH.wp_arch
		call panel_reduce_path
	    .endif
	.else
	    add edi,S_PATH.wp_arch
	    call panel_add_to_path
	.endif
	jmp panel_enter_read

endif

enter_directory_error:
	invoke errnomsg,
	    addr cp_error_chdir,
	    addr cp_chdir_format,
	    addr [ebp].S_PEVENT.pe_path
	ret

panel_enter_directory:
	mov edi,[esi]
	.if [edi].S_PATH.wp_path[1] != ':'
	    .if [edi].S_PATH.wp_path != '\'
		jmp enter_directory_error
	    .endif
	.endif
ifdef __ARC__
	.if !(ecx & _FB_ARCHIVE)
endif
	    invoke historysave
ifdef __ARC__
	.endif
endif
	sub eax,eax
	mov [ebp].S_PEVENT.pe_file,al
	.if ecx & _FB_UPDIR
	    push ebx
	    call panel_savepath
	    pop ebx
	.endif
ifdef __ARC__
	.if ecx & _FB_ARCHIVE
	    call panel_enter_archive
	.elseif [edi].S_PATH.wp_path[1] == ':'
else
	.if [edi].S_PATH.wp_path[1] == ':'
endif
	    call panel_enter_local
	    jz enter_directory_error
	.else
	    call panel_enter_network
	.endif
	.if !([ebp.S_PEVENT.pe_flag] & _FB_ROOTDIR)
	    sub eax,eax
	    mov [esi].S_PANEL.pn_cel_index,eax
	    mov [esi].S_PANEL.pn_fcb_index,eax
	    .if [ebp].S_PEVENT.pe_file != al
		invoke wsearch,[esi].S_PANEL.pn_wsub,addr [ebp].S_PEVENT.pe_file
		.if eax != -1
		    mov edx,eax
		    mov eax,esi
		    invoke panel_setid
		.endif
	    .endif
	.endif
	xor eax,eax
	jmp panel_putinfoax

panelevent_Enter:
	mov eax,esi
	.if !panel_curobj()
	    ret
	.endif
	mov [ebp].S_PEVENT.pe_name,eax
	mov [ebp].S_PEVENT.pe_fblk,edx
	mov [ebp].S_PEVENT.pe_flag,ecx

	test	cl,_A_SUBDIR
	jnz	panel_enter_directory
	test	ecx,_FB_ARCHIVE
	jz	panelevent_enter_root

ifdef __DLL0__
	mov	ebx,[esi]
	mov	eax,[ebx]
	test	eax,_FB_ARCHEXT
	jz	@F
	mov	ebx,[esi].S_PANEL.pn_wsub
	invoke  dll_call,_DLL_ENTER,ebx,edx,0
	jnc	panelevent_enter_read
      @@:
endif
	xor	eax,eax
	ret
    panelevent_enter_root:
ifdef __ROT__
	.if ecx & _FB_ROOTDIR
	    .if ecx & _A_VOLID
		mov eax,cpanel
		mov eax,[eax]
		and [eax].S_PATH.wp_flag,not _W_ROOTDIR
		mov eax,[ebp].S_PEVENT.pe_name
		movzx eax,byte ptr [eax]
		sub al,'A' - 1
		invoke panel_sethdd,cpanel,eax
		mov eax,1
		ret
	    .endif
	.endif
endif
	.if isexec()
panel_enter_cmd:
	    .if strchr([ebp].S_PEVENT.pe_name,' ')
		invoke strcpy,addr [ebp].S_PEVENT.pe_file,addr cp_quote
		invoke strcat,eax,[ebp].S_PEVENT.pe_name
		invoke strcat,eax,addr cp_quote
	    .else
		mov eax,[ebp].S_PEVENT.pe_name
	    .endif
	    invoke command,eax
	    ret
	.endif
	invoke cmdlfblk,[ebp].S_PEVENT.pe_fblk,addr [ebp].S_PEVENT.pe_file
ifdef __DLL__
	.if eax == 1
	    ret
	.elseif eax
	    mov eax,ecx
	    jmp panel_enter_plugin
	.endif
else
	.if eax
	    mov eax,1
	    ret
	.endif
endif
ifdef __ARC__
	mov ebx,[esi]
	invoke strfcat,addr [ebp].S_PEVENT.pe_file,addr [ebx].S_PATH.wp_path,[ebp].S_PEVENT.pe_name
	invoke readword,eax
 ifdef __ZIP__
	.if ax == 4B50h ; 'PK'
	    mov eax,_W_ARCHZIP
	    jmp panel_enter_extern
	.endif
 endif
 ifdef __DLL__
	.if eax
       panel_enter_plugin:
	    .if dll_test([ebp].S_PEVENT.pe_fblk,eax) == 1
		mov eax,_W_ARCHEXT
		jmp panel_enter_extern
	    .elseif eax
		ret
	    .endif
	.endif
 endif
endif ; __ARC__
	.if console & CON_NTCMD
	    invoke CreateConsole,[ebp].S_PEVENT.pe_name,_P_NOWAIT
	.endif
	ret
ifdef __ARC__
       panel_enter_extern:
	.if path_a.wp_flag & _W_ARCHIVE || path_b.wp_flag & _W_ARCHIVE
	    xor eax,eax
	    ret
	.endif
	mov edi,[esi]
	mov [edi].S_PATH.wp_arch,0
	and [edi].S_PATH.wp_flag,not _W_ARCHIVE
	or  [edi].S_PATH.wp_flag,eax
	add edi,S_PATH.wp_file
	invoke strcpy,edi,[ebp].S_PEVENT.pe_name
endif ; __ARC__
    panelevent_enter_read:
	mov  eax,esi
	invoke panel_read
	invoke panel_putinfozx
	ret

;-----------------------------------------------------------------------------

panel_event proc uses esi edi ebx panel:dword, event:dword
local pe:S_PEVENT
	push ebp
	mov eax,panel
	.if panel_state()
	    mov esi,eax
	    mov pe.pe_panel,eax
	    mov eax,event
	    mov pe.pe_event,eax
	    lea ebp,pe
	    mov ecx,pekey_count
	    xor ebx,ebx
	    .if eax == KEY_INS
		mov ebx,keyshift
		mov dl,[ebx]
		.if dl & 3
		    xor eax,eax
		    jmp @F
		.endif
		xor ebx,ebx
	    .endif
	    .while ecx
		.if eax == pekey_table[ebx]
		    call peproc_table[ebx]
		    jmp @F
		.endif
		add ebx,4
		dec ecx
	    .endw
	    xor eax,eax
	.endif
      @@:
	pop ebp
	ret
panel_event endp

.data

pekey_table label dword
	dd KEY_LEFT
	dd KEY_RIGHT
	dd KEY_UP
	dd KEY_INS
	dd KEY_DOWN
	dd KEY_END
	dd KEY_HOME
	dd KEY_PGUP
	dd KEY_PGDN
	dd KEY_ENTER
	dd KEY_KPENTER
	dd KEY_MOUSEUP
	dd KEY_MOUSEDN

peproc_table label dword
	dd panelevent_LEFT
	dd panelevent_RIGHT
	dd panelevent_UP
	dd panelevent_INS
	dd panelevent_DOWN
	dd panelevent_END
	dd panelevent_HOME
	dd panelevent_PGUP
	dd panelevent_PGDN
	dd panelevent_Enter
	dd panelevent_Enter
	dd panelevent_MOUSEUP
	dd panelevent_MOUSEDN

pekey_count = (($ - offset peproc_table) / 4)

	END
