include dos.inc
include alloc.inc
include string.inc
include stdio.inc
include stdlib.inc
include io.inc
include ini.inc
include iost.inc
include wsub.inc
include clip.inc
include conio.inc
include tinfo.inc
include keyb.inc
include mouse.inc
include ctype.inc
include helpid.inc
ifdef __TE__

ifndef __DZ__
externdef	IDD_TEHelp:dword
endif
externdef	IDD_TEReload:dword
externdef	IDD_TEReload2:dword
externdef	IDD_TESave:dword
externdef	IDD_TEOpenFiles:dword
externdef	IDD_TESeek:dword
externdef	IDD_Replace:dword
externdef	IDD_ReplacePrompt:dword

externdef	cp_noname:byte
externdef	CP_ENOMEM:byte
externdef	format_u:byte
externdef	cp_linetolong:byte

ticurcp		proto
ticurlp		proto
tiseto		proto
tiputs		proto
ticontinue	proto
tihome		proto
tidown		proto
tialignx	proto
tialigny	proto
tinocando	proto
tireadstyle	proto
tihome		proto
tiputc		proto
titoend		proto
tievent		proto
tiprevword	proto
tinextword	proto
tidoiflines	proto
tiretevent	proto

ifdef __DZ__
view_readme	proto _CType
endif

;-----------------------------------------------------------------------------
; Alloc file buffer
;-----------------------------------------------------------------------------

	.data
	emmp	dd 0		; Allocated page
	curh	dw -1		; Current owners handle
	curp	dw -1		; Current page for this handle

	.code

	;--------------------------------------------------------------
	; Validate tinfo (AX)
	; return CX .ti_flag, DL .dl_flag, ES:AX dialog
	;--------------------------------------------------------------

tistate proc _CType public uses bx
	mov	bx,ax
	test	ax,ax
	jz	@F
	sub	ax,ax
	mov	cx,[bx].S_TINFO.ti_flag
	push	ss
	pop	es
	lea	bx,[bx].S_TEDIT.ti_DOBJ
	test	cx,_T_MALLOC
	jz	@F
	test	cx,_T_LINEBUF
	jz	@F
	mov	dl,byte ptr [bx].S_DOBJ.dl_flag
	mov	ax,bx
      @@:
	ret
tistate endp

tialloc proc private uses si di bx
	xor	di,di
	mov	si,ax
	cmp	tepages,EMSMINPAGES
	jb	tialloc_lokal
	call	emmnumfreep
	cmp	ax,EMSMINPAGES
	jb	tialloc_lokal
	cmp	ax,tepages
	jb	@F
	mov	ax,tepages
      @@:
	mov	di,ax
	lodm	emmp
	test	dx,dx		; same page for all files..
	jnz	@F
	mov	ax,0402h
	call	palloc
	jz	tialloc_fail
	inc	dx		; + 16
	xor	ax,ax		; zero offset
	stom	emmp
      @@:
	stom	[si].S_TINFO.ti_bp	; base pointer to page
	or	[si].S_TINFO.ti_flag,_T_MALLOC
	invoke  emmalloc,di
	inc	ax
	jz	tialloc_emmfail
	mov	[si].S_TEDIT.ti_emmh,dx
	mov	[si].S_TEDIT.ti_emmp,0
	or	[si].S_TINFO.ti_flag,_T_EMMBUF
	jmp	tialloc_style
    tialloc_fail?:
	mov	ax,si
	call	tifree
    tialloc_fail:
	invoke  ermsg,0,addr CP_ENOMEM
	sub	ax,ax
	jmp	tialloc_end
    tialloc_emmfail:
	mov	ax,si
	call	tifree
    tialloc_lokal:
	mov	ax,tinfo
	call	tistate
	jnz	tialloc_fail
	mov	ax,4004h
	call	palloc
	jz	tialloc_fail
	inc	dx
	sub	ax,ax
	or	[si].S_TINFO.ti_flag,_T_MALLOC
	stom	[si].S_TINFO.ti_bp
	mov	di,16
    tialloc_style:
	mov	ax,WMAXPATH/16
	call	palloc
	jz	tialloc_fail?
	invoke  strcpy,dx::ax,addr cp_noname
	stom	[si].S_TEDIT.ti_file
	mov	ax,128
	mov	cl,telsize
	shl	ax,cl
	mov	[si].S_TINFO.ti_bcol,ax
	mov	bx,ax
	sub	ax,ax
	cwd
	inc	dx
	div	bx
	shr	di,2
	mul	di
	mov	[si].S_TINFO.ti_brow,ax
	mov	ax,si
	call	timemzero
	inc	ax
    tialloc_end:
	ret
tialloc endp

tifree  proc private uses si
	mov	si,ax
	mov	ax,[si].S_TINFO.ti_flag
	test	ax,_T_MALLOC or _T_EMMBUF
	jz	tifree_end
	test	ax,_T_EMMBUF
	jz	@F
	invoke  emmfree,[si].S_TEDIT.ti_emmh
	mov	ax,-1
	mov	curh,ax		; Force a reread of the page
	mov	curp,ax
	jmp	tifree_name
      @@:
	mov	ax,[si].S_TINFO.ti_flag
	test	ax,_T_MALLOC
	jz	tifree_end
	mov	ax,word ptr [si].S_TINFO.ti_bp[2] ; free seg - 1
	dec	ax
	invoke  free,ax::ax		; free() only use segment..
    tifree_name:
	invoke  free,[si].S_TEDIT.ti_file
	invoke  free,[si].S_TEDIT.ti_style
    tifree_end:
	and	[si].S_TINFO.ti_flag,not (_T_MALLOC or _T_EMMBUF)
	ret
tifree  endp

;-----------------------------------------------------------------------------
; Open
;-----------------------------------------------------------------------------

tigetfile proc _CType public uses bx
	sub ax,ax	; AX first file
	mov dx,ax	; DX last file
	mov bx,tinfo
	.if bx
	    .if [bx].S_TINFO.ti_flag & _T_FILE
		mov dx,bx
		.repeat
		    mov ax,bx
		    mov bx,[bx].S_TEDIT.ti_prev
		    .break .if !bx
		.until bx == dx
		mov bx,dx
		.repeat
		    mov dx,bx
		    mov bx,[bx].S_TEDIT.ti_next
		    .break .if !bx
		.until bx == ax
		inc bx
	    .endif
	.endif
	ret
tigetfile endp

tishow proc _Ctype public uses si bx ti:size_t
	mov si,ti
	.if !([si].S_TEDIT.ti_DOBJ.dl_flag & _D_DOPEN)
	    .if dlscreen(addr [si].S_TEDIT.ti_DOBJ,[si].S_TINFO.ti_clat)
		invoke dlshow,dx::ax
		sub ax,ax
		mov al,[si].S_TEDIT.ti_DOBJ.dl_rect.rc_col
		mov [si].S_TINFO.ti_cols,ax
		mov al,[si].S_TEDIT.ti_DOBJ.dl_rect.rc_row
		mov [si].S_TINFO.ti_rows,ax
		invoke cursorset,addr [si].S_TINFO.ti_cursor
		.if [si].S_TINFO.ti_flag & _T_USEMENUS
		    dec [si].S_TINFO.ti_rows
		    mov dx,word ptr [si].S_TEDIT.ti_DOBJ.dl_rect
		    mov cx,[si].S_TINFO.ti_cols
		    mov bl,dh
		    mov ah,at_background[B_Menus]
		    mov al,' '
		    invoke scputw,dx,bx,cx,ax
		    inc dl
		    sub cx,19
		    invoke scpath,dx,bx,cx,[si].S_TEDIT.ti_file
		.endif
		call tiputs
	    .endif
	.endif
	ret
tishow endp

tihide proc pascal private uses si ti:size_t
	mov si,ti
	invoke dlclose,addr [si].S_TEDIT.ti_DOBJ
	ret
tihide endp

tiopen proc private uses si bx
	.if nalloc(SIZE S_TEDIT)
	    push ax
	    invoke memzero,ss::ax,SIZE S_TEDIT
	    pop si
	    mov al,at_background[B_Desktop]
	    or  al,at_foreground[F_Desktop]
	    mov [si].S_TINFO.ti_clat,al
	    mov [si].S_TEDIT.ti_stat,al
	    mov [si].S_TINFO.ti_cursor.cr_type,CURSOR_NORMAL
	    mov al,' '
	    mov [si].S_TINFO.ti_clch,al
	    mov [si].S_TEDIT.ti_stch,al
	    sub ax,ax
	    mov al,_scrcol	; adapt to current screen
	    mov [si].S_TINFO.ti_cols,ax
	    mov al,_scrrow
	    inc al
	    mov [si].S_TINFO.ti_rows,ax
	    mov ax,si
	    .if tialloc()
		.if tigetfile()
		    mov bx,dx
		    mov [si].S_TEDIT.ti_prev,bx ; Link to last file
		    mov [bx].S_TEDIT.ti_next,si
		.endif
		mov ax,teflag
		or  [si].S_TINFO.ti_flag,ax
		.if [si].S_TINFO.ti_flag & _T_USEMENUS
		    inc [si].S_TINFO.ti_ypos
		    inc byte ptr [si].S_TINFO.ti_cursor.cr_xy[size_l/2]
		    dec [si].S_TINFO.ti_rows
		.endif
		mov  ax,si
		test ax,ax
		jmp  @F
	    .endif
	    invoke nfree,si
	    jmp tiopen_nomem
	.else
	    jmp tiopen_nomem
	.endif
      @@:
	ret
    tiopen_nomem:
	invoke ermsg,0,addr CP_ENOMEM
	xor ax,ax
	jmp @B
tiopen endp

;-----------------------------------------------------------------------------
; Get line from buffer
;-----------------------------------------------------------------------------

tipushh proc private
	mov	ax,curh
	cmp	ax,-1
	je	@F
	cmp	ax,[si].S_TEDIT.ti_emmh
	je	tipushh_end
	invoke  emmwrite,emmp,curh,curp
      @@:
	mov	ax,[si].S_TEDIT.ti_emmh
	mov	curh,ax
	mov	ax,[si].S_TEDIT.ti_emmp
	mov	curp,ax
	invoke  emmread,emmp,curh,curp
    tipushh_end:
	ret
tipushh endp

tigetline proc public	; Get line from <tinfo> - tigetline(AX) --> DX:AX
	mov	dx,tinfo
tigetline endp

timemline proc private  ; Get line from <[dx]> - timemline(AX,DX) --> DX:AX
	push	si
	push	di
	mov	di,ax				; line
	mov	si,dx				; &tinfo
	mov	ax,[si].S_TINFO.ti_flag
	test	ax,_T_LINEBUF
	jz	timemline_nol
	cmp	di,[si].S_TINFO.ti_brow
	jnb	timemline_null
	test	ax,_T_EMMBUF
	mov	ax,[si].S_TINFO.ti_bcol
	jz	timemline_malloc
	mov	ax,[si].S_TEDIT.ti_emmh ; Init current EMM handle
	cmp	curh,ax			; same handle ?
	je	@F
	call	tipushh
      @@:
	mov	ax,[si].S_TINFO.ti_bcol ; size of line
	shl	ax,2				; * 4 (align segment)
	mul	di				; * line (DX to page)
	cmp	dx,[si].S_TEDIT.ti_emmp
	je	timemline_pageok
	push	dx
	push	ax
	push	dx
	invoke  emmwrite,[si].S_TINFO.ti_bp,[si].S_TEDIT.ti_emmh,[si].S_TEDIT.ti_emmp
	pop	ax
	invoke  emmread,[si].S_TINFO.ti_bp,[si].S_TEDIT.ti_emmh,ax
	test	ax,ax
	pop	ax
	pop	dx
	jnz	timemline_null
    timemline_pageok:
	mov	[si].S_TEDIT.ti_emmp,dx ; save page offset
	mov	curp,dx
	shr	ax,6
    timemline_ok:
	add	ax,word ptr [si].S_TINFO.ti_bp+2 ; + segment
	mov	dx,ax
	xor	ax,ax
	cmp	di,[si].S_TEDIT.ti_lcnt
	jnb	timemline_new
	test	dx,dx
	clc				; Carry set if new line
    timemline_end:
	pop	di
	pop	si
	ret
    timemline_null:			; ZF and CF set on error
	xor	ax,ax
	mov	dx,ax
	jmp	timemline_new
    timemline_nol:
	lodm	[si].S_TINFO.ti_bp
    timemline_new:
	test	dx,dx
	stc
	jmp	timemline_end
    timemline_malloc:
	shr	ax,4			; line size in para
	mul	di			; * line offset
	jmp	timemline_ok
timemline endp

timemzero proc private uses si di bx
	mov bx,ax
	mov ax,[bx].S_TINFO.ti_flag
	.if dzemm && ax & _T_EMMBUF
	    mov dx,[bx].S_TEDIT.ti_emmh
	    mov ax,7100h
	    int 67h
	    test ah,ah
	    jz timemzero_end
	.endif
	sub	si,si
	cld
      @@:
	mov	ax,si
	mov	dx,bx
	call	timemline
	jz	timemzero_end
	mov	es,dx
	mov	di,ax
	sub	ax,ax
	mov	cx,[bx].S_TINFO.ti_bcol
	shr	cx,1
	rep	stosw
	inc	si
	jmp	@B
    timemzero_end:
	ret
timemzero endp

ticlose proc private uses si di bx
	mov si,ax
	sub di,di
	.if [si].S_TINFO.ti_flag & _T_MALLOC or _T_EMMBUF
	    call tifree
	    invoke dlclose,addr [si].S_TEDIT.ti_DOBJ
	.endif
	.if tigetfile()
	    mov di,[si].S_TEDIT.ti_prev
	    mov bx,[si].S_TEDIT.ti_next
	    mov [si].S_TEDIT.ti_prev,0
	    mov [si].S_TEDIT.ti_next,0
	    .if bx && [bx].S_TEDIT.ti_prev == si
		mov [bx].S_TEDIT.ti_prev,di
	    .endif
	    .if di && [di].S_TEDIT.ti_next == si
		mov [di].S_TEDIT.ti_next,bx
	    .else
		mov di,bx
	    .endif
	.endif
	mov tinfo,di
	invoke nfree,si
	sub ax,ax
	ret
ticlose endp

tisavechanges proc pascal private uses di
local DLG_TESave:dword
	.if rsopen(IDD_TESave)
	    stom   DLG_TESave
	    invoke dlshow,dx::ax
	    les	  di,DLG_TESave
	    sub	   cx,cx
	    mov	   cl,es:[di][6]
	    sub	   cl,10
	    mov	   ax,es:[di][4]
	    add	   ax,0205h
	    mov	   dl,ah
	    mov	   di,tinfo
	    invoke scpath,ax,dx,cx,[di].S_TEDIT.ti_file
	    invoke rsevent,IDD_TESave,DLG_TESave
	    invoke dlclose,DLG_TESave
	    mov	   ax,dx
	.endif
	ret
tisavechanges endp

;-----------------------------------------------------------------------------
;
;-----------------------------------------------------------------------------

	.data
	cp_linefeed db 0Dh,0Ah,0
	.code

tiofread proc public uses si dx
	mov	ax,STDI.ios_l	; current line
	cmp	STDI.ios_c,0	; first line ?
	je	@F
	inc	STDI.ios_l	; get next line
	inc	ax
      @@:
	call	tigetline
	jc	tiofread_eof
	invoke  strcpy,STDI.ios_bp,dx::ax
	invoke  strcat,dx::ax,addr cp_linefeed
	mov	si,ax
	mov	ah,' '
	cld
      @@:
	lodsb
	test	al,al
	jz	@F
	cmp	al,TITABCHAR
	jne	@B
	mov	[si-1],ah
	jmp	@B
      @@:
	invoke  strlen,STDI.ios_bp
	mov	STDI.ios_c,ax
	sub	ax,ax
	mov	STDI.ios_i,ax
	inc	ax
    tiofread_end:
	ret
    tiofread_eof:
	sub	ax,ax
	jmp	tiofread_end
tiofread endp

tiseekst proc public	; cx dx:ax | ecx eax
      @@:
	push	ax			; ax: offset
	mov	[si].S_IOST.ios_l,dx	; dx: line
	mov	[si].S_IOST.ios_c,0
	call	tiofread
	pop	ax
	jz	tiseekst_fail
	cmp	[si].S_IOST.ios_c,ax
	ja	tiseekst_end
	inc	cx
	sub	ax,ax
	jmp	@B
    tiseekst_end:
	mov	[si].S_IOST.ios_i,ax
	inc	ax
	ret
    tiseekst_fail:
	sub	ax,ax
	ret
tiseekst endp

	;----------------------------------------------------
	; This is used by all search funtions
	; lines is copyed to _bufin and converted
	;
	; .ios_l - current line
	; .ios_i - current offset
	; .ios_c - strlen line
	; ?
	; .ios_bb (low word) -- offset
	; .ios_bb (high word) - line
	;----------------------------------------------------

titostdi proc private uses bx
	invoke  oinitst,addr STDI,0
	mov	al,fsflag
	and	al,IO_SEARCHMASK
	or	ax,IO_LINEBUF
	mov	STDI.ios_flag,ax
	call	ticurcp
	mov	es,dx
	mov	bx,ax		; cursor may be set above actual line size
	cmp	byte ptr es:[bx],0
	jne	@F
	call	titoend
      @@:
	mov	bx,tinfo
	mov	ax,[bx].S_TINFO.ti_boff
	add	ax,[bx].S_TINFO.ti_xoff
	mov	word ptr STDI.ios_bb,ax
	mov	ax,[bx].S_TINFO.ti_loff
	add	ax,[bx].S_TINFO.ti_yoff
	mov	STDI.ios_l,ax
	mov	word ptr STDI.ios_bb+2,ax
	call	tiofread
	mov	ax,word ptr STDI.ios_bb
	mov	STDI.ios_i,ax
	ret
titostdi endp

;-----------------------------------------------------------------------------
;
;-----------------------------------------------------------------------------

	.data
	cp_filetolong	db 'File too big, no more memory',0
	tab_c1 db ?
	tab_c2 db ?
	usetab db ?

	.code

tilineerror:
	push	dx
	call	oungetc
	test	[si].S_TINFO.ti_flag,_T_MODIFIED
	jnz	@F
	or	[si].S_TINFO.ti_flag,_T_MODIFIED
	invoke  ermsg,0,addr cp_linetolong
      @@:
	pop	dx
	ret

tireaderror:
	invoke  ermsg,0,addr cp_filetolong
	ret

tiiost:
	push	ax
	invoke  memzero,ss::bx,SIZE S_IOST
	pop	ax
	mov	[bx].S_IOST.ios_file,ax
	mov	[bx].S_IOST.ios_size,2048
	mov	word ptr [bx].S_IOST.ios_bp,offset _bufin + 2048
	mov	word ptr [bx].S_IOST.ios_bp[2],ds
	ret

tiread  proc private
	push	si	; AX tinfo
	push	di
	push	bx
	push	bp
	mov	si,ax
	; v2.49 -- auto detect CR/LF
	and	[si].S_TINFO.ti_flag,7FFFh ; not _T_USECRLF
	mov	tab_c1,' '	; v2.39 - include Use Tabs and Tab Size
	mov	tab_c2,' '
	mov	usetab,0
	test	[si].S_TINFO.ti_flag,_T_USETABS
	jz	@F
	mov	tab_c1,9
	mov	tab_c2,TITABCHAR
	mov	usetab,1
      @@:
	call	tiftime
	stom	[si].S_TEDIT.ti_time
	invoke  openfile,[si].S_TEDIT.ti_file,M_RDONLY,A_OPEN
	inc	ax
	mov	bp,ax
	jz	tiread_end
	dec	ax
	mov	bx,offset STDI
	call	tiiost
	invoke  lseek,STDI.ios_file,0,SEEK_END
	stom	[si].S_TEDIT.ti_size
	invoke  lseek,STDI.ios_file,0,SEEK_SET
	xor	ax,ax
	mov	bp,ax
	call	tigetline
	jz	tiread_error
	mov	di,bp
    tiread_read:
	call	ogetc
	mov	es,dx
	jz	tiread_eof
	test	al,al
	jz	tiread_line	; binary file
	cmp	al,0Dh
	je	tiread_0Dh
	cmp	al,0Ah
	je	tiread_line
	cmp	al,09h
	je	tiread_tab
	cmp	di,[si].S_TINFO.ti_bcol
	je	tiread_maxlen
	stosb
	jmp	tiread_read
    tiread_0Dh:
	or	[si].S_TINFO.ti_flag,8000h ; _T_USECRLF
	jmp	tiread_read
    tiread_tab:
	cmp	usetab,0
	jne	tiread_do
	inc	usetab
	or	[si].S_TINFO.ti_flag,_T_MODIFIED
    tiread_do:
	mov	al,tab_c1
	stosb
	mov	al,tab_c2
	mov	cl,tetabsize
	dec	cl
	and	cx,TIMAXTABSIZE-1
    tiread_tloop:
	test	di,cx
	jz	tiread_read
	cmp	di,[si].S_TINFO.ti_bcol
	je	tiread_maxlen
	stosb
	jmp	tiread_tloop
    tiread_maxlen:			; line to big..
	mov	es:[di-1],ah
	call	tilineerror
    tiread_line:
	inc	bp
	mov	ax,bp
	call	tigetline
	jz	tiread_tobig
	xor	di,di
	jmp	tiread_read
    tiread_tobig:
	call	tireaderror		; file to big..
    tiread_error:
	mov	bp,-1
    tiread_eof:
	invoke  close,STDI.ios_file
	inc	bp
	mov	[si].S_TEDIT.ti_lcnt,bp
    tiread_end:
	test	bp,bp
	jz	@F
	mov	ax,[si].S_TINFO.ti_flag
	and	[si].S_TINFO.ti_flag,not (_T_USECRLF or 8000h)
	test	ax,8000h
	jz	@F
	or	[si].S_TINFO.ti_flag,_T_USECRLF
     @@:
	mov	ax,bp
	test	ax,ax
	pop	bp
	pop	bx
	pop	di
	pop	si
	ret
tiread  endp

topen proc _CType public uses si file:dword
	xor ax,ax
	.if tiopen()
	    mov si,ax
	    or [si].S_TINFO.ti_flag,_T_FILE
	    mov tinfo,ax
	    lodm file
	    .if ax
		invoke wlongpath,0,dx::ax
	    .else
		mov dx,ds
		mov ax,offset cp_noname
		inc [si].S_TEDIT.ti_lcnt ; set line count to 1
	    .endif
	    invoke strcpy,[si].S_TEDIT.ti_file,dx::ax
	    .if ax != offset cp_noname
		.if !tireadstyle()
		    invoke ermsg,0,addr CP_ENOMEM
		    jmp @F
		.endif
		mov ax,si
		call tiread
		.if ZERO?
		  @@:
		    mov ax,si
		    call ticlose
		    sub si,si
		.endif
	    .endif
	    mov ax,si
	.endif
	test ax,ax
	ret
topen endp

tclose proc _CType private uses bx
	mov ax,tinfo
	.if tistate()
	    mov bx,tinfo
	    .if [bx].S_TINFO.ti_flag & _T_MODIFIED
		.if tisavechanges()
		    mov ax,tinfo
		    call tiflush
		.endif
	    .endif
	    mov ax,tinfo
	    call ticlose
	    mov ax,tinfo
	.endif
	test ax,ax
	ret
tclose endp

tcloseall proc _CType public
	call	tclose
	jnz	tcloseall
	ret
tcloseall endp

;-----------------------------------------------------------------------------
; Open files
;-----------------------------------------------------------------------------

	.data

DLG_OpenFiles	dd ?
FCB_OpenFiles	dw ?
MAXDLGOBJECT	equ 16
MAXOBJECTLEN	equ 38

	.code

event_xcell:
	push	bx
	les	bx,DLG_OpenFiles
	xor	ax,ax
	mov	al,es:[bx].S_DOBJ.dl_index
	mov	bx,FCB_OpenFiles
	mov	[bx].S_LOBJ.ll_celoff,ax
	call	dlxcellevent
	pop	bx
	retx

event_list:
	push bp
	push si
	push di
	push bx
	invoke dlinit,DLG_OpenFiles
	les bx,DLG_OpenFiles
	add bx,SIZE S_TOBJ
	mov cx,MAXDLGOBJECT
	.repeat
	    or es:[bx].S_TOBJ.to_flag,_O_STATE
	    add bx,SIZE S_TOBJ
	.untilcxz
	mov bx,word ptr DLG_OpenFiles
	sub ax,ax
	mov al,es:[bx][4]
	add al,3
	mov si,ax		; x-pos
	mov al,es:[bx][5]
	add ax,1
	mov di,ax		; y
	xor bp,bp		; loop
	mov dx,es
	mov cx,bx
	.repeat
	    mov ax,bp
	    mov bx,FCB_OpenFiles
	    .break .if ax >= [bx].S_LOBJ.ll_numcel
	    add ax,[bx].S_LOBJ.ll_index
	    add ax,ax
	    les bx,[bx].S_LOBJ.ll_list
	    add bx,ax
	    mov bx,es:[bx]
	    .if [bx].S_TINFO.ti_flag & _T_MODIFIED
		mov ax,si
		dec ax
		invoke scputc,ax,di,1,'*'
	    .endif
	    invoke scpath,si,di,MAXOBJECTLEN,[bx].S_TEDIT.ti_file
	    add cx,SIZE S_TOBJ
	    mov es,dx
	    mov bx,cx
	    and es:[bx].S_TOBJ.to_flag,not _O_STATE
	    inc di
	    inc bp
	.until 0
	mov ax,1
	pop bx
	pop di
	pop si
	pop bp
	retx

tdlgopen proc _CType public uses si di bx
local ll:S_LOBJ
local ti[TIMAXFILES]:word
	lea	ax,ll
	mov	FCB_OpenFiles,ax
	invoke  memzero,ss::ax,SIZE S_LOBJ
	lea	ax,ti
	mov	word ptr ll.ll_list,ax
	mov	word ptr ll.ll_list+2,ss
	invoke  memzero,ss::ax,TIMAXFILES*2
	mov	ll.ll_dcount,MAXDLGOBJECT	; number of cells (max)
	movp	ll.ll_proc,event_list
	.if tigetfile()
	    mov si,ax
	    sub bx,bx
	    mov di,word ptr ll.ll_list
	    .repeat
		mov ax,si
		.break .if !tistate()
		mov [di],si
		add di,2
		mov si,[si].S_TEDIT.ti_next
		inc bx
	    .until bx == TIMAXFILES
	    mov ll.ll_count,bx
	    mov ax,bx
	    .if ax >= MAXDLGOBJECT
		mov ax,MAXDLGOBJECT
	    .endif
	    mov ll.ll_numcel,ax
	    .if rsopen(IDD_TEOpenFiles)
		stom DLG_OpenFiles
		mov  di,ax
		mov  cx,MAXDLGOBJECT
		mov  ax,offset event_xcell
		movl dx,cs
		.repeat
		    add  di,SIZE S_TOBJ
		    stom es:[di].S_TOBJ.to_proc
		.untilcxz
		invoke dlshow,DLG_OpenFiles
		pushl  cs
		call   event_list
		invoke dllevent,DLG_OpenFiles,addr ll
		les   bx,DLG_OpenFiles
		mov    dx,es:[bx][4]
		les   bx,IDD_TEOpenFiles
		mov    es:[bx][6],dx
		invoke dlclose,DLG_OpenFiles
		mov ax,dx
		.if ax
		    sub ax,ax
		    mov bx,FCB_OpenFiles
		    .if [bx].S_LOBJ.ll_count
			mov ax,[bx].S_LOBJ.ll_index
			add ax,[bx].S_LOBJ.ll_celoff
			add ax,ax
			lea bx,ti
			add bx,ax
			mov ax,[bx]
		    .endif
		.endif
	    .endif
	.endif
	test ax,ax
	ret
tdlgopen endp

titogglemenus proc private
	mov ax,tinfo
	.if tistate()
	    push si
	    mov si,tinfo
	    invoke tihide,si
	    mov dx,word ptr [si].S_TEDIT.ti_DOBJ[4]
	    mov cx,word ptr [si].S_TEDIT.ti_DOBJ[6]
	    mov ax,[si].S_TINFO.ti_flag
	    xor ax,_T_USEMENUS
	    mov [si].S_TINFO.ti_flag,ax
	    and ax,_T_USEMENUS
	    .if !ZERO?
		mov al,dh
		inc al
		mov [si].S_TINFO.ti_ypos,ax
		mov al,ch
		dec al
		mov [si].S_TINFO.ti_rows,ax
	    .else
		mov al,dh
		mov [si].S_TINFO.ti_ypos,ax
		mov al,ch
		mov [si].S_TINFO.ti_rows,ax
	    .endif
	    invoke tishow,si
	    pop si
	.endif
	jmp ticontinue
titogglemenus endp

	.data
	cp_extbak db '.bak',0
	cp_exttmp db '.$$$',0

	.code

tistrip proc public uses si di ax cx
	push	ds
	mov	cl,tetabsize
	dec	cl
	and	cx,TIMAXTABSIZE-1
	mov	es,dx
	mov	ds,dx
	mov	si,ax
	mov	di,ax
	cld
	mov	ah,cl
	inc	ah
      @@:
	lodsb
	dec	ah
	jz	@F
	cmp	al,TITABCHAR
	je	@B
      @@:
	dec	si
    tistrip_lod:
	lodsb
	test	al,al
	jz	tistrip_eof
	cmp	al,9
	je	tistrip_09h
    tistrip_sto:
	stosb
	jmp	tistrip_lod
    tistrip_09h:
	stosb
	test	si,cx
	jz	tistrip_lod
	mov	ah,cl
	inc	ah
      @@:
	lodsb
	test	al,al
	jz	tistrip_eof
	cmp	al,9
	je	tistrip_09h
	cmp	al,TITABCHAR
	jne	tistrip_sto
	dec	ah
	jz	tistrip_sto
	jmp	@B
    tistrip_eof:
	stosb
    tistrip_end:
	pop	ds
	ret
tistrip endp

; strip space, BH and BL from end of line (DX:AX)
; uses CX, tinfo.ti_bcnt
; return CX strlen(line)

tistripl proc public uses si di bx bp
	mov	bp,tinfo
	push	es
	mov	si,ax
	invoke  strlen,dx::ax
	mov	di,si
	add	di,ax
	mov	cx,ax
	mov	ax,[bp].S_TINFO.ti_flag
	test	ax,_T_LINEBUF
	jz	tistripl_end
	and	ax,_T_USECONTROL
	jnz	tistripl_end
    tistripl_len:
	dec	di
	cmp	di,si
	jl	tistripl_end
	mov	al,es:[di]
	cmp	al,bl
	je	@F
	cmp	al,bh
	je	@F
	cmp	al,' '
	jne	tistripl_end
      @@:
	mov	es:[di],ah
	dec	cx
	jnz	tistripl_len
    tistripl_end:
	test	cx,cx
	mov	[bp].S_TINFO.ti_bcnt,cx
	mov	ax,si
	pop	es
	ret
tistripl endp

tistripline proc public uses bx
	call	ticurlp
	mov	bl,9
	mov	bh,TITABCHAR
	call	tistripl
	ret
tistripline endp

size_of_line	equ [bp-size_l]

; xchange line [AX] <--> [BP]
; size of line: [BP-2]
; uses DI
;
; while (getline(AX++))
;     xchange(AX, BP);
;
; return AX + 1 or -1

tixchgl proc private uses si
    tixchgl_get:
	push	ax
	call	tigetline
	mov	cx,size_of_line
	mov	es,dx
	mov	di,ax
	mov	si,bp
	jc	tixchgl_eof
      @@:
	mov	al,es:[di]
	movsb
	mov	[si-1],al
	dec	cx
	jnz	@B
	pop	ax
	inc	ax
	jmp	tixchgl_get
    tixchgl_eof:
	jz	tixchgl_end
      @@:
	mov	al,es:[di]
	movsb
	mov	[si-1],al
	dec	cx
	jnz	@B
	inc	cx
    tixchgl_end:
	pop	ax
	ret
tixchgl endp

; Insert a line below line[AX]

tinsline proc private uses si di bp
	mov	si,tinfo
	mov	bx,ax		; BX to line index
	mov	ax,[si].S_TINFO.ti_bcol
	sub	sp,ax		; create a line buffer on the stack
	mov	bp,sp		; buffer to BP
	push	ax
	invoke  memzero,ss::bp,ax
	mov	ax,[si].S_TEDIT.ti_lcnt ; room for one more line ?
	cmp	ax,[si].S_TINFO.ti_brow
	jae	tinsline_eof
	mov	ax,bx		; insert the blank line
	inc	ax
	call	tixchgl		; return index to last line
	cmp	ax,[si].S_TEDIT.ti_lcnt
	jne	tinsline_eof
	inc	[si].S_TEDIT.ti_lcnt
    tinsline_end:
	add	sp,[bp-size_l]; free buffer
	pop	cx		; line size
	test	ax,ax		; line count
	ret
    tinsline_eof:
	xor	ax,ax
	jmp	tinsline_end
	ret
tinsline endp

simove:				; move string to &string[1]
	lodsb
	cmp	si,cx		; CX max offset
	jae	simove_eof
	mov	[si-1],ah
	mov	ah,al
	test	al,al
	jnz	simove
	test	cx,cx
    simove_end:
	mov	[si],al ; terminate string
	ret
    simove_eof:
	xor	ax,ax
	jmp	simove_end

tiexpand proc public uses si di bp bx ax
	push	ds
	mov	bl,tetabsize
	mov	bp,tinfo
	test	[bp].S_TINFO.ti_flag,_T_USETABS
	jz	tiexpand_ret
	mov	es,dx
	mov	ds,dx
	dec	bl
	and	bx,TIMAXTABSIZE-1
	mov	si,ax
	mov	di,ax
	cld
	mov	cx,[bp].S_TINFO.ti_bcol
	dec	cx
    tiexpand_next:
	lodsb
	test	al,al
	jz	tiexpand_eos
	cmp	al,9
	je	tiexpand_09h
	cmp	di,cx
	je	tiexpand_end
	stosb
	jmp	tiexpand_next
    tiexpand_end:
	mov	al,0
	stosb
    tiexpand_ret:
	pop	ds
	ret
    tiexpand_eos:
	test	cx,cx
	jmp	tiexpand_end
    tiexpand_09h:		; insert TAB char
	stosb
	cmp	di,cx
	jae	tiexpand_end
      @@:			; insert "spaces" to next Tab offset
	mov	ah,TITABCHAR
	test	si,bx
	jz	tiexpand_next
	push	si
	call	simove
	pop	si
	jz	tiexpand_ret
	inc	si
	mov	di,si
	jmp	@B
tiexpand endp

tienterni proc public uses si di bp bx
	mov	si,tinfo
	mov	bx,[si].S_TINFO.ti_brow
	mov	ax,[si].S_TINFO.ti_loff
	add	ax,[si].S_TINFO.ti_yoff
	mov	di,ax
	inc	ax
	cmp	ax,bx
	mov	ax,_TI_RETEVENT
	jb	tienterni_do
	dec	bx
	jz	tienterni_end
    tienterni_nocando:
	call	tinocando
	jmp	tienterni_end
    tienterni_CONTINUE:
	mov	ax,_TI_CONTINUE
    tienterni_end:
	ret
    tienterni_do:
	mov	ax,di
	call	tinsline
	jz	tienterni_nocando
	mov	cx,[si].S_TINFO.ti_bcol
	or	[si].S_TINFO.ti_flag,_T_MODIFIED
	sub	sp,cx
	mov	bp,sp
	call	ticurcp
	push	dx
	push	ax
	invoke  strcpy,ss::bp,dx::ax
	pop	bx
	pop	es
	sub	ax,ax
	mov	es:[bx],al
	call	ticurlp
	mov	bx,ax
	sub	cx,cx
	mov	[si].S_TINFO.ti_boff,cx
	mov	[si].S_TINFO.ti_xoff,cx
     @@:
	mov	al,es:[bx]
	inc	cx
	inc	bx
	call	isspace
	jnz	@B
	mov	bl,al		; add indent if last char is zero
	mov	bh,0
	mov	ax,di
	inc	ax
	call	tigetline
	jz	tienterni_home
	mov	di,ax
	dec	cx
	jz	tienterni_home
	test	bl,bl
	jnz	tienterni_home
	mov	al,' '
	mov	es,dx
	mov	bx,cx
;	mov	[si].S_TINFO.ti_boff,0
	mov	[si].S_TINFO.ti_xoff,cx
	rep	stosb
    tienterni_push:
	mov	al,TITABCHAR
     @@:
	cmp	[bp],al
	jne	tienterni_cpy
	inc	bp
	jmp	@B
    tienterni_home:
	sub	bx,bx
	jmp	tienterni_push
    tienterni_cpy:
	invoke  strcpy,dx::di,ss::bp
	test	[si].S_TINFO.ti_flag,_T_USETABS
	jz	tienterni_done
	call	tistrip
	call	tiexpand
    tienterni_done:
	add	sp,[si].S_TINFO.ti_bcol
	call	tidown
	jmp	tienterni_end
if 0
	test	bx,bx
	jz	@F
	call	tidown
	call	tiprevword
	call	tinextword
	jmp	tienterni_end
      @@:
	call	tihome
	call	tidown
	jmp	tienterni_end
endif
tienterni endp

tienter_putc:
	mov	ax,[si].S_TINFO.ti_xoff
	add	ax,[si].S_TINFO.ti_boff
	push	ax
	mov	al,dl
	call	tiputc
	cmp	ax,_TI_CONTINUE
	pop	dx
	mov	ax,0
	jne	@F
	mov	ax,[si].S_TINFO.ti_xoff
	add	ax,[si].S_TINFO.ti_boff
	sub	ax,dx
      @@:
	test	ax,ax
	ret

tigetindent proc public
	push	si
	push	di
	mov	si,tinfo
	call	tigetline
	jz	tigetindent_end
	mov	es,dx
	mov	di,ax
	add	ax,[si].S_TINFO.ti_bcol
	mov	dx,ax
	xor	cx,cx
      @@:
	mov	al,es:[di]
	call	isspace
	jz	@F
	inc	cx
	inc	di
	cmp	di,dx
	jb	@B
      @@:
	mov	ax,cx
    tigetindent_end:
	pop	di
	pop	si
	ret
tigetindent endp

tienter proc public
	call	tidoiflines
	push	si
	push	di
	mov	si,tinfo
	call	tienterni
	cmp	ax,_TI_CONTINUE
	je	@F
	cmp	ax,_TI_RETEVENT
	je	tienter_ret
	jmp	tienter_end
     @@:
	mov	ax,[si].S_TINFO.ti_flag
	and	ax,_T_USEINDENT
	jz	tienter_end
	mov	ax,[si].S_TINFO.ti_loff
	add	ax,[si].S_TINFO.ti_yoff
	dec	ax
	call	tigetindent
if 0
	mov	dx,[si].S_TINFO.ti_xoff
	add	dx,[si].S_TINFO.ti_boff
	cmp	ax,dx
	jb	@F
	mov	ax,dx
     @@:
endif
	test	ax,ax
	jz	tienter_end
	mov	di,ax
	test	[si].S_TINFO.ti_flag,_T_OPTIMALFILL
	jz	tienter_space
     @@:
	cmp	di,8
	jb	tienter_space
	mov	dl,9
	call	tienter_putc
	jz	tienter_end
	cmp	di,ax
	jbe	tienter_end
	sub	di,ax
	jmp	@B
    tienter_space:
	mov	dl,' '
	call	tienter_putc
	jz	tienter_end
	dec	di
	jnz	tienter_space
    tienter_end:
	pop	di
	pop	si
	jmp	ticontinue
    tienter_ret:
	pop	di
	pop	si
	jmp	tiretevent
tienter endp

tioptimalfill proc private uses si bx cx
	mov	bl,9
	mov	bh,TITABCHAR
	call	tistripl
	mov	si,tinfo
	test	[si].S_TINFO.ti_flag,_T_LINEBUF
	jz	optimalfill_end
	test	[si].S_TINFO.ti_flag,_T_OPTIMALFILL
	jz	optimalfill_end
	test	[si].S_TINFO.ti_flag,_T_USETABS
	jz	optimalfill_end
	cmp	tetabsize,8
	jne	optimalfill_end
	cmp	cx,8
	jb	optimalfill_end
	push	ds
	push	ax
	mov	si,ax
	mov	ds,dx
	mov	es,dx
	mov	ah,0
    optimalfill_load:
	mov	bx,si
	lodsb
	cmp	al,39
	je	optimalfill_quote
	cmp	al,'"'
	je	optimalfill_quote
	cmp	al,' '
	jne	optimalfill_test
	test	ah,ah
	jnz	optimalfill_load
;	test	bx,7
;	jnz	optimalfill_load
      @@:
	lodsb
	cmp	al,' '
	je	@B
	mov	cx,si
	sub	cx,bx
	mov	si,bx
	lodsb
	cmp	cx,9
	jb	optimalfill_test
	xchg	bx,di
	mov	al,9
	stosb
	mov	al,TITABCHAR
	mov	cx,7
	rep	stosb
	mov	si,di
	mov	di,bx
	dec	si
    optimalfill_skip:
	lodsb
    optimalfill_test:
	test	al,al
	jnz	optimalfill_load
	pop	ax
	pop	ds
    optimalfill_end:
	ret
    optimalfill_quote:
	.if !ah
	    mov ah,al
	    jmp optimalfill_load
	.endif
	.if al == ah
	    mov ah,0
	.endif
	jmp optimalfill_load
tioptimalfill endp

tiflushl proc public uses si di bp
	;
	; Produce output to clipboard or file
	;
	; args: AX start line	?, 0
	;	DX start offset ?, 0
	;	CX end line	?, line count - 1 ?
	;	BX end offset	?, -1
	;
	mov	si,tinfo
	mov	bp,ax
	mov	di,dx
	call	tigetline
	jnz	@F
	jmp	tiflushl_eoi
     @@:
	jnc	@F		; CF set if string buffer
	test	[si].S_TINFO.ti_flag,_T_LINEBUF
	jnz	tiflushl_eoi	; else CF is EOF
     @@:
	call	tioptimalfill
	add	di,ax
	add	bx,ax
    tiflushl_loop:
	mov	es,dx
	inc	di
	mov	ax,[si].S_TINFO.ti_bcol
	cmp	bp,cx
	jne	@F
	mov	ax,bx
     @@:
	cmp	di,ax
	ja	tiflushl_eob
	mov	al,es:[di-1]
	or	al,al
	jz	tiflushl_eol
	cmp	al,9
	je	tiflushl_tab
    tiflushl_put:
	assert  al,0,jne,"tiflushl: al=0"
	call	oputc
	jnz	tiflushl_loop	; out of space..
    tiflushl_eof:
	xor	ax,ax
	stc
	jmp	tiflushl_end
    tiflushl_tab:
	mov	ah,TIMAXTABSIZE-1
     @@:
	mov	al,es:[di]
	cmp	al,TITABCHAR
	jne	tiflushl_putt
	inc	di
	dec	ah
	jnz	@B
    tiflushl_putt:
	mov	al,9
	jmp	tiflushl_put
    tiflushl_eob:		; end of selection buffer
	cmp	bp,cx		; break if last line
	je	tiflushl_eok
    tiflushl_eol:		; end of line
	inc	bp
	cmp	bp,cx
	ja	tiflushl_last	; break if last line (BP==CX)
	mov	ax,bp
	call	tigetline
	jbe	tiflushl_eoi	; break if last line (EOF)
	call	tioptimalfill
	mov	di,ax
	test	[si].S_TINFO.ti_flag,_T_USECRLF
	jz	@F		; insert line: 0D0A or 0A
	mov	al,0Dh
	call	oputc
     @@:
	mov	al,0Ah
	call	oputc
	jz	tiflushl_eof
	mov	ax,di
	jmp	tiflushl_loop
    tiflushl_eoi:		; end of input (CF)
	xor	ax,ax
	inc	ax
	stc
	jmp	tiflushl_end
    tiflushl_last:
	dec	bp
    tiflushl_eok:
	xor	ax,ax
	inc	ax
	clc
    tiflushl_end:		; out:  AX result
	mov	bx,di		;	DX line index
	mov	dx,bp		;	BX line offset
	ret
tiflushl endp

tisave  proc private
	mov  bx,ax
	test [bx].S_TINFO.ti_flag,_T_FILE
	jnz  tiflush
	jmp  ticontinue
tisave endp

tiflush proc private uses si di
local path[WMAXPATH]:byte
	mov si,ax
	lea di,path
	invoke strcpy,ss::di,[si].S_TEDIT.ti_file
	invoke setfext,ss::di,addr cp_exttmp
	.if oopen(dx::ax,M_WRONLY)
	    xor ax,ax
	    mov dx,ax
	    mov cx,[si].S_TEDIT.ti_lcnt
	    dec cx
	    mov bx,ax
	    dec bx
	    .if !tiflushl()
		invoke oclose,addr STDO
		invoke remove,ss::di
		xor di,di
	    .else
		call oflush
		invoke oclose,addr STDO
		.if [si].S_TINFO.ti_flag & _T_USEBAKFILE
		    invoke setfext,ss::di,addr cp_extbak
		    invoke remove,ss::di
		    invoke rename,[si].S_TEDIT.ti_file,ss::di
		    invoke setfext,ss::di,addr cp_exttmp
		.endif
		invoke remove,[si].S_TEDIT.ti_file
		invoke rename,ss::di,[si].S_TEDIT.ti_file
		inc ax
		mov di,ax
		and [si].S_TINFO.ti_flag,not _T_MODIFIED
		mov ax,si
		call tiftime
		stom [si].S_TEDIT.ti_time
	    .endif
	.endif
	mov  ax,di
	test ax,ax
	ret
tiflush endp

tilseek proc private uses bx
local DLG_TESeek:dword
	.if rsopen(IDD_TESeek)
	    stom DLG_TESeek
	    mov bx,tinfo
	    mov cx,[bx].S_TINFO.ti_loff
	    add cx,[bx].S_TINFO.ti_yoff
	    mov bx,ax
	    invoke sprintf,es:[bx][24],addr format_u,cx
	    invoke dlinit,DLG_TESeek
	    .if rsevent(IDD_TESeek,DLG_TESeek)
		les bx,DLG_TESeek
		invoke strtol,es:[bx][24]
		call tialigny
	    .endif
	    invoke dlclose,DLG_TESeek
	    call tiputs
	.endif
	sub ax,ax
	ret
tilseek endp

	.data
	;
	; These are characters used as valid identifiers (Alt-S)
	;
	idchars db '0123456789_?@abcdefghijklmnopqrstuvwxyz',0

	.code

tisearchfound proc private
	push	bx
	mov	ax,STDI.ios_l
	call	tialigny
	invoke  strlen,addr searchstring
	mov	dx,STDI.ios_i
	sub	dx,ax
	push	ax
	mov	ax,dx
	dec	ax
	call	tialignx
	call	ticurcp ; v2.38 - line may be short by 1
	pop	cx	; - the real reason is currently unknown..
	push	cx
	invoke  strnicmp,dx::ax,addr searchstring,cx
	jz	@F
	mov	bx,tinfo
	inc	[bx].S_TINFO.ti_loff
      @@:
	call	ticlipset
	pop	ax
	push	ax
	mov	bx,tinfo
	add	[bx].S_TINFO.ti_cleo,ax
	call	tiputs
	call	ticlipset
	pop	cx
	pop	bx
	jmp	ticontinue
tisearchfound endp

tisearch proc private
	call	titostdi
	call	ogetc
	invoke  cmdsearch,00010000h
	push	ax
	and	fsflag,not IO_SEARCHMASK
	mov	ax,STDI.ios_flag
	and	al,IO_SEARCHMASK
	or	fsflag,al
	pop	ax
	test	ax,ax
	jnz	tisearchfound
	jmp	ticontinue
tisearch endp

ticontinuesearch proc private
	call	titostdi
	and	STDI.ios_flag,not (IO_SEARCHSET or IO_SEARCHCUR)
	call	continuesearch
	test	ax,ax
	jnz	tisearchfound
	inc	ax
	ret
ticontinuesearch endp

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

ID_YES  equ	1
ID_ALL  equ	2
ID_NO	equ	3

iddreplaceprompt proc private
	mov ax,1
	mov bx,tinfo
	.if [bx].S_TINFO.ti_flag & _T_PROMPTONREP
	    .if rsmodal(IDD_ReplacePrompt)
		mov dx,ax
		.if ax
		    dec dx
		.endif
		mov bx,word ptr IDD_ReplacePrompt
		mov [bx].S_ROBJ.rs_index,dl
		mov bx,tinfo
		.if ax == ID_ALL
		    xor [bx].S_TINFO.ti_flag,_T_PROMPTONREP
		.endif
	    .endif
	.endif
	test ax,ax
	ret
iddreplaceprompt endp

ID_OLDSTRING	equ 1*16
ID_NEWSTRING	equ 2*16
ID_USECASE	equ 3*16
ID_PROMPT	equ 4*16
ID_CURSOR	equ 5*16
ID_GLOBAL	equ 6*16
ID_OK		equ 7
ID_CHANGEALL	equ 8

iddreplace proc pascal private uses bx sflag:size_t
local	DLG_Replace:dword
	.if rsopen(IDD_Replace)
	    stom DLG_Replace
	    mov es:[bx].S_TOBJ.to_count[ID_OLDSTRING],128 shr 4
	    mov es:[bx].S_TOBJ.to_count[ID_NEWSTRING],128 shr 4
	    mov dx,ds
	    mov ax,offset searchstring
	    stom es:[bx].S_TOBJ.to_data[ID_OLDSTRING]
	    mov  ax,offset replacestring
	    stom es:[bx].S_TOBJ.to_data[ID_NEWSTRING]
	    mov ax,sflag
	    mov dl,_O_FLAGB
	    .if ax & IO_SEARCHCASE
		or es:[bx][ID_USECASE],dl
	    .endif
	    .if ax & _T_PROMPTONREP
		or es:[bx][ID_PROMPT],dl
	    .endif
	    mov dl,_O_RADIO
	    .if ax & IO_SEARCHCUR
		or es:[bx][ID_CURSOR],dl
	    .else
		or es:[bx][ID_GLOBAL],dl
	    .endif
	    invoke dlinit,DLG_Replace
	    .if rsevent(IDD_Replace,DLG_Replace)
		mov ax,sflag
		and ax,not (IO_SEARCHMASK or _T_PROMPTONREP)
		mov dl,_O_FLAGB
		.if es:[bx][ID_USECASE] & dl
		    or ax,IO_SEARCHCASE
		.endif
		.if es:[bx][ID_PROMPT] & dl
		    or ax,_T_PROMPTONREP
		.endif
		.if byte ptr es:[bx][ID_CURSOR] & _O_RADIO
		    or ax,IO_SEARCHCUR
		.else
		    or ax,IO_SEARCHSET
		.endif
		mov dx,ax
		xor ax,ax
		.if searchstring != al
		    .if replacestring != al
			inc ax
		    .endif
		.endif
	    .endif
	    push dx
	    invoke dlclose,DLG_Replace
	    mov ax,dx
	    pop dx
	.endif
	test ax,ax
	ret
iddreplace endp

tireplace proc private uses si di bx
	mov si,tinfo
	mov ax,_T_PROMPTONREP
	or  [si].S_TINFO.ti_flag,ax
	mov al,fsflag
	and al,IO_SEARCHMASK
	.if iddreplace(ax)
	    and fsflag,not IO_SEARCHMASK
	    or  fsflag,dl
	    .if ax == ID_CHANGEALL || !(dx & _T_PROMPTONREP)
		and [si].S_TINFO.ti_flag,not _T_PROMPTONREP
	    .endif
	    .if !ticontinuesearch()
		jmp @F
		.repeat
		    call titostdi
		    and STDI.ios_flag,not (IO_SEARCHSET or IO_SEARCHCUR)
		    .break .if !continuesearch()
		    call tisearchfound
		    @@:
		    mov di,cx
		    .break .if !iddreplaceprompt()
		    .if ax != ID_NO
			add  [si].S_TINFO.ti_cleo,di	; select text
			call ticlipdel			; delete text
			mov  di,offset replacestring	; add new text
			.repeat
			    mov al,[di]
			    inc di
			    .break .if !al
			    call tiputc
			.until 0
		    .else
			call ticontinuesearch
		    .endif
		.until 0
	    .endif
	.endif
	call tiputs
	xor ax,ax
	ret
tireplace endp

idtestal:
	push	es
	push	di
	push	cx
	push	ax
	cmp	al,'A'
	jb	@F
	cmp	al,'Z'
	ja	@F
	or	al,20h
      @@:
	push	ds
	pop	es
	mov	di,offset idchars
	mov	cx,sizeof idchars
	cld
	repne	scasb
	cmp	byte ptr [di-1],0
	pop	ax
	pop	cx
	pop	di
	pop	es
	ret

tisearchxy proc pascal private uses si di bx
local	linebuf[128]:byte
	call	cursorx		; get cursor x,y pos
	mov	di,ax
	mov	bx,dx
	inc	di		; to start of line..
      @@:
	dec	di		; moving left seeking a valid character
	jz	@F
	invoke  getxyc,di,bx
	call	idtestal
	jz	@B
	mov	ax,di
	dec	ax
	invoke  getxyc,ax,bx
	call	idtestal
	jnz	@B
      @@:
	lea	si,linebuf
	mov	cx,32
	xor	ax,ax
      @@:
	invoke  getxyc,di,bx
	inc	di
	call	idtestal
	jz	@F
	mov	[si],al
	inc	si
	dec	cx
	jnz	@B
      @@:
	sub	ax,ax
	mov	[si],al
	mov	al,linebuf
	test	al,al
	jz	@F
	invoke  strcpy,addr searchstring,addr linebuf
	call	tisearch
      @@:
	ret
tisearchxy endp

;-----------------------------------------------------------------------------
; Event handler
;-----------------------------------------------------------------------------

	.data

te_keytable label size_t
	dw KEY_F1,	__F1		; Help
	dw KEY_F2,	__F2		; Save file
	dw KEY_F3,	tisearch	; Search
	dw KEY_F4,	tireplace	; Replace
	dw KEY_F6,	__F6
  ifdef __DZ__
	dw KEY_F8,	__F8
	dw KEY_F9,	__F9
	dw KEY_ESC,	__Esc		; Exit - leave files open
	dw KEY_ALTX,	__AltX		; Exit - Close all files
	dw KEY_CTRLX,	__CtrlX		; Close current file
  else
	dw KEY_F9,	__AltX
	dw KEY_ESC,	__AltX
	dw KEY_ALTX,	__AltX
	dw KEY_CTRLX,	__AltX
  endif
	dw KEY_F11,	titogglemenus	; Zoom (Ctrl-M)
	dw KEY_CTRLF2,  __CtrlF2	; Save as
	dw KEY_CTRLF6,  __CtrlF9	; Options
	dw KEY_CTRLF9,  __CtrlF9	; Options

	dw KEY_CTRLA,	__CtrlA		; Select All
	dw KEY_CTRLB,	__CtrlB		; User screen
	dw KEY_CTRLF,	__CtrlF		; Optimal fill on/off
	dw KEY_CTRLG,	tilseek		; Goto line
	dw KEY_CTRLI,	__CtrlI		; Autoindent on/off
	dw KEY_CTRLL,	__CtrlL		; Search again
	dw KEY_CTRLM,	titogglemenus	; Toggle menus on/off
	dw KEY_CTRLO,	__CtrlB		;
	dw KEY_ALTR,	__CtrlR		; Reload file
	dw KEY_CTRLS,	__CtrlS		; Toggle style on/off
	dw KEY_CTRLT,	__CtrlT		; Tabs mode on/off
	dw KEY_ALTL,	tilseek		;
	dw KEY_ALTS,	tisearchxy	; Word search
	dw KEY_ALT0,	__Alt0		; Window List
	tekeycount equ (($ - offset te_keytable) / (size_l * 2))

.code

tioption:
	call teoption
	mov bx,tinfo
	mov ax,[bx].S_TINFO.ti_flag
	mov cx,teflag
	mov dx,ax
	and ax,not _T_TECFGMASK
	or  ax,cx
	mov [bx].S_TINFO.ti_flag,ax
	mov ax,dx
	and ax,_T_USETABS
	and cx,_T_USETABS
	.if ax != cx
	    mov ax,1
	    .if dx & _T_MODIFIED
		.if tisavechanges()
		    mov ax,tinfo
		    call tiflush
		.endif
	    .endif
	    .if ax
		call __CtrlR
	    .endif
	.endif
	retx

__CtrlF9:
	pushl	cs
	call	tioption
	jmp	ticontinue

__F1:
  ifdef __DZ__
	mov  ax,HELPID_05
	call view_readme
  else
	invoke rsmodal,IDD_TEHelp
  endif
	jmp ticontinue

__F2:
	mov  ax,tinfo
	call tisave
	jmp  ticontinue

__F6:
	.if tigetfile()
	    mov bx,tinfo
	    .if [bx].S_TEDIT.ti_next
		mov ax,[bx].S_TEDIT.ti_next
	    .endif
	    jmp titogglefile
	.endif
	ret

titogglefile:
	push si
	push di
	mov di,ax
	mov si,tinfo
	.if di != si
	    .if [di].S_TINFO.ti_flag & _T_MALLOC or _T_EMMBUF
		invoke tihide,si
		mov tinfo,di
		invoke tishow,di
	    .endif
	.endif
	pop di
	pop si
	jmp ticontinue

ifdef DEBUG
SHOWTINFO equ 1
endif
ifdef SHOWTINFO

	.data
	extrn _dsstack:word
	tformat label byte
	db "%8u line count",10
	db "%8u EMM handle",10
	db "%8u EMM page  ",10
	db "%08lX file name ",10
	db "%8X Stack top  ",10
	db "%8X SP         ",10
	db "%8lu file size ",10
	db "%8X next file ",10
	db "%8X prev file ",10
	db "%08lX style ptr ",10
	db 0
	.code

__Alt0:
	.if tdlgopen()
	    push si
	    mov si,ax
	    mov ax,sp
	    invoke ermsg,0,addr tformat,
		[si].S_TEDIT.ti_lcnt,
		[si].S_TEDIT.ti_emmh,
		[si].S_TEDIT.ti_emmp,
		[si].S_TEDIT.ti_file,
		offset _dsstack,
		ax,
		[si].S_TEDIT.ti_size,
		[si].S_TEDIT.ti_next,
		[si].S_TEDIT.ti_prev,
		[si].S_TEDIT.ti_style
	    mov ax,si
	    pop si
	    jmp titogglefile
	.endif
	ret
else
__Alt0:
	.if tdlgopen()
	    jmp titogglefile
	.endif
	ret
endif

__CtrlF2:
	mov bx,tinfo
	invoke strcpy,addr _bufin,[bx].S_TEDIT.ti_file
	invoke strfn,dx::ax
	.if ax != offset _bufin
	    mov bx,ax
	    mov byte ptr [bx-1],0
	.endif
	.if wdlgopen(addr _bufin,dx::ax,0)
	    mov bx,tinfo
	    invoke strcpy,[bx].S_TEDIT.ti_file,dx::ax
	    mov ax,tinfo
	    call tiflush
	    mov bx,tinfo
	    xor [bx].S_TINFO.ti_flag,_T_USEMENUS
	    call titogglemenus
	.endif
	sub ax,ax
	ret

__CtrlA:
	call tiselectall
	call tiseto
	jmp  titoggleupdate

__CtrlB:
	call consuser
	sub  ax,ax
	ret

__CtrlI:
	mov ax,_T_USEINDENT
	jmp @F
__CtrlF:
	mov ax,_T_OPTIMALFILL
	jmp @F
__CtrlS:
	mov ax,_T_USESTYLE
	jmp @F
__CtrlT:
	mov ax,_T_SHOWTABS
      @@:
	mov bx,tinfo
	xor [bx].S_TINFO.ti_flag,ax
	jmp titoggleupdate

__CtrlL:
	call	ticontinuesearch
	jmp	ticontinue

titoggleupdate:
	call	tiputs
	jmp	ticontinue

__CtrlR:
	push	bx
	mov	bx,tinfo
	test	[bx].S_TINFO.ti_flag,_T_MODIFIED
	pop	bx
	jz	@F
	invoke  rsmodal,IDD_TEReload2
	jnz	@F
	jmp	ticontinue
      @@:
	mov	ax,tinfo
	call	timemzero
	mov	curh,-1		; v2.47 - update page on read
	mov	ax,tinfo
	call	tiread
	jz	@F
	call	tiseto
	call	tiputs
	jmp	ticontinue
      @@:
	mov	di,KEY_ESC
	dec	ax
	ret

ifdef __DZ__

tisavefiles	proto _CType
tiloadfiles	proto _CType

__F8:
	call	tisavefiles
	ret

__F9:
	call	tiloadfiles
	ret

	;------------------------------------------
	; Close window and exit -- leave files open
	;------------------------------------------
__Esc:
	mov ax,tinfo
	.if ax
	    xchg ax,bx
	    test [bx].S_TINFO.ti_flag,_T_EMMBUF
	    xchg ax,bx
	    .if !ZERO?
		invoke tihide,ax
		mov ax,_TI_RETEVENT
		ret
	    .endif
	.endif

	;----------------------------------------
	; Close current file -- exit if last file
	;----------------------------------------
__CtrlX:
	call	tclose
	mov	ax,_TI_RETEVENT
	jz	@F
	mov	ax,tinfo
	test	ax,ax
	jz	@F
	invoke  tishow,ax
	mov	ax,_TI_CONTINUE
      @@:
	ret
endif
	;-----------------------------
	; Close all open files -- exit
	;-----------------------------
__AltX:
	call tcloseall
	mov  ax,_TI_RETEVENT
	ret


	.data
	cp_tionfo	db ' col %-3u ln %-5u',0
	tiupdate_line	dw -1
	tiupdate_offs	dw -1

	.code

timenus proc private
	push si
	mov si,tinfo
	mov ax,si
	.if tistate()
	    .if dl & _D_ONSCR && cx & _T_USEMENUS
		mov  bx,ax
		mov  ax,[si].S_TINFO.ti_loff
		add  ax,[si].S_TINFO.ti_yoff
		inc  ax
		push ax
		mov  ax,[si].S_TINFO.ti_xoff
		add  ax,[si].S_TINFO.ti_boff
		push ax
		mov  ax,es:[bx][4]
		add  al,es:[bx].S_DOBJ.dl_rect.rc_col
		sub  al,18
		mov  cl,ah
		invoke scputf,ax,cx,0,0,addr cp_tionfo
		add sp,size_l*2
		mov ax,' '
		.if [si].S_TINFO.ti_flag & _T_MODIFIED
		    mov al,'*'
		.endif
		invoke scputw,0,cx,1,ax
	    .endif
	.endif
	pop si
	xor ax,ax
	ret
timenus endp

tiftime proc private uses si
	local ft:S_FTIME
	push di
	mov si,ax
	sub ax,ax
	mov ft.ft_time,ax
	mov ft.ft_date,ax
	.if osopen([si].S_TEDIT.ti_file,0,M_RDONLY,A_OPEN) != -1
	    mov di,ax
	    invoke getftime,di,addr ft
	    invoke close,di
	.else
	    or [si].S_TINFO.ti_flag,_T_MODIFIED
	.endif
	lodm ft
	test ax,ax
	pop di
	ret
tiftime endp

teevent proc private uses si di bx
	call tiseto
	call tiputs
	.repeat
	    mov ax,tinfo
	    mov si,ax
	    .if [si].S_TINFO.ti_flag & _T_MODIFIED
		.if tiftime()
		    .if ax != word ptr [si].S_TEDIT.ti_time
			.if rsmodal(IDD_TEReload)
			    mov  ax,si
			    call timemzero
			    mov  curh,-1	; v2.48 - update page on read
			    mov  ax,si
			    call tiread
			    mov  di,KEY_ESC
			    .break .if ZERO?
			    call tiseto
			    call tiputs
			.endif
		    .endif
		.endif
	    .endif
	    call timenus
	    call tgetevent
	    mov  di,ax
	    xor  bx,bx
	    mov  cx,tekeycount
	    .repeat
		.if ax == te_keytable[bx]
		    xor ax,ax
		    .break
		.endif
		add bx,size_l*2
	    .untilcxz
	    .if ax
	      ifdef __CLIP__
		call ticlipevent
	      endif
		call tievent
		mov  si,ax
	    .else
		call te_keytable[bx+size_l]
		.continue .if ax == _TI_CONTINUE
		.break
	    .endif
	    call tiseto
	    call tiputs
	.until 0
	mov ax,di
	ret
teevent endp

tiupdate:
	push si
	mov si,tinfo
	mov ax,si
	.if tistate()
	    .if dl & _D_ONSCR && cx & _T_USEMENUS
		mov ax,[si].S_TINFO.ti_loff
		add ax,[si].S_TINFO.ti_yoff
		mov dx,[si].S_TINFO.ti_xoff
		add dx,[si].S_TINFO.ti_boff
		.if ax != tiupdate_line || dx != tiupdate_offs
		    mov tiupdate_offs,dx
		    mov tiupdate_line,ax
		    call timenus
		.endif
	    .endif
	.endif
	pop si
	xor ax,ax
	retx

tmodal proc _CType public uses si di bx
local cursor:S_CURSOR
local update:dword
local ftime:dword
	.repeat
	    call mousep
	.until ZERO?
	mov ax,tinfo
	mov si,ax
	.if tistate()
	    movmx update,tupdate
	    movp tupdate,tiupdate
	    invoke cursorget,addr cursor
	    invoke tishow,si
	    mov ax,si
	    call tiftime
	    stom ftime
	    call teevent
	    mov di,ax
	    mov ax,tinfo
	    .if si == ax
		call tiftime
		mov si,word ptr ftime
		sub si,ax
	    .else
		mov si,0
	    .endif
	    mov ax,word ptr update
	    mov word ptr tupdate,ax
	    movl ax,word ptr update+2
	    movl word ptr tupdate+2,ax
	    invoke cursorset,addr cursor
	    mov dx,si		; zero if not modified
	    mov ax,di		; returned key value
	    test ax,ax
	.endif
	ret
tmodal endp

tedit proc _CType public fname:dword, line:size_t
	.if topen(fname)
	    mov ax,line
	    call tialigny
	    call tmodal
	.endif
	ret
tedit endp
endif
	END
