include	clib.inc
include	keyb.inc
ifndef	__f__
include	conio.inc

	.data
	keyboard dw 1

	.code

InstallKeyboard:
	sub	ax,ax
	mov	es,ax
	mov	ah,12h		; GET EXTENDED SHIFT STATES
	int	16h		; (enh kbd support only)
	mov	bx,0417h	; 0040:0017 (keyshift)
	cmp	al,es:[bx]
	jne	@F
	mov	ah,80h
	xor	es:[bx],ah
	mov	ah,12h
	int	16h
	cmp	al,es:[bx]
	jne	@F
	mov	keyboard,1001h
      @@:
	test	console,CON_INT2F
	jz	@F
	and	console,not CON_INT2F
	mov	ax,1680h	; MS Windows, DPMI, various
	int	2Fh		; - RELEASE CURRENT VIRTUAL MACHINE TIME-SLICE
	test	al,al		; 00h if the call is supported
	jnz	@F		; 80h (unchanged) if the call is not supported
	or	console,CON_INT2F
      @@:
	ret

keystroke:
	mov	ax,keyboard	; 01h: CHECK FOR KEYSTROKE
	inc	ah      	; 11h: CHECK FOR ENHANCED KEYSTROKE
	int	16h
	jz	keystroke_end	; ZF clear if keystroke available
	mov	ax,keyboard	; 00h: GET KEYSTROKE
	int	16h		; 10h: GET ENHANCED KEYSTROKE
	;-----------------------
	test	ah,ah		; Yury - 04 Apr 2012
	jz	@F		; - Russian letter 224 (0xE0) discarded
	cmp	al,0E0h
	jne	keystroke_end
	sub	al,al
      @@:
	test	ax,ax
	;------------------------
    keystroke_end:
	ret

getkey proc _CType public
	call	keystroke
	jnz	getkey_end
	test	console,CON_INT2F
	jz	getkey_nul
	mov	ax,1680h; added 05/05/2008 (bttr)
	int	2Fh     ; RELEASE CURRENT VIRTUAL MACHINE TIME-SLICE
    getkey_nul:
	xor	ax,ax
    getkey_end:
	test	ax,ax
	ret
getkey endp

getesc proc _CType public
	call	keystroke
	jz	getesc_nul
	cmp	ax,011Bh	; ESC
	je	getesc_end
    getesc_nul:
	xor	ax,ax
    getesc_end:
	test	ax,ax
	ret
getesc endp

pragma_init InstallKeyboard, 10

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
else
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

include	stdio.inc

KEY_EVENT	equ 1
MOUSE_EVENT	equ 2

UpdateKeyEvent 	proto _CType :ptr INPUT_RECORD
UpdateMouseEvent proto _CType :ptr INPUT_RECORD

	.data

scancode label byte
	db 3Bh,3Ch,3Dh,3Eh,3Fh,40h,41h,42h,43h,44h ; F1..F10
	db 47h	; HOME
	db 48h	; UP
	db 49h	; PGUP
	db 4Bh	; LEFT
	db 4Dh	; RIGHT
	db 4Fh	; END
	db 50h	; DOWN
	db 51h	; PGDN
	db 52h	; INS
	db 53h	; DEL
	db 0Fh	; Ctrl-Tab 0F00 --> 9400
	db 0
scanshift label byte
	db 54h,55h,56h,57h,58h,59h,5Ah,5Bh,5Ch,5Dh
	db 47h,48h,49h,4Bh,4Dh,4Fh,50h,51h,52h,53h
	db 0Fh
scanctrl label byte
	db 5Eh,5Fh,60h,61h,62h,63h,64h,65h,66h,67h
	db 77h,8Dh,84h,73h,74h,75h,91h,76h,92h,93h
	db 94h
scanalt label byte
	db 68h,69h,6Ah,6Bh,6Ch,6Dh,6Eh,6Fh,70h,71h
	db 47h,98h,49h,9Bh,9Dh,4Fh,0A0h,51h,52h,53h
	db 0Fh

	.code

	ASSUME	ebx:ptr INPUT_RECORD

parseshift:
	push	esi
	mov	esi,offset scancode
      @@:
	lodsb
	or	al,al
	je	@F
	cmp	ah,al
	jne	@B
	sub	esi,offset scancode
	mov	ah,[esi+edx-1]
	mov	al,0
      @@:
	pop	esi
	ret

getkey	proc _CType uses ebx edi esi
local	Count:dword
local	Event:INPUT_RECORD
	sub edi,edi
	lea ebx,Event
	.if GetNumberOfConsoleInputEvents(OFSH_INPUT,addr Count)
	    mov esi,Count
	    .while esi
	    	invoke ReadConsoleInput,OFSH_INPUT,ebx,1,addr Count
		.break .if !Count
		.if [ebx].EventType == KEY_EVENT
		    invoke UpdateKeyEvent,ebx
		    mov edi,eax
		    .break .if eax
		.elseif [ebx].EventType == MOUSE_EVENT
		    invoke UpdateMouseEvent,ebx
		    .break .if eax
		.endif
		dec esi
	    .endw
	.endif
	mov eax,edi
	.if ah && !al
	    mov edx,keyshift
	    mov edx,[edx]
	    .if edx & SHIFT_RIGHT or SHIFT_LEFT
		mov edx,offset scanshift
		call parseshift
	    .elseif edx & SHIFT_CTRL or SHIFT_CTRLLEFT
		mov edx,offset scanctrl
		call parseshift
	    .elseif edx & SHIFT_ALT or SHIFT_ALTLEFT
		mov edx,offset scanalt
		call parseshift
	    .endif
	.endif
	test eax,eax
	ret
getkey	endp
endif
	end
