include	clib.inc
include	io.inc
include	iost.inc
include	string.inc
include	conio.inc

extrn	IDD_Search:	dword
extrn	searchstring:	byte

	.data
	cp_search	db 'Search',0
	cp_notfoundmsg	db "Search string not found: '%s'",0
	cp_stlsearch	db 'Search for the string:',0
	hexstring	db 128 dup(?)
	hexstrlen	d? 0

	.code

ioseek:
	lodm STDI.ios_bb	; current offset | line:offset
	mov rcx,STDI.ios_flag
	and STDI.ios_flag,not (IO_SEARCHSET or IO_SEARCHCUR)
	test rcx,IO_SEARCHSET
	jz @F
	sub rax,rax
	mov rdx,rax
	jmp ioseek_set
      @@:
	test rcx,IO_SEARCHCUR
	jnz ioseek_set
	add rax,1		; offset++ (continue)
	adc rdx,0
    ioseek_set:
	mov rdi,rax
	mov rbp,rdx
	invoke oseek,dxax,SEEK_SET
	ret

seekbx:
	cmp rbx,STDI.ios_i
	ja  @F
	sub rdi,rbx
	sbb rbp,0
	sub STDI.ios_i,rbx
	ret
      @@:
	push rsi
	mov rsi,rbx
      @@:
	call oungetc
	sub rdi,1
	sbb rbp,0
	dec rsi
	jnz @B
	pop rsi
	ret

lodhex:
	mov al,[rsi]
	test al,al
	jz  lodhex_end
	inc rsi
	cmp al,'0'
	jb  lodhex
	cmp al,'9'
	jbe lodhex_ok
	or  al,20h
	cmp al,'f'
	ja  lodhex
	sub al,27h
    lodhex_ok:
	sub al,'0'
	test rsi,rsi
    lodhex_end:
	ret

searchfound:
	mov rax,rsi
	sub rax,rdx
	inc rax
	sub rdi,rax
	sbb rbp,0
	mov rax,rdi
	mov rdx,rbp
	or  rdi,1
	ret

searchhex:
	push rbp
	push rsi
	push rdi
	push rbx
	.if (STDI.ios_flag & IO_LINEBUF)
	    sub ax,ax
	    jmp searchhex_end
	.endif
      ifdef __f__
	mov edx,0
      endif
	call ioseek
	jz  searchhex_end
	xor rcx,rcx
	mov rsi,offset searchstring
	mov rbx,offset hexstring
    searchhex_xtol:
	call lodhex
	jz searchhex_hexl
	mov ah,al
	call lodhex
	jnz searchhex_mkb
	xchg al,ah
    searchhex_mkb:
	shl ah,4
	or  al,ah
	mov [rbx],al
	inc rbx
	inc rcx
	jmp searchhex_xtol
    searchhex_found:
	call searchfound
    searchhex_end:
	pop rbx
	pop rdi
	pop rsi
	pop rbp
	ret
    searchhex_hexl:
	mov hexstrlen,rcx
    searchhex_scan:
	mov dl,hexstring
	mov rcx,STDI.ios_l
	  @@:
	    call ogetc
	    jz searchhex_end
	    add rdi,1	; inc offset
	    adc rbp,0
	    mov ah,al
	    sub ah,10
	    cmp ah,1
	    adc rcx,0	; inc line
	    cmp al,dl
	    jne @B
	mov STDI.ios_l,rcx
	mov rsi,offset hexstring
    searchhex_cmp:
	call	ogetc
	jz	searchhex_end
	add	rdi,1
	adc	rbp,0
	inc	rsi
	mov	rdx,offset hexstring
	mov	rcx,rsi
	sub	rcx,rdx
	cmp	rcx,hexstrlen
	je	searchhex_found
	cmp	al,[rsi]
	je	searchhex_cmp
	mov	rbx,rsi
	sub	rbx,rdx
	call	seekbx
	jmp	searchhex_scan

search:
	sub rax,rax
	.if searchstring != al
	    .if STDI.ios_flag & IO_SEARCHHEX
		jmp searchhex
	    .endif
	    jmp searchtxt
	.endif
	ret

searchtxt:
	push rbp
	push rsi
	push rdi
	call ioseek
	jz   searchtxt_end
    searchtxt_scan:
	sub rcx,rcx
	.if STDI.ios_flag & IO_SEARCHCASE
	    mov dl,searchstring
	  @@:
	    call ogetc
	    jz searchtxt_end
	    add rdi,1	; inc offset
	    adc rbp,0
	    cmp	al,10
	    je searchtxt_l12
	searchtxt_l11:
	    cmp al,dl
	    jne @B
	.else
	    mov al,searchstring
	    sub al,'A'
	    cmp al,'Z'-'A'+1
	    sbb ah,ah
	    and ah,'a'-'A'
	    add al,ah
	    add al,'A'
	    mov dl,al  	; tolower(*searchstring)
	  @@:
	    call ogetc
	    jz searchtxt_end
	    add rdi,1
	    adc rbp,0
	    cmp	al,10
	    je searchtxt_l22
	searchtxt_l21:
	    sub al,'A'
	    cmp al,'Z'-'A'+1
	    sbb ah,ah
	    and ah,'a'-'A'
	    add al,ah
	    add al,'A' 	; tolower(AL)
	    cmp al,dl
	    jne @B
	.endif
	.if !(STDI.ios_flag & IO_LINEBUF)
	    add STDI.ios_l,rcx
	.endif
	mov rsi,offset searchstring
    searchtxt_cmp:
	call ogetc
	jz  searchtxt_end
	add rdi,1
	adc rbp,0
	inc rsi
	mov rdx,offset searchstring
	mov cl,al
	mov al,[rsi]
	test al,al
	jz searchtxt_found
	cmp al,cl
	je searchtxt_cmp
	.if !(STDI.ios_flag & IO_SEARCHCASE)
	    sub al,'A'
	    cmp al,'Z'-'A'+1
	    sbb ah,ah
	    and ah,'a'-'A'
	    add al,ah
	    add al,'A' 	; tolower(AL)
	    xchg al,cl
	    sub al,'A'
	    cmp al,'Z'-'A'+1
	    sbb ah,ah
	    and ah,'a'-'A'
	    add al,ah
	    add al,'A' 	; tolower(CL)
	    cmp al,cl
	    je searchtxt_cmp
	.endif
	mov rbx,rsi
	sub rbx,rdx
	call seekbx
	jmp searchtxt_scan
    searchtxt_found:
	call searchfound
    searchtxt_end:
	pop rdi
	pop rsi
	pop rbp
	ret
    searchtxt_l12:
	inc rcx
	jmp searchtxt_l11
    searchtxt_l22:
	inc rcx
	jmp searchtxt_l21

notfoundmsg:
	mov cp_notfoundmsg+24,' '
	invoke strlen,addr searchstring
	cmp rax,29
	jb @F
	mov cp_notfoundmsg+24,10
      @@:
	invoke stdmsg,addr cp_search,addr cp_notfoundmsg,addr searchstring
	ret

continuesearch proc _CType public
local	StatusLine[160]:byte
	sub rax,rax
	.if searchstring
	    invoke wcpushst,addr StatusLine,addr cp_stlsearch
	    mov al,_scrrow
	    invoke scputs,24,rax,0,80-24,addr searchstring
	    invoke oseekl,STDI.ios_bb,SEEK_SET
	    .if rax
		.if STDI.ios_flag & IO_SEARCHHEX
		    call searchhex
		.else
		    call searchtxt
		.endif
		.if !ZERO?
		    stom STDI.ios_bb
		    mov rax,1
		    jmp @F
		.endif
	    .endif
	    call notfoundmsg
	    xor rax,rax
	  @@:
	    push rax
	    invoke wcpopst,addr StatusLine
	    pop rax
	.endif
	ret
continuesearch endp

osearch	proc _CType public uses rbx h:size_t,fsize:dword,buf:dword,bsize:size_t,flag:size_t
	mov rax,h
	mov STDI.ios_file,rax
	invoke lseek,rax,0,SEEK_CUR
      ifdef __f__
	cmp eax,-1
      else
	cmp dx,-1
	jne @F
	cmp ax,-1
      endif
	je osearch_err
      @@:
	stom STDI.ios_bb
	sub rax,rax
	mov STDI.ios_c,rax
	mov STDI.ios_i,rax
	movmx STDI.ios_size,bsize
	movmx STDI.ios_bp,buf
	mov rax,flag
	or  rax,IO_SEARCHCUR
	mov STDI.ios_flag,rax
	call search
	jnz osearch_end
    osearch_err:
	mov rax,-1
	mov16 dx,ax
    osearch_end:
	mov rcx,STDI.ios_l
	ret
osearch	endp

cmsearchidd proc _CType public uses rsi rbx sflag:size_t
local DLG_Search:dword
	invoke rsopen,IDD_Search
	stom DLG_Search
	jz cmsearchidd_nul
	mov16 es,dx
	mov rbx,rax
	mov PEBX.S_TOBJ.to_count[1*16],128 shr 4
	mov WORDP PEBX.S_TOBJ.to_data[1*16],offset searchstring
	mov16 word ptr es:[bx].S_TOBJ.to_data[1*16+2],ds
	mov rax,sflag
	mov dl,_O_FLAGB
	test rax,IO_SEARCHCASE
	jz cmsearchidd_hex?
	or PEBX[2*16],dl
    cmsearchidd_hex?:
	test rax,IO_SEARCHHEX
	jz cmsearchidd_cur?
	or PEBX[3*16],dl
    cmsearchidd_cur?:
	mov dl,_O_RADIO
	test rax,IO_SEARCHCUR
	jz cmsearchidd_rset
	or PEBX[6*16],dl
	jmp cmsearchidd_event
    cmsearchidd_nul:
	xor rax,rax
	jmp cmsearchidd_end
    cmsearchidd_rset:
	or PEBX[7*16],dl
    cmsearchidd_event:
	invoke dlinit,DLG_Search
	invoke rsevent,IDD_Search,DLG_Search
	test rax,rax
	jz cmsearchidd_nul
	mov rax,sflag
	and rax,not IO_SEARCHMASK
	mov dl,_O_FLAGB
	test PEBX[2*16],dl
	jz cmsearchidd_hex
	or rax,IO_SEARCHCASE
    cmsearchidd_hex:
	test PEBX[3*16],dl
	jz cmsearchidd_cur
	or rax,IO_SEARCHHEX
    cmsearchidd_cur:
	test byte ptr PEBX[6*16],_O_RADIO
	jz cmsearchidd_set
	or rax,IO_SEARCHCUR
	jmp cmsearchidd_toend
    cmsearchidd_set:
	or rax,IO_SEARCHSET
    cmsearchidd_toend:
	mov rdx,rax
	sub rax,rax
	cmp searchstring,al
	je cmsearchidd_end
	inc rax
    cmsearchidd_end:
	mov rsi,rdx
	invoke dlclose,DLG_Search
	mov rax,rdx
	mov rdx,rsi
	test rax,rax
	ret
cmsearchidd endp

cmdsearch proc _CType public offs:dword
	sub rax,rax
      ifndef __f__
	cmp ax,word ptr offs+2
	jne cmdsearch_00
	cmp word ptr offs,16
	jb cmdsearch_end
      else
	cmp offs,16
	jb cmdsearch_end
      endif
    cmdsearch_00:
	invoke cmsearchidd,STDI.ios_flag
	jz cmdsearch_end
	mov STDI.ios_flag,rdx
	and rdx,IO_SEARCHCUR or IO_SEARCHSET
	push rdx
	call continuesearch
	pop rdx
	or STDI.ios_flag,rdx
    cmdsearch_end:
	ret
cmdsearch endp

	END
