include	clib.inc
include	time.inc
include	conio.inc
include	mouse.inc
include	keyb.inc

ifdef DEBUG
ifdef __DZ__
	__TVSEG equ 1
endif
endif

ifdef __TVSEG
_TVIEW	SEGMENT word USE16 public 'CODE'
_TVIEW	ENDS
	ASSUME cs:_TVIEW, ds:DGROUP
else
_TVIEW	equ <_TEXT>
endif

STARTDAY  	equ 5
STARTYEAR       equ 0
MAXYEAR 	equ 3000

;USE_MDALTKEYS	= 1

;	.data
_DATA	SEGMENT

;******** Resource begin CALENDAR *
;	{ 0x005C,   0,   0, {42, 2,29,10} },
;******** Resource data  *******************
CALENDAR_RC label word
	dw	00283h	; Alloc size
	dw	0005Ch,00000h,0022Ah,00A1Dh,03AF0h,0F02Eh,02A3Ah,01DF0h
	dw	0F02Eh,02A74h,01DF0h,0F02Eh,0DF1Dh,04D20h,06E6Fh,05420h
	dw	06575h,05720h,06465h,05420h,07568h,04620h,06972h,05320h
	dw	07461h,05320h,06E75h,02020h,01BF0h,0F0C4h,020AFh,01DF0h
	dw	02EDCh
;	68 byte
;******** Resource end   CALENDAR *

;******** Resource begin CALENDAR2 *
;	{ 0x0010,   0,   0, {45,12,14, 1} },
;******** Resource data  *******************
CALENDAR2_RC label word
	dw	0002Ch	; Alloc size
	dw	00010h,00000h,00C2Dh,0010Eh,00EF0h,0F007h,0200Eh,00707h
;	18 byte
;******** Resource end   CALENDAR2 *

	cp_jan	db "January",0
	cp_feb	db "February",0
	cp_mar	db "March",0
	cp_apr	db "April",0
	cp_may	db "May",0
	cp_jun	db "June",0
	cp_jul	db "July",0
	cp_aug	db "August",0
	cp_sep	db "September",0
	cp_oct	db "October",0
	cp_nov	db "November",0
	cp_dec	db "December",0
	cp_month label size_t
		d? offset cp_jan
		d? offset cp_feb
		d? offset cp_mar
		d? offset cp_apr
		d? offset cp_may
		d? offset cp_jun
		d? offset cp_jul
		d? offset cp_aug
		d? offset cp_sep
		d? offset cp_oct
		d? offset cp_nov
		d? offset cp_dec
	keylocal label size_t
		d? MOUSECMD
		d? KEY_ESC
		d? KEY_HOME
		d? KEY_RIGHT
		d? KEY_LEFT
		d? KEY_UP
		d? KEY_DOWN
		d? KEY_PGUP
		d? KEY_PGDN
		d? KEY_CTRLPGUP
		d? KEY_CTRLPGDN
		d? KEY_ENTER
		d? KEY_ALTX
	ifdef USE_MDALTKEYS
		d? KEY_ALTUP
		d? KEY_ALTDN
		d? KEY_ALTLEFT
		d? KEY_ALTRIGHT
	endif
	keyproc label size_t
		d? event_mouse
		d? event_ESC
		d? event_HOME
		d? event_nextday
		d? event_prevday
		d? event_UP
		d? event_DOWN
		d? event_prevmnd
		d? event_nextmnd
		d? event_prevyear
		d? event_nextyear
		d? event_ENTER
		d? event_ESC
	ifdef USE_MDALTKEYS
		d? event_ALTUP
		d? event_ALTDN
		d? event_ALTLEFT
		d? event_ALTRIGHT
	endif
	keycount = (($ - offset keyproc) / size_l)
	mnd_table  db 31,28,31,30,31,30,31,31,30,31,30,31
	keypos	   db 1,5,9,13,17,21,25
	format_s_d db '%s %d',0
	format_2d  db '%2d',0

	DLG_Calendar	dd ?
	DLG_Calendar2	dd ?
	xpos		d? ?
	ypos		d? ?
	year		d? ?
	month		d? ?
	day		d? ?
	week_day	d? ?
	days_in_month	d? ?
	current_year	d? ?
	current_month	d? ?
	calender	d? ?
	result		d? ?

_DATA	ENDS

;	.code
_TVIEW	SEGMENT

days_in_feb:
	push	rdx
	push	rbx
	test	rcx,rcx
	jz	days_in_feb_29
	mov	rax,rcx
	and	al,3
	jnz	@F
	mov	rax,rcx
	mov	rbx,100
	xor	rdx,rdx
	div	rbx
	or	rdx,rdx
	jnz	days_in_feb_29
      @@:
	mov	rbx,400
	mov	rax,rcx
	xor	rdx,rdx
	div	rbx
	test	rdx,rdx
	jz	days_in_feb_29
	mov	rax,28
    days_in_feb_end:
	pop	rbx
	pop	rdx
	ret
    days_in_feb_29:
	mov	rax,29
	jmp	days_in_feb_end

days_in_mnd:
	cmp	rbx,2
	je	days_in_feb
	mov	ah,0
	mov	al,mnd_table[rbx-1]
	ret

weekday_jan1:
	push	rbp
	push	rsi
	push	rdi
	xor	rbp,rbp
	mov	rsi,STARTDAY
	mov	rdi,rcx
	mov	rcx,STARTYEAR
    weekday_jan1_loop:
	cmp	rcx,rdi
	jnb	weekday_jan1_break
	call	days_in_feb
	cmp	rax,29
	jne	@F
	add	rsi,1
 	adc	rbp,0
      @@:
	inc	rcx
	add	rsi,1
	adc	rbp,0
	jmp	weekday_jan1_loop
    weekday_jan1_break:
	push	rdx
	mov	rdx,rbp
	mov	rax,rsi
	mov	rsi,7
	div	rsi
	mov	rax,rdx
	pop	rdx
	mov	rcx,rdi
	pop	rdi
	pop	rsi
	pop	rbp
	ret

getweekday:
	call	weekday_jan1
	push	rsi
	push	rdi
	mov	rsi,rax
	mov	rdi,rbx
	mov	rbx,1
      @@:
	cmp	rbx,rdi
	jnb	@F
	call	days_in_mnd
	add	rsi,rax
	inc	rbx
	jmp	@B
      @@:
	push	rdx
	mov	rdi,7
	xor	rdx,rdx
	mov	rax,rsi
	div	rdi
	mov	rax,rdx
	pop	rdx
	pop	rdi
	pop	rsi
	ret

getcurdate:	; GET SYSTEM DATE
	call	getday
	mov	day,rax
	call	getmnd
	mov	month,rax
	call	getyear
	mov	year,rax
	mov	rdx,day
	mov	rcx,rax
	mov	rax,month
	mov	rbx,rax
	call	getweekday
	mov	week_day,rax
	call	days_in_mnd
	mov	days_in_month,rax
	ret

incyear:
	mov	rcx,year
	cmp	rcx,MAXYEAR
	je	@F
	inc	rcx
	ret
      @@:
	mov	rcx,STARTYEAR
	ret

decyear:
	mov	rcx,year
	test	rcx,rcx
	jz	@F
	dec	rcx
	ret
      @@:
	mov	rcx,MAXYEAR
	ret

putdate:
	push	rsi
	push	rdi
	mov	rax,year
	mov	rdx,month
	cmp	rax,current_year
	jne	@F
	cmp	rdx,current_month
	je	putdate_day
      @@:
	mov	current_month,rdx
	mov	current_year,rax
	mov	rax,xpos
	mov	rdx,ypos
	add     al,3
	add	dl,10
	invoke	scputw,rax,rdx,14,0720h
	mov	rbx,month
	dec	rbx
	shl	rbx,size_l/2
	mov	rbx,cp_month[rbx]
	invoke	scputf,rax,rdx,0,0,addr format_s_d,ssbx,year
	mov	rbx,xpos
	mov	rdx,ypos
	add	dl,3
	mov	rcx,6
	mov	rax,20h
	mov	ah,at_background[7]
	or	ah,at_foreground[0]
      @@:
	invoke	scputw,rbx,rdx,29,rax
	inc	dl
	dec	rcx
	jnz	@B
    putdate_day:
	xor	rsi,rsi
	mov	rdi,3
    putdate_loop:
	cmp	rsi,days_in_month
	jnb	putdate_end
	xor	rcx,rcx
    putdate_xloop:
	cmp	rcx,7
	jnb	putdate_yloop
	mov	rax,3		; first line
	cmp	week_day,rcx	; week day
	ja      @F
	cmp	rdi,rax
	je	putdate_putday
      @@:
	cmp	rdi,rax
	jna	putdate_next
	cmp	rsi,days_in_month	; days in month
	jae	putdate_next
    putdate_putday:
	inc	rsi
	push	rcx
	push	rdi
	mov	rbx,rcx
	mov	cl,at_background[7]
	mov	al,at_foreground[0Fh]
	cmp	rsi,day
	je	@F
	mov	al,at_foreground[0]
      @@:
	or	cl,al
	mov	al,keypos[rbx]
	mov	rbx,rdi
	add	rbx,ypos
	add	rax,xpos
	mov	rdi,rax
	invoke	scputf,rax,rbx,rcx,2,addr format_2d,rsi
	call	getday
	cmp	rax,rsi
	jne	@F
	call	getmnd
	cmp	rax,month
	jne	@F
	call	getyear
	cmp	rax,year
	jne	@F
	mov	al,04h
	or	al,at_background[7]
	invoke	scputa,rdi,rbx,2,rax
      @@:
	pop	rdi
	pop	rcx
    putdate_next:
	inc	rcx
	jmp	putdate_xloop
    putdate_yloop:
	add	rdi,1
	cmp	rdi,10
	jb	putdate_loop
    putdate_end:
	pop	rdi
	pop	rsi
	ret

setdate:
	mov	day,rdx
	mov	month,rbx
	mov	year,rcx
	call	getweekday
	mov	week_day,rax
	call	days_in_mnd
	mov	days_in_month,rax
	call	putdate
	ret

ifdef USE_MDALTKEYS
event_ALTUP:
	mov	rax,rcmoveup
	jmp	DLMOVE_MOVE
event_ALTDN:
	mov	rax,rcmovedn
	jmp	DLMOVE_MOVE
event_ALTLEFT:
	mov	rax,rcmoveleft
	jmp	DLMOVE_MOVE
event_ALTRIGHT:
	mov	rax,rcmoveright
DLMOVE_MOVE:
	push	ax
	pushm	[bp-6]
	call	dlhide
	pop	ax
	les	bx,[bp-28]
	pushm	es:[bx+4]
	pushm	es:[bx+12]
	push	es:[bx]
	pushl	cs
	call	ax
	mov	ax,dx
	les	bx,[bp-28]
	mov	es:[bx+4],ax
	mov	[bp-24],ax
	add	ax,0A03h
	les	bx,[bp-6]
	mov	es:[bx+4],ax
	pushm	[bp-6]
	call	dlshow
	ret
endif

event_ENTER:
	mov	rax,1
	mov	result,rax

event_ESC:
	inc	byte ptr calender
	ret

event_HOME:
	call	getcurdate
	jmp	putdate

event_nextday:
	mov	rdx,day
	inc	rdx
	cmp	rdx,days_in_month
	ja	event_nextmnd
	mov	day,rdx
	jmp	putdate

event_prevday:
	mov	rdx,day
	cmp	rdx,1
	je	@F
	mov	rcx,year
	mov	rbx,month
	dec	rdx
	jmp	setdate
      @@:
	call	event_prevmnd
	mov	rax,days_in_month
	mov	day,rax
	jmp	putdate

event_UP:
	mov	rax,7
	cmp	day,rax
	jbe	event_prevday
	sub	day,rax
	jmp	putdate

event_DOWN:
	mov	rax,day
	add	rax,7
	cmp	rax,days_in_month
	ja	event_nextday
	mov	day,rax
	jmp	putdate

event_prevmnd:
	mov	rdx,1
	mov	rbx,month
	mov	rcx,year
	cmp	rbx,1
	je	@F
	dec	rbx
	jmp	setdate
    @@:
	mov	rbx,12
	call	decyear
	jmp	setdate

event_nextmnd:
	mov	rbx,month
	cmp	rbx,12
	je	event_nextyear
	mov	rdx,1
	mov	rcx,year
	inc	rbx
	jmp	setdate

event_prevyear:
	mov	rdx,1
	mov	rbx,rdx
	call	decyear
	jmp	setdate

event_nextyear:
	mov	rdx,1
	mov	rbx,rdx
	call	incyear
	jmp	setdate

event_mouse:
  ifdef __MOUSE__
	call	mousex
	mov	rdx,rax
	call	mousey
	LPES	rbx,DLG_Calendar
	invoke	rcxyrow,dword ptr PEBX.S_DOBJ.dl_rect,rdx,rax
	test	rax,rax
	jz	event_ESC
	invoke	dlhide,DLG_Calendar2
	invoke	dlmove,DLG_Calendar
	LPES	rbx,DLG_Calendar
	sub	rax,rax
	mov	al,PEBX+4
	mov	dl,al
	mov	xpos,rax
	mov	al,PEBX+5
	mov	ypos,rax
	mov	ah,al
	mov	al,dl
	add	ax,0A03h
	LPES	rbx,DLG_Calendar2
	mov	PEBX+4,ax
	invoke	dlshow,DLG_Calendar2
  else
	xor	rax,rax
  endif
	ret

modal:	cmp	byte ptr calender,0
	je	@F
	ret
      @@:
	call	tgetevent
	mov	rcx,keycount
	xor	rbx,rbx
      @@:
	cmp	rax,keylocal[rbx]
	je	@F
	add	rbx,size_l
	dec	rcx
	jnz	@B
	jmp	modal
      @@:
	call	keyproc[rbx]
	jmp	modal

cmcalendar proc _CType public uses rbx
	xor	rax,rax
	mov     calender,rax
	mov     current_year,rax
	mov     current_month,rax
	mov	result,rax
	invoke	rsopen,addr CALENDAR_RC
	stom	DLG_Calendar
	jz	cmcalendar_end
	mov	rbx,rax
	sub	rax,rax
	mov	al,PEBX[4]
	mov	xpos,rax
	mov	al,PEBX[5]
	mov	ypos,rax
	invoke	dlshow,DLG_Calendar
	invoke	rsopen,addr CALENDAR2_RC
	stom	DLG_Calendar2
	invoke	dlshow,dxax
	call	getcurdate
	mov	rdx,day
	mov	rbx,month
	mov	rcx,year
	call	setdate
  ifdef __MOUSE__
	call	msloop
  endif
	call	modal
	invoke	dlclose,DLG_Calendar2
	invoke	dlclose,DLG_Calendar
	mov	rdx,day
	mov	rbx,month
	mov	rcx,year
    cmcalendar_end:
	mov	rax,result
	ret
cmcalendar endp

_TVIEW	ENDS

	end
