include	clib.inc
include	stdio.inc
include	math.inc

public	output_flush

BUFFERSIZE	equ 512		; ANSI-specified minimum is 509

FLAG_SIGN	equ 0001h     	; put plus or minus in front
FLAG_SIGNSP	equ 0002h     	; put space or minus in front
FLAG_LEFT	equ 0004h     	; left justify
FLAG_LEADZERO	equ 0008h     	; pad with leading zeros
FLAG_LONG       equ 0010h     	; long value given
FLAG_SHORT      equ 0020h     	; short value given
FLAG_SIGNED	equ 0040h     	; signed data given
FLAG_ALTERNATE	equ 0080h     	; alternate form requested
FLAG_NEGATIVE	equ 0100h     	; value is negative
FLAG_FORCEOCTAL equ 0200h     	; force leading '0' for octals

	.data

cl_table label byte
	db	 06h, 00h, 00h, 06h, 00h, 01h, 00h, 00h
	db	 10h, 00h, 03h, 06h, 00h, 06h, 02h, 10h
	db	 04h, 45h, 45h, 45h, 05h, 05h, 05h, 05h
	db	 05h, 35h, 30h, 00h, 50h, 00h, 00h, 00h
	db	 00h, 20h, 28h, 38h, 50h, 58h, 07h, 08h
	db	 00h, 37h, 30h, 30h, 57h, 50h, 07h, 00h
	db	 00h, 20h, 20h, 08h, 00h, 00h, 00h, 00h
	db	 08h, 60h, 60h, 60h, 60h, 60h, 60h, 00h
	db	 00h, 70h, 78h, 78h, 78h, 78h, 78h, 08h
	db	 07h, 08h, 00h, 00h, 07h, 00h, 08h, 08h
	db	 08h, 00h, 00h, 08h, 00h, 08h, 00h, 00h
	db	 08h

formchar	db 'bcdefginopsuxEGX'
nullstring	db '(null)',0
output_flush 	p? ?

OPST_table 	label size_t
	d?	OPST_normal
	d?	OPST_percent
	d?	OPST_flag
	d?	OPST_width
	d?	OPST_dot
	d?	OPST_precision
	d?	OPST_size
	d?	OPST_type

output_proctab 	label size_t
	d?	OUTPUT_b
	d?	OUTPUT_c
	d?	OUTPUT_d
	d?	OUTPUT_dummy
	d?	OUTPUT_dummy
	d?	OUTPUT_dummy
	d?	OUTPUT_d
	d?	OUTPUT_n
	d?	OUTPUT_o
	d?	OUTPUT_p
	d?	OUTPUT_s
	d?	OUTPUT_u
	d?	OUTPUT_x
	d?	OUTPUT_dummy
	d?	OUTPUT_dummy
	d?	OUTPUT_xu

S_OUTPUT 	STRUC
OP_filep	dd ?
OP_format	dd ?
OP_charsout 	d? ?
OP_hexoff	d? ?
OP_state	d? ?
OP_curadix	d? ?
OP_prefix	db 2 dup(?)
OP_count	d? ?
OP_prefixlen	d? ?
OP_no_output	d? ?
OP_fldwidth	d? ?
OP_padding	d? ?
OP_text		dd ?
OP_capitalize	d? ?
ifdef __f__
OP_numeax	dd ?
OP_numedx	dd ?
else
OP_number	dd ?
endif
OP_ddtemp	dd ?
OP_dwtemp	d? ?
OP_buffer	db BUFFERSIZE dup(?)
OP_STACK	dd ? ; [(E)BP]
ifndef __c__
OP_CSIP		d? ?
endif
ifdef __CDECL__
OP_ARGfile	dd ?
OP_ARGformat	dd ?
OP_argp		dd ?
else
OP_argp		dd ?
OP_ARGformat	dd ?
OP_ARGfile	dd ?
endif
S_OUTPUT 	ENDS

	.code

OPST_normal:
	mov	al,dl

OUTPUT_PUTC:
	LPES	rbx,[rbp].S_OUTPUT.OP_filep
	dec	PEBX.S_FILE.iob_cnt
	jl	OPPUTC_00
	inc	WORDP PEBX.S_FILE.iob_bp
	LPES	rbx,PEBX.S_FILE.iob_bp
	mov	PEBX-1,al
    OPPUTC_01:
	inc	[rbp].S_OUTPUT.OP_charsout
	ret
    OPPUTC_00:
      ifdef __CDECL__
	pushm	[rbp].S_OUTPUT.OP_filep
	push	rax
      else
	push	rax
	pushm	[rbp].S_OUTPUT.OP_filep
      endif
	call	output_flush
	cmp	rax,-1
	jne	OPPUTC_01
	mov	[rbp].S_OUTPUT.OP_charsout,rax
	ret

OUTPUT_GETD:	; Get DWORD from stack
    ifndef __f__
	lea	bx,[bp].S_OUTPUT.OP_argp
	mov	ax,[bx+2]
	add	word ptr [bx],4
	mov	bx,[bx]
	mov	es,ax
      ifdef __3__
	mov	eax,es:[bx-4]
      else
	mov	ax,es:[bx-4]
	mov	dx,es:[bx-2]
      endif
    else
	mov	ebx,[ebp].S_OUTPUT.OP_argp
	add	[ebp].S_OUTPUT.OP_argp,4
	mov	eax,[ebx]
	xor	edx,edx
    endif
	ret

ifndef __f__
OUTPUT_GETW:	; Get WORD from stack
	lea	bx,[bp].S_OUTPUT.OP_argp
	mov	ax,[bx+2]
	add	word ptr [bx],2
	mov	bx,[bx]
	mov	es,ax
	mov	ax,es:[bx-2]
	ret
else
OUTPUT_GETQ: 	; Get QWORD from stack
	mov	ebx,[ebp].S_OUTPUT.OP_argp
	add 	[ebp].S_OUTPUT.OP_argp,8
	mov	eax,[ebx]
	mov	edx,[ebx+4]
	ret
endif

OPST_percent:
	sub	rax,rax
	mov	[rbp].S_OUTPUT.OP_no_output,rax
	mov	[rbp].S_OUTPUT.OP_fldwidth,rax
	mov	[rbp].S_OUTPUT.OP_prefixlen,rax
	mov	[rbp].S_OUTPUT.OP_capitalize,rax
	mov	rsi,rax	; bufferiswide (default)
	mov	rdi,rax	; precision
	dec	rdi
	ret

OPST_flag:
	mov al,dl
	.if al == '+'
	    or rsi,FLAG_SIGN    	; '+' force sign indicator
	.elseif al == ' '
	    or rsi,FLAG_SIGNSP  	; ' ' force sign or space
	.elseif al == '#'
	    or rsi,FLAG_ALTERNATE	; '#' alternate form
	.elseif al == '-'
	    or rsi,FLAG_LEFT		; '-' left justify
	.elseif al == '0'
	    or rsi,FLAG_LEADZERO	; '0' pad with leading zeros
	.endif
	ret

OPST_width:
	.if dl == '*'
	  ifndef __f__
	    call OUTPUT_GETW
	  else
	    call OUTPUT_GETD
	  endif
	    mov [rbp].S_OUTPUT.OP_fldwidth,rax
	    cmp rax,0
	    jge @F
	    or  rsi,4
	    neg rax
	    mov [rbp].S_OUTPUT.OP_fldwidth,rax
	  @@:
	.else
	    CBI  dl
	    push rax
	    mov  rax,[rbp].S_OUTPUT.OP_fldwidth
	    mov  rdx,10
	    imul rdx
	    pop  rdx
	    add  rdx,rax
	    add  rdx,-48
	    mov  [rbp].S_OUTPUT.OP_fldwidth,rdx
	.endif
	ret

OPST_dot:
	sub rdi,rdi
	ret

OPST_precision:
	.if dl == '*'
	  ifndef __f__
	    call OUTPUT_GETW
	  else
	    call OUTPUT_GETD
	  endif
	    mov rdi,rax
	    cmp rax,0
	    jge @F
	    mov rdi,-1
	.else
	    CBI  dl
	    push rax
	    mov  rax,rdi
	    mov  rdx,10
	    imul rdx
	    pop  rdx
	    add  rdx,rax
	    add  rdx,-48
	    mov  rdi,rdx
	.endif
      @@:
	ret

OPST_size:
	.if dl == 'l'
	    or rsi,FLAG_LONG
	.endif
	ret

OPST_type:
	sub rbx,rbx
	mov rcx,16
	.repeat
	    .if dl == formchar[rbx]
	    	shl rbx,size_l/2
		call output_proctab[rbx]
		.break
	    .endif
	    inc rbx
	.untilcxz
	call OUTPUT
	ret

OUTPUT_b:
	push	rsi
      ifndef __f__
	call	OUTPUT_GETW
      else
	call	OUTPUT_GETD
      endif
	test	rsi,FLAG_LONG
	mov	rsi,16
	jnz	OUTPB_00
	mov	rsi,8
    OUTPB_00:
	mov	[rbp].S_OUTPUT.OP_count,rsi
    OUTPB_01:
	mov	rdx,rax
	xor	rcx,rcx
    OUTPB_02:
	mov	rax,rdx
	shr	rax,cl
	and	rax,1
	add	rax,48
	mov	[rbp].S_OUTPUT.OP_buffer[rsi-1],al
	inc	rcx
	dec	rsi
	jnz	OUTPB_02
	pop	rsi
	jmp	OUTPUT_LDTEXT

OUTPUT_c:
      ifndef __f__
	call	OUTPUT_GETW
      else
	call	OUTPUT_GETD
      endif
	mov	rdx,rax
	mov	[rbp].S_OUTPUT.OP_buffer,al
	mov	[rbp].S_OUTPUT.OP_count,1

OUTPUT_LDTEXT:
	lea	rax,[rbp].S_OUTPUT.OP_buffer
	mov16	WORDP [bp].S_OUTPUT.OP_text+2,ss
	mov	WORDP [rbp].S_OUTPUT.OP_text,rax
	ret

OUTPUT_s:
	.if rdi == -1
	    mov rcx,7FFFh
	.else
	    mov rcx,rdi
	.endif
	call	OUTPUT_GETD
      ifdef __16__
	mov	word ptr [bp].S_OUTPUT.OP_text+2,dx
	mov	word ptr [bp].S_OUTPUT.OP_text,ax
	or	ax,dx
      else
      	mov	[rbp].S_OUTPUT.OP_text,eax
	test	eax,eax
      endif
	jnz	OUTPS_02
    OUTPS_NULL:
	mov16	word ptr [bp].S_OUTPUT.OP_text+2,ds
	mov	WORDP [rbp].S_OUTPUT.OP_text,offset nullstring
    OUTPS_02:
	LPES	rbx,[rbp].S_OUTPUT.OP_text
    OUTPS_03:
	cmp	byte ptr PEBX,0
	je	OUTPS_04
	inc	rbx
	dec	rcx
	jnz	OUTPS_03
    OUTPS_04:
      ifndef __f__
	sub	bx,word ptr [bp].S_OUTPUT.OP_text
      else
	sub	ebx,[ebp].S_OUTPUT.OP_text
      endif
	mov	[rbp].S_OUTPUT.OP_count,rbx
	ret

OUTPUT_n:
	call	OUTPUT_GETD
	LPES	rbx,PEBX-4
	test	rsi,FLAG_LONG
	jnz	@F
	mov	rax,[rbp].S_OUTPUT.OP_charsout
	mov	PEBX,rax
	ret
      @@:
	mov	rax,[rbp].S_OUTPUT.OP_charsout
	mov	PEBX,rax
	mov	[rbp].S_OUTPUT.OP_no_output,1
	ret

OUTPUT_p:
	mov	rdi,8
	or	rsi,FLAG_LONG

OUTPUT_xu:
	mov	[rbp].S_OUTPUT.OP_hexoff,'A'-'9'-1
	jmp	OPCOMMONHEX

OUTPUT_x:
	mov	[rbp].S_OUTPUT.OP_hexoff,'a'-'9'-1

OPCOMMONHEX:
	mov	[rbp].S_OUTPUT.OP_curadix,16
	test	rsi,FLAG_ALTERNATE
	jz	@F
	mov	[rbp].S_OUTPUT.OP_prefix,'0'
	mov	[rbp].S_OUTPUT.OP_prefix+1,'x'
	mov	[rbp].S_OUTPUT.OP_prefixlen,2
      @@:
	test	rsi,FLAG_LONG
	jnz	OUTPUT_LONGINT
	cmp	[rbp].S_OUTPUT.OP_fldwidth,2
	jne	OUTPUT_SHORTINT
      ifndef __f__
	call	OUTPUT_GETW
      else
	call	OUTPUT_GETD
      endif
	and	rax,00FFh
	jmp	OUTPUT_UNSIGNED

OUTPUT_o:
	mov	[rbp].S_OUTPUT.OP_curadix,8
	test	rsi,FLAG_ALTERNATE
	jz	OUTPUT_GENINT
	or	rsi,FLAG_FORCEOCTAL
	jmp	OUTPUT_GENINT

OUTPUT_d:
	or	rsi,FLAG_SIGNED

OUTPUT_u:
	mov	[rbp].S_OUTPUT.OP_curadix,10

OUTPUT_GENINT:
	test	rsi,FLAG_LONG
	jz	OUTPUT_SHORTINT

OUTPUT_LONGINT:
      ifndef __f__
	call	OUTPUT_GETD
      else
	call	OUTPUT_GETQ
      endif
	jmp	OUTPUT_NUMBER

OUTPUT_SHORTINT:
      ifndef __f__
	call	OUTPUT_GETW
      else
	call	OUTPUT_GETD
      endif
	test	rsi,FLAG_SIGNED
	jz	OUTPUT_UNSIGNED
      ifndef __f__
       ifdef __3__
	movsx eax,ax
       else
	cwd
       endif
      else
	cmp	eax,0
	jnl	OUTPUT_NUMBER
	dec	edx
      endif
      	jmp	OUTPUT_NUMBER

OUTPUT_UNSIGNED:
ifndef __f__
  ifdef __3__
	movzx eax,ax
  else
	xor dx,dx
  endif
endif

OUTPUT_NUMBER:
      ifndef __f__
       ifdef __3__
	mov	[bp].S_OUTPUT.OP_ddtemp,eax
	test	si,FLAG_SIGNED
	jz	@F
	cmp	eax,0
	jnl	@F
	neg	eax
	or	si,FLAG_NEGATIVE
      @@:
	mov	[bp].S_OUTPUT.OP_number,eax
       else
	stom	[bp].S_OUTPUT.OP_ddtemp
	test	si,FLAG_SIGNED
	jz	@F
	test	dx,dx
	jns	@F
	neg	ax
	neg	dx
	sbb	dx,0
	or	si,FLAG_NEGATIVE
      @@:
	stom	[bp].S_OUTPUT.OP_number
       endif
      else
	test	esi,FLAG_SIGNED
	jz	@F
	test	edx,edx
	jns	@F
	neg	eax
	neg	edx
	sbb	edx,0
	or	esi,FLAG_NEGATIVE
      @@:
	mov	[ebp].S_OUTPUT.OP_numeax,eax
	mov	[ebp].S_OUTPUT.OP_numedx,edx
      endif
	test	rdi,rdi
	jnl	OPNUM_01
	mov	rdi,1
	jmp	OPNUM_02
    OPNUM_01:
	and	rsi,-9
    OPNUM_02:
  ifdef __3__
	test	eax,eax
  else
	test	rax,rax
	jnz	OPNUM_03
	test	rdx,rdx
  endif
	jnz	OPNUM_03
	mov	[rbp].S_OUTPUT.OP_prefixlen,rax
    OPNUM_03:
	lea	rax,[rbp].S_OUTPUT.OP_buffer+512-1
	mov16	word ptr [bp].S_OUTPUT.OP_text+2,ss
	mov	WORDP [rbp].S_OUTPUT.OP_text,rax
	jmp	OPNUM_06
    OPNUM_04:
    ifdef __16__
	mov	bx,[bp].S_OUTPUT.OP_curadix
	xor	cx,cx
	lodm	[bp].S_OUTPUT.OP_number
	call	_div32
	stom	[bp].S_OUTPUT.OP_number
	add	bx,'0'
	mov	cx,bx
    else
      ifdef __f__
	mov	ecx,[ebp].S_OUTPUT.OP_curadix
	mov	eax,[ebp].S_OUTPUT.OP_numeax
	mov	edx,[ebp].S_OUTPUT.OP_numedx
	call	_div64
	mov	[ebp].S_OUTPUT.OP_numeax,eax
	mov	[ebp].S_OUTPUT.OP_numedx,edx
	add	ecx,'0'
      else
	movzx	ebx,[bp].S_OUTPUT.OP_curadix
	mov	eax,[bp].S_OUTPUT.OP_number
	sub	edx,edx
	div	ebx
	mov	[bp].S_OUTPUT.OP_number,eax
	add	dx,'0'
	mov	cx,dx
      endif
    endif
	cmp	rcx,'9'
	jng	OPNUM_05
	add	rcx,[rbp].S_OUTPUT.OP_hexoff
    OPNUM_05:
	LPES	rbx,[rbp].S_OUTPUT.OP_text
	mov	PEBX,cl
    ifndef __f__
	dec	word ptr [bp].S_OUTPUT.OP_text
    else
	dec	[ebp].S_OUTPUT.OP_text
    endif
    OPNUM_06:
	mov	rcx,rdi
	dec	rdi
	test	rcx,rcx
	jg	OPNUM_04
    ifdef __3__
	test	eax,eax
    else
	or	rax,rdx
    endif
	jnz	OPNUM_04
	lea	rax,[rbp].S_OUTPUT.OP_buffer+512-1
    ifndef __f__
	sub	ax,word ptr [bp].S_OUTPUT.OP_text
	mov	[bp].S_OUTPUT.OP_count,ax
	inc	word ptr [bp].S_OUTPUT.OP_text
    else
	sub	eax,[ebp].S_OUTPUT.OP_text
	mov	[ebp].S_OUTPUT.OP_count,eax
	inc	[ebp].S_OUTPUT.OP_text
    endif
	test	rsi,FLAG_FORCEOCTAL
	jz	OUTPUT_dummy
	LPES	rbx,[rbp].S_OUTPUT.OP_text
	cmp	byte ptr PEBX,'0'
	jne	OPNUM_07
	cmp	[rbp].S_OUTPUT.OP_count,0
	jne	OUTPUT_dummy
    OPNUM_07:
	dec	rbx
	mov	WORDP [rbp].S_OUTPUT.OP_text,rbx
	mov	byte ptr PEBX,'0'
	inc	[rbp].S_OUTPUT.OP_count
OUTPUT_dummy:
	ret

OUTPUT_MULTI:
	push	rsi
	push	rdi
	ZXAX
	mov	rsi,rax
	mov	rdi,rdx
	jmp	OPMULTI_01
    OPMULTI_00:
	mov	rax,rsi
	call	OUTPUT_PUTC
	cmp	[rbp].S_OUTPUT.OP_charsout,-1
	je	OPMULTI_02
    OPMULTI_01:
	mov	rax,rdi
	dec	rdi
	test	rax,rax
	jg OPMULTI_00
    OPMULTI_02:
	pop	rdi
	pop	rsi
	ret

OUTPUT_STRING:
	push16	di
	push	rsi
	mov16	di,ax
	mov	rsi,rcx
	mov	rbx,rdx
	jmp	OPSTR_01
    OPSTR_00:
	mov16	es,di
	mov	al,PEBX
	inc	rbx
	push	rbx
	call	OUTPUT_PUTC
	pop	rbx
	cmp	[rbp].S_OUTPUT.OP_charsout,-1
	jz	OPSTR_02
    OPSTR_01:
	mov	rax,rsi
	dec	rsi
	or	rax,rax
	jg	OPSTR_00
    OPSTR_02:
	pop	rsi
	pop16	di
	ret

OUTPUT:
	sub	rax,rax
	cmp	rax,[rbp].S_OUTPUT.OP_no_output
	je	OUTPUT_00
	ret
    OUTPUT_00:
	test	rsi,FLAG_SIGNED
	jz	OUTPUT_03
	test	rsi,FLAG_NEGATIVE
	jz	OUTPUT_01
	mov	[rbp].S_OUTPUT.OP_prefix,'-'
	mov	[rbp].S_OUTPUT.OP_prefixlen,1
	jmp	OUTPUT_03
    OUTPUT_01:
	test	rsi,FLAG_SIGN
	jz 	OUTPUT_02
	mov	[rbp].S_OUTPUT.OP_prefix,43
	mov	[rbp].S_OUTPUT.OP_prefixlen,1
	jmp	OUTPUT_03
    OUTPUT_02:
	test	rsi,FLAG_SIGNSP
	jz	OUTPUT_03
	mov	[rbp].S_OUTPUT.OP_prefix,' '
	mov	[rbp].S_OUTPUT.OP_prefixlen,1
    OUTPUT_03:
	mov	rax,[rbp].S_OUTPUT.OP_fldwidth
	sub	rax,[rbp].S_OUTPUT.OP_count
	sub	rax,[rbp].S_OUTPUT.OP_prefixlen
	mov	[rbp].S_OUTPUT.OP_padding,rax
	test	rsi,FLAG_LEFT or FLAG_LEADZERO
	jnz	OUTPUT_04
	mov	rdx,rax
	mov	rax,' '
	call	OUTPUT_MULTI
    OUTPUT_04:
	mov16	ax,ss
	lea	rdx,[rbp].S_OUTPUT.OP_prefix
	mov	rcx,[rbp].S_OUTPUT.OP_prefixlen
	call	OUTPUT_STRING
	test	rsi,FLAG_LEADZERO
	jz	OUTPUT_05
	test	rsi,FLAG_LEFT
	jnz	OUTPUT_05
	mov	rax,'0'
	mov	rdx,[rbp].S_OUTPUT.OP_padding
	call	OUTPUT_MULTI
    OUTPUT_05:
	cmp	[rbp].S_OUTPUT.OP_count,0
	jng	OUTPUT_08
	movmx	[rbp].S_OUTPUT.OP_ddtemp,[rbp].S_OUTPUT.OP_text
	mov	rax,[rbp].S_OUTPUT.OP_count
	mov	[rbp].S_OUTPUT.OP_dwtemp,rax
	jmp	OUTPUT_07
    OUTPUT_06:
	LPES	rbx,[rbp].S_OUTPUT.OP_ddtemp
	inc	WORDP [rbp].S_OUTPUT.OP_ddtemp
	mov	al,PEBX
	call	OUTPUT_PUTC
    OUTPUT_07:
	mov	rax,[rbp].S_OUTPUT.OP_dwtemp
	dec	[rbp].S_OUTPUT.OP_dwtemp
	or	rax,rax
	jg	OUTPUT_06
	jmp	OUTPUT_09
    OUTPUT_08:
	mov16	ax,word ptr [bp].S_OUTPUT.OP_text+2
	mov	rdx,WORDP [rbp].S_OUTPUT.OP_text
	mov	rcx,[rbp].S_OUTPUT.OP_count
	call	OUTPUT_STRING
    OUTPUT_09:
	test	rsi,FLAG_LEFT
	jz	OUTPUT_10
	mov	rax,' '
	mov	rdx,[rbp].S_OUTPUT.OP_padding
	call	OUTPUT_MULTI
    OUTPUT_10:
	ret

_output proc _CType public uses rdx rcx rbx rsi rdi rbp filep:dword,
	format:dword, argp:dword
local	OP[S_OUTPUT.OP_STACK]:byte
	lea rbp,OP
	movmx [rbp].S_OUTPUT.OP_format,[rbp].S_OUTPUT.OP_ARGformat
	movmx [rbp].S_OUTPUT.OP_filep,[rbp].S_OUTPUT.OP_ARGfile
	sub rax,rax
	mov [rbp].S_OUTPUT.OP_count,rax
	mov [rbp].S_OUTPUT.OP_charsout,rax
	mov [rbp].S_OUTPUT.OP_state,rax
	.repeat
	    LPES rbx,[rbp].S_OUTPUT.OP_format
	  ifdef __16__
	    inc word ptr [rbp].S_OUTPUT.OP_format
	  else
	    inc [rbp].S_OUTPUT.OP_format
	  endif
	    ZXAX byte ptr PEBX
	    mov rdx,rax
	    .break .if !al
	    .break .if [rbp].S_OUTPUT.OP_charsout > 7FFFh
	    .if al < ' ' || al > 'x'
		sub rax,rax
	    .else
		mov rbx,rax
		mov al,cl_table[rbx-32]
		and rax,15
	    .endif
	    mov rcx,rax
	    mov rbx,rax
	    shl rbx,3
	    add rbx,[rbp].S_OUTPUT.OP_state
	    mov al,cl_table[rbx]
	    shr rax,4
	    mov [rbp].S_OUTPUT.OP_state,rax
	    mov rbx,rax
	    .if rax <= 7
	      ifdef __f__
		shl ebx,2
	      else
		add bx,bx
	      endif
		call OPST_table[rbx]
	    .endif
	.until 0
	mov rax,[rbp].S_OUTPUT.OP_charsout
	ret
_output	endp

	end
