include	clib.inc
include	iost.inc

	.code

ocopy	proc _CType public uses rsi len:dword
ifndef	__f__
	push	di
	mov	di,word ptr len
	mov	si,word ptr len+2
	test	si,si
	jnz	ocopy_start
	test	di,di
	jnz	ocopy_start	; copy zero byte -- ok
    ocopy_success:
	xor	ax,ax
	inc	ax
	jmp	ocopy_end
    ocopy_start:
	mov	ax,STDI.ios_c	; flush inbuf
	sub	ax,STDI.ios_i
	or	si,si
	jnz	ocopy_bigbuf
	cmp	ax,di
	jae	ocopy_inbuf
    ocopy_bigbuf:
	test	ax,ax
	jz	ocopy_block
    ocopy_inbuf:
	call	ogetc
	jz	ocopy_end
	call	oputc
	jz	ocopy_end
	sub	di,ax
	sbb	si,0
	mov	ax,si
	or	ax,di
	jz	ocopy_success	; success if zero (inbuf > len)
	mov	ax,STDI.ios_i
	cmp	ax,STDI.ios_c
	jne	ocopy_inbuf	; do byte copy from STDI to STDO
    ocopy_block:
	call	oflush		; flush STDO
	jz	ocopy_end	; do block copy of bytes left
	push	STDO.ios_size
	pushm	STDO.ios_bp
	movmx	STDO.ios_bp,STDI.ios_bp
	mov	ax,STDI.ios_size
	mov	STDO.ios_size,ax
    ocopy_next:
	call	ofread
	jz	ocopy_eof
	mov	ax,STDI.ios_c	; count
	test	si,si
	jnz	ocopy_more
	cmp	ax,di
	jae	ocopy_last
    ocopy_more:
	sub	di,ax
	sbb	si,0
	mov	STDO.ios_i,ax	; fill STDO
	mov	STDI.ios_i,ax	; flush STDI
	call	oflush		; flush STDO
	jnz	ocopy_next	; copy next block
    ocopy_exit:
	mov	dx,ax
      ifdef __3__
      	pop	eax
	mov	STDO.ios_bp,eax
      else
	pop	ax
	mov	word ptr STDO.ios_bp,ax
	pop	ax
	mov	word ptr STDO.ios_bp+2,ax
      endif
	pop	ax
	mov	STDO.ios_size,ax
	mov	ax,dx
    ocopy_end:
    	pop	di
	ret
    ocopy_last:
	mov	STDI.ios_i,di
	mov	STDO.ios_i,di
	call	oflush
	jmp	ocopy_exit
    ocopy_eof:
	xor	ax,ax
	test	si,di
	jnz	ocopy_exit
	inc	ax
	jmp	ocopy_exit
else
	mov	esi,len
	test	esi,esi
	jnz	ocopy_start
    ocopy_success:
	sub	eax,eax
	inc	eax
	jmp	ocopy_end
    ocopy_start:
	mov	eax,STDI.ios_c	; flush inbuf
	sub	eax,STDI.ios_i
	cmp	eax,esi
	jae	ocopy_inbuf
	test	eax,eax
	jz	ocopy_block
    ocopy_inbuf:
	call	ogetc
	jz	ocopy_end
	call	oputc
	jz	ocopy_end
	sub	esi,eax
	jz	ocopy_success	; success if zero (inbuf > len)
	mov	eax,STDI.ios_i
	cmp	eax,STDI.ios_c
	jne	ocopy_inbuf	; do byte copy from STDI to STDO
    ocopy_block:
	call	oflush		; flush STDO
	jz	ocopy_end	; do block copy of bytes left
	push	STDO.ios_size
	push	STDO.ios_bp
	mov	eax,STDI.ios_bp
	mov	STDO.ios_bp,eax
	mov	eax,STDI.ios_size
	mov	STDO.ios_size,eax
    ocopy_next:
	call	ofread
	jz	ocopy_eof
	mov	eax,STDI.ios_c	; count
	cmp	eax,esi
	jae	ocopy_last
    ocopy_more:
	sub	esi,eax
	mov	STDO.ios_i,eax	; fill STDO
	mov	STDI.ios_i,eax	; flush STDI
	call	oflush		; flush STDO
	jnz	ocopy_next	; copy next block
    ocopy_exit:
	mov	edx,eax
      	pop	eax
	mov	STDO.ios_bp,eax
	pop	eax
	mov	STDO.ios_size,eax
	mov	eax,edx
    ocopy_end:
	ret
    ocopy_last:
	mov	STDI.ios_i,esi
	mov	STDO.ios_i,esi
	call	oflush
	jmp	ocopy_exit
    ocopy_eof:
	sub	eax,eax
	test	esi,esi
	jnz	ocopy_exit
	inc	eax
	jmp	ocopy_exit
endif
ocopy	endp

	end
