include	clib.inc
include	clip.inc
include	conio.inc
include	tinfo.inc
include	keyb.inc
include	mouse.inc
include	string.inc
include	dos.inc
include	ctype.inc

ifdef __TE__
tienter		proto
tienterni	proto
tigetline	proto 		; AX line
tiexpand	proto
tistrip		proto
tistripl	proto
tistripline	proto
tiremline	proto
tistyle		proto
endif
	.data

ti_keytable label size_t
	d? _TI_CONTINUE
	d? KEY_ESC
	d? KEY_LEFT
	d? KEY_RIGHT
	d? KEY_HOME
	d? KEY_END
	d? KEY_BKSP
	d? KEY_TAB
	d? KEY_DEL
	d? MOUSECMD
	d? KEY_CTRLRIGHT
	d? KEY_CTRLLEFT
	d? KEY_ENTER
	d? KEY_KPENTER
	d? KEY_UP
	d? KEY_DOWN
ifdef __TE__
	d? KEY_PGUP
	d? KEY_PGDN
	d? KEY_CTRLPGUP
	d? KEY_CTRLPGDN
	d? KEY_CTRLHOME
	d? KEY_CTRLEND
	d? KEY_CTRLUP	; Scroll up one line
	d? KEY_CTRLDN	; Scroll down one line
endif

ti_proctab label size_t
	d? ticontinue
	d? tiesc
	d? tileft
	d? tiright
	d? tihome
	d? titoend
	d? tibacksp
	d? titab
	d? tidelete
	d? timouse
	d? tinextword
	d? tiprevword
  ifdef __TE__
	d? tienter
	d? tienter
	d? tiup
	d? tidown
	d? tipgup
	d? tipgdn
	d? tictrlhome
	d? tictrlend
	d? tictrlpgup
	d? tictrlpgdn
	d? tiscrollup
	d? tiscrolldn
  else
	d? tiesc
	d? tiesc
	d? tiesc
	d? tiesc
  endif

ti_key_count = (($ - offset ti_proctab) / size_l)

	cp_linetolong db 'Line too long, was truncated',0
public	cp_linetolong

	.code
	ASSUME	bx?:ptr S_TINFO

tinocando proc public
	invoke	beep,9,1
	mov	ax?,_TI_CMFAILED	; end of line/buffer
	ret
tinocando endp

ticurlp proc public uses bx?
	mov	bx?,tinfo
    ifdef __TE__
	mov	ax?,[bx?].ti_loff	; this return ZF set if	NULL
	add	ax?,[bx?].ti_yoff
	call	tigetline
	jz	@F
	call	tistrlen
	test	dx?,dx?
      @@:
    else
	lodm	[bx?].ti_bp
    endif
	ret
ticurlp endp

ticurcp proc public uses bx?
	mov	bx?,tinfo
	call	ticurlp
	add	ax?,[bx?].ti_boff	; no ZF flag if	__TE__
	add	ax?,[bx?].ti_xoff
	ret
ticurcp endp

ticontinue proc public
	sub ax?,ax?
	ret
ticontinue endp

tiretevent proc public
	mov ax?,_TI_RETEVENT
	ret
tiretevent endp

tiesc proc public
	jmp tiretevent
tiesc endp

tiback proc public uses bx?
	mov bx?,tinfo
	sub ax?,ax?
	.if cx? == [bx?].ti_xoff
	    .if cx? == [bx?].ti_boff
		mov ax?,_TI_CMFAILED
	    .else
		dec [bx?].ti_boff
	    .endif
	.else
	    dec [bx?].ti_xoff
	.endif
	ret
tiback	endp

tileft	proc public
	sub  cx?,cx?
	call tiback
	ret
tileft	endp

tiincvalue proc pascal public uses si? di? dx? boff:dword, soff:dword,
	bmax:size_t, smax:size_t
	mov si?,word_ptr boff
	mov di?,word_ptr soff
	mov ax?,[si?]
	add ax?,[di?]
	inc ax?
	.if ax? >= bmax
	    sub ax?,ax?
	.else
	    mov dx?,[si?]
	    mov ax?,[di?]
	    inc ax?
	    .if ax? >= smax
		mov ax?,smax
		dec ax?
		inc dx?
	    .endif
	    mov [di?],ax?
	    mov [si?],dx?
	.endif
	ret
tiincvalue endp

tiincx proc public uses bx? ax?
	mov bx?,tinfo
	invoke tiincvalue,addr [bx?].ti_boff,addr [bx?].ti_xoff,
		[bx?].ti_bcol,[bx?].ti_cols
	ret
tiincx endp

tiright	proc public uses di? bx?
	mov	bx?,tinfo
    ifdef __TE__
	test	[bx?].ti_flag,_T_LINEBUF
	jz	@F
	call	tiincx
	jmp	tiright_ok
      @@:
    endif
	call	ticurcp
	mov?	es,dx
	mov	di?,ax?
	mov	al,edi?
	sub	di?,[bx?].ti_xoff
	test	al,al
	jz	tiright_00
	mov	ax?,[bx?].ti_cols
	dec	ax?
	cmp	ax?,[bx?].ti_xoff
	jbe	tiright_00
	inc	[bx?].ti_xoff
    tiright_ok:
	call	ticontinue
    tiright_end:
	ret
    tiright_00:
	invoke	strlen,esdi
	cmp	ax?,[bx?].ti_cols
	jb	tiright_eof
	inc	[bx?].ti_boff
	jmp	tiright_ok
    tiright_eof:
	call	tinocando
	jmp	tiright_end
tiright	endp

tihome proc public uses bx?
    ifdef __TE__
	call	tistripline
    endif
	mov	bx?,tinfo
	sub	ax?,ax?
	mov	[bx?].S_TINFO.ti_xoff,ax?
	mov	[bx?].S_TINFO.ti_boff,ax?
	ret
tihome endp

titoend proc public uses bx?
    ifdef __TE__
	call	tistripline
    endif
	mov	bx?,tinfo
	mov	dx?,[bx?].ti_cols
	dec	dx?
	mov	ax?,[bx?].ti_bcnt
	cmp	ax?,dx?
	jle	@F
	mov	ax?,dx?
      @@:
	mov	[bx?].ti_xoff,ax?
	mov	dx?,[bx?].ti_bcnt
	sub	dx?,[bx?].ti_cols
	inc	dx?
	xor	ax?,ax?
	cmp	ax?,dx?
	jg	@F
	mov	ax?,dx?
      @@:
	mov	[bx?].ti_boff,ax?
	add	ax?,[bx?].ti_xoff
	cmp	ax?,[bx?].ti_bcnt
	jbe	@F
	dec	[bx?].ti_boff
      @@:
	call	ticontinue
	ret
titoend endp

; set byte count in line to .ti_bcnt
; set line[size-1]=0
; return CX strlen(DX:AX)

tistrlen proc public uses si? di? bx?
	mov	bx?,tinfo
	push?	es
	mov?	es,dx
	mov	si?,ax?
	mov	di?,ax?
	xor	ax?,ax?
	add	di?,[bx?].S_TINFO.ti_bcol
	dec	di?
	mov	edi?,al
	mov	di?,si?
	mov	cx?,ax?
	dec	cx?
	cld?
	repnz	scasb
	not	cx?
	dec	cx?
	mov	[bx?].S_TINFO.ti_bcnt,cx?
	mov	ax?,si?
	pop?	es
	ret
tistrlen endp

tidecvalue proc pascal public uses si? di? dx? boff:dword, soff:dword,
	bmax:size_t, smax:size_t
	mov si?,word_ptr boff
	mov di?,word_ptr soff
	mov ax?,[si?]
	add ax?,[di?]
	.if ax?
	    mov dx?,[si?]
	    mov ax?,[di?]
	    .if ax?
		dec ax?
		and si?,si?
		stc
	    .else
		dec dx?
		and si?,si?
		clc
	    .endif
	    mov [di?],ax?
	    mov [si?],dx?
	.endif
	ret
tidecvalue endp

tidecx proc public uses ax? bx?
	mov	bx?,tinfo
	invoke	tidecvalue,addr [bx?].S_TINFO.ti_boff,addr [bx?].S_TINFO.ti_xoff,
		[bx?].S_TINFO.ti_bcol,[bx?].S_TINFO.ti_cols
	ret
tidecx endp

tialignx proc public uses bx? cx?
	mov	bx?,tinfo
	mov	cx?,[bx?].S_TINFO.ti_xoff
	add	cx?,[bx?].S_TINFO.ti_boff
	cmp	cx?,ax?
	jb	tialignx_inc
	je	tialignx_end
    tialignx_dec:
	call	tidecx
	jz	tialignx_end
	dec	cx?
	cmp	ax?,cx?
	jne	tialignx_dec
	jmp	tialignx_ok
    tialignx_inc:
	call	tiincx
	jz	tialignx_end
	inc	cx?
	cmp	ax?,cx?
	jne	tialignx_inc
    tialignx_ok:
	inc	cx?
    tialignx_end:
	ret
tialignx endp

ifdef __TE__

tidoiflines proc public
	mov	ax?,tinfo
    ifdef __f__
	test	[eax].S_TINFO.ti_flag,_T_LINEBUF
    else
	xchg	ax,bx
	test	[bx].S_TINFO.ti_flag,_T_LINEBUF
	xchg	ax,bx
    endif
	jnz	@F
	pop	ax?
	jmp	tiretevent
      @@:
    ifdef __TE__
	push	ax?
	call	tistripline
	pop	ax?
    endif
	ret
tidoiflines endp

tiup	proc public
	call tidoiflines
	push bx?
	mov bx?,ax?
	sub ax?,ax?
	.if ax? != [bx?].S_TINFO.ti_yoff
	    dec [bx?].S_TINFO.ti_yoff
	.elseif ax? != [bx?].S_TINFO.ti_loff
	    dec [bx?].S_TINFO.ti_loff
	.endif
    	pop bx?
	ret
tiup	endp

tidown	proc public
	call	tidoiflines
	push	bx?
	mov	bx?,ax?
	mov	dx?,[bx?].ti_loff
	mov	cx?,[bx?].ti_yoff
	mov	ax?,dx?
	add	ax?,cx?
	inc	ax?
	cmp	ax?,[bx?].ti_brow
	jae	tidown_retevent
	cmp	ax?,[bx?].S_TEDIT.ti_lcnt
	jae	tidown_continue
	mov	ax?,[bx?].ti_rows
	dec	ax?
	cmp	cx?,ax?
	jae	@F
	inc	[bx?].ti_yoff
	jmp	tidown_continue
      @@:
	mov	ax?,[bx?].ti_brow
	sub	ax?,dx?
	sub	ax?,cx?
	jz	tidown_retevent
	dec	ax?
	jz	tidown_retevent
	inc	[bx?].ti_loff
    tidown_continue:
    	pop	bx?
	jmp	ticontinue
    tidown_retevent:
    	pop	bx?
	jmp	tiretevent
tidown	endp

tipgup	proc public
	call	tidoiflines
	push	bx?
	mov	bx?,ax?
	mov	ax?,[bx?].ti_loff
	test	ax?,ax?
	jz	tipgup_tictrlhome
	cmp	ax?,[bx?].ti_rows
	jb	tipgup_tictrlhome
	sub	ax?,[bx?].ti_rows
	mov	[bx?].ti_loff,ax?
    tipgup_continue:
    	pop	bx?
	jmp	ticontinue
    tipgup_tictrlhome:
    	pop	bx?
	jmp	tictrlhome
tipgup	endp

tipgdn	proc	public
	call	tidoiflines
	push	bx?
	mov	bx?,ax?
	mov	ax?,[bx?].S_TINFO.ti_rows
	add	ax?,ax?
	add	ax?,[bx?].S_TINFO.ti_loff
	cmp	ax?,[bx?].S_TEDIT.ti_lcnt
	jnb	tipgdn_ctrlend
	mov	ax?,[bx?].S_TINFO.ti_loff
	add	ax?,[bx?].S_TINFO.ti_rows
	mov	[bx?].S_TINFO.ti_loff,ax?
    tipgdn_continue:
    	pop	bx?
	jmp	ticontinue
    tipgdn_ctrlend:
    	pop	bx?
	jmp	tictrlend
tipgdn	endp

tictrlpgup proc public
	call	tidoiflines
	push	bx?
	mov	bx?,ax?
	sub	ax?,ax?
	mov	[bx?].S_TINFO.ti_yoff,ax?
	pop	bx?
	ret
tictrlpgup endp

tictrlpgdn proc public
	call	tidoiflines
	push	bx?
	mov	bx?,ax?
	mov	ax?,[bx?].S_TINFO.ti_rows
	dec	ax?
	mov	[bx?].S_TINFO.ti_yoff,ax?
	add	ax?,[bx?].S_TINFO.ti_loff
	cmp	ax?,[bx?].S_TEDIT.ti_lcnt
	pop	bx?
	jb	@F
	ret
      @@:
	jmp	tictrlend
tictrlpgdn endp

tictrlend proc public
	call	tidoiflines
    ifdef __f__
	mov	eax,[eax].S_TEDIT.ti_lcnt
    else
	xchg	bx?,ax?
	mov	bx?,[bx?].S_TEDIT.ti_lcnt
	xchg	bx?,ax?
    endif
	dec	ax?
	call	tialigny
	jmp	ticontinue
tictrlend endp

tictrlhome proc public
	call	tictrlpgup
	push	bx?
	mov	bx?,tinfo
	mov	[bx?].S_TINFO.ti_loff,ax?
	pop	bx?
	ret
tictrlhome endp

tiscrollup proc public
	call	tidoiflines
	push	bx?
	mov	bx?,ax?
	sub	ax?,ax?
	cmp	ax?,[bx?].S_TINFO.ti_loff
	je	@F
	dec	[bx?].S_TINFO.ti_loff
      @@:
      	pop	bx?
	ret
tiscrollup endp

tiscrolldn proc public
	call	tidoiflines
	push	bx?
	mov	bx?,ax?
	mov	ax?,[bx?].S_TINFO.ti_loff
	add	ax?,[bx?].S_TINFO.ti_yoff
	inc	ax?
	cmp	ax?,[bx?].S_TEDIT.ti_lcnt
	jae	@F
	inc	[bx?].S_TINFO.ti_loff
      @@:
      	pop	bx?
	jmp	ticontinue
tiscrolldn endp

tidecy proc public uses bx? ax?
	mov	bx?,tinfo
	invoke	tidecvalue,addr [bx?].S_TINFO.ti_loff,addr [bx?].S_TINFO.ti_yoff,
		[bx?].S_TINFO.ti_brow,[bx?].S_TINFO.ti_rows
	ret
tidecy endp

tiincy proc public uses si? bx? ax?
	mov	bx?,tinfo
	mov	si?,[bx?].ti_rows
	test	[bx?].ti_flag,_T_USEMENUS
	jz	@F
	dec	si?
      @@:
	invoke	tiincvalue,addr [bx?].S_TINFO.ti_loff,addr [bx?].S_TINFO.ti_yoff,
		[bx?].S_TINFO.ti_brow,si?
	ret
tiincy endp

tialigny proc public uses bx? cx?
	mov	bx?,tinfo	; Align yoff and loff to AX
	mov	cx?,[bx?].S_TINFO.ti_yoff
	add	cx?,[bx?].S_TINFO.ti_loff
	cmp	cx?,ax?
	jb	tialigny_inc
	je	tialigny_end
      @@:
	call	tidecy
	jz	tialigny_end
	dec	cx?
	cmp	ax?,cx?
	jne	@B
	jmp	tialigny_ok
    tialigny_inc:
	call	tiincy
	jz	tialigny_end
	inc	cx?
	cmp	ax?,cx?
	jne	tialigny_inc
    tialigny_ok:
	inc	cx?
    tialigny_end:
	ret
tialigny endp

endif

tiseto proc public uses si? di? bx?
	call	ticurlp
	mov	di?,ax?
  ifdef __TE__
	jz	tiseto_00
	mov	bx?,2020h
	call	tistripl
	mov	bx?,tinfo
	mov	ax?,[bx?].ti_boff	; test if char is visible
	add	ax?,[bx?].ti_xoff
	cmp	ax?,cx?
	jbe	tiseto_00
	test	[bx?].ti_flag,_T_LINEBUF
	jz	tiseto_01
	add	di?,cx?			; length of line
	mov?	es,dx			; ES to segment
	mov	cx?,ax?
	sub	cx?,[bx?].ti_bcnt	; CX to pad count
   ifdef _PADD_WITH_TABS
	test	[bx?].ti_flag,_T_OPTIMALFILL
	jz	tiseto_space
    tiseto_tab:
	mov	dx?,di?			; insert '\t' if possible
	add	dx?,cx?
	mov	ax?,di?
	and	ax?,not 7
	add	ax?,8
	cmp	ax?,dx?
	ja	tiseto_space
	sub	ax?,di?
	mov	ah,al
	mov	al,9
      @@:
	stosb
	mov	al,TITABCHAR
	dec	cx?
	dec	ah
	jnz	@B
	jmp	tiseto_tab
    tiseto_space:			; padd the rest with ' '
   endif
	mov	ax?,' '
	cld?
	rep	stosb
	mov	al,ah
	stosb
	jmp	tiseto_01
  else
	mov	bx?,tinfo
	mov	cx?,ax?
	add	cx?,[bx?].ti_bcol
	dec	cx?
	mov?	es,dx
	mov	bx?,cx?
	mov	byte ptr ebx?,0
	invoke	strlen,dxax
	mov	dx?,ax?
	mov	bx?,tinfo
	mov	[bx?].ti_bcnt,ax?
	mov	ax?,[bx?].ti_boff	; test if char is visible
	add	ax?,[bx?].ti_xoff
	cmp	ax?,dx?
	jb	tiseto_00
  endif
    tiseto_toend:
	call	titoend			; if not --> to end of line
    tiseto_01:
	mov	ax?,1
    tiseto_end:
	ret
    tiseto_00:
	xor	ax?,ax?
	jmp	tiseto_end
	ret
tiseto endp

tibacksp proc public uses bx?
	mov bx?,tinfo
	xor cx?,cx?
	mov ax?,[bx?].ti_boff
	add ax?,[bx?].ti_xoff
	.if ax?
	    call tiback
	    jmp tibacksp_delete
	.else
  ifdef __TE__
	    .if [bx?].ti_flag & _T_LINEBUF
		mov ax?,[bx?].ti_loff
		add ax?,[bx?].ti_yoff
		.if ax?
		    .if [bx?].ti_yoff != cx?
			dec [bx?].ti_yoff
		    .else
			dec [bx?].ti_loff
		    .endif
		    jmp @F
		.endif
	    .endif
  endif
	    call tinocando
	    jmp tibacksp_end
	.endif
      @@:
	call tiseto
	call titoend
    tibacksp_delete:
	call tidelete
    tibacksp_end:
	ret
tibacksp endp

ifdef	__TE__

tistr0B proc uses di? bx? ax?
	mov	di?,ax?
	mov	bx?,ax?
	mov	ax?,2000h+TITABCHAR
	cmp	edi?,al
	jne	tistr0B_end
	mov	edi?,ah
	cmp	edi?+1,al
	jne	@F
	mov	byte ptr edi?,9
      @@:
	or	di?,di?
	jz	tistr0B_end
      @@:
	dec	di?
	cmp	edi?,al
	jne	@F
	mov	edi?,ah
	or	di?,di?
	jnz	@B
      @@:
	cmp	byte ptr edi?,9
	jne	tistr0B_end
	mov	edi?,ah
    tistr0B_end:
	ret
tistr0B endp

endif

tiputc_add:
	mov	ax?,[bx?].ti_bcnt
	inc	ax?
	cmp	ax?,[bx?].ti_bcol
	jae	tiputc_eof
  ifdef __TE__
	call	tiincx
	jz	tiputc_eof
	inc	[bx?].ti_bcnt
	push	cx?
	call	ticurlp
	pop	cx?
	jz	tiputc_eof
	or	[bx?].ti_flag,_T_MODIFIED
	mov?	es,dx
	add	ax?,[bx?].ti_xoff
	add	ax?,[bx?].ti_boff
	test	[bx?].ti_flag,_T_LINEBUF
	jnz	tiputc_lbuf
    tiputc_insert:
	dec	ax?
	mov	bx?,ax?
	mov	ah,cl
    tiputc_addcl:
	mov	al,ebx?
	mov     ebx?,ah
	mov	ah,al
	inc	bx?
	or	al,al
	jnz	tiputc_addcl
	mov     ebx?,al
	jmp	tiputc_CONTINUE
    tiputc_lbuf:
	dec	ax?
	push	ax?
	call	tistr0B
	call	tistrip
	inc	ax?
	call	tiputc_insert
	pop	ax?
	push	cx?
	call	tiexpand
	push	ax?
	call	ticurlp
	pop	cx?
	mov	bx?,ax?
	mov	ah,' '
      @@:
	cmp	bx?,cx?
	je	@F
	mov	al,ebx?
	inc	bx?
	or	al,al
	jnz	@B
	mov	ebx?-1,ah
	jmp	@B
      @@:
	pop	cx?
	mov	bx?,tinfo
	cmp	cl,9
	jne	tiputc_CONTINUE
	mov	ax?,[bx?].ti_xoff	; Align xoff and boff to next TAB
	add	ax?,[bx?].ti_boff
	mov	cx?,ax?
	test	al,7
	jz	tiputc_CONTINUE
	and	al,0F8h
	add	al,8
	cmp	cx?,ax?			; Align xoff and boff to AX
	jb	tiputc_inc
	je	tiputc_CONTINUE
    tiputc_dec:
	call	tidecx
	jz	tiputc_CONTINUE
	dec	cx?
	cmp	ax?,cx?
	jne	tiputc_dec
	jmp	tiputc_CONTINUE
    tiputc_inc:
	call	tiincx
	jz	tiputc_CONTINUE
	inc	cx?
	cmp	ax?,cx?
	jne	tiputc_inc
  else
	push	cx?
	call	ticurcp
	push	si?
	push	di?
	mov	cx?,[bx?].ti_bcol
	sub	cx?,[bx?].ti_xoff
	sub	cx?,[bx?].ti_boff
	dec	cx?
	mov?	ds,dx
	mov?	es,dx
	mov	di?,ax?
	mov	si?,ax?
	inc	di?
	dec	cx?
	mov	ax?,si?
	add	si?,cx?
	add	di?,cx?
	inc	cx?
	std
	rep	movsb
	cld
	mov	bx?,ax?
	pop	di?
	pop	si?
	pop	ax?
	mov	[bx?],al
	mov?	ax,ss
	mov?	ds,ax
	mov	bx?,tinfo
	inc	[bx?].ti_bcnt
	inc	[bx?].ti_xoff
	mov	ax?,[bx?].ti_cols
	cmp	[bx?].ti_xoff,ax?
	jl	tiputc_CONTINUE
	dec	ax?
	mov	[bx?].ti_xoff,ax?
	add	ax?,[bx?].ti_boff
	cmp	[bx?].ti_bcnt,ax?
	jbe	tiputc_CONTINUE
	inc	[bx?].ti_boff
  endif
    tiputc_CONTINUE:
	mov	ax?,_TI_CONTINUE
	ret
  ifdef __TE__
    tiputc_strbuf:
  else
    tiputc_CONTROL:
  endif
	or	al,al
	jz	tiputc_ret
	test	[bx?].ti_flag,_T_USECONTROL
	jnz	tiputc_add
    tiputc_ret:
	mov	ax?,_TI_RETEVENT
	ret
    tiputc_eof:
  ifdef __TE__
	mov	ax?,[bx?].ti_bcol
	dec	ax?
	mov	[bx?].ti_bcnt,ax?
	invoke	ermsg,0,addr cp_linetolong
    tiputc_nocando:
  endif
	jmp	tinocando
  ifdef __TE__
    tiputc_ENTER:
	jmp	tienterni
    tiputc_CONTROL:
	test	[bx?].ti_flag,_T_LINEBUF
	jz	tiputc_strbuf
	cmp	al,9
	je	tiputc_TAB
	cmp	al,0Ah
	je	tiputc_ENTER
	cmp	al,0Dh
	je	tiputc_CONTINUE
	jmp	tiputc_ret
    tiputc_TAB:
	call	tiputc_add
	cmp	ax?,_TI_CONTINUE
	jne	tiputc_nocando
	jmp	tiputc_CONTINUE
  endif


tiputc proc public uses bx?
	mov bx?,tinfo
	mov cx?,ax?
	call getctype
	.if ah & _CONTROL
	    call tiputc_CONTROL
	.else
	    call tiputc_add
	.endif
	ret
tiputc endp


titab proc public uses bx?
	mov bx?,tinfo
	.if [bx?].ti_flag & _T_LINEBUF
	    call tiputc
	    call ticontinue
	.else
	    call tiretevent
	.endif
	ret
titab endp

tidelete proc public uses si? di? bp? bx?
	mov  bx?,tinfo
	call ticurcp
	mov? es,dx
	mov  di?,ax?
	or   [bx?].ti_flag,_T_MODIFIED
    	.if  byte ptr edi? == 0
    ifdef __TE__
	    .if [bx?].S_TINFO.ti_flag & _T_LINEBUF
		mov ax?,[bx?].S_TINFO.ti_loff
		add ax?,[bx?].S_TINFO.ti_yoff
		inc ax?
		.if ax? < [bx?].ti_brow && ax? < [bx?].S_TEDIT.ti_lcnt
		    call tigetline
		    .if !CARRY?
			push ax?
			invoke strlen,dxax
			add ax?,[bx?].ti_bcnt
			mov cx?,ax?
			pop ax?
			.if cx? < [bx?].ti_bcol
			    sub sp?,[bx?].ti_bcol	; add next line to this
			    mov bp?,sp?
			  ifdef __f__
			    invoke strcpy,ebp,eax
			  else
			    invoke strcpy,ss::bp,dx::ax
			  endif
			    mov ax?,[bx?].S_TINFO.ti_loff
			    add ax?,[bx?].S_TINFO.ti_yoff
			    mov si?,ax?
			    call tigetline
			    .if !CARRY?
			      ifdef __f__
			      	invoke strcat,eax,ebp
			      else
			      	invoke strcat,dx::ax,ss::bp
			      endif
				add sp?,[bx?].S_TINFO.ti_bcol
				inc si?
				mov ax?,si?
				mov dx?,1
				call tiremline
			    .endif
			.endif
		    .endif
		.endif
	    .endif
    endif
	.else
    ifdef __TE__
	    .if [bx?].S_TINFO.ti_flag & _T_LINEBUF
		call tistrip
		mov bx?,ax?
		.if al & 7
		    mov ah,ebx?
		    mov al,ebx?-1
		    .if al == 9
			mov byte ptr ebx?-1,' '
			jmp @F
		    .elseif al == TITABCHAR
			mov di?,bx?
			mov ah,' '
			.repeat
			    dec di?
			    .break .if edi? != al
			    mov edi?,ah
			.until !di?
			mov edi?,ah
			jmp @F
		    .endif
		.endif
		.repeat
		    mov   ax?,bx?
		    push? dx
		    push  ax?
		    inc   ax?
		    push? dx
		    push  ax?
		    call  strcpy
		.until byte ptr ebx? != TITABCHAR
	      @@:
		mov  ax?,bx?
		call tiexpand
		mov  bx?,tinfo
		or   [bx?].S_TINFO.ti_flag,_T_MODIFIED
		jmp  @F
	    .endif
    endif
	    dec [bx?].S_TINFO.ti_bcnt
	    mov cx?,ax?
	    inc cx?
	  ifdef __f__
      	    invoke strcpy,eax,ecx
	  else
      	    invoke strcpy,dx::ax,dx::cx
	  endif
	.endif
      @@:
	call ticontinue
	ret
tidelete endp

tiisword proc public
	call	getctype
	and	ah,_UPPER or _LOWER or _DIGIT
	jnz	@F
	cmp	al,'_'
	jne	tiisword_nul
	test	al,al
      @@:
	ret
    tiisword_nul:
	cmp	al,al
	ret
tiisword endp

tinextword proc public uses si? bp?
	push?	ds
	call	ticurcp
	mov	bp?,tinfo
	mov?	ds,dx
	mov	si?,ax?
	mov	dx?,ax?
	cld?
      @@:
	lodsb
	call	tiisword
	jnz	@B
	test	al,al
	jz      tinextword_eof
      @@:
	lodsb
	test	al,al
	jz      tinextword_eof
	call	tiisword
	jz	@B
	dec	si?
	sub	si?,dx?
	mov	ax?,[bp?].S_TINFO.ti_boff
	add	ax?,[bp?].S_TINFO.ti_xoff
	add	ax?,si?
	cmp	ax?,[bp?].S_TINFO.ti_bcnt
	ja	tinextword_eof
	mov	ax?,si?
	add	ax?,[bp?].S_TINFO.ti_xoff
	mov	dx?,[bp?].S_TINFO.ti_cols
	cmp	ax?,dx?
	jb	@F
	dec	dx?
	sub	ax?,dx?
	add	[bp?].S_TINFO.ti_boff,ax?
	mov	ax?,dx?
     @@:
	mov	[bp?].S_TINFO.ti_xoff,ax?
	pop?	ds
	call	ticontinue
    tinextword_end:
	ret
    tinextword_eof:
	; next line..
	pop?	ds
	call	titoend
	jmp	tinextword_end
tinextword endp

tiprevword proc public uses si? di? bp?
	mov?	di,ds
	mov	bp?,tinfo
	mov	ax?,[bp?].S_TINFO.ti_boff
	add	ax?,[bp?].S_TINFO.ti_xoff
	test	ax?,ax?
	jz	tiprevword_eof
	mov	si?,ax?
	mov	cx?,ax?
	call	ticurlp
	mov?	ds,dx
	mov	dx?,ax?
	add	si?,ax?
	std
	lodsb
	inc	si?
	call	tiisword
	jnz	tiprevword_start
	test	al,al
	jnz	tiprevword_l1
	dec	si?
    tiprevword_l1:
	lodsb
	cmp	si?,dx?
	jbe	tiprevword_eof
	test	al,al
	jz	tiprevword_eof
	call	tiisword
	jz	tiprevword_l1
    tiprevword_l2:
	lodsb
	cmp	si?,dx?
	jbe	tiprevword_eof
	test	al,al
	jz	tiprevword_eof
	call	tiisword
	jnz	tiprevword_l2
	mov	ax?,si?
	cld
	mov?	ds,di
	sub	ax?,dx?
	add	ax?,2
	cmp	ax?,[bp?].S_TINFO.ti_xoff
	ja	tiprevword_boff
	mov	[bp?].S_TINFO.ti_xoff,ax?
	jmp	tiprevword_continue
    tiprevword_start:
	mov	al,[si?-1]
	call	tiisword
	jnz	tiprevword_l2
	dec	si?
	jmp	tiprevword_l1
    tiprevword_boff:
	sub	ax?,[bp?].S_TINFO.ti_xoff
	mov	[bp?].S_TINFO.ti_xoff,0
	sub	[bp?].S_TINFO.ti_boff,ax?
    tiprevword_continue:
	call	ticontinue
    tiprevword_end:
    	ret
    tiprevword_eof:
	cld
	mov?	ds,di
	call	tihome
	jmp	tiprevword_end
tiprevword endp

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

tiinitcursor proc public
	push	bx?
	mov	bx?,tinfo
	mov     [bx?].S_TINFO.ti_cursor.cr_type,CURSOR_NORMAL
    ifdef __f__
	mov	[ebx].S_TINFO.ti_cursor.cr_size,CURSOR_SIZE
    endif
	pop	bx?
tiinitcursor endp

tisetcursor proc public uses bx?
	mov	bx?,tinfo
	mov	ax?,[bx?].ti_xpos
	add	ax?,[bx?].ti_xoff
	mov?	ah,byte ptr [bx?].ti_ypos
    ifdef __f__
	mov	edx,[ebx].ti_ypos
    endif
    ifdef __TE__
	test	[bx?].ti_flag,_T_LINEBUF
	jz	@F
    ifndef __f__
	add	ah,byte ptr [bx?].ti_yoff
    else
	add	edx,[bx?].ti_yoff
    endif
      @@:
    endif
    ifdef __f__
	shl	edx,16
	or	eax,edx
    endif
	mov	[bx?].ti_cursor.cr_xy,ax?
	mov	[bx?].ti_cursor.cr_type,CURSOR_NORMAL
	invoke	cursorset,addr [bx?].ti_cursor
	ret
tisetcursor endp

timouse proc uses bx?
  ifdef __MOUSE__
	mov	bx?,tinfo
	call	mousey
   ifdef __TE__
	mov	dx?,ax?
	call	mousex
	mov	cx?,ax?
	mov	ax?,[bx?].ti_xpos
	cmp	cx?,ax?
	jb	timouse_esc
	add	ax?,[bx?].ti_cols
	cmp	cx?,ax?
	jae	timouse_esc
	mov	ax?,[bx?].ti_ypos
	cmp	dx?,ax?
	jb	timouse_esc
	add	ax?,[bx?].ti_rows
	cmp	dx?,ax?
	jae	timouse_esc
	sub	dx?,[bx?].ti_ypos
	mov	[bx?].ti_yoff,dx?
	push	cx?
	call	ticurlp
	jz	@F
	invoke	strlen,dxax
     @@:
	pop	cx?
	sub	cx?,[bx?].ti_xpos
	cmp	cx?,ax?
	jg	@F
	mov	ax?,cx?
     @@:
	mov	[bx?].ti_xoff,ax?
	call	tisetcursor
	call	msloop
   else
	cmp	ax?,[bx?].ti_ypos
	jne	timouse_esc
	call	mousex
	mov	dx?,[bx?].ti_xpos
	cmp	al,dl
	jb	timouse_esc
	add	dx?,[bx?].ti_cols
	cmp	ax?,dx?
	jnb	timouse_esc
	sub	ax?,[bx?].ti_xpos
	mov	[bx?].ti_xoff,ax?
	lodm	[bx?].ti_bp
	add	ax?,[bx?].ti_boff
	invoke	strlen,dxax
	cmp	ax?,[bx?].ti_xoff
	jnb	@F
	mov	[bx?].ti_xoff,ax?
      @@:
	mov	ax?,[bx?].ti_xpos
	add	ax?,[bx?].ti_xoff
	invoke	gotoxy,ax?,[bx?].ti_ypos
	call	msloop
   endif ; __TE__
	call	ticontinue
    timouse_end:
	ret
    timouse_esc:
	call	tiesc
	jmp	timouse_end
  else
	call	ticontinue
	ret
  endif ; __MOUSE__
timouse endp

tievent	proc public
	mov	dx?,bx?
	mov	cx?,ti_key_count
	xor	bx?,bx?
    tievent_loop:
    	test	cx,cx
	jz	tievent_break
	cmp	ax?,ti_keytable[bx?]
	jne	tievent_next
	mov	bx?,ti_proctab[bx?]
	xchg	bx?,dx?
	jmp	dx?
    tievent_next:
	add	bx?,size_l
	dec	cx?
	jnz	tievent_loop
    tievent_break:
	mov	bx?,dx?
	call	tiputc
	ret
tievent	endp

tiputl	proc public uses si? di? bx?
local	lb[2+TIMAXSCRLINE]:byte
local	wc[2*TIMAXSCRLINE]:byte
local	line:size_t	; current line 0..max
local	loff:size_t	; adress of line
local	lseg:size_t
local	llen:size_t	; length of line
local	clst:size_t	; clip start
local	clen:size_t	; clip end
	mov si?,tinfo
	ASSUME si?:ptr S_TINFO
  ifdef __TE__
	mov	line,ax?
	mov	ah,[si?].ti_clat
	mov	al,[si?].ti_clch
	test	[si?].ti_flag,_T_USESTYLE
	jz	@F
	mov	ah,[si?].S_TEDIT.ti_stat
	mov	al,[si?].S_TEDIT.ti_stch
      @@:
  else
	mov	ah,[si?].ti_clat
	mov	al,[si?].ti_clch
  endif
	push?	ss
	pop?	es
	lea	dx?,wc
	mov	di?,dx?
	mov	cx?,TIMAXSCRLINE
	cld?
	rep	stosw
	mov	di?,dx?
  ifdef __TE__
	mov	ax?,line
	call	tigetline
	mov	loff,ax?
	mov?	lseg,dx
	jz	tiputl_screen
  else
	lodm	[si?].ti_bp
	mov	loff,ax?
	mov?	lseg,dx
  endif
      ifndef __f__
	push	dx
	push	ax
      endif
	lea	bx?,lb
	add	ax?,[si?].ti_boff
      ifdef __f__
	invoke	memcpy,ebx,eax,TIMAXSCRLINE
	mov	[ebx+TIMAXSCRLINE],cl
	invoke	strlen,loff
      else
	invoke	memcpy,ss::bx,dx::ax,TIMAXSCRLINE
	mov	[bx+TIMAXSCRLINE],cl
	call	strlen
	mov	es,dx
      endif
	mov	llen,ax?
	cmp	ax?,[si?].ti_boff
	jbe	tiputl_color
	xchg	si?,bx?
	mov	cx?,TIMAXSCRLINE
    tiputl_cl:
	lodsb
	or	al,al
	jz	tiputl_break
	cmp	al,TITABCHAR
	jne	@F
	mov	al,' '
    @@:
	cmp	al,9
	jne	@F
	test	[bx?].S_TINFO.ti_flag,_T_SHOWTABS
	jnz	@F
	mov	al,' '
    @@:
	stosb
	inc	di?
	dec	cx?
	jnz	tiputl_cl
    tiputl_break:
	mov	si?,bx?
  ifdef __TE__
	test	[si?].ti_flag,_T_USESTYLE
	jz	tiputl_color
	push?	es
	mov	ax?,loff
	mov?	di,lseg
	lea	dx?,wc
	mov	cx?,llen
	mov	bx?,line
	call	tistyle
	pop?	es
  endif
    tiputl_color:
  ifdef __CLIP__
	xor	ax?,ax?
	mov	clen,ax?	; clip end to   0000
	dec	ax?		; clip start to FFFF
	mov	clst,ax?
	call	tiselected
	jz	tiputl_screen
  ifdef __TE__
	xor	dx?,dx?
	cmp	word_ptr [si?].ti_bp,dx?
	jne	tiputl_local
	mov	ax?,line
	cmp	ax?,[si?].ti_clsl
	jb	tiputl_screen
	je	tiputl_clst
	cmp	ax?,[si?].ti_clel
	ja	tiputl_screen
	mov	clst,dx?
	je      tiputl_clen
	dec	dx?
	mov	clen,dx?
	jmp	tiputl_clput
    tiputl_clen:
	mov	ax?,[si?].ti_cleo
	mov	clen,ax?
	jmp	tiputl_clput
    tiputl_clst:
	dec	dx?
	mov	clen,dx?
	cmp	ax?,[si?].ti_clel
	mov	ax?,[si?].ti_clso
	mov	clst,ax?
	je	tiputl_clen
	jmp	tiputl_clput
    tiputl_local:
  endif
	mov	ax?,[si?].ti_clso
	add	ax?,word_ptr [si?].ti_bp
	mov	clst,ax?
	mov	ax?,[si?].ti_cleo
	add	ax?,word_ptr [si?].ti_bp
	mov	clen,ax?
    tiputl_clput:
	mov	cx?,TIMAXSCRLINE
	lea	di?,wc+1
	mov	al,at_background[B_DarkGray]
	mov	bx?,loff
	add	bx?,[si?].ti_boff
	mov	dx?,clst
    tiputl_cloop:
	cmp	bx?,dx?
	jb	@F
	cmp	bx?,clen
	jae	tiputl_screen
	stosb
	jmp	tiputl_inc
    @@:
	inc	di?
    tiputl_inc:
	inc	bx?
	inc	di?
	dec	cx?
	jnz	tiputl_cloop
  endif
    tiputl_screen:
	mov	ax?,[si?].ti_xpos
	mov	dx?,[si?].ti_ypos
    ifdef __TE__
	add	dx?,line
	sub	dx?,[si?].ti_loff
    endif
    ifdef __f__
    ;
	mov	ecx,[esi].ti_cols
	lea	esi,wc
	mov	ebx,eax
      @@:
	mov	eax,[esi]
	add	esi,2
	invoke	scputw,ebx,edx,1,eax
	inc	ebx
	dec	ecx
	jnz	@B
    else
	HideMouseCursor
	invoke	getxyp,ax,dx
	mov	es,dx
	mov	di,ax
	mov	cx,[si].ti_cols
	lea	si,wc
	assert	cx,TIMAXSCRLINE,jna,"tiputl"
	rep	movsw
	ShowMouseCursor
    endif
	xor	ax?,ax?
	ret
tiputl	endp

tiputs proc public
	call	tisetcursor
    ifdef __TE__
	push	si?
	push	di?
	mov	di?,tinfo
	mov	si?,[di?].S_TINFO.ti_rows
	mov	di?,[di?].S_TINFO.ti_loff
	.if !si?
	    inc si?
	.endif
	.while si?
	    mov  ax?,di?
	    call tiputl
	    inc  di?
	    dec  si?
	.endw
	pop	di?
	pop	si?
    else
	sub	ax?,ax?
	call	tiputl
    endif
	ret
tiputs endp


timodal proc public uses si? di?
	mov si?,_TI_CONTINUE
	.while si? != _TI_RETEVENT
	    call tiseto
	    call tiputs
	    call tgetevent
	  ifdef __CLIP__
	    call ticlipevent
	  endif
	    mov  di?,ax?
	    call tievent
	    mov  si?,ax?
	.endw
	call	ticurlp
	invoke	strlen,dxax
	mov	si?,tinfo
	mov	[si?].S_TINFO.ti_bcnt,ax?
	mov	ax?,di?
	ret
timodal endp

	end
