include	clib.inc
ifdef __TE__
include	clip.inc
include	wsub.inc
include	string.inc
include	stdio.inc
include	conio.inc
include	tinfo.inc
include	keyb.inc
include	mouse.inc
include	alloc.inc
include	dos.inc
include	io.inc
include	iost.inc
include	ctype.inc
ifdef __DLL__
 include io.inc
 include dos.inc
 include plugins.inc
endif
ifdef __DZ__
 include fblk.inc
else
externdef	IDD_TEHelp:dword
endif
externdef	IDD_TEReload:dword
externdef	IDD_TEReload2:dword
externdef	IDD_TESave:dword
externdef	IDD_TEOpenFiles:dword
externdef	IDD_TESeek:dword
externdef	IDD_Replace:dword
externdef	IDD_ReplacePrompt:dword

externdef	cp_noname:byte
externdef	cp_enomem:byte
externdef	format_u:byte
externdef	cp_linetolong:byte

ticurcp		proto
ticurlp		proto
tiseto		proto
tiputs		proto
ticontinue	proto
tihome		proto
tidown		proto
tialignx	proto
tialigny	proto
tinocando	proto
tireadstyle	proto
tihome		proto
tiputc		proto
titoend		proto
tievent		proto
tiprevword	proto
tinextword	proto
tidoiflines	proto
tiretevent	proto

ifdef __DZ__
DZHELP_EDIT	equ 4003
view_readme	proto _CType
endif

;-----------------------------------------------------------------------------
; Alloc file buffer
;-----------------------------------------------------------------------------

	.data
	emmp	dd 0		; Allocated page
	curh	d? -1		; Current owners handle
	curp	d? -1		; Current page for this handle

	.code
	ASSUME	si?:ptr S_TINFO

	;--------------------------------------------------------------
	; Validate tinfo (AX)
	; return CX .ti_flag, DL .dl_flag, ES:AX dialog
	;--------------------------------------------------------------

tistate proc _CType public uses bx?
	mov	bx?,ax?
	test	ax?,ax?
	jz	@F
	sub	ax?,ax?
	mov	cx?,[bx?].S_TINFO.ti_flag
	les?	bx?,[bx?].S_TEDIT.ti_dialog
	test	bx?,bx?
	jz	@F
	test	cx?,_T_MALLOC
	jz	@F
	test	cx?,_T_LINEBUF
	jz	@F
	mov	dl,byte ptr ebx?.S_DOBJ.dl_flag
	test	dl,_D_DOPEN
	jz	@F
	mov	ax?,bx?
      @@:
	ret
tistate endp

tialloc proc public uses si? di? bx?
	xor	di?,di?
	mov	si?,ax?
	cmp	tepages,EMSMINPAGES
	jb	tialloc_lokal
	call	emminit
	jz	tialloc_lokal
	call	emmcoreleft
	jz	tialloc_lokal
	mov	ax?,cx?
	cmp	ax?,EMSMINPAGES
	jb	tialloc_lokal
	cmp	ax?,tepages
	jb	@F
	mov	ax?,tepages
      @@:
	mov	di?,ax?
	lodm	emmp
	test	dx?,dx?		; same page for all files..
	jnz	@F
	mov	ax?,0402h
	call	palloc
	jz	tialloc_fail
	inc	dx?		; + 16
	xor	ax?,ax?		; zero offset
	stom	emmp
      @@:
	stom	[si?].ti_bp	; base pointer to page
	or	[si?].ti_flag,_T_MALLOC
	invoke	emmalloc,di?
	inc	ax?
	jz	tialloc_emmfail
	mov	[si?].S_TEDIT.ti_emmh,dx?
	mov	[si?].S_TEDIT.ti_emmp,0
	or	[si?].ti_flag,_T_EMMBUF
	jmp	tialloc_style
    tialloc_fail?:
	mov	ax?,si?
	call	tifree
    tialloc_fail:
	invoke	ermsg,0,addr cp_enomem
	sub	ax?,ax?
	jmp	tialloc_end
    tialloc_emmfail:
	mov	ax?,si?
	call	tifree
    tialloc_lokal:
	mov	ax?,tinfo
	call	tistate
	jnz	tialloc_fail
	mov	ax?,4004h
	call	palloc
	jz	tialloc_fail
	inc	dx?
	xor	ax?,ax?
	or	[si?].ti_flag,_T_MALLOC
	stom	[si?].ti_bp
	mov	di?,16
    tialloc_style:
	mov	ax?,((STYLESIZE + WMAXPATH) / 16) + 1
	call	palloc
	jz	tialloc_fail?
	invoke	strcpy,dxax,addr cp_noname
	stom	[si?].S_TEDIT.ti_file
	add	ax,WMAXPATH
	stom	[si?].S_TEDIT.ti_style
	invoke	memzero,dxax,STYLESIZE
	mov	ax?,telsize
	mov     [si?].ti_bcol,ax?
	mov	bx?,ax?
	sub	ax?,ax?
	mov	dx?,ax?
	inc	dx?
	div	bx?
	shr	di?,2
	mul	di?
	mov	[si?].ti_brow,ax?
	mov	ax?,si?
	call	timemzero
	inc	ax?
    tialloc_end:
	ret
tialloc endp

tifree	proc public uses si?
	mov	si?,ax?
	mov	ax?,[si?].ti_flag
	test	ax?,_T_MALLOC or _T_EMMBUF
	jz	tifree_end
	test	ax?,_T_EMMBUF
	jz	@F
	invoke	emmfree,[si?].S_TEDIT.ti_emmh
	mov	ax?,-1
	mov	curh,ax?		; Force a reread of the page
	mov	curp,ax?
	jmp	tifree_name
      @@:
	mov	ax?,[si?].ti_flag
	test	ax?,_T_MALLOC
	jz	tifree_end
      ifdef __f__
	invoke	free,[esi].ti_bp
      else
	mov	ax,word ptr [si].ti_bp[2] ; free seg - 1
	dec	ax
	invoke	free,ax::ax		; free() only use segment..
      endif
    tifree_name:
	invoke	free,[si?].S_TEDIT.ti_file
    tifree_end:
	and	[si?].ti_flag,not (_T_MALLOC or _T_EMMBUF)
	ret
tifree	endp

;-----------------------------------------------------------------------------
; Open
;-----------------------------------------------------------------------------

tigetfile proc _CType public uses bx?
	sub ax?,ax?	; AX first file
	mov dx?,ax?	; DX last file
	mov bx?,tinfo
	.if bx?
	    .if [bx?].S_TINFO.ti_flag & _T_FILE
		mov dx?,bx?
		.repeat
		    mov ax?,bx?
		    mov bx?,[bx?].S_TEDIT.ti_prev
		    .break .if !bx?
		.until bx? == dx?
		mov bx?,dx?
		.repeat
		    mov dx?,bx?
		    mov bx?,[bx?].S_TEDIT.ti_next
		    .break .if !bx?
		.until bx? == ax?
		inc bx?
	    .endif
	.endif
	ret
tigetfile endp

tiopen proc public uses si? bx?
	.if func(nalloc,SIZE S_TEDIT)
	    push ax?
	    invoke memzero,ssax,SIZE S_TEDIT
	    pop si?
	    mov al,at_background[B_Desktop]
	    or  al,at_foreground[F_Desktop]
	    mov [si?].ti_clat,al
	    mov [si?].S_TEDIT.ti_stat,al
	    mov dl,al
	    .if func(dlscreen,addr [si?].S_TEDIT.ti_DOBJ,dx?)
		stom [si?].S_TEDIT.ti_dialog
		xor ax?,ax?
		mov [si?].ti_xpos,ax?
		mov [si?].ti_ypos,ax?
		mov [si?].ti_cursor.cr_xy,ax?
		mov [si?].ti_cursor.cr_type,CURSOR_NORMAL
		mov al,[si?].S_TEDIT.ti_DOBJ.dl_rect.S_RECT.rc_col
		mov [si?].ti_cols,ax?
		mov al,[si?].S_TEDIT.ti_DOBJ.dl_rect.S_RECT.rc_row
		mov [si?].ti_rows,ax?
		mov al,' '
		mov [si?].ti_clch,al
		mov [si?].S_TEDIT.ti_stch,al
		mov ax?,si?
		.if func(tialloc)
		    .if func(tigetfile)
			mov bx?,dx?
			mov [si?].S_TEDIT.ti_prev,bx?	; Link to last file
			mov [bx?].S_TEDIT.ti_next,si?
		    .endif
		    mov  ax?,teflag
		    and  ax?,_T_TESAVEMASK
		    or   [si?].ti_flag,ax?
		    mov  ax?,si?
		    test ax?,ax?
		    jmp  @F
		.endif
		invoke dlclose,[si?].S_TEDIT.ti_dialog
	    .endif
	    invoke nfree,si?
	    xor ax?,ax?
	.endif
      @@:
	ret
tiopen endp

;-----------------------------------------------------------------------------
; Get line from buffer
;-----------------------------------------------------------------------------

tipushh	proc
	mov	ax?,curh
	cmp	ax?,-1
	je	@F
	cmp	ax?,[si?].S_TEDIT.ti_emmh
	je	tipushh_end
	invoke	emmwrite,emmp,curh,curp
      @@:
	mov	ax?,[si?].S_TEDIT.ti_emmh
	mov	curh,ax?
	mov	ax?,[si?].S_TEDIT.ti_emmp
	mov	curp,ax?
	invoke	emmread,emmp,curh,curp
    tipushh_end:
	ret
tipushh	endp

tigetline proc public 	; Get line from <tinfo> - tigetline(AX) --> DX:AX
	mov	dx?,tinfo
tigetline endp

timemline proc public 	; Get line from <[dx]> - timemline(AX,DX) --> DX:AX
	push	si?
	push	di?
	mov	di?,ax?
	mov	si?,dx?
	mov	ax?,[si?].ti_flag
	test	ax?,_T_LINEBUF
	jz	timemline_nol
	cmp	di?,[si?].ti_brow
	jnb	timemline_null
	test	ax?,_T_EMMBUF
	mov	ax?,[si?].ti_bcol
	jz	timemline_malloc
	mov	ax?,[si?].S_TEDIT.ti_emmh	; Init current EMM handle
	cmp	curh,ax?		; same handle ?
	je	@F
	call	tipushh
      @@:
	mov	ax?,[si?].ti_bcol
	shl	ax?,2			; align segment
	mul	di?   			; DX to page
	cmp	dx?,[si?].S_TEDIT.ti_emmp
	je	timemline_pageok
	push	dx?
	push	ax?
	push	dx?
	invoke	emmwrite,[si?].ti_bp,[si?].S_TEDIT.ti_emmh,[si?].S_TEDIT.ti_emmp
	pop	ax?
	invoke	emmread,[si?].ti_bp,[si?].S_TEDIT.ti_emmh,ax?
	test	ax?,ax?
	pop	ax?
	pop	dx?
	jnz	timemline_null
    timemline_pageok:
	mov	[si?].S_TEDIT.ti_emmp,dx?	; save page offset
	mov	curp,dx?
	shr	ax?,6
    timemline_ok:
	add	ax,word ptr [si].ti_bp+2 ; + segment
	mov	dx?,ax?
	xor	ax?,ax?
	cmp	di?,[si?].S_TEDIT.ti_lcnt
	jnb	timemline_new
	test	dx?,dx?
	clc       			; Carry set if new line
    timemline_end:
	pop	di?
	pop	si?
	ret
    timemline_null:			; ZF and CF set on error
	xor	ax?,ax?
	mov	dx?,ax?
	jmp	timemline_new
    timemline_nol:
	lodm	[si?].ti_bp
    timemline_new:
	test	dx?,dx?
	stc
	jmp	timemline_end
    timemline_malloc:
	shr	ax?,4			; line size in para
	mul	di?			; * line offset
	jmp	timemline_ok
timemline endp

timemzero proc public uses si? di? bx?
	mov	bx?,ax?
	sub	si?,si?
	cld?
      @@:
	mov	ax?,si?
	mov	dx?,bx?
	call	timemline
	jz	@F
	mov?	es,dx
	mov	di?,ax?
	sub	ax?,ax?
	mov	cx?,[bx?].S_TINFO.ti_bcol
    ifdef __f__
	shr	cx?,2
	rep	stosd
    else
	shr	cx?,1
	rep	stosw
    endif
	inc	si?
	jmp	@B
      @@:
	ret
timemzero endp

ticlose proc public uses si? di? bx?
	mov si?,ax?
	sub di?,di?
	.if [si?].S_TINFO.ti_flag & _T_MALLOC or _T_EMMBUF
	    call tifree
	    invoke dlclose,[si?].S_TEDIT.ti_dialog
	    mov ax?,[si?].S_TINFO.ti_flag
	    and ax?,_T_TESAVEMASK
	    or teflag,ax?
	.endif
	.if func(tigetfile)
	    mov di?,[si?].S_TEDIT.ti_prev
	    mov bx?,[si?].S_TEDIT.ti_next
	    mov [si?].S_TEDIT.ti_prev,0
	    mov [si?].S_TEDIT.ti_next,0
	    .if bx? && [bx?].S_TEDIT.ti_prev == si?
		mov [bx?].S_TEDIT.ti_prev,di?
	    .endif
	    .if di? && [di?].S_TEDIT.ti_next == si?
		mov [di?].S_TEDIT.ti_next,bx?
	    .else
		mov di?,bx?
	    .endif
	.endif
	mov tinfo,di?
	invoke nfree,si?
	sub ax?,ax?
	ret
ticlose endp

tisavechanges proc pascal uses di?
local DLG_TESave:dword
	.if func(rsopen,IDD_TESave)
	    stom   DLG_TESave
	    invoke dlshow,dxax
	    les?   di?,DLG_TESave
	    sub    cx?,cx?
	    mov    cl,edi?[6]
	    sub    cl,10
	    mov    ax,edi?[4]
	    add    ax,0205h
	    mov    dl,ah
	    mov    di?,tinfo
	    invoke scpath,ax?,dx?,cx?,[di?].S_TEDIT.ti_file
	    invoke rsevent,IDD_TESave,DLG_TESave
	    invoke dlclose,DLG_TESave
	    mov    ax?,dx?
	.endif
	ret
tisavechanges endp

;-----------------------------------------------------------------------------
;
;-----------------------------------------------------------------------------

tiofread proc public uses si? dx?
	mov	ax?,STDI.ios_l	; current line
	cmp     STDI.ios_c,0	; first line ?
	je	@F
	inc	STDI.ios_l	; get next line
	inc	ax?
      @@:
	call	tigetline
	jc 	tiofread_eof
	invoke	strcpy,STDI.ios_bp,dxax
	invoke	strcat,dxax,addr cp_linefeed
	mov	si?,ax?
	mov	ah,' '
	cld?
      @@:
	lodsb
	test	al,al
	jz	@F
	cmp	al,TITABCHAR
	jne	@B
	mov	[si?-1],ah
	jmp	@B
      @@:
	invoke	strlen,STDI.ios_bp
	mov	STDI.ios_c,ax?
	sub	ax?,ax?
	mov	STDI.ios_i,ax?
	inc	ax?
    tiofread_end:
	ret
    tiofread_eof:
	sub	ax?,ax?
	jmp	tiofread_end
tiofread endp

tiseekst proc public	; cx dx:ax | ecx eax
    ifdef __f__
	mov	edx,eax
	shr	edx,16
	and	eax,0FFFFh
    endif
      @@:
	push	ax?			; ax: offset
	mov	[si?].S_IOST.ios_l,dx?	; dx: line
	mov	[si?].S_IOST.ios_c,0
	call	tiofread
	pop	ax?
	jz	tiseekst_fail
	cmp	[si?].S_IOST.ios_c,ax?
	ja	tiseekst_end
	inc	cx?
	sub	ax?,ax?
	jmp	@B
    tiseekst_end:
	mov	[si?].S_IOST.ios_i,ax?
	inc	ax?
	ret
    tiseekst_fail:
	sub	ax?,ax?
	ret
tiseekst endp

	;----------------------------------------------------
	; This is used by all search funtions
	; lines is copyed to _bufin and converted
	;
	; .ios_l - current line
	; .ios_i - current offset
	; .ios_c - strlen line
	; ?
	; .ios_bb (low word) -- offset
	; .ios_bb (high word) - line
	;----------------------------------------------------

titostdi proc public uses bx?
	invoke	oinitst,addr STDI,0
	mov	al,fsflag
	and	al,IO_SEARCHMASK
	or	ax?,IO_LINEBUF
	mov	STDI.ios_flag,ax?
	call	ticurcp
	mov?	es,dx
	mov	bx?,ax?		; cursor may be set above actual line size
	cmp	byte ptr ebx?,0
	jne	@F
	call	titoend
      @@:
	mov	bx?,tinfo
	mov	ax?,[bx?].S_TINFO.ti_boff
	add	ax?,[bx?].S_TINFO.ti_xoff
	mov	word_ptr STDI.ios_bb,ax?
	mov	ax?,[bx?].S_TINFO.ti_loff
	add	ax?,[bx?].S_TINFO.ti_yoff
	mov	STDI.ios_l,ax?
	mov	word ptr STDI.ios_bb+2,ax
	call	tiofread
	mov	ax?,word_ptr STDI.ios_bb
	mov	STDI.ios_i,ax?
	ret
titostdi endp

;-----------------------------------------------------------------------------
;
;-----------------------------------------------------------------------------

	.data
	cp_filetolong	db 'File too big, no more memory',0
	cp_linefeed     db 0Dh,0Ah,0

	.code

tilineerror:
	push	dx?
	call	oungetc
	test	[si?].S_TINFO.ti_flag,_T_MODIFIED
	jnz	@F
	or	[si?].S_TINFO.ti_flag,_T_MODIFIED
	invoke	ermsg,0,addr cp_linetolong
      @@:
	pop	dx?
	ret

tireaderror:
	invoke	ermsg,0,addr cp_filetolong
	ret

tiiost:
	push	ax?
	invoke	memzero,ssbx,SIZE S_IOST
	pop	ax?
	mov	[bx?].S_IOST.ios_file,ax?
	mov	[bx?].S_IOST.ios_size,2048
	mov	word_ptr [bx?].S_IOST.ios_bp,offset _bufin + 2048
	mov?	word ptr [bx].S_IOST.ios_bp[2],ds
	ret

tiread	proc public
	push	si?	; AX tinfo
	push	di?
	push	bx?
	push	bp?
	mov	si?,ax?
	call	tiftime
	stom	[si?].S_TEDIT.ti_time
	invoke	openfile,[si?].S_TEDIT.ti_file,M_RDONLY,A_OPEN
	inc	ax?
	mov	bp?,ax?
	jz	tiread_end
	dec	ax?
	mov	bx?,offset STDI
	call	tiiost
	invoke	lseek,STDI.ios_file,0,SEEK_END
	stom	[si?].S_TEDIT.ti_size
	invoke	lseek,STDI.ios_file,0,SEEK_SET
	xor	ax?,ax?
	mov	bp?,ax?
	call	tigetline
	jz	tiread_error
	mov	di?,bp?
    tiread_read:
	call	ogetc
	mov?	es,dx
	jz	tiread_eof
	test	al,al
	jz	tiread_line	; binary file
	cmp	al,0Dh
	je	tiread_read
	cmp	al,0Ah
	je	tiread_line
	cmp	al,09h
	je	tiread_tab
	cmp	di?,[si?].S_TINFO.ti_bcol
	je	tiread_maxlen
	stosb
	jmp	tiread_read
    tiread_tab:
	stosb
	mov	al,TITABCHAR
    tiread_tloop:
	test	di?,7
	jz	tiread_read
	cmp	di?,[si?].S_TINFO.ti_bcol
	je	tiread_maxlen
	stosb
	jmp	tiread_tloop
    tiread_maxlen:			; line to big..
	mov	edi?-1,ah
	call    tilineerror
    tiread_line:
	inc	bp?
	mov	ax?,bp?
	call	tigetline
	jz	tiread_tobig
	xor	di?,di?
	jmp	tiread_read
    tiread_tobig:
	call	tireaderror		; file to big..
    tiread_error:
	mov	bp?,-1
    tiread_eof:
	invoke	close,STDI.ios_file
	inc	bp?
	mov	[si?].S_TEDIT.ti_lcnt,bp?
    tiread_end:
	mov	ax?,bp?
	test	ax?,ax?
	pop	bp?
	pop	bx?
	pop	di?
	pop	si?
	ret
tiread	ENDP

topen proc _CType public uses si? file:dword
	xor ax?,ax?
	.if func(tiopen)
	    mov si?,ax?
	    or [si?].S_TINFO.ti_flag,_T_FILE
	    mov tinfo,ax?
	    lodm file
	    .if ax?
		invoke wlongpath,0,dxax
	    .else
		mov? dx,ds
		mov ax?,offset cp_noname
		inc [si?].S_TEDIT.ti_lcnt ; set line count to 1
	    .endif
	    invoke strcpy,[si?].S_TEDIT.ti_file,dxax
	    .if ax? != offset cp_noname
		call tireadstyle
		mov ax?,si?
		call tiread
		.if ZERO?
		    mov ax?,si?
		    call ticlose
		    sub si?,si?
		.endif
	    .endif
	    mov ax?,si?
	.endif
	test ax?,ax?
	ret
topen endp

tclose proc _CType public uses bx?
	mov ax?,tinfo
	.if func(tistate)
	    mov bx?,tinfo
	    .if [bx?].S_TINFO.ti_flag & _T_MODIFIED
		.if func(tisavechanges) == 1
		    mov ax?,tinfo
		    call tiflush
		.endif
	    .endif
	    mov bx?,tinfo
	    mov ax?,[bx?].S_TINFO.ti_flag
	    and ax?,_T_TESAVEMASK
	    mov teflag,ax?
	    mov ax?,tinfo
	    call ticlose
	    mov ax?,tinfo
	.endif
	test ax?,ax?
	ret
tclose endp

tcloseall proc _CType public
	call	tclose
	jnz	tcloseall
	ret
tcloseall endp

;-----------------------------------------------------------------------------
; Open files
;-----------------------------------------------------------------------------

	.data

DLG_OpenFiles	dd ?
FCB_OpenFiles	d? ?
MAXDLGOBJECT	equ 16
MAXOBJECTLEN	equ 38
MAXOPENFILES	equ 64

	.code

event_xcell:
	push	bx?
	les?	bx?,DLG_OpenFiles
	xor	ax?,ax?
	mov	al,ebx?.S_DOBJ.dl_index
	mov	bx?,FCB_OpenFiles
	mov	[bx?].S_LOBJ.ll_celoff,ax?
	call	dlxcellevent
	pop	bx?
	retx

event_list:
	push bp?
	push si?
	push di?
	push bx?
	invoke dlinit,DLG_OpenFiles
	les? bx?,DLG_OpenFiles
	add bx?,SIZE S_TOBJ
	mov cx?,MAXDLGOBJECT
	.repeat
	    or ebx?.S_TOBJ.to_flag,_O_STATE
	    add bx?,SIZE S_TOBJ
	.untilcxz
	mov bx?,word_ptr DLG_OpenFiles
	sub ax?,ax?
	mov al,ebx?[4]
	add al,3
	mov si?,ax?		; x-pos
	mov al,ebx?[5]
	add ax?,1
	mov di?,ax?		; y
	xor bp?,bp?		; loop
	mov? dx,es
	mov cx?,bx?
	.repeat
	    mov ax?,bp?
	    mov bx?,FCB_OpenFiles
	    .break .if ax? >= [bx?].S_LOBJ.ll_numcel
	    add ax?,[bx?].S_LOBJ.ll_index
	    add ax?,ax?
	    les? bx?,[bx?].S_LOBJ.ll_list
	    add bx?,ax?
	    mov bx?,ebx?
	    .if [bx?].S_TINFO.ti_flag & _T_MODIFIED
		mov ax?,si?
		dec ax?
		invoke scputc,ax?,di?,1,'*'
	    .endif
	    invoke scpath,si?,di?,MAXOBJECTLEN,[bx?].S_TEDIT.ti_file
	    add cx?,SIZE S_TOBJ
	    mov? es,dx
	    mov bx?,cx?
	    and ebx?.S_TOBJ.to_flag,not _O_STATE
	    inc di?
	    inc bp?
	.until 0
	mov ax?,1
	pop bx?
	pop di?
	pop si?
	pop bp?
	retx

tdlgopen proc _CType public uses si? di? bx?
local ll:S_LOBJ
local ti[MAXOPENFILES]:word
	lea	ax?,ll
	mov	FCB_OpenFiles,ax?
	invoke	memzero,ssax,SIZE S_LOBJ
	lea	ax?,ti
	mov	word_ptr ll.ll_list,ax?
	mov?	word ptr ll.ll_list+2,ss
	invoke	memzero,ssax,MAXOPENFILES*2
	mov	ll.ll_dcount,MAXDLGOBJECT	; number of cells (max)
	movp	ll.ll_proc,event_list

	.if func(tigetfile)
	    mov si?,ax?
	    sub bx?,bx?
	    mov di?,word_ptr ll.ll_list
	    .repeat
		mov ax?,si?
		.break .if !func(tistate)
		mov [di?],si?
		add di?,2
		mov si?,[si?].S_TEDIT.ti_next
		inc bx?
	    .until bx? == MAXOPENFILES
	    mov ll.ll_count,bx?
	    mov ax?,bx?
	    .if ax? >= MAXDLGOBJECT
		mov ax?,MAXDLGOBJECT
	    .endif
	    mov ll.ll_numcel,ax?
	    .if func(rsopen,IDD_TEOpenFiles)
		stom DLG_OpenFiles
		mov  di?,ax?
		mov  cx?,MAXDLGOBJECT
		mov  ax?,offset event_xcell
		movl dx,cs
		.repeat
		    add  di?,SIZE S_TOBJ
		    stom edi?.S_TOBJ.to_proc
		.untilcxz
		invoke dlshow,DLG_OpenFiles
		pushl  cs
		call   event_list
		invoke dllevent,DLG_OpenFiles,addr ll
		les?   bx?,DLG_OpenFiles
		mov    dx,ebx?[4]
		les?   bx?,IDD_TEOpenFiles
		mov    ebx?[6],dx
		invoke dlclose,DLG_OpenFiles
		mov ax?,dx?
		.if ax?
		    sub ax?,ax?
		    mov bx?,FCB_OpenFiles
		    .if [bx?].S_LOBJ.ll_count
			mov ax?,[bx?].S_LOBJ.ll_index
			add ax?,[bx?].S_LOBJ.ll_celoff
			add ax?,ax?
			lea bx?,ti
			add bx?,ax?
			mov ax?,[bx?]
		    .endif
		.endif
	    .endif
	.endif
	test ax?,ax?
	ret
tdlgopen endp

titogglemenus proc public
	mov ax?,tinfo
	.if func(tistate)
	    push si?
	    push bx?
	    mov bx?,ax?
	    mov dx,ebx?[4]
	    mov cx,ebx?[6]
	    mov si?,tinfo
	    mov ax?,[si?].S_TINFO.ti_flag
	    xor ax?,_T_USEMENUS
	    mov [si?].S_TINFO.ti_flag,ax?
	    and ax?,_T_USEMENUS
	    .if !ZERO?
		mov al,dh
		inc al
		mov [si?].S_TINFO.ti_ypos,ax?
		mov al,ch
		dec al
		mov [si?].S_TINFO.ti_rows,ax?
		mov cx?,[si?].S_TINFO.ti_cols
		mov bl,dh
		mov ah,at_background[B_Menus]
		mov al,' '
		invoke scputw,dx?,bx?,cx?,ax?
		inc dl
		sub cx?,19
		invoke scpath,dx?,bx?,cx?,[si?].S_TEDIT.ti_file
	    .else
		mov al,dh
		mov [si?].S_TINFO.ti_ypos,ax?
		mov al,ch
		mov [si?].S_TINFO.ti_rows,ax?
		mov cx?,[si?].S_TINFO.ti_cols
		mov ah,[si?].S_TINFO.ti_clat
		mov al,[si?].S_TINFO.ti_clch
		.if [si?].S_TINFO.ti_flag & _T_USESTYLE
		    mov ah,[si?].S_TEDIT.ti_stat
		    mov al,[si?].S_TEDIT.ti_stch
		.endif
		mov bl,dh
		invoke scputw,dx?,bx?,cx?,ax?
	    .endif
	    pop bx?
	    pop si?
	    call tiputs
	.endif
	jmp ticontinue
titogglemenus endp

	.data
	cp_extbak db '.bak',0
	cp_exttmp db '.$$$',0

	.code

tistrip proc public uses si? di? ax?
	push?	ds
	mov?	es,dx
	mov?	ds,dx
	mov	si?,ax?
	mov	di?,ax?
	cld?
      @@:
	lodsb
	cmp	al,TITABCHAR
	je	@B
	dec	si?
    tistrip_lod:
	lodsb
	or	al,al
	jz	tistrip_eof
	cmp	al,9
	je      tistrip_09h
    tistrip_sto:
	stosb
	jmp	tistrip_lod
    tistrip_09h:
	stosb
	test	si?,7
	jz	tistrip_lod
	mov	ah,8
      @@:
	lodsb
	or	al,al
	jz	tistrip_eof
	cmp	al,9
	je	tistrip_09h
	cmp	al,TITABCHAR
	jne	tistrip_sto
	dec	ah
	jz	tistrip_sto
	jmp	@B
    tistrip_eof:
	stosb
    tistrip_end:
	pop?	ds
	ret
tistrip endp

; strip space, BH and BL from end of line (DX:AX)
; uses CX, tinfo.ti_bcnt
; return CX strlen(line)

tistripl proc public uses si? di? bx? bp?
	mov	bp?,tinfo
	ASSUME	bp?:ptr S_TINFO
	push?	es
	mov	si?,ax?
	invoke	strlen,dxax
	mov	di?,si?
	add	di?,ax?
	mov	cx?,ax?
	mov	ax?,[bp?].ti_flag
	test	ax?,_T_LINEBUF
	jz	tistripl_end
	and	ax?,_T_USECONTROL
	jnz	tistripl_end
    tistripl_len:
	dec	di?
	cmp	di?,si?
	jl      tistripl_end
	mov	al,edi?
	cmp	al,bl
	je	@F
	cmp	al,bh
	je	@F
	cmp	al,' '
	jne	tistripl_end
      @@:
	mov	edi?,ah
	dec	cx?
	jnz	tistripl_len
    tistripl_end:
	test	cx?,cx?
	mov	[bp?].ti_bcnt,cx?
	mov	ax?,si?
	pop?	es
	ret
tistripl endp

tistripline proc public uses bx?
	call	ticurlp
	mov	bl,9
	mov	bh,TITABCHAR
	call	tistripl
	ret
tistripline endp

size_of_line	equ [bp?-size_l]

; xchange line [AX] <--> [BP]
; size of line: [BP-2]
; uses DI
;
; while (getline(AX++))
;     xchange(AX, BP);
;
; return AX + 1 or -1

tixchgl	proc public uses si?
    tixchgl_get:
	push	ax?
	call	tigetline
	mov	cx?,size_of_line
	mov?	es,dx
	mov	di?,ax?
	mov	si?,bp?
	jc	tixchgl_eof
      @@:
	mov	al,edi?
	movsb
	mov	[si?-1],al
	dec	cx?
	jnz	@B
	pop	ax?
	inc	ax?
	jmp	tixchgl_get
    tixchgl_eof:
	jz	tixchgl_end
      @@:
	mov	al,edi?
	movsb
	mov	[si?-1],al
	dec	cx?
	jnz	@B
	inc	cx?
    tixchgl_end:
	pop	ax?
	ret
tixchgl	endp

; Insert a line below line[AX]

tinsline proc public uses si? di? bp?
	mov	si?,tinfo
	mov	bx?,ax?		; BX to line index
	mov	ax?,[si?].S_TINFO.ti_bcol
	sub	sp?,ax?		; create a line buffer on the stack
	mov	bp?,sp?		; buffer to BP
	push	ax?
      ifdef __f__
	invoke	memzero,ebp,eax	; blank line
      else
	invoke	memzero,ss::bp,ax
      endif
	mov	ax?,[si?].S_TEDIT.ti_lcnt ; room for one more line ?
	cmp	ax?,[si?].S_TINFO.ti_brow
	jae	tinsline_eof
	mov	ax?,bx?		; insert the blank line
	inc	ax?
	call	tixchgl		; return index to last line
	cmp	ax?,[si?].S_TEDIT.ti_lcnt
	jne	tinsline_eof
	inc	[si?].S_TEDIT.ti_lcnt
    tinsline_end:
	add	sp?,[bp?-size_l]; free buffer
	pop	cx?		; line size
	test	ax?,ax?		; line count
	ret
    tinsline_eof:
	xor	ax?,ax?
	jmp     tinsline_end
	ret
tinsline endp

simove:				; move string to &string[1]
	lodsb
	cmp	si?,cx?		; CX max offset
	jae	simove_eof
	mov     [si?-1],ah
	mov	ah,al
	test	al,al
	jnz	simove
	test	cx?,cx?
    simove_end:
	mov     [si?],al	; terminate string
	ret
    simove_eof:
	xor	ax?,ax?
	jmp	simove_end

tiexpand proc public uses si? di? bp? ax?
	push?	ds
	mov?	bp,ss:tinfo
	mov?	es,dx
	mov?	ds,dx
    ifdef __f__
	mov	ebp,tinfo
    endif
	mov	si?,ax?
	mov	di?,ax?
	cld?
	mov	cx?,[bp?].S_TINFO.ti_bcol
	dec	cx?
    tiexpand_next:
	lodsb
	or	al,al
	jz	tiexpand_eos
	cmp	al,9
	je	tiexpand_09h
	cmp	di?,cx?
	je	tiexpand_end
	stosb
	jmp	tiexpand_next
    tiexpand_end:
	mov	al,0
	stosb
    tiexpand_ret:
	pop?	ds
	ret
    tiexpand_eos:
	test	cx?,cx?
	jmp	tiexpand_end
    tiexpand_09h:		; insert TAB char
	stosb
	cmp	di?,cx?
	jae	tiexpand_end
      @@:		; insert "spaces" to next Tab offset
	mov	ah,TITABCHAR
	test	si?,7
	jz	tiexpand_next
	push	si?
	call	simove
	pop	si?
	jz	tiexpand_ret
	inc	si?
	mov	di?,si?
	jmp	@B
tiexpand endp

tienterni proc public uses si? di? bp? bx?
	mov	si?,tinfo
	ASSUME	si?:ptr S_TINFO
	mov	bx?,[si?].ti_brow
	mov	ax?,[si?].ti_loff
	add	ax?,[si?].ti_yoff
	mov	di?,ax?
	inc	ax?
	cmp	ax?,bx?
	mov	ax?,_TI_RETEVENT
	jb	tienterni_do
	dec	bx?
	jz	tienterni_end
    tienterni_nocando:
	call	tinocando
	jmp	tienterni_end
    tienterni_CONTINUE:
	mov	ax?,_TI_CONTINUE
    tienterni_end:
	ret
    tienterni_do:
	mov	ax?,di?
	call	tinsline
	jz	tienterni_nocando
	mov	cx?,[si?].ti_bcol
	or	[si?].ti_flag,_T_MODIFIED
	sub	sp?,cx?
	mov	bp?,sp?
	call	ticurcp
	push?	dx
	push	ax?
      ifdef __f__
	invoke	strcpy,ebp,eax
      else
	invoke	strcpy,ss::bp,dx::ax
      endif
	pop	bx?
	pop?	es
	sub	ax?,ax?
	mov	ebx?,al
	;
	; need to get indent if line above if stripped..
	;
	call	ticurlp
	mov	bx?,ax?
	sub	cx?,cx?
      @@:
    	mov	al,ebx?
	inc	cx?
	inc	bx?
	call	isspace
	jnz	@B
	mov	bl,al		; add indent if last char is zero
	mov	bh,0
	mov	ax?,di?
	inc	ax?
	call	tigetline
	jz	tienterni_home
	mov	di?,ax?
	dec	cx?
	jz	tienterni_home
	test	bl,bl
	jnz	tienterni_home
	mov	al,' '
	mov?	es,dx
	mov	bx?,cx?
	rep	stosb
    tienterni_push:
	mov	al,TITABCHAR
      @@:
	cmp	[bp?],al
	jne	tienterni_cpy
	inc	bp?
	jmp	@B
    tienterni_home:
	sub	bx?,bx?
	jmp	tienterni_push
    tienterni_cpy:
      ifdef __f__
	invoke	strcpy,edi,ebp
      else
	invoke	strcpy,dx::di,ss::bp
      endif
	call	tistrip
	call	tiexpand
    tienterni_done:
	add	sp?,[si?].ti_bcol
	test	bx?,bx?		; just move down if indent
	jz	@F
	call	tidown
	call	tiprevword
	call	tinextword
	jmp	tienterni_end
      @@:
    	call	tihome
	call	tidown
	jmp	tienterni_end
tienterni endp

tienter_putc:
	mov	ax?,[si?].ti_xoff
	add	ax?,[si?].ti_boff
	push	ax?
	mov	al,dl
	call	tiputc
	cmp	ax?,_TI_CONTINUE
	pop	dx?
	mov	ax?,0
	jne	@F
	mov	ax?,[si?].ti_xoff
	add	ax?,[si?].ti_boff
	sub	ax?,dx?
      @@:
	test	ax?,ax?
	ret

tienter proc public
	call	tidoiflines
	push	si?
	push	di?
	mov	si?,tinfo
	call	tienterni
	cmp	ax?,_TI_CONTINUE
	je	@F
	cmp	ax?,_TI_RETEVENT
	je	tienter_ret
	jmp	tienter_end
      @@:
	mov	ax?,[si?].ti_flag
	and	ax?,_T_USEINDENT
	jz	tienter_end
	mov	ax?,[si?].ti_loff
	add	ax?,[si?].ti_yoff
	dec	ax?
	call	tigetline
	jz	tienter_end
	mov?	es,dx
	mov	di?,ax?
	add	ax?,[si?].ti_bcol
	mov	dx?,ax?
	xor	cx?,cx?
      @@:
	mov	al,edi?
	call	isspace
	jz	@F
	inc	cx?
	inc	di?
	cmp	di?,dx?
	jb	@B
      @@:
	test	cx?,cx?
	jz	tienter_end
	mov	di?,cx?
	test	[si?].ti_flag,_T_OPTIMALFILL
	jz	tienter_space
      @@:
	cmp	di?,8
	jb	tienter_space
	mov	dl,9
	call	tienter_putc
	jz	tienter_end
	cmp	di?,ax?
	jbe	tienter_end
	sub	di?,ax?
	jmp	@B
    tienter_space:
	mov	dl,' '
	call	tienter_putc
	jz	tienter_end
	dec	di?
	jnz	tienter_space
    tienter_end:
	pop	di?
	pop	si?
	jmp	ticontinue
    tienter_ret:
	pop	di?
	pop	si?
	jmp	tiretevent
tienter endp

tioptimalfill proc public uses si? bx? cx?
	mov	bl,9
	mov	bh,TITABCHAR
	call	tistripl
	mov	si?,tinfo
	test	[si?].S_TINFO.ti_flag,_T_LINEBUF
	jz	optimalfill_end
	test	[si?].S_TINFO.ti_flag,_T_OPTIMALFILL
	jz	optimalfill_end
	cmp	cx?,8
	jb	optimalfill_end
	push?	ds
	push	ax?
	mov	si?,ax?
	mov?	ds,dx
	mov?	es,dx
    optimalfill_load:
	test	si?,7
	jnz	optimalfill_skip
	mov	bx?,si?
	lodsb
	cmp	al,' '
	jne	optimalfill_test
      @@:
	lodsb
	cmp	al,' '
	je	@B
	mov	cx?,si?
	sub	cx?,bx?
	mov	si?,bx?
	lodsb
	cmp	cx?,9
	jb	optimalfill_test
	xchg	bx?,di?
	mov	al,9
	stosb
	mov	al,TITABCHAR
	mov	cx,7
	rep	stosb
	mov	si?,di?
	mov	di?,bx?
	dec	si?
    optimalfill_skip:
	lodsb
    optimalfill_test:
	or	al,al
	jnz	optimalfill_load
    optimalfill_eos:
	pop	ax?
	pop?	ds
    optimalfill_end:
	ret
tioptimalfill endp

tiflushl proc public uses si? di? bp?
	;
	; Produce output to clipboard or file
	;
	; args:	AX start line	?, 0
	;	DX start offset	?, 0
	;	CX end line	?, line count - 1 ?
	;	BX end offset	?, -1
	;
	mov	si?,tinfo
	mov	bp?,ax?
	mov	di?,dx?
	call	tigetline
	jz	tiflushl_eoi
	jnc	@F		; CF set if string buffer
	test	[si?].ti_flag,_T_LINEBUF
	jnz	tiflushl_eoi	; else CF is EOF
      @@:
	call	tioptimalfill
	add	di?,ax?
	add	bx?,ax?
    tiflushl_loop:
	mov?	es,dx
	inc	di?
	mov	ax?,[si?].ti_bcol
	cmp	bp?,cx?
	jne	@F
	mov	ax?,bx?
      @@:
	cmp	di?,ax?
	ja	tiflushl_eob
	mov	al,edi?-1
	or	al,al
	jz	tiflushl_eol
	cmp	al,9
	je	tiflushl_tab
    tiflushl_put:
	assert	al,0,jne,"tiflushl: al=0"
	call	oputc
	jnz	tiflushl_loop	; out of space..
    tiflushl_eof:
	xor	ax?,ax?
	stc
	jmp	tiflushl_end
    tiflushl_tab:
	mov	ax?,di?
	and	ax?,7
	jz 	tiflushl_putt
    @@:
	mov	ah,edi?
	cmp	ah,TITABCHAR
	jne	tiflushl_putt
	inc	di?
	inc	al
	cmp	al,8
	jb	@B
    tiflushl_putt:
	mov	al,9
	jmp	tiflushl_put
    tiflushl_eob:		; end of selection buffer
	cmp	bp?,cx?		; break if last line
	je	tiflushl_eok
    tiflushl_eol:		; end of line
	inc	bp?
	cmp	bp?,cx?
	ja	tiflushl_last	; break if last line (BP==CX)
	mov	ax?,bp?
	call	tigetline
	jbe	tiflushl_eoi	; break if last line (EOF)
	call	tioptimalfill
	mov	di?,ax?
	test	[si?].ti_flag,_T_USECRLF
	jz	@F		; insert line: 0D0A or 0A
	mov	al,0Dh
	call	oputc
    @@:
	mov	al,0Ah
	call	oputc
	jz	tiflushl_eof
	mov	ax?,di?
	jmp	tiflushl_loop
    tiflushl_eoi:		; end of input (CF)
	xor	ax?,ax?
	inc	ax?
	stc
	jmp	tiflushl_end
    tiflushl_last:
	dec	bp?
    tiflushl_eok:
	xor	ax?,ax?
	inc	ax?
	clc
    tiflushl_end:		; out:	AX result
	mov	bx?,di?		;	DX line index
	mov	dx?,bp?		;	BX line offset
	ret
tiflushl endp

tisave	proc public
	mov  bx?,ax?
	test [bx?].S_TINFO.ti_flag,_T_FILE
	jnz  tiflush
	jmp  ticontinue
tisave endp

tiflush	proc pascal public uses si? di?
local path[WMAXPATH]:byte
	mov si?,ax?
	lea di?,path
	invoke strcpy,ssdi,[si?].S_TEDIT.ti_file
	invoke setfext,ssdi,addr cp_exttmp
	.if func(oopen,dxax,M_WRONLY)
	    xor ax?,ax?
	    mov dx?,ax?
	    mov cx?,[si?].S_TEDIT.ti_lcnt
	    dec cx?
	    mov bx?,ax?
	    dec bx?
	    .if !func(tiflushl)
		invoke oclose,addr STDO
		invoke remove,ssdi
		xor di?,di?
	    .else
		call oflush
		invoke oclose,addr STDO
		.if [si?].S_TINFO.ti_flag & _T_USEBAKFILE
		    invoke setfext,ssdi,addr cp_extbak
		    invoke remove,[si?].S_TEDIT.ti_file
		    invoke rename,ssdi,[si?].S_TEDIT.ti_file
		    invoke setfext,ssdi,addr cp_exttmp
		.else
		    invoke remove,[si?].S_TEDIT.ti_file
		.endif
		invoke rename,ssdi,[si?].S_TEDIT.ti_file
		inc ax?
		mov di?,ax?
		and [si?].S_TINFO.ti_flag,not _T_MODIFIED
		mov ax?,si?
		call tiftime
		stom [si?].S_TEDIT.ti_time
	    .endif
	.endif
	mov  ax?,di?
	test ax?,ax?
	ret
tiflush endp

tilseek proc public uses bx?
local DLG_TESeek:dword
	.if func(rsopen,IDD_TESeek)
	    stom DLG_TESeek
	    mov bx?,tinfo
	    mov cx?,[bx?].S_TINFO.ti_loff
	    add cx?,[bx?].S_TINFO.ti_yoff
	    mov bx?,ax?
	    invoke sprintf,ebx?[24],addr format_u,cx?
	    invoke dlinit,DLG_TESeek
	    .if func(rsevent,IDD_TESeek,DLG_TESeek)
		les? bx?,DLG_TESeek
		invoke strtol,ebx?[24]
		call tialigny
	    .endif
	    invoke dlclose,DLG_TESeek
	    call tiputs
	.endif
    	sub ax?,ax?
	ret
tilseek	endp

	.data
	;
	; These are characters used as valid identifiers (Alt-S)
	;
	idchars db '0123456789_?@abcdefghijklmnopqrstuvwxyz',0

	.code

tisearchfound proc public
	mov	ax?,STDI.ios_l
	call	tialigny
	invoke	strlen,addr searchstring
	mov	dx?,STDI.ios_i
	sub	dx?,ax?
	push	ax?
	mov	ax?,dx?
	dec	ax?
	call	tialignx
	call	ticlipset
	pop	ax?
	push	ax?
	push	bx?
	mov	bx?,tinfo
	add	[bx?].S_TINFO.ti_cleo,ax?
	pop	bx?
	call	tiputs
	call	ticlipset
	pop	cx?
	jmp	ticontinue
tisearchfound endp

tisearch proc public
	call	titostdi
	call	ogetc
	invoke	cmdsearch,00010000h
	push	ax?
	and	fsflag,not IO_SEARCHMASK
	mov	ax?,STDI.ios_flag
	and	al,IO_SEARCHMASK
	or	fsflag,al
	pop	ax?
	test	ax?,ax?
	jnz	tisearchfound
	jmp	ticontinue
tisearch endp

ticontinuesearch proc public
	call	titostdi
	and	STDI.ios_flag,not (IO_SEARCHSET or IO_SEARCHCUR)
	call	continuesearch
	test	ax?,ax?
	jnz	tisearchfound
	inc	ax?
	ret
ticontinuesearch endp

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

ID_YES	equ	1
ID_ALL	equ	2
ID_NO	equ	3

iddreplaceprompt proc
	mov ax?,1
	mov bx?,tinfo
	.if [bx?].S_TINFO.ti_flag & _T_PROMPTONREP
	    .if func(rsmodal,IDD_ReplacePrompt)
		mov dx?,ax?
		.if ax?
		    dec dx?
		.endif
		mov bx?,word_ptr IDD_ReplacePrompt
		mov [bx?].S_ROBJ.rs_index,dl
		mov bx?,tinfo
		.if ax? == ID_ALL
		    xor [bx?].S_TINFO.ti_flag,_T_PROMPTONREP
		.endif
	    .endif
	.endif
	test ax?,ax?
	ret
iddreplaceprompt endp

ID_OLDSTRING	equ 1*16
ID_NEWSTRING    equ 2*16
ID_USECASE	equ 3*16
ID_PROMPT	equ 4*16
ID_CURSOR	equ 5*16
ID_GLOBAL	equ 6*16
ID_OK		equ 7
ID_CHANGEALL	equ 8

	ASSUME	bx?:ptr S_TOBJ

iddreplace proc pascal uses bx? sflag:size_t
local	DLG_Replace:dword
	.if func(rsopen,IDD_Replace)
	    stom DLG_Replace
	    mov  ebx?.to_count[ID_OLDSTRING],128 shr 4
	    mov  ebx?.to_count[ID_NEWSTRING],128 shr 4
	    mov? dx,ds
	    mov  ax?,offset searchstring
	    stom ebx?.to_data[ID_OLDSTRING]
	    mov  ax?,offset replacestring
	    stom ebx?.to_data[ID_NEWSTRING]
	    mov  ax?,sflag
	    mov  dl,_O_FLAGB
	    .if ax? & IO_SEARCHCASE
		or ebx?[ID_USECASE],dl
	    .endif
	    .if ax? & _T_PROMPTONREP
		or ebx?[ID_PROMPT],dl
	    .endif
	    mov dl,_O_RADIO
	    .if ax? & IO_SEARCHCUR
		or ebx?[ID_CURSOR],dl
	    .else
		or ebx?[ID_GLOBAL],dl
	    .endif
	    invoke dlinit,DLG_Replace
	    .if func(rsevent,IDD_Replace,DLG_Replace)
		mov ax?,sflag
		and ax?,not (IO_SEARCHMASK or _T_PROMPTONREP)
		mov dl,_O_FLAGB
		.if ebx?[ID_USECASE] & dl
		    or ax?,IO_SEARCHCASE
		.endif
		.if ebx?[ID_PROMPT] & dl
		    or ax?,_T_PROMPTONREP
		.endif
		.if byte ptr ebx?[ID_CURSOR] & _O_RADIO
		    or ax?,IO_SEARCHCUR
		.else
		    or ax?,IO_SEARCHSET
		.endif
		mov dx?,ax?
		xor ax?,ax?
		.if searchstring != al
		    .if replacestring != al
			inc ax?
		    .endif
		.endif
	    .endif
	    push dx?
	    invoke dlclose,DLG_Replace
	    mov ax?,dx?
	    pop dx?
	.endif
	test ax?,ax?
	ret
iddreplace endp

	ASSUME	bx?:nothing

tireplace proc public uses si? di? bx?
	mov si?,tinfo
	mov ax?,_T_PROMPTONREP
	or  [si?].ti_flag,ax?
	mov al,fsflag
	and al,IO_SEARCHMASK
	.if func(iddreplace,ax?)
	    and fsflag,not IO_SEARCHMASK
	    or  fsflag,dl
	    .if ax? == ID_CHANGEALL || !(dx? & _T_PROMPTONREP)
		and [si?].ti_flag,not _T_PROMPTONREP
	    .endif
	    .if !func(ticontinuesearch)
		jmp @F
		.repeat
		    call titostdi
		    and STDI.ios_flag,not (IO_SEARCHSET or IO_SEARCHCUR)
		    .break .if !func(continuesearch)
		    call tisearchfound
		    @@:
		    mov di?,cx?
		    .break .if !func(iddreplaceprompt)
		    .if ax? != ID_NO
			add  [si?].ti_cleo,di?		; select text
			call ticlipdel			; delete text
			mov  di?,offset replacestring	; add new text
			.repeat
			    mov al,[di?]
			    inc di?
			    .break .if !al
			    call tiputc
			.until 0
		    .else
			call ticontinuesearch
		    .endif
		.until 0
	    .endif
	.endif
	call tiputs
	xor ax?,ax?
	ret
tireplace endp

idtestal:
	push?	es
	push	di?
	push	cx?
	push	ax?
	cmp	al,'A'
	jb	@F
	cmp	al,'Z'
	ja	@F
	or	al,20h
      @@:
	push?	ds
	pop?	es
	mov	di?,offset idchars
	mov	cx?,sizeof idchars
	cld?
	repne	scasb
	cmp	byte ptr [di?-1],0
	pop	ax?
	pop	cx?
	pop	di?
	pop?	es
	ret

tisearchxy proc pascal public uses si? di? bx?
local	linebuf[128]:byte
	call	cursorx		; get cursor x,y pos
	mov	di?,ax?
	mov	bx?,dx?
	inc	di?		; to start of line..
      @@:
	dec	di?		; moving left seeking a valid character
	jz	@F
	invoke	getxyc,di?,bx?
	call	idtestal
	jz	@B
	mov	ax?,di?
	dec	ax?
	invoke	getxyc,ax?,bx?
	call	idtestal
	jnz	@B
      @@:
	lea	si?,linebuf
	mov	cx?,32
	xor	ax?,ax?
      @@:
	invoke	getxyc,di?,bx?
	inc	di?
	call	idtestal
	jz	@F
	mov	[si?],al
	inc	si?
	dec	cx?
	jnz	@B
      @@:
	sub	ax?,ax?
	mov	[si?],al
	mov	al,linebuf
	test	al,al
	jz	@F
	invoke	strcpy,addr searchstring,addr linebuf
	call	tisearch
      @@:
	ret
tisearchxy endp

;-----------------------------------------------------------------------------
; Event handler
;-----------------------------------------------------------------------------

	.data

te_keytable label size_t
	d? KEY_F1,	__F1		; Help
	d? KEY_F2,	__F2		; Save file
	d? KEY_F3,	tisearch	; Search
	d? KEY_F4,	tireplace	; Replace
	d? KEY_F6,	__F6
  ifdef __DZ__
	d? KEY_F7,	tiloadfiles
	d? KEY_F8,	tisavefiles
	d? KEY_F9,	__Esc
	d? KEY_ESC,	__Esc		; Exit - leave files open
	d? KEY_ALTX,	__AltX		; Exit - Close all files
	d? KEY_CTRLX,	__CtrlX		; Close current file
  else
	d? KEY_F9,	__AltX
	d? KEY_ESC,	__AltX
	d? KEY_ALTX,	__AltX
	d? KEY_CTRLX,	__AltX
  endif
	d? KEY_F11,	titogglemenus	; Zoom (Ctrl-M)
	d? KEY_CTRLF2,	__CtrlF2	; Save as
	d? KEY_CTRLF9,	__CtrlF9	; Options

	d? KEY_CTRLA,	__CtrlA		; Select All
	d? KEY_CTRLB,	__CtrlB		; User screen
	d? KEY_CTRLF,	__CtrlF		; Optimal fill on/off
	d? KEY_CTRLG,	tilseek		; Goto line
	d? KEY_CTRLI,	__CtrlI		; Autoindent on/off
	d? KEY_CTRLL,	__CtrlL		; Search again
	d? KEY_CTRLM,	titogglemenus	; Toggle menus on/off
	d? KEY_CTRLO,	__CtrlB		;
	d? KEY_CTRLR,	__CtrlR		; Reload file
	d? KEY_CTRLS,	__CtrlS		; Toggle style on/off
	d? KEY_CTRLT,	__CtrlT		; Tabs mode on/off
	d? KEY_ALTL,	tilseek		;
	d? KEY_ALTS,	tisearchxy	; Word search
	d? KEY_ALT0,	__Alt0		; Window List
  ifdef __DLL__
	d? KEY_SHIFTF1,	__ShiftF1	; [Compile]
	d? KEY_SHIFTF2,	__ShiftF2
	d? KEY_SHIFTF3,	__ShiftF3
	d? KEY_SHIFTF4,	__ShiftF4
	d? KEY_SHIFTF5,	__ShiftF5
	d? KEY_SHIFTF6,	__ShiftF6
	d? KEY_SHIFTF7,	__ShiftF7
	d? KEY_SHIFTF8,	__ShiftF8
	d? KEY_SHIFTF9,	__ShiftF9
	d? KEY_ALTF1,	__AltF1
	d? KEY_ALTF2,	__AltF2
	d? KEY_ALTF3,	__AltF3
	d? KEY_ALTF4,	__AltF4
	d? KEY_ALTF5,	__AltF5
	d? KEY_ALTF6,	__AltF6
	d? KEY_ALTF7,	__AltF7	; Previous error
	d? KEY_ALTF8,	__AltF8	; Next error
	d? KEY_ALTF9,	__AltF9	; [Compile]
  endif
	tekeycount equ (($ - offset te_keytable) / (size_l * 2))
  ifdef __DLL__
	cp_AltFX	db 'AltF'
	cp_AltX		db '1',0
	cp_ShiftFX	db 'ShiftF'
	cp_ShiftX	db '1',0
	cp_te		db '*.te',0
	cp_pipe		db 'pipe'
	cp_errext	db '.err',0
	error_count	d? ?
	error_id	d? ?
  endif

	.code

tioption:
	mov	bx?,tinfo
	mov	ax?,[bx?].S_TINFO.ti_flag
	and	ax?,_T_TESAVEMASK
	mov	teflag,ax?
	call	teoption
	mov	bx?,tinfo
	mov	ax?,[bx?].S_TINFO.ti_flag
	and	ax?,not _T_TESAVEMASK
	or	ax?,teflag
	mov	[bx?].S_TINFO.ti_flag,ax?
	retx

__CtrlF9:
	pushl	cs
	call	tioption
	jmp	ticontinue

__F1:
  ifdef __DZ__
	mov  ax?,DZHELP_EDIT
	call view_readme
  else
	invoke rsmodal,IDD_TEHelp
  endif
	jmp ticontinue

__F2:
	mov  ax?,tinfo
	call tisave
	jmp  ticontinue

__F6:
	.if func(tigetfile)
	    mov bx?,tinfo
	    .if [bx?].S_TEDIT.ti_next
		mov ax?,[bx?].S_TEDIT.ti_next
	    .endif
	    jmp titogglefile
	.endif
	ret

titogglefile:
	push si?
	push di?
	mov di?,ax?
	mov si?,tinfo
	.if di? != si?
	    .if [di].S_TINFO.ti_flag & _T_MALLOC or _T_EMMBUF
		invoke	dlhide,[si?].S_TEDIT.ti_dialog
		invoke	dlshow,[di?].S_TEDIT.ti_dialog
		mov	tinfo,di?
		xor	[di?].S_TINFO.ti_flag,_T_USEMENUS
		call	titogglemenus
		invoke	cursorset,addr [di?].S_TINFO.ti_cursor
	    .endif
	.endif
	pop di?
	pop si?
	jmp ticontinue

__Alt0:
	.if func(tdlgopen)
	    jmp titogglefile
	.endif
	ret

__CtrlF2:
	mov bx?,tinfo
	invoke strcpy,addr _bufin,[bx?].S_TEDIT.ti_file
	invoke strfn,dxax
	.if ax? != offset _bufin
	    mov bx?,ax?
	    mov byte ptr [bx?-1],0
	.endif
	.if func(wdlgopen,addr _bufin,dxax,0)
	    mov bx?,tinfo
	    invoke strcpy,[bx?].S_TEDIT.ti_file,dxax
	    mov ax?,tinfo
	    call tiflush
	    mov bx?,tinfo
	    xor [bx?].S_TINFO.ti_flag,_T_USEMENUS
	    call titogglemenus
	.endif
    	sub ax?,ax?
	ret

__CtrlA:
	call tiselectall
	call tiseto
	jmp  titoggleupdate

__CtrlB:
	call consuser
	sub  ax?,ax?
	ret

__CtrlI:
	mov ax?,_T_USEINDENT
	jmp @F
__CtrlF:
	mov ax?,_T_OPTIMALFILL
	jmp @F
__CtrlS:
	mov ax?,_T_USESTYLE
	jmp @F
__CtrlT:
	mov ax?,_T_SHOWTABS
      @@:
	mov bx?,tinfo
	xor [bx?].S_TINFO.ti_flag,ax?
	jmp titoggleupdate

__CtrlL:
	call	ticontinuesearch
	jmp	ticontinue

titoggleupdate:
	call	tiputs
	jmp	ticontinue

__CtrlR:
	push	bx?
	mov	bx?,tinfo
	test	[bx?].S_TINFO.ti_flag,_T_MODIFIED
	pop	bx?
	jz	@F
	invoke	rsmodal,IDD_TEReload2
	jnz	@F
	jmp	ticontinue
      @@:
	mov	ax?,tinfo
	call	timemzero
	mov	ax?,tinfo
	call	tiread
	jz	@F
	call	tiseto
	call	tiputs
	jmp	ticontinue
      @@:
	mov	di?,KEY_ESC
	dec	ax?
	ret

ifdef __DZ__
	;------------------------------------------
	; Close window and exit -- leave files open
	;------------------------------------------
__Esc:
	push	bx?
	mov	bx?,tinfo
	test	bx?,bx?
	jz	@F
	test	[bx?].S_TINFO.ti_flag,_T_EMMBUF
	lodm	[bx?].S_TEDIT.ti_dialog
      @@:
	pop	bx?
	jz	__CtrlX
	invoke	dlhide,dxax
	mov	ax?,_TI_RETEVENT
	ret
	;----------------------------------------
	; Close current file -- exit if last file
	;----------------------------------------
__CtrlX:
	push	bx?
	call	tclose
	mov	ax?,_TI_RETEVENT
	jz	@F
	mov	bx?,tinfo
	test	bx?,bx?
	jz	@F
	invoke	dlshow,[bx?].S_TEDIT.ti_dialog
	xor	[bx?].S_TINFO.ti_flag,_T_USEMENUS
	invoke	cursorset,addr [bx?].S_TINFO.ti_cursor
	call	titogglemenus
	mov	ax?,_TI_CONTINUE
      @@:
	pop	bx?
	ret
endif
	;-----------------------------
	; Close all open files -- exit
	;-----------------------------
__AltX:
	call tcloseall
	mov  ax?,_TI_RETEVENT
	ret

ifdef __DLL__

inicmd	macro l1,id
l1&id&:	mov al,id+'0'
	jmp &l1&X
	endm
inicmd	__AltF,1
inicmd	__AltF,2
inicmd	__AltF,3
inicmd	__AltF,4
inicmd	__AltF,5
inicmd	__AltF,6
inicmd	__AltF,9
inicmd	__ShiftF,1
inicmd	__ShiftF,2
inicmd	__ShiftF,3
inicmd	__ShiftF,4
inicmd	__ShiftF,5
inicmd	__ShiftF,6
inicmd	__ShiftF,7
inicmd	__ShiftF,8
inicmd	__ShiftF,9
__AltFX:
	mov cp_AltX,al
	mov ax?,offset cp_AltFX
	jmp tiexecuteini
__ShiftFX:
	mov cp_ShiftX,al
	mov ax?,offset cp_ShiftFX
	jmp tiexecuteini

inicommand  proto _CType :dword, :dword, :dword

Message	struc
m_file	db WMAXPATH dup(?)
m_info	db 256 dup(?)
m_line	dd ?
Message	ends

GetMessageId proc pascal uses si di M:dword, id:word
    sub si,si
    .if func(filexist,addr cp_pipe) == 1
	.if func(osopen,addr cp_pipe,0,M_RDONLY,A_OPEN) != -1
	    mov di,ax
	    mov ax,SIZE Message
	    mul id
	    invoke lseek,di,dx::ax,SEEK_SET
	    invoke osread,di,M,SIZE Message
	    xchg ax,di
	    invoke close,ax
	    .if di == SIZE Message
		inc si
	    .endif
	.endif
    .endif
    mov ax,si
    ret
GetMessageId endp

LoadMessageFile proc pascal uses si di M:dword
    mov si,tinfo
    mov di,word ptr M
    invoke strfn,addr [di].Message.m_file
    push dx
    push ax
    invoke strfn,[si].S_TEDIT.ti_file
    push dx
    push ax
    call stricmp
    .if ax
	.if func(topen,addr [di].Message.m_file)
	    mov ax,tinfo
	    mov tinfo,si
	    call titogglefile
	    mov si,tinfo
	.else
	    jmp @F
	.endif
    .endif
    mov ax,word ptr [di].Message.m_line
    .if ax
	dec ax
    .endif
    call tialigny
    call tiseto
    call tiputs
    lea ax,[di].Message.m_info
    mov bx,[si].S_TINFO.ti_yoff
    .if bl <= 1
	add bl,2
    .endif
    .if !([si].S_TINFO.ti_flag & _T_USEMENUS)
	dec bl
    .endif
    invoke scputs,0,bx,4Fh,[si].S_TINFO.ti_cols,ss::ax
    mov ax,1
  @@:
    ret
LoadMessageFile endp

__AltF7	proc pascal	; Previous Error
    local M:Message
    .if error_count
	.if func(GetMessageId, addr M, error_id)
	    invoke LoadMessageFile, addr M
	    .if error_id
		dec error_id
	    .else
		mov ax,error_count
		dec ax
		mov error_id,ax
	    .endif
	.endif
    .endif
    mov ax,_TI_CONTINUE
    ret
__AltF7 endp

__AltF8	proc pascal	; Next Error
    local M:Message
    .if error_count
	.if func(GetMessageId,addr M,error_id)
	    invoke LoadMessageFile,addr M
	    mov ax,error_id
	    inc ax
	    .if ax >= error_count
		sub ax,ax
	    .endif
	    mov error_id,ax
	.endif
    .endif
    mov ax,_TI_CONTINUE
    ret
__AltF8 endp

cmspawnini proc pascal IniSection:dword
	.if func(filexist,addr cp_pipe)
	    invoke remove,addr cp_pipe
	.endif
	sub ax,ax
	mov bx,tinfo
	.if [bx].S_TINFO.ti_flag & _T_EMMBUF
	    .if [bx].S_TINFO.ti_flag & _T_MODIFIED
		call __F2
		mov bx,tinfo
	    .endif
	    invoke dlhide,[bx].S_TEDIT.ti_dialog
	    mov bx,tinfo
	    .if func(inicommand,addr __srcfile,[bx].S_TEDIT.ti_file,IniSection)
		mov dx,ds
		mov bx,offset __srcfile
		mov ah,_DZ_command
		mov al,SPAWN_HIDE
		int DZ
		mov ax,1
		.if CARRY?
		    sub ax,ax
		.endif
	    .endif
	.endif
	ret
cmspawnini endp

tiexecuteini:
	push si
	push di
	mov error_count,0
	mov si,tinfo
	invoke cmspawnini,ds::ax
	push ax
	invoke dlshow,[si].S_TEDIT.ti_dialog
	call __CtrlR
	pop ax
	.if ax
	    .if func(filexist,addr cp_pipe) == 1
		.if func(osopen,addr cp_pipe,0,M_RDONLY,A_OPEN) != -1
		    mov di,ax
		    invoke lseek,di,0,SEEK_END
		    mov cx,SIZE Message
		    div cx
		    mov error_id,0
		    mov error_count,ax
		    invoke close,di
		.endif
		.if error_count
		    call __AltF8
		.endif
	    .endif
	.endif
	sub ax,ax
	pop di
	pop si
	ret

endif ; __DLL__

	.data
	cp_tionfo	db ' col %-3u ln %-5u',0
	tiupdate_line	d? -1
	tiupdate_offs	d? -1

	.code

timenus proc public
	push si?
	mov  si?,tinfo
	mov  ax?,si?
	.if func(tistate)
	    .if dl & _D_ONSCR && cx? & _T_USEMENUS
		mov  bx?,ax?
		mov  ax?,[si?].ti_loff
		add  ax?,[si?].ti_yoff
		inc  ax?
		push ax?
		mov  ax?,[si?].ti_xoff
		add  ax?,[si?].ti_boff
		push ax?
		mov  ax?,ebx?[4]
		add  al,ebx?.S_DOBJ.dl_rect.S_RECT.rc_col
		sub  al,18
		mov  cl,ah
		invoke scputf,ax?,cx?,0,0,addr cp_tionfo
		add sp?,size_l*2
		mov ax?,' '
		.if [si?].ti_flag & _T_MODIFIED
		    mov al,'*'
		.endif
		invoke scputw,0,cx?,1,ax?
	    .endif
	.endif
	pop si?
	xor ax?,ax?
	ret
timenus endp

tiftime proc public uses si? di?
	local ft:S_FTIME
	mov si?,ax?
	sub ax?,ax?
	mov ft.ft_time,ax
	mov ft.ft_date,ax
	.if func(osopen,[si?].S_TEDIT.ti_file,0,M_RDONLY,A_OPEN) != -1
	    mov di?,ax?
	    invoke getftime,ax?,addr ft
	    invoke close,di?
	.else
	    or [si?].S_TINFO.ti_flag,_T_MODIFIED
	.endif
	lodm ft
	test ax?,ax?
	ret
tiftime	endp

teevent proc public uses si? di? bx?
	call tiseto
	call tiputs
	.repeat
	    mov ax?,tinfo
	    mov si?,ax?
	    .if func(tiftime)
		.if ax? != word_ptr [si?].S_TEDIT.ti_time
		    .if func(rsmodal,IDD_TEReload)
			mov  ax?,si?
			call timemzero
			mov  ax?,si?
			call tiread
			mov  di?,KEY_ESC
			.break .if ZERO?
			call tiseto
			call tiputs
		    .endif
		.endif
	    .endif
	    call timenus
	    call tgetevent
	    mov  di?,ax?
	    xor  bx?,bx?
	    mov  cx?,tekeycount
	    .repeat
		.if ax? == te_keytable[bx?]
		    xor ax?,ax?
		    .break
		.endif
		add bx?,size_l*2
	    .untilcxz
	    .if ax?
	      ifdef __CLIP__
		call ticlipevent
	      endif
		call tievent
		mov  si?,ax?
	    .else
		call te_keytable[bx?+size_l]
		.continue .if ax == _TI_CONTINUE
		.break
	    .endif
	    call tiseto
	    call tiputs
	.until 0
	mov ax?,di?
	ret
teevent endp

tiupdate:
	push si?
	mov si?,tinfo
	mov ax?,si?
	.if func(tistate)
	    .if dl & _D_ONSCR && cx? & _T_USEMENUS
		mov ax?,[si?].S_TINFO.ti_loff
		add ax?,[si?].S_TINFO.ti_yoff
		mov dx?,[si?].S_TINFO.ti_xoff
		add dx?,[si?].S_TINFO.ti_boff
		.if ax? != tiupdate_line || dx? != tiupdate_offs
		    mov tiupdate_offs,dx?
		    mov tiupdate_line,ax?
		    call timenus
		.endif
	    .endif
	.endif
	pop si?
	xor ax?,ax?
	retx

tmodal proc _CType public uses si? di? bx?
local cursor:S_CURSOR
local update:dword
local ftime:dword
	.repeat
	    call mousep
	.until ZERO?
	mov ax?,tinfo
	mov si?,ax?
	.if func(tistate)
	    movmx update,tupdate
	    movp tupdate,tiupdate
	    invoke cursorget,addr cursor
	    invoke dlshow,[si?].S_TEDIT.ti_dialog
	    xor [si?].S_TINFO.ti_flag,_T_USEMENUS
	    call titogglemenus
	    invoke cursorset,addr [si?].S_TINFO.ti_cursor
	    mov ax?,si?
	    call tiftime
	    stom ftime
	    call teevent
	    mov di?,ax?
	    mov ax?,tinfo
	    .if si? == ax?
		call tiftime
		mov si?,word_ptr ftime
		sub si?,ax?
	    .else
		mov si?,0
	    .endif
	    mov ax?,word_ptr update
	    mov word_ptr tupdate,ax?
	    movl ax,word ptr update+2
	    movl word ptr tupdate+2,ax
	    invoke cursorset,addr cursor
	    mov dx?,si?		; zero if not modified
	    mov ax?,di?		; returned key value
	    test ax?,ax?
	.endif
	ret
tmodal endp

tedit proc _CType public fname:dword, line:size_t
	.if func(topen,fname)
	    mov ax?,line
	    call tialigny
	    call tmodal
	.endif
	ret
tedit endp

ifdef	__DZ__

topenh proc _CType public uses si? handle:size_t
local tf:S_TFILE
	.repeat
	    .break .if func(osread,handle,addr tf,SIZE S_TFILE) != SIZE S_TFILE
	    .if func(filexist,addr tf) != 1
	    	.continue
	    .endif
	    .break .if !func(topen,addr tf)
	    mov si?,tinfo
	    mov ax?,tf.tf_xoff
	    mov [si?].S_TINFO.ti_xoff,ax?
	    mov ax?,tf.tf_yoff
	    mov [si?].S_TINFO.ti_yoff,ax?
	    mov ax?,tf.tf_boff
	    mov [si?].S_TINFO.ti_boff,ax?
	    mov ax?,tf.tf_loff
	    mov [si?].S_TINFO.ti_loff,ax?
	.until 0
	ret
topenh endp

tsaveh	proc _CType public uses si? di? handle:size_t
local	tf:S_TFILE
	call tigetfile
	mov  si?,ax?
	mov  di?,ax?
	.while si?
	    invoke memzero,addr tf,SIZE S_TFILE
	    invoke strcpy,addr tf,[si?].S_TEDIT.ti_file
	    movmx  tf.tf_time,[si?].S_TEDIT.ti_time
	    mov    ax?,[si?].S_TINFO.ti_xoff
	    mov    tf.tf_xoff,ax?
	    mov    ax?,[si?].S_TINFO.ti_yoff
	    mov    tf.tf_yoff,ax?
	    mov    ax?,[si?].S_TINFO.ti_boff
	    mov    tf.tf_boff,ax?
	    mov    ax?,[si?].S_TINFO.ti_loff
	    mov    tf.tf_loff,ax?
	    invoke oswrite,handle,addr tf,SIZE S_TFILE
	    mov    ax?,[si?].S_TEDIT.ti_next
	    mov    si?,ax?
	    .break .if di? == ax?
	    .break .if !func(tistate)
	.endw
	ret
tsaveh	endp

tiloadfiles proc public
	.if func(wgetfile,addr cp_te,3)
	    push si?
	    push di?
	    mov di?,ax?
	    mov ax?,tinfo
	    mov si?,ax?
	    .if func(tistate)
		invoke dlhide,[si?].S_TEDIT.ti_dialog
	    .endif
	    invoke topenh,di?
	    invoke close,di?
	    mov ax?,tinfo
	    mov si?,ax?
	    .if func(tistate)
		xor [si?].S_TINFO.ti_flag,_T_USEMENUS
		invoke dlshow,[si?].S_TEDIT.ti_dialog
	    .endif
	    pop di?
	    pop si?
	    jmp titogglemenus
	.endif
	ret
tiloadfiles endp

topensession proc _CType public
local cu:S_CURSOR
	invoke	cursorget,addr cu
	call	tiloadfiles
	sub	ax?,ax?
	call	tmodal
	invoke	cursorset,addr cu
	ret
topensession endp

tisavefiles proc public uses si?
	.if func(wgetfile,addr cp_te,2)
	    mov si?,ax?
	    invoke tsaveh,si?
	    invoke close,si?
	.endif
	mov ax?,_TI_CONTINUE
	ret
tisavefiles endp

wedit proc _CType public uses si? di? bx? fcb:dword, count:size_t
	.repeat
	    invoke fbffirst,fcb,count
	    .break .if ZERO?
	    mov di?,ax?
	    and	edi?.S_FBLK.fb_flag,not _A_SELECTED
	    .if !(cx? & _A_ARCHIVE or _A_SUBDIR)
		add ax?,S_FBLK.fb_name
		invoke topen,dxax
	    .endif
	.until ZERO?
	sub ax?,ax?
	call tmodal
	ret
wedit	endp
endif
endif
	end
