include	clib.inc
include	dir.inc
include	io.inc
include	iost.inc
include	string.inc
include	errno.inc
include	tview.inc
include	version.inc
ifdef __MOUSE__
 include mouse.inc
endif

	.186

	public	main
	public	tvflag
	public	fsflag
	public	searchstring
	public	programpath
	public	tv_class
	public	tv_clversion
	public	tv_classsize
	public	tv_classrow

	extrn	_argc:WORD
	extrn	_argv:DWORD
	extrn	textview:NEAR

_DATA	SEGMENT

cp_info	label byte
	db	'Text View Version ',DOSZIP_VSTR,' Copyright (c) 1998-2010 Hjort Nidudsson',13,10
size_info = $ - offset cp_info

cp_usage label byte
	db	'Syntax is: TVIEW [-options] [file]',13,10
	db	13,10
	db	'  -t             View Text',13,10
	db	'  -b             View Binary',13,10
	db	'  -h             View Hex',13,10
	db	'  -m             View Memory [00000..FFFFF]',13,10
	db	'  -o<offset>     Start offset',13,10
	db	'  -s<size>       Limit size of memory to <size>',13,10
	db	'  -q             quiet - no logo',13,10
size_usage = $ - offset cp_usage

_C_HEXVIEW	= 80h
_C_BINVIEW	= 40h
_C_WRAPLINES	= 20h
_C_HIGHCOLOR	= 10h
_C_HEXOFFSET	= 08h
_C_CLIPBOARD	= 04h

option_q	db 0

tvflag		db _C_HEXOFFSET
fsflag		db 0
searchstring	db 128 dup(0)
ext_cfg		db 'cfg',0
arg_file	dd 0
arg_offset	dd 0
arg_size	dd 000FFFFFh
programpath	db WMAXPATH dup(0)
tv_clversion	dw CLVERSION
tv_classsize	dw CLCOUNT
tv_classrow	dw CLCOUNT
tv_class	S_CLASS CLCOUNT dup(<'byte',1,CLTYPE_BYTE,CLFORM_HEX>)

_DATA	ENDS

_TEXT	SEGMENT

main	PROC
	push	ds
	push	offset programpath
	mov	bx,word ptr _argv
	push	ss
	push	[bx]
	call	strcpy
	push	dx
	push	ax
	call	strfn
	dec	ax
	mov	bx,ax
	xor	ax,ax
	mov	[bx],al
	cmp	_argc,1
	jne	read_config
    print_usage:
	mov	cx,size_usage
	mov	dx,offset cp_usage
	call	stderrmsg
	xor	ax,ax
	ret
    read_config:
	push	ds
	push	offset searchstring
	push	ds
	push	offset ext_cfg
	call	argvext
	push	dx
	push	ax
	call	readword
	or	ax,ax
	jz	init_args
	mov	tvflag,al
	mov	fsflag,ah
	xor	ax,ax
    init_args:
	mov	searchstring,al
	mov	si,1
    arg_loop:
	cmp	si,_argc
	jae	init_info
	les	bx,_argv
	mov	ax,si
	inc	si
	shl	ax,2
	add	bx,ax
	les	bx,es:[bx]
	mov	ax,es:[bx]
	cmp	al,'?'
	je	print_usage
	cmp	al,'/'
	je	options
	cmp	al,'-'
	je	options
	mov     word ptr arg_file,bx
	mov	word ptr arg_file+2,es
	jmp	arg_loop
    options:
	mov	al,ah
	or	al,20h
	cmp	al,'t'
	je	case_t
	cmp	al,'b'
	je	case_b
	cmp	al,'h'
	je	case_h
	cmp	al,'m'
	je	case_m
	cmp	al,'o'
	je	case_o
	cmp	al,'q'
	je	case_q
	jmp	print_usage
    case_t:
	and	tvflag,not (_C_HEXVIEW or _C_BINVIEW)
	jmp	arg_loop
    case_b:
	or	tvflag,_C_BINVIEW
    case_h:
	or	tvflag,_C_HEXVIEW
	jmp	arg_loop
    case_m:
	mov	STDI.ios_flag,IO_MEMREAD
	jmp	arg_loop
    case_o:
	add	bx,2
	push	es
	push	bx
	call	strtol
	mov	word ptr arg_offset,ax
	mov	word ptr arg_offset+2,dx
	jmp	arg_loop
    case_q:
	inc	option_q
	jmp	arg_loop
    init_info:
	cmp	option_q,0
	jne	init_file
	mov	cx,size_info
	mov	dx,offset cp_info
	call	stderrmsg
    init_file:
	cmp	STDI.ios_flag,IO_MEMREAD
	je	call_tview
	push	word ptr arg_file+2
	push	word ptr arg_file
	push	0
	call	access
	or	ax,ax
	jz	call_tview
	push	ds
	push	offset cp_info
	push	word ptr arg_file+2
	push	word ptr arg_file
	call	strcpy
	call	eropen
	xor	ax,ax
	ret
    call_tview:
  ifdef __MOUSE__
	call	mouseinit
	call	mouseon
  endif
	push	word ptr arg_file+2
	push	word ptr arg_file
	push	word ptr arg_offset+2
	push	word ptr arg_offset
	push	word ptr arg_offset+2
	push	word ptr arg_offset
	push	word ptr arg_size+2
	push	word ptr arg_size
	call	textview
  ifdef __MOUSE__
	call	mouseoff
  endif
	push	ds
	push	offset searchstring
	push	ds
	push	offset ext_cfg
	call	argvext
	push	dx
	push	ax
	push	_A_HIDDEN
	push	 M_WRONLY
	push	A_CREATE or A_TRUNC
	call	osopen
	cmp	ax,-1
	jz	toend
	push	ax
	push	ax
	push	ds
	push	offset tvflag
	push	2
	call	oswrite
	call	close
    toend:
	xor	ax,ax
	ret
main	ENDP

_TEXT	ENDS

	END
