#include <io.h>
#include <dir.h>
#include <stdio.h>
#include <string.h>
#include <time.h>

#ifdef __BORLANDC__
 #pragma option -a-
#else
 #pragma pack( 1 )
#endif

#define OMF_THEADR	0x80
#define OMF_COMENT	0x88
#define OMF_PUBDEF	0x90
#define OMF_LNAMES	0x96
#define OMF_SEGDEF	0x98
#define OMF_LEDATA	0xA0
#define OMF_FIXUPP	0x9C
#define OMF_MODEND	0x8A

#define MAXIDDSIZE	2048

typedef struct {
	BYTE	type;
	WORD	length;
	char	data[1024];
	BYTE	cksum;
      } OMFR;

char cp_usage[] =
"Syntax: IDDC [options] <idd-file>\n\n"
"-fxxx\tOutput to file <xxx>\n"
;

char file_idd[WMAXPATH];
char file_obj[WMAXPATH];

char dlname[128];
char dialog[2048];

char COMENT[] = "\x88\x1C\x00\x1A\Doszip Resource Edit v2.02";
char LNAMES[] = "\x96\x0D\x00\x00\x04\DATA\x05\_DATA";

int idd_read(void)
{
	int h,z;

	h = osopen(file_idd, _A_NORMAL, M_RDONLY, A_OPEN);
	if (h == -1) {
		perror(file_idd);
		return 0;
	}
	z = osread(h, dialog, MAXIDDSIZE);
	close(h);
	return z;
}

int omf_write(OMFR *o, int h)
{
	char *p;
	int x,chksum;

	p = (char *)o;
	chksum = 0;
	for (x = 0; x < o->length + 2; x++)
		chksum += p[x];
	chksum = ~(chksum - 1);
	p[o->length + 2] = chksum;
	oswrite(h, o, o->length + 3);
	return chksum;
}

int obj_save(int size)
{
	int h,q,c;
	OMFR omf;

	if (size > 1020) {
		perror("Resource is to big -- > 1024");
		return 0;
	}
	h = osopen(file_obj, _A_NORMAL, M_WRONLY, A_TRUNC | A_CREATE);
	if (h == -1) {
		perror(file_obj);
		return 0;
	}
	strcpy(omf.data + 1, strfn(file_idd));
	omf.type = OMF_THEADR;
	omf.length = strlen(omf.data + 1) + 2;
	omf.data[0] = omf.length - 2;
	omf_write(&omf, h);
	memcpy(&omf, COMENT, sizeof(COMENT));
	omf_write(&omf, h);
	memcpy(&omf, LNAMES, sizeof(LNAMES));
	omf_write(&omf, h);
	q = size + 4;
	omf.type    = OMF_SEGDEF;
	omf.length  = 7;
	omf.data[0] = 0x48;
	omf.data[1] = q;
	omf.data[2] = (q >> 8);
	omf.data[3] = 3;
	omf.data[4] = 2;
	omf.data[5] = 1;
	omf.data[6] = 0;
	omf_write(&omf, h);
	omf.type = OMF_PUBDEF;
	omf.data[0] = 0;
	omf.data[1] = 1;
	strcpy(omf.data + 3, "IDD_");
	strcat(omf.data + 3, dlname);
	strupr(omf.data + 3);
	omf.data[2] = strlen(omf.data + 3);
	omf.length = 7 + omf.data[2];
	q -= 4;
	omf.data[omf.length - 4] = q;
	omf.data[omf.length - 3] = (q >> 8);
	omf.data[omf.length - 2] = 0;
	omf.data[omf.length - 1] = 0;
	omf_write(&omf, h);
	omf.type = OMF_COMENT;
	omf.length = 4;
	omf.data[0] = 0x00;
	c = 0xA2;
	omf.data[1] = c;
	omf.data[2] = 0x01;
	omf_write(&omf, h);
	memzero(omf.data, 1024);
	omf.type = OMF_LEDATA;
	omf.length = q + 8;
	omf.data[0] = 1;
	memcpy(omf.data + 3, dialog, size);
	omf_write(&omf, h);
	omf.type = OMF_FIXUPP;
	omf.length = 5;
	omf.data[1] = q;
	q >>= 8;
	c = 0xCC | q;
	omf.data[0] = c;
	omf.data[2] = 0x54;
	omf.data[3] = 1;
	omf.data[4] = 0;
	omf_write(&omf, h);
	omf.type = OMF_MODEND;
	omf.length = 2;
	omf.data[0] = 0;
	omf_write(&omf, h);
	close(h);
	return 1;
}

int pascal main(void)
{
	int c,size;
	int option_f = 0;
	char *q;

	if (_argc == 1) {
		printf(cp_usage);
		return 1;
	}
	file_idd[0] = 0;
	for (c = 1; c < _argc; c++) {
		switch (_argv[c][0]) {
		case '?':
			printf(cp_usage);
			return 0;
		case '/':
		case '-':
			switch (_argv[c][1] | 0x20) {
			case 'f':
				option_f = 1;
				strcpy(file_obj, &_argv[c][2]);
				break;
			default:
				printf(cp_usage);
				return 0;
			}
			break;
		default:
			strcpy(file_idd, _argv[c]);
			break;
		}
	}
	if (file_idd[0] == 0) {
		perror("Command line: missing <source>");
		return 1;
	}
	if (access(file_idd, 0) == 0) {
		if (strsol(file_idd))
			strcpy(file_idd, wlongpath(file_idd, NULL));
		else
			strcpy(file_idd, wlongname(file_idd, NULL));
	} else {
		perror("missing <source>");
		return 1;
	}
	strcpy(dlname, strfn(file_idd));
	if ((q = strrchr(dlname, '.')) != NULL)
		*q = 0;
	if (option_f == 0) {
		fullpath(file_obj, 0);
		strfcat(file_obj, NULL, strfn(file_idd));
		setfext(file_obj, ".OBJ");
	}
	size = idd_read();
	if (size == 0)
		return 1;
	if (obj_save(size) == 0)
		return 1;
	return 0;
}
