# BUILDIDD.MAK--
# Updates dialogs for a single memory model
#
# Output: Cx or LIBx or CLIBx
# Syntax: [NMAKE|WMAKE|MAKE] xxx=x [MDL|W0X|DEBUG]
#
#  MDL=c  Memory model (c or l)
#  W0X=1  Open Watcom C library
#
# Default: LIBL
#

!ifndef MDL
MDL=l
!endif

# Get Doszip root directory and flags
!include ..\srcpath

!if $(DEBUG)
SRCIDD=$(ROT)\src\clib\src\*.IDD
OUTLIB=$(ROT)\lib\c$(MDL)
!else
SRCIDD=src\*.IDD
!ifdef W0X
OUTLIB=$(ROT)\lib\clib$(MDL)
!else
OUTLIB=$(ROT)\lib\lib$(MDL)
!endif
!endif

$(OUTLIB).LIB:
 @for %f in ($(SRCIDD)) do ..\iddc\iddc %f
!ifdef 	__WCC__
 @for %f in (*.OBJ) do @%append OBJECTS -+%f
!else
 @for %f in (*.OBJ) do echo -+%f & >> OBJECTS
 @echo -+ALLOC.OBJ >> OBJECTS
!endif
!ifdef 	__BCC__
 tlib $(OUTLIB) /C @OBJECTS
!endif
!ifdef 	__MCC__
 lib $(OUTLIB) /I /NOLOGO @OBJECTS;
!endif
!ifdef 	__WCC__
 wlib -q -c $(OUTLIB) @OBJECTS.
!endif
 @del *.obj
 @del OBJECTS
 @if exist $(OUTLIB).bak del $(OUTLIB).bak
