CON_UBEEP	equ	0001h	; Use Beep
CON_MOUSE	equ	0002h	; Use Mouse
CON_IOLFN	equ	0004h	; Use Long File Names
CON_CLIPB	equ	0008h	; Use System Clipboard
CON_INT2F	equ	0010h	; Use Idle Int 2Fh
CON_COLOR	equ	0080h	; Use Color
CON_UTIME	equ	0100h	; Use Time
CON_UDATE	equ	0200h	; Use Date
				; Doszip flags
CON_IMODE	equ	1000h	; Init screen mode on startup
CON_REVGA	equ	2000h	; Restore VGA palette on exit

CURSOR_NORMAL	equ	0607h
CURSOR_HIDDEN	equ	0F00h

_D_DOPEN	equ	0001h
_D_ONSCR	equ	0002h
_D_DMOVE	equ	0004h
_D_SHADE	equ	0008h
_D_MYBUF	equ	0010h	; do not delete on exit (static)
_D_RCNEW	equ	0020h	; twclose -- delete dialog if set
_D_RESAT	equ	0040h	; attrib is index in color table (rcedit)
_D_DHELP	equ	0080h	; execute thelp() if set
_D_CLEAR	equ	0100h   ; args on open/create
_D_BACKG	equ	0200h
_D_FOREG	equ	0400h
_D_STERR	equ	1000h	; error color (red)
_D_MENUS	equ	2000h	; menus color (gray), no title
_D_MUSER	equ	4000h

_D_COLOR	equ	_D_BACKG or _D_FOREG
_D_RESRC	equ	0030h
_D_SETRC	equ	0031h
_D_STDDLG	equ	(_D_DMOVE or _D_SHADE or _D_CLEAR or _D_COLOR)
_D_STDERR	equ	(_D_STDDLG or _D_STERR)

_O_PBUTT	equ	0
_O_RBUTT	equ	1
_O_CHBOX	equ	2
_O_XCELL	equ	3
_O_TEDIT	equ	4
_O_MENUS	equ	5
_O_XHTML	equ	6
_O_MOUSE	equ	7
_O_LLMSU	equ	8
_O_LLMSD	equ	9
_O_TBUTT	equ	10

_O_RADIO	equ	0010h
_O_FLAGB	equ	0020h
_O_LLIST	equ	0040h
_O_DTEXT	equ	0080h
_O_DEXIT	equ	0200h
_O_CURID	equ	0800h
_O_GLCMD	equ	1000h
_O_EVENT	equ	2000h
_O_CHILD	equ	4000h
_O_STATE	equ	8000h
_O_DEACT	equ	_O_STATE

_C_NORMAL	equ	1
_C_RETURN	equ	2
_C_ESCAPE	equ	3
_C_REOPEN	equ	4

B_Black		= 	0
B_Desktop	= 	1
B_Dialog	= 	2
B_Menus		= 	3
B_Red		= 	4
B_Title		= 	5
B_DarkGray	= 	6
B_Gray		= 	7

F_Black		= 	0
F_Panel		= 	1
F_Frame		= 	2
F_Subdir	= 	3
F_Files		= 	4
F_System	= 	5
F_Hidden	= 	6
F_Gray		= 	7
F_DarkGray	= 	8
F_Desktop	= 	9
F_Dialog	= 	10
F_Menus		= 	11
F_TitleKey	= 	12
F_DesktopKey	= 	13
F_DialogKey	= 	14
F_MenusKey	= 	15
F_Title		=	0

S_CURSOR 	STRUC
cr_x		db ?
cr_y		db ?
cr_start	db ?
cr_end		db ?
S_CURSOR 	ENDS

S_COLOR		STRUC
cl_backgr	db 8  dup(?)
cl_foregr	db 16 dup(?)
cl_palett	db 16 dup(?)
S_COLOR		ENDS

S_WCHAR		STRUC
wc_ch		db ?
wc_at		db ?
S_WCHAR		ENDS

S_RECT		STRUC
rc_x		db ?
rc_y		db ?
rc_col		db ?
rc_row		db ?
S_RECT		ENDS

TO_OFLAG	equ	00h
TO_OCOUNT	equ	02h
TO_OASCII	equ	03h
TO_ORECT	equ	04h
TO_ODATA	equ	08h
TO_SDATA	equ	0Ah
TO_OPROC	equ	0Ch
TO_SPROC	equ	0Eh

S_TOBJ		STRUC
to_flag		dw ?
to_count	db ?
to_ascii	db ?
to_rect_x	db ?
to_rect_y	db ?
to_rect_c	db ?
to_rect_r	db ?
to_data_ax	dw ?
to_data_dx	dw ?
to_proc_ax	dw ?
to_proc_dx	dw ?
S_TOBJ		ENDS

S_DOBJ		STRUC
dl_flag		dw ?
dl_count	db ?
dl_index	db ?
dl_rect_x	db ?
dl_rect_y	db ?
dl_rect_c	db ?
dl_rect_r	db ?
dl_wp_ax	dw ?
dl_wp_dx	dw ?
dl_object_ax	dw ?
dl_object_dx	dw ?
S_DOBJ		ENDS

S_ROBJ		STRUC
rs_memsize	dw ?
rs_flag		dw ?
rs_count	db ?
rs_index	db ?
rs_rect		dd ?
S_ROBJ		ENDS

S_GLCMD		STRUC
gl_key		dw ?
gl_proc		PF ?
S_GLCMD		ENDS

GCMD	macro	key, name	; GlobalCommand: <ShortKey>, <cmdProc>
	dw	key
 ifdef LPROG
	dd	name
 else
	dw	name
 endif
	endm

S_TINFO		STRUC
ti_base		dd ?	; base pointer
ti_xpos		dw ?	; text window x,y
ti_ypos		dw ?
ti_cols		dw ?	; size of screen-line
ti_bcol		dw ?	; size of buffer-line
ti_xoff		dw ?	; offset on screen
ti_boff		dw ?	; offset in buffer (start of screen-line)
ti_bcnt		dw ?	; byte count in line
ifdef __CLIP__
 ti_clst	dd ?	; Clipboard start
 ti_clen	dd ?	; Clipboard end
endif
ti_clat		dw ?	; Normal string attrib
S_TINFO		ENDS

S_LOBJ		STRUC
ll_dlgoff	dw ?	; start index in dialog
ll_dcount	dw ?	; number of cells (max)
ll_celoff	dw ?	; cell offset
ll_numcel	dw ?	; number of visible cells
ll_count	dw ?	; total number of items in list
ll_index	dw ?	; index in list buffer
ll_list_ax	dw ?	; pointer to list buffer
ll_list_dx	dw ?
ll_proc		PF ?
S_LOBJ		ENDS

GLOBAL	_scrseg: 	word	; Screen segment (B800 or B000)
GLOBAL	_scrrow: 	byte	; Screen rows - 1
GLOBAL	_scrcol: 	byte	; Screen columns
GLOBALD _screct			; Update _scr* (_INIT_)

GLOBAL	console: 	word	; BEEP/MOUSE/LFN/CLIPB/2F/COLOR/TIME/DATE
GLOBAL	console_wp: 	word 	; Init screen (user screen)
GLOBAL	console_xy: 	word 	; Init cursor (set on exit)
GLOBAL	console_oz: 	byte 	; Init screen size

GLOBALD	consinit
GLOBALD	conssetl
GLOBALD	consuser
GLOBALD	consexit

GLOBALD	cursorx
GLOBALD	cursory
GLOBALD	cursoron
GLOBALD	cursoroff
GLOBALP	gotoxy, 	:word, :word
GLOBALP	getcursor, 	:dword
GLOBALP	setcursor, 	:dword

GLOBAL	at_palett:	byte
GLOBAL	at_background:	byte
GLOBAL	at_foreground:	byte

GLOBALP	setpal,     	:word, :word
GLOBALD	resetpal
GLOBALP	loadpal,	:dword
GLOBALD	editpal
GLOBALD	editattrib

GLOBALD	@wcenter
GLOBALD	@wcputa
GLOBALD	@wcputbg
GLOBALD	@wcputfg
GLOBALD	@wcputc
GLOBALD	@wcputw
GLOBALD	@wctitle
GLOBALD	@wcputs
GLOBALD	@wcputf

GLOBALN	@wgetxyp
GLOBALN	@wcputxg
GLOBALN	@wcpath
GLOBALN	@wcputnum
GLOBALN	@putesbxal
GLOBALN	@rsunzipat
GLOBALN	@rsunzipch

GLOBALP	wcunzip,	:dword, :dword, :word
GLOBALP	wcpbutt,	:dword, :word, :word, :dword
GLOBALP	wcpushst,	:dword, :dword
GLOBALP	wcpopst,	:dword

GLOBALD	@getxya
GLOBALD	@getxyc
GLOBALD	@getxyw
GLOBALD	@getxyp
GLOBALD	@scputa
GLOBALD	@scputc
GLOBALD	@scputw
GLOBALD	@scputfg
GLOBALD	@scputbg
GLOBALD	@scpath
GLOBALD	@scputs
GLOBALD	@scputds
GLOBALD	@scenter
GLOBALD	@scputf

GLOBALN	@putstr
GLOBALN	@rcsprc

GLOBALP	rcalloc,	:dword, :word
GLOBALP	rcbprc,		:dword, :dword, :word
GLOBALP	rcclose,	:dword, :word, :dword
GLOBALP	rcclrshade,	:dword, :dword
GLOBALP	rcframe,	:dword, :dword, :word, :word
GLOBALP	rchide,		:dword, :word, :dword
GLOBALP	rcinside,	:dword, :dword
GLOBALP	rcmemsize,	:dword, :word
GLOBALP	rcopen,		:dword, :word, :word, :dword, :dword
GLOBALP	rcread,		:dword, :dword
GLOBALP	rcsetshade,	:dword, :dword
GLOBALP	rcshow,		:dword, :word, :dword
GLOBALP	rcsprc,		:dword
GLOBALP	rcsprcrc,	:dword, :dword
GLOBALP	rcwrite,	:dword, :dword
GLOBALP	rcxchg,		:dword, :dword
GLOBALP	rcxyrow,	:dword, :word, :word
GLOBALP	rcmoveup,	:dword, :dword, :word
GLOBALP	rcmovedn,	:dword, :dword, :word
GLOBALP	rcmoveleft,	:dword, :dword, :word
GLOBALP	rcmoveright,	:dword, :dword, :word

ifdef __WCC__
 GLOBALP rcaddrc,	:dword, :dword, :word
 GLOBALP rcmove,	:dword, :dword, :word, :word, :word, :word
 GLOBALP rcmsmove,	:dword, :dword, :word, :word
else
 GLOBALP rcaddrc,	:dword, :dword
 GLOBALP rcmove,	:dword, :dword, :word, :word, :word
 GLOBALP rcmsmove,	:dword, :dword, :word
endif

GLOBALP	twopen,	 	:dword, :word, :dword
GLOBALP	twclose, 	:dword
GLOBALP	twshow,	 	:dword
GLOBALP	twhide,	 	:dword
GLOBALP	twmove,	 	:dword

GLOBAL	tdialog:	dword
GLOBAL	tdllist:	dword
GLOBAL	tmaxascii:	byte
GLOBAL	tminascii:	byte
GLOBAL	tclrascii:	byte
GLOBAL	key_scancode:	byte
GLOBAL	cp_error: 	byte
GLOBAL	thelp:		FPTR ; int (*thelp)(void);
GLOBAL	tupdate:	FPTR ; int (*tupdate)(void);
GLOBAL	tgetevent:	FPTR ; int (*tgetevent)(void);

GLOBALN	@pbuttms
GLOBALD	@ermsg
GLOBALD	@ermsgt
GLOBALD	@stdmsg
GLOBALP	tmsgbox,   	:dword, :word

GLOBALD	tdpbuttevent
GLOBALD	tdradioevent
GLOBALD	tdcheckevent
GLOBALD	tdxcellevent
GLOBALD	tdteditevent
GLOBALD	tdmenusevent

GLOBALD	getevent
GLOBALD	tupdtime
GLOBALD	tupddate
GLOBALD	scroll_delay

GLOBALP	rsopen,	   	:dword
GLOBALP	rsevent,   	:dword, :dword
GLOBALP	rsmodal,   	:dword
GLOBALP	rsreload,  	:dword, :dword
GLOBALP	tdinit,	   	:dword
GLOBALP	tdevent,   	:dword
GLOBALP	tdlevent,  	:dword, :dword
GLOBALP	tdmodal,	:dword
GLOBALD	textview;,	:dword, :dword, :dword, :dword
GLOBALP	tview,		:dword, :dword

GLOBALP tdedit,		:dword, :dword, :word
GLOBALP	getxys,		:word, :word, :dword, :word, :word
GLOBALP	pbuttset,	:word, :word, :word
GLOBALP	pbuttclr,	:word, :word, :word
GLOBALP	pbuttms,	:word, :word, :word
GLOBALP	tdinitobj,	:dword, :dword
GLOBALP	tgetline,	:dword, :dword, :word, :word
GLOBALP	tdsetbitflag,	:dword, :word, :word, :dword
GLOBALP	tdgetbitflag,	:dword, :word, :word
GLOBALP	tihndlevent,	:dword, :word

GLOBALP	thelpinit,	:FPTR	; global help proc
GLOBALP	thelp_set,	:FPTR	; locale help proc
GLOBALD	thelp_pop
