include	clib.inc
include	clip.inc
include	malloc.inc
include	string.inc
include	stdio.inc
include	stdlib.inc
include	io.inc
include	ios.inc
include	dos.inc
include	dialog.inc
include	math.inc

	.186

	public	Textview

TVVERSION = 	0109h

	extrn	tvflag: BYTE
	extrn	fsflag: BYTE
	extrn	IDD_TVHelp: DWORD
	extrn	IDD_TVSeek: DWORD
	extrn	IDD_TVCopy: DWORD
	extrn	tvmem_offs: DWORD
	extrn	tvmem_size: DWORD

_C_CLIPBOARD	= 04h
_C_HEXOFFSET	= 08h
_C_HIGHCOLOR	= 10h
_C_WRAPLINES	= 20h
_C_BINVIEW	= 40h
_C_HEXVIEW	= 80h

S_TEXTVIEW STRUC
	tv_offset	DD ?
	tv_fsize	DD ?
	tv_xflag	DW ?		; config flag
	tv_dialog	DD ?		; main dialog pointer
	tv_rowcnt	DW ?		; max lines (23/48)
	tv_lcount	DW ?		; lines on screen
	tv_scount	DD ?		; bytes on screen
	tv_maxcol	DD ?		; max linesize on screen
	tv_curcol	DD ?		; current line offset (col)
	tv_screen	DD ?		; screen buffer
	tv_switch	DW ?		; main switch
	tv_cursor	DD ?		; cursor (old)
	tv_oldupd	DW ?		; update proc (old)
	tv_s_dlg	DD ?		; search dialog
	tv_s_offs	DD ?		; search offset
	tv_tcount	DW ?		; TexLineCount
	tv_bsize	DW ?		; buffer size
	tv_xpos		DW ?		; temp (mouse)
	tv_ypos		DW ?		; temp (mouse)
	tv_zpos		DW ?		; temp (mouse)
	tv_ddtmp	DD ?	 	; temp 32
	tv_ltab		DD  50 dup(?)	; line offset in file
	tv_tltab	DD 256 dup(?)	; offset of first 256 lines
	;---
	tv_SSSIZE	DW ?
	tv_SSReturn	PF ?
	tv_SSMEMSIZE	DD ?
	tv_SSMEMOFFS	DD ?
	tv_SSOFFSET	DD ?
	tv_SSFILENAME	DD ?
S_TEXTVIEW ENDS

_DATA	SEGMENT

format_8ld	DB	'%-8ld',0
format_10u	DB	'%010lu',0
format_08lXh	DB	'%08lXh',0

cp_deci		DB	'Dec'
cp_hex		DB	'Hex  '
cp_ascii	DB	'Ascii'
cp_wrap		DB	'Wrap  '
cp_unwrap	DB	'Unwrap'
cp_memory	DB	'MEMORY',0
cp_byte		DB	'byte',0

format_3d	DB	'%3d',0
format_lu	DB	'%lu',0

TVkey_global	DW	KEY_F1
		DW	KEY_F2
		DW	KEY_F3
		DW	KEY_F4
		DW	KEY_F5
		DW	KEY_F6
		DW	KEY_F7
		DW	KEY_F8
		DW	KEY_F10
		DW	KEY_ESC
		DW	KEY_ALTX
		DW	KEY_CTRLF5

TVkey_glcount =	12

TVkey_local	DW	KEY_UP
		DW	KEY_DOWN
		DW	KEY_PGUP
		DW	KEY_PGDN
		DW	KEY_LEFT
		DW	KEY_RIGHT
		DW	KEY_HOME
		DW	KEY_END
		DW	KEY_CTRLL
		DW	KEY_CTRLE
		DW	KEY_CTRLX
		DW	KEY_CTRLR
		DW	KEY_CTRLC
		DW	KEY_CTRLUP
		DW	KEY_CTRLDN
		DW	KEY_CTRLLEFT
		DW	KEY_CTRLRIGHT
		DW	KEY_SHIFTF3
		DW	KEY_CTRLEND
		DW	KEY_CTRLHOME

TVkey_count =	33

TVresource	DW	4016,4410h,0,0
		DB	80
TVrs_rcrow	DB	25,0F0h,050h,070h
TVrs_atcnt	DW	30F7h
		DB	17h,70h,7Fh,7Fh,240,7,70h,7Fh,7Fh,240,9,70h
		DB	7Fh,7Fh,240,9,70h,7Fh,7Fh,240,8,70h,7Fh,7Fh
		DB	240,7,70h,7Fh,7Fh,240,6,70h,7Fh,7Fh,240,10,70h
		DB	240,3,7Fh,240,6,70h
		DB	' Text View:',240,50,' col',240,11,' 100%'
TVrs_chcnt	DW	32F7h
		DB	' F1 Help  F2',240,9,' F3 Search  F4'
		DB	240,8,' F5 Copy  F6 Dec  F7 Seek',240,5,' Esc Quit '

TVIEW_KEYPROC	DW	OFFSET TVIEW_CMHELP
		DW	OFFSET TVIEW_CMWRAP
		DW	OFFSET TVIEW_CMSEARCH
		DW	OFFSET TVIEW_CMHEX
		DW	OFFSET TVIEW_COPY
		DW	OFFSET TVIEW_CMOFFS
		DW	OFFSET TVIEW_CMSEEK
		DW	OFFSET TVIEW_CMBINARY
		DW	OFFSET TVIEW_CMQUIT
		DW	OFFSET TVIEW_CMQUIT
		DW	OFFSET TVIEW_CMQUIT
		DW	OFFSET TVIEW_CMCOLOR
		DW	OFFSET TVIEW_UP
		DW	OFFSET TVIEW_DOWN
		DW	OFFSET TVIEW_PGUP
		DW	OFFSET TVIEW_PGDN
		DW	OFFSET TVIEW_LEFT
		DW	OFFSET TVIEW_RIGHT
		DW	OFFSET TVIEW_HOME
		DW	OFFSET TVIEW_END
		DW	OFFSET TVIEW_SEARCH
		DW	OFFSET TVIEW_UP
		DW	OFFSET TVIEW_DOWN
		DW	OFFSET TVIEW_PGUP
		DW	OFFSET TVIEW_PGDN
		DW	OFFSET TVIEW_PGUP
		DW	OFFSET TVIEW_PGDN
		DW	OFFSET TVIEW_PGLEFT
		DW	OFFSET TVIEW_PGRIGHT
		DW	OFFSET TVIEW_SEARCH
		DW	OFFSET TVIEW_ENDRIGHT
		DW	OFFSET TVIEW_TOLSTART
if USE_MOUSE
TVSCROLLDDELAY	DW	OFFSET TVSCROLLD06
		DW	OFFSET TVSCROLLD00
		DW	OFFSET TVSCROLLD01
		DW	OFFSET TVSCROLLD03
		DW	OFFSET TVSCROLLD04
endif
_DATA	ENDS

_TEXT	SEGMENT

TVUPDATE PROC DIST	; Dummy update
	XOR	AX,AX
	RET
TVUPDATE ENDP

if USE_MEMREAD

NORMALIZE PROC
	MOV	CL,DH
	SHL	DX,4
	ADD	AX,DX
	ADC	CL,0
	AND	CL,0Fh
	MOV	DL,CL
	MOV	DH,0
	RET
NORMALIZE ENDP

endif

TVGETLASTOFFSET	PROC
	PUSH	BX
	LEA	BX,[BP.tv_tltab]
	MOV	AX,[BP.tv_tcount]
	SHL	AX,2
	ADD	BX,AX
	MOV	AX,SS:[BX]
	MOV	DX,SS:[BX+2]
	POP	BX
	RET
TVGETLASTOFFSET	ENDP

TVADDOFFS PROC
	PUSH	BX
	LEA	BX,[BP.tv_ltab]
	MOV	AX,[BP.tv_lcount]
	SHL	AX,2
	ADD	BX,AX
	LDX32	[BP.tv_offset]
	STO32	SS:[BX]
	INC	[BP.tv_lcount]
	POP	BX
	RET
TVADDOFFS ENDP

TVGETLINESIZE PROC
	SHL	AX,2
	LEA	BX,[BP.tv_ltab]
	ADD	BX,AX
	LDX32	SS:[BX+4]
	MOV	CX,SS:[BX+2]
	MOV	BX,SS:[BX]
	SUB	AX,BX
	SBB	DX,CX
	RET
TVGETLINESIZE ENDP

TVSETMAXCOL PROC
	XOR	CX,CX
MAXCOL_00:
	CMP	CX,[BP.tv_lcount]
	JNC	MAXCOL_02
	MOV	AX,CX
	PUSH	BX
	PUSH	CX
	CALL	TVGETLINESIZE
	POP	CX
	POP	BX
	CMP32	[BP.tv_maxcol]
	JBE	MAXCOL_01
	STO32	[BP.tv_maxcol]
MAXCOL_01:
	INC	CX
	JMP	MAXCOL_00
MAXCOL_02:
	RET
TVSETMAXCOL ENDP

TVIEWMSCROLL PROC
	XOR	CX,CX
	MOV	ES,CX
	MOV	CL,ES:[0484h]
	XOR	BX,BX
	CMP	CX,24
	JZ	MSCROLL_00
	SHR	AX,1
	SHR	DX,1
MSCROLL_00:
	CMP	DX,8
	JC	MSCROLL_07
	CMP	DX,16
	JA	MSCROLL_06
	CMP	DX,8
	JC	MSCROLL_03
	CMP	DX,16
	JA	MSCROLL_03
	CMP	AX,31
	JC	MSCROLL_05
	CMP	AX,50
	JA	MSCROLL_04
	CMP	DX,12
	JNZ	MSCROLL_01
	CMP	AX,39
	JA	MSCROLL_04
	JMP	MSCROLL_05
MSCROLL_01:
	CMP	DX,11
	JB	MSCROLL_02
	CMP	DX,13
	JA	MSCROLL_02
	CMP	AX,36
	JB	MSCROLL_05
	CMP	AX,45
	JA	MSCROLL_04
MSCROLL_02:
	CMP	DX,12
	JB	MSCROLL_07
	JA	MSCROLL_06
MSCROLL_03:
	RET
MSCROLL_04:
	INC	BX
MSCROLL_05:
	INC	BX
MSCROLL_06:
	INC	BX
MSCROLL_07:
	INC	BX
	PUSH	BX
	CMP	AX,37
	JB	MSCROLL_09
	CMP	AX,43
	JB	MSCROLL_08
	MOV	BX,79
	SUB	BX,AX
	MOV	AX,BX
	JMP	MSCROLL_09
MSCROLL_08:
	XOR	AX,AX
MSCROLL_09:
	SHL	AX,2
	CMP	DX,12
	JE	MSCROLL_10
	JB	MSCROLL_11
	MOV	CX,24
	SUB	CX,DX
	MOV	DX,CX
	JMP	MSCROLL_11
MSCROLL_10:
	XOR	DX,DX
MSCROLL_11:
	ADD	DX,DX
	ADD	DX,DX
	POP	BX
	RET
TVIEWMSCROLL ENDP

TVGETC	PROC
	CALL	ogetc
	JZ	TVGETC01	; ZF set: EOF
	INC32	[BP.tv_offset]
TVGETC	ENDP

TVGETC00 PROC
	CMP	AL,0Dh
	JE	TVGETC02
	CMP	AL,0Ah
	JE	TVGETC02
TVGETC00 ENDP

TVGETC01 PROC		; CF clear: Normal byte
	CLC
	RET
TVGETC01 ENDP

TVGETC02 PROC		; CF set: New line
	INC	AH
	STC
	RET
TVGETC02 ENDP

TVUNGETC PROC		; Reverse direction
	CALL	oungetc
	JZ	TVGETC01
	DEC32	[BP.tv_offset]
	JMP	TVGETC00
TVUNGETC ENDP

TVREADTLTAB PROC
	XOR	AX,AX
	CWD
	STO32	[BP.tv_tltab]
	STO32	[BP.tv_offset]
	MOV	[BP.tv_tcount],1
	CALL	OSEEKEAX
	JZ	TLTAB_05
TLTAB_00:
	CALL	TVGETC
	JC	TLTAB_02
	JNZ	TLTAB_00
TLTAB_01:
	CALL	TLTAB_06
	CALL	TLTAB_06
	DEC	[BP.tv_tcount]
	JMP	TLTAB_04
TLTAB_02:
	CALL	TVGETC
	JZ	TLTAB_01
	JC	TLTAB_03
	CALL	TVUNGETC
TLTAB_03:
	CALL	TLTAB_06
	MOV	AX,[BP.tv_tcount]
	CMP	AX,253
	JNA	TLTAB_00
TLTAB_04:
	DEC	[BP.tv_tcount]
TLTAB_05:
	RET
TLTAB_06:
	LEA	BX,[BP.tv_tltab]
	MOV	AX,[BP.tv_tcount]
	SHL	AX,2
	ADD	BX,AX
	LDX32	[BP.tv_offset]
	STO32	SS:[BX]
	INC	[BP.tv_tcount]
	RET
TVREADTLTAB ENDP

TVREADLTAB PROC
	PUSH	SI
	MOV	[BP.tv_lcount],1
	LDX32	STDI.ios_bb
	STO32	[BP.tv_ltab]
	STO32	[BP.tv_offset]
	TEST	tvflag,_C_HEXVIEW
	JZ	LTAB_0
	JMP	LTAB_08
LTAB_0:
	TEST	tvflag,_C_WRAPLINES
	JNZ	LTAB_07
	LEA	BX,[BP.tv_tltab]
	MOV	CX,[BP.tv_tcount]
LTAB_00:
	CMP32	SS:[BX]
	JE	LTAB_01
	ADD	BX,4
	DEC	CX
	JNZ	LTAB_00
	XOR	BX,BX
LTAB_01:
	OR	BX,BX
	JZ	LTAB_03
LTAB_02:
	ADD	BX,4
	LDX32	SS:[BX]
	STO32	[BP.tv_offset]
	CALL	TVADDOFFS
	MOV	AX,[BP.tv_lcount]
	CMP	AX,[BP.tv_rowcnt]
	JA	LTAB_06
	DEC	CX
	JNZ	LTAB_02
	LDX32	[BP.tv_offset]
	CMP32	[BP.tv_fsize]
	JE	LTAB_06
LTAB_03:
	CALL	OSEEKEAX
	JZ	LTAB_07
	MOV	SI,8000h
LTAB_04:
	CALL	ogetc
	JZ	LTAB_05
	INC32	[BP.tv_offset]
	CMP	AL,0Dh
	JE	LTAB_12
	CMP	AL,0Ah
	JE	LTAB_12
	DEC	SI
	JZ	LTAB_12
	JMP	LTAB_04
LTAB_05:
	CALL	TVADDOFFS
	CALL	TVADDOFFS
	DEC	[BP.tv_lcount]
LTAB_06:
	DEC	[BP.tv_lcount]
LTAB_07:
	POP	SI
	JNZ	LTAB_14
	RET
LTAB_08:
	CALL	OSEEKEAX	; Read Hex Table
	JZ	LTAB_07
	MOV	CX,[BP.tv_rowcnt]
LTAB_09:
	LDX32	[BP.tv_offset]
	ADD	AX,8
	ADC	DX,0
	TEST	tvflag,_C_BINVIEW
	JNZ	LTAB_10
	ADD	AX,8
	ADC	DX,0
LTAB_10:
	STO32	[BP.tv_offset]
	CMP32	[BP.tv_fsize]
	JA	LTAB_11
	CALL	TVADDOFFS
	DEC	CX
	JNZ	LTAB_09
	JMP	LTAB_05
LTAB_11:
	LDX32	[BP.tv_fsize]
	STO32	[BP.tv_offset]
	JMP	LTAB_05
LTAB_12:
	CALL	TVGETC
	JZ	LTAB_05
	JC	LTAB_13
	CALL	TVUNGETC
LTAB_13:
	CALL	TVADDOFFS
	MOV	AX,[BP.tv_lcount]
	CMP	AX,[BP.tv_rowcnt]
	JA	LTAB_06
	JMP	LTAB_04
LTAB_14:
	PUSH	DI
	MOV	AX,2020h
	MOV	CX,960*2
	LES	DI,[BP.tv_screen]
	CLD
	REP	STOSW
	POP	DI
	LDX32	STDI.ios_bb
	STO32	[BP.tv_offset]
TVREADLTAB ENDP

OSEEKEAX PROC
	PUSH	DX
	PUSH	AX
	PUSH	SEEK_SET
	CALL	oseekl
	RET
OSEEKEAX ENDP

TVPARSELINE PROC
	PUSH	SI
	PUSH	DI
	XOR	SI,SI
PARSEL_00:
	CALL	TVGETC
	JZ	PARSEL_02
	JC	PARSEL_04
	CMP	AL,9
	JE	PARSEL_06
	MOV	ES:[DI],AL
	INC	DI
	INC	SI
PARSEL_01:
	CMP	SI,80
	JE	PARSEL_07
	JB	PARSEL_00
PARSEL_02:
	POP	DI
	POP	SI
	JZ	PARSEL_03
	ADD	DI,80
PARSEL_03:
	RET
PARSEL_04:
	CALL	TVGETC
	JNA	PARSEL_02
PARSEL_05:
	DEC32	[BP.tv_offset]
	DEC	STDI.ios_i
	JMP	PARSEL_02
PARSEL_06:
	SUB	SI,DI
	ADD	DI,8
	AND	DI,0FFF8h
	ADD	SI,DI
	JMP	PARSEL_01
PARSEL_07:
	CALL	TVGETC
	JZ	PARSEL_02
	JC	PARSEL_04
	JMP	PARSEL_05
TVPARSELINE ENDP

TVREADASC PROC
	CALL	TVREADLTAB
	JZ	RDASC_02
	PUSH	DI
	LES	DI,[BP.tv_screen]
	XOR	AX,AX
	MOV	[BP.tv_bsize],AX
	MOV	[BP.tv_lcount],AX
RDASC_00:
	MOV	AX,[BP.tv_bsize]
	INC	[BP.tv_bsize]
	CMP	AX,[BP.tv_rowcnt]
	JNC	RDASC_01
	CALL	TVADDOFFS
	CALL	TVPARSELINE
	JNZ	RDASC_00
RDASC_01:
	LDX32	[BP.tv_offset]
	SBX32	STDI.ios_bb
	STO32	[BP.tv_scount]
	OR	AX,1
	POP	DI
	RET
RDASC_02:
	XOR	AX,AX
	RET
TVREADASC ENDP

TVREADTXT PROC
	CALL	TVREADLTAB
	JZ	RDTXT_04
	CALL	TVSETMAXCOL
	PUSH	DI
	LES	DI,[BP.tv_screen]
	MOV	[BP.tv_bsize],0
RDTXT_00:
	MOV	AX,[BP.tv_bsize]
	INC	[BP.tv_bsize]
	CMP	AX,[BP.tv_lcount]
	JNC	RDTXT_02
	CALL	TVGETLINESIZE
	ADD	WORD PTR [BP.tv_scount],AX
	ADC	WORD PTR [BP.tv_scount+2],DX
	CMP32	[BP.tv_curcol]
	JA	RDTXT_01
	ADD	DI,80
	JMP	RDTXT_00
RDTXT_01:
	ADD	BX,WORD PTR [BP.tv_curcol]
	ADD	CX,WORD PTR [BP.tv_curcol+2]
	MOV	AX,BX
	MOV	DX,CX
	CALL    OSEEKEAX
	JZ	RDTXT_04
	CALL	TVPARSELINE
	JNZ	RDTXT_00
RDTXT_02:
	OR	AX,1
RDTXT_03:
	POP	DI
	RET
RDTXT_04:
	XOR	AX,AX
	JMP	RDTXT_03
TVREADTXT ENDP

MK_HEXW	PROC
	MOV	AH,AL
	AND	AX,0FF0h
	SHR	AL,04h
	ADD	AX,3030h
	CMP	AH,39h
	JBE	HEXW_00
	ADD	AH,07h
HEXW_00:
	CMP	AL,39h
	JBE	HEXW_01
	ADD	AL,07h
HEXW_01:
	RET
MK_HEXW	ENDP

TVREADHEX PROC
	CALL	TVREADLTAB
	JNZ	RDHEX_01
RDHEX_00:
	RET
RDHEX_01:
	CALL	ogetc
	JZ	RDHEX_00
	DEC	STDI.ios_i
	MOV	AX,8
	TEST	tvflag,_C_BINVIEW
	JNZ	RDHEX_02
	ADD	AX,AX
RDHEX_02:
	MUL	[BP.tv_rowcnt]
	CMP	AX,STDI.ios_c
	JNBE	RDHEX_03
	MOV	STDI.ios_c,AX
RDHEX_03:
	MOV	AX,STDI.ios_c
	XOR	CX,CX
	MOV	WORD PTR [BP.tv_scount],AX
	MOV	WORD PTR [BP.tv_scount+2],CX
	PUSH	DI
	LES	DI,[BP.tv_screen]
RDHEX_04:
	PUSH	DI
	LEA	BX,[BP.tv_ltab]
	MOV	AX,CX
	SHL	AX,2
	ADD	AX,3
	ADD	BX,AX
	MOV	DX,4
	TEST	tvflag,_C_HEXOFFSET OR _C_BINVIEW
	JNZ	RDHEX_05
	PUSH32	SS:[BX-3]
	MOV	AX,OFFSET format_10u
	MOV	DX,ES
	MOV	BX,DI
	CALL	@sprintf
	ADD	SP,4
	ADD	DI,9
	JMP	RDHEX_06
RDHEX_05:
	MOV	AL,SS:[BX]
	CALL	MK_HEXW
	MOV	ES:[DI],AX
	ADD	DI,2
	DEC	BX
	DEC	DX
	JNZ	RDHEX_05
	INC	DI
RDHEX_06:
	MOV	DX,STDI.ios_c
	MOV	AX,8
	TEST	tvflag,_C_BINVIEW
	JNZ	RDHEX_07
	ADD	AX,AX
	ADD	DI,3
RDHEX_07:
	CMP	DX,AX
	JC	RDHEX_08
	MOV	DX,AX
RDHEX_08:
	OR	DX,DX
	JZ	RDHEX_16
	SUB	STDI.ios_c,DX
	MOV	BX,DI
	ADD	BX,51
	PUSH	CX
	MOV	CX,DX
	XOR	DX,DX
RDHEX_09:
	TEST	tvflag,_C_BINVIEW
	JNZ	RDHEX_11
RDHEX_10:
	CMP	DX,8
	JNZ	RDHEX_11
	MOV	AL,179
	MOV	ES:[DI],AL
	ADD	DI,2
RDHEX_11:
	MOV	AX,STDI.ios_i
	PUSH	ES
	PUSH	BX
	LES	BX,STDI.ios_bp
	ADD	BX,AX
	MOV	AL,ES:[BX]
	POP	BX
	POP	ES
	INC	STDI.ios_i
	TEST	tvflag,_C_BINVIEW
	JNZ	RDHEX_12
	MOV	ES:[BX],AL
	CALL	MK_HEXW
	MOV	ES:[DI],AX
	ADD	DI,3
	INC	BX
	INC	DX
	DEC	CX
	JNZ	RDHEX_10
	JMP	RDHEX_15
RDHEX_12:
	MOV	AH,AL
	PUSH	CX
	MOV	CX,8
RDHEX_13:
	MOV	AL,AH
	SHL	AH,1
	AND	AL,80h
	MOV	AL,'1'
	JNZ	RDHEX_14
	MOV	AL,'0'
RDHEX_14:
	MOV	ES:[DI],AL
	INC	DI
	DEC	CX
	JNZ	RDHEX_13
	POP	CX
	INC	DI
	INC	DX
	DEC	CX
	JNZ	RDHEX_09
RDHEX_15:
	POP	CX
	POP	DI
	ADD	DI,80
	INC	CX
	CMP	CX,[BP.tv_lcount]
	JNC	RDHEX_17
	JMP	RDHEX_04
RDHEX_16:
	POP	DI
RDHEX_17:
	OR	AX,1
	POP	DI
	RET
TVREADHEX ENDP

TVPREVLINE PROC
	JMP	PREVL_04
PREVL_00:
	LDX32	[BP.tv_fsize]
	STO32	STDI.ios_bb
	RET
PREVL_01:
	XOR	CX,CX
	MOV	BX,8
	TEST	tvflag,_C_BINVIEW
	JNZ	PREVL_02
	MOV	BX,16
PREVL_02:
	CMP	DX,CX
	JNE	PREVL_02B
	CMP	AX,BX
PREVL_02B:
	JBE	PREVL_03
	SUB	AX,BX
	SBB	DX,CX
	RET
PREVL_03:
	XOR	AX,AX
	CWD
	RET
PREVL_04:
	LDX32	STDI.ios_bb
	STO32	[BP.tv_offset]
	MOV	CX,DX
	OR	CX,AX
	JZ	PREVL_03
	CMP32	[BP.tv_fsize]
	JA	PREVL_00
	TEST	tvflag,_C_HEXVIEW
	JNZ	PREVL_01
	CALL	TVGETLASTOFFSET
	CMP32	[BP.tv_offset]
	JB	PREVL_07
	LDX32	[BP.tv_offset]
	MOV	CX,[BP.tv_tcount]
	DEC	CX
PREVL_05:
	LEA	BX,[BP.tv_tltab]
	PUSH	AX
	MOV	AX,CX
	SHL	AX,2
	ADD	BX,AX
	POP	AX
	CMP32	SS:[BX]
	JA	PREVL_06
	OR	CX,CX
	JZ	PREVL_03
	DEC	CX
	JMP	PREVL_05
PREVL_06:
	LDX32	SS:[BX]
	JMP	PREVL_11
PREVL_07:
	LDX32	[BP.tv_offset]
	CALL	OSEEKEAX
	JZ	PREVL_03
	CALL	TVUNGETC
	JZ	PREVL_03
	PUSH	SI
	MOV	SI,8000h
	JNC	PREVL_08
	CALL	TVUNGETC
	JZ	PREVL_09
PREVL_08:
	CALL	oungetc
	JZ	PREVL_09
	DEC32	[BP.tv_offset]
	CMP	AL,0Dh
	JE	PREVL_10
	CMP	AL,0Ah
	JE	PREVL_10
	DEC	SI
	JZ	PREVL_10
	JMP	PREVL_08
PREVL_09:
	POP	SI
	XOR	AX,AX
	CWD
	RET
PREVL_10:
	POP	SI
	LDX32	[BP.tv_offset]
	ADD	AX,1
	ADC	DX,0
PREVL_11:
	TEST	tvflag,_C_WRAPLINES
	JNZ	PREVL_12
	RET
PREVL_12:
	CMP32	STDI.ios_bb
	JG	PREVL_15
	MOV	BX,WORD PTR STDI.ios_bb
	MOV	CX,WORD PTR STDI.ios_bb+2
	SUB	BX,AX
	SBB	CX,DX
	OR	CX,CX
	JNZ	PREVL_17
	CMP	BX,8000h
	JB	PREVL_13
PREVL_17:
	ADD	AX,BX
	ADC	DX,CX
	SUB	AX,80
	SBB	DX,0
PREVL_13:
	STO32	[BP.tv_offset]
	STO32	[BP.tv_ddtmp]
	CALL	OSEEKEAX
	JZ	PREVL_15
	PUSH	DI
PREVL_14:
	LES	DI,[BP.tv_screen]
	CALL	TVPARSELINE
	JZ	PREVL_16
	LDX32	[BP.tv_offset]
	CMP32	STDI.ios_bb
	jae	PREVL_16
	STO32	[BP.tv_ddtmp]
	JMP	PREVL_14
PREVL_15:
	XOR	AX,AX
	CWD
	RET
PREVL_16:
	POP	DI
	LDX32	[BP.tv_ddtmp]
	RET
TVPREVLINE ENDP

TVREAD	PROC
	XOR	AX,AX
	MOV	WORD PTR [BP.tv_scount],AX
	MOV	WORD PTR [BP.tv_scount+2],AX
	MOV	AL,tvflag
	TEST	AL,_C_HEXVIEW
	JNZ	TVREAD_01
	TEST	AL,_C_WRAPLINES
	JNZ	TVREAD_00
	CALL	TVREADTXT
	JMP	TVREAD_02
TVREAD_00:
	CALL	TVREADASC
	JMP	TVREAD_02
TVREAD_01:
	CALL	TVREADHEX
TVREAD_02:
	RET
TVREAD	ENDP

TVPUTPAGE PROC
	LDX32	[BP.tv_scount]
	ADX32	STDI.ios_bb
	MOV	CX,DX
	OR	CX,AX
	JZ	TVPUTP_00
	XOR	CX,CX
	MOV	BX,100
	CALL	MUL32
	MOV	BX,WORD PTR [BP.tv_fsize]
	MOV	CX,WORD PTR [BP.tv_fsize+2]
	CALL	DIV32
	AND	AX,007Fh
	CMP	AX,100
	JBE	TVPUTP_01
TVPUTP_00:
	MOV	AX,100
TVPUTP_01:
	PUSH	AX
	MOV	AX,OFFSET format_3d
	XOR	CX,CX
	MOV	BX,75
	CALL	@scputf
	PUSH	WORD PTR [BP.tv_curcol+2]
	PUSH	WORD PTR [BP.tv_curcol]
	MOV	AX,OFFSET format_8ld
	MOV	BX,65
	CALL	@scputf
	ADD	SP,6
	CMP	WORD PTR [BP.tv_fsize+2],0
	JNE	TVPUTP_01B
	CMP	WORD PTR [BP.tv_fsize],0
	JE	TVPUTP_03
TVPUTP_01B:
	MOV	AX,80
	MUL	[BP.tv_rowcnt]
	MOV	CX,AX
if USE_MOUSE
	CALL	mousehide
endif
	MOV	AX,0B800h
	MOV	ES,AX
	PUSH	DS
	PUSH	SI
	PUSH	DI
	LDS	SI,[BP.tv_screen]
	MOV	DI,160
	CLD
TVPUTP_02:
	MOVSB
	INC	DI
	DEC	CX
	JNZ	TVPUTP_02
	POP	DI
	POP	SI
	POP	DS
if USE_MOUSE
	CALL	mouseshow
endif
TVPUTP_03:
	RET
TVPUTPAGE ENDP

TVIEW_HOME PROC
	XOR	AX,AX
	MOV	WORD PTR [BP.tv_curcol],AX
	MOV	WORD PTR [BP.tv_curcol+2],AX
	MOV	WORD PTR STDI.ios_bb,AX
	MOV	WORD PTR STDI.ios_bb+2,AX
TVIEW_HOME ENDP

TVREREAD PROC
	CALL	TVREAD
	JZ	TVREREAD_00
	CALL	TVPUTPAGE
	MOV	AX,1
TVREREAD_00:
	RET
TVREREAD ENDP

TVIEW_END PROC
	TEST	tvflag,_C_HEXVIEW
	JNZ	TV_END_00
	MOV	AX,[BP.tv_lcount]
	CMP	AX,[BP.tv_rowcnt]
	JB	TV_END_02
	LDX32	[BP.tv_scount]
	ADX32	STDI.ios_bb
	ADD	AX,1
	ADC	DX,0
	CMP32	[BP.tv_fsize]
	JAE	TV_END_02
	LDX32	[BP.tv_fsize]
	STO32	STDI.ios_bb
	JMP	TVIEW_TXTPGUP
TV_END_00:
	MOV	AX,[BP.tv_rowcnt]
	MOV	CL,3
	TEST	tvflag,_C_BINVIEW
	JNZ	TV_END_01
	INC	CL
TV_END_01:
	XOR	DX,DX
	SHL	AX,CL
	ADD	AX,1
	ADC	DX,0
	CMP32	[BP.tv_fsize]
	JAE	TV_END_02
	SBX32	[BP.tv_fsize]
	NOT	AX
	NOT	DX
	ADD	AX,18
	ADC	DX,0
	AND	AL,0F0h
	STO32	STDI.ios_bb
	JMP	TVREREAD
TV_END_02:
	RET
TVIEW_END ENDP

TVIEW_UP PROC
	CALL	TVPREVLINE
	CMP32	STDI.ios_bb
	JZ	TV_UP_00
	STO32	STDI.ios_bb
	JMP	TVREREAD
TV_UP_00:
	RET
TVIEW_UP ENDP

TVIEW_DOWN PROC
	TEST	tvflag,_C_HEXVIEW
	JZ	TV_DN_02
	XOR	CX,CX
	MOV	BX,8
	TEST	tvflag,_C_BINVIEW
	JNZ	TV_DN_00
	ADD	BX,BX
TV_DN_00:
	LDX32	[BP.tv_scount]
	ADX32	STDI.ios_bb
	ADD	AX,1
	ADC	DX,0
	CMP32	[BP.tv_fsize]
	JNC	TV_DN_03
	ADD	AX,BX
	ADC	DX,CX
	CMP32	[BP.tv_fsize]
	JC	TV_DN_01
	JMP	TVIEW_END
TV_DN_01:
	ADD	WORD PTR STDI.ios_bb,BX
	ADC	WORD PTR STDI.ios_bb+2,CX
	JMP	TVREREAD
TV_DN_02:
	MOV	AX,[BP.tv_lcount]
	CMP	AX,[BP.tv_rowcnt]
	JC	TV_DN_03
	LEA	BX,[BP.tv_ltab]
	ADD	BX,4
	LDX32	SS:[BX]
	STO32	STDI.ios_bb
	JMP	TVREREAD
TV_DN_03:
	XOR	AX,AX
	RET
TVIEW_DOWN ENDP

TVIEW_PGUP PROC
	LDX32	STDI.ios_bb
	OR	AX,DX
	JZ	TV_PGUP_03
	TEST	tvflag,_C_HEXVIEW
	JZ	TVIEW_TXTPGUP
	MOV	AX,[BP.tv_rowcnt]
	MOV	CL,4
	TEST	tvflag,_C_BINVIEW
	JZ	TV_PGUP_00
	MOV	CL,3
TV_PGUP_00:
	SHL	AX,CL
	XOR	DX,DX
	CMP32	STDI.ios_bb
	JNB	TV_PGUP_01
	SUB	WORD PTR STDI.ios_bb,AX
	SBB	WORD PTR STDI.ios_bb+2,DX
	JMP	TV_PGUP_02
TV_PGUP_01:
	XOR	AX,AX
	MOV	WORD PTR STDI.ios_bb,AX
	MOV	WORD PTR STDI.ios_bb+2,AX
TV_PGUP_02:
	JMP	TVREREAD
TV_PGUP_03:
	RET
TVIEW_PGUP ENDP

TVIEW_TXTPGUP PROC
	PUSH	DI
	MOV	DI,1
	TEST	tvflag,_C_WRAPLINES
	JNZ	TV_TPGUP_02
TV_TPGUP_00:
	CALL	TVPREVLINE
	CMP32	STDI.ios_bb
	JZ	TV_TPGUP_01
	STO32	STDI.ios_bb
	INC	DI
	CMP	DI,[BP.tv_rowcnt]
	JNZ	TV_TPGUP_00
TV_TPGUP_01:
	POP	DI
	JMP	TVREREAD
TV_TPGUP_02:
	LDX32	STDI.ios_bb
	CMP32	[BP.tv_fsize]
	JNZ	TV_TPGUP_00
	MOV	DI,[BP.tv_rowcnt]
	DEC	DI
TV_TPGUP_03:
	CALL	TVPREVLINE
	STO32	STDI.ios_bb
	DEC	DI
	JNZ	TV_TPGUP_03
	JMP	TV_TPGUP_01
TVIEW_TXTPGUP ENDP

TVIEW_PGDN PROC
	LDX32	[BP.tv_scount]
	ADX32	STDI.ios_bb
	ADD	AX,1
	ADC	DX,0
	CMP32	[BP.tv_fsize]
	JNB	TV_PGDN_03
	TEST	tvflag,_C_HEXVIEW
	JZ	TV_PGDN_01
	MOV	CX,DX
	MOV	BX,AX
	MOV	AX,[BP.tv_rowcnt]
	PUSH	CX
	MOV	CL,4
	TEST	tvflag,_C_BINVIEW
	JZ	TV_PGDN_00
	DEC	CL
TV_PGDN_00:
	SHL	AX,CL
	POP	CX
	XOR	DX,DX
	ADD	BX,AX
	ADC	CX,DX
	CMP	CX,WORD PTR [BP.tv_fsize+2]
	JNE	TV_PGDN_04
	CMP	BX,WORD PTR [BP.tv_fsize]
TV_PGDN_04:
	JNC	TV_PGDN_02
	ADD	WORD PTR STDI.ios_bb,AX
	ADC	WORD PTR STDI.ios_bb+2,DX
	JMP	TVREREAD
TV_PGDN_01:
	MOV	AX,[BP.tv_lcount]
	CMP	AX,[BP.tv_rowcnt]
	JNZ	TV_PGDN_03
	MOV	AX,[BP.tv_lcount]
	DEC	AX
	SHL	AX,2
	LEA	BX,[BP.tv_ltab]
	ADD	BX,AX
	LDX32	SS:[BX]
	CMP32	[BP.tv_fsize]
	JNC	TV_PGDN_02
	STO32	STDI.ios_bb
	JMP	TVREREAD
TV_PGDN_02:
	JMP	TVIEW_END
TV_PGDN_03:
	RET
TVIEW_PGDN ENDP

TVIEW_LEFT PROC
	TEST	tvflag,_C_HEXVIEW OR _C_BINVIEW OR _C_WRAPLINES
	JNZ	TV_LEFT_00
	XOR	AX,AX
	CWD
	CMP32	[BP.tv_curcol]
	JE	TV_LEFT_00
	SUB	WORD PTR [BP.tv_curcol],1
	SBB	WORD PTR [BP.tv_curcol+2],0
	JMP	TVREREAD
TV_LEFT_00:
	RET
TVIEW_LEFT ENDP

TVIEW_PGLEFT PROC
	TEST	tvflag,_C_HEXVIEW OR _C_BINVIEW OR _C_WRAPLINES
	JNZ	TV_PGLEFT_02
	LDX32	[BP.tv_curcol]
	MOV	CX,DX
	OR	CX,AX
	JZ	TV_PGLEFT_02
	OR	DX,DX
	JNZ 	TV_PGLEFT_00
	CMP	AX,80
	JNBE	TV_PGLEFT_00
	XOR	AX,AX
	CWD
	JMP	TV_PGLEFT_01
TV_PGLEFT_00:
	SUB	AX,80
	SBB	DX,0
TV_PGLEFT_01:
	STO32	[BP.tv_curcol]
	JMP	TVREREAD
TV_PGLEFT_02:
	RET
TVIEW_PGLEFT ENDP

TVIEW_RIGHT PROC
	TEST	tvflag,_C_HEXVIEW OR _C_BINVIEW OR _C_WRAPLINES
	JNZ	TV_RIGHT_00
	LDX32	[BP.tv_curcol]
	CMP32	[BP.tv_maxcol]
	JZ	TV_RIGHT_00
	INC32	[BP.tv_curcol]
	JMP	TVREREAD
TV_RIGHT_00:
	RET
TVIEW_RIGHT ENDP

TVIEW_PGRIGHT PROC
	TEST	tvflag,_C_HEXVIEW OR _C_BINVIEW OR _C_WRAPLINES
	JNZ	TV_PGRIGHT_00
	LDX32	[BP.tv_curcol]
	CMP32	[BP.tv_maxcol]
	JB	TV_PGRIGHT_01
TV_PGRIGHT_00:
	RET
TV_PGRIGHT_01:
	ADD	AX,80
	ADC	DX,0
	CMP32	[BP.tv_maxcol]
	JB	TV_PGRIGHT_02
	LDX32	[BP.tv_maxcol]
TV_PGRIGHT_02:
	STO32	[BP.tv_curcol]
	JMP	TVREREAD
TVIEW_PGRIGHT ENDP

TVIEW_ENDRIGHT PROC
	TEST	tvflag,_C_HEXVIEW OR _C_BINVIEW OR _C_WRAPLINES
	JNZ	TV_ENDR_00
	LDX32	[BP.tv_maxcol]
	OR	DX,DX
	JNZ	TV_ENDR_01
	CMP	AX,80
	JNBE	TV_ENDR_01
TV_ENDR_00:
	RET
TV_ENDR_01:
	SUB	AX,20
	SBB	DX,0
TVIEW_ENDRIGHT ENDP

TV_ENDR_03 PROC
	STO32	[BP.tv_curcol]
	JMP	TVREREAD
TV_ENDR_03 ENDP

TVIEW_TOLSTART PROC
	XOR	AX,AX
	CWD
	JMP	TV_ENDR_03
TVIEW_TOLSTART ENDP

TVIEW_SEARCH PROC
	CALL	continuesearch
	OR	AX,AX
	JNZ	TVIEW_TOLSTART
	RET
TVIEW_SEARCH ENDP

TVIEW_CMSEARCH PROC
	AND	STDI.ios_flag,NOT IO_SEARCHMASK
	MOV	AL,fsflag
	AND	AX,IO_SEARCHMASK
	OR	STDI.ios_flag,AX
	PUSH	WORD PTR [BP.tv_fsize+2]
	PUSH	WORD PTR [BP.tv_fsize]
	CALL	cmdsearch
	PUSH	AX
	AND	fsflag,NOT IO_SEARCHMASK
	MOV	AX,STDI.ios_flag
	AND	STDI.ios_flag,NOT (IO_SEARCHSET OR IO_SEARCHCUR)
	AND	AL,IO_SEARCHMASK
	OR	fsflag,AL
	POP	AX
	OR	AX,AX
	JZ	TV_SEARCH_00
	JMP	TVREREAD
TV_SEARCH_00:
	RET
TVIEW_CMSEARCH ENDP

TVIEW_IDDOFFS PROC
	PUSH	DX
	PUSH	AX
	PUSH	WORD PTR STDI.ios_bb+2
	PUSH	WORD PTR STDI.ios_bb
	MOV	AX,OFFSET format_08lXh
	TEST	tvflag,_C_HEXOFFSET
	JNZ	TV_IDDOFFS_00
	MOV	AX,OFFSET format_lu
TV_IDDOFFS_00:
	MOV	DX,WORD PTR ES:[BX+16+2].to_data
	MOV	BX,WORD PTR ES:[BX+16].to_data
	CALL	@sprintf
	ADD	SP,4
	CALL	tdinit
	RET
TVIEW_IDDOFFS ENDP

TVIEW_IDDSEEK PROC
	PUSH	DS
	PUSH	WORD PTR IDD_TVSeek
	CALL	rsopen
	JZ	TV_SEEK_02
	PUSH	DX
	PUSH	AX
	PUSH	DS
	PUSH	WORD PTR IDD_TVSeek
	PUSH	DX
	PUSH	AX
	CALL	TVIEW_IDDOFFS
	CALL	rsevent
	CALL	twclose
	MOV	AX,DX
	OR	AX,AX
	JZ	TV_SEEK_02
	PUSH	WORD PTR ES:[BX+TO_ODATA+18]
	PUSH	WORD PTR ES:[BX+TO_ODATA+16]
	CALL	strtol
if USE_MEMREAD
	TEST	STDI.ios_flag,IO_MEMREAD
	JZ	TV_SEEK_01
	CALL	NORMALIZE
endif
TV_SEEK_01:
	CMP32	[BP.tv_fsize]
	JA	TV_SEEK_04
	STO32	STDI.ios_bb
	XOR	AX,AX
	INC	AX
TV_SEEK_02:
	RET
TV_SEEK_04:
	XOR	AX,AX
	JMP	TV_SEEK_02
TVIEW_IDDSEEK ENDP

TVIEW_CMSEEK PROC
	CALL	TVIEW_IDDSEEK
	JZ	TV_CMSEEK_00
	JMP	TVREREAD
TV_CMSEEK_00:
	RET
TVIEW_CMSEEK ENDP

TVIEW_COPY PROC
	PUSH	DS
	PUSH	WORD PTR IDD_TVCopy
	CALL	rsopen
	JNZ	TVCOPY_01
TVCOPY_00:
	RET
TVCOPY_01:
	PUSH	DX
	PUSH	AX
	PUSH	DS
	PUSH    WORD PTR IDD_TVCopy
	PUSH	DX
	PUSH	AX
	MOV	WORD PTR [BP.tv_ddtmp],AX
	MOV	WORD PTR [BP.tv_ddtmp+2],DX
	TEST	tvflag,_C_CLIPBOARD
	JZ	TVCOPY_02
	OR	BYTE PTR ES:[BX+4*16],_O_FLAGB
TVCOPY_02:
	CALL	TVIEW_IDDOFFS
	CALL	rsevent
	OR	AX,AX
	JZ	TVCOPY_CLOSE
	PUSH	WORD PTR ES:[BX+TO_ODATA+18]
	PUSH	WORD PTR ES:[BX+TO_ODATA+16]
	AND	tvflag,NOT _C_CLIPBOARD
	TEST	BYTE PTR ES:[BX+4*16],_O_FLAGB
	JZ	TVCOPY_03
	OR	tvflag,_C_CLIPBOARD
TVCOPY_03:
	CALL	strtol
	CMP32	[BP.tv_fsize]
	JB	TVCOPY_05
	XOR	AX,AX
TVCOPY_CLOSE:
	CALL	twclose
	MOV	AX,DX
	OR	AX,AX
	RET
TVCOPY_04:
	MOV	AX,1
	JMP	TVCOPY_CLOSE
TVCOPY_05:
	PUSH	DX
	PUSH	AX
	PUSH	SEEK_SET
	CALL	oseek
	JZ	TVCOPY_06
	TEST	tvflag,_C_CLIPBOARD
	JNZ	TVCOPY_07
	MOV	AX,OSTDO
	CALL	oinitst
	JZ	TVCOPY_CLOSE
	LES	BX,[BP.tv_ddtmp]
	PUSH	ES:[BX+TO_ODATA+3*16+2]
	PUSH	ES:[BX+TO_ODATA+3*16]
	CALL	ogetouth
	CMP	AX,-1
	JZ	TVCOPY_06
	MOV	STDO.ios_file,AX
	LES	BX,[BP.tv_ddtmp]
	PUSH	WORD PTR ES:[BX+TO_ODATA+34]
	PUSH	WORD PTR ES:[BX+TO_ODATA+32]
	CALL	strtol
	PUSH	DX
	PUSH	AX
	CALL	ocopy
	CALL	ofwrite
	MOV	AX,OSTDO
	CALL	oclose
TVCOPY_06:
	MOV	AX,OSTDO
	CALL	ofreest
	JMP	TVCOPY_04
TVCOPY_07:
	LES	BX,[BP.tv_ddtmp]
	PUSH	WORD PTR ES:[BX+TO_ODATA+34]
	PUSH	WORD PTR ES:[BX+TO_ODATA+32]
	CALL	strtol
	OR	DX,DX
	JNZ	TVCOPY_04
	OR	AX,AX
	JZ	TVCOPY_04
	CMP	AX,STDI.ios_c
	JNA	TVCOPY_08
	JMP	TVCOPY_04
TVCOPY_08:
	PUSH	WORD PTR STDI.ios_bp+2
	PUSH	WORD PTR STDI.ios_bp
	PUSH	AX
	CALL	ClipboardInit
	CALL	ClipboardOpen
	CALL	ClipboardEmpty
	CALL	ClipboardCopy
	CALL	ClipboardClose
	CALL	ClipboardFree
	JMP	TVCOPY_04
TVIEW_COPY ENDP

TVUPDATEDLG PROC
	MOV	BX,0100h
	MOV	DX,[BP.tv_rowcnt]
	MOV	AX,80
	MUL	DL
	MOV	CX,AX
	MOV	AL,at_background[B_Desktop]
	OR	AL,07h
	TEST	tvflag,_C_HIGHCOLOR
	JZ	TVUPDDLG_00
	OR	AL,0Fh
TVUPDDLG_00:
	CALL	@scputa
	MOV	BL,35
	INC	DL
	MOV	BH,DL
	MOV	CX,5
	MOV	AX,OFFSET cp_hex
	TEST	tvflag,_C_HEXVIEW
	JZ	TVUPDDLG_01
	MOV	AX,OFFSET cp_ascii
TVUPDDLG_01:
	CALL	@scputds
	MOV	BL,13
	INC	CL
	MOV	AX,OFFSET cp_unwrap
	TEST	tvflag,_C_WRAPLINES
	JNZ	TVUPDDLG_02
	MOV	AX,OFFSET cp_wrap
TVUPDDLG_02:
	CALL	@scputds
	MOV	BL,54
	MOV	CL,3
	MOV	AX,OFFSET cp_deci
	TEST	tvflag,_C_HEXOFFSET
	JNZ	TVUPDDLG_03
	MOV	AX,OFFSET cp_hex
TVUPDDLG_03:
	CALL	@scputds
	RET
TVUPDATEDLG ENDP

TVUPDDLG PROC
	CALL	TVUPDATEDLG
	JMP	TVREREAD
TVUPDDLG ENDP

TVOUT0000 PROC
	XOR	AX,AX
	RET
TVOUT0000 ENDP

TVIEW_CMWRAP PROC
	XOR	AX,AX
	CWD
	CMP32	[BP.tv_fsize]
	JE	TVOUT0000
	TEST	tvflag,_C_HEXVIEW
	JNE	TVOUT0000
	XOR	tvflag,_C_WRAPLINES
	JMP	TVUPDDLG
TVIEW_CMWRAP ENDP

TVIEW_CMOFFS PROC
	XOR	AX,AX
	CWD
	CMP32	[BP.tv_fsize]
	JE	TVOUT0000
	XOR	tvflag,_C_HEXOFFSET
	JMP	TVUPDDLG
TVIEW_CMOFFS ENDP

TVIEW_CMBINARY PROC
	XOR	AX,AX
	CWD
	CMP32	[BP.tv_fsize]
	JE	TVOUT0000
	TEST	tvflag,_C_HEXVIEW
	JNZ	TV_BIN_00
	OR	tvflag,_C_HEXVIEW OR _C_BINVIEW
	JMP	TVUPDDLG
TV_BIN_00:
	XOR	tvflag,_C_BINVIEW
	JMP	TVUPDDLG
TVIEW_CMBINARY	ENDP

TVIEW_CMHEX PROC
	XOR	AX,AX
	CWD
	CMP32	[BP.tv_fsize]
	JE	TVOUT0000
	AND	tvflag,NOT _C_BINVIEW
	XOR	tvflag,_C_HEXVIEW
	TEST	tvflag,_C_HEXVIEW
	JNZ	TV_CMHEX_01
	LDX32	[BP.tv_curcol]
	CMP32	STDI.ios_bb
	JNA	TV_CMHEX_00
	JMP	TVUPDDLG
TV_CMHEX_00:
	SUB	WORD PTR STDI.ios_bb,AX
	SBB	WORD PTR STDI.ios_bb+2,DX
	JMP	TVUPDDLG
TV_CMHEX_01:
	LDX32	[BP.tv_curcol]
	ADD	WORD PTR STDI.ios_bb,AX
	ADC	WORD PTR STDI.ios_bb+2,DX
	JMP	TVUPDDLG
TVIEW_CMHEX ENDP

TVIEW_CMCOLOR PROC
	XOR	tvflag,_C_HIGHCOLOR
	CALL	TVUPDATEDLG
	MOV	AX,1
	RET
TVIEW_CMCOLOR ENDP

TVIEW_CMHELP PROC
	PUSH	DS
	PUSH	WORD PTR IDD_TVHelp
	CALL	rsmodal
	RET
TVIEW_CMHELP ENDP

TVIEW_CMQUIT PROC
	MOV	[BP.tv_switch],1
	XOR	AX,AX
	RET
TVIEW_CMQUIT ENDP

if USE_MOUSE

TVIEW_MSCROLL PROC
	CALL	mousey
	PUSH	AX
	CALL	mousex
	POP	DX
	CALL	TVIEWMSCROLL
	RET
TVIEW_MSCROLL ENDP

TVSCROLLD00 PROC
	MOV	AX,KEY_UP
	JMP	TVSCROLLD02
TVSCROLLD00 ENDP

TVSCROLLD01 PROC
	MOV	AX,KEY_DOWN
TVSCROLLD01 ENDP

TVSCROLLD02 PROC
	PUSH	DX
	JMP	TVSCROLLD05
TVSCROLLD02 ENDP

TVSCROLLD03 PROC
	PUSH	AX
	MOV	AX,KEY_LEFT
	JMP	TVSCROLLD05
TVSCROLLD03 ENDP

TVSCROLLD04 PROC
	PUSH	AX
	MOV	AX,KEY_RIGHT
TVSCROLLD04 ENDP

TVSCROLLD05 PROC
	CALL	TVIEW_EVENT
	POP	AX
	MOV	DI,AX
TVSCROLLD05 ENDP

TVSCROLLD06 PROC
	OR	DI,DI
	JZ	SCROLLD06_00
	PUSH	DI
	CALL	delay
SCROLLD06_00:
	RET
TVSCROLLD06 ENDP

TVIEW_SCROLLD PROC
	PUSH	DI
	XOR	DI,DI
	CALL	TVIEW_MSCROLL
	ADD	BX,BX
	CALL	[BX+TVSCROLLDDELAY]
	POP	DI
	RET
TVIEW_SCROLLD ENDP

TVIEW_MOUSE PROC
	CALL	mousep
	JZ	TVMOUSE_07
	CALL	mousex
	MOV	[BP.tv_xpos],AX
	CALL	mousey
	MOV	[BP.tv_ypos],AX
	DEC	AX
	CMP	AX,[BP.tv_rowcnt]
	JNE	TVMOUSE_08
	CALL	msloop
	MOV	AX,[BP.tv_xpos]
	CMP	AL,9
	JNB	TVMOUSE_00
	JMP	TVIEW_CMHELP
TVMOUSE_00:
	JE	TVMOUSE_07
	CMP	AL,20
	JNB	TVMOUSE_01
	JMP	TVIEW_CMWRAP
TVMOUSE_01:
	JZ	TVMOUSE_07
	CMP	AL,31
	JNB	TVMOUSE_02
	JMP	TVIEW_CMSEARCH
TVMOUSE_02:
	JE	TVMOUSE_07
	CMP	AL,41
	JNB	TVMOUSE_03
	JMP	TVIEW_CMHEX
TVMOUSE_03:
	JE	TVMOUSE_07
	CMP	AL,50
	JNB	TVMOUSE_04
	JMP	TVIEW_COPY
TVMOUSE_04:
	JE	TVMOUSE_07
	CMP	AL,58
	JNB	TVMOUSE_05
	JMP	TVIEW_CMOFFS
TVMOUSE_05:
	JE	TVMOUSE_07
	CMP	AL,66
	JNBE	TVMOUSE_06
	JMP	TVIEW_CMSEEK
TVMOUSE_06:
	CMP	AL,70
	JBE	TVMOUSE_07
	CALL	TVIEW_CMQUIT
TVMOUSE_07:
	XOR	AX,AX
	RET
TVMOUSE_08:
	CALL	mousep
	CMP	AX,1
	JNE	TVMOUSE_07
	CALL	TVIEW_SCROLLD
	JMP	TVMOUSE_08
TVIEW_MOUSE ENDP
endif
TVIEW_EVENT PROC
	MOV	CX,TVkey_count
	XOR	BX,BX
	MOV	DX,WORD PTR [BP.tv_fsize]
	OR	DX,WORD PTR [BP.tv_fsize+2]
	JNZ	TVEVENT_00
	MOV	CX,TVkey_glcount
TVEVENT_00:
	CMP	AX,[BX+TVkey_global]
	JE	TVEVENT_01
	ADD	BX,2
	LOOP	TVEVENT_00
	RET
TVEVENT_01:
	JMP	[BX+TVIEW_KEYPROC]
TVIEW_EVENT ENDP

TVIEW_MODAL PROC
	CMP	[BP.tv_switch],0
	JNE	TVMODAL_04
TVMODAL_00:
if USE_MOUSE
	CALL	mousep
	OR	AX,AX
	JNZ	TVMODAL_01
endif
	CALL	getkey
	OR	AX,AX
	JZ	TVMODAL_00
	JMP	TVMODAL_02
TVMODAL_01:
if USE_MOUSE
	CALL	TVIEW_MOUSE
endif
	JMP	TVMODAL_03
TVMODAL_02:
	CALL	TVIEW_EVENT
TVMODAL_03:
	CALL	msloop
	JMP	TVIEW_MODAL
TVMODAL_04:
	XOR	AX,AX
	RET
TVIEW_MODAL ENDP

;----------------------------------------------------------------------------

Textview PROC 	DIST
; int Textview(char *file, long offs, long memoffs, long memsize);
;
; Name:    +16[BP] +18 == [BP.tv_SSFILENAME]
; Offset:  +12[BP] +14 == [BP.tv_SSOFFSET]  == [BP.tv_offset] == STDI.ios_bb
; Adress:  + 8[BP] +10 == [BP.tv_SSMEMOFFS] == [DS:tvmem_offs]
; Memsize: + 4[BP] + 6 == [BP.tv_SSMEMSIZE] == [DS:tvmem_size]

	PUSH	BP
	SUB	SP,tv_SSSIZE
	MOV	BP,SP
	PUSH	SI
	PUSH	DI
	PUSH	SS			; clear stack
	PUSH	BP
	PUSH	tv_SSSIZE
	CALL	memzero			; make memory size global for IOST
if USE_MEMREAD
	MOV32	tvmem_size,[BP.tv_SSMEMSIZE]
	LDX32	[BP.tv_SSMEMOFFS]	; convert memory adress to long value
	CALL	NORMALIZE
	STO32	tvmem_offs
endif
	LDX32	[BP.tv_SSOFFSET]
if USE_MEMREAD
	AND	STDI.ios_flag,IO_MEMREAD
	JZ	TVIEW_09
	CALL	NORMALIZE		; offset == pointer
endif
TVIEW_09:
	STO32	[BP.tv_offset]
	STO32	STDI.ios_bb
	XOR	AX,AX			; init resource
	MOV	ES,AX
	MOV	AL,ES:[0484h]
	DEC	AL
	MOV	[BP.tv_rowcnt],AX	; adapt to current screen size
	ADD	AL,2
	MOV	TVrs_rcrow,AL
	MOV	DX,160
	MUL	DL
	ADD	AX,16
	MOV	TVresource,AX
	MOV	AX,[BP.tv_rowcnt]
	MOV	DX,80
	MUL	DL
	OR	AX,0F000h
	XCHG	AL,AH
	MOV	TVrs_atcnt,AX
	ADD	AH,2
	MOV	TVrs_chcnt,AX
	MOV	STDI.ios_bsize,8000h	; init stream
	XOR	AX,AX
if USE_MEMREAD
	TEST	STDI.ios_flag,IO_MEMREAD
	JNZ	TVIEW_00
endif
	PUSH32	[BP.tv_SSFILENAME]	; open file
	PUSH	AX
	PUSH	AX
	PUSH	A_OPEN
	CALL	osopen
	CMP	AX,-1
	JNE	TVIEW_0A
	DEC	AX
	JMP	TVIEW_03
TVIEW_0A:
	MOV	STDI.ios_file,AX
TVIEW_00:
	PUSH	8F1Ch
	CALL	malloc
	MOV	WORD PTR STDI.ios_bp,AX
	MOV	WORD PTR STDI.ios_bp+2,DX
	MOV	BX,AX
	ADD	AX,800Ch
	ADC	DX,0
	MOV	WORD PTR [BP.tv_screen],AX
	MOV	WORD PTR [BP.tv_screen+2],DX
	OR	BX,BX
	JZ	TVIEW_01
	PUSH	DS
	PUSH	OFFSET TVresource
	CALL	rsopen
	JNZ	TVIEW_04
	PUSH32	STDI.ios_bp
	CALL	free
TVIEW_01:
if USE_MEMREAD
	TEST	STDI.ios_flag,IO_MEMREAD
	JNZ	TVIEW_02
endif
	PUSH	STDI.ios_file
	CALL	close
TVIEW_02:
	MOV	AX,1
TVIEW_03:
	POP	DI
	POP	SI
	ADD	SP,tv_SSSIZE
	POP	BP
	RET	16
TVIEW_04:
	MOV	WORD PTR [BP.tv_dialog],AX
	MOV	WORD PTR [BP.tv_dialog+2],DX
	PUSH	DX
	PUSH	AX
	CALL	twshow
if USE_MOUSE
	CALL	mouseoff
endif
	MOV	AX,WORD PTR [BP.tv_SSFILENAME]
	MOV	DX,WORD PTR [BP.tv_SSFILENAME+2]
	MOV	BX,12
	MOV	CX,30
	OR	AX,AX
	JNZ	TVIEW_05
	MOV	DX,DS
	MOV	AX,OFFSET cp_memory
TVIEW_05:
	CALL	@scpath
	ADD	AX,14
	MOV	SI,AX
if USE_MEMREAD
	MOV	AX,WORD PTR tvmem_size
	MOV	DX,WORD PTR tvmem_size+2
	TEST	STDI.ios_flag,IO_MEMREAD
	JNZ	TVIEW_06
endif
	MOV	AX,4202h
	MOV	BX,STDI.ios_file
	XOR	CX,CX
	XOR	DX,DX
	INT	21h
	JC	TVIEW_07
TVIEW_06:
	MOV	WORD PTR [BP.tv_fsize],AX
	MOV	WORD PTR [BP.tv_fsize+2],DX
TVIEW_07:
	PUSH	0
	PUSH	0
	PUSH	DX
	PUSH	AX
	CALL	qwtobstr
	MOV	BX,SI
	XOR	CX,CX
	CALL	@scputs
	ADD	BL,AL
	MOV	AX,OFFSET cp_byte
	CALL	@scputs
	PUSH	SS
	LEA	AX,[BP.tv_cursor]
	PUSH	AX
	CALL	getcursor
	CALL	cursoroff
	LPUSH	WORD PTR tupdate+2
	PUSH	WORD PTR tupdate
	LMOV	WORD PTR tupdate+2,CS
	MOV	WORD PTR tupdate,OFFSET TVUPDATE
if USE_MOUSE
	CALL	mouseon
endif
	CALL	TVUPDATEDLG
if USE_MOUSE
	CALL	msloop
endif
	CALL	TVREADTLTAB
	CALL	TVREREAD
	CALL	TVIEW_MODAL
	POP	AX
	LPOP	DX
	MOV	WORD PTR tupdate,AX
	LMOV	WORD PTR tupdate+2,DX
	PUSH	WORD PTR STDI.ios_bp+2
	PUSH	WORD PTR STDI.ios_bp
	CALL	free
	PUSH	WORD PTR [BP.tv_dialog+2]
	PUSH	WORD PTR [BP.tv_dialog]
	CALL	twclose
if USE_MEMREAD
	TEST	STDI.ios_flag,IO_MEMREAD
	JNZ	TVIEW_08
endif
	PUSH	STDI.ios_file
	CALL	close
TVIEW_08:
	XOR	AX,AX
	MOV	STDI.ios_flag,AX
	PUSH	WORD PTR [BP.tv_cursor+2]
	PUSH	WORD PTR [BP.tv_cursor]
	CALL	setcursor
	XOR	AX,AX
	JMP	TVIEW_03
Textview ENDP

_TEXT	ENDS

PPROC	tview,	fn:DWORD, off:DWORD
	PUSH	WORD PTR fn+2
	PUSH	WORD PTR fn
	PUSH	WORD PTR off+2
	PUSH	WORD PTR off
	PUSH	0
	PUSH	0
	PUSH	000Fh
	PUSH	0FFFFh
	CALL	Textview
	RET
PEND	tview

	END

