include	clib.inc
include	clip.inc
include	malloc.inc
include	string.inc
include	console.inc

_TEXT	SEGMENT

ClearClipboard PROC
	XOR	AX,AX
	MOV	WORD PTR Clipbsize,AX
	MOV	WORD PTR Clipbsize+2,AX
	MOV	AX,WORD PTR Clipboard
	MOV	DX,WORD PTR Clipboard+2
	OR	AX,AX
	JNZ	ClrClp_00
	OR	DX,DX
	JZ	ClrClp_01
ClrClp_00:
	PUSH	DX
	PUSH	AX
	XOR	AX,AX
	MOV	WORD PTR Clipboard,AX
	MOV	WORD PTR Clipboard+2,AX
	CALL	free
ClrClp_01:
	RET
ClearClipboard ENDP

INT_2F	PROC
	XOR	AX,AX
	CMP	WINOLDAP,AX
	JE	INT2F_00
	MOV	AX,DX
	INT	2Fh
INT2F_00:
	RET
INT_2F	ENDP

_TEXT	ENDS

PPROC	ClipboardFree
	CALL	ClearClipboard
	RET
PEND	ClipboardFree

PPROC	ClipboardInit
	XOR	AX,AX
	MOV	WINOLDAP,AX
	TEST	console,CON_CLIPB
	JZ	ClInit_00
	MOV	AX,1700h
	INT	2Fh
	MOV	DX,AX
	XOR	AX,AX		; AX <> 1700h
	CMP	DX,1700h        ; - AL = WINOLDAP major version
	JZ	ClInit_00	; - AH = WINOLDAP minor version
	MOV	WINOLDAP,DX
ClInit_00:
	INC	AX
	RET
PEND	ClipboardInit

PPROC	ClipboardOpen
	MOV	DX,1701h
	CALL	INT_2F
	XOR	AX,AX
	INC	AX
	RET
PEND	ClipboardOpen

PPROC	ClipboardClose
	MOV	DX,1708h
	CALL	INT_2F
	RET
PEND	ClipboardClose

PPROC	ClipboardEmpty
	MOV	DX,1702h
	CALL	INT_2F
	CALL	ClearClipboard
	RET
PEND	ClipboardEmpty

PPROC	ClipboardCopy, string:DPTR, len:WORD
	CALL	ClearClipboard
	XOR	AX,AX
	CMP	WINOLDAP,AX
	JE	ClCopy_00
	MOV	DX,1		; set type to text
	MOV	CX,len		; SI:CX = size of data
	PUSH	SI
	MOV	SI,AX		; HSIZE = 0
	MLES	BX,string	; ES:BX = data
	MOV	AX,1703h
	INT	2Fh
	POP	SI
	OR	AX,AX
	JNZ	ClCopy_01
ClCopy_00:
	MOV	AX,len
	INC	AX
	PUSH	AX
	CALL	malloc
	JZ	ClCopy_01
	MOV	WORD PTR Clipboard,AX
	MOV	WORD PTR Clipboard+2,DX
	MOV	ES,DX
	MOV	BX,AX
	MOV	CX,len
	MOV	Clipbsize,CX
	ADD	BX,CX
	MOV	BYTE PTR ES:[BX],0
	PUSH	DX
	PUSH	AX
	PUSH32	string
	PUSH	CX
	CALL	memcpy
ClCopy_01:
	RET
PEND	ClipboardCopy

PPROC	ClipboardPaste
	XOR	DX,DX
	CMP	WINOLDAP,DX
	JE	ClPaste_01
	INC	DX
	MOV	AX,1704h
	INT	2Fh
	OR	DX,DX
	JNZ	ClPaste_01
	OR	AX,AX
	JZ	ClPaste_01
	CMP	AX,MAXCLIPSIZE
	jae	ClPaste_01
	PUSH	AX
	PUSH	AX
	CALL	ClearClipboard
	CALL	malloc
	POP	CX
	JZ	ClPaste_02
	MOV	Clipbsize,CX
	MOV	WORD PTR Clipboard,AX
	MOV	WORD PTR Clipboard+2,DX
	PUSH	DX
	PUSH	AX
	PUSH	CX
	CALL	memzero
	MOV	DX,1
	LES	BX,Clipboard
	MOV	AX,1705h
	INT	2Fh
ClPaste_00:
	MOV	CX,WORD PTR Clipboard
	MOV	DX,WORD PTR Clipboard+2
	JMP	ClPaste_02
ClPaste_01:
	XOR	CX,CX
	MOV	DX,AX
	CMP	AX,Clipbsize
	JNE	ClPaste_00
ClPaste_02:
	MOV	AX,CX
	OR	AX,AX
	RET
PEND	ClipboardPaste

PPROC	ClipboardSize
	XOR	DX,DX
	CMP	WINOLDAP,DX
	JE	ClSize_00
	INC	DX
	MOV	AX,1704h
	INT	2Fh
	OR	DX,DX
	JZ	ClSize_01
ClSize_00:
	MOV	AX,Clipbsize
ClSize_01:
	XOR	DX,DX
	RET
PEND	ClipboardSize

_DATA	SEGMENT

WINOLDAP  DW	0
Clipbsize DW	0
Clipboard DD	0

_DATA	ENDS

	END
