USE_MULTILINE	= 0

_D_DOPEN	EQU	0001h
_D_ONSCR	EQU	0002h
_D_DMOVE	EQU	0004h
_D_SHADE	EQU	0008h
_D_MYBUF	EQU	0010h	; do not delete on exit (static)
_D_RCNEW	EQU	0020h	; twclose -- delete dialog if set
_D_RESAT	EQU	0040h	; attrib is index in color table (rcedit)
_D_DHELP	EQU	0080h	; execute thelp() if set

_D_CLEAR	EQU	0100h   ; args on open/create
_D_BACKG	EQU	0200h
_D_FOREG	EQU	0400h
_D_COLOR	EQU	_D_BACKG or _D_FOREG
_D_STERR	EQU	1000h	; error color (red)
_D_MENUS	EQU	2000h	; menus color (gray), no title
_D_MUSER	EQU	4000h

_D_RESRC	EQU	0030h
_D_SETRC	EQU	0031h

_D_STDDLG	EQU	(_D_DMOVE or _D_SHADE or _D_CLEAR or _D_COLOR)
_D_STDERR	EQU	(_D_STDDLG or _D_STERR)

_O_PBUTT	EQU	0
_O_RBUTT	EQU	1
_O_CHBOX	EQU	2
_O_XCELL	EQU	3
_O_TEDIT	EQU	4
_O_MENUS	EQU	5
_O_XHTML	EQU	6
_O_MOUSE	EQU	7
_O_LLMSU	EQU	8
_O_LLMSD	EQU	9
_O_TBUTT	EQU	10

_O_RADIO	EQU	0010h
_O_FLAGB	EQU	0020h
_O_LLIST	EQU	0040h
_O_DTEXT	EQU	0080h
_O_DEXIT	EQU	0200h
_O_CURID	EQU	0800h
_O_GLCMD	EQU	1000h
_O_EVENT	EQU	2000h
_O_CHILD	EQU	4000h
_O_STATE	EQU	8000h
_O_DEACT	EQU	_O_STATE

_C_NORMAL	EQU	1
_C_RETURN	EQU	2
_C_ESCAPE	EQU	3
_C_REOPEN	EQU	4

CURSOR_NORMAL	EQU	0607h
CURSOR_HIDDEN	EQU	0F00h

S_FOBJ	STRUC
	fo_flag		DW ?
	fo_count	DB ?
	fo_index	DB ?
	fo_rect		DD ?
S_FOBJ	ENDS

TO_OFLAG	EQU	00h
TO_OCOUNT	EQU	02h
TO_OASCII	EQU	03h
TO_ORECT	EQU	04h
TO_ODATA	EQU	08h
TO_SDATA	EQU	0Ah
TO_OPROC	EQU	0Ch
TO_SPROC	EQU	0Eh

S_TOBJ	STRUC
	to_flag		DW ?
	to_count	DB ?
	to_ascii	DB ?
	to_rect		DD ?
	to_data		DD ?
	to_proc		PF ?
 ifndef LPROG
	to_align16	DW ?
 endif
S_TOBJ	ENDS

S_DOBJ	STRUC
	dl_flag		DW ?
	dl_count	DB ?
	dl_index	DB ?
	dl_rect		DD ?
	dl_wp		DD ?
	dl_object	DD ?
S_DOBJ	ENDS

S_ROBJ	STRUC
	rs_memsize	DW ?
	rs_flag		DW ?
	rs_count	DB ?
	rs_index	DB ?
	rs_rect		DD ?
S_ROBJ	ENDS

S_GLCMD	STRUC
	gl_key		DW ?
	gl_proc		PF ?
S_GLCMD	ENDS

GCMD	MACRO	key, name	; GlobalCommand: <ShortKey>, <cmdProc>
	DW	key
 ifdef LPROG
	DD	name
 else
	DW	name
 endif
	ENDM

S_TINFO	STRUC
	ti_base		DD ?	; base pointer
	ti_xpos		DW ?	; text window x,y
	ti_ypos		DW ?
	ti_cols		DW ?	; size of screen-line
	ti_bcol		DW ?	; size of buffer-line
	ti_xoff		DW ?	; offset on screen
	ti_boff		DW ?	; offset in buffer (start of screen-line)
	ti_bcnt		DW ?	; byte count in line
 if USE_MULTILINE
	ti_rows		DW ?	; number of lines on screen
	ti_brow		DW ?	; number of lines in buffer
	ti_yoff		DW ?	; line offset
 endif
 if USE_CLIPBOARD
	ti_clst		DD ?	; Clipboard start
	ti_clen		DD ?	; Clipboard end
 endif
	ti_clat		DW ?	; Normal string attrib
S_TINFO	ENDS

S_LOBJ	STRUC
	ll_dlgoff	DW ?	; start index in dialog
	ll_dcount	DW ?	; number of cells (max)
	ll_celoff	DW ?	; cell offset
	ll_numcel	DW ?	; number of visible cells
	ll_count	DW ?	; total number of items in list
	ll_index	DW ?	; index in list buffer
	ll_list		PD ?	; pointer to list buffer
	ll_proc		PF ?
S_LOBJ	ENDS
