; TVIEW.ASM--
; Copyright (c) 1998 Hjort Nidudsson
;
; Change history:
; 15 Nov 2008	- added function Seek
; 13 Nov 2008	- Moved Binary View to F4
;		- added switch /M --> read memory [00000..FFFFF]
; 10 Sep 2008	- Divide error in putinfo(percent)
; 		- command END  in dump text (F2) moves to top of file
; 		- command UP   in dump text (F2) moves to top of file
; 		- command PGUP in dump text (F2) moves to top of file
; 		- command END  in hex view  (F4) offset not aligned
; 		- command END  in HEX and BIN -- last offset + 1 < offset
; 		- added short key Ctrl+End -- End of line (End right)
; 		- added IO Bit Stream
; 20 Apr 2007	- added switch /O<offset>
; 12 Mar 2007	- added Binary View
; 10 Jan 1998	- Created

include		clib.inc
include		clip.inc
include		errno.inc
include		iost.inc
include		io.inc
include		dos.inc
include		alloc.inc
include		string.inc
include		stdio.inc
include		stdlib.inc
include		dialog.inc
include		kbd.inc
include		arch.inc

MEMVIEW		= 1

MAXROW		= 48		; 50 lines EGA mode
MEMPAGE		= 8000h		; read buffer size
HEXPAGE		= (MAXROW * 16) ; 16 bytes in each line
TXTPAGE		= (MAXROW * 80) ; 80 bytes in each line
ALLOCSIZE	= (MEMPAGE + 12 + (MAXROW * 80) + 16)

TV_HEXVIEW	= 8000h
TV_BINVIEW	= 4000h
TV_WRAPLINES	= 2000h
TV_HIGHCOLOR	= 1000h
TV_HEXOFFSET	= 0800h
TV_CLIPBOARD	= 0400h
TV_SEARCHMASK	= 001Fh
TV_SEARCHCUR	= 0010h	; Search from cursor/set
TV_SEARCHSET	= 0008h	; Search entire scope
TV_SEARCHHEX	= 0004h	; Search hex string/ascii
TV_SEARCHCASE	= 0002h	; Case sensitive search

GLOBAL 	PASCAL	IDD_TVHelp:	DWORD
GLOBAL 	PASCAL	IDD_TVCopy:	DWORD
GLOBAL 	PASCAL	IDD_Seek:	DWORD
GLOBAL 	PASCAL	tview:		DIST
GLOBAL 	PASCAL	config:		WORD

IFDEF	TVEXE
GLOBAL 	PASCAL	main: 		DIST
GLOBAL 	PASCAL	readword: 	DIST
	EXTRN	__setargv__: 	ABS
	cflag	= [config]	; --> TVIEW.CFG
ELSE
	cflag	= [config+6]	; --> DZ.CFG
ENDIF

CR 		= 	13	; '\r' 0D
LF 		= 	10	; '\n' 0A
LINEFEED	EQU	CR,LF

_DATA		SEGMENT

IFDEF TVEXE
copyright	DB	'TVIEW Version 1.04 Copyright 1998-2009 Hjort Nidudsson'
		DB	LINEFEED
sizecopyright	=	$ - copyright
cp_usage	DB 	LINEFEED
		DB 	'Usage: TVIEW <filename> [/O<offset>] [/M]'
		DB 	LINEFEED
sizeusage	= 	$ - cp_usage
FileNotFound	DB	'File not found: '
size_FileNotFound =	$ - FileNotFound
config		DW	TV_WRAPLINES
cp_ext		DB	'CFG',0
		PUBLIC	_bufin
_bufin		DB	?
		DB	512 dup(?)
ENDIF

; General hot keys

key_global	DW	KEY_F1		; cm_help
		DW	KEY_F2		; cm_wrap
		DW	KEY_F3		; cm_search
		DW	KEY_F4		; cm_hex
		DW	KEY_F5          ; cm_copy
		DW	KEY_F6		; cm_offs
		DW	KEY_F7		; cm_seek
		DW	KEY_F8		; cm_binary
		DW	KEY_F10		; cm_quit
		DW	KEY_ESC         ; cm_quit
		DW	ALTX	 	; cm_quit
		DW	CTRLF5          ; cm_color

key_glcount	=	(($ - key_global) / 2)

key_local	DW	KEY_UP          ; event_up
		DW	KEY_DOWN        ; event_down
		DW	KEY_PGUP        ; event_pgup
		DW	KEY_PGDN        ; event_pgdn
		DW	KEY_LEFT        ; event_left
		DW	KEY_RIGHT       ; event_right
		DW	KEY_HOME        ; event_home
		DW	KEY_END         ; event_end

		DW	CTRLL		; continue_search
		DW	CTRLE       	; event_up
		DW	CTRLX       	; event_down
		DW	CTRLR		; event_pgup
		DW	CTRLC		; event_pgdn
		DW	CTRLUP		; event_pgup
		DW	CTRLDN     	; event_pgdn
		DW	CTRLLEFT	; event_pgleft
		DW	CTRLRIGHT	; event_pgright

		DW	SHIFTF3		; continue_search
		DW	CTRLEND		; event_endright
		DW	CTRLHOME	; event_startofline

key_count	=	(($ - key_global) / 2)


key_proc	DW	cm_help
		DW	cm_wrap
		DW	cm_search
		DW	cm_hex
		DW	cm_copy
		DW	cm_offs
		DW	cm_seek
		DW	cm_binary
		DW	cm_quit
		DW	cm_quit
		DW	cm_quit
		DW	cm_color

		DW	event_up
		DW	event_down
		DW	event_pgup
		DW	event_pgdn
		DW	event_left
		DW	event_right
		DW	event_home
		DW	event_end

		DW	event_search
		DW	event_up
		DW	event_down
		DW	event_pgup
		DW	event_pgdn
		DW	event_pgup
		DW	event_pgdn
		DW	event_pgleft
		DW	event_pgright

		DW	event_search
		DW	event_endright
		DW	event_startofline

cp_dec		DB	'Dec'
cp_hex		DB	'Hex  '
cp_ascii	DB	'Ascii'
cp_wrap		DB	'Wrap  '
cp_unwrap	DB	'Unwrap'
cp_memory	DB	'MEMORY',0
cp_byte		DB	'byte',0
form_8ld	DB	'%-8ld',0
form_3d		DB	'%3d',0
form_10u	DB	'%010lu',0
form_08lXh	DB	'%08lXh',0
form_lu		DB	'%lu',0

; The resource must fit the screen size (25/50)

resource	DW	4016	; alloc size
		DW	4410h	; Dialog:	flag
		DW	0	; 		index
		DW	0	; 		x,y
		DB	80	; 		col
rs_rcrow	DB	25	; [0000:0484]	row

; The rest is compressed data - screen-bytes are first split: [COLOR][CHAR]
; then compressed using an RLE-like 3-byte count:
;  --> 	FxxxCH	-- if high nibble of byte is F: code
;       xxx	-- count of bytes 001..FFF
;	CH	-- the byte compressed

		; this represent the color of the first line: F|050|70
		DB	0F0h	; code 'F'
		DB	050h    ; byte count (80)
		DB	070h    ; attrib of first (menu) line
		; this represent the color of text window: F|730|17
rs_atcnt	DW	30F7h	; 730h (1840/80=23)
		DB	017h    ; attrib text window

		DB	70h,7Fh,7Fh	; F1 Help
		DB	240,7,70h
		DB	7Fh,7Fh		; F2 Unwrap
		DB	240,9,70h
		DB	7Fh,7Fh		; F3 Search
		DB	240,9,70h
		DB	7Fh,7Fh		; F4 Ascii/Hex
		DB	240,8,70h
		DB	7Fh,7Fh		; F5 Copy
		DB	240,7,70h
		DB	7Fh,7Fh		; F6 Dec/Hex
		DB	240,6,70h
		DB	7Fh,7Fh		; F7 Seek
		DB	240,10,70h
		DB	240,3,7Fh	; Esc Quit
		DB	240,6,70h

		; this represent the text of the first line
		DB	' Text View:',240,50,' col',240,11,' 100%'
		; this represent the text of window: F|732|' '
rs_chcnt	DW	32F7h	; 732h (1840+2)
		DB	' F1 Help  F2',240,9,' F3 Search  F4'
		DB	240,8,' F5 Copy  F6 Dec  F7 Seek',240,5,' Esc Quit '
_DATA		ENDS

;---------------------------------------------------------------------------

TVIEW_TEXT	SEGMENT USE16 BYTE PUBLIC 'CODE'
		ASSUME CS:TVIEW_TEXT, DS:DGROUP

; memtoffs() -- convert memory adress (DX:AX) to offset (EAX)

memtoffs:	movzx	edx,dx
		shl	edx,4   ; 000SSSS0 <-- 0000SSSS
		movzx	eax,ax
		add	eax,edx ; 0000OOOO  +  000SSSS0
		ret

getc:		call	ogetc
		jz	SHORT getc_end
		inc	offs
getc_cmp:	cmp	al,CR
		jz	SHORT getc_found
		cmp	al,LF
		jz	SHORT getc_found
getc_end:	clc             	; clear Carry flag
		ret			; ZERO flag set if EOF
getc_found:	inc	ah	    	; clear ZERO flag
		stc			; set Carry flag
		ret	; return ZF set: EOF, CF set: CR|LF

ungetc:		call	oungetc		; reverse direction
		jz	SHORT getc_end
		dec	offs
		jmp	SHORT getc_cmp

;---------------------------------------------------------------------------

; Read a static line table of offset < 256 from start of file

Readstatic:	mov	tcount,1        ; one line so far..
		xor	eax,eax
		mov	tltab,eax	; = offset of first line
		mov	offs,eax
		call	seekeax		; seek to start of file
		jz	SHORT @@toend
@@loop:		call	getc
		jc	SHORT @@add
		jnz	SHORT @@loop
@@eof:		call	@@addoffset
		call	@@addoffset
		dec	tcount
@@dec:		dec	tcount
@@toend:	ret
@@add:		call	getc		; see if next byte CR/LF
		jz	SHORT @@eof
		jc	SHORT @@inc
		call	ungetc		; if not --> ungetc
@@inc:		call	@@addoffset
		mov	ax,tcount
		cmp	ax,253
		ja	SHORT @@dec
		jmp	SHORT @@loop
@@addoffset:	lea	bx,tltab
		mov	ax,tcount
		shl	ax,2
		add	bx,ax
		mov	eax,offs
		mov	ss:[bx],eax
		inc	tcount
		ret

TL_lastoffset:	push	bx		; last offset in table == sizeof()
		lea	bx,tltab
		mov	ax,tcount
		shl	ax,2
		add	bx,ax
		mov	eax,ss:[bx]
		pop	bx
		ret

;---------------------------------------------------------------------------

; Read a dynamic line table of offset <= rowcnt

Initlinetable:  push	si
		mov	lcount,1        ; one line so far..
		mov	eax,[si.ios_bb]	; edx = current filepos
		mov	ltab,eax	; = offset of first line
		mov	offs,eax
		test	xflag,TV_HEXVIEW
		jnz	SHORT @@ReadHexTable
		test	xflag,TV_WRAPLINES
		jnz	SHORT @@toend
		lea	bx,tltab        ; copy offset from static table
		mov	cx,tcount       ; if in range..
@@nextline:	cmp	eax,ss:[bx]
		je	SHORT @@found
		add	bx,4
		dec	cx
		jnz	SHORT @@nextline
		xor	bx,bx
@@found:	or	bx,bx
		jz	SHORT @@doslow  ; else read a new one
@@cpy:		add	bx,4		; overlap table with one
		mov	eax,ss:[bx]
		mov	offs,eax
		call	LT_addoffset
		mov	ax,lcount
		cmp	ax,rowcnt
		ja	SHORT @@dec
		dec	cx
		jnz	SHORT @@cpy
		mov	eax,offs	; arg to seek
		cmp	eax,fsize	; eof ?
		je	SHORT @@dec
		;dec	lcount		; reduce line count

@@doslow:       call	seekeax		; seek to EAX
		jz	SHORT @@toend   ; read from this offset

		;xor	si,si
		mov	si,MEMPAGE
@@loop:		;call	getc
		;jc	SHORT @@add
		;jnz	SHORT @@loop

		call	ogetc
		jz	SHORT @@eof
		inc	offs
		cmp	al,CR
		je	SHORT @@add
		cmp	al,LF
		je	SHORT @@add
		dec	si
		jz	SHORT @@add
		jmp	SHORT @@loop

@@eof:		call	LT_addoffset
		call	LT_addoffset
		dec	lcount
@@dec:		dec	lcount
@@toend:        pop	si
		jnz	SHORT @@clear_screen
		ret

@@ReadHexTable: call	seekeax		; seek to this file offset
		jz	SHORT @@toend
		xor	dx,dx
@@xlp:          mov	eax,offs
		add	eax,8
		test	xflag,TV_BINVIEW
		jnz	SHORT @@bin
		add	eax,8
@@bin:          mov	offs,eax
		cmp	eax,fsize
		ja	SHORT @@neg
		call	LT_addoffset
		inc	dx
		cmp	dx,rowcnt
		jb	SHORT @@xlp
		jmp	SHORT @@eof
@@neg:		mov	eax,fsize
		mov	offs,eax
		jmp	SHORT @@eof

@@add:		call	getc		; see if next byte CR/LF
		jz	SHORT @@eof
		jc	SHORT @@inc
		call	ungetc
@@inc:		call	LT_addoffset
		mov	ax,lcount
		cmp	ax,rowcnt
		ja	SHORT @@dec
		jmp	SHORT @@loop

@@clear_screen:	push	di
		mov	eax,20202020h	; clear screen table(' ')
		mov	cx,(TXTPAGE/4)
		les	di,screen
		cld
	rep	stosd
		pop	di
		mov	eax,[si.ios_bb]
		mov	offs,eax

seekeax:	push	eax		; seek to offset EAX
		push	SEEK_SET
		call	oseekl
		ret

;---------------------------------------------------------------------------

LT_addoffset:	push	bx
		lea	bx,ltab
		mov	ax,lcount
		shl	ax,2
		add	bx,ax
		mov	eax,offs
		mov	ss:[bx],eax
		inc	lcount
		pop	bx
		ret

;---------------------------------------------------------------------------

getlinesize:	push	bx
		shl	ax,2		; ax = lineid
		lea	bx,ltab
		add	bx,ax
		mov	edx,ss:[bx]     ; edx = line offset
		mov	eax,ss:[bx+4]   ; eax = linesize
		sub	eax,edx
		pop	bx
		ret

;---------------------------------------------------------------------------

setmaxcol:	xor	cx,cx
@@loop:		cmp	cx,lcount
		jae	SHORT @@toend
		mov	ax,cx
		call	getlinesize
		cmp	eax,maxcol
		jbe	SHORT @@next
		mov	maxcol,eax
@@next:		inc	cx
		jmp	SHORT @@loop
@@toend:	ret

;---------------------------------------------------------------------------

readhex:        call	Initlinetable
		jnz	SHORT @@do
@@return:	ret
@@do:           call	ogetc		; init buffer
		jz	SHORT @@return
		dec	[si.ios_i]	; ungetc
		mov	ax,8		; adjust read size to 8 byte
		test	xflag,TV_BINVIEW
		jnz	SHORT @@binary
		add	ax,ax		; adjust read size to 16 byte
@@binary:	mul	rowcnt		; * number of lines
		cmp	ax,[si.ios_c]
		ja	SHORT @@scount
		mov	[si.ios_c],ax
@@scount:	movzx	eax,[si.ios_c]
		mov	scount,eax	; bytes on screen
		push	di
		les	di,screen	; ES:DI to buffer
		xor	cx,cx		; CX to line loop
@@lineloop:	push	di		; save offset
		lea	bx,ltab		; ltab[cx]
		mov	ax,cx
		shl	ax,2
		add	ax,3
		add	bx,ax
		mov	dx,4
		test	xflag,(TV_HEXOFFSET or TV_BINVIEW)
		jnz	SHORT @@hex_foff
@@des_foff:	push	es      ; print "%010lu" desimal offset
		push	bx
		push	cx
		mov	eax,ss:[bx-3]
		push	eax
		push	ds
		push	OFFSET form_10u
		push	es
		push	di
		call	sprintf
		add	sp,12
		pop     cx
		pop     bx
		pop     es
		add	di,9
		jmp	SHORT @@SIZE
@@hex_foff:	mov	al,ss:[bx]	; print "%08lX" hex offset
		call	mkhexw
		mov	es:[di],ax
		add	di,2
		dec	bx
		dec	dx
		jnz	SHORT @@hex_foff
		inc	di		; to first byte in out buffer
@@SIZE:		mov	dx,[si.ios_c]	; byte count in buffer
		mov	ax,8
		test	xflag,TV_BINVIEW
		jnz	SHORT @@testsize
		add	ax,ax
		add	di,3
@@testsize:	cmp	dx,ax
		jb      SHORT @@testzero
		mov	dx,ax
@@testzero:	or	dx,dx
		jz	SHORT @@popdi
		sub	[si.ios_c],dx
		mov	bx,di
		add	bx,51		; put ascii to the right if hex
		push	cx		; save line loop
		mov	cx,dx           ; set cx to byte count
		xor	dx,dx           ; dx to zero
@@byteloop:	test	xflag,TV_BINVIEW
		jnz	SHORT @@getc
@@bloop:	cmp	dx,8
		jne	SHORT @@getc
		mov	al,179		; insert a  vertical line
		mov	es:[di],al
		add	di,2            ; and a space
@@getc:         mov	ax,[si.ios_i]
		push	es
		push	bx
		les	bx,[si.ios_bp]
		add	bx,ax
		mov	al,es:[bx]
		pop	bx
		pop	es
		inc	[si.ios_i]
		test	xflag,TV_BINVIEW
		jnz	SHORT @@putbin
		mov	es:[bx],al
		call	mkhexw
		mov	es:[di],ax
		add	di,3
		inc	bx
		inc	dx
		dec	cx
		jnz	SHORT @@bloop
		jmp	SHORT @@nextl
@@putbin:	mov	ah,al
		push	cx
		mov	cx,8
@@bitloop:      mov	al,ah
		shl	ah,1
		and	al,80h
		mov	al,'1'
		jnz	SHORT @@notzero
		mov	al,'0'
@@notzero:      mov	es:[di],al
		inc	di
		dec	cx
		jnz	SHORT @@bitloop
		pop	cx
		inc	di
		inc	dx
		dec	cx
		jnz	SHORT @@byteloop
@@nextl:	pop	cx
		pop	di
		add	di,80
		inc	cx
		cmp	cx,lcount
		jnb	SHORT @@toend
		jmp	@@lineloop
@@popdi:	pop	di
@@toend:	or	ax,1
		pop	di
		ret

mkhexw:		mov	ah,al		; hex to ascii
		and	ax,0FF0h
		shr	al,4
		add	ax,'00'
		cmp	ah,'9'
		jbe	SHORT @@db1
		add	ah,7
@@db1:		cmp	al,'9'
		jbe	SHORT @@db2
		add	al,7
@@db2:		ret

;---------------------------------------------------------------------------

; Moves byte from file to ES:DI -- max 80 + CR + LF
; Return DI: offset next line (+80)

getc_ESDX:	push	es
		push	dx
		call	getc		; get byte from read buffer
		pop	dx
		pop	es
		ret

parseline:      push	di      	; di += 80 on return
		xor	dx,dx
@@do:		call	getc_ESDX
		jz	SHORT @@toend
		jc	SHORT @@crlf
		cmp	al,9
		je	SHORT @@tab
		mov	es:[di],al
		inc	di
		inc	dx
@@inc:		cmp	dx,80
		je	SHORT @@eol	; end of line --> + CR + LF
		jb	SHORT @@do
@@toend:        pop	di
		jz	SHORT @@eof
		add	di,80		; next screen line
@@eof:		ret
@@crlf:		call	getc_ESDX	; see if next byte is CR/LF
		jz	SHORT @@toend	; --> EOF
		jc	SHORT @@toend	; --> CR/LF
@@unget:	dec	offs            ; --> start of next line
		dec	[si.ios_i]
		jmp	SHORT @@toend
@@tab:		sub	dx,di
		add	di,8
		and	di,0FFF8h
		add	dx,di
		jmp	SHORT @@inc
@@eol:		call	getc_ESDX	; one or two bytes (80+CR+LF)
		jz	SHORT @@toend 	; EOF ?
		jc	SHORT @@crlf	; if CR/LF --> try one more
		jmp	SHORT @@unget   ; line is 80 byte

;---------------------------------------------------------------------------

; Read ASCII (dump)

readasc:	call	Initlinetable
		jz	SHORT @@error
		push	di
		les	di,screen	; ES:DI to screen buffer
		xor	ax,ax
		mov	ocx,ax
		mov	lcount,ax
@@loop:         mov	ax,ocx
		inc	ocx
		cmp	ax,rowcnt
		jae	SHORT @@toend
		call	LT_addoffset
		call	parseline
		jnz	SHORT @@loop
@@toend:        mov	eax,offs
		sub	eax,[si.ios_bb]
		mov	scount,eax
		or	ax,1
		pop	di
		ret
@@error:	xor	ax,ax
		ret

;---------------------------------------------------------------------------

readtxt:        call	Initlinetable
		jz	SHORT @@error
		call	setmaxcol
		push	di
		les	di,screen
		mov	ocx,0
@@loop:         mov	ax,ocx
		inc	ocx
		cmp	ax,lcount
		jae	SHORT @@toend
		call	getlinesize
		add	scount,eax
		cmp	eax,curcol
		ja	SHORT @@add
		add	di,80
		jmp	SHORT @@loop
@@add:		add	edx,curcol
		mov	eax,edx
		call	seekeax
		jz	SHORT @@error
		call	parseline
		jnz	SHORT @@loop
@@toend:	or	ax,1
@@pop:		pop	di
		ret
@@error:	xor	ax,ax
		jmp	SHORT @@pop

;---------------------------------------------------------------------------

; Return previous offset, CF clear if successful

offset_error:	mov	eax,fsize	; DBUG (offset > fsize)
		mov	[si.ios_bb],eax	; reset fpos to filesize
		ret
offset_hex:	mov	edx,8		; fixed size: 8 byte
		test	xflag,TV_BINVIEW
		jnz	SHORT @@binary
		mov	dx,16		; fixed size: 16 byte
@@binary:	cmp	eax,edx
		jbe	SHORT offset_top
		sub	eax,edx
		ret
offset_top:	xor	eax,eax
		ret

offset_prev:	mov	eax,[si.ios_bb]
		mov	offs,eax
		or	eax,eax
		jz	SHORT offset_top
		cmp	eax,fsize
		ja	SHORT offset_error
		test	xflag,TV_HEXVIEW
		jnz	SHORT offset_hex
		call	TL_lastoffset   ; get last offset in table
		cmp	eax,offs	; current offset in table ?
		jb	SHORT @@doslow  ; if not, do a slow file-scan
		mov	eax,offs	; get position of this offset
		mov	cx,tcount	; loop from last line in table
		dec	cx		; index of last offset in table
@@prev:		lea	bx,tltab
		mov	dx,cx
		shl	dx,2
		add	bx,dx
		cmp	eax,ss:[bx]     ; if current > table[bx]
		ja	SHORT @@found   ; then *this = previous offset
		or	cx,cx           ; compare to start of table
		jz      SHORT offset_top
		dec	cx
		jmp	SHORT @@prev
@@found:        mov	eax,ss:[bx]
		jmp	SHORT @@test

@@doslow:       mov	eax,offs
		call	seekeax         ; seek back in stream
		jz	SHORT offset_top
		call	ungetc		; init buffer
		jz	SHORT offset_top

; prev byte may be CR/LF (end of previous line)

		push	si
		;xor	si,si
		mov	si,MEMPAGE

		jnc	SHORT @@get	; not found..
		call	ungetc		; skip LF
		jz	SHORT @@top
		jc	SHORT @@get	; skip CR

@@do:           jc	SHORT @@set	; found..
@@get:		call	oungetc		; get next byte
		jz	SHORT @@top
		dec	offs
		cmp	al,CR
		jz	SHORT @@set
		cmp	al,LF
		jz	SHORT @@set
		dec	si
		jz	SHORT @@set
		jmp	SHORT @@get

@@top:          pop	si
		xor	eax,eax
		ret

@@set:          pop	si
		mov	eax,offs
		inc	eax
@@test:		test	xflag,TV_WRAPLINES
		jnz	SHORT offset_dump
		ret

; Compute the previous line offset in dump mode. Start from
; (1) the previous CR/LF (2) from top of file

offset_dump:    mov	edx,[si.ios_bb]	; get size of line
		sub	edx,eax		; EDX --> length of this line
		jl	SHORT @@nul     ; EAX --> prev text offset
		cmp	edx,MEMPAGE
		jb	SHORT @@read

; this line is to long (--> FFFFFFFFh)

		add	eax,edx		; to current offset
		sub	eax,80		; back one line

@@read:         mov	offs,eax        ; start offset < current offset
		mov	ddtmp,eax
		call	seekeax         ; seek back in stream
		jz	SHORT @@nul
		push	di
@@doline:       les	di,screen
		call	parseline	; compute bytes in each line
		jz	SHORT @@toend
		mov	eax,offs
		cmp	eax,[si.ios_bb]
		jae	SHORT @@toend
		mov	ddtmp,eax       ; start of line
		jmp	SHORT @@doline
@@nul:		xor	eax,eax
		ret
@@toend:	pop	di
		mov	eax,ddtmp
		ret

;---------------------------------------------------------------------------

initpage:       mov	scount,0
		mov	ax,xflag
		test	ax,TV_HEXVIEW
		jnz	SHORT @@hex
		test	ax,TV_WRAPLINES
		jnz	SHORT @@ascii
		call	readtxt
		jmp	SHORT @@toend
@@ascii:	call	readasc
		jmp	SHORT @@toend
@@hex:		call	readhex
@@toend:	ret

;---------------------------------------------------------------------------

putpage:	mov	eax,scount
		add	eax,[si.ios_bb]
		jz	SHORT @@100
		mov	ebx,100
		mul	ebx
		mov	ebx,fsize
		div	ebx
		and	ax,007Fh
		cmp	ax,100
		jbe	SHORT @@put
@@100:		mov	ax,100
@@put:		push    ax
		push	ds
		push	OFFSET form_3d
		push	large 0
		push	0
		push	75
		call	scputf
		add	sp,14
		push	curcol
		push	ds
		push	OFFSET form_8ld
		push	large 0
		push	0
		push	65
		call	scputf
		add	sp,16
		cmp	fsize,0
		jz	SHORT @@toend
		mov	ax,80
		mul	rowcnt
		mov	cx,ax
		call	__mshide
		mov	ax,SCRSEG
		mov	es,ax
		push	ds
		push	si
		push	di
		lds	si,screen
		mov	di,160
		cld
@@next:		movsb
		inc	di
		dec	cx
		jnz	SHORT @@next
		pop	di
		pop	si
		pop	ds
		call	__msshow
@@toend:	ret

;---------------------------------------------------------------------------

dw_update:	call	initpage
		jz	SHORT @@toend
		call	putpage
		mov	ax,1
@@toend:	ret

;---------------------------------------------------------------------------

event_home:     xor	eax,eax
		mov	curcol,eax
		mov	[si.ios_bb],eax
		jmp 	SHORT dw_update

			;----------------------------------------------------

event_end:      test	xflag,TV_HEXVIEW
		jnz	SHORT @@cmend_hex
@@cmend_txt:	mov	ax,lcount       ; text offset
		cmp	ax,rowcnt
		jb	SHORT @@toend
		mov	eax,scount
		add	eax,[si.ios_bb]
		inc	eax
		cmp	fsize,eax
		jb	SHORT @@toend
		mov	eax,fsize
		mov	[si.ios_bb],eax
		jmp	text_pgup
@@cmend_hex:	mov	ax,rowcnt	; max byte on screen
		mov	cl,3
		test	xflag,TV_BINVIEW
		jnz	SHORT @@binary
		inc	cl
@@binary:	shl	ax,cl
		movzx	eax,ax
		inc	eax
		cmp	fsize,eax
		jb	SHORT @@toend
		sub	eax,fsize
		not	eax             ; fpos = fsize - (rowcnt * 16|8);
		add	eax,18
		and	al,0F0h
		mov	[si.ios_bb],eax
		jmp 	dw_update
@@toend:	ret

			;----------------------------------------------------

event_up:	call	offset_prev
		cmp	eax,[si.ios_bb]
		jz	SHORT @@toend
		mov	[si.ios_bb],eax
		jmp	dw_update
@@toend:	ret

			;----------------------------------------------------

event_down:	test	xflag,TV_HEXVIEW
		jz	SHORT @@ascii
		mov	edx,8
		test	xflag,TV_BINVIEW
		jnz	SHORT @@binary
		add	dx,dx
@@binary:	mov	eax,scount
		add	eax,[si.ios_bb]
		inc	eax
		cmp	eax,fsize
		jae	SHORT ret_0
		add	eax,edx
		cmp	eax,fsize
		jb	SHORT @@04
		jmp	event_end
@@04:		add	[si.ios_bb],edx
		jmp	dw_update
@@ascii:	mov	ax,lcount
		cmp	ax,rowcnt
		jb	SHORT ret_0
		lea	bx,ltab
		add	bx,4
		mov	eax,ss:[bx]
ret_fpos:	mov	[si.ios_bb],eax
ret_upd:	jmp	dw_update
ret_0:		xor	ax,ax
		ret

			;----------------------------------------------------

event_pgup:	cmp	[si.ios_bb],0
		jz	SHORT @@ret
		test	xflag,TV_HEXVIEW
		jz	SHORT text_pgup
		mov	ax,rowcnt
		mov	cl,4
		test	xflag,TV_BINVIEW
		jz	SHORT @@hex
		mov	cl,3
@@hex:		shl	ax,cl
		movzx	eax,ax
		cmp	eax,[si.ios_bb]	; if (fpos > (rowcnt * 16|8))
		jae	SHORT @@nul
		sub	[si.ios_bb],eax	; fpos -= (rowcnt * 16|8);
		jmp	SHORT @@toend
@@nul:		mov	[si.ios_bb],0
@@toend:	jmp	dw_update
@@ret:		ret

text_pgup:	push	di
		mov	di,1
		test	xflag,TV_WRAPLINES
		jnz	SHORT @@dump_pgup
@@prev:		call	offset_prev
		cmp	eax,[si.ios_bb]
		jz	SHORT @@toend
		mov	[si.ios_bb],eax
		inc	di
		cmp	di,rowcnt
		jnz	SHORT @@prev
@@toend:	pop	di
		jmp	dw_update
@@dump_pgup:	mov	eax,[si.ios_bb]		; case END in dump text mode
		cmp	eax,fsize
		jne	SHORT @@prev
		mov	di,rowcnt
		dec	di
@@loop:		call	offset_prev
		mov	[si.ios_bb],eax
		dec	di
		jnz	SHORT @@loop
		jmp	SHORT @@toend

			;----------------------------------------------------

event_pgdn:	mov	eax,scount
		add	eax,[si.ios_bb]
		inc	eax
		cmp	eax,fsize
		jae	SHORT @@toend
		test	xflag,TV_HEXVIEW
		jz	SHORT @@txt
		mov	edx,eax
		mov	ax,rowcnt
		mov	cl,4
		test	xflag,TV_BINVIEW
		jz	SHORT @@hex
		dec	cl
@@hex:		shl	ax,cl
		movzx	eax,ax
		add	edx,eax
		cmp	edx,fsize
		jae	SHORT @@eend
		add	[si.ios_bb],eax		; fpos += (rowcnt * 16);
		jmp	dw_update
@@txt:		mov	ax,lcount
		cmp	ax,rowcnt
		jne	SHORT @@toend
		mov	ax,lcount
		dec	ax
		shl	ax,2
		lea	bx,ltab
		add	bx,ax
		mov	eax,ss:[bx]
		cmp	eax,fsize
		jae	SHORT @@eend	; return event_end();
		mov	[si.ios_bb],eax
		jmp	dw_update
@@eend:		jmp	event_end
@@toend:	ret

			;----------------------------------------------------

event_left:	test	xflag,(TV_HEXVIEW or TV_BINVIEW or TV_WRAPLINES)
		jnz	SHORT @@toend
		cmp	curcol,0
		jz	SHORT @@toend
		dec	curcol
		jmp	dw_update
@@toend:	ret

			;----------------------------------------------------

event_pgleft:	test	xflag,(TV_HEXVIEW or TV_BINVIEW or TV_WRAPLINES)
		jnz	SHORT @@toend
		mov	eax,curcol
		or	eax,eax
		jz      SHORT @@toend
		cmp	eax,80
		ja      SHORT @@sub
		xor	eax,eax
		jmp	SHORT @@set
@@sub:		sub	eax,80
@@set:		mov	curcol,eax
		jmp	dw_update
@@toend:	ret

			;----------------------------------------------------

event_right:	test	xflag,(TV_HEXVIEW or TV_BINVIEW or TV_WRAPLINES)
		jnz	SHORT @@toend
		mov	eax,curcol
		cmp	eax,maxcol
		jz	SHORT @@toend
		inc	curcol
		jmp	dw_update
@@toend:	ret

			;----------------------------------------------------

event_pgright:	test	xflag,(TV_HEXVIEW or TV_BINVIEW or TV_WRAPLINES)
		jnz	SHORT @@toend
		mov	eax,curcol
		cmp	eax,maxcol
		jb	SHORT @@add
@@toend:	ret
@@add:		add	eax,80
		cmp	eax,maxcol
		jb	SHORT @@set
		mov	eax,maxcol
@@set:		mov	curcol,eax
		jmp	dw_update

event_endright: test	xflag,(TV_HEXVIEW or TV_BINVIEW or TV_WRAPLINES)
		jnz	SHORT @@toend
		mov	eax,maxcol
		cmp	eax,80
		ja	SHORT @@sub
@@toend:	ret
@@sub:		sub	eax,20
		mov	curcol,eax
		jmp	dw_update

event_startofline:
		xor	eax,eax
		mov	curcol,eax
		jmp	dw_update


			;----------------------------------------------------

event_search:	call	continue_search
		or	ax,ax
		jz	SHORT @@toend
		xor	eax,eax
		mov	curcol,eax
		jmp	dw_update
@@toend:	ret

cm_search:      and	[si.ios_flag],(not IO_SEARCHMASK)
		mov	ax,xflag
		and	ax,IO_SEARCHMASK
		or      [si.ios_flag],ax
@@search:	push	fsize
		call	cmdsearch
		push	ax
		and	xflag,(not IO_SEARCHMASK)
		mov	ax,[si.ios_flag]
		and	[si.ios_flag],(not (IO_SEARCHSET or IO_SEARCHCUR))
		and	ax,IO_SEARCHMASK
		or      xflag,ax
		pop	ax
		or	ax,ax
		jz	SHORT @@toend
		jmp	dw_update
@@toend:	ret

			;----------------------------------------------------

idd_ldoffset:	push	[si.ios_bb]
		push	ds
		mov	ax,OFFSET form_08lXh
		test	xflag,TV_HEXOFFSET
		jnz	SHORT @@hex
		mov	ax,OFFSET form_lu
@@hex:		push	ax
		les	bx,ddtmp
		les	bx,es:[bx.dl_object]
		push	es:[bx.to_data]
		call	sprintf
		add	sp,12
		push	ddtmp
		call	tdinit
		ret

iddseekio:	push	IDD_Seek
		call	rsopen
		or	ax,ax
		jnz	SHORT @@seekio
		ret

@@seekio:	mov	WORD PTR [ddtmp],ax
		mov	WORD PTR [ddtmp+2],dx
		call	idd_ldoffset
		push	IDD_Seek
		push	ddtmp
		call	rsevent
		or	ax,ax
		jz	SHORT idd_exit
		les	bx,ddtmp
		les	bx,es:[bx.dl_object]
		push	es:[bx.to_data]
		call	strtol
		test	[si.ios_flag],IO_MEMREAD
		jnz	SHORT @@memoffs
@@push:		push	dx
		push	ax
		pop	eax
@@size:		cmp	eax,fsize
		ja	SHORT idd_exit
		mov     [si.ios_bb],eax
		call	idd_exit
		inc	ax
		ret

@@memoffs:      cmp	dx,15
		jbe	SHORT @@push
		call	memtoffs
		jmp	SHORT @@size

cm_seek:	call	iddseekio
		jz	SHORT @@toend
		jmp	dw_update
@@toend:	ret

idd_exit:	push	ddtmp
		call	twclose
		xor	ax,ax
		ret

;----------------------------------------------------

ID_OFFSET	=	0
ID_SIZE		=	16
ID_FILE		=	32
ID_CLIPBOARD	=	48

cm_copy:	push	IDD_TVCopy
		call	rsopen
		or	ax,ax
		jnz	SHORT @@copy
		ret

@@copy:		mov	WORD PTR [ddtmp],ax
		mov	WORD PTR [ddtmp+2],dx
		test	xflag,TV_CLIPBOARD
		jz	SHORT @@idd
		les	bx,ddtmp
		les	bx,es:[bx.dl_object]
		add	bx,ID_CLIPBOARD
		or	es:[bx.to_flag],_O_FLAGB
@@idd:		call	idd_ldoffset
		push	IDD_TVCopy
		push	ddtmp
		call	rsevent
		or	ax,ax
		jz	SHORT idd_exit
		les	bx,ddtmp
		les	bx,es:[bx.dl_object]
		push	es:[bx.to_data]
		and	xflag,(not TV_CLIPBOARD)
		add	bx,ID_CLIPBOARD
		test	es:[bx.dl_flag],_O_FLAGB
		jz	SHORT @@offset
		or	xflag,TV_CLIPBOARD
@@offset:	call	strtol
		push	dx
		push	ax
		pop	eax
		cmp	eax,fsize
		jae	SHORT idd_exit
		push	eax
		push	SEEK_SET
		call	oseek
		jz	SHORT @@toend
		test	xflag,TV_CLIPBOARD
		jnz	SHORT @@clipboard
		;jmp	SHORT @@er_open

		push	OSTDO
		call	oinitst
		jz	SHORT @@toend

		les	bx,ddtmp
		les	bx,es:[bx.dl_object]
		add	bx,32
		push	es:[bx.to_data]
		call	getouthandle
		cmp	ax,-1
		je	SHORT @@er_open
		mov	bx,OSTDO
		mov	[bx.ios_file],ax
		les	bx,ddtmp
		les	bx,es:[bx.dl_object]
		add	bx,16
		push	es:[bx.to_data]
		call	strtol
		push	dx
		push	ax
		call	ocopy
		call	ofwrite
		push	OSTDO
		call	oclose
@@toend:	call	idd_exit
		inc	ax
		ret

@@er_open:	push	OSTDO
		call	ofreest
		les	bx,ddtmp
		les	bx,es:[bx.dl_object]
		add	bx,32
		push	es:[bx.to_data]
		push	EMEROPEN
		call	idd_exit
		push	ax
		call	stderror
		ret

@@clipboard:    les	bx,ddtmp
		les	bx,es:[bx.dl_object]
		add	bx,16
		push	es:[bx.to_data]
		call	strtol
		or	dx,dx
		jnz	SHORT @@clip_end
		or	ax,ax
		jz	SHORT @@clip_end
		mov	bx,OSTDI
		cmp	ax,[bx.ios_c]
		ja	SHORT @@clip_end
		push	[bx.ios_bp]
		push	ax
		call	ClipboardInit
		call	ClipboardOpen
		call	ClipboardEmpty
		call	ClipboardCopy
		call	ClipboardClose
		call	ClipboardFree
@@clip_end:     call	idd_exit
		inc	ax
		ret

;----------------------------------------------------

cm_color:	xor	xflag,TV_HIGHCOLOR
		call	update_dlg
		mov	ax,1
		ret

cm_wrap:	cmp	fsize,0
		jz	SHORT cm_ret0
		test	xflag,TV_HEXVIEW
		jnz	SHORT cm_ret0
		xor	xflag,TV_WRAPLINES
		jmp	SHORT cm_upd

cm_offs:	cmp	fsize,0
		jz	SHORT cm_ret0
		xor	xflag,TV_HEXOFFSET
		jmp	SHORT cm_upd

cm_binary:	cmp	fsize,0
		jz	SHORT cm_ret0
		test    xflag,TV_HEXVIEW
		jnz	SHORT @@xor
		or	xflag,(TV_HEXVIEW or TV_BINVIEW)
		jmp	SHORT cm_upd
@@xor:          xor	xflag,TV_BINVIEW
		jmp	SHORT cm_upd

cm_hex:		cmp	fsize,0
		jz	SHORT cm_ret0
		and	xflag,(not TV_BINVIEW)
		xor	xflag,TV_HEXVIEW
		test    xflag,TV_HEXVIEW
		jnz	SHORT @@hex
@@text:         mov	eax,curcol
		cmp	eax,[si.ios_bb]
		ja	SHORT cm_upd
		sub	[si.ios_bb],eax
		jmp	SHORT cm_upd
@@hex:          mov	eax,curcol
		add	[si.ios_bb],eax
cm_upd:		call	update_dlg
		jmp	dw_update

cm_quit:	mov	switch,1
cm_ret0:	xor	ax,ax
		ret

cm_help:	push	IDD_TVHelp
		call	rsmodal
		ret

event_handler:  mov	cx,key_count
		xor	bx,bx
		cmp	fsize,0
		jnz	SHORT @@keyloop
		mov	cx,key_glcount
@@keyloop:	cmp	ax,[bx.key_global]
		jz	SHORT @@exe
		add	bx,2
		loop	SHORT @@keyloop
		ret
@@exe:		jmp	[bx.key_proc]

;---------------------------------------------------------------------------

scroll_action:  call	mousey	; ax = xpos
		push	ax	; dx = ypos
		call	mousex  ; bx = result
		xor	cx,cx
		mov	es,cx
		mov	cl,es:[0484h]
		pop	dx
		xor	bx,bx
		cmp	cx,24
		jz	SHORT @@sa_00
		shr	ax,1
		shr	dx,1
@@sa_00:	cmp	dx,8
		jb	SHORT @@sa_up
		cmp	dx,16
		ja	SHORT @@sa_dn
		cmp	dx,8
		jb	SHORT @@sa_r0
		cmp	dx,16
		ja	SHORT @@sa_r0
		cmp	ax,31
		jb	SHORT @@sa_le
		cmp	ax,50
		ja	SHORT @@sa_ri
		cmp	dx,12
		jnz	SHORT @@sa_01
		cmp	ax,39
		ja	SHORT @@sa_ri
		jmp	SHORT @@sa_le
@@sa_01:	cmp	dx,11
		jb	SHORT @@sa_02
		cmp	dx,13
		ja	SHORT @@sa_02
		cmp	ax,36
		jb	SHORT @@sa_le
		cmp	ax,45
		ja	SHORT @@sa_ri
@@sa_02:	cmp	dx,12
		jb	SHORT @@sa_up
		ja      SHORT @@sa_dn
@@sa_r0:	ret
@@sa_ri:	inc	bx
@@sa_le:	inc	bx
@@sa_dn:	inc	bx
@@sa_up:	inc	bx
delay_time:     push	bx
		cmp	ax,37
		jb	SHORT @@dt_left
		cmp	ax,43
		jb	SHORT @@dt_x0
		mov	bx,79
		sub	bx,ax
		mov	ax,bx
		jmp	SHORT @@dt_left
@@dt_x0:	xor	ax,ax
@@dt_left:	shl	ax,2
		cmp	dx,12
		jz	SHORT @@dt_y0
		jb	SHORT @@dt_up
		mov	cx,24
		sub	cx,dx
		mov	dx,cx
		jmp	SHORT @@dt_up
@@dt_y0:	xor	dx,dx
@@dt_up:	add	dx,dx
		add	dx,dx
dt_end:         pop	bx
		ret

			;----------------------------------------------------

sd_case		DW	sd_default
		DW	sd_case_up
		DW	sd_case_dn
		DW	sd_case_le
		DW	sd_case_ri

scrolldelay:   push	di
		xor	di,di
		call	scroll_action
		add	bx,bx
		jmp	cs:[bx.sd_case]
sd_case_up:     mov	ax,KEY_UP
		jmp	SHORT sd_01
sd_case_dn:	mov	ax,KEY_DOWN
sd_01:		push	dx
		jmp	SHORT sd_02
sd_case_le:	push	ax
		mov	ax,KEY_LEFT
		jmp	SHORT sd_02
sd_case_ri:	push	ax
		mov	ax,KEY_RIGHT
sd_02:		call	event_handler
		pop	ax
		mov	di,ax
sd_default:	cmp	di,0
		jz	SHORT sd_end
		push	di
		call	delay
sd_end:         pop	di
		ret

			;----------------------------------------------------

event_mouse:    call	mousep
		or	ax,ax
		jz	SHORT @@toend
		call	mousey
		mov	y,ax
		call	mousex
		mov	x,ax
		mov	ax,rowcnt
		inc	ax
		cmp	ax,y
		jnz	SHORT @@scroll
		call	mouseloop	; wait until button released..
		cmp	x,9
		jnb	SHORT @@wrap
		jmp	cm_help
@@wrap:		je	SHORT @@toend
		cmp	x,20
		jnb	SHORT @@search
		jmp	cm_wrap
@@search:       je	SHORT @@toend
		cmp	x,31
		jnb	SHORT @@hex
		jmp	cm_search
@@hex:		je	SHORT @@toend
		cmp	x,41
		jnb	SHORT @@copy
		jmp	cm_hex
@@copy:		je	SHORT @@toend
		cmp	x,50
		jnb	SHORT @@offs
		jmp	cm_copy
@@offs:         je	SHORT @@toend
		cmp	x,58
		jnb	SHORT @@seek
		jmp	cm_offs
@@seek:         je	SHORT @@toend
		cmp	x,66
		ja	SHORT @@quit
		jmp	cm_seek
@@quit:		cmp	x,70
		jna	SHORT @@toend
		call	cm_quit
@@toend:	xor	ax,ax
		ret
@@scroll:	call	mousep
		cmp	ax,1
		jnz	SHORT @@toend
		call	scrolldelay
		jmp	SHORT @@scroll

;---------------------------------------------------------------------------

modal:          cmp	switch,0
		jnz	SHORT @@toend
@@idle:		call	mousep
		or	ax,ax
		jnz	SHORT @@mouse
		call	getkey
		or	ax,ax
		jz	SHORT @@idle
		jmp	SHORT @@hndevent
@@mouse:	call	event_mouse
		jmp	SHORT @@mousep
@@hndevent:	call	event_handler
@@mousep:	call	mouseloop
		jmp	SHORT modal
@@toend:	xor	ax,ax
		ret

;---------------------------------------------------------------------------

dummy_update:	xor	ax,ax
		retf

mouseloop:	call	mousep
		or	ax,ax
		jnz	SHORT mouseloop
		ret

update_dlg:     push	si
		mov	si,xflag
		push	0
		push	1
		mov	dx,rowcnt
		mov	ax,80
		mul	dl
		push	ax
		mov	al,bg_Desktop
		or	al,07h
		test	si,TV_HIGHCOLOR
		jz	SHORT @@setcolor
		or	al,0Fh
@@setcolor:	push	ax
		call	scputa
		push	35
		mov	ax,rowcnt
		inc	ax
		push	ax
		push	0
		push	5
		push	ds
		mov	ax,OFFSET cp_hex
		test	si,TV_HEXVIEW
		jz	SHORT @@sethex
		mov	ax,OFFSET cp_ascii
@@sethex:	push	ax
		call	scputs
		push	13
		mov	ax,rowcnt
		inc	ax
		push	ax
		push	0
		push	6
		push	ds
		mov	ax,OFFSET cp_unwrap
		test	si,TV_WRAPLINES
		jnz	SHORT @@setwrap
		mov	ax,OFFSET cp_wrap
@@setwrap:	push	ax
		call	scputs
		push	54
		mov	ax,rowcnt
		inc	ax
		push	ax
		push	0
		push	3
		push	ds
		mov	ax,OFFSET cp_dec
		test	si,TV_HEXOFFSET
		jnz	SHORT @@setoffs
		mov	ax,OFFSET cp_hex
@@setoffs:	push	ax
		call	scputs
		pop	si
		ret

;---------------------------------------------------------------------------

IFDEF	TVEXE
msgmsdos:	mov	ah,40h
		mov	bx,2
		int	21h
		ret
ENDIF

;---------------------------------------------------------------------------

tview		PROC	PASCAL	DIST
ARG		fname:	DWORD,\		; filename
		offs:	DWORD           ; offset
LOCAL           x,y,z:	WORD,\		; temp (mouse)
		ddtmp:	DWORD,\         ; temp 32
		switch:	WORD,\		; main switch
		dialog:	DWORD,\		; main dialog pointer
		cursor:	DWORD,\		; cursor (old)
		oldupd:	DWORD,\		; update proc (old)
		s_dlg:	DWORD,\		; search dialog
		s_offs:	DWORD,\		; search offset
		tcount:	WORD,\		; TexLineCount
		tltab:	DWORD:[256],\	; offset of first 256 lines
		ltab:	DWORD:[MAXROW+2],\; line offset in file
		ocx:	WORD,\		; buffer size
		curcol:	DWORD,\		; current line offset (col)
		maxcol:	DWORD,\		; max linesize on screen
		rowcnt:	WORD,\		; max lines (23/48)
		lcount:	WORD,\		; lines on screen
		scount:	DWORD,\		; bytes on screen
		screen:	DWORD,\		; screen buffer
		xflag:	WORD,\		; config flag
		fsize:	DWORD
		USES	si,di

		mov	si,OSTDI
		mov	ax,cflag
		mov	xflag,ax
		mov	eax,offs
		mov	[si.ios_bb],eax
		xor	eax,eax
		mov	switch,ax
		mov	[si.ios_c],ax
		mov	[si.ios_i],ax
		and	[si.ios_flag],IO_MEMREAD
		mov	curcol,eax
		mov	maxcol,eax
		mov	scount,eax
		mov	lcount,ax
		mov	tcount,ax
		mov	es,ax
		mov	al,es:[0484h]
		dec	ax
		mov	rowcnt,ax	; number of lines on screen - 2
		add	ax,2
		mov	rs_rcrow,al	; set row count in dialog
		mov	dx,160
		mul	dl
		add	ax,16
		mov	resource,ax	; adjust memory size
		mov	ax,rowcnt
		mov	dx,80
		mul	dl
		or	ax,0F000h
		xchg	al,ah
		mov	rs_atcnt,ax     ; adjust attrib count
		add	ah,2
		mov	rs_chcnt,ax     ; adjust char count
		mov	ax,MEMPAGE
		mov	[si.ios_memz],ax
IFDEF MEMVIEW
		test	[si.ios_flag],IO_MEMREAD
		jnz	SHORT @@alloc
ENDIF
		push	fname
IFDEF TVEXE
		push    0
		push	M_RDONLY
		push	A_OPEN
		call	osopen
		cmp	ax,-1
		jz	SHORT @@eropen
ELSE
		push	M_RDONLY
		push	A_OPEN
		call	openfile
		cmp	ax,-1
		jz	SHORT @@toend
ENDIF
		mov	[si.ios_file],ax
@@alloc:	push	ALLOCSIZE
		call	malloc
		mov	[si.ios_bp],eax
		mov	screen,eax
		add	screen,(MEMPAGE+12)	; 4008h - align tabs
		or	ax,ax
		jz	SHORT @@errmem
		push	ds
		push	OFFSET resource
		call	rsopen
		or	ax,ax
		jnz	SHORT @@dialog
		push	[si.ios_bp]
		call	free
@@errmem:
IFDEF MEMVIEW
		test	[si.ios_flag],IO_MEMREAD
		jnz	SHORT @@return_1
ENDIF
		push	[si.ios_file]
		call	close
@@return_1:	mov	ax,1
@@toend:
IFNDEF TVEXE
@@shift:	les	bx,shift
		test	WORD PTR es:[bx],0000001000001000b
		jnz	SHORT @@shift
ENDIF
		ret
IFDEF TVEXE
@@eropen:	mov	dx,OFFSET FileNotFound
		mov	cx,size_FileNotFound
		call	msgmsdos
		push	fname
		call	strlen
		mov	cx,ax
		push	ds
		lds	dx,fname
		call	msgmsdos
		pop	ds
		jmp	SHORT @@toend
ENDIF

@@dialog:	mov	WORD PTR [dialog],ax
		mov	WORD PTR [dialog+2],dx
		push	dialog
		call	twshow
		call	mouseoff
		push    12
		push	0
		push	30
IFDEF MEMVIEW
		test	[si.ios_flag],IO_MEMREAD
		jz	SHORT @@fname
		push	ds
		push	OFFSET cp_memory
		jmp	SHORT @@scpath
ENDIF
@@fname:	push	fname
@@scpath:	call	scpath
		add	ax,14
		mov	x,ax
IFDEF MEMVIEW
		test	[si.ios_flag],IO_MEMREAD
		jz	SHORT @@seek
		xor	ax,ax
		dec	ax
		mov	dx,15
		jmp	SHORT @@setsize
ENDIF
@@seek:		mov	ax,4202h	; get filesize from handle
		mov	bx,[si.ios_file]
		xor	cx,cx
		xor	dx,dx
		int	21h
		jc	SHORT @@fsize
@@setsize:	mov	WORD PTR [fsize+0],ax
		mov	WORD PTR [fsize+2],dx
@@fsize:	push	large 0
		push	dx
		push	ax
		call	qwtobstr
		push	x
		push	large 0
		push	0
		push	dx
		push	ax
		call	scputs
		add	ax,x
		push	ax
		push	large 0
		push	0
		push	ds
		push	OFFSET cp_byte
		call	scputs
		lea	ax,cursor
		push	ss
		push	ax
		call	getcursor
		call	cursoroff
IFNDEF TVEXE
	IFDEF LPROG
		mov	eax,tupdate
		mov	oldupd,eax
	ELSE
		mov	ax,tupdate
		mov	WORD PTR oldupd,ax
	ENDIF
ENDIF
		push	cs
		push	OFFSET dummy_update
		pop     tupdate
		call	mouseon
		call	update_dlg
@@mousep:	call	mousep
		or	ax,ax
		jnz	SHORT @@mousep
		call	Readstatic
		call	dw_update
		call	modal
		push	[si.ios_bp]
		call	free
		push	dialog
		call	twclose
IFDEF MEMVIEW
		test	[si.ios_flag],IO_MEMREAD
		jnz	SHORT @@resetupd
ENDIF
		push	[si.ios_file]
		call	close
@@resetupd:     xor	ax,ax
		mov     [si.ios_flag],ax

		mov	eax,oldupd
IFDEF	LPROG
		mov	tupdate,eax
ELSE
		mov	tupdate,ax
ENDIF
		push	cursor
		call	setcursor
		mov	ax,xflag
		mov	cflag,ax
		xor	ax,ax
		jmp	@@toend
tview		ENDP

;---------------------------------------------------------------------------

IFDEF	TVEXE

		PUBLIC	oupdcrc	; exclude from link
		PUBLIC	oupdate
		PUBLIC	_flsbuf
oupdcrc:	ret
oupdate		PROC	PASCAL	DIST
ARG		@@ios:	WORD
		xor	ax,ax
		ret
oupdate		ENDP
_flsbuf		PROC	PASCAL	DIST
ARG		@@iob:	DWORD
		mov	ax,-1
		ret
_flsbuf		ENDP

;---------------------------------------------------------------------------

;_TEXT		SEGMENT

main_argx:	mov	dx,'/-'
		mov	ax,es:[bx]
		cmp	al,dl
		je	SHORT @@found
		cmp	ah,dl
		jne	SHORT @@error
@@found:	or	ah,20h
		ret
@@error:	xor	ax,ax
		ret

main_argm:	mov	bx,OSTDI
		or	[bx.ios_flag],IO_MEMREAD
		mov	WORD PTR [argn],OFFSET cp_memory
		mov	WORD PTR [argn+2],ds
		ret

main_argo:	push	es
		les	bx,es:[di]
		push	es
		add	bx,2
		push	bx
		call	strtol
		pop	es
		jz	SHORT @@argerror
@@setoffs:	mov	WORD PTR [argo],ax
		mov	WORD PTR [argo+2],dx
		xor	ax,ax
		inc	ax
		ret
@@argerror:	xor	ax,ax
		ret

		PUBLIC	main

main		PROC	PASCAL	DIST
ARG		argc:	WORD,\
		argv:	DWORD
LOCAL		argn:	DWORD,\
		argo:	DWORD
		mov	cx,sizecopyright
		mov	dx,OFFSET copyright
		call	msgmsdos
		cmp	argc,1
		je	SHORT @@argerror
		cmp	argc,5
		jnb	SHORT @@argerror
		xor	eax,eax
		mov	argn,eax
		mov	argo,eax
		mov	si,argc
		dec	si
		les	di,argv
		add	di,4
@@argloop:      push	es
		les	bx,es:[di]
		call	main_argx
		pop	es
		jz	SHORT @@filename
		cmp	ah,'m'
		je	SHORT @@initmem
		cmp	ah,'o'
		je	SHORT @@initoffset
@@argerror:	mov	cx,sizeusage
		mov	dx,OFFSET cp_usage
		call	msgmsdos
		jmp	@@toend
@@nextarg:      add	di,4
		dec	si
		jnz	SHORT @@argloop
		xor	eax,eax
		cmp	eax,argn
		je	SHORT @@argerror
		mov	bx,OSTDI
		test	[bx.ios_flag],IO_MEMREAD
		jz	SHORT @@endargs
		cmp	eax,argo
		je	SHORT @@endargs
		mov     edx,eax
		mov     ax,WORD PTR [argo+2]
		mov	dx,WORD PTR [argo]
		shl	eax,4
		add	eax,edx
		mov	argo,eax
		jmp	SHORT @@endargs
@@filename:	xor	eax,eax
		cmp	eax,argn
		jne	SHORT @@argerror
		mov	eax,es:[di]
		mov	argn,eax
		jmp	SHORT @@nextarg
@@initoffset:   xor	eax,eax
		cmp	eax,argo
		jne	SHORT @@argerror
		call	main_argo
		jz	SHORT @@argerror
		jmp	SHORT @@nextarg
@@initmem:      call	main_argm
		jmp	SHORT @@nextarg
@@endargs:	call	mouseinit
		call	mouseon
		push	63
		push	6
		call	setpal
		push	ds
		push	OFFSET searchstring
		push	ds
		push	OFFSET cp_ext
		call	setext
		push	dx
		push	ax
		call	readword
		mov	config,ax	; => config
		mov	searchstring,0

		push	argn
		push	argo
		call	tview		; tview(argn, argo);
		call	mouseoff
		push	ds
		push	OFFSET searchstring
		push	ds
		push	OFFSET cp_ext
		call	setext
		push	dx
		push	ax
		push    _A_HIDDEN
		push	M_WRONLY
		push	(A_CREATE or A_TRUNC)
		call	osopen
		cmp	ax,-1
		jz	SHORT @@toend
		push	ax
		mov	bx,ax
		mov	ax,4000h
		mov	cx,2
		mov	dx,OFFSET config
		int	21h
		call	close
@@toend:	xor	ax,ax
		ret
main		ENDP

ENDIF		; IFDEF TVEXE

TVIEW_TEXT	ENDS

		END
