; PRECT.ASM--
; Copyright (c) 1996-2008 Hjort Nidudsson
;
; Change history:
;

INCLUDE		clib.inc
INCLUDE		dzmain.inc
INCLUDE		dialog.inc

SPRECT		STRUC
		pr_info		DD ?
		pr_frame	DD ?
		pr_proc		DD ?
		pr_rect		DD ?
		ENDS

_DATA		SEGMENT

CELL_VSL	=	0
CELL_VLL	=	1
CELL_VSD	=	2
CELL_VLD	=	3
CELL_HSL	=	4
CELL_HLL	=	5
CELL_HSD	=	6
CELL_HLD	=	7

_i_vsl		DB	10,9,'  Name',9,9,'Name',9,9,' Name',0
_i_vll		DB	10,9,9,'Name',9,9,9,'  '
cp_name		DB	'Name',0
_i_vsd		DB	10,9,'  Name',9,'  Byte',9,' Date',9,'Time',0
_i_vld		DB	10,9,9,9,' Name',9,9,9,'   Byte',0

_f_vsl		DB	14,13,0
_f_vll		DB	20,0,0
_f_vsd		DB	14,0,10,24,0
_f_vld		DB	12,28,0
_f_hsl		DB	14,14,14,27,14,40,14,53,0
_f_hll		DB	21,0,20,39,0
_f_hsd		DB	12,14,7,34,12,53,7,73,0
_f_hld		DB	12,53,7,73,0

xcell_rect	DD	_DATA:_i_vsl
		DD	_DATA:_f_vsl
		DD	_TEXT:fbputsl
		DB	1,2,12,1
		DD	_DATA:_i_vll
		DD	_DATA:_f_vll
		DD	_TEXT:fbputll
		DB	1,2,18,1
		DD	_DATA:_i_vsd
		DD	_DATA:_f_vsd
		DD	_TEXT:fbputsd
		DB	1,2,38,1
		DD	_DATA:_i_vld
		DD	_DATA:_f_vld
		DD	_TEXT:fbputld
		DB	1,2,38,1
		DD	_DATA:_i_vsl
		DD	_DATA:_f_hsl
		DD	_TEXT:fbputsl
		DB	2,2,12,1
		DD	_DATA:_i_vll
		DD	_DATA:_f_hll
		DD	_TEXT:fbputll
		DB	2,2,18,1
		DD	_DATA:_i_vsd
		DD	_DATA:_f_hsd
		DD	_TEXT:fbputsd
		DB	2,2,38,1
		DD	_DATA:_i_vsd
		DD	_DATA:_f_hld
		DD	_TEXT:fbputld
		DB	1,2,78,1

_DATA		ENDS

PRECT_TEXT	SEGMENT USE16 BYTE PUBLIC 'CODE'
		ASSUME CS:PRECT_TEXT, DS:DGROUP

InitRect:	mov	rect,16280100h
		les	bx,__egaline
		mov	al,es:[bx]
		dec	al
		dec	al
		test	config.c_lflag,_C_HORIZONTAL
		jz	SHORT @@Mini
		mov	rect.rc_col,80
		shr	al,1
@@Mini:		test	config.c_lflag,_C_SMALLPANELS
		jz	SHORT @@SetRow
		shr	al,1
		add	al,5
		test	config.c_lflag,_C_HORIZONTAL
		jz	SHORT @@SetRow
		sub	al,2
@@SetRow:	mov	rect.rc_row,al
		mov	bx,WORD PTR panel
		mov	bx,[bx]
		mov	di,[bx]
		test	di,_W_PANELID
		jz	SHORT @@toend
		test	config.c_lflag,_C_HORIZONTAL
		jz	SHORT @@Vertical
		mov	al,rect.rc_row
		add	rect.rc_y,al
		ret
@@Vertical:	mov	rect.rc_x,40
@@toend:	ret

prect_open	PROC	PASCAL	DIST
ARG		panel:	DWORD
LOCAL		@@x:	WORD,\
		@@q:	WORD,\
		rect:	DWORD,\
		rcxl:	DWORD,\
		dlwp:	DWORD
		USES	si,di

		call	InitRect
@@InitX:	xor	ax,ax
		test	config.c_lflag,_C_HORIZONTAL
		jz	SHORT @@Long
		mov	al,4
@@Long:		test	di,_W_LONGNAME
		jz	SHORT @@Detail
		inc	al
@@Detail:	test	di,_W_DETAIL
		jz	SHORT @@EndX
		add	al,2
@@EndX:		mov	@@x,ax

		shl	ax,4
		mov	si,ax
		add	si,OFFSET xcell_rect
		mov	eax,[si.pr_rect]
		mov	rcxl,eax
		mov	al,rect.rc_x
		add	rcxl.rc_x,al
		mov	al,rect.rc_y
		add	rcxl.rc_y,al
		mov	bx,WORD PTR panel
		mov	bx,WORD PTR [bx.pn_xl]
		mov	eax,rcxl
		mov	[bx.xl_cpos],eax
		mov	al,rect.rc_row
		sub	al,3
		mov	[bx.xl_rows],al
		movzx	ax,rect.rc_col
		div	rcxl.rc_col
		mov	[bx.xl_cols],al

		mov	bx,OFFSET paneldlgA
		test	di,_W_PANELID
		jz	SHORT @@TestOpen
		mov	bx,OFFSET paneldlgB

@@TestOpen:     test	[bx.dl_flag],_D_DOPEN
		jz	SHORT @@InitRC
		push	bx
		mov	bx,WORD PTR panel
		push	[bx.pn_dialog]
		push	[bx.pn_xl]
		call	twclose
		call	twclose
		pop	bx

@@InitRC:	mov	eax,rect
		mov	[bx.dl_rect],eax

		mov	bx,WORD PTR panel
		push	[bx.pn_dialog]
		mov	al,at_background[B_Desktop]
		or	al,at_foreground[F_Frame]
		push	ax
		xor	eax,eax
		push	eax
		call	twopen
		or	ax,ax
		jnz	SHORT @@Open
@@toend:	ret

@@Open:		xor	al,al
		mov	rect.rc_x,al
		mov	rect.rc_y,al
		mov	bx,WORD PTR panel
		mov	bx,WORD PTR es:[bx.pn_dialog]
		mov	eax,[bx.dl_wp]
		mov	dlwp,eax
		movzx	dx,rect.rc_col
		add	ax,dx
		add	ax,dx
		push	eax
		push	dx
		MKAT	B_Desktop,F_Panel
		mov	al,' '
		push	ax
		call	wcputw

		test	di,_W_MINISTATUS
		jz	SHORT @@PutFrame

		sub	rect.rc_row,2
		mov	bx,WORD PTR panel
		mov	bx,WORD PTR [bx.pn_xl]
		sub	[bx.xl_rows],2

		test	di,_W_DRVINFO
		jz	SHORT @@RCFrame

		sub	rect.rc_row,2
		sub	[bx.xl_rows],2
		test	config.c_lflag,_C_HORIZONTAL
		jnz	SHORT @@RCFrame
		dec	rect.rc_row
		dec	[bx.xl_rows]

@@RCFrame:	push	rect
		push	dlwp
		xor	ax,ax
		mov	al,rect.rc_col
		push	ax
		mov	al,at_background[B_Desktop]
		or	al,at_foreground[F_Frame]
		push	ax
		call	rcframe

@@PutFrame:     mov	eax,rect
		mov	rcxl,eax
		xor	ax,ax
		mov	al,rect.rc_col
		mov	@@q,ax
		mov	bx,si
		add	bx,4
		mov	bx,[bx]

@@FrameLoop:	xor	al,al
		cmp	al,[bx]
		je	SHORT @@InitProc

		mov	al,[bx]
		inc	bx
		mov	rcxl.rc_col,al
		mov	al,[bx]
		inc	bx
		mov	rcxl.rc_x,al
		push	bx
		push	rcxl
		push	dlwp
		push	@@q
		mov	ah,2
		mov	al,at_background[B_Desktop]
		or	al,at_foreground[F_Frame]
		push	ax
		call	rcframe
		pop	bx
		jmp	SHORT @@FrameLoop

@@InitProc:	mov	eax,[si.pr_proc]
		mov	bx,WORD PTR panel
		mov	[bx.pn_putfcb],eax
		xor	cx,cx
		mov	dx,cx
		mov	dl,rect.rc_col
		mov	ax,@@x
		cmp	ax,CELL_VSL
		je	SHORT @@case_VLD
		cmp	ax,CELL_VLL
		je	SHORT @@case_VLD
		cmp	ax,CELL_VSD
		je	SHORT @@case_VLD
		cmp	ax,CELL_VLD
		je	SHORT @@case_VLD
		cmp	ax,CELL_HSL
		je	SHORT @@case_HSD
		cmp	ax,CELL_HSD
		je	SHORT @@case_HSD
		cmp	ax,CELL_HLL
		je	SHORT @@case_HLL
		cmp	ax,CELL_HLD
		je	SHORT @@case_HLD
		jmp	@@break

@@case_VLD:	push	dlwp
		push	dx
		push	cx
		push	[si.pr_info]
		call	wcputs
		jmp	@@break

@@case_HSD:	mov	eax,dlwp
		add	ax,80
		push	eax
		push	dx
		push	cx
		push	[si.pr_info]
		sub	ax,78
		push	eax
		push	dx
		push	cx
		push	[si.pr_info]
		call	wcputs
		call	wcputs
		jmp	SHORT @@break

@@case_HLL:	mov	eax,dlwp
		add	ax,80
		push	eax
		push	dx
		push	cx
		push	[si.pr_info]
		sub	ax,78
		push	eax
		push	dx
		push	cx
		push	[si.pr_info]
		call	wcputs
		call	wcputs
		jmp	SHORT @@break

@@case_HLD:	mov	eax,dlwp
		add	ax,dx
		add	ax,dx
		add	ax,(46*2)
		push	eax
		push	4
		push	' '
		sub	ax,(28*2)
		push	eax
		push	dx
		push	cx
		push	ds
		push	OFFSET cp_name
		mov	ax,WORD PTR dlwp
		add	ax,80
		push	eax
		push	dx
		push	cx
		push	[si.pr_info]
		call	wcputs
		call	wcputs
		call	wcputc

@@break:	les	bx,dlwp
		movzx	ax,rect.rc_col
		add	al,2
		add	bx,ax
		add	bx,ax
		mov	BYTE PTR es:[bx],':'
		mov	BYTE PTR es:[bx+2],25

		mov	bx,WORD PTR panel
		mov	bx,WORD PTR [bx.pn_dialog]
		mov	eax,[bx.dl_rect]
		mov	rect,eax
		xor	ax,ax
		mov	rect.rc_x,al
		mov	rect.rc_y,al

		push	rect
		push	dlwp
		mov	al,rect.rc_col
		push	ax
		mov	ah,1
		mov	al,at_background[B_Desktop]
		or	al,at_foreground[F_Frame]
		push	ax
		call	rcframe

		test	di,_W_MINISTATUS
		jz	SHORT @@NoMini

		test	di,_W_DRVINFO
		jz	SHORT @@NoDrvInfo
		mov	al,rect.rc_row
		sub	al,6
		test	config.c_lflag,_C_HORIZONTAL
		jz	SHORT @@NotHor
		inc	al
@@NotHor:	mul	rect.rc_col
		add	ax,2
		add	ax,ax
		mov	edx,dlwp
		add	dx,ax
		push	edx
		push	1
		push	31
		call	wcputc
		jmp	SHORT @@ShowPanel

@@NoDrvInfo:	mov	al,rect.rc_row
		sub	al,3
		mul	rect.rc_col
		add	ax,2
		shl	ax,1
		mov	edx,dlwp
		add	dx,ax
		push	edx
		push	1
		push	7
		mov	al,rect.rc_row
		sub	al,2
		mul	rect.rc_col
		sub	ax,3
		shl	ax,1
		mov	edx,dlwp
		add	dx,ax
		push	edx
		push	1
		push	31
		call	wcputc
		call	wcputc
		jmp	SHORT @@ShowPanel

@@NoMini:	mov	al,rect.rc_col
		mul	rect.rc_row
		sub	ax,3
		add	ax,ax
		mov	edx,dlwp
		add	dx,ax
		push	edx
		push	1
		push	30
		call	wcputc

@@ShowPanel:	push	panel
		call	prect_show
		jmp	@@toend
prect_open	ENDP

prect_close	PROC	PASCAL	DIST
ARG		panel:	DWORD
		xor	ax,ax
		mov	bx,WORD PTR panel
		mov	bx,[bx]
		test	[bx.wp_flag],_W_VISIBLE
		jz	SHORT @@toend
		push	panel
		call	prect_hide
		mov	bx,WORD PTR panel
		push	[bx.pn_dialog]
		call	twclose
		mov	ax,1
@@toend:	ret
prect_close	ENDP

prect_show	PROC	PASCAL	DIST
ARG		panel:	DWORD
		mov	bx,WORD PTR panel
		push	[bx.pn_dialog]
		call	twshow
		mov	bx,WORD PTR panel
		mov	bx,[bx]
		or	[bx.wp_flag],_W_VISIBLE
		ret
prect_show	ENDP

prect_hide	PROC	PASCAL	DIST
ARG		panel:	DWORD
		xor	ax,ax
		mov	bx,WORD PTR panel
		mov	bx,[bx]
		mov	bx,[bx]
		and	bx,_W_VISIBLE
		jz	SHORT @@toend
		mov	bx,WORD PTR panel
		push	[bx.pn_xl]
		call	twclose
		mov	bx,WORD PTR panel
		push	[bx.pn_dialog]
		call	twhide
		mov	bx,WORD PTR panel
		mov	bx,[bx]
		and	[bx],(not _W_VISIBLE)
		mov	ax,1
@@toend:	ret
prect_hide	ENDP

PRECT_TEXT	ENDS

		END
