/*
 * MENUS.C
 *
 *  This file is part of DOSZIP
 *  Copyright (c) 1996 Hjort Nidudsson.
 */

#include <errno.h>
#include <string.h>
#include <dzmain.h>

#define MENUSCMD	(-2)
#define MENUSLINE_COL	57

typedef struct {
	const char *info;
	int (*proc) (void);
      } MINFO;

const char
	cp_menusline[] =
"Panel-&A   &File   &Edit   &Setup   &Tools   &Help   Panel-&B",
	cp_statusline[] =
"&F&1 Help  &F&2 Ren  &F&3 View  &F&4 Edit  &F&5 Copy  &F&6 Move  "
"&F&7 Mkdir  &F&8 Del  &F&1&0 Exit",
	cp_stlctrl[] =
"&F&1 PanelA  &F&2 PanelB  &F&3 View  &F&4 Edit  &F&5 Name  &F&6 Type  "
"&F&7 Date  &F&8 Size",
	cp_stlctrlalt[] =
"&Quick Search: \x1A   ";

TOBJ tobj_menusline[] = { /* Active Menus Info */
	{ 0x0006, 0, 0x1E/*'A'*/, { 0, 0,11, 1}, "Panel-&A", },
	{ 0x0006, 0, 0x21/*'F'*/, {10, 0, 8, 1}, "&File",    },
	{ 0x0006, 0, 0x12/*'E'*/, {17, 0, 8, 1}, "&Edit",    },
	{ 0x0006, 0, 0x1F/*'S'*/, {24, 0, 9, 1}, "&Setup",   },
	{ 0x0006, 0, 0x14/*'T'*/, {32, 0, 9, 1}, "&Tools",   },
	{ 0x0006, 0, 0x23/*'H'*/, {40, 0, 8, 1}, "&Help",    },
	{ 0x0006, 0, 0x30/*'B'*/, {47, 0,11, 1}, "Panel-&B",  }
};

const char
	cp_long		[] = "Long/short filename",
	cp_detail	[] = "Show detail",
	cp_hidden	[] = "Show hidden files",
	cp_mini		[] = "Ministatus",
	cp_volinfo	[] = "Volume information",
	cp_sort		[] = "Sort current panel by Name, Type, Time, Size, or Unsorted",
	cp_toggle	[] = "Toggle panel - on/off",
	cp_pfilter	[] = "Panel filter",
	cp_subinfo	[] = "Directory information",
	cp_update	[] = "Re-read",
	cp_chdrv	[] = "Select drive",

	cp_rename	[] = "Rename file or directory",
	cp_view		[] = "View File or Directory information",
	cp_edit		[] = "Edit",
	cp_copy		[] = "Copy",
	cp_move		[] = "Move",
	cp_mkdir	[] = "Make directory",
	cp_delete	[] = "Delete",
	cp_blkprop	[] = "Edit file property",
	cp_compress	[] = "Compress",
	cp_decompress	[] = "Decompress",
//	cp_search	[] = "File Search",
	cp_history	[] = "List of the last 16 DOS commands",
	cp_exit		[] = "Exit program",

	cp_select	[] = "Select files",
	cp_deselect	[] = "Deselect files",
	cp_invert	[] = "Invert selection",
	cp_compare	[] = "Compare directories",

	cp_toggleon	[] = "Toggle panels - on/off",
	cp_togglehz 	[] = "Toggle panels - horizontal/vertical",
	cp_togglesz 	[] = "Toggle Panels - size",
	cp_egaline	[] = "Toggle 25-50 lines",
	cp_swappanels	[] = "Swap panels",

	cp_config	[] = "Configuration",
	cp_confirm	[] = "Confirmations options",
	cp_screen	[] = "Screen options",
	cp_panel	[] = "Panel options",

	cp_help		[] = "Help",
	cp_about	[] = "About Doszip";

static 	MINFO menus[] = {
	{ cp_long,   	cmalong		},
	{ cp_detail, 	cmadetail	},
	{ cp_hidden, 	cmahidden	},
	{ cp_mini,   	cmamini		},
	{ cp_volinfo,	cmavolinfo	},
	{ cp_sort,   	cmaname		},
	{ cp_sort,   	cmatype		},
	{ cp_sort,   	cmadate		},
	{ cp_sort,   	cmasize		},
	{ cp_sort,   	cmanosort	},
	{ cp_toggle, 	cmatoggle	},
	{ cp_pfilter,	cmafilter   	},
	{ cp_subinfo,	cmasubinfo  	},
	{ cp_update, 	cmaupdate	},
	{ cp_chdrv,  	cmachdrv	},

	{ cp_rename, 	cmrename 	},
	{ cp_view,   	cmview 		},
	{ cp_edit,   	cmedit 		},
	{ cp_copy,   	cmcopy 		},
	{ cp_move,   	cmmove 		},
	{ cp_mkdir,  	cmmkdir		},
	{ cp_delete, 	cmdelete 	},
	{ cp_blkprop,	cmblkprop 	},
	{ cp_compress, 	cmcompress 	},
	{ cp_decompress, cmdecompress 	},
	{ cp_search, 	cmsearch 	},
	{ cp_history, 	cmhistory	},
	{ cp_exit,   	cmexit 		},

	{ cp_select, 	cmselect 	},
	{ cp_deselect, 	cmdeselect 	},
	{ cp_invert, 	cminvert 	},
	{ cp_compare, 	cmcompare 	},

	{ cp_toggleon, 	cmtoggleon 	},
	{ cp_togglehz, 	cmtogglehz 	},
	{ cp_togglesz, 	cmtogglesz 	},
	{ cp_egaline, 	cmegaline 	},
	{ cp_swappanels, cmswap 	},
	{ cp_confirm, 	cmconfirm 	},
	{ cp_screen, 	cmscreen 	},
	{ cp_panel, 	cmpanel 	},
	{ cp_config, 	cmoptions 	},

	{ cp_help, 	cmhelp		},
	{ cp_about, 	cmabout		},

	{ cp_long,   	cmblong		},
	{ cp_detail, 	cmbdetail	},
	{ cp_hidden, 	cmbhidden	},
	{ cp_mini,   	cmbmini		},
	{ cp_volinfo,	cmbvolinfo	},
	{ cp_sort,   	cmbname		},
	{ cp_sort,   	cmbtype		},
	{ cp_sort,   	cmbdate		},
	{ cp_sort,   	cmbsize		},
	{ cp_sort,   	cmbnosort	},
	{ cp_toggle, 	cmbtoggle	},
	{ cp_pfilter,	cmbfilter   	},
	{ cp_subinfo,	cmbsubinfo  	},
	{ cp_update, 	cmbupdate	},
	{ cp_chdrv,  	cmbchdrv	},
};

int aputsl(const char *p)
{
	WCHR *wc;

	wc = (WCHR *)getxyp(0, *__egaline);
	__mshide();
	wcputw(wc, 80, MKW(at_Menus, ' '));
	wcputs(wc + 1, 79, 0, p);
	__msshow();
	return 0;
}

enum {	OP_LONGNAME,
	OP_DETAIL,
	OP_HIDDEN,
	OP_MINISTATUS,
	OP_DRVINFO,
	OP_NAME,
	OP_TYPE,
	OP_DATE,
	OP_SIZE,
	OP_NOSORT,
	OP_TOGGLE,
	OP_FILTER,
	OP_SUBINFO,
	OP_UPDATE,
	OP_CHDRV,
	OP_COUNT	};

int menus_oid[] = {
	ID_ALONGNAME,
	ID_RENAME,
	ID_SELECT,
	ID_TOGGLEON,
	ID_HELP,
	ID_HELP,
	ID_BLONGNAME,
};

void panel_initmenus(WORD flag, TOBJ *o)
{
	if (_ifsmgr == 0)
		o[OP_LONGNAME].flag |= _O_STATE;
	if (flag & _W_LONGNAME)
		o[OP_LONGNAME].flag |= _O_FLAGB;
	if (flag & _W_DETAIL)
		o[OP_DETAIL].flag |= _O_FLAGB;
	if (flag & _W_HIDDEN)
		o[OP_HIDDEN].flag |= _O_FLAGB;
	if (flag & _W_MINISTATUS)
		o[OP_MINISTATUS].flag |= _O_FLAGB;
	if (flag & _W_DRVINFO)
		o[OP_DRVINFO].flag |= _O_FLAGB;
	if (flag & _W_NOSORT) {
		o[OP_NOSORT].flag |= _O_RADIO;
	} else {
		switch (flag & _W_SORTFLAG) {
		case _W_SORTNAME: o[OP_NAME].flag |= _O_RADIO; break;
		case _W_SORTTYPE: o[OP_TYPE].flag |= _O_RADIO; break;
		case _W_SORTDATE: o[OP_DATE].flag |= _O_RADIO; break;
		case _W_SORTSIZE: o[OP_SIZE].flag |= _O_RADIO; break;
		}
	}
}

static int menus_idd = 0;
static int menus_obj = 0;
static int menus_modalidd(int idd)
{
	DOBJ 	*d,mu;
	WCHR 	mb[30];
	WCHR 	stl[80];
	int 	q,state;
	int	result;

	if (idd == ID_MTOOLS)
		return tools_modalidd(128, NULL, "Tools");
	mu.wp   = mb;
	mu.rc   = tobj_menusline[idd].rc;
	mu.flag = _D_COLOR|_D_MYBUF;
	wcpushst(stl, tobj_menusline[idd].data);
	if (idd == ID_MPANELA)
		ResourceMenus[0]->dialog.rc.x = 0;
	else if (idd == ID_MPANELB)
		ResourceMenus[0]->dialog.rc.x = 42;
	if (twopen(&mu, at_MenusKey & 0x0F, NULL))
		twshow(&mu);
	if ((d = rsopen(ResourceMenus[idd])) == NULL)
		return 0;
	for (q = 0; q < d->count; q++)
		d->object[q].data = menus[menus_oid[idd] + q].info;
	if (idd == ID_MPANELA)
		panel_initmenus(config.ide[0].flag, d->object);
	else if (idd == ID_MPANELB)
		panel_initmenus(config.ide[1].flag, d->object);
#ifdef _DOSBMP_
	d->object[0].flag |= _O_DHELP;
#endif
	tdinit(d);
	result = tdmodal(d);
	state  = (d->object[result - 1].flag & _O_STATE);
	twclose(&mu);
	wcpopst(stl);
	if (result > 0 && result <= d->count) {
		menus_idd = idd;
		menus_obj = result - 1;
		if (state == 0)
			menus[menus_oid[idd] + result - 1].proc();
	} else if (mousep()) {
		return MOUSECMD;
	}
	return result;
}

int menus_idle(void)
{
	int q;
	int event = 0;

	do {
		tupdate();
		if (mousep())
			break;
		/*if (shift->AltLeft) {
			event = MENUSCMD;
			while (shift->Alt) {
				if ((q = getkey()) != 0) {
					event = q;
					break;
				}
			}
			break;
		} else*/ if (shift->Ctrl) {
			return CTRL;
		}
	} while ((event = getkey()) == 0);
	return event;
}

static int menus_event(int menus, int key)
{
	int mx;
	int q,idd;
	int activ;
	int event;

	idd = menus;
	activ = 1;
	event = key;
	do {
		switch (event) {
		case MOUSECMD:
			activ = 0;
			event = 0;
			break;
		case MENUSCMD:
			event = menus_modalidd(idd);
			activ = 1;
			break;
		case RIGHT:
			if (activ) {
				if (idd + 1 <= ID_MPANELB)
					idd++;
				else
					idd = ID_MPANELA;
				event = menus_modalidd(idd);
				break;
			}
			return event;
		case LEFT:
			if (activ) {
				if (idd > ID_MPANELA)
					idd--;
				else
					idd = ID_MPANELB;
				event = menus_modalidd(idd);
				break;
			}
			return event;
		case ESC:
			if (activ)
				return 0;
			return event;
		default:
			if (activ) {
				while(mousep());
				return 0;
			} else if (event) {
				q = -1;
				switch (event) {
				case 0x1E00/*'A'*/: q = 0; break;
				case 0x2100/*'F'*/: q = 1; break;
				case 0x1200/*'E'*/: q = 2; break;
				case 0x1F00/*'S'*/: q = 3; break;
				case 0x1400/*'T'*/: q = 4; break;
				case 0x2300/*'H'*/: q = 5; break;
				case 0x3000/*'B'*/: q = 6; break;
				}
				if (q != -1) {
					idd = q;
					event = menus_modalidd(idd);
					activ = 1;
					break;
				}
				if (activ == 0)
					return event;
			}
			break;
		}
		if (activ == 0) {
			if ((event = menus_idle()) == CTRL)
				return CTRL;
		}
		if (event == 0 && mousey() == 0) {
			mx = mousex();
			idd = ID_MPANELB;
			if (mx < MENUSLINE_COL) {
				while (mx < tobj_menusline[idd].rc.x)
					idd--;
				event = tobj_menusline[idd].ascii << 8;
			} else {
				return MOUSECMD;
			}
		} else if (event == 0) {
			return MOUSECMD;
		}
	} while ( 1 );
}

int cmlastmenu(void)
{
	ResourceMenus[menus_idd]->dialog.ascii = menus_obj;
	return menus_event(menus_idd, menus_modalidd(menus_idd));
}

/**/

int menus_getevent(void)
{
	return menus_event(0, MOUSECMD);
}

#define	_RCEDIT_

/******** Resource begin PANELA *
	{ 0x2418,  15,   0, { 0, 1,38,20} },
	{ 0x0005,   0, 'L', { 2, 1,34, 1} },
	{ 0x0005,   0, 'T', { 2, 2,34, 1} },
	{ 0x0005,   0, 'H', { 2, 3,34, 1} },
	{ 0x0005,   0, 'M', { 2, 4,34, 1} },
	{ 0x0005,   0, 'V', { 2, 5,34, 1} },
	{ 0x0005,   0, 'N', { 2, 7,34, 1} },
	{ 0x0005,   0, 'E', { 2, 8,34, 1} },
	{ 0x0005,   0, 'D', { 2, 9,34, 1} },
	{ 0x0005,   0, 'Z', { 2,10,34, 1} },
	{ 0x0005,   0, 'U', { 2,11,34, 1} },
	{ 0x0005,   0, 'O', { 2,13,34, 1} },
	{ 0x0005,   0, 'P', { 2,14,34, 1} },
	{ 0x0005,   0, 'I', { 2,15,34, 1} },
	{ 0x0005,   0, 'R', { 2,17,34, 1} },
	{ 0x0005,   0, 'C', { 2,18,34, 1} },
********* Resource data  *******************/
static int PANELA_RC[] = {
#ifdef _RCEDIT_
	0x073C,0x2418,0x000F,0x0100,0x1426,0x0005,0x4C00,0x0102,
	0x0122,0x0005,0x5400,0x0202,0x0122,0x0005,0x4800,0x0302,
	0x0122,0x0005,0x4D00,0x0402,0x0122,0x0005,0x5600,0x0502,
	0x0122,0x0005,0x4E00,0x0702,0x0122,0x0005,0x4500,0x0802,
	0x0122,0x0005,0x4400,0x0902,0x0122,0x0005,0x5A00,0x0A02,
	0x0122,0x0005,0x5500,0x0B02,0x0122,0x0005,0x4F00,0x0D02,
	0x0122,0x0005,0x5000,0x0E02,0x0122,0x0005,0x4900,0x0F02,
	0x0122,0x0005,0x5200,0x1102,0x0122,0x0005,0x4300,0x1202,
	0x0122,
#endif
	0x29F0,0x3F3B,0x27F0,0x3F3B,0x23F0,0x3F3B,0x25F0,0x3F3B,
	0x25F0,0x3F3B,0x53F0,0x3F3B,0x28F0,0x3F3B,0x22F0,0x3F3B,
	0x27F0,0x3F3B,0x23F0,0x3F3B,0x44F0,0x3F3B,0x24F0,0x3F3B,
	0x2FF0,0x3F3B,0x41F0,0x3F3B,0x25F0,0x3F3B,0x48F0,0xDA3B,
	0x24F0,0xBFC4,0x20B3,0x4C20,0x6E6F,0x2067,0x6966,0x656C,
	0x616E,0x656D,0x0DF0,0x4320,0x7274,0x2D6C,0x204C,0xB320,
	0x20B3,0x4420,0x7465,0x6961,0xF06C,0x2014,0x7443,0x6C72,
	0x542D,0x2020,0xB3B3,0x2020,0x6948,0x6464,0x6E65,0x14F0,
	0x4320,0x7274,0x2D6C,0x2048,0xB320,0x20B3,0x4D20,0x6E69,
	0x2069,0x7473,0x7461,0x7375,0x0FF0,0x4320,0x7274,0x2D6C,
	0x204D,0xB320,0x20B3,0x5620,0x6C6F,0x6D75,0x2065,0x6E49,
	0x6F66,0x0FF0,0x4320,0x7274,0x2D6C,0x2056,0xB320,0x20B3,
	0x23F0,0xB3C4,0x20B3,0x5320,0x726F,0x2074,0x7962,0x4E20,
	0x6D61,0xF065,0x200E,0x7443,0x6C72,0x4E2D,0x2020,0xB3B3,
	0x0AF0,0x5420,0x7079,0xF065,0x200E,0x7443,0x6C72,0x452D,
	0x2020,0xB3B3,0x0AF0,0x4420,0x7461,0xF065,0x200E,0x7443,
	0x6C72,0x442D,0x2020,0xB3B3,0x0AF0,0x5320,0x7A69,0xF065,
	0x200E,0x7443,0x6C72,0x5A2D,0x2020,0xB3B3,0x0AF0,0x5520,
	0x736E,0x726F,0x6574,0xF064,0x200A,0x7443,0x6C72,0x552D,
	0x2020,0xB3B3,0x24F0,0xB3C4,0x20B3,0x5420,0x676F,0x6C67,
	0x2065,0x6170,0x656E,0xF06C,0x200B,0x7443,0x6C72,0x462D,
	0x2F31,0x2032,0xB320,0x20B3,0x5020,0x6E61,0x6C65,0x6620,
	0x6C69,0x6574,0xF072,0x2E03,0x13F0,0xB320,0x20B3,0x4420,
	0x7269,0x6365,0x6F74,0x7972,0x4920,0x666E,0x726F,0x616D,
	0x6974,0x6E6F,0x0DF0,0xB320,0xF0B3,0xC424,0xB3B3,0x2020,
	0x6552,0x722D,0x6165,0xF064,0x2013,0x7443,0x6C72,0x522D,
	0x2020,0xB3B3,0x2020,0x6843,0x6E61,0x6567,0x6420,0x6972,
	0x6576,0x03F0,0xF02E,0x2009,0x6C41,0x2D74,0x3146,0x322F,
	0x2020,0xC0B3,0x24F0,0xD9C4,0x3B3B,
}; //	588 byte
ROBJ *IDD_PANELA = (ROBJ *)&PANELA_RC;
/******** Resource end   PANELA */

/******** Resource begin FILE *
	{ 0x2418,  13,   0, {10, 1,31,18} },
	{ 0x0005,   0, 'R', { 2, 1,27, 1} },
	{ 0x0005,   0, 'V', { 2, 2,27, 1} },
	{ 0x0005,   0, 'E', { 2, 3,27, 1} },
	{ 0x0005,   0, 'Y', { 2, 4,27, 1} },
	{ 0x0005,   0, 'O', { 2, 5,27, 1} },
	{ 0x0005,   0, 'M', { 2, 6,27, 1} },
	{ 0x0005,   0, 'L', { 2, 7,27, 1} },
	{ 0x0005,   0, 'P', { 2, 8,27, 1} },
	{ 0x0005,   0, 'C', { 2,10,27, 1} },
	{ 0x0005,   0, 'D', { 2,11,27, 1} },
	{ 0x0005,   0, 'S', { 2,13,27, 1} },
	{ 0x0005,   0, 'H', { 2,14,27, 1} },
	{ 0x0005,   0, 'X', { 2,16,27, 1} },
********* Resource data  *******************/
static int FILE_RC[] = {
#ifdef _RCEDIT_
	0x057D,0x2418,0x000D,0x010A,0x121F,0x0005,0x5200,0x0102,
	0x011B,0x0005,0x5600,0x0202,0x011B,0x0005,0x4500,0x0302,
	0x011B,0x0005,0x5900,0x0402,0x011B,0x0005,0x4F00,0x0502,
	0x011B,0x0005,0x4D00,0x0602,0x011B,0x0005,0x4C00,0x0702,
	0x011B,0x0005,0x5000,0x0802,0x011B,0x0005,0x4300,0x0A02,
	0x011B,0x0005,0x4400,0x0B02,0x011B,0x0005,0x5300,0x0D02,
	0x011B,0x0005,0x4800,0x0E02,0x011B,0x0005,0x5800,0x1002,
	0x011B,
#endif
	0x22F0,0x3F3B,0x1EF0,0x3F3B,0x1EF0,0x3F3B,0x21F0,0x3F3B,
	0x1CF0,0x3F3B,0x1DF0,0x3F3B,0x20F0,0x3F3B,0x1CF0,0x3F3B,
	0x3DF0,0x3F3B,0x1EF0,0x3F3B,0x3DF0,0x3F3B,0x1EF0,0x3F3B,
	0x3EF0,0x3F3B,0x39F0,0xDA3B,0x1DF0,0xBFC4,0x20B3,0x5220,
	0x6E65,0x6D61,0xF065,0x2011,0x3246,0x2020,0xB3B3,0x2020,
	0x6956,0x7765,0x13F0,0x4620,0x2033,0xB320,0x20B3,0x4520,
	0x6964,0xF074,0x2013,0x3446,0x2020,0xB3B3,0x2020,0x6F43,
	0x7970,0x13F0,0x4620,0x2035,0xB320,0x20B3,0x4D20,0x766F,
	0xF065,0x2013,0x3646,0x2020,0xB3B3,0x2020,0x614D,0x656B,
	0x4420,0x7269,0x6365,0x6F74,0x7972,0x09F0,0x4620,0x2037,
	0xB320,0x20B3,0x4420,0x6C65,0x7465,0xF065,0x2011,0x3846,
	0x2020,0xB3B3,0x2020,0x7250,0x706F,0x7265,0x7974,0x0FF0,
	0x4620,0x2039,0xB320,0xF0B3,0xC41D,0xB3B3,0x2020,0x6F43,
	0x706D,0x6572,0x7373,0x0BF0,0x4120,0x746C,0x462D,0x2035,
	0xB320,0x20B3,0x4420,0x6365,0x6D6F,0x7270,0x7365,0xF073,
	0x2009,0x6C41,0x2D74,0x3646,0x2020,0xB3B3,0x1DF0,0xB3C4,
	0x20B3,0x5320,0x6165,0x6372,0xF068,0x200D,0x6C41,0x2D74,
	0x3746,0x2020,0xB3B3,0x2020,0x6948,0x7473,0x726F,0xF079,
	0x200C,0x6C41,0x2D74,0x3846,0x2020,0xB3B3,0x1DF0,0xB3C4,
	0x20B3,0x4520,0x6978,0xF074,0x2012,0x3146,0x2030,0xB320,
	0xF0C0,0xC41D,0x3BD9,
}; //	440 byte
ROBJ *IDD_FILE = (ROBJ *)&FILE_RC;
/******** Resource end   FILE */

/******** Resource begin EDIT *
	{ 0x2418,   4,   0, {17, 1,34, 7} },
	{ 0x0005,   0, 'S', { 2, 1,30, 1} },
	{ 0x0005,   0, 'D', { 2, 2,30, 1} },
	{ 0x0005,   0, 'I', { 2, 3,30, 1} },
	{ 0x0005,   0, 'C', { 2, 5,30, 1} },
********* Resource data  *******************/
static int EDIT_RC[] = {
#ifdef _RCEDIT_
	0x025A,0x2418,0x0004,0x0111,0x0722,0x0005,0x5300,0x0102,
	0x011E,0x0005,0x4400,0x0202,0x011E,0x0005,0x4900,0x0302,
	0x011E,0x0005,0x4300,0x0502,0x011E,
#endif
	0x25F0,0x3F3B,0x21F0,0x3F3B,0x21F0,0x3F3B,0x43F0,0x3F3B,
	0x40F0,0xDA3B,0x20F0,0xBFC4,0x20B3,0x5320,0x6C65,0x6365,
	0xF074,0x200E,0x654B,0x7079,0x6461,0x2B20,0x2020,0xB3B3,
	0x2020,0x6544,0x6573,0x656C,0x7463,0x0CF0,0x4B20,0x7965,
	0x6170,0x2064,0x202D,0xB320,0x20B3,0x4920,0x766E,0x7265,
	0xF074,0x200E,0x654B,0x7079,0x6461,0x2A20,0x2020,0xB3B3,
	0x20F0,0xB3C4,0x20B3,0x4320,0x6D6F,0x6170,0x6572,0x4420,
	0x7269,0x6365,0x6F74,0x6972,0x7365,0x03F0,0x4320,0x7274,
	0x2D6C,0x2043,0xB320,0xF0C0,0xC420,0x3BD9,
}; //	182 byte
ROBJ *IDD_EDIT = (ROBJ *)&EDIT_RC;
/******** Resource end   EDIT */

/******** Resource begin SETUP *
	{ 0x2418,   9,   0, {24, 1,36,14} },
	{ 0x0005,   0, 'O', { 2, 1,32, 1} },
	{ 0x0005,   0, 'H', { 2, 2,32, 1} },
	{ 0x0005,   0, 'Z', { 2, 3,32, 1} },
	{ 0x0005,   0, 'E', { 2, 4,32, 1} },
	{ 0x0005,   0, 'W', { 2, 6,32, 1} },
	{ 0x0005,   0, 'F', { 2, 8,32, 1} },
	{ 0x0005,   0, 'S', { 2, 9,32, 1} },
	{ 0x0005,   0, 'P', { 2,10,32, 1} },
	{ 0x0005,   0, 'C', { 2,12,32, 1} },
********* Resource data  *******************/
static int SETUP_RC[] = {
#ifdef _RCEDIT_
	0x04CE,0x2418,0x0009,0x0118,0x0E24,0x0005,0x4F00,0x0102,
	0x0120,0x0005,0x4800,0x0202,0x0120,0x0005,0x5A00,0x0302,
	0x0120,0x0005,0x4500,0x0402,0x0120,0x0005,0x5700,0x0602,
	0x0120,0x0005,0x4600,0x0802,0x0120,0x0005,0x5300,0x0902,
	0x0120,0x0005,0x5000,0x0A02,0x0120,0x0005,0x4300,0x0C02,
	0x0120,
#endif
	0x2EF0,0x3F3B,0x23F0,0x3F3B,0x25F0,0x3F3B,0x21F0,0x3F3B,
	0x41F0,0x3F3B,0x49F0,0x3F3B,0x20F0,0x3F3B,0x23F0,0x3F3B,
	0x47F0,0x3F3B,0x44F0,0xDA3B,0x22F0,0xBFC4,0x20B3,0x5420,
	0x676F,0x6C67,0x2065,0x6E4F,0x4F2F,0x6666,0x0BF0,0x4320,
	0x7274,0x2D6C,0x204F,0xB320,0xF0B3,0x2009,0x6F48,0x6972,
	0x6F7A,0x746E,0x6C61,0x0AF0,0x4620,0x3231,0x2020,0xB3B3,
	0x09F0,0x5320,0x7A69,0xF065,0x2010,0x3146,0x2031,0xB320,
	0xF0B3,0x2009,0x6745,0x6C61,0x6E69,0x7365,0x09F0,0x4120,
	0x746C,0x462D,0x2039,0xB320,0xF0B3,0xC422,0xB3B3,0x2020,
	0x7753,0x7061,0x5020,0x6E61,0x6C65,0xF073,0x200D,0x7443,
	0x6C72,0x572D,0x2020,0xB3B3,0x22F0,0xB3C4,0x20B3,0x4320,
	0x6E6F,0x6966,0x6D72,0x7461,0x6F69,0xF06E,0x2E03,0x09F0,
	0x4320,0x7274,0x2D6C,0x2046,0xB320,0x20B3,0x5320,0x7263,
	0x6565,0x206E,0x706F,0x6974,0x6E6F,0xF073,0x2E03,0x07F0,
	0x4320,0x7274,0x2D6C,0x2041,0xB320,0x20B3,0x5020,0x6E61,
	0x6C65,0x6F20,0x7470,0x6F69,0x736E,0x03F0,0xF02E,0x2008,
	0x7443,0x6C72,0x502D,0x2020,0xB3B3,0x22F0,0xB3C4,0x20B3,
	0x4320,0x6E6F,0x6966,0x7567,0x6172,0x6974,0x6E6F,0x03F0,
	0xF02E,0x2007,0x7443,0x6C72,0x462D,0x2039,0xB320,0xF0C0,
	0xC422,0x3BD9,
}; //	390 byte
ROBJ *IDD_SETUP = (ROBJ *)&SETUP_RC;
/******** Resource end   SETUP */

/******** Resource begin HELP *
	{ 0x2418,   2,   0, {40, 1,30, 5} },
	{ 0x0005,   0, 'H', { 2, 1,26, 1} },
	{ 0x0005,   0, 'A', { 2, 3,26, 1} },
********* Resource data  *******************/
static int HELP_RC[] = {
#ifdef _RCEDIT_
	0x0182,0x2418,0x0002,0x0128,0x051E,0x0005,0x4800,0x0102,
	0x011A,0x0005,0x4100,0x0302,0x011A,
#endif
	0x21F0,0x3F3B,0x3BF0,0x3F3B,0x38F0,0xDA3B,0x1CF0,0xBFC4,
	0x20B3,0x4820,0x6C65,0xF070,0x2E03,0x0FF0,0x4620,0x2031,
	0xB320,0x20B3,0x1AF0,0x20C4,0xB3B3,0x2020,0x6241,0x756F,
	0xF074,0x2E03,0x12F0,0xB320,0xF0C0,0xC41C,0x3BD9,
}; //	88 byte
ROBJ *IDD_HELP = (ROBJ *)&HELP_RC;
/******** Resource end   HELP */

ROBJ *ResourceMenus[] = {
	(ROBJ *)&PANELA_RC,
	(ROBJ *)&FILE_RC,
	(ROBJ *)&EDIT_RC,
	(ROBJ *)&SETUP_RC,
	NULL,
	(ROBJ *)&HELP_RC,
	(ROBJ *)&PANELA_RC
};
