/*
 * CMFBLOCK.C
 *
 *  This file is part of DOSZIP
 *  Copyright (c) 1996 Hjort Nidudsson.
 */
#include <io.h>
#include <time.h>
#include <string.h>
#include <stdlib.h>
#include <ifsmgr.h>
#include <dir.h>
#include <progress.h>
#include <dzmain.h>

#define STATE_IFS	0x0003FFFF
#define STATE_DOS	0x000333FF

enum {	ID_SETRDONLY,
	ID_CLRRDONLY,
	ID_SETARCH,
	ID_CLRARCH,
	ID_SETHIDDEN,
	ID_CLRHIDDEN,
	ID_SETSYSTEM,
	ID_CLRSYSTEM,
	ID_DOSUBDIR,
	ID_MASK,
	ID_DATECREATE,
	ID_TIMECREATE,
	ID_DATEWRITE,
	ID_TIMEWRITE,
	ID_DATEACCESS,
	ID_TIMEACCESS,
	ID_SET,
	ID_CANCEL,
	ID_MNUFRAME1,
	ID_MNUFRAME2,
	ID_MNUFRAME3,
	ID_STATICTEXT1,
	ID_STATICTEXT2,
	ID_STATICTEXT3,
	ITEMCOUNT	};

const char
	cp_property	[] = "&Property";
const char
	cp_ldatefrm	[] = "%02d.%02d.%d",
	cp_ltimefrm	[] = "%02d:%02d:%02d";
static char
	__spath		[WMAXPATH];
static wfblk
	ifsblock;
static unsigned char
	clr_attrib,
	set_attrib;
static int
	setnewdate,
	setnewattrib;
static unsigned
	time_access,
	time_create,
	time_modified,
	date_access,
	date_create,
	date_modified;

static int __setfdate(const char *, const char *);
static int __setfattr(const char *, char);
static int __dodirectory(const char *);
static int __dofiles(const char *, wfblk *);
static int __setdirectory(DOBJ *, const char *);
static int __setfile(char *, const char *, char);

int crename(const char *oldname, const char *newname)
{
	if (strcmp(oldname, newname)) {
		if (rename(oldname, newname) == 0)
			return 1;
	}
	return 0;
}

int cmblkprop(void)
{
	int 	q;
	int	flag_init;
	int	flag_exit;
	char *	p;
	FBLK *	b;
	DOBJ *	dp;
	BYTE	clear;

	if (!(b = cpanel_findfirst()))
		return 0;
	if (ISARCHIVE(b->flag)) {
		notsup();
		return 0;
	}
	if (fullpath(__spath, 0) == NULL)
		return 0;
	fp_maskp = cp_stdmask;
	fp_fileblock = __dofiles;
	fp_directory = __dodirectory;
	if ((dp = rsopen(IDD_PROPERTY)) == 0)
		return 0;
	p = dp->object[ID_MASK].data;
	if (_ifsmgr) {
		_ifsmgr = 0;
		if ((q = wfindfirst(b->name,  &ifsblock, b->flag & 0xFF)) != -1) {
			wcloseff(q);
			strcpy(p, ifsblock.name);
		} else {
			twclose(dp);
			return 0;
		}
		_ifsmgr = 1;
	} else {
		strcpy(p, b->name);
		ifsblock.attrib = (b->flag & _A_FATTRIB);
		ifsblock.date_modified = b->date;
		ifsblock.time_modified = b->time;
		ifsblock.time_create = 0;
		ifsblock.date_create = 0;
		ifsblock.time_access = 0;
		ifsblock.date_access = 0;
	}
	dwtolstr(dp->object[ID_DATEACCESS].data, ifsblock.date_access);
	dwtolstr(dp->object[ID_DATECREATE].data, ifsblock.date_create);
	twtostr(dp->object[ID_TIMEACCESS].data, ifsblock.time_access);
	twtostr(dp->object[ID_TIMECREATE].data, ifsblock.time_create);
	dwtolstr(dp->object[ID_DATEWRITE].data, ifsblock.date_modified);
	twtostr(dp->object[ID_TIMEWRITE].data, ifsblock.time_modified);
	if (ISSELECTED(b->flag)) {
		dp->object[ID_CLRRDONLY].flag |= _O_FLAGB;
		strcpy(p, cpanel->ide->mask);
	} else {
		if (ISRDONLY(ifsblock.attrib))
			dp->object[ID_SETRDONLY].flag |= _O_FLAGB;
		if (ISARCH(ifsblock.attrib))
			dp->object[ID_SETARCH].flag |= _O_FLAGB;
		if (ISHIDDEN(ifsblock.attrib))
			dp->object[ID_SETHIDDEN].flag |= _O_FLAGB;
		if (ISSYSTEM(ifsblock.attrib))
			dp->object[ID_SETSYSTEM].flag |= _O_FLAGB;
	}
	if (ISCDROOM(b->flag)) {
		for (q = 0; q < ID_CANCEL - 1; q++)
			dp->object[q].flag |= _O_STATE;
	}
	if (_ifsmgr == 0) {
		dp->object[ID_TIMEACCESS].flag |= _O_STATE;
		dp->object[ID_DATEACCESS].flag |= _O_STATE;
		dp->object[ID_TIMECREATE].flag |= _O_STATE;
		dp->object[ID_DATECREATE].flag |= _O_STATE;
	}
	flag_init = tdgetbitflag(dp->object, ID_DOSUBDIR + 1, _O_FLAGB);
	tdinit(dp);
	twshow(dp);
	if (tdevent(dp) == 0) {
		twclose(dp);
		return 0;
	}
	flag_exit = tdgetbitflag(dp->object, ID_DOSUBDIR + 1, _O_FLAGB);
	setnewattrib = (flag_exit ^ flag_init);
	set_attrib   = 0;
	clr_attrib   = ~_A_SUBDIR;
	if (dp->object[ID_SETRDONLY].flag & _O_FLAGB)
		set_attrib = _A_RDONLY;
	if (dp->object[ID_SETARCH].flag & _O_FLAGB)
		set_attrib |= _A_ARCH;
	if (dp->object[ID_SETHIDDEN].flag & _O_FLAGB)
		set_attrib |= _A_HIDDEN;
	if (dp->object[ID_SETSYSTEM].flag & _O_FLAGB)
		set_attrib |= _A_SYSTEM;
	if (set_attrib != 0)
		setnewattrib = 1;
	clear = clr_attrib;
	if (dp->object[ID_CLRRDONLY].flag & _O_FLAGB)
		clr_attrib &= ~_A_RDONLY;
	if (dp->object[ID_CLRARCH].flag & _O_FLAGB)
		clr_attrib &= ~_A_ARCH;
	if (dp->object[ID_CLRHIDDEN].flag & _O_FLAGB)
		clr_attrib &= ~_A_HIDDEN;
	if (dp->object[ID_CLRSYSTEM].flag & _O_FLAGB)
		clr_attrib &= ~_A_SYSTEM;
	if (clr_attrib != clear)
		setnewattrib = 1;
	time_access   = strtotw(dp->object[ID_TIMEACCESS].data);
	time_create   = strtotw(dp->object[ID_TIMECREATE].data);
	time_modified = strtotw(dp->object[ID_TIMEWRITE].data);
	date_access   = strtodw(dp->object[ID_DATEACCESS].data);
	date_create   = strtodw(dp->object[ID_DATECREATE].data);
	date_modified = strtodw(dp->object[ID_DATEWRITE].data);
	if (	time_access   == ifsblock.time_access 	&&
		date_access   == ifsblock.date_access)
		date_access    = time_access = 0;
	if (	time_create   == ifsblock.time_create	&&
		date_create   == ifsblock.date_create)
		date_create    = time_create = 0;
	if (	time_modified == ifsblock.time_modified	&&
		date_modified == ifsblock.date_modified)
		date_modified  = time_modified = 0;
	setnewdate =
		time_access   +
		time_create   +
		time_modified +
		date_access   +
		date_create   +
		date_modified;
	if (setnewdate == 0 && setnewattrib == 0) {
		if (ISSELECTED(b->flag) || ISSUBDIR(b->flag)) {
			twclose(dp);
			return 0; /* nothing to do.. */
		}
	}
	progress_open(cp_property, "");
	progress_set(NULL, cpanel->ide->path, 0);
	do {
		if (ISSUBDIR(b->flag)) {
			if (__setdirectory(dp, b->name))
				break;
		} else {
			if (ISSELECTED(b->flag) == 0)
				crename(b->name, dp->object[ID_MASK].data);
			p = wshortname(b->name);
			__setfdate(__spath, p);
			__setfattr(p, b->flag & _A_FATTRIB);
		}
		b->flag &= ~(_A_SELECTED);
		if (getesc())
			break;
	} while ((b = panel_ffselected(cpanel)) != NULL);
	progress_close();
	twclose(dp);
	if (panel_state(&panela))
		panel_update_fcb(&panela);
	if (panel_state(&panelb))
		panel_update_fcb(&panelb);

	return 0;
}

int __setfdate(const char *p, const char *fn)
{
	int handle;
	char fname[WMAXPATH];

	if (setnewdate == 0)
		return 0;
	if (fn != NULL)
		strfcat(fname, p, fn);
	else
		strcpy(fname, p);
	if (_ifsmgr) {
		if (date_modified)
			wsetwrdate(fname, date_modified, time_modified);
		if (date_access)
			wsetacdate(fname, date_access);
		if (date_create)
			wsetcrdate(fname, date_create, time_create);
		return 0;
	}
	if ((handle = osopen(fname, _A_NORMAL, M_RDONLY, A_OPEN)) != -1) {
		if (date_modified)
			setfdate(handle, date_modified, time_modified);
		close(handle);
		return 0;
	}
	return -1;
}

int __setfattr(const char *file, char attrib)
{
	char newattrib;

	if (setnewattrib == 0)
		return 0;
	newattrib = attrib;
	newattrib |= set_attrib;
	newattrib &= clr_attrib;
	if (newattrib == attrib)
		return 0;
	if (ISSUBDIR(attrib)) {
		if (setfattr(file, 0) == 0)
			return setfattr(file, newattrib & ~_A_SUBDIR);
		return -1;
	}
	return setfattr(file, newattrib);
}

int __setfile(char *p, const char *fn, char attrib)
{
	wfblk ff;

	ff.attrib = attrib;
	strcpy(ff.name, fn);
	return __dofiles(p, &ff);
}

int __dofiles(const char *p, wfblk *wf)
{
	char fname[WMAXPATH];

	if (getesc())
		return 1;
	progress_set(NULL, wf->name, 1);
	if (__setfdate(p, wf->name) == 0)
		return __setfattr(strfcat(fname, p, wf->name), wf->attrib);

	return -1;
}

int __dodirectory(const char *p)
{
	char attrib;

	progress_set(NULL, p, 0);
	delay(60);
	if (scan_files(p) == 0) {
		if ((attrib = getfattr(p)) != -1)
			__setfattr(p, attrib);
		return  __setfdate(p, NULL);
	}
	return -1;
}

int __setdirectory(DOBJ *dp, const char *name)
{
	char attrib;
	char fname[WMAXPATH];

	strfcat(fname, __spath, wshortname(name));
	if (dp->object[ID_DOSUBDIR].flag & _O_FLAGB)
		return scan_directory(0, fname);
	if ((attrib = getfattr(fname)) != -1)
		__setfattr(fname, attrib);
	return  __setfdate(fname, NULL);
}

/******** Resource begin PROPERTY *
	{ 0x4C1C,  18,  17, {18, 2,44,21} },
	{ 0x0002,   0,   0, { 5, 5, 3, 1} },
	{ 0x0002,   0, 'R', {10, 5, 3, 1} },
	{ 0x0002,   0,   0, { 5, 6, 3, 1} },
	{ 0x0002,   0, 'A', {10, 6, 3, 1} },
	{ 0x0002,   0,   0, { 5, 7, 3, 1} },
	{ 0x0002,   0, 'H', {10, 7, 3, 1} },
	{ 0x0002,   0,   0, { 5, 8, 3, 1} },
	{ 0x0002,   0, 'T', {10, 8, 3, 1} },
	{ 0x0002,   0, 'P', { 5,10, 3, 1} },
	{ 0x0004,  16, 'N', {10,12,30, 1} },
	{ 0x0004,   1, 'E', {19,15,10, 1} },
	{ 0x0004,   1,   0, {32,15, 8, 1} },
	{ 0x0004,   1, 'M', {19,16,10, 1} },
	{ 0x0004,   1,   0, {32,16, 8, 1} },
	{ 0x0004,   1, 'L', {19,17,10, 1} },
	{ 0x0004,   1,   0, {32,17, 8, 1} },
	{ 0x0000,   0, 'S', { 3,19, 7, 1} },
	{ 0x0A00,   0, 'C', {14,19,10, 1} },
********* Resource data  *******************/
static int PROPERTY_RC[] = {
	0x0A1C,0x4C1C,0x1112,0x0212,0x152C,0x0002,0x0000,0x0505,
	0x0103,0x0002,0x5200,0x050A,0x0103,0x0002,0x0000,0x0605,
	0x0103,0x0002,0x4100,0x060A,0x0103,0x0002,0x0000,0x0705,
	0x0103,0x0002,0x4800,0x070A,0x0103,0x0002,0x0000,0x0805,
	0x0103,0x0002,0x5400,0x080A,0x0103,0x0002,0x5000,0x0A05,
	0x0103,0x0004,0x4E10,0x0C0A,0x011E,0x0004,0x4501,0x0F13,
	0x010A,0x0004,0x0001,0x0F20,0x0108,0x0004,0x4D01,0x1013,
	0x010A,0x0004,0x0001,0x1020,0x0108,0x0004,0x4C01,0x1113,
	0x010A,0x0004,0x0001,0x1120,0x0108,0x0000,0x5300,0x1303,
	0x0107,0x0A00,0x4300,0x130E,0x010A,0x2CF0,0xF050,0x2ABE,
	0xF02E,0x2A2B,0xF02E,0x2A2B,0xF02E,0x2A2E,0xF02E,0x2A4F,
	0xF02E,0x2A53,0xF02E,0x2A04,0x1EF0,0xF007,0x2A63,0xF02E,
	0x2A0B,0x0AF0,0xF007,0x2A03,0x08F0,0xF007,0x2A09,0xF02E,
	0x2A0D,0x0AF0,0xF007,0x2A03,0x08F0,0xF007,0x2A09,0xF02E,
	0x2A0D,0x0AF0,0xF007,0x2A03,0x08F0,0xF008,0x2A33,0x5050,
	0xF05C,0x5004,0xF020,0x2A03,0x5050,0xF05C,0x5007,0xF020,
	0x2A17,0x07F0,0xF020,0x2A04,0x0AF0,0xF020,0x2A13,0x12F0,
	0x5020,0x6F72,0x6570,0x7472,0xF079,0x2014,0xF0DA,0xC426,
	0xF0BF,0x2004,0xF0B3,0x2006,0x6843,0x6E61,0x6567,0x6620,
	0x6C69,0x2065,0x7461,0x7274,0x6269,0x7475,0x7365,0x0AF0,
	0xB320,0x04F0,0xC320,0x26F0,0xB4C4,0x04F0,0xB320,0x2020,
	0x6553,0x2074,0x4320,0x656C,0x7261,0x1AF0,0xB320,0x04F0,
	0xB320,0x2020,0x205B,0x205D,0x5B20,0x5D20,0x5220,0x6165,
	0x2064,0x6E6F,0x796C,0x12F0,0xB320,0x04F0,0xB320,0x2020,
	0x205B,0x205D,0x5B20,0x5D20,0x4120,0x6372,0x6968,0x6576,
	0x14F0,0xB320,0x04F0,0xB320,0x2020,0x205B,0x205D,0x5B20,
	0x5D20,0x4820,0x6469,0x6564,0xF06E,0x2015,0xF0B3,0x2004,
	0x20B3,0x5B20,0x5D20,0x2020,0x205B,0x205D,0x7953,0x7473,
	0x6D65,0x15F0,0xB320,0x04F0,0xC320,0x26F0,0xB4C4,0x04F0,
	0xB320,0x2020,0x205B,0x205D,0x7250,0x636F,0x7365,0x2073,
	0x7573,0x6662,0x6C6F,0x6564,0x7372,0x0EF0,0xB320,0x04F0,
	0xC320,0x26F0,0xB4C4,0x04F0,0xB320,0x2020,0x614E,0x656D,
	0x20F0,0xB320,0x04F0,0xC320,0x26F0,0xB4C4,0x04F0,0xB320,
	0x10F0,0x6420,0x2E64,0x6D6D,0xF02E,0x7904,0x03F0,0x6820,
	0x3A68,0x6D6D,0x733A,0x2073,0xF0B3,0x2004,0x20B3,0x4320,
	0x6572,0x7461,0x6F69,0xF06E,0x201C,0xF0B3,0x2004,0x20B3,
	0x4D20,0x646F,0x6669,0x6369,0x7461,0x6F69,0xF06E,0x2018,
	0xF0B3,0x2004,0x20B3,0x4C20,0x7361,0x2074,0x6361,0x6563,
	0x7373,0x19F0,0xB320,0x04F0,0xC020,0x26F0,0xD9C4,0x07F0,
	0x5320,0x7465,0x2020,0xF0DC,0x2005,0x6143,0x636E,0x6C65,
	0x2020,0xF0DC,0x2017,0x07F0,0xF0DF,0x2004,0x0AF0,0xF0DF,
	0x2013,0x2A2A,
}; //	660 byte
ROBJ *IDD_PROPERTY = (ROBJ *)&PROPERTY_RC;
/******** Resource end   PROPERTY */
