/*
 * MKDZ.C
 *
 *  This file is part of DOSZIP
 *  Copyright (c) 1996 Hjort Nidudsson.
 */
#include <io.h>
#include <stdio.h>

typedef struct {
	WORD	signature;
	WORD	last512;
	WORD	total512;
	WORD	relocation_entries;
	WORD	header_size;
	WORD	minimum_memory;
	WORD	maximum_memory;
	WORD	initial_SS;
	WORD	initial_SP;
	WORD	checksum;
	DWORD	initial_CSIP;
	WORD	offset_relocation;
	WORD	overlay;
      }	EXES;

EXES exe;
BYTE rdbuf[2000];
WORD csize;
WORD *stack;
long signature = 0x564A4A00;

int exeread(char *q, EXES *p)
{
	int  h;
	BYTE *sp;

	if ((h = osopen(q, 0, M_RDONLY, A_OPEN)) == -1)
		return 0;
	osread(h, p, sizeof(EXES));
	lseek(h, 0x200, SEEK_SET);
	csize = osread(h, rdbuf, 2000);
	close(h);
	sp = &rdbuf[csize - 2];
	stack = (WORD *)sp;
	return 1;
}

int main(void)
{
	int h,ss;

	if (exeread("DZ.EXE", &exe) == 0) {
		perror("error open file ");
		return 1;
	}
	if ((h = osopen("DZ.EXE", 0, M_WRONLY, A_TRUNC)) == -1) {
		perror("error open file ");
		return 1;
	}
	csize -= 2;
	exe.header_size	= 2;
	exe.total512 = 2;
	exe.last512 = csize - 512;//0x0200;
	ss = (csize >> 4);
	if (csize & 15)
		ss++;
	exe.initial_SS = ss;//0x002A;
	exe.initial_SP = *stack;
	oswrite(h, &exe, sizeof(EXES));
	oswrite(h, &signature, 4);
	oswrite(h, rdbuf, csize);
	close(h);
	return 0;
}
