; TDEDIT.ASM--
; Copyright (c) 2007 Hjort Nidudsson
;
; Change history:
; 31 Nov 2008	- added Clipboard
; 16 Nov 2008	- added KEY_KPENTER
; 10 Nov 2008	- memset --> memzero
; 02 May 2007	- Created <-- tdedit.c

include		clib.inc
include		clip.inc
include		dos.inc
include		string.inc
include		dialog.inc
include		kbd.inc
include		alloc.inc

CTRLINS		=	9200h
CTRLDEL		=	9300h
CONTINUE	=	0	; continue edit
RETEVENT	=	1	; return current event (keystroke)
CMFAILED	=	2	; operation fail (end of line/buffer)

TINFO		STRUC
		ti_base		DD ?
		ti_rect		DD ?
		ti_bcol		DW ?
		ti_xpos		DW ?
		ti_wpos		DW ?
		ti_clst		DD ?
		ti_clen		DD ?
		ti_clat		DW ?
		ENDS

_DATA		SEGMENT

GLOBAL		tclrascii: BYTE
GLOBAL		tminascii: BYTE
GLOBAL		tmaxascii: BYTE

ti_proctab	DW	case_continue
		DW      case_esc
		DW      case_left
		DW      case_mouse
		DW      case_right
		DW      case_home
		DW      tinextword
		DW      tiprevword
		DW      titoend
		DW      tidelete
		DW      tibacksp
		DW      case_esc
		DW      case_esc
		DW      case_esc

ti_keytable	DW	CONTINUE
		DW      KEY_ESC
		DW      KEY_LEFT
		DW      MOUSECMD
		DW      KEY_RIGHT
		DW      KEY_HOME
		DW      CTRLRIGHT
		DW      CTRLLEFT
		DW      KEY_END
		DW      KEY_DEL
		DW      KEY_BKSP
		DW      KEY_TAB
		DW      KEY_ENTER
		DW      KEY_KPENTER

key_count	=	(($ - ti_keytable) / 2)

_DATA		ENDS

_TEXT		SEGMENT

INITRECT:	xor	ax,ax		; expand rect to WORD size
		mov	al,rect.rc_x
		mov	rcx,ax
		mov	al,rect.rc_y
		mov	rcy,ax
		mov	al,rect.rc_col
		mov	rccol,ax
		ret

INITOFFSET:	xor	ax,ax		; to start of buffer --> Ctrl-PGUP
		mov	xpos,ax
		mov	wpos,ax
		ret

INITCLIPBOARD:	push	rcx		; get attrib of text to select
		push	rcy
		call	getxya
		mov	clat,ax         ; save text color
		mov	eax,base
		mov	clst,eax	; start = end = base
		mov	clen,eax
		call	ClipboardInit	; init WINOLDAP functions
		ret

INITCURSOR:	push	ss
		lea	ax,cursor
		push	ax
		call	getcursor
		ret

INITLOCAL:	call	INITRECT
		call	INITOFFSET
		call	INITCLIPBOARD
		call	INITCURSOR
		push	rcx
		push	rcy
		call	gotoxy
		call	cursoron
		ret

		;------------------------------------------------------------
		; end of line/buffer
		;
nocando:	push	9
		push	1
		call	beep
		mov	ax,CMFAILED
		ret

		;------------------------------------------------------------

clinep:		les	bx,base	; current line offset (in buffer)
		mov	dx,es
		mov	ax,bx
		ret

cwlinep:	call	clinep	; current line offset (on screen)
		add	ax,wpos
		mov	bx,ax	; base.wpos
		ret

curpos:		call	cwlinep	; current char offset (on screen)
		add	ax,xpos
		mov	bx,ax	; base.wpos.xpos
		ret

		;------------------------------------------------------------

tiseto:		call	clinep
		push	dx
		push	ax
		add	bx,bcol
		dec	bx
		xor	ax,ax
		mov	es:[bx],al	; terminate line
		call	strlen
		mov	bcount,ax	; byte count in line
		mov	dx,wpos		; test if char is visible
		add	dx,xpos
		cmp	dx,ax
		jb	SHORT @@null
		call	titoend         ; if not --> to end of line
		mov	ax,1
		ret
@@null:		xor	ax,ax
		ret

		;------------------------------------------------------------
		; print out a text line to screen
		;
print_line:     push	ds
		push	si
		push	cx
		push	bx
		call	__mshide
		mov	ax,rcy
		mov	dx,rcx
		call	__xytoesbx
		pop	si
		pop	ds
		mov	cx,rccol
@@lodsb:        mov	al,[si]
		inc	si
		or	al,al
		jz	SHORT @@toend
@@stosb:        mov	es:[bx],al
		add	bx,2
@@loop:         dec	cx
		jnz	SHORT @@lodsb
@@toend:	call	__msshow
		pop	si
		pop	ds
		ret

tiputl:		push	es
		push	bx
		mov	WORD PTR clq,bx
		mov     WORD PTR clq+2,es
		mov	eax,clen
		sub	eax,clst
		jz	SHORT @@puts
		push	si
		xor	si,si
@@loop:		cmp	si,rccol
		jnb	SHORT @@popsi
		mov	eax,clq
		cmp	eax,clst
		jb      SHORT @@next
		cmp	eax,clen
		jae	SHORT @@popsi
		mov	ax,rcx
		add	ax,si
		push	ax
		push	rcy
		push	1
		mov	al,at_background[B_DarkGray]
		push	ax
		call	scputa
@@next:		inc	si
		inc	clq
		jmp	SHORT @@loop
@@popsi:	pop	si
@@puts:         pop	bx
		pop	cx
		call	print_line
		ret

		;------------------------------------------------------------

tiputs:		push	rcx
		push	rcy
		push	rccol
		mov	ax,clat		; clear line
		mov	ah,al
		mov	al,tclrascii
		push	ax
		call	scputw
		mov	ax,rcx
		add	ax,xpos
		push	ax
		push	rcy
		call	gotoxy
		les	bx,base
		push	bx
		push	es
		push	bx
		call	strlen
		pop	bx
		cmp	ax,wpos
		jbe	SHORT @@select
		add	bx,wpos
		call	tiputl
		xor	ax,ax
@@toend:	ret
@@select:	mov	eax,clen
		cmp	eax,clst
		je	SHORT @@toend
		add	bx,wpos
		cmp	bx,WORD PTR clst
		jb	SHORT @@toend
		cmp	bx,WORD PTR clen
		jae	SHORT @@toend
		push	rcx
		push	rcy
		push	rccol
		mov	al,at_background[B_DarkGray]
		push	ax
		call	scputa
		ret

		;------------------------------------------------------------

titoend:	mov	ax,bcount
		mov	xpos,ax
		mov	dx,rccol
		dec	dx
		cmp	ax,dx
		jb	SHORT @@1
		mov	xpos,dx
@@1:		sub	ax,rccol
		inc	ax
		mov	wpos,ax
		cmp	ax,0
		jg	SHORT @@2
		mov	wpos,0
@@2:            mov	ax,bcol
		dec	ax
		cmp	ax,bcount
		jne	SHORT @@toend
		dec	wpos
@@toend:	mov	ax,CONTINUE
		ret

		;------------------------------------------------------------

tiputc:		cmp	al,tminascii	; add a character to line
		jb	SHORT @@exit
		cmp	al,tmaxascii
		ja	SHORT @@exit
		inc	bcount
		mov	dx,bcol
		cmp     dx,bcount
		jbe	SHORT @@beep	; end of line

		push	ax		; save character
		call	curpos
		push	dx              ; seg string
		inc	ax		; memcpy(s+1, s, len)
		push	ax              ; s+1
		push	dx
		dec	ax
		push	ax		; s
		mov	ax,bcol		; length of line
		sub	ax,wpos         ; - window offset
		sub	ax,xpos         ; - cursor offset
		dec	ax              ; - 1
		push	ax
		call	memmove         ; must use memmove
		mov	es,dx
		dec	ax
		mov	bx,ax
		pop	ax
		mov	es:[bx],al

		inc	xpos
		mov	ax,rccol
		cmp	ax,xpos
		ja	SHORT @@toend
		dec	ax
		mov	xpos,ax
		mov	ax,wpos
		add	ax,xpos
		cmp	ax,bcount
		jae	SHORT @@toend
		inc	wpos
		jmp	SHORT @@toend
@@exit:		mov	ax,RETEVENT
		ret
@@toend:	mov	ax,CONTINUE
		ret
@@beep:		mov	ax,bcol
		dec	ax
		mov	bcount,ax
		call	nocando
		ret

		;------------------------------------------------------------

tinextword:	call	clinep
		add	bx,wpos
		add	bx,xpos
		xor	ax,ax
		cmp	al,es:[bx]
		jz	SHORT @@toend
		mov	ax,wpos
		add	ax,xpos
		cmp	ax,bcount
		jnb	SHORT @@toend
		cmp	BYTE PTR es:[bx+1],0
		jz	SHORT @@toend
		push	bx
		inc	bx
		push	es
		push	bx
		push	' '
		call	strchr
		pop	bx
		or	ax,ax
		jz	SHORT @@titoend
		mov	es,dx
		xchg	ax,bx
@@1:		cmp     BYTE PTR es:[bx],' '
		jne	SHORT @@2
		inc	bx
		jmp	SHORT @@1
@@2:		sub	bx,ax
		jmp	SHORT @@4
@@3:            dec	bx
		mov	ax,rccol
		dec	ax
		cmp	ax,xpos
		jbe	SHORT @@5
		inc	xpos
		jmp	SHORT @@4
@@5:		inc	wpos
@@4:		or	bx,bx
		jnz	SHORT @@3
		jmp	SHORT @@toend
@@titoend:	call	titoend
		ret
@@toend:	mov	ax,CONTINUE
		ret

		;------------------------------------------------------------

dec_offset:	cmp	cx,xpos
		je	SHORT @@b
		dec	xpos
@@toend:	ret
@@b:            cmp	cx,wpos
		je	SHORT @@toend
		dec	wpos
		ret

		;------------------------------------------------------------

tiprevword:	mov	ax,wpos
		add	ax,xpos
		or	ax,ax
		jz	SHORT ticontinue
		call	clinep
		add	bx,wpos
		add	bx,xpos
		dec	bx
		mov	dl,' '
		xor	cx,cx
@@2:		cmp	es:[bx],dl
		ja	SHORT @@1
		call	dec_offset
		dec	bx
		jmp	SHORT @@2
@@1:		cmp	bx,ax
		jna	SHORT @@break
		call	dec_offset
		dec	bx
		cmp	es:[bx],dl
		ja	SHORT @@1
@@break:	cmp	ax,bx
		jne	SHORT ticontinue
		xor	ax,ax
		mov     wpos,ax
		mov     xpos,ax

		;------------------------------------------------------------

ticontinue:	mov	ax,CONTINUE
		ret

		;------------------------------------------------------------

tidelete:	call	clinep
		add	bx,wpos
		add	bx,xpos
		cmp	BYTE PTR es:[bx],0
		jz	SHORT ticontinue
		dec	bcount		; delete char on current position
		push	dx
		push	bx
		push	dx
		inc	bx
		push	bx
		call	strcpy		; strcpy(s, s+1)
		jmp	SHORT ticontinue

		;------------------------------------------------------------

tibacksp:       xor	cx,cx
		mov	ax,wpos
		add	ax,xpos
		or	ax,ax
		jz	SHORT @@nocando
		call	dec_offset
		dec	bcount
		call	clinep
		add	ax,xpos
		add	ax,wpos
		push	dx
		push	ax
		push	dx
		inc	ax
		push	ax
		call	strcpy
		mov	ax,CONTINUE
		ret
@@nocando:      call	nocando
		ret

		;------------------------------------------------------------

ti_exit:	mov	ax,RETEVENT
		ret

		;------------------------------------------------------------

case_mouse:	call	mousey
		cmp	ax,rcy
		jne	SHORT ti_exit
		call	mousex
		mov	dx,rcx
		cmp	ax,dx
		jb	SHORT ti_exit
		add	dx,rccol
		cmp	ax,dx
		jae	SHORT ti_exit
		sub	ax,rcx
		mov	xpos,ax
		call	clinep
		add	ax,wpos
		push	dx
		push	ax
		call	strlen
		cmp	ax,xpos
		jae	SHORT @@a
		mov	xpos,ax
@@a:		mov	ax,rcx
		add	ax,xpos
		push	ax
		push	rcy
		call	gotoxy
@@mouse:	call	mousep
		or	ax,ax
		jnz	SHORT @@mouse
		jmp	SHORT case_continue

		;------------------------------------------------------------

case_esc:	mov	ax,RETEVENT
		ret

		;------------------------------------------------------------

case_left:	xor	cx,cx
		call	dec_offset


		;------------------------------------------------------------

case_continue:	xor	ax,ax
		;mov	ax,CONTINUE
		ret

		;------------------------------------------------------------

case_right:	call	clinep
		add	bx,wpos
		add	bx,xpos
		mov	al,es:[bx]
		sub	bx,xpos
		or	al,al
		jz	SHORT @@elif
		mov	ax,rccol
		dec	ax
		cmp	ax,xpos
		jbe	SHORT @@elif
		inc	xpos
		jmp	SHORT case_continue
@@elif:         push	es
		push	bx
		call	strlen
		cmp	ax,rccol
		jb 	SHORT @@else
		inc	wpos
		jmp	SHORT case_continue
@@else:         call	nocando
		ret

		;------------------------------------------------------------

case_home:	xor	ax,ax
		mov	xpos,ax
		mov	wpos,ax
		ret

;----------------------------------------------------------------------------

tihandle_event:	mov	cx,key_count
		xor	bx,bx
@@keyloop:	cmp	ax,[bx.ti_keytable]
		jz	SHORT @@exe
		add	bx,2
		dec	cx
		jnz	SHORT @@keyloop
		call	tiputc
		ret
@@exe:		jmp	[bx.ti_proctab]

;----------------------------------------------------------------------------

tiedit:		push	si
		push	di
		mov	si,CONTINUE
@@loop:         call	tiseto
		call	tiputs
		cmp	si,RETEVENT
		je	SHORT @@break
		call	tgetevent
		call	ClipboardEvent
		mov	di,ax
		call	tihandle_event
		mov	si,ax
		jmp	SHORT @@loop
@@break:        call	clinep
		push	dx
		push	ax
		call	strlen
		mov	bcount,ax
		mov	ax,di
		pop	di
		pop	si
		ret

;----------------------------------------------------------------------------

clip_init:      mov	eax,base	; set clipboard to start
		call	curpos		; set clipboard to current position
		mov	clst,eax
		mov	clen,eax
		ret

;----------------------------------------------------------------------------

ClipboardDelete:
		mov	eax,clen
		sub	eax,clst
		jz	SHORT @@toend
		push	clst
		push	clen
		call	strcpy
		call	clip_init
		call	tiseto
		xor	ax,ax
		inc	ax
@@toend:	ret

;----------------------------------------------------------------------------

ClipboardCut:	push	ax
		mov	eax,clen
		sub	eax,clst
		jle	SHORT @@toend
		push	clst
		push	ax
		call	ClipboardOpen
		call	ClipboardEmpty
		call	ClipboardCopy
		call	ClipboardClose
		pop	ax
		or	ax,ax
		jz	SHORT @@toend
		call	ClipboardDelete
@@toend:	call	clip_init
		xor	ax,ax
		ret

;----------------------------------------------------------------------------

ClipboardGet:	push	xpos			; Save current posision
		push	wpos
		call	ClipboardDelete		; Clear selection if any
		call	ClipboardOpen   	; Open Clipboard
		call	ClipboardSize		; Get size of data
		or	ax,ax
		jz	SHORT @@toend
		cmp	ax,MAXCLIPSIZE
		ja	SHORT @@toend
		mov	clz,ax			; Get pointer to data
		call	ClipboardPaste
		jz      SHORT @@toend
		mov	clq,eax
		call	ClipboardClose		; Close clipboard
@@memcpy:	les	bx,clq
		mov	al,es:[bx]
		or	al,al
		jz      SHORT @@toend
		inc	WORD PTR clq
		call	tiputc
		or	ax,ax
		jnz     SHORT @@toend
		dec	clz
		jnz	SHORT @@memcpy
@@toend:        pop	wpos            ; Restore cursor position
		pop	xpos
		xor	ax,ax
		ret

;----------------------------------------------------------------------------

ClipboardEvent:	push	si
		mov	si,ax
		mov	eax,clst
		cmp	eax,clen
		jne	SHORT @@test_key
		call	clip_init
@@test_key:	cmp	si,CTRLINS
		je	SHORT @@case_ctrlins
		cmp	si,CTRLDEL
		je	SHORT @@case_ctrldel
		les	bx,shift
		mov	ax,es:[bx]
		and	ax,(SHIFT_RIGHT	or SHIFT_LEFT)
		jnz	SHORT @@shift
		cmp	si,KEY_DEL
		jne	SHORT @@out_event
		call	ClipboardDelete
		jz	SHORT @@out_event
		xor	ax,ax
		jmp	SHORT @@toend
@@shift:	cmp	si,KEY_INS
		je	SHORT @@case_ins
		cmp	si,KEY_DEL
		je	SHORT @@case_ctrldel
		cmp	si,KEY_HOME
		je	SHORT @@update
		cmp	si,KEY_LEFT
		je	SHORT @@update
		cmp	si,KEY_RIGHT
		je	SHORT @@update
		cmp	si,KEY_END
		je	SHORT @@update
@@out_event:	call	clip_init
		mov	ax,si
@@toend:        pop	si
		ret
@@case_ins:	call	ClipboardGet
		jmp	SHORT @@toend
@@case_ctrlins:	xor	ax,ax
		jmp	SHORT @@cut
@@case_ctrldel:	mov	ax,1
@@cut:		call	ClipboardCut
		jmp	SHORT @@toend
@@update:  	mov	ax,si
		call	tihandle_event
		or	ax,ax
		jnz	SHORT @@out_continue
		call	curpos
		cmp	ax,WORD PTR clst
		jb	SHORT @@clst
		cmp	si,KEY_RIGHT
		jne	SHORT @@clen
		mov	dx,ax
		dec	dx
		cmp	dx,WORD PTR clst
		jne	SHORT @@clen
		cmp	dx,WORD PTR clen
		jne	SHORT @@clst
@@clen:		mov	WORD PTR clen,ax
		jmp	SHORT @@out_continue
@@clst:		mov	WORD PTR clst,ax
@@out_continue:	xor	ax,ax
		jmp	SHORT @@toend

_TEXT		ENDS

;************** int tihndlevent(TINFO *, int __event);

TI_GETEVENT	=	0

PPROC		tihndlevent
ARG		@@ti:	DWORD,\
		@@cmd:	WORD

LOCAL		base:	DWORD,\
		rect:	DWORD,\
		bcol:	WORD,\
		xpos:	WORD,\
		wpos:	WORD,\
		clst:	DWORD,\
		clen:	DWORD,\
		clat:	WORD,\
		clq:	DWORD,\
		clz:	WORD,\
		rcx:	WORD,\
		rcy:	WORD,\
		rccol:	WORD,\
		bcount:	WORD,\
		cursor:	DWORD
		push	ss
		lea	ax,base
		push	ax
		push	@@ti
		push	SIZE TINFO
		call	memcpy
		call	INITRECT
		xor	ax,ax
		cmp	clat,ax
		jnz	SHORT @@print
		call	INITOFFSET
		call	INITCLIPBOARD
@@print:	call	tiseto
		call	tiputs
		mov	ax,@@cmd
		or	ax,ax
		jnz	SHORT @@event
		call	tgetevent
		mov	@@cmd,ax
@@event:	call	ClipboardEvent
		call	tihandle_event
		push	ax
		call	tiseto
		call	tiputs
		push	@@ti
		push	ss
		lea	ax,base
		push	ax
		push	SIZE TINFO
		call	memcpy
		pop	dx
		xor	ax,ax
		cmp	dx,RETEVENT
		jne	SHORT @@toend
		mov	ax,@@cmd
@@toend:	ret
PEND		tihndlevent

;************** int tdedit(char *base, RECT, int bsize);

PPROC		tdedit
ARG		@@base:	DWORD,\
		@@rect:	DWORD,\
		@@bsize:WORD

LOCAL		base:	DWORD,\
		rect:	DWORD,\
		bcol:	WORD,\
		xpos:	WORD,\
		wpos:	WORD,\
		clst:	DWORD,\
		clen:	DWORD,\
		clat:	WORD,\
		clq:	DWORD,\
		clz:	WORD,\
		rcx:	WORD,\
		rcy:	WORD,\
		rccol:	WORD,\
		bcount:	WORD,\
		cursor:	DWORD
		mov	eax,@@base
		mov	base,eax
		mov	eax,@@rect
		mov	rect,eax
		mov	ax,@@bsize
		mov	bcol,ax
		call	INITLOCAL
		call	tiseto
		call	tiedit
		push	ax
		call	tiputs
		push	cursor
		call	setcursor
		pop	ax
@@toend:	ret
PEND		tdedit

		END
