/* DZMAIN.H--
 * Copyright (c) 1999 Hjort Nidudsson
 *
 * Change history:
 * 25 Des 1999	- Created
 */

#ifndef __INC_DZMAIN
#define __INC_DZMAIN

#include <dir.h>
#include <wsub.h>
#include <stdio.h>
#include <xcell.h>
#include <dialog.h>

//#define _DOSBMP_
#include <dzfblk.h>
#include <dzpanel.h>
#include <dzconfig.h>
#include <dzmenu.h>

#define READMEFILE	"README.TXT"

#define COM_VISIBLE	0x0001

typedef struct {
	char	base[WMAXPATH];
	TINFO	ti;
	WSUB *	sub;
      }	CMDL;

typedef struct {
	char	name[80];
	char	argc;
	char	argv;
	char	cmdl[126];
      } EXEC;

extern const char cp_ldatefrm	[];
extern const char cp_ltimefrm	[];
extern const char cp_stdmask	[];
extern const char cp_userabort	[];
extern const char cp_recursive	[];
extern const char cp_needpanel	[];
extern const char cp_filter	[]; /* Filter */
extern const char cp_directory	[]; /* Directory */

extern char *comspec;
extern char *envconf;
extern char *envtemp;

extern char configfile[MAXPATH];
extern char programpath[MAXPATH];

extern CMDL com;
extern EXEC *dzexe;
extern FILT *filter;

extern int dzerrno;
extern int dzerflag;
extern int dzcount;

extern int _end;
extern int dzexitcode;

int tview(const char *, long);

int ex_command(const char *__command);
char *ex_convert(char *__command);
void ex_addmacro(char *__cmd, const char *__mac,
	const char *__file, int __maclen);

int com_setdevice(WSUB *__sub);
int com_hndevent(int);
void com_egaline(void);
void com_initline(void);

int doskey_save(void);
void doskey_delete(void);
int cmdoskey_up(void);
int cmdoskey_dn(void);

int cmfilter(void);
int load_iniproc(const char *__sec, const char *__file, int __type);
int FindFile(const char *__path);
void set_confirmflag(void);
DWORD mkbstring(char *, DWORD, DWORD);
int tools_modalidd(int, char *, const char *);

#endif