;
; TVIEW.ASM
;
; This file is part of DOSZIP
; Copyright (c) 1996 Hjort Nidudsson.
;

INCLUDE		clib.inc
INCLUDE		ios.inc
INCLUDE		io.inc
INCLUDE		dos.inc
INCLUDE		alloc.inc
INCLUDE		string.inc
INCLUDE		stdio.inc
INCLUDE		dialog.inc
INCLUDE		kbd.inc

MAXROW		= 48
MEMPAGE		= EMMPAGE;1024
HEXPAGE		= (MAXROW * 16)
TXTPAGE		= (MAXROW * 80)
ALLOCSIZE	= (MEMPAGE + 12 + (MAXROW * 80) + 16)

TV_HEXVIEW	= 01h
TV_WRAPLINES	= 02h
TV_SEARCHCASE	= 04h
TV_SEARCHSCOPE	= 08h
TV_HIGHCOLOR	= 10h
TV_HEXOFFSET	= 20h
TV_BINVIEW	= 40h

GLOBAL 	PASCAL	IDD_TVHelp:	DWORD
GLOBAL 	PASCAL	IDD_TVMsgw:	DWORD
GLOBAL 	PASCAL	IDD_TVSearch: 	DWORD
GLOBAL 	PASCAL	searchstring[128]: BYTE
GLOBAL 	PASCAL	tview:		DIST

GLOBAL 	PASCAL	qwtobstr: 	DIST
GLOBAL 	PASCAL	config:		WORD

IFDEF TVEXE
GLOBAL 	PASCAL	main: 		DIST
GLOBAL 	PASCAL	readword: 	DIST
	EXTRN	__setargv__: 	ABS
	cflag	= [config]	; TVIEW.CFG
ELSE
	cflag	= [config+6]	; DZ.CFG
ENDIF

		locals

_DATA		SEGMENT

IFDEF TVEXE

copyright	DB	'TVIEW 1.02 Copyright 1996 Hjort Nidudsson',13,10
sizecopyright	=	$ - copyright

cp_usage	DB	13,10
		DB	'Usage: TVIEW <filename> [/O<offset>]',13,10
sizeusage	=	$ - cp_usage

FileNotFound	DB 	'File not found: '
size_FileNotFound =  	$ - FileNotFound

cp_notfoundmsg	DB	"Search string not found: '%s'",0

config		DW	TV_WRAPLINES
cp_ext		DB	'CFG',0

		PUBLIC	cp_search
		PUBLIC	cp_notfoundmsg
ENDIF

;
; General hot keys
;

key_global	DW	KEY_F1		; cm_help
		DW	KEY_F2		; cm_wrap
		DW	KEY_F3		; cm_search
		DW	KEY_F4		; cm_hex
		DW	KEY_F5          ; cm_color
		DW	KEY_F6		; cm_offs
		DW	KEY_F7		; cm_search
		DW	KEY_F8		; cm_binary
		DW	KEY_F10		; cm_quit
		DW	KEY_ESC         ; cm_quit
		DW	ALTX	 	; cm_quit

key_glcount	=	(($ - key_global) / 2)

key_local	DW	KEY_UP          ; event_up
		DW	KEY_DOWN        ; event_down
		DW	KEY_PGUP        ; event_pgup
		DW	KEY_PGDN        ; event_pgdn
		DW	KEY_LEFT        ; event_left
		DW	KEY_RIGHT       ; event_right
		DW	KEY_HOME        ; event_home
		DW	KEY_END         ; event_end

		DW	CTRLL		; continue_search
		DW	CTRLE       	; event_up
		DW	CTRLX       	; event_down
		DW	CTRLR		; event_pgup
		DW	CTRLC		; event_pgdn
		DW	CTRLUP		; event_pgup
		DW	CTRLDN     	; event_pgdn
		DW	CTRLLEFT	; event_pgleft
		DW	CTRLRIGHT	; event_pgright

		DW	SHIFTF3		; continue_search

key_count	=	(($ - key_global) / 2)


key_proc	DW	cm_help
		DW	cm_wrap
		DW	cm_search
		DW	cm_hex
		DW	cm_color
		DW	cm_offs
		DW	cm_search
		DW	cm_binary
		DW	cm_quit
		DW	cm_quit
		DW	cm_quit

		DW	event_up
		DW	event_down
		DW	event_pgup
		DW	event_pgdn
		DW	event_left
		DW	event_right
		DW	event_home
		DW	event_end

		DW	continue_search
		DW	event_up
		DW	event_down
		DW	event_pgup
		DW	event_pgdn
		DW	event_pgup
		DW	event_pgdn
		DW	event_pgleft
		DW	event_pgright

		DW	continue_search

cp_search	DB	'Search',0
cp_searchmsg	DB	'Search string not found:'
cp_msgst        DB	" '%s'", 0

cp_hex		DB	'Hex  '
cp_ascii	DB	'Ascii'
cp_wrap		DB	'Wrap  '
cp_unwrap	DB	'Unwrap'
cp_hexmode	DB	'Hex'
cp_binary	DB	'Bin'

cp_byte		DB	'byte',0
form_8ld	DB	'%-8ld',0
form_3d		DB	'%3d',0
form_10u	DB	'%010lu',0

searchstring	DB	128 dup(0)

resource	DW	4016
		DW	4410h	; rs_flag
		DW	0	; rs_index
		DW	0	; rs_xy
		DB	80	; rs_rccol
rs_rcrow	DB	25
		DB	0F0h	; code 'F'
		DB	050h    ; byte count (80)
		DB	070h    ; attrib
rs_atcnt	DW	30F7h	; 730h (1840/80=23)
		DB	017h    ; attrib window
		DW	03F0h,0F07Fh,7007h,7F7Fh,09F0h,7F70h,0F07Fh,7009h
		DW	7F7Fh,08F0h,7F70h,0F07Fh, 7008h, 02F0h, 0F07Fh
		DB	9
		DB	70h
		DB	0F0h
		DB	2
		DB	7Fh
		DB	0F0h
		DB	6
		DW	0F070h
		DB	3
		DW	0F07Fh
		DB      6
		DB      70h
		DB	' Text View:',240,50,' col',240,11,' 100%'
rs_chcnt	DW	32F7h	; 732h (730+2)
		DB	' F1 Help  F2',240,9,' F3 Search  F4'
		DB	240,8,' F5 Color  F6 Offset  F8 Bin  Esc Quit '

_DATA		ENDS

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

LF 		= 10
CR 		= 13

_TEXT		SEGMENT

readltab:       call	iospush
		mov	lcount,1
		mov	edx,edi		; edi = current filepos
		mov	ltab,edx
		call	iosseek
		jz	SHORT @@END
		mov	edi,eax
		mov	ax,MEMPAGE
		cld
		call	iosread
		jz	SHORT @@END
		test	xflag,TV_HEXVIEW
		jnz	SHORT @@hex
@@loop:		call	ioscrlf
@@test:		jz	SHORT @@eof
		jc	SHORT @@add
		jmp	SHORT @@loop
@@eof:		call	addedi
		call	addedi
		dec	lcount
@@dec:		dec	lcount
@@END:		ret
@@add:		call	ioscrlf
		jz	SHORT @@eof
		jc	SHORT @@inc
		inc	cx    		; ungetc
		dec	edi
		dec	si
@@inc:		call	addedi
		mov	ax,lcount
		cmp	ax,rowcnt
		ja	SHORT @@dec
		jmp	SHORT @@loop
@@hex:          xor	dx,dx
@@xlp:          add	edi,8
		test	xflag,TV_BINVIEW
		jnz	SHORT @@bin
		add	edi,8
@@bin:		cmp	edi,fsize
		ja	SHORT @@edi
		call	addedi
		inc	dx
		cmp	dx,rowcnt
		jb	SHORT @@xlp
		jmp	SHORT @@eof
@@edi:		mov	edi,fsize
		jmp	SHORT @@eof

addedi:         push	bx
		lea	bx,ltab
		mov	ax,lcount
		shl	ax,2
		add	bx,ax
		mov	SS:[bx],edi
		inc	lcount
		pop	bx
		ret

getlsize:       push	bx
		shl	ax,2		; ax = lineid
		lea	bx,ltab
		add	bx,ax
		mov	edx,SS:[bx]     ; edx = line offset
		mov	eax,SS:[bx+4]   ; eax = linesize
		sub	eax,edx
		pop	bx
		ret

lodscr:		lodsb
iscrlf:		cmp	al,CR
		jz	SHORT @@END
		cmp	al,LF
@@END:		ret

parseline:      push	si	; si ++ (dx == si on return)
		push	di      ; di += 80
		or	cx,cx
		jz	SHORT @@END
		xor	dx,dx
@@loop:		call	lodscr
		jnz	SHORT @@tab
@@cr1:		call	lodscr
		jz	SHORT @@END
@@dec:		dec	si
		jmp	SHORT @@END
@@tab:		cmp	al,9
		jnz	SHORT @@copy
		sub	dx,di
		add	di,8
		and	di,0FFF8h
		add	dx,di
		jmp	SHORT @@inc
@@copy:		stosb
		inc	dx
@@inc:		cmp	dx,80
		jnz	SHORT @@79
		call	lodscr
		jnz	SHORT @@dec
		dec	si
		jmp	SHORT @@lp
@@79:		cmp	dx,79
		ja	SHORT @@END
@@lp:		loop	SHORT @@loop
@@END:          pop	di
		add	di,80
		mov	ax,si
		pop	dx
		sub	ax,dx	; return byte count
		cwde		; ax to eax
		ret

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

setmaxcol:	xor	cx,cx
@@loop:		cmp	cx,lcount
		jae	SHORT @@END
		mov	ax,cx
		call	getlsize
		cmp	eax,maxcol
		jbe	SHORT @@next
		mov	maxcol,eax
@@next:		inc	cx
		jmp	SHORT @@loop
@@END:		ret

clrsbuf:	call	readltab
		jz	SHORT @@END
		push	di
		push	ES
		mov	eax,20202020h	; clear screen table
		mov	cx,(TXTPAGE/4)
		les	di,screen
		cld
	rep	stosd
		pop	ES
		pop	di
		or	ax,ax		; clear ZF
@@END:		ret

readhex:        call	clrsbuf
		jnz	SHORT @@
		ret
@@:		call	iospush
		push	ES
		push	bx
		mov	ax,8		; adjust read size to 8 byte
		test	xflag,TV_BINVIEW
		jnz	SHORT @@bin
		add	ax,8		; adjust read size to 16 byte
@@bin:		mul	rowcnt		; * number of lines
		cmp	ax,rsize
		ja	SHORT @@rs
		mov	rsize,ax
@@rs:		mov	ax,rsize
		cwde
		mov	scount,eax	; bytes on screen
		cld
		les	di,screen	; ES:DI to buffer
		xor	cx,cx		; CX to line loop
@@lineloop:	push	di		; save offset
		lea	bx,ltab
		mov	ax,cx
		shl	ax,2
		add	ax,3
		add	bx,ax
		mov	dx,4
		test	xflag,(TV_HEXOFFSET or TV_BINVIEW)
		jnz	SHORT @@hex_foff
@@des_foff:	push	DS	; print "%010lu" desimal offset
		push	ES
		push	bx
		push	cx
		mov	DS,CS:[DGROUP@]
		push	DWORD PTR SS:[bx-3]
		push	ds
		push	OFFSET form_10u
		push	ES
		push	di
		call	sprintf
		add	sp,12
		pop     cx
		pop     bx
		pop     ES
		pop     DS
		add	di,9
		jmp	SHORT @@size
@@hex_foff:	mov	al,SS:[bx]	; print "%08lX" hex offset
		call	mkhexw
		stosw
		dec	bx
		dec	dx
		jnz	SHORT @@hex_foff
		inc	di		; to first byte in out buffer
@@size:		mov	dx,rsize
		mov	ax,8
		test	xflag,TV_BINVIEW
		jnz	SHORT @@testsize
		mov	ax,16
		add	di,3
@@testsize:	cmp	dx,ax
		jb      SHORT @@zero
		mov	dx,ax
@@zero:		or	dx,dx
		jz	SHORT @@popdi
		sub	rsize,dx
		mov	bx,di
		add	bx,51
		push	cx
		mov	cx,dx
		xor	dx,dx
@@byteloop:	test	xflag,TV_BINVIEW
		jnz	SHORT @@getc
@@bl:		cmp	dx,8
		jne	SHORT @@getc
		mov	al,179
		stosb
		inc	di
@@getc:		lodsb
		test	xflag,TV_BINVIEW
		jnz	SHORT @@putbin
		mov	ES:[bx],al
		call	mkhexw
		stosw
		inc	di
		inc	bx
		inc	dx
		loop	SHORT @@bl
		jmp	SHORT @@nextl
@@putbin:	mov	ah,al
		push	cx
		mov	cx,8
@@bitloop:      mov	al,ah
		shl	ah,1
		and	al,80h
		mov	al,'1'
		jnz	short @@notzero
		mov	al,'0'
@@notzero:	stosb
		loop	SHORT @@bitloop
		pop	cx
		inc	di
		inc	dx
		loop	SHORT @@byteloop
@@nextl:	pop	cx
		pop	di
		add	di,80
		inc	cx
		cmp	cx,lcount
		jnb	SHORT @@toend
		jmp	@@lineloop
@@popdi:	pop	di
@@toend:	or	ax,1
		pop	bx
		pop	ES
		ret

mkhexw:		mov	ah,al		; hex to ascii
		and	ax,0FF0h
		shr	al,4
		add	ax,'00'
		cmp	ah,'9'
		jbe	SHORT @@db1
		add	ah,7
@@db1:		cmp	al,'9'
		jbe	SHORT @@db2
		add	al,7
@@db2:		ret

; Read ASCII (dump)
;
readasc:	call	clrsbuf
		jz	SHORT @@err
		call	iospush
		mov	ax,MEMPAGE
		mov	edx,edi
		call	iosgetx
		jz	SHORT @@err
@@sbp:          les	bx,screen
		xor	ax,ax
		mov	ocx,ax
		mov	lcount,ax
@@loop:         mov	ax,ocx
		inc	ocx
		cmp	ax,rowcnt
		jae	SHORT @@END
		call	addedi
		mov	cx,rsize
		xchg	di,bx
		call	parseline
		xchg	di,bx
		add	edi,eax
		add	scount,eax
		sub	rsize,ax
		jnz	SHORT @@loop
@@END:          or	ax,1
		ret
@@err:          xor	ax,ax
		ret

readtxt:	call	clrsbuf
		jz	SHORT @@err
		call	setmaxcol
		call	iospush
		les	di,screen
		mov	ocx,0
@@loop:         mov	ax,ocx
		inc	ocx
		cmp	ax,lcount
		jae	SHORT @@END
		call	getlsize
		add	scount,eax
		cmp	eax,curcol
		ja	SHORT @@add
		add	di,80
		jmp	SHORT @@loop
@@add:		add	edx,curcol
		mov	ax,82		; max line
		call	iosgetx
		jz	SHORT @@err
		push	si
		call	parseline
		pop	si
		jmp	SHORT @@loop
@@END:          or	ax,1
		ret
@@err:          xor	ax,ax
		ret

;
; OFFSET_PREV - Get previous line offset
;
; Arg:		void
; Return:	offset, CF clear if successful
; Modifies:	eax,cx,ds,si,edi
;
offset_prev:    call	iospush
		mov	eax,edi
		or	eax,eax
		jz	SHORT @@ret
		cmp	eax,fsize	; align fpos
		jbe	SHORT @@
		mov	eax,fsize	; reset fpos to filesize
		mov	foffs,eax
		mov	edi,eax
		ret
@@:		test	xflag,TV_HEXVIEW
		jz	SHORT @@txt
		mov	edx,16		; fixed size: 16 byte
		test	xflag,TV_BINVIEW
		jz	SHORT @@hex
		mov	dx,8            ; fixed size: 8 byte
@@hex:		cmp	eax,edx
		jbe	SHORT @@nul
		sub	eax,edx
		ret
@@nul:		xor	eax,eax
@@ret:		ret

@@txt:		std
		mov	edx,edi
		call	iosseek		; seek to current offset
		jz	SHORT @@nul
		xor	cx,cx
		call	ioscrlf		; init buffer
		jz	SHORT @@nul
		jnc	SHORT @@do	; not found..
		call	ioscrlf		; skip one
		jz	SHORT @@nul
		jc	SHORT @@get	; skip two
@@do:           jc	SHORT @@set	; found..
@@get:		call	ioscrlf		; get next byte
		jz	SHORT @@nul
		jmp	SHORT @@do
@@set:          mov	eax,edi
		inc	eax
		test	xflag,TV_WRAPLINES
		jz	SHORT @@ret
		cld			; flip direction flag
		sub	edx,eax		; length of line
		cmp	edx,MEMPAGE
		mov	ebx,eax		; ebx = start offset
		xchg	edx,eax         ; edx to result
		jb	SHORT @@b
		sub	edx,MEMPAGE
		mov	ax,MEMPAGE
@@b:            call	iosgetx		; seek to current offset
		jz	SHORT @@nul
		lds	si,readb
@@pl:           les	di,screen
		call	parseline
		or	cx,cx
		jbe	SHORT @@end
		add	eax,ebx
		cmp	eax,foffs
		jae	SHORT @@end
		mov	ebx,eax
		jmp	SHORT @@pl
@@end:		mov	eax,ebx
		ret

initpage:       mov	scount,0
		mov	al,xflag
		test	al,TV_HEXVIEW
		jnz	SHORT @@hex
		test	al,TV_WRAPLINES
		jnz	SHORT @@ascii
		call	readtxt
		jmp	SHORT @@END
@@ascii:	call	readasc
		jmp	SHORT @@END
@@hex:		call	readhex
@@END:		ret

putpage:	mov	eax,fsize
		mov	ebx,100
		cdq
		div	ebx
		push	eax
		mov	eax,scount
		mov	edx,foffs
		add	edx,eax
		pop	eax
		mov	cx,1
		mov	ebx,eax
@@loop:		cmp	cx,99
		ja	SHORT @@put
		cmp	eax,edx
		jae	SHORT @@put
		add	eax,ebx
		inc	cx
		jmp	SHORT @@loop

@@put:		push    cx
		push	DS
		push	OFFSET form_3d
		push	large 0
		push	0
		push	75
		call	scputf
		add	sp,14

		push	curcol
		push	DS
		push	OFFSET form_8ld
		push	large 0
		push	0
		push	65
		call	scputf
		add	sp,16

		cmp	fsize,0
		jz	SHORT @@END
		mov	ax,80
		mul	rowcnt
		mov	cx,ax
		call	__mshide
		mov	ax,SCRSEG
		mov	ES,ax
		push	DS
		push	si
		push	di
		lds	si,screen
		mov	di,160
		cld
@@next:		movsb
		inc	di
		loop	SHORT @@next
		pop	di
		pop	si
		pop	DS
		call	__msshow
@@END:		ret

dw_update:	call	initpage
		jz	SHORT @@END
		call	putpage
		mov	ax,1
@@END:		ret

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

event_home:	mov	curcol,0
		mov	foffs,0
		jmp 	SHORT dw_update

event_end:      test	xflag,TV_HEXVIEW
		jz	SHORT @@TEXT
		mov	ax,rowcnt	; max byte on screen
		mov	cl,4
		test	xflag,TV_BINVIEW
		jz	SHORT @@hex
		dec	cl
@@hex:		shl	ax,cl
		cwde
		inc	eax
		cmp	fsize,eax
		jb	SHORT @@END
		mov	edx,fsize
		sub	edx,eax		; fpos = fsize - (rowcnt * 16|8);
		mov	eax,fsize       ; += (16 - (fsize % 16|8));
		test	xflag,TV_BINVIEW
		jz	SHORT @@hex2
		sub	edx,8
@@hex2:		and	eax,15
		add	edx,16
		sub	edx,eax
		mov	foffs,edx
		jmp 	dw_update
@@TEXT:		mov	ax,lcount       ; text offset
		cmp	ax,rowcnt
		jb	SHORT @@END
		mov	eax,scount
		add	eax,foffs
		inc	eax
		cmp	fsize,eax
		jb	SHORT @@END
		mov	eax,fsize
		mov	foffs,eax
		jmp	text_pgup
@@END:		ret

event_up:	call	offset_prev
		cmp	eax,foffs
		jz	SHORT @@END
		mov	foffs,eax
		jmp	dw_update
@@END:		ret

event_down:	test	xflag,TV_HEXVIEW
		jz	SHORT @@ascii
		mov	edx,16
		test	xflag,TV_BINVIEW
		jz	SHORT @@hex
		mov	dx,8
@@hex:		mov	eax,scount
		add	eax,foffs
		inc	eax
		cmp	eax,fsize
		jae	SHORT ret_0
		add	eax,edx
		cmp	eax,fsize
		jb	SHORT @@04
		jmp	event_end
@@04:		add	foffs,edx
		jmp	dw_update
@@ascii:	mov	ax,lcount
		cmp	ax,rowcnt
		jb	SHORT ret_0
		lea	bx,ltab
		add	bx,4
		mov	eax,SS:[bx]
ret_fpos:	mov	foffs,eax
ret_upd:	jmp	dw_update
ret_0:		xor	ax,ax
		ret

event_pgup:	cmp	foffs,0
		jz	SHORT @@ret
		test	xflag,TV_HEXVIEW
		jz	SHORT text_pgup
		mov	ax,rowcnt
		mov	cl,4
		test	xflag,TV_BINVIEW
		jz	SHORT @@hex
		mov	cl,3
@@hex:		shl	ax,cl
		cwde
		cmp	eax,foffs	; if (fpos > (rowcnt * 16|8))
		jae	SHORT @@nul
		sub	foffs,eax	; fpos -= (rowcnt * 16|8);
		jmp	SHORT @@END
@@nul:		mov	foffs,0
@@END:		jmp	dw_update
@@ret:		ret

text_pgup:	push	di
		mov	di,1
@@prev:		call	offset_prev
		cmp	eax,foffs
		jz	SHORT @@END
		mov	foffs,eax
		inc	di
		cmp	di,rowcnt
		jnz	SHORT @@prev
@@END:		pop	di
		jmp	dw_update

event_pgdn:	mov	eax,scount
		add	eax,foffs
		inc	eax
		cmp	eax,fsize
		jae	SHORT @@END
		test	xflag,TV_HEXVIEW
		jz	SHORT @@TEXT
		mov	edx,eax
		mov	ax,rowcnt
		mov	cl,4
		test	xflag,TV_BINVIEW
		jz	SHORT @@hex
		mov	cl,3
@@hex:		shl	ax,cl
		cwde
		add	edx,eax
		cmp	edx,fsize
		jae	SHORT @@eend
		add	foffs,eax		; fpos += (rowcnt * 16);
		jmp	dw_update
@@TEXT:		mov	ax,lcount
		cmp	ax,rowcnt
		jne	SHORT @@END
		mov	ax,lcount
		dec	ax
		shl	ax,2
		lea	bx,ltab
		add	bx,ax
		mov	eax,SS:[bx]
		cmp	eax,fsize
		jae	SHORT @@eend	; return event_end();
		mov	foffs,eax
		jmp	dw_update
@@eend:		jmp	event_end
@@END:		ret

event_left:	test	xflag,TV_WRAPLINES
		jnz	SHORT @@END
		cmp	curcol,0
		jz	SHORT @@END
		dec	curcol
		jmp	dw_update
@@END:		ret

event_pgleft:	test	xflag,TV_WRAPLINES
		jnz	SHORT @@END
		mov	eax,curcol
		or	eax,eax
		jz      SHORT @@END
		cmp	eax,80
		ja      SHORT @@sub
		xor	eax,eax
		jmp      SHORT @@set
@@sub:		sub	eax,80
@@set:		mov	curcol,eax
		jmp	dw_update
@@END:		ret

event_right:	test	xflag,TV_WRAPLINES
		jnz	SHORT @@END
		mov	eax,curcol
		cmp	eax,maxcol
		jz	SHORT @@END
		inc	curcol
		jmp	dw_update
@@END:		ret

event_pgright:	test	xflag,TV_WRAPLINES
		jnz	SHORT @@toend
		mov	eax,curcol
		cmp	eax,maxcol
		jb	SHORT @@add
@@toend:	ret
@@add:		add	eax,80
		cmp	eax,maxcol
		jb	SHORT @@set
		mov	eax,maxcol
@@set:		mov	curcol,eax
		jmp	dw_update


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

cm_search:	cmp	fsize,16
		jb	SHORT @@ret
		push	IDD_TVSearch
		call	rsopen
		or	ax,ax
		jnz	SHORT @@
@@ret:		ret

@@:		mov	ES,dx
		mov	bx,ax
		push	dx
		push	ax
		pop	eax
		mov     [s_dlg],eax
		les	bx,ES:[bx.dl_object]
		mov	ES:[bx.to_count],(128 shr 4)
		mov	WORD PTR ES:[bx.to_data+2],DS
		mov	WORD PTR ES:[bx.to_data],OFFSET searchstring
		test	xflag,TV_SEARCHCASE
		jz	SHORT @@01
		or	ES:[bx.to_flag+16],_O_FLAGB
@@01:		test	xflag,TV_SEARCHSCOPE
		jz	SHORT @@02
		or	ES:[bx.to_flag+(16*5)],_O_RADIO
		jmp	SHORT @@03
@@02:		or	ES:[bx.to_flag+(16*4)],_O_RADIO
@@03:
		push	IDD_TVSearch
		push	eax
		push	eax
		call	tdinit
		call	rsevent

		push	ax
		les	bx,s_dlg
		les	bx,ES:[bx.dl_object]
		push	ES:[bx.to_flag+16]
		push	ES:[bx.to_flag+(16*5)]
		push	s_dlg
		call	twclose
		pop	ax
		pop	dx
		pop	cx
		or	cx,cx
		jz	SHORT @@END
		cmp	searchstring,ch
		jz	SHORT @@END
		and	xflag,(not (TV_SEARCHCASE or TV_SEARCHSCOPE))
		and	dx,_O_FLAGB
		jz	SHORT @@04
		or	xflag,TV_SEARCHCASE
@@04:		and	ax,_O_RADIO
		jz	SHORT @@05
		or	xflag,TV_SEARCHSCOPE
		or	lflag,IOS_SEEKSET
		xor	eax,eax
		jmp	SHORT @@06
@@05:           or	lflag,IOS_SEEKCUR
@@06:		call	continue_search
@@END:		ret

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

continue_search:
		xor	ax,ax
		cmp	searchstring,al
		jz	SHORT @@END
		push	IDD_TVMsgw
		call	rsopen
		or	ax,ax
		jz	SHORT @@END
		push	dx
		push	ax
		pop	eax
		mov	s_dlg,eax
		push	eax
		call	twshow
		push	20
		push	11
		push	39
		push	DS
		push	OFFSET searchstring
		call	scenter
		test	xflag,TV_HEXVIEW
		jz	SHORT @@txt
		call	iossearchhex
		jmp	SHORT @@close
@@txt:		call	iossearchtxt
@@close:	push	si
		mov	si,ax
		push	s_dlg
		call	twclose
		or	si,si
		jnz	SHORT @@found
		call	iosnotfoundmsg
		jmp	SHORT @@pop
@@found:	call	putpage
		mov	ax,si
@@pop:		pop	si
@@END:		ret

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

cm_color:	xor	xflag,TV_HIGHCOLOR
		call	update_dlg
		mov	ax,1
		ret

cm_wrap:	cmp	fsize,0
		jz	SHORT cm_ret0
		test	xflag,TV_HEXVIEW
		jnz	SHORT cm_ret0
		xor	xflag,TV_WRAPLINES
		jmp	SHORT cm_upd

cm_offs:	cmp	fsize,0
		jz	SHORT cm_ret0
		test	xflag,TV_HEXVIEW
		jz	SHORT cm_ret0
		xor	xflag,TV_HEXOFFSET
		jmp	SHORT cm_upd

cm_binary:      cmp	fsize,0
		jz	SHORT cm_ret0
		xor	xflag,TV_BINVIEW
		jmp	SHORT cm_upd

cm_hex:		cmp	fsize,0
		jz	SHORT cm_ret0
		xor	xflag,TV_HEXVIEW
cm_upd:		call	update_dlg
		jmp	dw_update


cm_quit:	mov	switch,1
cm_ret0:	xor	ax,ax
		ret

cm_help:	push	IDD_TVHelp
		call	rsmodal
		ret

event_handler:  mov	cx,key_count
		xor	bx,bx
		cmp	fsize,0
		jnz	SHORT @@keyloop
		mov	cx,key_glcount
@@keyloop:	cmp	ax,[bx.key_global]
		jz	SHORT @@exe
		add	bx,2
		loop	SHORT @@keyloop
		ret
@@exe:		jmp	[bx.key_proc]

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

scroll_action:  call	mousey	; ax = xpos
		push	ax	; dx = ypos
		call	mousex  ; bx = result
		xor	cx,cx
		mov	ES,cx
		mov	cl,ES:[0484h]
		pop	dx
		xor	bx,bx
		cmp	cx,24
		jz	SHORT sa_00
		shr	ax,1
		shr	dx,1
sa_00:		cmp	dx,8
		jb	SHORT sa_up
		cmp	dx,16
		ja	SHORT sa_dn
		cmp	dx,8
		jb	SHORT sa_r0
		cmp	dx,16
		ja	SHORT sa_r0
		cmp	ax,31
		jb	SHORT sa_le
		cmp	ax,50
		ja	SHORT sa_ri
		cmp	dx,12
		jnz	SHORT sa_01
		cmp	ax,39
		ja	SHORT sa_ri
		jmp	SHORT sa_le
sa_01:          cmp	dx,11
		jb	SHORT sa_02
		cmp	dx,13
		ja	SHORT sa_02
		cmp	ax,36
		jb	SHORT sa_le
		cmp	ax,45
		ja	SHORT sa_ri
sa_02:		cmp	dx,12
		jb	SHORT sa_up
		ja      SHORT sa_dn
sa_r0:		ret
sa_ri:		inc	bx
sa_le:		inc	bx
sa_dn:		inc	bx
sa_up:		inc	bx
delay_time:     push	bx
		cmp	ax,37
		jb	SHORT dt_left
		cmp	ax,43
		jb	SHORT dt_x0
		mov	bx,79
		sub	bx,ax
		mov	ax,bx
		jmp	SHORT dt_left
dt_x0:		xor	ax,ax
dt_left:        shl	ax,2
		cmp	dx,12
		jz	SHORT dt_y0
		jb	SHORT dt_up
		mov	cx,24
		sub	cx,dx
		mov	dx,cx
		jmp	SHORT dt_up
dt_y0:		xor	dx,dx
dt_up:		add	dx,dx
		shl	dx,1
dt_end:         pop	bx
		ret

sd_case		DW	sd_default
		DW	sd_case_up
		DW	sd_case_dn
		DW	sd_case_le
		DW	sd_case_ri

scroll_delay:   push	si
		xor	si,si
		call	scroll_action
		shl	bx,1
		jmp	CS:[bx.sd_case]
sd_case_up:     mov	ax,KEY_UP
		jmp	SHORT sd_01
sd_case_dn:	mov	ax,KEY_DOWN
sd_01:		push	dx
		jmp	SHORT sd_02
sd_case_le:	push	ax
		mov	ax,KEY_LEFT
		jmp	SHORT sd_02
sd_case_ri:	push	ax
		mov	ax,KEY_RIGHT
		jmp	SHORT sd_02
sd_02:		call	event_handler
		pop	ax
		mov	si,ax
sd_default:	cmp	si,0
		jz	SHORT sd_end
		push	si
		call	delay
sd_end:         pop	si
		ret

event_mouse:    call	mousep
		or	ax,ax
		jz	SHORT @@END
		call	mousey
		mov	y,ax
		call	mousex
		mov	x,ax
		mov	ax,rowcnt
		inc	ax
		cmp	ax,y
		jnz	SHORT @@01
		call	mouseloop	; wait until button released..
		cmp	x,9
		jnb	SHORT @@0919
		jmp	cm_help
@@0919:		je	SHORT @@END
		cmp	x,20
		jnb	SHORT @@2130
		jmp	cm_wrap
@@2130:		cmp	x,31
		jnb	SHORT @@3240
		jmp	cm_search
@@3240:		je	SHORT @@END
		cmp	x,40
		ja	SHORT @@4249
		jmp	cm_hex
@@4249:		je	SHORT @@END
		cmp	x,50
		ja	SHORT @@5259
		jmp	cm_color
@@5259:
		cmp	x,61
		ja	SHORT @@62
		jmp	cm_offs
@@62:           cmp	x,68
		ja	SHORT @@70
		jmp	cm_binary
@@70:		cmp	x,70
		jna	SHORT @@END
		call	cm_quit
@@END:		xor	ax,ax
		ret
@@01:		call	mousep
		cmp	ax,1
		jnz	SHORT @@END
		call	scroll_delay
		jmp	SHORT @@01
@@02:		call	mouseloop
		jmp	SHORT @@END

modal:          cmp	switch,0
		jnz	SHORT @@END
		call	dw_update
@@idle:		call	mousep
		or	ax,ax
		jnz	SHORT @@mouse
		call	getkey
		or	ax,ax
		jz	SHORT @@idle
		jmp	SHORT @@hndevent
@@mouse:	call	event_mouse
		jmp	SHORT @@mousep
@@hndevent:	call	event_handler
@@mousep:	call	mouseloop
		jmp	SHORT modal
@@END:		xor	ax,ax
		ret

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

dummy_update:	xor	ax,ax
		retf

mouseloop:	call	mousep
		or	ax,ax
		jnz	SHORT mouseloop
		ret

update_dlg:     push	si
		movzx	si,xflag
		push	0
		push	1
		mov	dx,rowcnt
		mov	ax,80
		mul	dl
		push	ax
		mov	al,bg_Desktop
		or	al,07h
		test	si,TV_HIGHCOLOR
		jz	SHORT @@setcolor
		or	al,0Fh
@@setcolor:	push	ax
		call	scputa
		push	35
		mov	ax,rowcnt
		inc	ax
		push	ax
		push	0
		push	5
		push	DS
		mov	ax,OFFSET cp_hex
		test	si,TV_HEXVIEW
		jz	SHORT @@sethex
		mov	ax,OFFSET cp_ascii
@@sethex:	push	ax
		call	scputs
		push	13
		mov	ax,rowcnt
		inc	ax
		push	ax
		push	0
		push	6
		push	DS
		mov	ax,OFFSET cp_unwrap
		test	si,TV_WRAPLINES
		jnz	SHORT @@setwrap
		mov	ax,OFFSET cp_wrap
@@setwrap:	push	ax
		call	scputs
		push	66
		mov	ax,rowcnt
		inc	ax
		push	ax
		push	0
		push	3
		push	DS
		mov	ax,OFFSET cp_hexmode
		test	si,TV_BINVIEW
		jnz	SHORT @@setoffs
		mov	ax,OFFSET cp_binary
@@setoffs:	push	ax
		call	scputs
		pop	si
		ret

IFDEF TVEXE
msgmsdos:	mov	ah,40h
		mov	bx,2
		int	21h
		ret
ENDIF

_TEXT		ENDS

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

PPROC		tview
USES		si,di
LOCAL           x,y,z:	WORD,\		; temp (mouse)
		switch:	WORD,\		; main switch
		dialog:	DWORD,\		; main dialog pointer
		cursor:	DWORD,\		; cursor (old)
		oldupd:	DWORD,\		; update proc (old)
		s_dlg:	DWORD,\		; search dialog
		s_offs:	DWORD,\		; search offset
		ltab:	DWORD:[MAXROW+2],\; line offset in file
		ocx:	WORD,\		; buffer size
		curcol:	DWORD,\		; current line offset (col)
		maxcol:	DWORD,\		; max linesize on screen
		rowcnt:	WORD,\		; max lines (23/48)
		lcount:	WORD,\		; lines on screen
		scount:	DWORD,\		; bytes on screen
		screen:	DWORD,\		; screen buffer
		lflag:	BYTE,\		; local config flag
		xflag:	BYTE,\		; extern config flag
		readb:	DWORD,\		; read buffer
		foffs:	DWORD,\         ; current offset = edi
		fsize:	DWORD,\		; file size
		bsize:	WORD,\		; buffer size
		rsize:	WORD,\		; current read size
		fhndl:	WORD		; file handle
ARG		fname:	DWORD,\
		offs:	DWORD
		mov	ax,cflag
		mov	xflag,al
		mov	eax,offs
		mov	foffs,eax
		xor	eax,eax
		mov	lflag,al
		mov	switch,ax
		mov	rsize,ax
		mov	fsize,eax
		mov	curcol,eax
		mov	maxcol,eax
		mov	scount,eax
		mov	lcount,ax
		mov	ES,ax
		mov	al,ES:[0484h]
		dec	ax
		mov	rowcnt,ax
		add	ax,2
		mov	rs_rcrow,al	; set row count in dialog
		mov	dx,160
		mul	dl
		add	ax,16
		mov	resource,ax	; adjust memory size
		mov	ax,rowcnt
		mov	dx,80
		mul	dl
		or	ax,0F000h
		xchg	al,ah
		mov	rs_atcnt,ax     ; adjust attrib count
		add	ah,2
		mov	rs_chcnt,ax     ; adjust char count
		mov	ax,MEMPAGE
		mov	bsize,ax
		push	fname
		push    0
		push	M_RDONLY
		push	A_OPEN
		call	osopen
		cmp	ax,-1
IFDEF TVEXE
		jz	SHORT @@eropen
ELSE
		jz	SHORT @@end
ENDIF
		mov	fhndl,ax
		push	ALLOCSIZE
		call	malloc
		mov	readb,eax
		mov	screen,eax
		add	screen,(MEMPAGE+12)	; 4008h - align tabs
		or	ax,ax
		jz	SHORT @@errmem
		push	DS
		push	OFFSET resource
		call	rsopen
		or	ax,ax
		jnz	SHORT @@dialog
@@erridd:	push	readb
		call	free
@@errmem:	push	fhndl
		call	close
		mov	ax,1
@@end:
IFNDEF TVEXE
@@shift:	les	bx,shift
		test	WORD PTR ES:[bx],0000001000001000b
		jnz	SHORT @@shift
ENDIF
		ret
IFDEF TVEXE
@@eropen:	mov	dx,OFFSET FileNotFound
		mov	cx,size_FileNotFound
		call	msgmsdos
		push	fname
		call	strlen
		mov	cx,ax
		push	DS
		lds	dx,fname
		call	msgmsdos
		pop	DS
		jmp	SHORT @@end
ENDIF

@@dialog:	mov	WORD PTR [dialog],ax
		mov	WORD PTR [dialog+2],dx
		push	dialog
		call	twshow
		call	mouseoff
		push    12
		push	0
		push	30
		push	fname
		call	scpath
		add	ax,14
		mov	x,ax
@@seek:		mov	ax,4202h
		mov	bx,fhndl
		xor	cx,cx
		xor	dx,dx
		int	21h
		jc	SHORT @@fsize
		mov	WORD PTR [fsize],ax
		mov	WORD PTR [fsize+2],dx
@@fsize:	push	large 0
		push	fsize
		call	qwtobstr
		push	x
		push	large 0
		push	0
		push	dx
		push	ax
		call	scputs
		add	ax,x
		push	ax
		push	large 0
		push	0
		push	DS
		push	OFFSET cp_byte
		call	scputs
		lea	ax,cursor
		push	SS
		push	ax
		call	getcursor
		call	cursoroff
IFNDEF TVEXE
	IFDEF LPROG
		mov	eax,tupdate
		mov	oldupd,eax
	ELSE
		mov	ax,tupdate
		mov	WORD PTR oldupd,ax
	ENDIF
ENDIF
		push	CS
		push	OFFSET dummy_update
		pop     tupdate
		call	mouseon
		call	update_dlg
@@mousep:	call	mousep
		or	ax,ax
		jnz	short @@mousep
		call	modal
		push	readb
		call	free
		push	dialog
		call	twclose
		push	fhndl
		call	close
		mov	eax,oldupd
IFDEF	LPROG
		mov	tupdate,eax
ELSE
		mov	tupdate,ax
ENDIF
		push	cursor
		call	setcursor
		mov	al,xflag
		mov	BYTE PTR cflag,al
		xor	ax,ax
		jmp	@@end
PEND		tview

IFDEF TVEXE

GLOBAL PASCAL	atol:	DIST

PPROC		main
ARG		argc:	WORD,\
		argv:	DWORD
		mov	cx,sizecopyright
		mov	dx,OFFSET copyright
		call	msgmsdos
		cmp	argc,1
		je	SHORT @@argerror
		xor	eax,eax
		cmp	argc,3
		ja	SHORT @@argerror
		jb      SHORT @@push
		les	bx,argv
		mov	eax,ES:[bx+8]
		add	eax,2
		push	eax
		call	atol
		push	dx
		push	ax
		jmp	SHORT @@init
@@argerror:	mov	cx,sizeusage
		mov	dx,OFFSET cp_usage
		call	msgmsdos
		jmp	SHORT @@toend
@@push:		push	eax
@@init:		call	mouseinit
		call	mouseon
		push	63
		push	6
		call	setpal

		push	DS
		push	OFFSET searchstring
		push	DS
		push	OFFSET cp_ext
		call	setext
		push	dx
		push	ax
		call	readword
		mov	config,ax	; => config
		mov	searchstring,0

		les	bx,argv
		add	bx,4
		mov	eax,ES:[bx]
		pop	edx
		push	eax
		push	edx
		call	tview		; tview(argv[1], 0L);

		call	mouseoff
		push	DS
		push	OFFSET searchstring
		push	DS
		push	OFFSET cp_ext
		call	setext
		push	dx
		push	ax
		push    _A_HIDDEN
		push	M_WRONLY
		push	(A_CREATE or A_TRUNC)
		call	osopen
		cmp	ax,-1
		jz	SHORT @@toend

		push	ax
		mov	bx,ax
		mov	ax,4000h
		mov	cx,2
		mov	dx,OFFSET config
		int	21h
		call	close
@@toend:	xor	ax,ax
		ret
PEND		main

ENDIF

		END
