/*
 * XCELL.C
 *
 *  This file is part of DOSZIP
 *  Copyright (c) 1996 Hjort Nidudsson.
 */

#include <io.h>
#include <arch.h>
#include <ifsmgr.h>
#include <string.h>
#include <dzmain.h>

#define cell_flag	(_D_BACKG|_D_MYBUF)

extern 	xcell panelcela[];
#define panel_xcell panelcela

int pcell_set(panel *p)
{
	p->cel_count = MIN(p->xl->cols * p->xl->rows, p->fcb_count - p->fcb_index);
	p->cel_index = xl_setcell(p->xl, p->cel_index, p->cel_count);
	return p->cel_index;
}

int pcell_show(panel *p)
{
	if (p->xl->flag & (_D_DOPEN|_D_ONSCR))
		return 0;
	pcell_set(p);
	if (p->cel_count == 0)
		return 0;
	if (xl_open(p->xl))
		xl_show(p->xl);
	return 1;
}

int pcell_update(panel *p)
{
	if (pcell_hide(p) == 0)
		return 0;
	pcell_set(p);
	p->putfcb(panel_curobj(p), p->xl->rc.x, p->xl->rc.y);
	if (xl_open(p->xl))
		xl_show(p->xl);
	panel_putmini(p);
	return 1;
}

int pcell_select(panel *p)
{
	FBLK *b;

	if ((b = panel_curobj(p)) == NULL)
		return 0;
	if (invert_fb(b)) {
		pcell_update(p);
		return 1;
	}
	return 0;
}

int pcell_setxy(panel *p, int x, int y)
{
	int 	q,z;
	RECT 	rc;

	_ASSERTE(p == NULL);
	if (panel_state(p) == 0)
		return 0;
	if (panel_xycmd(p, x, y) != PN_XYFILE) {
		while (mousep() == 2) {
			q = mousex();
			z = mousey();
			if (panel_xycmd(p, q, z) == PN_XYFILE)
				return pcell_setxy(p, q, z);
		}
		return 0;
	}
	z = 0;
	for (q = 0; q < p->cel_count; q++) {
		rc = xl_getrect(p->xl, q);
		if (rcxyrow(rc, x, y)) {
			z = 1;
			break;
		}
	}
	if (z == 1) {
		if (p->cel_index != q) {
			p->cel_index = q;
			pcell_update(p);
		}
		if (mousep() == 2) {
			pcell_select(p);
			mousewait(rc.x, rc.y, rc.col);
			return pcell_setxy(p, mousex(), mousey());
		} else {
			mousewait(x, y, 1);
		}
		switch (pcell_move(p)) {
			case 1:	cmcopy(); return 1;
			case 2:	cmmove(); return 1;
			default:
			for (q = 0; q < 10; q++) {
				delay(16);
				if (mousep())
					break;
			}
			break;
		}
		if (mousep() && mousex() == x && mousey() == y)
			panel_hndevent(p, ENTER);
		return 1;
	}
	while (mousep() == 2) {
		if (panel_xycmd(p, mousex(), mousey()) == PN_XYFILE)
			return pcell_setxy(p, mousex(), mousey());
	}
	return 0;
}

#define _RCFLAG	(_D_DMOVE|_D_CLEAR|_D_COLOR)

int pcell_move(panel *p)
{
	int 	q;
	int 	docopy;
	int 	selected;
	WCHR *	sc;
	RECT	rc;
	FBLK *	b;

	if (!(b = cpanel_findfirst()))
		return 0;
	if (panel_state(&panela) == 0 && panel_state(&panelb) == 0)
		return 0;
	rc = p->xl->rc;
	selected = panel_numselected(p);
	if (mousep() == 1) {
		docopy = 1;
		if (shift->ShiftLeft || shift->ShiftRight)
			docopy = 0;
		if (selected) {
			rc.col = 15;
		} else {
			if (*p->flag & _W_DETAIL)
				rc.col -= 26;
			while (getxyc(rc.x + rc.col - 1, rc.y) == ' ')
				rc.col--;
			rc.col++;
		}
		rc.col++;
		rc.x--;
		sc = rcopen(rc, _RCFLAG, at_Reverse, 0, 0);
		if (selected)
			wcputf(sc+1, 0, 0, cp_mcopyselected, selected);
		else
			wcputs(sc+1, 0, rc.col - 1, b->name);
		q = _RCFLAG|_D_DOPEN;
		rcshow(rc, q, sc);
		q |= _D_ONSCR;
		scputc(rc.x, rc.y, 0, 1, ' ');
		if (docopy)
			scputc(rc.x + rc.col - 1, rc.y, 0, 1, '+');
		else
			scputc(rc.x + rc.col - 1, rc.y, 0, 1, ' ');
		while (mousep() == 1) {
			if (rc.x != mousex() || rc.y != mousey())
				rc = rcmove(rc, sc, q, mousex(), mousey());
			if (docopy) {
				if (shift->ShiftLeft || shift->ShiftRight) {
					docopy = 0;
					scputc(rc.x + rc.col - 1, rc.y, 0, 1, ' ');
				}
			} else {
				if (!shift->ShiftLeft && !shift->ShiftRight) {
					docopy = 1;
					scputc(rc.x + rc.col - 1, rc.y, 0, 1, '+');
				}
			}
		}
		rcclose(rc, q, sc);
		if (*p->flag & _W_PANELID)
			q = panel_xycmd(&panela, mousex(), mousey());
		else
			q = panel_xycmd(&panelb, mousex(), mousey());
		if (q != 0) {
			if (docopy == 0)
				return 2;
			return 1;
		}
	}
	return 0;
}

int copyfile(const char *src, const char *des)
{
	int sh;
	int oh;
	int result;

	if ((oh = osopen(des, _A_NORMAL, M_WRONLY, A_CREATE)) == -1)
		return 0;
	if ((sh = osopen(src, _A_NORMAL, M_RDONLY, A_OPEN)) == -1) {
		close(oh);
		return 0;
	}
	result = copyhndl(sh, oh, filelength(sh));
	close(sh);
	close(oh);
	return result;
}

int ccell_edit(int do_copy)
{
	char *	p;
	fblk *	b;
	RECT	rc;
	char 	name[WMAXPATH];

	if ((b = panel_curobj(cpanel)) == NULL)
		return 0;
	if (ISUPDIR(b->flag))
		return 0;
	if (ISARCHIVE(b->flag))
		return notsup();
	rc = cpanel->xl->rc;
	p  = wlongname(cpanel->ide->path, b->name);
	strcpy(name, p);
	if (*name) {
		scputc(rc.x, rc.y, at_Msdos, rc.col, ' ');
		if (tdedit(name, rc, WMAXPATH - 1, 1) != ESC) {
			if (strcmp(p, name)) {
				if (do_copy == 1)
					copyfile(p, name);
				else
					rename(p, name);
				panel_update_fcb(cpanel);
			}
		}
	}
	if (pcell_hide(cpanel))
		pcell_show(cpanel);
	return 1;
}
