/*
 * INITPATH.C
 *
 *  This file is part of DOSZIP
 *  Copyright (c) 1996 Hjort Nidudsson.
 */

#include <io.h>
#include <arch.h>
#include <string.h>
#include <errno.h>
#include <dzmain.h>

static DOBJ *dialog;

char __outpath[WMAXPATH];
char __srcpath[WMAXPATH];
char __outfile[WMAXPATH];
char __srcfile[WMAXPATH];

int cpy_flag;
int cpy_jump;
int cpy_subcount;
int cpy_filecount;

void set_confirmflag(void);
static int confirm_path(FBLK *, int);
int cpy_setselectedcnt(void);
int recursive(char *, char *, char *);

int cpy_initpath(FBLK *b, int copy)
{
	char *p;
	panel *t;

	cpy_jump = 0;
	cpy_flag = 0;
	cpy_subcount  = 0;
	cpy_filecount = 0;
	if ((p = cpanel_gettarget()) == NULL)
		return stderror(cp_needpanel, EMUSER, 0);
	t = &panela;
	if (cpanel == t)
		t = &panelb;
	if (*t->flag & _W_ARCHIVE) {
		if (copy == 0 || (*t->flag & _W_ARCHIVE) != _W_ZIP)
			return notsup();
		cpy_flag = CPY_OUTARCH;
	}
	strcpy(__outpath, wlongpath(p, NULL));
	strcpy(__srcpath, wlongpath(cpanel->ide->path, NULL));
	strcpy(__srcfile, wlongpath(__srcpath, b->name));
	if (cpy_flag == CPY_OUTARCH) {
		strfcat(__outfile, __outpath, t->ide->file);
		if (t->ide->arch[0])
			strcpy(__outpath, t->ide->arch);
		else
			__outpath[0] = 0;
		dostounix(__outpath);
	} else {
		strfcat(__outfile, __outpath, strfn(__srcfile));
	}
	if (ISSELECTED(b->flag)) {
		if (cpy_setselectedcnt() == 0)
			return cpy_flag;
		cpy_flag |= CPY_SELECTED;
	} else if (ISSUBDIR(b->flag)) {
		if (recursive(b->name, __srcpath, __outpath))
			cpy_flag |= CPY_RECURSIV;
		cpy_subcount = 1;
	} else {
		cpy_filecount = 1;
	}
	if ((cpy_filecount + cpy_subcount) == 0)
		return 0;
	if (confirm_path(b, copy) == 0)
		return 0;
	if (ISARCHIVE(b->flag)) {
		_ASSERTE(cpy_flag & CPY_OUTARCH);
		cpy_flag |= CPY_SRCARCH;
		cpy_flag &= ~CPY_RECURSIV;
	} else if (0 == strcmp(__outfile, __srcfile)) {
		return stderror(cp_fnisequal, EMUSER, 0);
	}
	if (cpy_flag & CPY_RECURSIV)
		return stderror(cp_recursive, EMUSER, 0);
	if ((cpy_flag & CPY_OUTARCH) == 0 && getfattr(__outpath) == -1) {
		if (mkdir(__outpath) != 0)
			return ermsg(cp_mkdir, cp_ermkdir, __outpath, sys_errlist[errno]);
	}
	set_confirmflag();
	return 1;
}

static int event_filter(void)
{
	int x,y;

	cmfilter();
	x = dialog->rc.x + 16;
	y = dialog->rc.y + 5;
	if (filtp == NULL)
		scputc(x, y, 0, 1, ' ');
	else
		scputc(x, y, 0, 1, 7);
	return _C_NORMAL;
}

int confirm_path(FBLK *b, int copy)
{
	int x,y;
	DOBJ *d;

	if (copy)
		x = (config.confirm & _C_CONFCOPY);
	else
		x = (config.confirm & _C_CONFMOVE);
	if (x == 0)
		return 1;
	if (copy)
		d = rsopen(IDD_COPY);
	else
		d = rsopen(IDD_MOVE);
	if (d == NULL)
		return 0;
	dialog = d;
	if (copy) {
		filtp = NULL;
		d->object[2].proc = event_filter;
	}
	twshow(d);
	x = d->rc.x + 9;
	y = d->rc.y + 2;
	d->object->count = 16;
	if (ISSELECTED(b->flag)) {
		scputf(x, y, 0, 0, cp_copyselected,
			(cpy_filecount + cpy_subcount));
		scpath(x - 5, y + 1, 51, __outpath);
		d->object->data = __outpath;
	} else {
		scputc(x, y, 0, 1, '\'');
		scputs(scpath(x + 1, y, 38, b->name) +
			x + 1, y, 0, 0, "' to");
		d->object->data = __outfile;
	}
	if (ISSUBDIR(b->flag)) {
		scpath(x - 5, y + 1, 51, __outpath);
		d->object->data = __outpath;
	}
	if (cpy_flag & CPY_OUTARCH) {
		d->object->data = __outfile;
		tdinit(d);
		d->object->flag |= _O_STATE;
	}
	if (copy)
		x = rsevent(IDD_COPY, d);
	else
		x = rsevent(IDD_MOVE, d);
	tdclose(d);
	return (x != 0);
}

int cpy_setselectedcnt(void)
{
	int q;
	fblk **b;

	b = cpanel->ide->fcb;
	for (q = 0; q < cpanel->fcb_count; q++) {
		if (ISSELECTED(b[q]->flag)) {
			if (ISSUBDIR(b[q]->flag)) {
				if (recursive(b[q]->name, __srcpath, __outpath))
					cpy_flag = CPY_RECURSIV;
				cpy_subcount++;
			} else {
				cpy_filecount++;
			}
		}
	}
	return 1;
}

int recursive(char *name, char *src, char *des)
{
	char *p;
	char b[WMAXPATH];

	strcpy(b, des);
	strfcat(b, NULL, wlongname(src, name));
	p = wlongpath(src, name);
	return (0 == strnicmp(p, b, strlen(p)));
}