/*
 * COMMAND.C
 *
 *  This file is part of DOSZIP
 *  Copyright (c) 1996 Hjort Nidudsson.
 */

#include <string.h>
#include "dzmain.h"

CMDL com = { "", com.base, 0, { 0,24,80,1 }, NULL };

static int com_update(int result)
{
	if (result == 0)
		return 0;
	while (com.count >= (80 - com.rc.x)) {
		com.bp++;
		com.count = 79 - com.rc.x;
	}
	scputc(com.rc.x, com.rc.y, 0x07, 80 - com.rc.x, ' ');
	scputs(com.rc.x, com.rc.y, 0x07, 80 - com.rc.x, com.bp);
	gotoxy(com.rc.x + com.count, com.rc.y);
	return result;
}

void com_initline(void)
{
	com.rc.x = MIN(strlen(com.sub->path) + 1, 51);
	scputc(0, com.rc.y, 0, 80, ' ');
	com.rc.y = *__egaline - 1;
	scpath(0, com.rc.y, 50, com.sub->path);
	scputc(com.rc.x - 1, com.rc.y, 0, 1, '>');
	gotoxy(com.rc.x, com.rc.y);
}

int com_setdevice(WSUB *p)
{
	wsinit(p);
	com.sub = p;
	com.rc.y = *__egaline - 1;
	com_initline();
	return com_update(1);
}

void com_egaline(void)
{
	if (com.bp && com.sub) {
		com_initline();
	} else {
		com.rc.y = *__egaline - 1;
	}
	com_update(1);
}

static int com_nextword(void)
{
	char *p;
	char *q;

	p = com.bp + com.count;
	if (p[0] && com.count < strlen(com.bp)) {
		if (p[1] && (q = strchr(p + 1, ' ')) != NULL) {
			while (*q == ' ')
				q++;
			com.count += (q - p);
		} else {
			return END;
		}
	}
	return com_update(1);
}

static int com_prevword(void)
{
	char *p;
	char *q;

	if (com.count || com.bp > com.base) {
		p = com.base;
		q = com.bp + com.count;
		if (*--q <= ' ') do {
			if (com.count)
				com.count--;
			else if (com.bp > com.base)
				com.bp--;
		} while (*--q <= ' ');
		while (q > p) {
			if (com.count)
				com.count--;
			else if (com.bp > com.base)
				com.bp--;
			if (*--q <= ' ')
				break;
		}
		if (q == p) {
			com.count = 0;
			com.bp = com.base;
		}
	}
	return com_update(1);
}

int com_hndevent(int event)
{
	int lp;
	int result = 1;

	switch (event) {
	case LEFT:
		if (com.count)
			com.count--;
		else if (com.bp > com.base)
			com.bp--;
		break;
	case RIGHT:
		if (com.count < strlen(com.bp))
			com.count++;
		break;
	case DEL:
		if (*com.bp != 0)
			strcpy(&com.bp[com.count], &com.bp[com.count + 1]);
		break;
	case BKSP:
		if (com.count) {
			com.count--;
			strcpy(&com.bp[com.count], &com.bp[com.count + 1]);
		}
		break;
	case CTRLLEFT:
		return com_prevword();
	case HOME:
		com.count = 0;
		com.bp = com.base;
		break;
	case CTRLRIGHT:
		if (com_nextword() != END)
			break;
	case END:
		if (strlen(com.bp) >= 80 - com.rc.x) {
			com.bp += strlen(com.bp) - 79 + com.rc.x;
			com.count = 79 - com.rc.x;
		} else {
			com.count = strlen(com.bp);
		}
		break;
	case UP:
		if (!panel_state(cpanel))
			cmdoskey_up();
		else
			return 0;
		break;
	case DOWN:
		if (!panel_state(cpanel))
			cmdoskey_dn();
		else
			return 0;
		break;
	default:
		if ((unsigned char)event > 31) {
			if (com.bp - com.base + (80 - com.rc.x) >= (WMAXPATH-1)) {
				beep(5,5);
				return 0;
			}
			for (lp = strlen(com.bp) + 1; lp > com.count; lp--)
				com.bp[lp] = com.bp[lp - 1];
			com.bp[com.count++] = (unsigned char)event;
		} else {
			result = 0;
		}
		break;
	}
	return com_update(result);
}