/*
 * WSREAD.C
 *
 *  This file is part of DOSZIP
 *  Copyright (c) 1996 Hjort Nidudsson.
 */
#include <wsub.h>
#include <arch.h>
#include <string.h>
#include <errno.h>
#include <tdialog.h>

extern const char cp_emaxfb[];

int wsread(WSUB *q)
{
	int count;

	count = 0;
	switch (*q->flag & _W_ARCHIVE) {
	case _W_ZIP: count = wzipread(q); break;
	case _W_ARJ: count = warjread(q); break;
	case _W_GZ:  count = wgzread(q); break;
	default:
		*q->flag &= ~_W_ARCHIVE;
		count = wsreadsub(q);
	}
	if (count == ARCHIVE_ERROR) {
		*q->flag &= ~_W_ARCHIVE;
		count = wsreadsub(q);
	}
	if (count > 1)
		wssort(q);
	if (count == q->maxfb)
		stdmsg("", cp_emaxfb, q->maxfb, q->maxfb);
	return count;
}

