/*
 * WSOPEN.C
 *
 *  This file is part of DOSZIP
 *  Copyright (c) 1996 Hjort Nidudsson.
 */
#include <wsub.h>
#include <alloc.h>
#include <string.h>

int wsopen(WSUB *p)
{
	int size;

	size = (sizeof(void *) * p->maxfb);
	if ((p->fcb = malloc(size)) == NULL)
		return 0;
	memset(p->fcb, 0, size);
	return 1;
}

int wsclose(WSUB *p)
{
	int result;

	result = wsfree(p);
	free(p->fcb);
	p->fcb = NULL;
	return result;
}
