/*
 * ZIPIO.C
 *
 *  This file is part of DOSZIP
 *  Copyright (c) 1996 Hjort Nidudsson.
 */

#include <io.h>
#include <arch.h>
#include <errno.h>
#include <progress.h>

LZIP zip_local;

#ifdef DEBUG
 unsigned long	zip_numhuf;	/* track memory usage */
#endif
unsigned int 	zip_bsize;
unsigned int 	zip_bindex;
unsigned char *	zip_inbuf;
unsigned char *	zip_slide;
unsigned long 	zip_crcval;
unsigned long 	zip_wrcount;

int wzipgetbyte(void)
{
	WORD n;
	BYTE *p;

	if (zip_bindex == _MAXIOBUF) {
		if ((zip_bsize = osread(arc_srchnd, zip_inbuf, _MAXIOBUF)) == 0)
			return -1;
		if (zip_attrib & _A_ENCRYPTED) {
			for (n = zip_bsize, p = zip_inbuf; n--; p++)
				wzipdecode(*p);
		}
		zip_bindex = 0;
	}
	return zip_inbuf[zip_bindex++];
}

int wzipreadcentral(int h, CZIP *z, int s)
{
	int o;

	if ((o = osread(h, z, sizeof(CZIP))) != sizeof(CZIP))
		return wzipseekback(h, o);
	if (z->signature != ZID_CENTRAL)
		return wzipseekback(h, o);
	if ((o = osread(h, entryname, z->fnsize)) != z->fnsize)
		return wzipseekback(h, o + sizeof(CZIP));
	if (s && z->extsize + z->cmtsize)
		lseek(h, z->extsize + z->cmtsize, SEEK_CUR);
	return 1;
}

int wzipreadlocal(int h, LZIP *z, int s)
{
	int o;

	if ((o = osread(h, z, sizeof(LZIP))) != sizeof(LZIP))
		return wzipseekback(h, o);
	if (z->signature != ZID_LOCAL)
		return wzipseekback(h, o);
	if ((o = osread(h, entryname, z->fnsize)) != z->fnsize)
		return wzipseekback(h, o + sizeof(LZIP));
	if (s && z->extsize + z->csize)
		lseek(h, z->csize + z->extsize, SEEK_CUR);
	return 1;
}

int wzipseekback(int h, int o)
{
	lseek(h, 0L - o, SEEK_CUR);
	return 0;
}

int wzipwritecentral(int h, CZIP *z)
{
	if (oswrite(h, z, sizeof(CZIP)) != sizeof(CZIP))
		return 0;
	if (oswrite(h, entryname, z->fnsize) != z->fnsize)
		return 0;
	return 1;
}

int wzipwritelocal(int h, LZIP *z)
{
	if (oswrite(h, z, sizeof(LZIP)) != sizeof(LZIP))
		return 0;
	if (oswrite(h, entryname, z->fnsize) != z->fnsize)
		return 0;
	return 1;
}

int wzipwrslide(unsigned c)
{
	unsigned n;

	wzipupdatecrc(zip_slide, c);
	if (c == 0 || arc_enospc)
		return 0;
	n = oswrite(arc_outhnd, zip_slide, c);
	if (n != c) {
		arc_enospc = 1;
		return ENOSPC;
	}
	zip_wrcount += c;
	_ASSERTE(zip_wrcount > zip_local.fsize);
	return progress_update(zip_wrcount);
}