/*
 * IFSMGR.H
 *
 *  This file is part of DOSZIP
 *  Copyright (c) 1996 Hjort Nidudsson.
 */
#ifndef __INC_IFSMGR
#define __INC_IFSMGR
#if !defined(__INC_DEFS)
 #include <defs.h>
#endif

#ifdef __cplusplus
 extern "C" {
#endif

typedef struct {
	unsigned long	attrib;
	unsigned	time_create;
	unsigned	date_create;
	unsigned long	create;
	unsigned	time_access;
	unsigned	date_access;
	unsigned long	access;
	unsigned	time_modified;
	unsigned	date_modified;
	unsigned long	modified;
	unsigned long	size_high;
	unsigned long	size_low;
	char		reserved[8];
	char		name[260];
	char		shname[14];
      } wfblk;

extern  WORD _CType _ifsmgr;
extern  WORD _CType _ifssysflag;
extern  WORD _CType _ifsmaxfile;
extern  WORD _CType _ifsmaxpath;

int _CType wfindfirst(const char *, wfblk *, unsigned);
int _CType wfindnext(wfblk *, int __handle);
int _CType wcloseff(int __handle);
char *_CType wlongname(const char *__sp, const char *__f);
char *_CType wlongpath(const char *__sp, const char *__f);
char *_CType wshortname(const char *__sp);
int _CType wsetaccessdate(int __handle, int __date, int __time);
int _CType wsetcreationdate(int __handle, int __date, int __time);
int _CType wsetfattr(const char *__file, int __attrib);
int _CType wgetfattr(const char *__file);
int _CType wsetacdate(const char *__file, int __date);
int _CType wsetwrdate(const char *__file, int __date, int __time);
int _CType wsetcrdate(const char *__file, int __date, int __time);
int _CType wgetacdate(const char *__file);
long _CType wgetwrdate(const char *__file);
long _CType wgetcrdate(const char *__file);
char * _CType wgetcwd(char *, int);
char * _CType wfullpath(char *, int);
int _CType wvolinfo(const char *__drive, char *__buf32);

#ifdef __cplusplus
 }
#endif
#endif