/*
 * PRECT.C
 *
 *  This file is part of DOSZIP
 *  Copyright (c) 1996 Hjort Nidudsson.
 */

#include <dzmain.h>

#define rc_frame(rc,wp,z,t,at) rcframe(rc,wp,z,MKW(t,at))

enum {	CELL_VSL,
	CELL_VLL,
	CELL_VSD,
	CELL_VLD,
	CELL_HSL,
	CELL_HLL,
	CELL_HSD,
	CELL_HLD };

typedef struct {
	const char *	info;
	const char *	frame;
	void  		(*putfcb)(const FBLK *, int, int);
	RECT  		cl;
      } PRECT;

static char
	_i_vsl	[] = "\n\t  Name\t\tName\t\t Name",
	_i_vll	[] = "\n\t\tName\t\t\t  Name",
	_i_vsd	[] = "\n\t  Name\t  Byte\t Date\tTime",
	_i_vld	[] = "\n\t\t\t Name\t\t\t   Byte",
	_f_vsl	[3] = { 14,13,  0 			},
	_f_vll	[3] = { 20, 0,  0 			},
	_f_vsd	[5] = { 14, 0, 10,24,  0		},
	_f_vld	[3] = { 12,28,  0 			},
	_f_hsl	[9] = { 14,14, 14,27, 14,40, 14,53,  0 	},
	_f_hll	[5] = { 21, 0, 20,39,  0		},
	_f_hsd	[9] = { 12,14,  7,34, 12,53,  7,73,  0 	},
	_f_hld	[5] = { 12,53,  7,73,  0		};

static PRECT xcell_rect[] = {
	{ _i_vsl, _f_vsl, fbputsl, { 1, 2,12, 1} },
	{ _i_vll, _f_vll, fbputll, { 1, 2,18, 1} },
	{ _i_vsd, _f_vsd, fbputsd, { 1, 2,38, 1} },
	{ _i_vld, _f_vld, fbputld, { 1, 2,38, 1} },
	{ _i_vsl, _f_hsl, fbputsl, { 2, 2,12, 1} },
	{ _i_vll, _f_hll, fbputll, { 2, 2,18, 1} },
	{ _i_vsd, _f_hsd, fbputsd, { 2, 2,38, 1} },
	{ _i_vsd, _f_hld, fbputld, { 1, 2,78, 1} } };

extern 	DOBJ paneldlga[];
#define panel_wbox paneldlga

static RECT make_panelA_rc(void)
{
	RECT rc;

	rc.x = 0;
	rc.y = 1;
	rc.col = 40;
	rc.row = *__egaline - 2;
	if (cflag & _C_HORIZONTAL) {
		rc.col = 80;
		rc.row >>= 1;
	}
	if (cflag & _C_SMALLPANELS) {
		rc.row >>= 1;
		rc.row += 5;
		if (cflag & _C_HORIZONTAL)
			rc.row -= 2;
	}
	return rc;
}

static RECT convert_AtoB(RECT rc)
{
	if (cflag & _C_HORIZONTAL)
		rc.y += rc.row;
	else
		rc.x = 40;
	return rc;
}

static void _lc_putframe(void *p, RECT rc, const char *c)
{
	int q = rc.col;

	while ( *c ) {
		rc.col = *c++;
		rc.x   = *c++;
		rcframe(rc, p, q, MKW(2, at_Frame));
	}
}

static int _lc_getxlid(int flag)
{
	int q = 0;
	if (cflag & _C_HORIZONTAL)
		q += 4;
	if (flag & _W_LONGNAME)
		q++;
	if (flag & _W_DETAIL)
		q += 2;
	return q;
}


void prect_open(panel *p)
{
	int	x,q;
	RECT	rc,xl;
	PRECT *	rp;
	WCHR *	sp;

	rc = make_panelA_rc();
	if (*p->flag & _W_PANELID)
		rc = convert_AtoB(rc);
	x  = _lc_getxlid(*p->flag);
	rp = &xcell_rect[x];
	xl   = rp->cl;
	xl.x += rc.x;
	xl.y += rc.y;
	p->xl->cpos = xl;
	p->xl->rows = rc.row - 3;
	p->xl->cols = rc.col / xl.col;
	q = (*p->flag & _W_PANELID);
	if (panel_wbox[q].flag & _D_DOPEN) {
		pcell_hide(p);
		twclose(p->dialog);
	}
	panel_wbox[q].rc = rc;
	if (twopen(p->dialog, at_Frame, NULL) == 0)
		return;
	rc.y = 0;
	rc.x = 0;
	sp = p->dialog->wp;
	wcputw(sp + rc.col, rc.col, MKW(at_Panel, ' '));
	if (*p->flag & _W_MINISTATUS) {
		rc.row -= 2;
		p->xl->rows -= 2;
		rc_frame(rc, sp, rc.col, 0, at_Frame);
	}
	_lc_putframe(sp, rc, rp->frame);
	p->putfcb = rp->putfcb;
	switch (x) {
	case CELL_VSL:
	case CELL_VLL:
	case CELL_VSD:
	case CELL_VLD:
		wcputs(sp, rc.col, 0, rp->info);
		break;
	case CELL_HSL:
	case CELL_HSD:
		wcputs(sp + 1, rc.col, 0, rp->info);
		wcputs(sp + 40, rc.col, 0, rp->info);
		break;
	case CELL_HLL:
		wcputs(sp + 2, rc.col, 0, rp->info);
		wcputs(sp + 40, rc.col, 0, rp->info);
		break;
	case CELL_HLD:
		wcputs(sp + 40, rc.col, 0, rp->info);
		wcputs(sp + rc.col + 18, rc.col, 0, "Name");
		wcputc(sp + rc.col + 46, 4, ' ');
	default:
		break;
	}
	wcputw(sp + rc.col + 2, 1, MKW(at_Panel, ':'));
	wcputw(sp + rc.col + 3, 1, MKW(at_Panel, 25));
	rc = p->dialog->rc;
	rc.y = 0;
	rc.x = 0;
	rcframe(rc, sp, rc.col, MKW(1, at_Frame));
	if (*p->flag & _W_MINISTATUS)
		wcputc(sp + rc.col * (rc.row - 2) - 3, 1, 31);
	else
		wcputc(sp + rc.col * rc.row - 3, 1, 30);
	prect_show(p);
}

int prect_close(panel *p)
{
	if (*p->flag & _W_VISIBLE) {
		prect_hide(p);
		twclose(p->dialog);
		return 1;
	}
	return 0;
}

int prect_show(panel *p)
{
	int result;

	result = twshow(p->dialog);
	*p->flag |= _W_VISIBLE;
	return result;
}

int prect_hide(panel *p)
{
	if (*p->flag & _W_VISIBLE) {
		pcell_hide(p);
		twhide(p->dialog);
		*p->flag &= ~_W_VISIBLE;
		return 1;
	}
	return 0;
}
