/*
 * CMVIEW.C
 *
 *  This file is part of DOSZIP
 *  Copyright (c) 1996 Hjort Nidudsson.
 */

#include <string.h>
#include <stdlib.h>
#include <arch.h>
#include <dzmain.h>
#include <progress.h>

const char cp_section_view[] = "View";

int load_iniproc(const char *sec, const char *file, int type)
{
	char *p, *q;
	char b[WMAXPATH];

	switch (type) {
	case 4: q = "F4";	break;
	case 3: q = "Alt";	break;
	case 2: q = "Ctrl";	break;
	case 1: q = "Shift";	break;
	case 0: q = "F3";	break;
	default:
		return 0;
	}
	if ((p = inientry(sec, q)) == NULL)
		return 0;
	strncpy(b, p, WMAXPATH - 1);
	if (strlen(p) + strlen(file) < WMAXPATH) {
		strcat(b, " ");
		strcat(b, file);
		return ex_command(b);
	}
	return 0;
}

int load_tview(char *file, int type)
{
	char *p;
	long o;

	if (load_iniproc(cp_section_view, file, type) == 0) {
		cmclrcmdl();
		ex_addmacro(file, "\"", "", 1);
		if ((p = strchr(file, '/')) != NULL) {
			*--p = 0;
			o = atol(p+3);
		} else {
			o = 0L;
		}
		tview(file, o);
		return 0;
	}
	return 1;
}

int viewzip(FBLK *b, int type)
{
	char tmp[WMAXPATH];
	int  result;

	if (envtemp == NULL)
		return 0;
	progress_open(cp_unziptotemp, cp_copy);
	result = wzipcopy(cpanel->ide, b, envtemp);
	progress_close();
	if (result != 0)
		return 0;
	strfcat(tmp, envtemp, b->name);
	strcpy(config.pending_file, tmp);
	if (load_tview(tmp, type) == 0) {
		setfattr(tmp, 0);
		remove(tmp);
	}
	return 1;
}

int cmview(void)
{
	FBLK *b;
	int type = 0;
	char tmp[WMAXPATH];

	if (shift->ShiftRight || shift->ShiftLeft)
		type = 1;
	else if (shift->Ctrl)
		type = 2;
	else if (shift->Alt)
		type = 3;
	if ((b = panel_curobj(cpanel)) != NULL) {
		if (ISARCHIVE(b->flag)) {
			if (ISSUBDIR(b->flag) || !ISZIP(b->flag))
				return 0;
			return viewzip(b, type);
		}
		if (!ISSUBDIR(b->flag)) {
			tmp[0] = '"';
			if ((*cpanel->flag & _W_NETWORK) == _W_NETWORK)
				strfcat(tmp+1, cpanel->ide->path, b->name);
			else
				strcpy(tmp+1, b->name);
			strcat(tmp, "\"");
			return load_tview(tmp, type);
		}
	}
	if ((b = cpanel_findfirst()) == NULL)
		return 0;
	if (ISARCHIVE(b->flag))
		return 0;
	if (ISSELECTED(b->flag) || ISSUBDIR(b->flag))
		return cmsubsize();
	return 0;
}