/*
 * CMHELP.C
 *
 *  This file is part of DOSZIP
 *  Copyright (c) 1996 Hjort Nidudsson.
 */

#include <dzmain.h>
#include <string.h>

enum {	OD_MEMORY,
	OD_COMPRESS,
	OD_VIEWER,
	OD_ENVIRON,
	OD_WINDOWS,
	OD_INSTALL,
	OD_TOOLS,
	OD_SHORTKEY,
	OD_README,
	OD_ABOUT,
	OD_OK,
	OD_COUNT	};

static
WORD offset_README_TXT[OD_COUNT - 2] = {
	1526, /* Memory     */
	2796, /* Compress   */
	4489, /* View       */
	6165, /* Environ    */
	7103, /* Windows    */
	7438, /* Install    */
	7976, /* Tools      */
	9443, /* Shortkey   */
	0,    /* README.TXT */
};

int cmabout(void)
{
	stdmsg(cp_about, cp_copyright);
	return 0;
}

int cmhelp(void)
{
	int x;
	DOBJ *d;
	char b[WMAXPATH];

	if ((d = rsopen(IDD_DoszipHelp)) == NULL)
		return 0;
	thelp = cmabout;
	d->object[OD_ABOUT].proc = cmabout;
	strfcat(b, programpath, READMEFILE);
	while ((x = rsevent(IDD_DoszipHelp, d)) > 0) {
		tview(b, offset_README_TXT[x - 1]);
	}
	tdclose(d);
	return 1;
}
