;
; INFLATE.ASM
;
; This file is part of DOSZIP
; Copyright (c) 1996 Hjort Nidudsson.
;

INCLUDE		unzip.inc
INCLUDE		alloc.inc

		locals

_TEXT		SEGMENT

dumpb		MACRO	cnt
		mov	cx,cnt
		shr	bb,cl
		sub	bk,cx
		ENDM

needb		MACRO	cnt
		mov	ax,cnt
		call	needbits
		ENDM

wzipfreehuf	PROC 	PASCAL DIST
ARG		huft:	DWORD
		mov	eax,huft
@@prev:		or	eax,eax
		jz	SHORT @@toend
		sub	ax,6
		push	eax
		pop	bx
		pop	ES
		push	DWORD PTR ES:[bx+2]
		push	eax
		call	free
		pop	eax
		jmp	SHORT @@prev
@@toend:	ret
wzipfreehuf	ENDP

wzipinflate	PROC 	PASCAL FAR
		USES	di
	DBUG	USES	si
		xor	eax,eax
		mov	wp,ax
		mov	bk,ax
		mov	bb,eax
		mov	result,ax
	DBUG	mov	si,ax
@@loop:
	DBUG	xor	ax,ax
	DBUG	mov	zip_numhuf,ax
		call	inflate_block
		cmp	result,0
		jnz	SHORT @@error
		or	ax,ax
		jnz	SHORT @@toend
	DBUG	cmp	si,zip_numhuf
	DBUG	ja	<SHORT @@mloop>
	DBUG	mov	si,zip_numhuf
@@mloop:	jmp	SHORT @@loop
@@toend:	push	wp
		call	wzipwrslide
		or	ax,ax
		jz	SHORT @@error
		cmp	ax,ER_USERABORT
		jne	SHORT @@diskfull
		mov	result,ax
		jmp	SHORT @@error
@@diskfull:	mov	result,ER_DISKFULL
@@error:
	DBUG	mov	zip_numhuf,si
		call	freeblock
		mov	ax,result
		ret
wzipinflate	ENDP

inflate_block	PROC 	PASCAL
		USES	di
		needb	1
		mov	di,ax
		and	di,1
		dumpb	1
		needb	2
		mov	dx,ax
		and	dx,3
		dumpb	2
		cmp	dx,2
		je	SHORT @@dynamic
		cmp	dx,1
		je	SHORT @@fixed
		or	dx,dx
		jz	SHORT @@stored
		jmp	SHORT @@error
@@fixed:	call	inflate_fixed
		jmp	SHORT @@result
@@stored:	call	inflate_stored
		jmp	SHORT @@result
@@dynamic:	call	inflate_dynamic
@@result:	mov	result,ax
		jmp	SHORT @@toend
@@error:	mov	result,ER_ZIP
@@toend:        mov	ax,di
		ret
inflate_block	ENDP

inflate_codes	PROC 	PASCAL
		USES	si,di
LOCAL		n:	WORD,\
		d:	WORD,\
		ml:	WORD,\
		md:	WORD,\
		t:	DWORD
ARG		tl:	DWORD,\
		td:	DWORD,\
		ntl:	WORD,\
		ntd:	WORD
		mov	di,wp
		mov	bx,ntl
		shl	bx,1
		mov	ax,[bx+mask_bits]
		mov     ml,ax
		mov	bx,ntd
		shl	bx,1
		mov	ax,[bx+mask_bits]
		mov     md,ax
@@loop:         needb	ntl
		mov	dx,ml
		mov	eax,tl
		mov	t,eax
		call	inflc_01
		jbe	SHORT @@endloop1
@@loop1:	cmp	si,99
		jne	SHORT @@11
		mov	ax,1
		jmp	@@toend
@@11:		les	bx,t
		mov	cl,ES:[bx+1]
		shr	bb,cl
		mov	ch,0
		sub	bk,cx
		sub	si,16
		needb	si
		call	inflc_02
		ja	SHORT @@loop1
@@endloop1:     xor	cx,cx
		mov	cl,ES:[bx+1]
		shr	bb,cl
		sub	bk,cx
		cmp	si,16
		jne	SHORT @@eob
		mov	ax,ES:[bx+2]
		les	bx,zip_slide
		mov	ES:[bx+di],al
		inc	di
		cmp	di,WSIZE
		jne	SHORT @@1
		push	di
		xor	di,di
		call	wzipwrslide
		or	ax,ax
		je	SHORT @@1
		jmp	@@diskfull
@@1:		jmp	SHORT @@loop
@@eob:		mov	ax,si
		cmp	ax,15
		jne	SHORT @@2
		jmp     @@endloop
@@2:		call	needbits
		mov	bx,si
		and	ax,mask_bits[bx+si]
		les	bx,t
		add	ax,ES:[bx+2]
		mov	n,ax
		dumpb	si
		needb	ntd
		mov	eax,td
		mov	t,eax
		mov	dx,md
		call	inflc_01
		jbe	SHORT @@endloop2
@@loop2:        mov	ax,1
		cmp	si,99
		jne	SHORT @@21
		jmp	@@toend
@@21:           xor	cx,cx
		mov	cl,ES:[bx+1]
		shr	bb,cl
		sub	bk,cx
		sub	si,16
		needb	si
		call	inflc_02
		ja	SHORT @@loop2
@@endloop2:     xor	cx,cx
		mov	cl,ES:[bx+1]
		shr	bb,cl
		sub	bk,cx
		push	WORD PTR ES:[bx+2]
		needb	si
		mov	bx,si
		mov	dx,mask_bits[bx+si]
		and	dx,ax
		mov	ax,di
		pop	bx
		sub	ax,bx
		sub	ax,dx
		mov	d,ax
		dumpb	si
		mov	wp,di
		mov	bx,n
@@loop3:        mov	dx,d
		call	subcount
		mov	d,dx
		add	d,cx
		call	docopy
		or	ax,ax
		jnz	SHORT @@diskfull
		or	bx,bx
		jnz	SHORT @@loop3
		mov	di,wp
		jmp	@@loop
@@diskfull:     cmp	ax,ER_USERABORT
		je	SHORT @@toend
		mov	ax,ER_DISKFULL
		jmp	SHORT @@toend
@@endloop:	mov	wp,di
		xor	ax,ax
@@toend:	ret
inflate_codes	ENDP

inflc_02:	les	bx,t
		mov	eax,ES:[bx+2]
		mov	t,eax
		mov	bx,si
		shl	bx,1
		mov	ax,WORD PTR bb
		and	ax,mask_bits[bx]
		imul	ax,ax,6
		add	WORD PTR t,ax
		les	bx,t
		jmp	SHORT inflc_03
inflc_01:	mov	ax,WORD PTR bb
		and	ax,dx
		imul	ax,ax,6
		add	WORD PTR t,ax
		les	bx,t
inflc_03:	mov	al,ES:[bx]
		mov	ah,0
		mov	si,ax
		cmp	ax,16
		ret

docopy		PROC
		push	si
		push	di
		push	DS
		les	di,zip_slide
		add	di,wp
		add	wp,cx
		lds	si,zip_slide
		add	si,dx
		mov	ax,wp
		sub	ax,dx
		cld
		cmp	ax,cx
		jb	SHORT @@doslow
	rep	movsb
		jmp	SHORT @@1
@@doslow:	lodsb
		stosb
		loop	SHORT @@doslow
@@1:            pop	DS
		pop	di
		pop	si
docopy		ENDP
wrslide		PROC
		xor	ax,ax
		cmp	wp,WSIZE
		jne	SHORT @@toend
		push	bx
		push	wp
		mov	wp,0
		call	wzipwrslide
		pop	bx
@@toend:	ret
wrslide		ENDP

subcount	PROC
		mov	ax,(WSIZE-1)
		and	ax,dx
		mov	dx,ax
		cmp	ax,wp
		ja	SHORT @@1
		mov	ax,wp
@@1:		mov	cx,WSIZE
		sub	cx,ax
		cmp	cx,bx
		jbe	SHORT @@2
		mov	cx,bx
@@2:		sub	bx,cx
		ret
subcount	ENDP

inflate_dynamic	PROC 	PASCAL
		USES	si,di
LOCAL		ll:	WORD:[288+32],\
		m:	WORD,\
		dtl:	DWORD,\
		dtd:	DWORD,\
		n:	WORD,\
		dbl:	WORD,\
		dbd:	WORD,\
		nb:	WORD,\
		nl:	WORD,\
		nd:	WORD
		needb	5
		and	ax,001Fh
		add	ax,257
		mov	nl,ax
		dumpb	5
		needb	5
		and	ax,001Fh
		add	ax,1
		mov	nd,ax
		dumpb	5
		needb	4
		and	ax,000Fh
		add	ax,4
		mov	nb,ax
		dumpb	4
		cmp	nl,288
		ja	SHORT @@bad_length
		cmp	nd,32
		ja	SHORT @@bad_length
		jmp	SHORT @@1
@@bad_length:	mov	ax,1
		jmp	@@toend
@@1:		xor	si,si
		jmp	SHORT @@l1
@@loop1:        needb	3
		mov	bx,si
		shl	bx,1
		mov	ax,border[bx]
		shl	ax,1
		lea	bx,ll
		add	bx,ax
		mov	ax,WORD PTR bb
		and	ax,7
		mov	SS:[bx],ax
		dumpb	3
		inc	si
@@l1:		cmp	si,nb
		jb	SHORT @@loop1
		jmp	SHORT @@l2
@@loop2:	mov	bx,si
		shl	bx,1
		mov	ax,border[bx]
		shl	ax,1
		lea	bx,ll
		add	bx,ax
		xor	ax,ax
		mov	SS:[bx],ax
		inc	si
@@l2:		cmp	si,19
		jb	SHORT @@loop2
		mov     dbl,7
		lea	ax,ll
		push	SS
		push	ax
		mov	ax,19
		push	ax
		push	ax
		xor	eax,eax
		push	eax
		push	eax
		lea	ax,dtl
		push	SS
		push	ax
		lea	ax,dbl
		push	SS
		push	ax
		call	wzipmakehtab
		or	ax,ax
		jz	SHORT @@2
		cmp	ax,1
		jne	SHORT @@3
		push	ax
		push	dtl
		call	wzipfreehuf
		pop	ax
@@3:		jmp	@@toend
@@2:		mov	ax,nl
		add	ax,nd
		mov	n,ax
		mov	bx,dbl
		shl	bx,1
		mov	ax,mask_bits[bx]
		mov	m,ax
		xor	ax,ax
		mov	si,ax
		mov     di,ax
@@loop3:	cmp	si,n
		jb	SHORT @@301
		jmp	@@endl3
@@301:		mov	eax,dtl
		mov	dtd,eax
		needb	dbl
		and	ax,m
		imul	ax,ax,6
		add	WORD PTR dtd,ax
		xor	ax,ax
		les	bx,dtd
		mov	al,ES:[bx+1]
		dumpb	ax
		mov	ax,ES:[bx+2]
		cmp	ax,16
		je	SHORT @@j16
		ja	SHORT @@j17
		mov	di,ax
		mov	dx,si
		inc	si
		shl	dx,1
		lea	bx,ll
		add	bx,dx
		mov	SS:[bx],ax
@@302:		jmp	SHORT @@loop3
@@j16:		needb	2
		and	ax,3
		add	ax,3
		dumpb	2
		mov	dx,ax
		add	ax,si
		cmp	ax,n
		jbe	SHORT @@303
		mov	ax,1
		jmp	@@toend
@@303:		mov	ax,dx
		dec	dx
		or	ax,ax
		jz	SHORT @@302
		mov	ax,si
		inc	si
		shl	ax,1
		lea	bx,ll
		add	bx,ax
		mov	ax,di
		mov	SS:[bx],ax
		jmp	SHORT @@303
@@j17:		cmp	ax,17
		jne	SHORT @@ja17
		needb	3
		and	ax,7
		add	ax,3
		mov	dx,ax
		dumpb	3
@@307:		add	ax,si
		cmp	ax,n
		jbe	SHORT @@304
		mov	ax,1
		jmp	@@toend
@@304:		xor	di,di
@@305:		mov	ax,dx
		dec	dx
		or	ax,ax
		jz	SHORT @@306
		mov	ax,si
		inc	si
		shl	ax,1
		lea	bx,ll
		add	bx,ax
		xor	ax,ax
		mov	SS:[bx],ax
		jmp	SHORT @@305
@@306:		jmp	@@loop3
@@ja17:		needb	7
		and	ax,007fh
		add	ax,11
		mov	dx,ax
		dumpb	7
		jmp	SHORT @@307
@@endl3:	push	dtl
		call	wzipfreehuf
		mov	ax,lbits
		mov	dbl,ax
		lea	ax,ll
		push	SS
		push	ax
		push	nl
		push	257
		push	DS
		push	OFFSET cplens
		push	DS
		push	OFFSET cplext
		lea	ax,dtl
		push	SS
		push	ax
		lea	ax,dbl
		push	SS
		push	ax
		call	wzipmakehtab
		or	ax,ax
		jz	SHORT @@4
		cmp	ax,1
		jne	SHORT @@5
		push	ax
		push	dtl
		call	wzipfreehuf
		pop	ax
@@5:		jmp	SHORT @@toend
@@4:		mov	ax,dbits
		mov	dbd,ax
		lea	ax,ll
		add	ax,nl
		add	ax,nl
		push	SS
		push	ax
		push	nd
		push	0
		push	DS
		push	OFFSET cpdist
		push	DS
		push	OFFSET cpdext
		push	SS
		lea	ax,dtd
		push	ax
		push	SS
		lea	ax,dbd
		push	ax
		call	wzipmakehtab
		push	dtl
		push	dtd
		push	dbl
		push	dbd
		call	inflate_codes
		or	ax,ax
		jz	SHORT @@6
		mov	ax,1
		jmp	SHORT @@toend
@@6:		push	dtl
		call	wzipfreehuf
		push	dtd
		call	wzipfreehuf
		xor	ax,ax
@@toend:	ret
inflate_dynamic	ENDP

inflate_stored	PROC 	PASCAL
		USES	si
		mov	ax,bk
		and	ax,7
		dumpb	ax
		needb	16
		mov	si,ax
		dumpb	16
		needb	16
		not	ax
		cmp	ax,si
		je	SHORT @@1
		mov	ax,1
		jmp	SHORT @@toend
@@1:		dumpb	16
@@loop:         cmp	si,0
		jz	SHORT @@endloop
		dec	si
		needb	8
		les	bx,zip_slide
		add	bx,wp
		mov	ES:[bx],al
		inc	wp
		cmp	wp,WSIZE
		jne	SHORT @@2
		push	wp
		call	wzipwrslide
		or	ax,ax
		jz	SHORT @@3
		cmp	ax,ER_USERABORT
		je	SHORT @@toend
		mov	ax,ER_DISKFULL
		jmp	SHORT @@toend
@@3:		mov	wp,0
@@2:		dumpb	8
		jmp	SHORT @@loop
@@endloop:	xor	ax,ax
@@toend:	ret
inflate_stored	ENDP

inflate_fixed	PROC 	PASCAL
		USES	di
LOCAL		llist:	WORD:[288]
		xor	eax,eax
		cmp	eax,fixed_tl
		jz	SHORT @@mklist
		jmp	@@decompress
@@mklist:	lea	di,llist
		push	SS
		pop	ES
		cld
		mov	cx,144
		mov	ax,8
	rep	stosw
		mov	cx,112
		mov	ax,9
	rep	stosw
		mov	cx,24
		mov	ax,7
	rep	stosw
		mov	cx,8
		mov	ax,8
	rep	stosw
		mov	fixed_bl,7
		push	ES
		lea	ax,llist
		push	ax
		push	288
		push	257
		push	DS
		push	OFFSET cplens
		push	DS
		push	OFFSET cplext
		push	DS
		push	OFFSET fixed_tl
		push	DS
		push	OFFSET fixed_bl
		call	wzipmakehtab
		or	ax,ax
		jz	SHORT @@1
		xor	edx,edx
		mov	fixed_tl,edx
		jmp	SHORT @@toend
@@1:		lea	di,llist
		mov	dx,di
		mov	cx,30
		mov	ax,5
		push	SS
		pop	ES
		cld
	rep	stosw
		mov	fixed_bd,5
		push	ES
		push	dx
		push	30
		push	0
		push	DS
		push	OFFSET cpdist
		push	DS
		push	OFFSET cpdext
		push	DS
		push	OFFSET fixed_td
		push	DS
		push	OFFSET fixed_bd
		call	wzipmakehtab
		cmp	ax,1
		jbe	SHORT @@decompress
		push	ax
		push	fixed_tl
		call	wzipfreehuf
		xor	eax,eax
		mov	fixed_tl,eax
		pop	ax
		jmp	SHORT @@toend
@@decompress:	push	fixed_tl
		push	fixed_td
		push	fixed_bl
		push	fixed_bd
		call	inflate_codes
		or	ax,ax
		jz	SHORT @@toend
		mov	ax,1
@@toend:	ret
inflate_fixed	ENDP

freeblock	PROC
		xor	eax,eax
		cmp	fixed_tl,eax
		jz	SHORT @@toend
		push	fixed_td
		call	wzipfreehuf
		push	fixed_tl
		call	wzipfreehuf
		xor	eax,eax
		mov     fixed_td,eax
		mov     fixed_tl,eax
@@toend:	ret
freeblock	ENDP

needbits	PROC
		push	di
		mov	di,ax
@@next:		cmp	bk,di
		jnb	SHORT @@toend
		call	wzipgetbyte
		mov	cx,bk
		movsx	eax,ax
		shl	eax,cl
		or	bb,eax
		add	bk,8
		jmp	SHORT @@next
@@toend:	pop	di
		mov	ax,WORD PTR bb
		ret
needbits	ENDP

wzipexplode	PROC 	PASCAL FAR
		USES	si,di
LOCAL		ex_tb:	DWORD,\
		ex_tl:	DWORD,\
		ex_td:	DWORD,\
		ex_bb:	WORD,\
		ex_bl:	WORD,\
		ex_bd:	WORD,\
		ex_l:	WORD:[256]
LOCAL		ex_s:	DWORD,\
		ex_t:	DWORD,\
		ex_ml:	WORD,\
		ex_mb:	WORD,\
		ex_md:	WORD,\
		ex_u:	WORD,\
		exbits:	WORD,\
		exmask:	WORD
		mov	ex_bl,7
		mov	ex_bd,7
		cmp	zip_local.z_csize,200000
		jb	SHORT @@1
		mov	ex_bd,8
@@1:
	DBUG	mov	zip_numhuf,0
		mov	ax,zip_local.z_flag
		and	ax,4
		jnz	SHORT @@2
		jmp	@@nolit
@@2:		mov	ex_bb,9
		mov	ax,256
		call	exp_gettree
		or	ax,ax
		jz	SHORT @@201
		jmp	@@toend
@@201:		push	SS
		lea	ax,ex_l
		push	ax
		push	256
		push	256
		xor	eax,eax
		push	eax
		push	eax
		push	SS
		lea	ax,ex_tb
		push	ax
		push	SS
		lea	ax,ex_bb
		push	ax
		call	wzipmakehtab
		or	ax,ax
		jz	SHORT @@202
		push	ax
		cmp	ax,1
		jne	SHORT @@203
		jmp	SHORT @@206
@@202:		mov	ax,64
		call	exp_gettree
		or	ax,ax
		jz	SHORT @@204
		jmp	SHORT @@end2
@@204:		push	SS
		lea	ax,ex_l
		push	ax
		push	64
		push	0
		push	DS
		push	OFFSET cplen3
		push	DS
		push	OFFSET exextra
		push	SS
		lea	ax,ex_tl
		push	ax
		push	SS
		lea	ax,ex_bl
		push	ax
		call	wzipmakehtab
		or	ax,ax
		jz	SHORT @@205
		push	ax
		cmp	ax,1
		jnz	SHORT @@206
		push	ex_tl
		call	wzipfreehuf
@@206:		push	ex_tb
		call	wzipfreehuf
@@203:		pop	ax
		jmp	SHORT @@end2
@@205:		mov	ax,64
		call	exp_gettree
		or	ax,ax
		jz	SHORT @@207
@@end2:		jmp	@@toend
@@207:          push	SS
		lea	ax,ex_l
		push	ax
		push	64
		push	0
		push	DS
		mov	ax,zip_local.z_flag
		and	ax,2
		jz	SHORT @@208
		push	OFFSET cpdist8
		push	DS
		push	OFFSET exextra
		push	SS
		lea	ax,ex_td
		push	ax
		push	SS
		lea	ax,ex_bd
		push	ax
		call	wzipmakehtab
		or	ax,ax
		jz	SHORT @@209
		jmp	@@erhtab
@@209:		call	exp_lit8
		jmp	SHORT @@return
@@208:		push	OFFSET cpdist4
		push	DS
		push	OFFSET exextra
		push	SS
		lea	ax,ex_td
		push	ax
		push	SS
		lea	ax,ex_bd
		push	ax
		call	wzipmakehtab
		or	ax,ax
		jz	SHORT @@210
		jmp	@@erhtab
@@210:		call	exp_lit4
@@return:	push	ax
		jmp	@@3
@@nolit:	mov	ax,64
		call	exp_gettree
		jz	SHORT @@301
		jmp	SHORT @@end3
@@301:		push	SS
		lea	ax,ex_l
		push	ax
		push	64
		push	0
		push	DS
		push	OFFSET cplen2
		push	DS
		push	OFFSET exextra
		push	SS
		lea	ax,ex_tl
		push	ax
		push	SS
		lea	ax,ex_bl
		push	ax
		call	wzipmakehtab
		or	ax,ax
		jz	SHORT @@302
		cmp	ax,1
		jne	SHORT @@303
		push	ax
		push	ex_tl
		call	wzipfreehuf
		pop	ax
@@303:		jmp	SHORT @@end3
@@302:		mov	ax,64
		call	exp_gettree
		or	ax,ax
		jz	SHORT @@304
@@end3:		jmp	@@toend
@@304:		lea	ax,ex_l
		push	SS
		push	ax
		push	64
		push	0
		push	DS
		mov	ax,zip_local.z_flag
		and	ax,2
		jz	SHORT @@305
		push	OFFSET cpdist8
		push	DS
		push	OFFSET exextra
		push	SS
		lea	ax,ex_td
		push	ax
		push	SS
		lea	ax,ex_bd
		push	ax
		call	wzipmakehtab
		or	ax,ax
		jz	SHORT @@306
		jmp	SHORT @@erhtab3
@@306:		call	exp_nolit8
		jmp	SHORT @@return3
@@305:		push	OFFSET cpdist4
		push	DS
		push	OFFSET exextra
		push	SS
		lea	ax,ex_td
		push	ax
		push	SS
		lea	ax,ex_bd
		push	ax
		call	wzipmakehtab
		or	ax,ax
		jz	SHORT @@307
		jmp	SHORT @@erhtab3
@@307:		call	exp_nolit4
@@return3:	push	ax
		jmp	SHORT @@6
@@erhtab3:	push	ax
		cmp	ax,1
		jne	SHORT @@4
@@6:		push    ex_td
		call	wzipfreehuf
@@4:		push	ex_tl
		jmp	SHORT @@5
@@erhtab:       push	ax
		cmp	ax,1
		jne	SHORT @@erhtab1
@@3:		push	ex_td
		call	wzipfreehuf
@@erhtab1:	push	ex_tl
		call	wzipfreehuf
		push	ex_tb
@@5:		call	wzipfreehuf
		pop	ax
@@toend:	ret
wzipexplode	ENDP

exp_lit8	PROC
		mov	exbits,7
		mov	exmask,007Fh
		call	exp_lit
		ret
exp_lit8	ENDP

exp_lit4	PROC
		mov	exbits,6
		mov	exmask,003Fh
		call	exp_lit
		ret
exp_lit4	ENDP

exp_nolit8	PROC
		mov	exbits,7
		mov	exmask,007Fh
		call	exp_nolit
		ret
exp_nolit8	ENDP

exp_nolit4	PROC
		mov	exbits,6
		mov	exmask,003Fh
		call	exp_nolit
		ret
exp_nolit4	ENDP

exp_nolit	PROC
		call	exp_init
@@loop:		xor	eax,eax
		cmp	ex_s,eax
		jz	SHORT @@wrslide
		needb	1
		and	ax,1
		jz	SHORT @@2
		call	exp_wrone
@@3:		or	ax,ax
		jz	SHORT @@loop
		jmp	SHORT @@toend
@@2:		call	exp_docopy
		jmp	SHORT @@3
@@wrslide:	push	wp
		call	wzipwrslide
@@toend:	ret
exp_nolit	ENDP

exp_lit		PROC
		call	exp_init
@@loop:		xor	eax,eax
		cmp	ex_s,eax
		jz	SHORT @@wrslide
		needb	1
		and	ax,1
		jz	SHORT @@2
		dumpb	1
		dec	ex_s
		mov	ax,WORD PTR bb
		call	needbits
		mov	dx,ex_mb
		mov	eax,ex_tb
		call	exp_dowhile
		or	ax,ax
		jnz	SHORT @@toend
		mov	al,ES:[bx+1]
		dumpb	ax
		mov	ax,ES:[bx+2]
		call	exp_wrbyte
		or	ax,ax
		jnz	SHORT @@toend
		jmp	SHORT @@loop
@@2:		call	exp_docopy
		or	ax,ax
		jnz	SHORT @@toend
		jmp	SHORT @@loop
@@wrslide:	push	wp
		call	wzipwrslide
@@toend:	ret
exp_lit		ENDP

exp_gettree	PROC
		mov	di,ax
		call	wzipgetbyte
		inc	ax
		push	ax
		xor	si,si
@@loop:		call	wzipgetbyte
		mov	dx,ax
		and	ax,000Fh
		mov	cx,ax
		inc	cx
		and	dx,00F0h
		shr	dx,4
		inc	dx
		mov	ax,dx
		add	ax,si
		cmp	ax,di
		jbe	SHORT @@2
		pop	ax
		jmp	SHORT @@error
@@2:		lea	bx,ex_l
		mov	ax,si
		shl	ax,1
		add	bx,ax
		mov	SS:[bx],cx
		inc	si
		dec	dx
		jnz	SHORT @@2
		pop	ax
		dec	ax
		jz	SHORT @@3
		push	ax
		jmp	SHORT @@loop
@@3:            cmp	si,di
		jne	SHORT @@error
		jmp	SHORT @@toend
@@error:	mov	ax,4
@@toend:	ret
exp_gettree	ENDP

exp_init:	xor	eax,eax
		mov	bb,eax
		mov	bk,ax
		mov	wp,ax
		mov	ex_u,1
		mov	bx,ex_bb
		shl	bx,1
		mov	ax,mask_bits[bx]
		mov	ex_mb,ax
		mov	bx,ex_bl
		shl	bx,1
		mov	ax,mask_bits[bx]
		mov	ex_ml,ax
		mov	bx,ex_bd
		shl	bx,1
		mov	ax,mask_bits[bx]
		mov	ex_md,ax
		mov	eax,zip_local.z_usize
		mov	ex_s,eax
		ret

exp_wrbyte	PROC
		les	bx,zip_slide
		add	bx,wp
		inc	wp
		mov	ES:[bx],al
		xor	ax,ax
		cmp	wp,WSIZE
		jne	SHORT @@toend
		push	wp
		call	wzipwrslide
		or	ax,ax
		jnz	SHORT @@toend
		mov	wp,ax
		mov	ex_u,ax
@@toend:        ret
exp_wrbyte	ENDP

exp_wrone	PROC
		dumpb	1
		dec	ex_s
		needb	8
		call	exp_wrbyte
		dumpb	8
		ret
exp_wrone	ENDP

exp_dowhile	PROC
		mov	ex_t,eax
		mov	ax,WORD PTR bb
		not	ax
		and	ax,dx
		imul	ax,ax,6
		add	WORD PTR ex_t,ax
		les	bx,ex_t
		xor	ax,ax
		mov	al,ES:[bx]
		mov	si,ax
		xor	ax,ax
		cmp	si,16
		jbe	SHORT @@toend
@@do:		cmp	si,99
		jne	SHORT @@1
		mov	ax,1
		jmp	SHORT @@toend
@@1:		mov	al,ES:[bx+1]
		dumpb	ax
		sub	si,16
		needb	si
		les	bx,ex_t
		mov	eax,ES:[bx+2]
		mov	ex_t,eax
		mov	bx,si
		shl	bx,1
		mov	ax,WORD PTR bb
		not	ax
		and	ax,mask_bits[bx]
		imul	ax,ax,6
		add	WORD PTR ex_t,ax
		les	bx,ex_t
		xor	ax,ax
		mov	al,ES:[bx]
		mov	si,ax
		xor	ax,ax
		cmp	si,16
		jbe	SHORT @@toend
		jmp	SHORT @@do
@@toend:	ret
exp_dowhile	ENDP

exp_docopy	PROC
		dumpb	1
		needb	exbits
		and	ax,exmask
		mov	di,ax
		dumpb	exbits
		needb	ex_bd
		mov	dx,ex_md
		mov	eax,ex_td
		call	exp_dowhile
		or	ax,ax
		jnz	SHORT @@toend
		mov	al,ES:[bx+1]
		dumpb	ax
		mov	dx,ES:[bx+2]
		mov	ax,wp
		sub	ax,di
		sub	ax,dx
		mov	di,ax
		needb	ex_bl
		mov	dx,ex_ml
		mov	eax,ex_tl
		call	exp_dowhile
		or	ax,ax
		jnz	SHORT @@toend
		mov	al,ES:[bx+1]
		dumpb	ax
		mov	ax,ES:[bx+2]
		xchg	ax,si
		or	ax,ax
		jz	SHORT @@3
		needb	8
		and	ax,00FFh
		add	si,ax
		dumpb	8
@@3:            xor	eax,eax
		mov	ax,si
		sub	ex_s,eax
		jmp	SHORT @@copy
@@toend:	ret
@@copy:		mov	bx,si
@@loop:		mov	dx,di
		call	subcount
		mov	di,dx
		add	di,cx
		cmp	ex_u,0
		jz	SHORT @@docopy
		cmp	wp,dx
		ja	SHORT @@docopy
		push	di
		xor	ax,ax
		les	di,zip_slide
		add	di,wp
		add	wp,cx
		cld
	rep	stosb
		pop	di
		call	wrslide
		jmp	SHORT @@4
@@docopy:	call	docopy
@@4:		or	ax,ax
		jnz	SHORT @@toend
		cmp	wp,0
		jnz	SHORT @@5
		mov	ex_u,0
@@5:		or	bx,bx
		jnz	SHORT @@loop
		xor	ax,ax
		jmp	SHORT @@toend
exp_docopy	ENDP

_TEXT		ENDS

_DATA		SEGMENT

border		DW	16,17,18,0,8,7,9,6,10,5,11,4,12,3,13,2,14,1,15
cpdist		DW	1,2,3,4,5,7,9,13,17,25,33,49,65,97,129,193,257
		DW	385,513,769,1025,1537,2049,3073,4097,6145,8193
		DW	12289,16385,24577
cplens		DW	3,4,5,6,7,8,9,10,11,13,15,17,19,23,27,31,35,43,51
		DW	59,67,83,99,115,131,163,195,227,258,0,0
cplext		DW	0,0,0,0,0,0,0,0,1,1,1,1,2,2,2,2,3,3,3,3,4,4,4,4,5
		DW	5,5,5,0,99,99
cpdext		DW	0,0,0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7,8,8,9,9
		DW	10,10,11,11,12,12,13,13
mask_bits	DW	0000h
		DW	0001h,0003h,0007h,000fh,001fh,003fh,007fh,00ffh
		DW	01ffh,03ffh,07ffh,0fffh,1fffh,3fffh,7fffh,0ffffh
lbits		DW	9
dbits		DW	6
wp		DW	?
bb		DD	?
bk		DW	?
result		DW	?
fixed_bd	DW	0000h
fixed_bl	DW	0000h
fixed_td	DD	00000000h
fixed_tl	DD	00000000h
cplen2		DW	2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17
		DW	18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34
		DW	35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51
		DW	52,53,54,55,56,57,58,59,60,61,62,63,64,65
cplen3		DW	3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18
		DW	19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35
		DW	36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52
		DW	53,54,55,56,57,58,59,60,61,62,63,64,65,66
exextra		DW	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
		DW	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
		DW	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
		DW	8
cpdist4		DW	1,65,129,193,257,321,385,449,513,577,641,705
		DW	769,833,897,961,1025,1089,1153,1217,1281,1345,1409,1473
		DW	1537,1601,1665,1729,1793,1857,1921,1985,2049,2113,2177
		DW	2241,2305,2369,2433,2497,2561,2625,2689,2753,2817,2881
		DW	2945,3009,3073,3137,3201,3265,3329,3393,3457,3521,3585
		DW	3649,3713,3777,3841,3905,3969,4033
cpdist8		DW	1,129,257,385,513,641,769,897,1025,1153,1281
		DW	1409,1537,1665,1793,1921,2049,2177,2305,2433,2561,2689
		DW	2817,2945,3073,3201,3329,3457,3585,3713,3841,3969,4097
		DW	4225,4353,4481,4609,4737,4865,4993,5121,5249,5377,5505
		DW	5633,5761,5889,6017,6145,6273,6401,6529,6657,6785,6913
		DW	7041,7169,7297,7425,7553,7681,7809,7937,8065

_DATA		ENDS

		END
