/*
 * FGETS.C
 *
 *  This file is part of DOSZIP
 *  Copyright (c) 1996 Hjort Nidudsson.
 */

#include <stdio.h>

char *fgets(char *sp, int count, FILE *fp)
{
	int ch;
	char *p = sp;

	if (count <= 0)
		return NULL;
	while (--count) {
		if ((ch = _getc_lk(fp)) == EOF) {
			if (p == sp)
				return NULL;
			break;
		}
		if ((*p++ = (char)ch) == '\n')
			break;
	}
	*p = '\0';
	return sp;
}
