/*
 * XCELL.H
 *
 *  This file is part of DOSZIP
 *  Copyright (c) 1996 Hjort Nidudsson.
 */
#ifndef __INC_XCELL
#define __INC_XCELL
#include <twindow.h>

#define XCELL_COLOR	at_Reverse
#define XCELL_FLAG	_D_BACKGROUND

#ifdef __cplusplus
 extern "C" {
#endif

typedef struct {
	unsigned 	flag;	/* align: (DRECT *)xp */
	unsigned char	cols;	/* | | | number of cell's */
	unsigned char	rows;	/* - - - number of lines  */
	RECT		rc;	/* position of current cell */
	void *		bp;	/* RECT-buffer */
	RECT		cpos;	/* position of first cell */
      } xcell;
typedef xcell		XCEL;

int  xl_setcell(xcell *, unsigned char __id, unsigned char __count);
RECT xl_getrect(xcell *, int __index);

#define xl_colspan(p)	(p->cpos.col + 1)
#define xl_celcount(p)	(p->rows * p->cols)
#define xl_open(p)  	twopen ((DOBJ *)p, XCELL_COLOR, NULL)
#define xl_close(p) 	twclose((DOBJ *)p)
#define xl_show(p)  	twshow ((DOBJ *)p)
#define xl_hide(p)  	twhide ((DOBJ *)p)

#ifdef __cplusplus
 }
#endif
#endif /* __INC_XCELL */