/*
 * DZMAIN.H
 *
 *  This file is part of DOSZIP
 *  Copyright (c) 1996 Hjort Nidudsson.
 */

#ifndef __INC_DZMAIN
#define __INC_DZMAIN

#define DZVERSION	0x0128
#define DZMINVERS	0x0125 /* Update config if less */

#define READMEFILE	"README.TXT"

#ifdef DEBUG
// #define _DOSBMP_
 int debug_info(void);
#endif

#include <dir.h>
#include <wsub.h>
#include <stdio.h>
#include <xcell.h>
#include <dialog.h>

#include <dz/dzfblk.h>
#include <dz/dzpanel.h>
#include <dz/dzconfig.h>
#include <dz/dzmenu.h>

extern int _end;
extern int dzexitcode;
extern int numfblock;

extern int argv_verbose;
extern char *argv_cfgpath;
extern char *argv_filename;

extern char *comspec;
extern char *envconf;
extern char *envtemp;

extern char configfile[MAXPATH];
extern char programpath[MAXPATH];

extern const char cp_ldatefrm[];
extern const char cp_ltimefrm[];
extern const char cp_stdmask[];
extern const char cp_userabort[];
extern const char cp_recursive[];
extern const char cp_needpanel[];

extern const char cp_filter	[]; /* Filter */
extern const char cp_directory	[]; /* Directory */

#define CPY_SELECTED	0x0001  /* cpy_flag */
#define CPY_RECURSIV	0x0002
#define CPY_OUTARCH	0x0004
#define CPY_SRCARCH	0x0008
#define CPY_PATHEQU	0x0010

extern int cpy_flag;
extern int cpy_jump;
extern int cpy_subcount;
extern int cpy_filecount;

extern char __outpath[];
extern char __srcpath[];
extern char __outfile[];
extern char __srcfile[];

void init_screen(void);
void init_menus(void);
void init_tools(void);

int cpy_initpath(FBLK *, int _1copy_or_0move);

int copyfile(const char *, const char *);
int openfile(const char *, int __mode, int __action);
int confirm_continue(const char *);

char *searchp(char *);
void scroll_delay(void);
int return_update_fcb(int __result);
int tview(const char *, long);

#define COM_VISIBLE	0x0001

typedef struct {
	char	base[WMAXPATH];
	char  *	bp;
	int	count;
	RECT	rc;
	WSUB *	sub;
      }	CMDL;
extern 	CMDL 	com;

typedef struct {
	char	name[80];
	char	argc;
	char	argv;
	char	cmdl[126];
      } EXEC;
extern	EXEC *dzexe;
extern	int dzerrno;
extern	int dzerflag;
extern	int dzcount;

int ex_command(const char *__command);
char *ex_convert(char *__command);

int com_setdevice(WSUB *__sub);
void com_egaline(void);
void com_clear(void);
void com_initline(void);
int com_hndevent(int);

int doskey_save(void);
void doskey_delete(void);
int cmdoskey_up(void);
int cmdoskey_dn(void);


extern FILT *filtp;

int cmfilter(void);
int test_filter(const char *, DWORD __size, WORD __flag, WORD __date);
int load_iniproc(const char *__sec, const char *__file, int __type);
int FindFile(const char *__path);
void ex_addmacro(char *__cmd, const char *__mac,
	const char *__file, int __maclen);

void set_confirmflag(void);
DWORD mkbstring(char *, DWORD, DWORD);
int tools_modalidd(int, char *, const char *);

#endif