/*
 * DZCONFIG.H
 *
 *  This file is part of DOSZIP
 *  Copyright (c) 1996 Hjort Nidudsson.
 */
#ifndef __INC_DZCONFIG
#define __INC_DZCONFIG

#include <dir.h>
#include <ini.h>
#include <dz/dzpanel.h>

#define _C_PANELID	0x0001
#define _C_HORIZONTAL	0x0002
#define _C_SMALLPANELS	0x0004
#define _C_EGALINE	0x0008
#define _C_SELECTDIR	0x0010
#define _C_INSMOVDN	0x0020
#define _C_CDCLRDONLY	0x0040
#define _C_AUTOSAVE	0x0080
#define _C_DELDZCMD	0x0400
#define _C_DELZIPLST	0x0800

/* Compress flags */

#define _C_ZPACKERID	0x000F	/* from .INI file [Packer]->0?= ? */
#define _C_ZINCDIR	0x0010
#define _C_ZDECOMP	0x0020
#define _C_ZSMALLEST	0x0100
#define _C_ZFASTEST	0x0200
#define _C_ZBEST	0x0300
#define _C_ZAUTOSELECT	0x0000
#define _C_ZPASSWORD	0x0400

/* Confirm flags */

#define _C_CONFCOPY	0x01
#define _C_CONFMOVE	0x02
#define _C_CONFDELETE	0x04
#define _C_CONFDELSUB	0x08
#define _C_CONFSYSTEM	0x10
#define _C_CONFRDONLY	0x20
#define _C_CONFEXIT	0x40

/* Textview Config */
#define TV_HEXVIEW	0x01
#define TV_WRAPLINES	0x02
#define TV_SEARCHCASE	0x04	/* IOS_USECASE */
#define TV_SEARCHSCOPE	0x08
#define TV_HIGHCOLOR	0x10
#define TV_HEXOFFSET	0x20
#define TV_BINVIEW	0x40

/* Filesearch Config */
#define FS_SEARCHCASE	0x04	/* IOS_USECASE */
#define FS_SEARCHSUB	0x08

typedef struct {
	WORD	flag;
	WORD	max_date;
	WORD	min_date;
	DWORD	max_size;
	DWORD	min_size;
	char	include[128];
	char	exclude[128];
      } FILT;

typedef struct {
	WORD	version;
	WORD	dzflag;
	BYTE	confirm;
	BYTE	console;
	BYTE	tvflag;
	BYTE	fsflag;
	WORD	compress;
	WORD 	idb[MAXPANELS];
	WORD 	idx[MAXPANELS];
	PATH	ide[MAXPANELS];
	FILT 	opfilt;
	COLOR	dzcolor;
	char	pending_file[WMAXPATH];
      } DZCFG;
extern	DZCFG 	config;
#define cflag	config.dzflag
#define zflag	config.compress
#define tvflag	config.tvflag
#define fsflag	config.fsflag
#define aflag	config.ide[0].flag
#define bflag	config.ide[1].flag

int config_init(void);
int config_read(void);
int config_write(void);
int create_INI(void);

extern char default_ini[];
extern const char cp_dzcmd[];
extern const char cp_ziplst[];

#endif