/*
  Program:  RAREAD
  Version 0.2
  Re-Written By:  Brian E. Reifsnyder
  Copyright:  2000 Under the terms of the GNU GPL, Version 2.

  Note:  This is a clone of the RAREAD program.

*/

// I N C L U D E S //////////////////////////////////////////////////////////

#include <bios.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

// D E F I N E S ////////////////////////////////////////////////////////////

#define  VERSION "0.2"

#define  TRUE    1
#define  FALSE   0

// G L O B A L   V A R I A B L E S //////////////////////////////////////////

int drive_number;

int total_cylinders;
int total_heads;
int total_sectors;

char drive_letter[80];
char enter[80];
char filename[256];
char huge_sector_buffer[(18*512)];  /* Sector buffer for 18 sectors */

// G L O B A L   S T R U C T U R E S ////////////////////////////////////////

typedef struct Flags_Structure{

  int help;
  int no_wait;
  int file;
  int drive;

  }Flags;

Flags flags;

// P R O T O T Y P E S //////////////////////////////////////////////////////

void Clear_Huge_Sector_Buffer();
void Display_Help_Information();
void Get_Drive_Parameters();
void Re_Position_Cursor();
void Write_Disk_Image();


// F U N C T I O N S ////////////////////////////////////////////////////////

/* Clear Huge Sector Buffer */
void Clear_Huge_Sector_Buffer()
{
  long loop=0;

  do
    {
    huge_sector_buffer[loop]=0;

    loop++;
    }while(loop<((512*32)-1));
}

void Display_Help_Information()
{

  printf("\nRAREAD Version %s\n",VERSION);
  printf("Copyright 2000, by Brian E. Reifsnyder under the terms of the GNU GPL Version 2.\n\n");

  printf("RAREAD option information:\n\n"
	 "       -f <file>: specify disk image file\n"
	 "       -d <drive>: specify diskette drive to use;\n"
	 "               must be either A or B\n"
	 "       -n: don't wait for user to insert diskette --\n"
	 "               assumes diskette is waiting in selected drive\n"
	 "       -h: print this help message and exit\n\n");


  exit(0);
}

void Get_Drive_Parameters()
{
  asm{
    mov ah,0x08
    mov dl,BYTE PTR drive_number
    int 0x13

    mov BYTE PTR total_cylinders, ch
    mov BYTE PTR total_heads, dh
    mov BYTE PTR total_sectors, cl
    }

  /* Needs error checking */
}

void Re_Position_Cursor()
{
  /* Re-position cursor back to the beginning of the line */
  asm{
    /* Get current video display mode */
    mov ah,0x0f
    int 0x10

    /* Get cursor position */
    mov ah,0x03
    int 0x10

    /* Set cursor position to beginning of line */
    mov ah,0x02
    sub dh,1
    int 0x10
    }
}

void Write_Disk_Image()
{
  int cylinder=0;
  int head=0;

  long index;

  FILE *fp;
  fp=fopen(filename,"wb");
  if(!fp)
    {
    printf("\nError opening file for writing...operation terminated.\n");
    exit(1);
    }

  printf("\n");

  /* Write disk to file 1 track at a time */
  do
    {
      do
	{
	/* Read Track */
	biosdisk(2,drive_number,head,cylinder,1,total_sectors,huge_sector_buffer);
	/* Write Track to File */
	index=0;
	do
	  {
	  fputc(huge_sector_buffer[index],fp);
	  index++;
	  }while(index<(total_sectors*512));
	/* Display Information */
	Re_Position_Cursor();
	printf("\nReading-->    Cyl:  %2d",cylinder);
	printf("   Head:  %1d",head);

	head++;
	}while(head<=total_heads);
      head=0;

    cylinder++;
    }while(cylinder<=total_cylinders);

  fclose(fp);

  Re_Position_Cursor();
  printf("\nOperation Complete.                 \n");
}

// M A I N //////////////////////////////////////////////////////////////////
void main(int argc, char *argv[])
{
  int command_ok;
  int index;

  flags.no_wait=FALSE;
  flags.file=FALSE;
  flags.drive=FALSE;
  flags.help=FALSE;

  // parse command line arguments, if they exist.
  if(argc>1)
    {
    index=1;
    do
      {
      command_ok=FALSE;

      if(argv[index] [1]=='f' || argv[index] [1]=='F')
	{
	if( (index+1)>=argc)
	  {
	  printf("filename must follow -f option\n");
	  exit(1);
	  }
	else strcpy(filename,argv[(index+1)]);

	index++;
	command_ok=TRUE;
	flags.file=TRUE;
	}

      if(argv[index] [1]=='d' || argv[index] [1]=='D')
	{
	if( (index+1)>=argc)
	  {
	  printf("drive letter must follow -d option\n");
	  exit(1);
	  }
	else strcpy(drive_letter,argv[(index+1)]);

	index++;
	command_ok=TRUE;
	flags.drive=TRUE;
	}

      if(argv[index] [1]=='n' || argv[index] [1]=='N')
	{
	command_ok=TRUE;
	flags.no_wait=TRUE;
	}

      if(argv[index] [1]=='h' || argv[index] [1]=='H')
	{
	command_ok=TRUE;
	flags.help=TRUE;
	}

      if(argv[index] [1]=='?')
	{
	command_ok=TRUE;
	flags.help=TRUE;
	}

      if(command_ok==FALSE)
	{
	printf("raread: '%s' - unknown option.\n",argv[index]);
	printf("Use 'raread -h' for instructions.\n");
	exit(1);
	}

      index++;
      }while(index<argc);
    }

  if(flags.help==TRUE) Display_Help_Information();

  if(flags.drive==FALSE)
    {
    printf("Enter source diskette drive:  ");
    gets(drive_letter); /* Bad...no way to prevent buffer overruns */
    }

  if(flags.file==FALSE)
    {
    printf("Enter disk image destination file name:  ");
    gets(filename);     /* Bad...no way to prevent buffer overruns */
    }

  if(flags.no_wait==FALSE)
    {
    printf("Please insert a source diskette into drive %c: and press -ENTER-:"
     ,drive_letter[0]);
    gets(enter);
    }

  // Ensure that drive_letter is valid
  drive_letter[0]=toupper(drive_letter[0]);
  drive_number=drive_letter[0]-'A';
  if(drive_number>1)
    {
    printf("\nInvalid source diskette drive...operation terminated.\n");
    exit(1);
    }

  Get_Drive_Parameters();
  Write_Disk_Image();
}