; 02.11.2002 - METAKERN.SYS - a boot menu that replaces the FreeDOS kernel
; Updated 26.03.2003: Allow up to 4 boot sectors, 4 partitions, 3 drives.
; Updated 01.04.2003: Autogenerate kernel names for several FreeDOS boots.
; Updated 18.04.2003: Repaired and improved partition list display
; Updated 04.05.2003: You can now compile with -DCLS and -DTIMEOUT
; Updated 15.05.2003: Bugfix for the timeout option.
;
; Usage:
;    1. change to drive / partition X: (must be bootable to make sense)
;    2. prepare bootsect.* - I assume that you know how to do this. Feel
;       free to ask me for more information (find my email address below).
;    3. ren kernel.sys fdkernel.sys
;    4. copy /b metakern.sys + bootsect.1 + bootsect.2 kernel.sys
;
; (bootsect.1 and/or bootsect.2 must be valid boot sectors for X:
;   or you will be unable to boot from X: at all after this!!)
; (NEW 03/2003: you can do this with up to FOUR boot sectors)
; (NEW 04/2003: you can even do this for SEVERAL identical FreeDOS boot
;   sectors, which will be made to point to fdkernel.sys, fdkern1.sys,
;   fdkern2.sys, etc., at boot time - rather than pointing to kernel.sys)
; (NEW 05/2003: if you compile with -DCLS, the screen will be cleared
;   on entering / leaving MetaKern. Use -DCLSin and -DCLSout to clear the
;   screen in only one of the cases... Use -DTIMEOUT to activate auto-
;   selection of an entry after a timeout...)
;
; Choice:
;    MetaKern will give you the choice to boot either of the OTHER
;    partitions or one of the two boot sectors. A typical use would
;    be to give it a FreeDOS and a MS DOS for the partition you install
;    MetaKern on. MetaKern replaces the original kernel.sys and redirects
;    the two boot sectors to fdkernel.sys IF they point to kernel.sys,
;    so you want to: 1. give it a FreeDOS boot sector 2. have a complete
;    (not Meta) kernel available as fdkernel.sys in the root directory!
;
; Disclaimer:
;    This is a beta version. Use it at your own risk. You may end up being
;    unable to boot (then SYS again). License: GPL 2. Copyright 2002-2003
;    Eric Auer, eric@coli.uni-sb.de - please send feedback or patches. For
;    space reasons, please fetch the GPL text at www.gnu.org/licenses/ ...
;    Basically it means: Freeware and open source but copyrighted... etc.!
;
; Compile:
;    nasm -o metakern.sys metakern.asm
;    or if you want TIMEOUT and CLS features as described:
;    nasm -DCLS -DTIMEOUT -o metakern.sys metakern.asm

        org  0  ; flat binary file, gets loaded to 0x60:0 by the FreeDOS
		; boot sector, which passes on the current drive number
		; in BL and can find us, kernel.sys anywhere in the root
		; directory (may even be fragmented)...
		; stack will be at 0x1fe0:7be0 or something,
		; fat will be loaded to RAM, too. See the FreeDOS sources.

; set this to 1 if you do not want MetaKern to attempt to offer
; partition table entries in the menu when booting from floppy:
%define WEAKFLOPPY 0

; set this to 1 if you do not want to see the active partition
; entry when booting from harddisk - because it will probably
; simply point to where you came from, and unless your MBR is
; broken, it will be equivalent to the "boot from C:" selection:
%define HIDEACTIVE 1

; set this to 1 if you do want to see the active partition when
; booting from floppy
%define SHOWACTIVEIFFLOPPY 1

; Use -DCLS, -DCLSin or -DCLSout compile flags to cause clear screen
; on entering / leaving MetaKern. If you want another screen mode
; than 3 (80x25 color), change the code at the places after %ifdef CLS.

%ifdef TIMEOUT
;
; set this to some value (unit: (1/18.2) second) to auto-trigger
; some menu item after VALUE amount of time has elapsed and the
; user still did not type anything. Only enabled if TIMEOUT you
; gave the -DTIMEOUT flag at compile time.
%define TimeOutTicks 180	; roughly 10 seconds
; the timeout in seconds as a string for a message
%define TimeOutText "10"
; set this to the key that MetaKern should pretend to be pressed
; if the user did not type anything before the time out.
%define DefaultKey '1'
;
%endif		; only if TIMEOUT is defined...

; Please only change %define lines ABOVE this line if you have no
; real clue on the internal workings of MetaKern. Actually, even
; the above define lines could be replaced by using -D...=... with
; nasm. Then you could select all options without editing this file.

; *************************************************************

; if you change this to have more or less than 4 boot sector menu
; entries, you must change the code, too. However, you can simply
; copy /b less than 4 boot sectors if you want to USE less entries,
; which is probably all that you need!

%define boot1	(sign+2)
; %define boot2   (sign+0x202)
; %define boot3   (sign+0x402)
; %define boot4   (sign+0x602)

; the mbr buffer MUST be a multiple of 0x200 after the boot1 buffer!
%define mbr	(sign+0x802)

%ifdef CLS
%define CLSin CLS	; CLS sets both CLSin and CLSout
%define CLSout CLS	; CLS sets both CLSin and CLSout
%endif

; *************************************************************

start:	push cs
	pop ds		; init ds
	push cs
	pop es		; init es
	mov [cs:drive],bl	; remember drive
	mov [cs:realdrive],bl	; remember drive
	cld
	mov cx,0x100
	xor ax,ax
	mov di,mbr
	rep stosw	; clear buffer for MBR

%if WEAKFLOPPY
	or bl,bl
	jns nothard	; < 0x80? Then we run from floppy
			; we COULD load the MBR of drive 0x80 anyway
			; in that case (ignoring errors)
%else
	mov bl,0x80	; read MBR from harddisk C: in any case
%endif

getmbr:
	mov dl,bl	; THAT drive
	mov si,3	; trial count
getmbr2:
	mov ax,0x0201	; read 1 sector
	mov cx,1	; 1st sector, 0th cylinder
	mov dh,0	; 0th head
	mov bx,mbr	; load to there
	int 0x13	; BIOS: disk
	jnc gotmbr
	xor ax,ax	; reset disk
	int 0x13
	dec si
	jnz getmbr2	; try again
	jmp short gotmbr	; give up (no problem)

nothard:
	; mov bl,0x80	; activate those two lines to load the MBR anyway
	; jmp short getmbr

gotmbr:
%ifdef CLSin
	mov ax,3	; 80x25 color
	int 0x10	; clear / reset screen mode first
%endif
	mov si,message
	call print	; print hello world


bootsectormenu:
	mov si,sectormenumsg
	call print
	mov al,'1'	; the key
	mov ah,1	; the bit
	mov si,boot1	; the bootsector offset
bootmenuloop:
	call checkboot	; valid boot sector? print entry and info!
	jc noboothere
	or byte [cs:valid],ah	; mark choice as valid
noboothere:
	inc al		; next key
	shl ah,1	; next bit
	add si,0x200	; next bootsector
	cmp si,mbr	; mbr is exactly after all boot sectors
	jb bootmenuloop


partitionmenu:
	cmp word [cs:si+0x1fe],0xaa55
	jnz skipmbr	; if we could not load any mbr, skip this
	push si			; fix 18apr2003
	mov si,partnmenumsg
	call print
	pop si			; fix 18apr2003
	add si,0x1be	; point to 1st partition table entry
	; ah already is 16
	; al already is '5'
nextpartn:
	call checkpartn	; valid partition? print entry and info!
	jc nopartn
	or [cs:valid],ah	; mark choice as valid
nopartn:
	inc al		; next iteration
	shl ah,1	; next iteration
	add si,0x10	; next partition table entry
	cmp al,'9'
	jb nextpartn	; loop
skipmbr:


abcentries:		; *** new: reboot from A:/B:/C:
	; *** we could check if the drives are actually installed here!
			; moved this text into the greeting 03may2003
	; mov si,drivemenumsg, call print
			; removed explicit list 18apr2003
	; mov byte [cs:choice],'A', mov byte [cs:dmaster],'A'
	; mov si,diskmaster, mov cx,3
; abcloop: call printchoice, inc byte [cs:choice], inc byte [cs:dmaster]
	; loop abcloop

prompt:	

; *************************************************************

	; now we have a validity mask in valid and a list on the
	; screen that will offer the boot sectors (1,2) and
	; the partitions (3..6), possibly not all of them.

	; only in while we wait for the FIRST keystroke from the user
	; we also check for the auto-selection / timeout things.
	; So "prompt:" runs the timeout, but "query:" does not.

%ifdef TIMEOUT
timer:	push ds
	mov ax,0x40
	mov ds,ax		; [40:6c] is the 32bit time of day time
	mov ax,[ds:0x6c]	; we only need the lower 16 bits
	add ax, TimeOutTicks
	mov cx,ax		; the "deadline" point of time
timeloop:
	; sti			; use "sti, hlt" (wait for IRQ)...
	; hlt			; ...to save energy while waiting.
	mov ah,1
	int 0x16		; check for keystroke: ZF if none
	jnz timecancel2		; BUGFIX
	mov ax,[ds:0x6c]	; check current time
	cmp cx,ax		; is the deadline reached?
	jnz timeloop		; keep waiting otherwise
	mov al, DefaultKey	; assume that user wants the default
; timecancel:
	mov ah,al
	pop ds
	mov al,[cs:realdrive]	; the actual drive that booted us
	mov [cs:drive],al	; reset un-real boot drive number
	mov al,ah
	jmp short queried
timecancel2:			; BUGFIX
	pop ds			; BUGFIX (next, query: CONSUME key)
%endif				; end of the TIMEOUT code


query:
	mov al,[cs:realdrive]	; the actual drive that booted us
	mov [cs:drive],al	; reset un-real boot drive number
	xor ax,ax
	int 0x16	; BIOS keyboard: get keystroke
queried:
	xor cx,cx
	mov ah,0
	cmp al,'1'	; ah is the scancode, AL the ASCII
	jb requerybeep	; ignore char
	cmp al,'8'	; 1..4 for boot sectors, 5..8 for partitions
	ja requery2	; try A..C
	sub al,'1'
	mov si,ax	; remember choice
	mov cl,al
	mov ax,1
	shl ax,cl	; bit for mask checking
	test al,[cs:valid]
	jnz bootme
	; inactive menu entry, reject:

requerybeep:		; user pressed an invalid choice key
	mov al,7	; "beep"
	call printchar	
	jmp query	; ask again

requery2:		; non numeric key pressed
	cmp al,'A'
	jb requerybeep	; no hotkey at all
	cmp al,'z'
	ja requerybeep	; no hotkey at all
	or al,0x20	; make lower case
	cmp al,'a'
	jb requerybeep	; no hotkey at all
	cmp al,'c'
	ja requerybeep	; not allowed drive
	sub al,'a'
	jmp bootdisk	; user has selected A, B or C



bootme:	cmp si,4	; user has selected partition of boot sector
	jb bootdos	; 0..3 are sectors, 4..7 partitions
	sub si,4	; normalize to have 0..3 as selection



bootpartn:		; start a partition, assuming none are active
	push ax
	push si
	shl si,1	; create a stamp based on the selection
	shl si,1
	add si,enumnames	; "1st 2nd 3rd 4th"
	mov ax,[cs:si]
	mov [cs:partnslotname],ax
	mov ax,[cs:si+2]
	mov [cs:partnslotname+2],ax
	mov si, partnslotmsg
	call print	; announce boot, tell which entry gets used
	pop si
	pop ax

	mov cl,4	; 16byte/entry
	shl si,cl	; translate to partition table entry
	add si,mbr+0x1be	; partition table
	mov byte [si],0x80	; activate partition
	mov byte [cs:drive],0x80	; feel like some MBR
	mov si,4	; IMPORTANT: "5th boot sector" is MBR



bootdos:		; copy and activate a stored boot sector or MBR
	push ax
	push si
	shl si,1	; create a stamp based on the selection
	shl si,1
	add si,enumnames	; "1st 2nd 3rd 4th"
	mov ax,[cs:si]
	mov [cs:bootsectname],ax
	mov ax,[cs:si+2]
	mov [cs:bootsectname+2],ax
	mov si, bootsectmsg
	call print	; announce boot, tell which entry gets used
	pop si
	pop ax

	mov cl,9	; 512byte/sector
	shl si,cl	; translate to a choice
	add si,boot1	; here we are!
	mov di,0x7c00	; as common for boot sectors
	xor ax,ax
	mov es,ax	; target segment
	mov cx,0x100
	rep movsw	; copy boot sector to usual place
	mov dl,[cs:drive]	; see table 00653 in RBIL 61



boot7c00:
%ifdef CLSout
	mov ax,3	; 80x25 color
	int 0x10	; clear / reset screen mode before leaving
%endif
	mov si,readytogomsg
	call print	; last message
			; Here we LEAVE MetaKern (for ALL menu items!):
	mov dh,0x20	; "drive is supported by int 0x13"
	jmp word 0:0x7c00	; go for it! (and pass on DH and DL)



bootdisk:			; *** new: reboot from A:/B:/C:
	push ax
	add al,'A'		; drive letter: stamp into diskbootmsg
	mov [cs:diskbootname], al	; add drive letter to template
	pop ax
	cmp al,2
	jb bootfloppy		; A: or B:
	add al,0x80-2		; C: ...
bootfloppy:
	mov bl,al
	mov dl,bl		; THAT drive
	mov si,diskbootmsg
	call print		; Tell about our plans
	mov si,3		; trial count


getdisk:
	mov ax,0x0201		; read 1 sector
	mov cx,1		; 1st sector, 0th cylinder
	mov dh,0		; 0th head
	xor bx,bx
	mov es,bx
	mov bx,0x7c00		; load to there
	int 0x13		; BIOS: disk
	jc getdiskerr		; retry if disk error

gotdisk:			; DL is still set
	cmp word [es:0x7dfe],0xaa55
	jnz gotnodiskflag	; could load, but is not bootable
	jmp short  boot7c00	; jump to the boot sector, good luck!

getdiskerr:
	xor ax,ax		; reset disk
	int 0x13
	dec si
	jnz getdisk		; try again

gotnodisk:			; give up, disk error
	push cs
	pop es
requeryfail:		; loading that selection did not succeed
	mov si,loadfailmsg
	call print	; disk error - reprompt
	jmp query	; ask again

gotnodiskflag:
	push cs
	pop es
requerynosystem:
	mov si,loadinvmsg
	call print	; un-bootable boot sector -  reprompt
	jmp query


; *************************************************************

checkpartn:		; check and print type of partition
	push ax		; table entry at SI, deactivate entry
	push si
	mov [cs:choice],al	; store the hotkey
	xor ax,ax
	mov al,[si]	; partition active?
	mov [si],ah	; deactivate in any case!

%if SHOWACTIVEIFFLOPPY
	cmp byte [cs:realdrive],0x80
	jb checkactivepartn	; if boot was from A: do not hide active
%endif

%if HIDEACTIVE
	cmp al,0x80
	jz checkfail	; was already active, do not offer as choice!
%endif

checkactivepartn:
	mov al,[si+4]	; operating system / partition type indicator
	or al,al
	jz checkfail	; empty partition, do not offer!
	cmp al,5	; CHS extended
			; (d5/e1/e4 are deprecated "extended" as well)
	jz checkfail	; do not offer extended "meta" partitions
	cmp al,0x0f	; LBA extended
	jz checkfail	; do not offer either
		push ax
	mov ah,al	; ah will be '0'..'F' for low nible
	and ah,0x0f
	shr al,1
	shr al,1
	shr al,1
	shr al,1
	add ax,'00'	; start conversion to ASCII
	cmp al,'9'
	jbe nibok1
	add al,7	; 'A'-('0'+10)
nibok1: cmp ah,'9'
	jbe nibok2
	add ah,7
nibok2:	mov [cs:ptype],ax	; conversion to ASCII now ready
		pop ax		; new type detection - 18apr2003
	mov si,linptype
	cmp al,0x83		; is it Linux?
	jz cpspecify
	mov si,qnxptype		; WinNT / QNX / OS2 ?
	cmp al,7
	jz cpspecify
	mov si,dosptype
	cmp al,1		; FAT12
	jz cpspecify
	cmp al,4		; FAT16 small (DOS 3.x)
	jz cpspecify
	cmp al,6		; FAT16 big (DOS 4+: 32MB or more)
	jz cpspecify
	mov si,winptype
	cmp al,0x0b		; any Win9x FAT32 type?
	jb cpunspecify
	cmp al,0x0e
	jbe cpspecify
cpunspecify:
	mov si,xyzptype		; unknown other type
				; (0 empty 5/F extended skipped anyway)
cpspecify:
	push si
	mov si, choice
	call print		; print "N -> "
	pop si
	call print		; print partition description
	mov si,partition	; message telling the type as number
	call printstrcrlf	; print and add CR LF
	clc
	jmp short checknothing	; return, no further printing

; *************************************************************

checkfail:
	stc			; invalid choice

checkdone:			; use SI to print a menu entry
	jc checknothing		; no valid menu entry, print nothing
	pushf
	call printchoice	; SI is entry name
	popf
checknothing:
	pop si
	pop ax
	ret

; *************************************************************

checkboot:	; scan 512 bytes from SI for boot sector stuff...
	mov [cs:choice],al	; store the hotkey
	push ax
	push si
	cmp word [si+0x1fe],0xaa55	; bootable (magic value)?
	jnz checkfail		; nope! (everything else is accepted!)

	push bx
	push di
	push bp
	push cx
	push dx

	mov bp,si		; where to search
	mov bx,searchlist
	mov di,fdsearch		; first search string
checkone:
	mov ax,[di]
	or ax,ax
	jz notypefound
	call stringfind	; search in BP..BP+0x1f8, string DI, len 11
	jz typefound	; Z = hit, at offset SI, DI unchanged
nexttype:
	inc bx		; next message
	inc bx
	add di,11	; next search string
	jmp short checkone	; go on with searching
typefound:
	cmp di,fdsearch	; did we find THAT one?
	jnz notypefound	; else, no special actions needed

	mov cx,[ds:fdreplacecnt]	; fetch current replace snippet
	or cx,0x2020	; turn into lower case
	mov [ds:fdtypecnt],cx		; update snippet in entry name

	mov cx,11
	mov di,si	; overwrite (BEFORE counting up)
	mov si,fdreplace	; patch the name! (only first occurance)
	rep movsb	; replaced "kernel" by "fdkernel"...

typecounting:		; count up the replacement string: first
	push ax		; value is fdkernel.sys, next are fdkern2.sys,
	mov ax,[ds:fdreplacecnt]	; fdkern3.sys, etc.!
	cmp ax,"EL"	; if last was not numerical, start counting
	jnz typecount1
	mov ax,"1 "	; one LESS than the first numerical suffix
typecount1:
	inc ax		; fdkernel.sys fdkern1.sys fdkern2.sys, etc.
	mov word [ds:fdreplacecnt],ax
	pop ax
	
notypefound:
	mov si,[bx]	; message for our type

	pop dx
	pop cx
	pop bp
	pop di
	pop bx
	clc	; SI now holds a describtion of the found boot sector
	jmp short checkdone	; print the boot menu entry and return


stringfind:	; search for string at DI, len 11, in area BP..BP+0x1ff
		; return Z for hit at offset SI, DI unchanged
	push ax
	push cx
	xor ax,ax	; start search at buffer start
restringfind:
	mov si,bp	; buffer start
	add si,ax	; current search start
	mov cx,11
	push di
	push si		; needed for "return hit offset"
	repe cmpsb	; compare strings here
	pop si		; needed for "return hit offset"
	pop di
	jz foundstring	; ZF set - found
	inc ax		; next search start
	cmp ax,0x200-11	; still in range?
	jb restringfind
	or ax,ax	; clear ZF - not found
foundstring:
	pop cx
	pop ax
	ret

; *************************************************************

printchoice:	; print choice + " -> " + string SI + CR + LF
	push si
	mov si,choice	; the hotkey, followed by an arrow
	call print
	pop si
printstrcrlf:		; print string SI + CR + LF
	push si
	call print	; the menu item description
	pop si
printcrlf:		; print CR + LF
	push ax
	mov al,13
	call printchar	; carriage return
	mov al,10
	call printchar	; newline
	pop ax
	ret

print:		; print zero-terminated string at CS:SI
	push ax	; updates SI to point to the end of the string
	push ds
	mov ax,cs
	mov ds,ax
print2:	lodsb
	or al,al
	jz eprint
	call printchar
	jmp short print2	; loop
eprint:	pop ds
	pop ax
	ret

printchar:	; print char from AL
	push ax
	push bx
	mov ah,0x0e	; TTY
	xor bx,bx
	int 0x10	; BIOS screen stuff
	pop bx
	pop ax
	ret

; *************************************************************

drive		db 0	; handed on to boot sectors
realdrive	db 0	; actual boot drive
valid		db 0	; bitmask of allowed choices

message		db 13,10,"Welcome to the FreeDOS MetaKern boot menu"
		db 13,10,"Please type a digit to select a list item"
		db 13,10,"or type A or C to reboot from A: or C:..."
%ifdef TIMEOUT
		db 13,10,"Using <", DefaultKey ,"> if no choice after "
		db TimeOutText, "s."
%endif
		db 13,10,0

choice		db "X"		; this must be the byte before arrow
arrow		db " -> ",0	; menu entries look like "X -> selection"

sectormenumsg	db "Boot sectors:",13,10,0
partnmenumsg	db "Partitions:",13,10,0

readytogomsg	db "kick!",13,10,0

				; removed explicit list 18apr2003
	; diskmaster	db "Reboot from disk "
	; dmaster	db "Z:",0

diskbootmsg	db "Booting from "
diskbootname	db "Z:"
		db "... ",0

bootsectmsg	db "Loading  "
bootsectname	db "9th "
		db " stored boot sector... ",0

partnslotmsg	db "Loading boot sector of  "
partnslotname	db "9th "
		db " partition... ",0

enumnames	db "1st 2nd 3rd 4th ",0

loadfailmsg	db "Disk read error, try again!",13,10,0

loadinvmsg	db "No system on that disk or partition, try again!",13,10,0

dosptype	db "DOS  ",0 	; 1    FAT12 4 FAT16 small 6 FAT16 big
winptype	db "Win9x",0	; B..E CHS/LBA x normal/hidden...
qnxptype	db "WinNT, QNX or OS/2",0	; 7
linptype	db "Linux",0	; 83  ext2, that is
xyzptype	db "???  ",0
		; auto-skipped types ( -> no type name string needed ) are:
		; nultype	db "empty",0	; 0
		; extptype	db "extended",0	; 5/F CHS/LBA

partition	db " - type "
ptype		db "xx",0

fdtype		db "FreeDOS       (chain to fdkern"
fdtypecnt	db                                "el.sys!)",0
mstype		db "MS (Win-) DOS (io.sys / msdos.sys)",0
ibmtype		db "IBM or DR DOS (ibmbio.com / ibmdos.com)",0
wintype		db "MS Windows    (winboot.sys)",0
		; could  add others here and in search strings
othertype	db "unknown operating system",0

fdsearch	db "KERNEL  SYS"
mssearch	db "IO      SYS" ; and "MSDOS   SYS"
ibmsearch	db "IBMBIO  COM" ; and "IBMDOS  COM"
winsearch	db "WINBOOT SYS"
		dw 0	; end of search list

		; map fdsearch to fdreplace, and in addition, count.
fdreplace	db "FDKERN"
fdreplacecnt	db       "ELSYS"

		; must match order of search strings:
searchlist	dw fdtype, mstype, ibmtype, wintype, othertype

; *************************************************************

		; make us exactly 3 sectors in size, for coolness:
                times   0x05fe-$+$$ db 0
sign		db 0xc0, 0x01	; "c001-ness :-)"

		; next sectors can be the FreeDOS and the MS DOS boot
		; sector and so on (up to 4 boot sectors, 0x200 bytes
		; each, at 0x600, 0x800, 0xa00 and 0xc00 in the file)
		; and after that (at 0xe00) we try to load the MBR...

; *************************************************************

; use copy /b to put:
; boot1 at: sign+2
; boot2 at: sign+0x202
; boot3 at: sign+0x402
; boot4 at: sign+0x602
; MetaKern will load:
; mbr   at: sign+0x802

