; ****************************************************************************
; BOOTMGR - multi-BOOT ManaGeR (main executable)
;   Written by Michal H. Tyc
;
; Copyright (c) 1997-2006 BTTR Software.  All rights reserved.
;
; This program is free software; you can redistribute it and/or modify it
; under the terms of the `MODIFIED' BSD LICENSE.  Please see `legal.txt'
; for details.
; ****************************************************************************


; Equates and macros.

%define VERSIONDATE '07-APR-2006'

%include 'defs.inc'

  Section .text

  Org 256

; Check environment, hook vectors, configure display.

startprogram:
  cmp sp, enddata + 512  ; check if enough memory, plus some stack
  mov dx, nomemtext      ; `no memory' message
  jb .errexit
  mov ah, 30h
  int DOSINT             ; get DOS version
  xchg al, ah
  cmp ax, 31eh           ; DOS 3.30 or higher?
  mov dx, notdos3text
  jb .errexit
  mov ax, 1600h
  int MUXINT             ; Windows Enhanced mode check
  and al, 7fH            ; anything but 0 or 80h means Windows running
  jnz .multi
  mov ax, 4680h
  int MUXINT             ; Windows Standard mode check
  test ax, ax            ; 0 means Windows running
  jz .multi
  push es                ; ES modified by this call
  mov ax, 4b02h
  xor bx, bx
  int MUXINT             ; Task Switcher check
  pop es
  test ax, ax            ; 0 means Task Switcher running
  jz .multi
  mov ax, 3306h
; xor bx, bx             ; (still 0) in case INT 21h/3306h not supported
  int DOSINT             ; get true DOS version
  cmp bx, 3205h          ; version 5.50 means WinNT DOS box
  jne .nomulti
.multi:
  mov dx, multitext
  mov ah, 9
  int DOSINT         ; print text at ds:dx
  call getkey
  push ax            ; save key code
  mov dx, crlftext
  mov ah, 9
  int DOSINT         ; print text at ds:dx
  pop ax
  cmp ax, 100h
  jne .exit
.nomulti:
  mov ax, cs
  mov cl, 4
  shl ax, cl                  ; linear address of buffer1 mod 64 Kbytes
  add ax, buffer1
  cmp ax, 0fe00h              ; 64k boundary crossed?
  jbe .no64k
  add byte [mbrbuff + 1], 2   ; select 2nd buffer to prevent DMA problems
  sub byte [filebuff + 1], 2  ; (if DOS doesn't take care of it)
.no64k:
  xor ax, ax
  mov es, ax             ; es = 0
  add al, [es:475h]      ; 0:475h number of hard disks
  jne .numofhd           ; there are some hard disks
  mov dx, nohdtext
.errexit:
  mov ah, 9
  int DOSINT  ; print text at ds:dx
.exit:
  mov ax, 4c01h
  int DOSINT     ; terminate program, exit code = 1
.numofhd:
  push ds
  pop es                          ; es = ds
  mov di, diskpar.howmany - 1
  call byte2asc                   ; convert to ASCII
  add al, 7fh
  mov [driveno.hi], al            ; remember highest BIOS drive number
  mov ax, 2523h
  mov dx, int23proc               ; ds:dx = handler
  int DOSINT                      ; set int 23h vector
  mov ax, 2524h
  mov dx, int24proc               ; ds:dx = handler, ds = cs
  int DOSINT                      ; set int 24h vector
  xor cx, cx
  mov es, cx                      ; es = 0
  mov ax, [es:463h]               ; 0:463h CRTC base (index) port
  cmp al, 0c4h                    ; CRTC base = 3d4h for color,
  mov al, 3                       ;   3b4h for mono video cards
  ja .color
  mov al, 7                       ; video mode (color: 3, mono: 7)
  mov byte [screenseg + 1], 0b0h  ; screen buffer segment
.color:
  cbw                ; ah = 0
  mov [vmode], ax    ; remember mode
  call videobios     ; set mode, clear screen
  mov al, [es:484h]  ; 0:484h rows on screen less one (EGA/VGA)
  test al, al
  jne .rows
  mov al, 24         ; always 25 rows on old video systems
.rows:
  mov dx, badvmtext
  cmp al, 24
  jb .errexit
  inc ax
  mov ah, 2 * 80       ; bytes per row
  mul ah
  mov [screensiz], ax  ; screen size in bytes
  xchg ax, cx
  mov es, [screenseg]
  cld                  ; strings direction is kept UP from here
  xor di, di           ; screen page 0 at offset 0
  shr cx, 1
  mov ax, 07b1h        ; `medium shade' as background
  rep stosw            ; fill
  call cursorout       ; hide cursor
  push ds
  pop es               ; es = ds

; Initialize some other variables.

  mov al, ' '
; xor ch, ch                    ; not needed after last rep stosw
  mov cl, partdata - assocdata  ; 6 columns, 4 rows in activea,
  mov di, assocdata             ;   NITEM rows in assocdata
  rep stosb                     ; fill with spaces
  mov al, 0b3h                  ; vertical line
  mov cl, 4 * 62                ; 62 cols, 4 rows in partition table dialog
  rep stosb                     ; fill template

; Draw the user interface elements that won't be modified.

  mov bp, statfields  ; list of screen objects
  mov si, ititletext  ; text of the first one
  mov cx, -NSTATF     ; negative counter
.nxt:
  xchg bp, si      ; si = object, bp = text
  lodsw
  xchg ax, bx      ; bh:bl = size
  lodsw
  xchg ax, di      ; di = position
  xchg bp, si      ; si = text, bp = object
  call printfield  ; print object, ch < 0, si moved to next text
  inc cx
  js .nxt
  call redrawbutt  ; draw buttons (none selected)

; Identify and display parameters of HD0.

  mov dl, 80h
  call identhd

; Main user interface routine: buttons, input fields and status line.

usrint:
  mov si, guidetext  ; `Keys: ...'
; mov dh, -1         ; dh = -1 after identhd
  call printinv      ; print in status line
  call getkey
  xchg al, ah        ; ax = special key index
  sub al, FIRSTALT
  jnb .alt
  xor bx, bx         ; start from field #0 (= button #0)
.repaint:
  mov si, bx
  mov bp, [bx + si + uiprocs]  ; procedure address
  mov si, [bx + si + uihelp]   ; quick-help text
  call printqhelp
  call redrawbutt.any          ; mark the selected button
  cmp bl, NBUTTONS
  jb .key                      ; this field is a button
  push bx                      ; save active field
  call bp                      ; execute procedure (with cf = nc)
  pop bx
  JMPS .spkey                  ; check which special key caused exit
.key:
  call getkey
  jne .key     ; ignore ASCII characters
  xchg al, ah  ; ax = special key index
.spkey:
  dec ax
  js .repaint                ; ignore [Esc]
  je .exec                   ; [Enter]
  dec ax
  je .next                   ; [Tab]
  dec ax
  dec ax
  jle .prev                  ; [Shift][Tab], [Bksp]
  cmp al, 5
  ja .noarr                  ; not an arrow key
  shl bx, 1
  shl bx, 1                  ; four links per field
  add bx, ax
  mov bl, [bx + uilink - 1]  ; link to another field
; JMPS .repaint              ; next jump does it anyway
.noarr:
  sub al, FIRSTALT - 4  ; [Alt][key] index -> field number
  jb .repaint           ; ignore other keys
.alt:
  cmp al, NBUTTONS
  xchg ax, bx       ; go to selected field
  jnb .repaint      ; activate non-button field
.exec:
  mov si, bx
  mov bp, [bx + si + uiprocs]  ; new procedure address
  push bx                      ; save active field
  call redrawbutt              ; redraw button as unselected
  call bp                      ; execute procedure (with cf = nc)
  pop bx
  JMPS .repaint
.prev:
  dec bx       ; go to previous field
  JMPS .normf
.next:
  sub bx, byte (NFIELDS - 1)  ; go to next field
.normf:
  jns .repaint
  add bx, byte NFIELDS  ; normalize negative field number modulo NFIELDS
  JMPS .repaint


; Redraw user interface buttons.
; On entry:
;   bx = selected user interface element number
; On exit:
;   ax = ?
;   cx = 0
;   dl = NBUTTONS
;   cf = nc

redrawbutt:
  mov bl, 7fh  ; none selected
.any:
  mov si, buttons  ; first button data
  mov dx, 0ff00h   ; dh = shadows and highlighting, dl = counter
.nxt:
  lodsb        ; button body width
  cbw          ; ah = 0 (al < 80h)
  xchg ax, cx  ; cx = width
  lodsw
  xchg ax, di  ; di = button position
  mov ah, 07h  ; selected: white on black
  cmp dl, bl
  je .prt
  mov ah, 70h  ; else black on white
.prt:
  call printtext    ; print and advance si
  inc dx
  cmp dl, NBUTTONS  ; all buttons?
  jb .nxt
  ret


; Quit the installation program.

quitinst:
  mov si, quittext
  call acknowledge       ; break if [Esc] pressed
  mov ax, [vmode]        ; al = video mode, ah = 0 (set mode)
  call videobios         ; int BIOSVIDEOINT
  int DOSTERMINT         ; terminate program, exit code 0


; Decode partition table into text buffer.
; On exit:
;   cx = 0
;   si = MBR buffer
;   all other registers destroyed

decodepart:
  mov di, partdata   ; text buffer
  mov cx, 4          ; 4 partitions
  mov bp, [mbrbuff]
  push bp            ; address of MBR buffer
  add bp, PARTTABL   ; partition table offset in buffer
.part:
  push cx               ; save loop counter
  mov al, '0' + NITEMS
  sub al, cl
  stosb                 ; partition # as ASCII digit
  inc di                ; skip `|'
  mov bl, [bp + 4]      ; partition ID
  mov si, idtable       ; table of known IDs
  mov cl, NUMIDS        ; number of entries
.nxtid:
  lodsw           ; next entry: ah = ID, al = meaning
  cmp ah, bl      ; match IDs
  loopne .nxtid
; xor ah, ah
  cbw             ; ah = 0
  xchg ax, bx
  call byte2hex   ; store ID as hex
  mov si, ptypes  ; di = descriptions
  inc di          ; skip `|'
  mov dx, di
.nxd:
  mov di, dx  ; next description copied on the same place
  mov cl, 11  ; maximum description length with terminating NUL
.cd:
  lodsb        ; next character
  test al, al
  jz .fsp      ; end of string
  stosb
  loop .cd
.fsp:
  dec bx             ; is this bx-th description?
  jns .nxd           ; no, try next one
  mov al, ' '
  dec cx
  rep stosb          ; fill the remainder with spaces
  mov ax, [bp + 12]
  mov dx, [bp + 14]  ; dx:ax = total_number_of_sectors
  call sectors2kmg   ; store as K/M/Gbytes
  inc di             ; skip `|'
  mov ax, [bp + 8]
  mov dx, [bp + 10]  ; dx:ax = partition start LBA
  mov cl, 10         ; max. 10 digits
  call dword2asc     ; store as decimal
  add ax, [bp + 12]
  adc dx, [bp + 14]  ; dx:ax = partition end LBA (start + size)
  cmp ax, 401h
  sbb dx, 0fbh       ; cf = cy if end <= 0fb0400h (CHS-accessible)
  inc di             ; skip `|'
  call accmode
  mov al, ' '
  stosb              ; space to buffer
  mov dh, [bp + 1]   ; partition start: head
  mov cx, [bp + 2]   ;   and cylinder/sector
  call chs2asc       ; store as cccc:hhh:ss
  mov dh, [bp + 5]   ; partition end
  mov cx, [bp + 6]
  call chs2asc
  add bp, byte 16    ; next entry in partition table
  pop cx
  loop .part         ; next partition
  pop si             ; MBR buffer
  ret


; Verify that settings make sense.
; (Some strange settings cannot be entered from keyboard,
; but there can be some garbage in the MBR read from disk.)
; Number of menu items encoded in the loader isn't checked at this stage.
; On entry:
;   ch = 0
;   si = loader code to test
;   [mbrbuff] = MBR with partition table
; On exit:
;   cf = cy: there are errors
;   cf = nc: ok
;   dx = number of menu items
;   ch = 0
;   all registers except si destroyed

checksett:
  xor bp, bp             ; bp = menu item index
  xor dx, dx             ; dx = number of non-blank items
  lea di, [si + smenu]   ; di = tested menu item
.nxt:
  mov al, ' '
  mov cl, 8                    ; length of menu item
  push di
  repe scasb                   ; scan for non-spaces
  pop di                       ; point to begin
  lea di, [di + 8]             ; next item, flags kept
  mov al, [si + bp + sdevf]    ; low byte of partition pointer
  je .blank                    ; item was blank
  cmp bp, dx
  ja .err                      ; non-blank item below blank one(s)
  inc dx                       ; count this item
; cmp al, FLOPPYID
; je .ok
  cmp al, OTHERID
; je .ok
  jbe .ok                      ; floppy and other HD devices are OK
  cmp al, 80h
  jb .done
  cmp al, 84h
  jnb .err
  mov ah, 16                   ; now check HD partitions (devf = 80h..83h)
  mul ah                       ; ah = 8
  add ax, PARTTABL - 800h + 4
  xchg ax, bx                  ; bx = partition type offset in MBR
  add bx, [mbrbuff]            ; pointer in data segment
  cmp [bx], ch                 ; check if partition ID = 0 (`unused')
  je .err                      ; incorrect
  JMPS .ok
.blank:
  cmp al, 20h
  jne .err     ; blank item must not have association
.ok:
  inc bp
  cmp bp, byte NITEMS         ; all items checked?
  jb .nxt
  test dx, dx
  je .err                     ; no items defined
  cmp dl, [byte si + sdefit]
  ja .done                    ; number of items >= default item, ok
.err:
  stc
.done:
  ret


; Print hard disk number in `choose' prompt.
; On entry:
;   dl = BIOS drive number
; On exit:
;   ax, bx, cx, si, di destroyed

printdrive:
  push dx
  xchg ax, dx
  sub al, 7fh
  mov di, choosetext.dsk
  call byte2asc
  mov si, choosetext.dsk + 1
  mov di, SCROFS(7, 22)
  mov cl, 3
  mov ah, 7
  call printtext
  pop dx
  ret


; Select hard disk to display.

choosedisk:
.prompt:
  mov si, choosetext
  call printqhelp     ; the prompt
  mov dx, [driveno]   ; current and max. drive
  call printdrive     ; show current
.key:
  call getkey
  jne .pm
  xchg al, ah  ; ax = special key index
  dec ax
  je identhd   ; [Enter] -- get again and show parameters/settings
  jns .key
  ret          ; [Esc] -- exit
.pm:
  cmp al, '+'
  je .plus
  cmp al, '-'
  jne .key
.minus:
  dec dl
  js .view  ; in range
.plus:
  inc dl
  cmp dl, dh
  jg .minus   ; out of range
.view:
  call printdrive
  call identhd
  JMPS .prompt


; Decode device codes into associations
; On entry:
;   ch = 0
; On exit:
;   dh = partition flags for last A: or D: item, or 0 if none
;   ax, bx, cl, dl, si, di destroyed

decodeassoc:
  mov si, mbr + sdevf  ; device codes in loader
  mov di, assocdata    ; decode associations
  mov cl, 4            ; shift counter
  mov dx, NITEMS
.nxta:
  lodsb         ; al = next pointer
  cmp al, ' '   ; unused?
  je .done      ; no more items
  mov bx, 'A:'
; cmp al, FLOPPYID
  test al, al       ; floppy?
  je .oth           ; if so, store `A:'
  mov bl, 'D'
  cmp al, OTHERID   ; other HD?
  je .oth           ; if so, store `D:'
  mov bx, 0b123h
  add bh, al        ; bx = `#n', n = 1 to 4
  JMPS .stas
.oth:
  mov dh, [byte si + sparf - 1 - sdevf]  ; partition flags for other device
.stas:
  xchg ax, bx
  stosw           ; store association description
  scasw
  scasw           ; next line of the box (di = di + 4)
  dec dl
  jne .nxta       ; next item
.done:
  ret


; Fill MBR buffer with zeros
; On exit:
;   ax = cx = 0
;   di = end of MBR buffer

clrmbrbuf:
  mov di, [mbrbuff]
  xor ax, ax
  mov cx, 100h
  rep stosw
  ret


; Indentify hard disk parameters and size
; On entry:
;   dl = BIOS drive number (80h, 81h, etc.)
; On exit:
;   all registers destroyed

identhd:
  push dx                    ; save disk number
  call clrmbrbuf             ; zero MBR buffer
  call updateinfo            ; show `empty' MBR
  pop dx
  push dx                    ; drive number
  mov al, dl
  mov [driveno], al
  sub al, 7fh
  mov di, diskpar.which - 1
  call byte2asc              ; convert hard disk number to ASCII
  pop dx
; xor cx, cx                 ; cx = 0 after byte2asc
  mov dh, ch                 ; C = H = S = 0 (if disk doesn't respond)
  push dx
  xor di, di                 ; workaround
  mov es, di                 ;   against BIOS bugs
  mov ah, 8
  int BIOSDISKINT            ; BIOS hard disk parameters
  pop bx
  mov dl, bl                 ; dl = drive number
  mov bp, dx                 ; save in bp
  pushf                      ; remember status
  mov ah, 1
  int BIOSDISKINT            ; buggy BIOSes need hard disk status here
  popf
  push cs                    ; workaround...
  pop ds
  push ds
  pop es                     ; ... es = ds = cs back
  pushf                      ; status
  mov di, diskpar.chs        ; text buffer
  cmc                        ; convert cyl + 1, head + 1, sectors (total #)
  call chs2asc.p1            ;   to ASCII, or keep all zeros if error (cy)
  push dx
  push ax                    ; save total number of sectors
  mov [nsectors], bx         ;   and sectors per track
  mov si, parbuffer          ; buffer for returned data
  mov word [si], 1ah         ; data size
; xor cx, cx                 ; not needed after chs2asc
  mov word [si + 2], cx      ; [si + 2] = 0 for buggy BIOSes
  mov dx, bp                 ; drive number
  mov ah, 48h
  int BIOSDISKINT            ; BIOS extended HD parameters
  xchg ax, cx                ; save status in ch
  pop ax
  pop dx                     ; dx:ax = total sectors in CHS mode
  jb .modesize               ; error -- no BIOS extensions
  test ch, ch                ; cf = nc, mark LBA mode
  jne .noext                 ; another test for error (for buggy BIOSes)
  mov ax, [si + 10h]         ; total sectors in LBA mode (lower 32 bits,
  mov dx, [si + 12h]         ;   so disks above 2048 Gbytes unsupported :->)
  JMPS .modesize
.noext:
  stc  ; mark CHS mode
.modesize:
  pushf
  mov di, diskpar.size  ; text buffer
  call sectors2kmg      ; disk size to ASCII
  popf
  mov di, diskpar.mode  ; text buffer
  call accmode          ; BIOS access mode
  mov di, SCROFS(3, 4)  ; position of partition table header
  mov cx, 62            ; length
  mov ah, 70h           ; black on white
  mov dh, 40h           ; no shadow, but highlight hotkey
  mov si, diskpar
  call printtext        ; show disk parameters
  popf                  ; status of `get parameters' function
  jb .err               ; give up if no disk
  call readmbr          ; read Master Boot Record
.err:
  call diskerrmsg  ; print error message if cf = nc


; Show partition table and BOOTMGR settings.
; Check whether BOOTMGR loader is installed
; and show its parameters, or assume defaults.
; On exit:
;   all registers destroyed

updateinfo:
  call decodepart
  mov [isinst], ch       ; ch = 0 after decodepart
  mov di, mbr
  mov cl, IDLEN
  repe cmpsb             ; compare MBR buffer with our loader code
  jne .jclr              ; incompatible loader
; xor ch, ch             ; cx = 0 after rep
  mov si, [mbrbuff]
  call checksett
  jb clrform             ; wrong BOOTMGR settings
  cmp dl, [si + sitems]
.jclr:
  jne clrform                ; wrong number of items
  mov ax, [si + sdelay - 1]  ; get timeout instruction from buffer
  xor al, 0ebh               ; is this `jmp short'?
  jz .setd                   ; infinite timeout then
  mov al, ah                 ; timeout value
  dec ax
  cmp al, 99                 ; correct are: 1 to 99 -> 0 to 98
  inc ax
  jnb clrform
.setd:
  mov [delay], al             ; save timeout value
  mov al, [byte si + sdefit]
  mov [mbr + sdefit], al      ; copy the default item number to loader
  inc byte [isinst]           ; mark that we have BOOTMGR installed

; Copy partition flags and menu items.

  add si, smenu        ; data tables in buffer
  mov di, mbr + smenu  ;   and in loader
  mov cl, CFGLEN
  rep movsb            ; copy

; Decode the BOOTMGR settings and display it.

  mov si, mbr + sparf  ; partition flags in loader
  mov di, hidedata     ; result pointer
.htrow:
  mov dl, '1'  ; initialize column indicator
  lodsb        ; get flags
.htcol:
  test al, 10h  ; hidden? (or has ID with bit 4 set?)
  mov ah, dl    ; if so, store digit
  jne .nh
  mov ah, ' '   ; if not, store space
.nh:
  mov [di], ah
  inc di                         ; next column
  inc dx                         ; next digit
  shr al, 1                      ; shift bitmap
  cmp dl, '5'                    ; all columns?
  jb .htcol
  cmp di, hidedata + 4 * NITEMS  ; all rows?
  jb .htrow
  call checkhiding               ; remove false hiding marks
  call decodeassoc               ; decode associations
  mov ax, 7f7fh                  ; al = counter, ah = default active
.nxp:
  inc ax      ; next code
  shr dh, 1   ; next active flag
  jnb .na
  mov ah, al  ; remember code for active partition
.na:
  cmp al, 83h             ; all possibilities?
  jb .nxp
  mov cl, [delay]         ; timeout
  mov ch, [mbr + sdefit]  ; default item
  test ah, ah
  jns findactp            ; active partition not determined yet
  JMPS showsett           ; print settings


; Reset forms with default values.
; On entry:
;   ch = 0
; On exit:
;   all registers destroyed

clrform:
  mov di, assocdata
  mov ax, 'A:'                                  ; 1st association = floppy
  stosw
  mov ax, '  '                                  ; next items unassociated
  mov cl, (activea - assocdata) / 2 - 1         ; clear assocdata and hidedata
  rep stosw
  mov word [di - 10 * NITEMS + 6], 'D:'         ; 2nd association = other HD
  mov di, mbr + sdevf + 2                       ; device flags in loader
  mov word [di - 2], FLOPPYID + (OTHERID << 8)  ; defaults for 1st & 2nd item
  Times ((NITEMS - 2) / 2) stosw                ; next items: unused
  Times ((NITEMS - 2) % 2) stosb
  mov si, menutop                               ; default menu
  mov di, mbr + smenu
  mov cl, 8                                     ; 8 words (2 lines)
  rep movsw                                     ; copy to loader
  mov cl, 4 * (NITEMS - 2)
  rep stosw                                     ; fill other lines with spaces
  mov [mbr + sdefit], ch                        ; set default item (ch = 0)
  mov cl, DEFTIM                                ; default timeout


; Find active partition or a candidate for one, then show settings
; On entry:
;   cl = timeout
;   ch = default item

findactp:
  mov ax, 07f7fh     ; al = counter, ah = default active
  mov si, [mbrbuff]  ; si = tested MBR
  mov bx, PARTTABL
.find:
  inc ax
  test byte [si + bx], bl     ; active partition? (bl > 80h)
  js .found
  test ah, ah
  js .nxt                     ; already found  (ah >= 80h)
  cmp byte [si + bx + 4], 0
  je .nxt                     ; unused
.found:
  mov ah, al             ; remember this one in ah
.nxt:
  add bx, byte 16  ; next partition
  cmp al, 83h      ; all partitions tested?
  jb .find


; Show all settings, put timeout and default item into loader code.
; On entry:
;   cl = timeout
;   ch = default item
;   ah = default active partition code
; On exit:
;   all registers except bp destroyed

showsett:
  mov [activ], ah
  mov [mbr + sdefit], ch
  mov al, cl
  call timecounter       ; timeout to ASCII, modify loader
  call showsett2
  call menucoords        ; load menu coordinates
  call printfield        ; show menu
  call timprint          ;   and timeout


; Print `Partition table' field.
; (+ see below)

partprint:
  mov di, SCROFS( 3, 7)  ; where
  mov bx, SCRCRD(62, 4)  ; size
  mov si, partdata


; Print rectangular field line by line.
; On entry:
;   ds:si = text to print
;   di = screen location
;   bh = number of lines
;   bl = line length
;   ch = line to highlight, add shadows if < 0
; On exit:
;   ds:si = byte past the text
;   ah = ?
;   al = 20h
;   dl = number of lines
;   dh = ch on entry

printfield:
  push cx      ; save cursor position
  push di      ;   and screen pointer
  xor dx, dx
  xchg ch, dh  ; ch = 0, dh = highlighted line
.line:
  mov ah, 07h  ; white on black
  cmp dl, dh
  je .bar      ; if selection bar,
  mov ah, 70h  ; else black on white
.bar:
  mov cl, bl
  push di
  call printtext
  pop di
  add di, SCROFS(0, 1)  ; one line down
  inc dx
  cmp dl, bh            ; all lines printed?
  jb .line
  pop di                ; restore screen pointer
  pop cx                ;   and cursor position
  ret


; Show some settings (associations, active partition and hiding table).
; On exit:
;   ch = -1
;   all registers except bp destroyed

showsett2:
  mov ch, [mbr + sdefit]  ; default item
  mov di, assocdata + 4   ; marks to be printed
  mov bh, NITEMS          ; number of lines
  call arrows             ; set arrow in ch-th row
  mov di, activea         ; marks to be printed
  mov ch, 80h
  xor ch, [activ]         ; ch = active partition
  mov bh, 4               ; number of lines
  call arrows             ; set arrow in ch-th row
  mov ch, -1              ; shadows on
  call assocprint         ; show associations,
  call activeprint        ;   active partition,
; jmp hideprint           ;   and hiding table


; Print `Hide' field.
; (+ see printfield above)

hideprint:
  mov di, SCROFS(25, 15)     ; where
  mov bx, SCRCRD(4, NITEMS)  ; size
  mov si, hidedata
  JMPS printfield


; Print `Assoc.' field.
; (+ see printfield above)

assocprint:
  mov di, SCROFS(15, 15)     ; where
  mov bx, SCRCRD(6, NITEMS)  ; size
  mov si, assocdata
  JMPS printfield


; Print `active Part.' field.
; (+ see printfield above)

activeprint:
  mov di, SCROFS(69, 7)  ; where
  mov bx, SCRCRD(6, 4)   ; size
  mov si, activea
  JMPS printfield


; Print `Timeout' field.
; (+ see printfield above)

timprint:
  mov di, SCROFS(33, 15)  ; where
  mov bx, SCRCRD(7, 1)    ; size
  mov si, timetext
  JMPS printfield


; Print inverse text in the status line.
; (+ see below)

printinv:
  mov ah, 7  ; white on black
  Db 0b9h    ; mov cx, ## skips over mov ah, 70h

; Print text in the status line.
; On exit:
;   dh = -1
; (+ see below)

printqhelp:
  mov ah, 70h  ; black on white
  mov dh, -1   ; with shadow and highlighting
  mov cx, 72   ; quick-help length


; Print text at the beginning of the status line.
; (+ see below)

printprompt:
  mov di, SCROFS(3, 22)  ; position on the screen


; Print ASCIZ `TEXT' as ` TEXT        ' padded with spaces
; and with optional shadow.
; On entry:
;   cx = length, excluding two spaces at edges
;   ah = attribute
;   dh bit 7 = use shadows
;   dh bit 6 = use highlighting
;   ds:si = text
;   di = destination in screen memory
; On exit:
;   cx = 0
;   ds:si = the byte after text
;   [screenseg]:di = the word after last blank printed
;   al = 20h
;   ah = final attribute
;   cf = nc

printtext:
  call .spc  ; left blank edge
.nxt:
  lodsb         ; next character
  test al, al
  je .nul       ; final \0
  test dh, 40h  ; highlighting on?
  je .pr
  cmp al, '~'   ; escape char
  jne .pr
  xor ah, 8     ; toggle foreground intensity:
  test ah, 70h
  je .nxt       ; background was 0, so done
  xor ah, 7     ; background was 7, we have to toggle 70h <-> 7Fh
  JMPS .nxt
.pr:
  call .chr  ; print
  loop .nxt  ; any characters left?
.nul:
  jcxz .spc    ; nothing to pad
.spc1:
  call .spc   ; pad with spaces
  loop .spc1  ;   to desired length
.spc:
  mov al, ' '
.chr:
  push es
  mov es, [screenseg]
  stosw                                  ; print on the screen
  test dh, dh                            ; clear Carry BTW
  jns .done                              ; no shadow if dh >= 0
  mov byte [es:di + SCROFS(1, 1)], 0b0h  ; `light shade' as shadow
.done:
  pop es
  ret


; Various binary to decimal and hexadecimal conversion routines.

%include 'convert.inc'


; Subroutines used in user interface dialogs.

%include 'dialogs.inc'


; Read a keystroke from keyboard.
; On exit:
;   al <> 0 = ASCII character
;     ah = 0, zf = nz
;   al = 0: special key
;     ah = table index, zf = zr
;   cf = nc

getkey:
  push di
  push cx  ; save used registers
.read:
  xor ah, ah
  int BIOSKEYBINT    ; read key
  mov di, keycodes
  mov cx, NSPECKEYS  ; length of 1st list (scancodes + ASCII)
  repne scasw        ; scan the list
  je .conv           ; found
  test al, al
  jne .done          ; normal key
  mov al, ah         ; scancode
  mov cl, NFUNCKEYS  ; length of 2nd list (scancodes only)
  repne scasb        ; scan the list
  jne .read          ; not found
  add cl, NSPECKEYS  ; index
.conv:
  xor al, al
.done:
  mov ah, cl  ; special key index, or zero if ASCII character
  pop cx
  pop di      ; restore registers
  ret


; Call video BIOS, preserving registers.
; On entry:
;   ah = BIOS video function number
; On exit:
;   bp, si, di = unchanged
;
videobios:
  push bp           ; save
  push si           ;   important registers
  push di           ;   (very old PC/XT BIOSes corrupt them)
  int BIOSVIDEOINT
  pop di
  pop si
  pop bp
  ret


; Move the cursor out of screen.
; (Some BIOSes seem to check ranges in int 10h, so we do it directly.
; Also hiding with `Set cursor shape' (ah = 1) function is reported
; to work incorrectly on some hardware.)
; On exit:
;   dx, ax, bx destroyed

cursorout:
  push ds                  ; save ds
  xor ax, ax
  mov ds, ax               ; ds = 0
  mov dx, [463h]           ; 0:463h CRTC base (index) port
  pop ds
  mov al, 0fh              ; Cursor Address Low index
  out dx, al
  inc dx                   ; dx = data port
  mov al, [screensiz]
  out dx, al
  dec dx                   ; dx = index port
  mov al, 0eh              ; Cursor Address High index
  out dx, al
  inc dx                   ; dx = data port
  mov al, [screensiz + 1]
  out dx, al               ; cursor now out of screen
  ret


; Read the Master Boot Record from current drive.
; (+ see below)

readmbr:
  mov ah, 2


; Read or write the Master Boot Record or any sector from/to current drive.
; On entry:
;   ah = 2 (read), 3 (write)
; On exit:
;   cf = error flag
;   ah = status
;   es:bx = buffer
;   cx = 1

accessmbr:
  mov cx, 1          ; cylinder 0, sector 1
  mov dh, ch         ; head 0
.any:
  mov dl, [driveno]  ; current drive
  mov al, 1          ; one sector
  mov bx, [mbrbuff]  ; es:bx = buffer
  int BIOSDISKINT
  ret


; DOS critical error handler: ignore error code, simply fail.

int24proc:
  mov al, 3  ; fail code


; [Ctrl][Break] handler: simply ignore the key.

int23proc:
  iret


; The boot loaders code.

  Align 2
%include 'bootload.inc'
%include 'generic.inc'


; Initialized data.

  Section .data align=2

%include 'data.inc'


; (end of bootmgr.asm)
