{**********************************************************************
Copyright (C) 2009 by Salvatore Licciardi

Web http://www.webalice.it/turylicciardi    eMail turylicciardi@tiscali.it

 This program is free software: you can redistribute it and/or modify it under
 the terms of the GNU General Public License as published by the Free Software
 Foundation, version 3 of the License.
 This program is distributed in the hope  that it will be useful , but WITHOUT
 ANY WARRANTY without even the implied warranty  of MERCHANTABILITY or FITNESS
 FOR A PARTICULAR PURPOSE.
 See the GNU General Public License for more details. You should have received
 a copy of the GNU General Public License along with this program. If not, see
 http://www.gnu.org/licenses/

 **********************************************************************}

unit Menu_Y_V;        { Menu_Y formato Video solo per FreePascal 1.x.x }

interface

uses Crt,Math,Keyboard,SysUtils,Video,
     {$ifdef Go32v2}
     MsMouse,
     {$else}
     Mouse,
     {$endif}
     MClick22,Altro32,M_y,TxtVideo;


type MenuLista_Y=object
       public
        x,y,error,bk_color,txt_ColorCornice,txt_ColorRiga,txt_ColorRigaSelezionata,
        selezionato,bk_selezione,txt_ColorVeloce,txt_deselezionato:byte;
        controllo{ se la finestra entra nel monitor },topo,tastiera,mancino:boolean;

        constructor init(massimaX,massimaY:longint);
        constructor init;
        destructor  destroy;
        procedure   Mostra;
        procedure   set_Home_End(b:boolean);
        procedure   set_Menu_Ciclico(b:boolean);
        function    get_Home_End:boolean;
        function    get_Menu_Ciclico:boolean;
        function    TestoRiga(posizione:byte):string;
        function    NuovaRiga(testo:string; tasto_:byte):byte;  {torna la posizione dove inserito, inserisce in coda}
        function    NuovaRiga(testo:string):byte;
        function    NuovaRiga:byte;
        function    Costruisci:byte; { ritorna la riga selezionata }
        function    NumElementi:byte;
        function    Ultimo_Tasto:string;
        function    Rimuovi(posizione:byte):boolean;
        function    Selezionabile(elemento:byte; abilitato:boolean):boolean;
        function    AggiornaRiga(posizione:byte; testo:string; tasto_:byte):boolean;
        function    AggiornaRiga(posizione:byte; testo:string):boolean;
        function    AggiornaRiga(posizione:byte; tasto_:byte):boolean;
        function    Inserisci(posizione:byte; testo:string; tasto_:byte):boolean;
        function    Inserisci(posizione:byte; testo:string):boolean;

       private
        mox,moy,tasto,old_mox,old_moy,maxl,old_selezionato,elementi:byte;
        empty,mostra_,Menu_Ciclico,tasti_Home_End:boolean;
        GetTextMaxX_,GetTextMaxY_:integer;
        last_key:string;
        lista:array [1..num] of tipo;
        procedure   writeColor(s:string; elemento_:byte);
        procedure   stampa_selezionato;
        function    Dimensioni(x2,y2:byte):byte;
        function    Run_Costruisci_Crt:byte;
        function    Run_Costruisci_Keyboard:byte;
        function    Run_Costruisci:byte;
       end;

implementation

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure MenuLista_Y.set_Menu_Ciclico(b:boolean);
begin
Menu_Ciclico:=b;
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

function  MenuLista_Y.get_Menu_Ciclico:boolean;
begin
get_Menu_Ciclico:=Menu_Ciclico;
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure MenuLista_Y.set_Home_End(b:boolean); { abilita/disabilita la presione dei tasti inizio/fine }
begin
tasti_Home_End:=b;
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

function MenuLista_Y.get_Home_End:boolean;
begin
get_Home_End:=tasti_Home_End;
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

function MenuLista_Y.selezionabile(elemento:byte; abilitato:boolean):boolean;
begin
if (elemento<1)or(elemento>elementi)or(lista[elemento].nome='') then
   begin
   Error:=13;
   Exit(false);
   end;
lista[elemento].attivo:=abilitato;
selezionabile:=true;
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

function MenuLista_Y.Ultimo_Tasto:string;
begin
Ultimo_Tasto:=last_key; { puo' assumere i valori :
'destra'  'sinistra'  'esc'  'invio'  'alt+'carattere  carattere  mox|moy  ''}
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

function MenuLista_Y.NumElementi:byte;
begin
NumElementi:=elementi;
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

function MenuLista_Y.NuovaRiga(testo:string; tasto_:byte):byte;  {torna la posizione dove inserito}
begin
if elementi=num then
   begin
   NuovaRiga:=0;
   Error:=1;
   exit;
   end;
inc(elementi);
lista[elementi].nome:=testo;
lista[elementi].Tasto:=tasto_;
lista[elementi].Attivo:=true;
NuovaRiga:=elementi;
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

function MenuLista_Y.NuovaRiga(testo:string):byte;  {torna la posizione dove inserito}
begin
exit(NuovaRiga(testo,1));
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

function MenuLista_Y.NuovaRiga:byte;  {torna la posizione dove inserito}
begin
exit(NuovaRiga('',1));
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

constructor MenuLista_Y.init(massimaX,massimaY:longint);
var i:byte;
begin
initvideo;
tasti_Home_End:=true;
Menu_Ciclico:=true;
mancino:=false;
mostra_:=false;
GetTextMaxX_:=byte(massimaX);
GetTextMaxY_:=byte(massimaY);
if massimaX<=0 then GetTextMaxX_:=ScreenWidth;
if massimaY<=0 then GetTextMaxY_:=ScreenHeight;
last_key:='';
txt_deselezionato:=7;
txt_ColorRigaSelezionata:=15;
txt_ColorVeloce:=15;
bk_selezione:=0;
controllo:=false;
elementi:=0;
error:=0;
selezionato:=0;
bk_color:=black;
txt_ColorCornice:=7;
txt_ColorRiga:=7;
x:=1;
y:=1;
tastiera:=true;
topo:=true;
for i:=1 to num do
    begin
    lista[i].nome:='';
    lista[i].Tasto:=0;
    lista[i].Attivo:=true;
    end;
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

constructor MenuLista_Y.init;
begin
init(-1,-1);
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

destructor MenuLista_Y.destroy;
begin
elementi:=0;
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure MenuLista_Y.writeColor(s:string; elemento_:byte);
var i:longint;
begin
hidemouse;
//s:=copy(s,1,GetTextMaxX_-2{-xddd}); ///ddd
i:=pos(char(lista[elemento_].tasto),s);
if lista[elemento_].attivo=false then
                                  if elemento_<>selezionato then outtext(copy(s,1,i-1),0,bk_color,txt_deselezionato)
                                                            else outtext(copy(s,1,i-1),0,bk_selezione,txt_deselezionato)
                                 else
                                  if elemento_<>selezionato then outtext(copy(s,1,i-1),0,bk_color,txt_ColorRiga)
                                                            else outtext(copy(s,1,i-1),0,bk_selezione,txt_ColorRigaSelezionata);
if i=0 then i:=maxlongint
       else movecursor(i-1);
if (i>0) then
       begin
       if lista[elemento_].attivo and (elemento_=selezionato) then outtext(copy(s,i,1),0,bk_selezione,txt_ColorVeloce)
                                                              else if elemento_=selezionato then outtext(copy(s,i,1),0,bk_selezione,txt_ColorVeloce)
                                                                                            else outtext(copy(s,i,1),0,bk_color,txt_ColorVeloce);
       if i<>maxlongint then movecursor(1)
                        else i:=0;
       if lista[elemento_].attivo=false then
                                         if elemento_<>selezionato then outtext(copy(s,i+1,255),0,bk_color,txt_deselezionato)
                                                                   else outtext(copy(s,i+1,255),0,bk_selezione,txt_deselezionato)
                                        else
                                         if elemento_<>selezionato then outtext(copy(s,i+1,255),0,bk_color,txt_ColorRiga)
                                                                   else outtext(copy(s,i+1,255),0,bk_selezione,txt_ColorRigaSelezionata);
       movecursor(length(copy(s,i+1,255)));
       end;
showmouse;
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure MenuLista_Y.stampa_selezionato;
var s:string;
begin
if old_selezionato>0 then
   begin
   setcursorpos(x,y+old_selezionato-1);
   s:=lista[old_selezionato].nome;
   while length(s)<maxl do s:=s+' ';
   writeColor(s,old_selezionato);
   end;
setcursorpos(x,y+selezionato-1);
s:=lista[selezionato].nome;
while length(s)<maxl do s:=s+' ';
writeColor(s,selezionato);
updatescreen(false);
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

function MenuLista_Y.Dimensioni(x2,y2:byte):byte;
var x_,y_:byte;
begin
x_:=GetTextMaxX_;
y_:=GetTextMaxY_;
if y2+elementi+1>y_ then Dimensioni:=12 else
if (x2+maxl+1=x_)and(y2+elementi+1=y_) then dimensioni:=12 else dimensioni:=0;
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure MenuLista_Y.Mostra;
begin
mostra_:=true;
Costruisci;
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

function MenuLista_Y.Run_Costruisci_Crt:byte;
var c:char;
    i,o_old_selezionato,o_selezionato:byte;
    cliccato:boolean;
    Doppio_Click:More_Click;
label skip;

begin
Doppio_Click.init;
Doppio_Click.set_mancino(mancino);
repeat
 skip:
 if keypressed or not topo then
     begin
     c:=readkey;
     case ord(c) of
         13: begin
             if elementi=0 then continue;
             if lista[selezionato].attivo then Run_Costruisci_Crt:=selezionato
                                          else Run_Costruisci_Crt:=0;
             last_key:='invio';
             Exit;
             end;
         27: begin
             Run_Costruisci_Crt:=0;
             last_key:='esc';
             Exit;
             end;
          0: begin
             c:=readkey;
             case ord(c) of
                 79 : if tasti_Home_End then  { tasto fine / End }
                              begin
                              if elementi<2 then goto skip;
                              old_selezionato:=selezionato;
                              selezionato:=NumElementi;
                              while (TestoRiga(selezionato)='')and(selezionato>1) do dec(selezionato);
                              stampa_selezionato;
                              end;
                 71 : if tasti_Home_End then
                              begin           { tasto inizio / Home }
                              if elementi<2 then goto skip;
                              old_selezionato:=selezionato;
                              selezionato:=1;
                              while (TestoRiga(selezionato)='')and(selezionato<numElementi) do inc(selezionato);
                              stampa_selezionato;
                              end;
                 68 : begin   { F10 }
                      last_key:='F10';
                      Run_costruisci_Crt:=0;
                      Exit;
                      end;
                 80 : begin   { freccia giu' }
                      if elementi<2 then goto skip;
                      o_old_selezionato:=old_selezionato;
                      o_selezionato:=selezionato;
                      repeat
                       if selezionato<elementi then inc(selezionato)
                                               else if Menu_Ciclico then selezionato:=1
                                                                    else break;
                      until lista[selezionato].nome<>'';
                      if lista[selezionato].nome='' then
                              begin
                              old_selezionato:=o_old_selezionato;
                              selezionato:=o_selezionato;
                              end
                             else old_selezionato:=o_selezionato;
                      stampa_selezionato;
                      end;
                 77 : begin   { destra }
                      last_key:='destra';
                      Run_costruisci_Crt:=0;
                      Exit;
                      end;
                 75 : begin   { sinistra }
                      last_key:='sinistra';
                      Run_costruisci_Crt:=0;
                      Exit;
                      end;
                  72: begin   { freccia su }
                      if elementi<2 then goto skip;
                      o_old_selezionato:=old_selezionato;
                      o_selezionato:=selezionato;
                      repeat
                       if selezionato>1 then dec(selezionato)
                                        else if menu_ciclico then selezionato:=elementi
                                                             else break;
                      until lista[selezionato].nome<>'';
                      if lista[selezionato].nome='' then
                              begin
                              old_selezionato:=o_old_selezionato;
                              selezionato:=o_selezionato;
                              end
                             else old_selezionato:=o_selezionato;
                      stampa_selezionato;
                      end;
                   else
                    if elementi>0 then
                       for i:=1 to elementi do { ho premuto un tasto alt+selezionato? quale? }
                           if (upcase(char(lista[i].Tasto))=upcase(from_alt_to_char(ord(c)))) and (lista[i].Tasto<>1) then
                                       begin
                                       if lista[i].attivo then Run_Costruisci_Crt:=i
                                                          else Run_Costruisci_Crt:=0;
                                       last_key:='alt+'+from_alt_to_char(ord(c));
                                       selezionato:=i;
                                       exit;
                                       end;
                  end;
             end
          else
           if elementi>0 then
              for i:=1 to elementi do { ho premuto un tasto selezionato? quale? }
                  if upcase(char(lista[i].Tasto))=upcase(c) then
                                      begin
                                      if lista[i].attivo then Run_Costruisci_Crt:=i
                                                         else Run_Costruisci_Crt:=0;
                                      last_key:=c;
                                      selezionato:=i;
                                      exit;
                                      end;
          end;
     end
    else    // mouse
     begin
     Sleep(5);
     {$ifdef Go32v2}
     cliccato:=Doppio_Click.Mouse_Up(mox,moy,tasto);
     if cliccato then tasto:=1
                 else tasto:=0;
     {$else}
     tasto:=0;
     {$endif}
     if tasto=1 then
        begin
        for i:=1 to elementi do
            if (mox>x)and(mox<=x+maxl)and(moy>y)and(moy<=y+elementi) then
                begin
                if lista[i].attivo then Run_Costruisci_Crt:=moy-y
                                   else Run_Costruisci_Crt:=0;
                if lista[i].nome='' then Run_Costruisci_Crt:=0
                                    else selezionato:=moy-y;
                Exit;
                end
               else
                begin
                Run_Costruisci_Crt:=0; { ho cliccato fuori dalla lista }
                last_Key:=inttostr(mox)+'|'+inttostr(moy);
                selezionato:=i;
                Exit;
                end;
        if elementi=0 then
           begin
           Run_Costruisci_Crt:=0; { ho cliccato fuori dalla lista }
           last_Key:=inttostr(mox)+'|'+inttostr(moy);
           selezionato:=0;
           Exit;
           end;
        end;
     if tasto=0 then
                begin { mouse spostato }
                cliccato:=Doppio_Click.Mouse_Down(mox,moy,tasto);
                if cliccato then tasto:=1
                            else tasto:=0;
                if (mox<>old_mox)or(moy<>old_moy) then
                       begin
                       old_mox:=mox;
                       old_moy:=moy;
                       if moy>y then i:=moy-y
                                else i:=0;
                       if (i<=elementi)and(i>0)and(lista[i].nome<>'')and(i<>selezionato)and(mox>x)and(mox<=x+maxl) then
                           begin
                           old_selezionato:=selezionato;
                           selezionato:=i;
                           stampa_selezionato;
                           end;
                       end;
                end;
     {$ifdef Go32v2}                        // click invertito
     if mancino then cliccato:=Doppio_Click.Mouse_Up_L(mox,moy,tasto)
                else cliccato:=Doppio_Click.Mouse_Up_R(mox,moy,tasto);
     if cliccato then tasto:=1
                 else tasto:=0;
     if tasto=1 then
             begin
             Run_Costruisci_Crt:=0;
             last_key:='esc';
             Exit;
             end;
     {$endif}
     end;
until false;
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

function MenuLista_Y.Run_Costruisci_Keyboard:byte;
var c:string;
    i,o_old_selezionato,o_selezionato:byte;
    cliccato:boolean;
    Doppio_Click:More_Click;
label skip;

begin
Doppio_Click.init;
Doppio_Click.set_mancino(mancino);
initKeyboard;
repeat
 skip:
 if (PollKeyEvent<>0) or (not topo) then
     begin
     c:=KeyEventToString(TranslateKeyEvent(GetKeyEvent));
     if c=#13 then
             begin
             if elementi=0 then continue;
             if lista[selezionato].attivo then Run_Costruisci_Keyboard:=selezionato
                                          else Run_Costruisci_Keyboard:=0;
             last_key:='invio';
             Exit;
             end else
     if c=#27 then
             begin
             Run_Costruisci_Keyboard:=0;
             last_key:='esc';
             Exit;
             end else
     if c='End' then
                begin
                if tasti_Home_End then  { tasto fine / End #79 }
                              begin
                              if elementi<2 then goto skip;
                              old_selezionato:=selezionato;
                              selezionato:=NumElementi;
                              while (TestoRiga(selezionato)='')and(selezionato>1) do dec(selezionato);
                              stampa_selezionato;
                              end;
                end else
     if c='Home' then
                 begin
                 if tasti_Home_End then
                              begin           { tasto inizio / Home #71 }
                              if elementi<2 then goto skip;
                              old_selezionato:=selezionato;
                              selezionato:=1;
                              while (TestoRiga(selezionato)='')and(selezionato<numElementi) do inc(selezionato);
                              stampa_selezionato;
                              end;
                 end else
     if c='F10' then
                begin   { F10 #68 }
                last_key:='F10';
                Run_costruisci_Keyboard:=0;
                Exit;
                end else
     if c='Down' then
                 begin   { freccia giu' #80 }
                 if elementi<2 then goto skip;
                 o_old_selezionato:=old_selezionato;
                 o_selezionato:=selezionato;
                 repeat
                  if selezionato<elementi then inc(selezionato)
                                          else if Menu_Ciclico then selezionato:=1
                                                               else break;
                 until lista[selezionato].nome<>'';
                 if lista[selezionato].nome='' then
                              begin
                              old_selezionato:=o_old_selezionato;
                              selezionato:=o_selezionato;
                              end
                             else old_selezionato:=o_selezionato;
                 stampa_selezionato;
                 end else
     if c='Right' then
                  begin   { destra #77 }
                  last_key:='destra';
                  Run_costruisci_Keyboard:=0;
                  Exit;
                  end else
     if c='Left' then
                 begin   { sinistra #75 }
                 last_key:='sinistra';
                 Run_costruisci_Keyboard:=0;
                 Exit;
                 end;
     if c='Up' then
               begin   { freccia su #72 }
               if elementi<2 then goto skip;
               o_old_selezionato:=old_selezionato;
               o_selezionato:=selezionato;
               repeat
                if selezionato>1 then dec(selezionato)
                                 else if menu_ciclico then selezionato:=elementi
                                                      else break;
               until lista[selezionato].nome<>'';
               if lista[selezionato].nome='' then
                              begin
                              old_selezionato:=o_old_selezionato;
                              selezionato:=o_selezionato;
                              end
                             else old_selezionato:=o_selezionato;
               stampa_selezionato;
               end
              else
               begin
               for i:=1 to elementi do { ho premuto un tasto alt+selezionato? quale? }
                  if (upcase(char(lista[i].Tasto))=upcase(from_alt_to_char(c))) then
                                       begin
                                       if lista[i].attivo then Run_Costruisci_Keyboard:=i
                                                          else Run_Costruisci_Keyboard:=0;
                                       last_key:='alt+'+from_alt_to_char(c);
                                       selezionato:=i;
                                       exit;
                                       end;
               for i:=1 to elementi do { ho premuto un tasto selezionato? quale? }
                  if ( upcase(char(lista[i].Tasto))=upcase(c) ) or
                     ( (copy(c,1,6)='SHIFT ')and(upcase(char(lista[i].Tasto))=upcase(c[7])) ) then
                                      begin
                                      if lista[i].attivo then Run_Costruisci_Keyboard:=i
                                                         else Run_Costruisci_Keyboard:=0;
                                      last_key:=c;
                                      if length(last_key)=7 then last_key:=c[7];
                                      selezionato:=i;
                                      exit;
                                      end;
               end;
     end
    else    // il mouse
     begin
     Sleep(5);
     {$ifdef Go32v2}
      cliccato:=Doppio_Click.Mouse_Up(mox,moy,tasto);
     {$else}
      cliccato:=Doppio_Click.Mouse_Down(mox,moy,tasto);
     {$endif}
     if cliccato then tasto:=1
                 else tasto:=0;
     if tasto=1 then
        begin
        for i:=1 to elementi do
            if (i=moy-y)and(mox>x)and(mox<=x+maxl)and(moy>y)and(moy<=y+elementi) then
                begin
                if lista[i].attivo then Run_Costruisci_Keyboard:=i
                                   else Run_Costruisci_Keyboard:=0;
                if lista[i].nome='' then Run_Costruisci_Keyboard:=0
                                    else selezionato:=i;
                Exit;
                end;
        Run_Costruisci_Keyboard:=0; { ho cliccato fuori dalla lista }
        last_Key:=inttostr(mox)+'|'+inttostr(moy);
        if elementi=0 then selezionato:=0
                      else
                       if (moy-y>0)and(lista[moy-y].nome<>'') then selezionato:=byte(max(0,moy-y));
        Exit;
        end;
     if tasto=0 then
                begin { mouse spostato }
                {$ifdef Go32v2}
                cliccato:=Doppio_Click.Mouse_Down(mox,moy,tasto);
                if cliccato then tasto:=1
                            else tasto:=0;
                {$endif}
                if (mox<>old_mox)or(moy<>old_moy) then
                       begin
                       old_mox:=mox;
                       old_moy:=moy;
                       if moy>y then i:=moy-y
                                else i:=0;
                       if (i<=elementi)and(i>0)and(lista[i].nome<>'')and(i<>selezionato)and(mox>x)and(mox<=x+maxl) then
                           begin
                           old_selezionato:=selezionato;
                           selezionato:=i;
                           stampa_selezionato;
                           end;
                       end;
                end;
     {$ifdef Go32v2}                            // click invertito
     if mancino then cliccato:=Doppio_Click.Mouse_Up_L(mox,moy,tasto)
                else cliccato:=Doppio_Click.Mouse_Up_R(mox,moy,tasto);
     if cliccato then tasto:=1
                 else tasto:=0;
     if tasto=1 then
             begin
             Run_Costruisci_Keyboard:=0;
             last_key:='esc';
             Exit;
             end;
     {$endif}
     end;
until false;
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

function MenuLista_Y.Run_Costruisci:byte;
begin
{$ifdef BP7}
 Run_Costruisci:=Run_Costruisci_Crt;
{$else}
 Run_Costruisci:=Run_Costruisci_Keyboard;
{$endif}
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

function MenuLista_Y.Costruisci:byte;
var i,j:byte;
    s:string;
begin
last_key:='';
hidemouse;
if (not tastiera) and (not topo) then
   begin
   Error:=2;
   RunError(201);
   exit;
   end;
if selezionato>elementi then selezionato:=elementi;
for i:=1 to elementi do   {controllo che le righe contengano caratteri validi}
    for j:=1 to length(lista[i].nome) do
        if not ( lista[i].nome[j] in [#9,#16,#32..#255,#27] ) then
                                begin
                                Error:=6;
                                RunError(201);
                                Exit;
                                end;
old_selezionato:=0;
old_mox:=x+1;
old_moy:=y+1;
maxl:=0;
empty:=true;
cursorOff;
if elementi=0 then
              begin
              Costruisci:=Run_Costruisci;
              Exit;
              end;

for i:=1 to elementi do
    begin
    maxL:=byte(trunc(max(length(lista[i].nome),maxl)));
    if not (char(lista[i].tasto) in [#32..#255,#1,#27]) then
                 begin
                 Error:=10;
                 RunError(201);
                 Exit;
                 end;
    empty:=empty and (lista[i].nome='');
    end;
//maxl:=byte(min(maxl,GetTextMaxX_-x-2{-xddd})); ///ddd //maxl:=maxl-2;//
//writeln(maxl);//,'   ',GetTextMaxX_,'  ',-x,'000000000000000');delay2(200); //ddddddddd
if empty then
   begin
   Error:=8;
   RunError(201);
   Exit;
   end;
if selezionato=0 then
   for i:=1 to elementi do
       if lista[i].nome<>'' then
          begin
          selezionato:=i;
          break;
          end;
if controllo then
   begin
   Error:=dimensioni(x,y);
   if Error<>0 then
      begin
      RunError(201);
      Exit;
      end;
   end;
cursorOff;
setcursorpos(x-1,y-1);
s:='';
for i:=1 to maxl do s:=s+c_D1{''};
outtext(c_UL1{''}+s+c_UR1{''},0,bk_color,txt_ColorCornice);
for i:=1 to elementi do
    begin
    setcursorpos(x-1,y+i-1);
    if lista[i].nome<>'' then
        begin
        outtext(c_U1{''},0,bk_color,txt_ColorCornice);
        movecursor(1);
        s:=lista[i].nome;
        while length(s)<maxl do s:=s+' ';
        old_selezionato:=i;
        writeColor(s,i);
        outtext(c_U1{''},0,bk_color,txt_ColorCornice);
        end
       else
        begin
        s:=lista[i].nome;
        while length(s)<maxl do s:=s+c_D1{''};
        outtext(c_CL1{''}+s+c_CR1{''},0,bk_color,txt_ColorCornice);
        end;
    end;
updatescreen(false);
s:='';
for i:=1 to maxl do s:=s+c_D1{''};
outtextxy(x-1,y+elementi,c_DL1{''}+s+c_DR1{''},0,bk_color,txt_ColorCornice);
showmouse;
stampa_selezionato;
if mostra_ then
           begin
           mostra_:=false;
           Costruisci:=0;
           Exit; { non deve eseguire, ma solo mostrare il menu Y }
           end;
Costruisci:=Run_Costruisci;
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

function MenuLista_Y.AggiornaRiga(posizione:byte; testo:string; tasto_:byte):boolean;
begin
if (posizione>elementi)or(posizione<1) then
   begin
   Error:=14;
   exit(false);
   end;
error:=0;
lista[posizione].nome:=testo;
lista[posizione].Tasto:=tasto_;
{lista[posizione].Attivo:=true;}
exit(true);
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

function MenuLista_Y.AggiornaRiga(posizione:byte; testo:string):boolean;
begin
exit(AggiornaRiga(posizione,testo,1));
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

function MenuLista_Y.AggiornaRiga(posizione:byte; tasto_:byte):boolean;
begin
exit(AggiornaRiga(posizione,tasto_));
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

function MenuLista_Y.Rimuovi(posizione:byte):boolean;
var i:byte;
begin
if (posizione>elementi)or(posizione<1) then
   begin
   Error:=14;
   exit(false);
   end;
error:=0;
for i:=posizione+1 to elementi do lista[i-1]:=lista[i];
dec(elementi);
exit(true);
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

function MenuLista_Y.Inserisci(posizione:byte; testo:string; tasto_:byte):boolean;
var i:byte;
begin
if (posizione>elementi)or(posizione<1)or(elementi>=num) then
   begin
   Error:=14;
   exit(false);
   end;
error:=0;
inc(elementi);
for i:=elementi downto posizione+1 do lista[i]:=lista[i-1];
lista[posizione].nome:=testo;
lista[posizione].Tasto:=tasto_;
lista[posizione].Attivo:=true;
exit(true);
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

function MenuLista_Y.Inserisci(posizione:byte; testo:string):boolean;
begin
exit(MenuLista_Y.Inserisci(posizione,testo,1));
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

function MenuLista_Y.TestoRiga(posizione:byte):string;
begin
if (posizione>elementi)or(posizione<1) then
   begin
   Error:=14;
   exit;
   end;
error:=0;
testoRiga:=lista[posizione].nome;
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

begin
end.


 Error
   0  : nesssun errore
   1  : troppe righe inserite
   2  : tastiera e mouse disabilitati (*)
   3  : 0 elementi (*)
   4  :
   5  :
   6  : il nome della riga contiene caratteri non validi (<#32) (*)
   7  :
   8  : righe tutte vuote (*)
   10 : tasto di scalta rapido non compreso tra  a..z  o  A..Z, #27, #1 (non assegnato) (*)
   11 :
   12 : se la finestra non entra nel monitor (*)
   13 : non selezionabile: '' o valore non valido;
   14 : posizione indicata non valida;
(*)  quando chiamo il metodo Costruisci
