/*  XCopy

    Copyright (c) Express Software 1997.
    All Rights Reserved.

    Created by: Joseph Cosentino.

*/

// I N C L U D E S //////////////////////////////////////////////////////////

#include <bios.h>
#include <conio.h>
#include <dir.h>
#include <dos.h>
#include <fcntl.h>
#include <stdio.h>
#include <stdlib.h>

// D E F I N E S ////////////////////////////////////////////////////////////

#define EXIST 80

// G L O B A L S ////////////////////////////////////////////////////////////

enum ATTRIB { NORMAL, RDONLY, HIDDEN, SYSTEM = 4 };
char newpath[MAXPATH], pathname[MAXPATH], newname[MAXPATH], oldname[MAXPATH];
char drive[MAXDRIVE], subdir[MAXDIR], file[MAXFILE], ext[MAXEXT], helpname[MAXPATH], sourcename[MAXPATH];

int aflag=0, mflag=0, pflag=0, vflag=0, wflag=0, yflag=0, nyflag=0, numfilescopied=0;
struct ffblk dta;

// P R O T O T Y P E S //////////////////////////////////////////////////////

int classify_args(int, char *[], char *[], char *[]);
int copyfile(char *, char *);

// F U N C T I O N S ////////////////////////////////////////////////////////

int classify_args(int argc, char *rawargs[], char *fileargs[], char *optargs[])
{
    int index, jndex, kndex;
    char *argptr;

    for (index=0,jndex=0,kndex=0;index<argc;index++)
        {
        argptr = rawargs[index];
        if (*argptr == '/')
            {
            argptr++;
            optargs[kndex++] = argptr;
            } // end if.
        else
            {
            fileargs[jndex++] = argptr;
            } // end else.
            
        } // end for.

   return kndex;

} // end classify_args.

/////////////////////////////////////////////////////////////////////////////

int copyfile(char *source, char *target)
{
    char far *buf = NULL;
    char prompt[] = "Target exists. Overwrite? ", newline[] = "\n\r";
    int hsource, htarget, ch;
    unsigned ret, segbuf, count;

    _dos_allocmem(0xffff, &segbuf);
    count = segbuf;
    if (ret = _dos_allocmem(count, &segbuf))
        return ret;

    FP_SEG(buf) = segbuf;

    if (ret)
        return ret;

    if (pflag)
        {
        printf("Do you want to copy %s? ", strupr(source));
        ch = bdos(1, 0, 0) & 0x00ff;
        printf("\n");
        if ((ch == 'y') || (ch == 'Y'))
            {
            // Open source file and create target, overwriting if necessary.
            if (ret = _dos_open(source, O_RDONLY, &hsource))
                return ret;

            ret = _dos_creatnew(target, NORMAL, &htarget);
            if (ret == EXIST)
                {
                if (yflag)
                    goto resume;
                else
                    _dos_write(1, prompt, sizeof(prompt) - 1, &ch);
resume:
                ch = bdos(1, 0, 0) & 0x00ff;
                if ((ch == 'y') || (ch == 'Y'))
                    ret = _dos_creat(target, NORMAL, &htarget);

                _dos_write(1, newline, sizeof(newline) - 1, &ch);
                } // end if.

            // Read and write until there is nothing left.
            while (count)
                {
                // Read and write input.
                if ((ret = _dos_read(hsource, buf, count, &count)))
                    return ret;

                if ((ret = _dos_write(htarget, buf, count, &count)))
                    return ret;

                } // end while.

            } // end if.
        else
            {
            count++;
            printf("%s not added\n", strupr(source));
            exit(1);
            } // end else.

        } // end if.

    // Open source file and create target, overwriting if necessary.
    if (ret = _dos_open(source, O_RDONLY, &hsource))
        return ret;

    ret = _dos_creatnew(target, NORMAL, &htarget);
    if (ret == EXIST)
        {
        _dos_write(1, prompt, sizeof(prompt) - 1, &ch);
        ch = bdos(1, 0, 0) & 0x00ff;
        if ((ch == 'y') || (ch == 'Y'))
            ret = _dos_creat(target, NORMAL, &htarget);

        _dos_write(1, newline, sizeof(newline) - 1, &ch);
        } // end if.

    // Read and write until there is nothing left.
    while (count)
        {
        // Read and write input.
        if ((ret = _dos_read(hsource, buf, count, &count)))
            return ret;

        if ((ret = _dos_write(htarget, buf, count, &count)))
            return ret;

        if (vflag)
            setverify(1);

        } // end while.

    // Close files and free memory.
    _dos_close(hsource);
    _dos_close(htarget);
    _dos_freemem(segbuf);
    return 0;

} // end copyfile.

/////////////////////////////////////////////////////////////////////////////

void getkey(void)
{
    _bios_keybrd(_KEYBRD_READ);

} // end getkey.

/////////////////////////////////////////////////////////////////////////////

int main(int argc, char *argv[])
{
    int len, done, count=0, wassubdir=1, loop, gavename=0, star=0, n_options, index, help_flag=0, aflag=0, wflag=0;
    char *fileargs[64], *optargs[64];
    unsigned attrib;

    n_options = classify_args(argc, argv, fileargs, optargs);

    for (index=0;index<n_options;index++)
        {
        if (optargs[index][0] == '?') help_flag=1;
        else if (optargs[index][0] == 'A' || optargs[index][0] == 'a') aflag=1;
        else if (optargs[index][0] == 'M' || optargs[index][0] == 'p') mflag=1;
        else if (optargs[index][0] == 'P' || optargs[index][0] == 'p') pflag=1;
        else if (optargs[index][0] == 'V' || optargs[index][0] == 'v') vflag=1;
        else if (optargs[index][0] == 'W' || optargs[index][0] == 'w') wflag=1;
        else if (optargs[index][0] == 'Y' || optargs[index][0] == 'y') yflag=1;
        else if (optargs[index][0] == '-Y' || optargs[index][0] == '-y') nyflag=1;
        else
            {
            printf("Invalid parameter - /%s\n", strupr(optargs[index]));
            exit(1);
            } // end else.

        } // end for.

    if (help_flag)
        {
        printf("Copies directories, their subdirectories, and files (except hidden and\n"
               "system files).\n\n"
               "Syntax: XCOPY source destination [/Y | /-Y] [/A | /M] [/P] [/V] [/W]\n"
               "  source      Specifies the location and names of the files you want to\n"
               "              copy\n"
               "  destination Specifies the destination of the files you want to copy\n"
               "  /Y          Indicates you want XCOPY to replace existing file(s) without\n"
               "              prompting for confirmation\n"
               "  /-Y         Prompt for confirmation before replacing existing files\n"
               "  /A          Copies only source files that have their archive attributes\n"
               "              set\n"
               "  /M          Copies source files that have their archive attributes set and\n"
               "              turns off the archive attribute\n"
               "  /P          Prompts for confirmation about whether you want to create\n"
               "              each destination file\n"
               "  /V          Verifies each file as it is written to the destination file\n"
               "              to make sure that the destination files are identical to the\n"
               "              source files\n"
               "  /W          Prompts you to press a key before copying\n"
               "  /?          Displays this help message\n");
        return 0;
        } // end if.

    if (argc < 2)
        {
        printf("Required parameter missing\n");
        return 1;
        } // end if.

    if (wflag)
        {
        printf("Press any key to start copying files... ");
        getkey();
        printf("\n");

        strcpy(sourcename,argv[1]);
        strcpy(newpath,argv[2]);
        strcpy(subdir,argv[2]);
        strcpy(helpname,argv[2]);
        len = strlen(newpath);              // Destination path length.

        if (newpath[len-1] == 92)
            {
            wassubdir=0;
            if (len > 1)
                subdir[len-1] = 0;

            } // end if.
        else
            {
            newpath[len] = 92;              // Add the '\'.
            newpath[len+1] = 0;             // Don't forget to terminate it.
            } // end else.

        getcwd(newname, MAXPATH);            // Save the directory we were called from.

        // Suppose that user wants to rename a file.
        if (chdir(subdir) * wassubdir)
            {
            fnsplit(helpname,drive,subdir,file,ext); // Break up the destination file name.
            gavename=1;                     // Name for renaming was given.
            newpath[len] = 0;
            strcat(file,ext);
            len=strlen(subdir);
            subdir[len-1] = 0;
            wassubdir=0;

            for (loop=0;sourcename[loop]!=0;loop++)
                {
                if ((sourcename[loop]=='*') || (sourcename[loop]=='?'))
                    star++;                 // Check if you want to rename several files, which is impossible.

                } // end for.

            for (loop=0;file[loop]!=0;loop++)
                {
                if ((file[loop]=='*') || (file[loop]=='?'))
                    star++;

                } // end for.

            if (star)
                {
                printf("Invalid file argument\n");
                return 11;
                } // end if.

            } // end if.
   
        // This line is new for the second modification.
        chdir(newname);

        if (chdir(subdir) * wassubdir)      // See if the destination directory exists.
            {
            printf("Error changing directories\n");
            return 1;
            } // end if.

        chdir(newname);                         // Go back to home directory.
        fnsplit(argv[1],drive,subdir,file,ext); // Break up the source file name.
        sprintf(pathname,"%s%s", strupr(drive), strupr(subdir));  // Save path of source file(s).
        done = findfirst(argv[1],&dta,47);      // Go look for first file.

        while (!done)
            {
            strcpy(oldname,pathname);       // Start "creating" the old filename.
            strcat(oldname,dta.ff_name);
            strupr(oldname);                // Make it all upper case for DOS.
            strcpy(newname,newpath);        // Start "creating" destination filename.

            if (!gavename)                  // Real moving without rename.
                {
                strcat(newname,dta.ff_name);
                } // end if.

            strupr(newname);

            if (copyfile(oldname, newname))
                printf("Error copying files\n% files copied\n", numfilescopied);
            else
                {
                count++;
                numfilescopied=numfilescopied+1;
                done=findnext(&dta);
                continue;
                } // end else.

             } // end while.

        printf("%d files copied\n", numfilescopied);
        return 1;
        } // end if.

    if (aflag)
        {
        strcpy(sourcename,argv[1]);
        strcpy(newpath,argv[2]);
        strcpy(subdir,argv[2]);
        strcpy(helpname,argv[2]);
        len = strlen(newpath);              // Destination path length.

        if (newpath[len-1] == 92)
            {
            wassubdir=0;
            if (len > 1)
                subdir[len-1] = 0;

            } // end if.
        else
            {
            newpath[len] = 92;              // Add the '\'.
            newpath[len+1] = 0;             // Don't forget to terminate it.
            } // end else.

        getcwd(newname, MAXPATH);            // Save the directory we were called from.

        // Suppose that user wants to rename a file.
        if (chdir(subdir) * wassubdir)
            {
            fnsplit(helpname,drive,subdir,file,ext); // Break up the destination file name.
            gavename=1;                     // Name for renaming was given.
            newpath[len] = 0;
            strcat(file,ext);
            len=strlen(subdir);
            subdir[len-1] = 0;
            wassubdir=0;

            for (loop=0;sourcename[loop]!=0;loop++)
                {
                if ((sourcename[loop]=='*') || (sourcename[loop]=='?'))
                    star++;                 // Check if you want to rename several files, which is impossible.

                } // end for.

            for (loop=0;file[loop]!=0;loop++)
                {
                if ((file[loop]=='*') || (file[loop]=='?'))
                    star++;

                } // end for.

            if (star)
                {
                printf("Invalid file argument\n");
                return 11;
                } // end if.

            // This line is new for the second modification.
            chdir(newname);

            if (chdir(subdir) * wassubdir)      // See if the destination directory exists.
                {
                printf("Error changing directories\n");
                return 1;
                } // end if.

            chdir(newname);                         // Go back to home directory.
            fnsplit(argv[1],drive,subdir,file,ext); // Break up the source file name.
            sprintf(pathname,"%s%s", strupr(drive), strupr(subdir));  // Save path of source file(s).
            done = findfirst(argv[1],&dta,47);      // Go look for first file.

            while (!done)
                {
                strcpy(oldname,pathname);       // Start "creating" the old filename.
                strcat(oldname,dta.ff_name);
                strupr(oldname);                // Make it all upper case for DOS.
                strcpy(newname,newpath);        // Start "creating" destination filename.

                if (!gavename)                  // Real moving without rename.
                    {
                    strcat(newname,dta.ff_name);
                    } // end if.

                strupr(newname);
                _dos_getfileattr(newname, &attrib);
		if ((attrib & FA_ARCH) != 0)
                    {
                    if (copyfile(oldname, newname))
                        printf("Error copying files\n% files copied\n", numfilescopied);
                    else
                        {
                        count++;
                        numfilescopied=numfilescopied+1;
                        done=findnext(&dta);
                        continue;
                        } // end else.

                    } // end if.
                else
                    {
                    fprintf(stderr, "File does not have an archive attribute\n");
                    return 1;
                    } // end else.

                done=findnext(&dta);
                } // end while.

            } // end if.

        printf("%d files copied\n", numfilescopied);
        return 0;
        } // end if.

    if (vflag)
        {
        strcpy(sourcename,argv[1]);
        strcpy(newpath,argv[2]);
        strcpy(subdir,argv[2]);
        strcpy(helpname,argv[2]);
        len = strlen(newpath);              // Destination path length.

        if (newpath[len-1] == 92)
            {
            wassubdir=0;
            if (len > 1)
                subdir[len-1] = 0;

            } // end if.
        else
            {
            newpath[len] = 92;              // Add the '\'.
            newpath[len+1] = 0;             // Don't forget to terminate it.
            } // end else.

        getcwd(newname, MAXPATH);            // Save the directory we were called from.

        // Suppose that user wants to rename a file.
        if (chdir(subdir) * wassubdir)
            {
            fnsplit(helpname,drive,subdir,file,ext); // Break up the destination file name.
            gavename=1;                     // Name for renaming was given.
            newpath[len] = 0;
            strcat(file,ext);
            len=strlen(subdir);
            subdir[len-1] = 0;
            wassubdir=0;

            for (loop=0;sourcename[loop]!=0;loop++)
                {
                if ((sourcename[loop]=='*') || (sourcename[loop]=='?'))
                    star++;                 // Check if you want to rename several files, which is impossible.

                } // end for.

            for (loop=0;file[loop]!=0;loop++)
                {
                if ((file[loop]=='*') || (file[loop]=='?'))
                    star++;

                } // end for.

            if (star)
                {
                printf("Invalid file argument\n");
                return 11;
                } // end if.

            } // end if.
   
        // This line is new for the second modification.
        chdir(newname);

        if (chdir(subdir) * wassubdir)      // See if the destination directory exists.
            {
            printf("Error changing directories\n");
            return 1;
            } // end if.

        chdir(newname);                         // Go back to home directory.
        fnsplit(argv[1],drive,subdir,file,ext); // Break up the source file name.
        sprintf(pathname,"%s%s", strupr(drive), strupr(subdir));  // Save path of source file(s).
        done = findfirst(argv[1],&dta,47);      // Go look for first file.

        while (!done)
            {
            strcpy(oldname,pathname);       // Start "creating" the old filename.
            strcat(oldname,dta.ff_name);
            strupr(oldname);                // Make it all upper case for DOS.
            strcpy(newname,newpath);        // Start "creating" destination filename.

            if (!gavename)                  // Real moving without rename.
                {
                strcat(newname,dta.ff_name);
                } // end if.

            strupr(newname);

            if (copyfile(oldname, newname))
                printf("Error copying files\n% files copied\n", numfilescopied);
            else
                {
                count++;
                numfilescopied=numfilescopied+1;
                done=findnext(&dta);
                continue;
                } // end else.

             } // end while.

        printf("%d files copied\n", numfilescopied);
        return 1;
        } // end if.

    // No parameters are specified.
    strcpy(sourcename,argv[1]);
    strcpy(newpath,argv[2]);
    strcpy(subdir,argv[2]);
    strcpy(helpname,argv[2]);
    len = strlen(newpath);              // Destination path length.

    if (newpath[len-1] == 92)
        {
        wassubdir=0;
        if (len > 1)
            subdir[len-1] = 0;

        } // end if.
    else
        {
        newpath[len] = 92;              // Add the '\'.
        newpath[len+1] = 0;             // Don't forget to terminate it.
        } // end else.

    getcwd(newname, MAXPATH);            // Save the directory we were called from.

    // Suppose that user wants to rename a file.
    if (chdir(subdir) * wassubdir)
        {
        fnsplit(helpname,drive,subdir,file,ext); // Break up the destination file name.
        gavename=1;                     // Name for renaming was given.
        newpath[len] = 0;
        strcat(file,ext);
        len=strlen(subdir);
        subdir[len-1] = 0;
        wassubdir=0;

        for (loop=0;sourcename[loop]!=0;loop++)
            {
            if ((sourcename[loop]=='*') || (sourcename[loop]=='?'))
                star++;                 // Check if you want to rename several files, which is impossible.

            } // end for.

        for (loop=0;file[loop]!=0;loop++)
            {
            if ((file[loop]=='*') || (file[loop]=='?'))
                star++;

            } // end for.

        if (star)
            {
            printf("Invalid file argument\n");
            return 11;
            } // end if.

        } // end if.
   
    // This line is new for the second modification.
    chdir(newname);

    if (chdir(subdir) * wassubdir)      // See if the destination directory exists.
        {
        printf("Error changing directories\n");
        return 1;
        } // end if.

    chdir(newname);                         // Go back to home directory.
    fnsplit(argv[1],drive,subdir,file,ext); // Break up the source file name.
    sprintf(pathname,"%s%s", strupr(drive), strupr(subdir));  // Save path of source file(s).
    done = findfirst(argv[1],&dta,47);      // Go look for first file.

    while (!done)
        {
        strcpy(oldname,pathname);       // Start "creating" the old filename.
        strcat(oldname,dta.ff_name);
        strupr(oldname);                // Make it all upper case for DOS.
        strcpy(newname,newpath);        // Start "creating" destination filename.

        if (!gavename)                  // Real moving without rename.
            {
            strcat(newname,dta.ff_name);
            } // end if.

        strupr(newname);
        if (copyfile(oldname, newname))
            printf("Error copying files\n%d files copied\n", numfilescopied);
        else
            {
            count++;
            numfilescopied=numfilescopied+1;
            done=findnext(&dta);
            continue;
            } // end else.

        } // end while.

    printf("%d files copied\n", numfilescopied);

    if (count=0)
        printf("File not found\n");

    return 0;

} // end main.
