; UDMA Driver for DOS  Copyleft (G) 2003 Jack R. Ellis and Luchezar I. Georgiev
%define	 Version '6.0'
%if 0

UDMA is free software; you can redistribute it and/or modify it under the terms
of the GNU General Public License (hereafter "GPL"), as published by the Free
Software Foundation; either version 2 of the GPL, or (at your option) any later
version. UDMA is distributed in the hope that it will be useful, but WITHOUT
ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
FOR A PARTICULAR PURPOSE. See the GPL for details. You must have received a
copy of it along with UDMA; if not, write to the Free Software Foundation, Inc.
59 Temple Place, Suite 330, Boston, MA 02111-1307  USA	(www.gnu.org)

Program history:
Version	 Date (D.M.2003)
6,0	9.XI.	Check LBA heads & sectors, and test reading before loading (LG)
5,9	7.XI.	Require a 386+ so universal installers fail, Ready removed (LG)
5,8	3.XI.	All error codes replaced by FF, resident part optimised (JE&LG)
5,7	2.XI.	Resident optimisation, streamline Identify install code (JE&LG)
5,6	27.X.	No EAX, reject > 28-bit LBA, no ONCYL, unlock on errors (JE&LG)
5,5	22.X.	Optimisation, no VDSAddr test, survive VDS misdetection (JE&LG)
5,4	18.X.	Ultra heavy resident space optimisation, exclude VDS ID (JE&LG)
5,3	14.X.	Bug fix: in case of XMS error, nonzero BX currupted memory (JE)
5,2	13.X.	Data and code space optimisation, DUMB_XMS code removed (JE&LG)
5,1	12.X.	64KB buffer, one-pass transfer, allow 1 to 128 blocks only (JE)
5,0	11.X.	Use a 32KB XMS buffer lowering resident RAM usage 7+ times (JE)
4,9	10.X.	Experimental multiple PRD version: abandoned, not released (JE)
4,8	9.10.	Lower resident stack use, revert back to old VDS detection (LG)
4,7	8.10.	Optimise resident code further: allow EAX MSW save/restore (LG)
4,6	7.10.	Spare several tens of bytes by optimising resident code (JE&LG)
4,5	6.10.	Error resets Start/Stop, try default HDD only if single (JE&LG)
4,4	5.10.	Optimise resident code addressing & fix buffered output (JE&LG)
4,3	4.10.	Fix a typo bug at "Output", was destroying buffered writes (LG)
4,2	3.10.	Fix "Ready" for 686A, fix controller ports/bits for slaves (LG)
4,1	2.10.	If no EDD BIOS, use the primary master; show disk location (LG)
4,0	1.10.	Resident variables and code optimisation, clean-up and fix (JE)
3,9	30.9.	Detect address of BIOS hard disk 80h, "Ready" optimised (LG&JE)
3,8	29.9.	Read entire ID block, use Active DMA mode, options removed (LG)
3,7	28.9.	Two bugs introduced in some earlier version and v3.6 fixed (JE)
3,6	27.9.	Minor changes to "DoIO", reset Start/Stop on interrupts (JE&LG)
3,5	26.9.	Hex in place to allow redirection, model not shown if none (LG)
3,4	25.9.	Load only if an UDMA-capable HDD is found & show its model (LG)
3,3	24.9.	Mode option sets also default mode, detect/show controller (LG)
3,2	23.9.	Correctly handle the case when UDMA mode bits are all zero (LG)
3,1	22.9.	Added conditional-assembly of Quick-Write driver thru -DQW (JE)
3,0	21.9.	Error display bug fix, hard disk mode detection simplified (LG)
2,9	17.9.	Code cleanup and optimisation, the 'W' test option removed (JE)
2,8	16.9.	Ready now waits not only Active low but Interrupt high too (LG)
2,7	15.9.	Save initial VDS lock state, save EAX & do CLI on VDS call (JE)
2,6	14.9.	Check DRQ before starting DMA, detect VDS via call 8102 (JE&LG)
2,5	12.9.	Reduced Ready subroutine, Go bit now reset on next request (JE)
2,4	9.IX.	Send DMAAddr/Len after command/control regs reset, cleanup (JE)
2,3	7.IX.	Load descriptor table pointer reg on each transfer, bugfix (JE)
2,2	6.IX.	Bug fix, code cleanup and optimisation (Jack Ellis &L.Georgiev)
2,1	4.IX.	NASM port, PCI port detection, LBA, options (Luchezar Georgiev)
2,0	1.IX.	Base buffered driver (MASM 5 version) written by Jack R. Ellis.
1,0	22.2.	Base un-buffered driver (MASM 5 version) written by Jack Ellis.
%endif

; General Equates

HEADS	equ	255		; LBA heads
SECSHD	equ	63		; LBA sectors per head
SECSCYL equ	HEADS*SECSHD	; LBA sectors per cylinder
RDYTO	equ	7		; 384 ms ready timeout
HD0DAT	equ	1F0h		; Primary hard disk data port
HD0CTL	equ	3F6h		; and control port
RBYTES	equ	(2*1024*65536*12/14318180+1)*512; Read bytes for rate assessment
	; ( = microseconds per tick, but adjusted for binary megabytes)
	; Number of reads this length per tick = transfer rate in MB/s
BIOSTMR equ	46Ch		; BIOS tick timer offset
HDISKS	equ	475h		; BIOS number of fixed disk drives
VDSFLAG equ	47Bh		; VDS flags
CR	equ	13		; Carriage return
LF	equ	10		; Line feed
%define CRLF	CR,LF

; IDE Status bits

BSY	equ	80h		; Device is busy
RDY	equ	40h		; Device is ready
FLT	equ	20h		; Disk has a fault
DRQ	equ	8		; Data request
ERR	equ	1		; General error flag

; IDE Commands

SETM	equ	3		; Set Mode subcommand
SETF	equ	0EFh		; Set Features
IDCMD	equ	0ECh		; Identify drive
DRCMD	equ	0C8h		; DMA read (write: 0CAh)

; UDMA Controller status bits

INTRPT	equ	4		; Interrupt has occured
BM_ERR	equ	2		; Bus master error flag
ACTIVE	equ	1		; Bus master IDE active

; Device Address Packet

struc	DAP
	.DASize resb	1	; Packet size in bytes (16 for IA-32)
	.DARes1 resb	1	; Reserved (0)
	.DABlks resb	1	; Number of blocks to transfer
	.DARes2 resb	1	; Reserved (0)
	.DABuf	resd	1	; Address of transfer buffer
	.DABeg	resd	2	; Starting logical block address
endstruc

; Device Driver Request Header

struc	RP
	.RPlenU resb	2	; Length and sub-unit
	.RPOp	resb	1	; Opcode
	.RPStat resw	1	; Status word
	.RPResN resb	9	; Reserved fields and number of units
	.RPSize resd	1	; Resident driver size
	.RPCmdl resd	1	; Pointer to command line arguments
endstruc

RPERR	equ	8003h		; Request status error flag and unknown command
RPDONE	equ	100h		; Request status done flag

; Device Driver Header

@	dd	-1		; Link to the next device driver header
	dw	8000h		; Attributes (bit 15: character device driver)
XHandle dw	Strat		; Strategy ofst / XMS buffer handle, set by init
BufOffs dd	DevInt		; Interrupt ofst/ XMS buffer offset, set by init

; Resident Variables (WARNING: Order and location are CRITICAL)

DDS	equ	$		; DMA Descriptor Structure (DDS), DWORD-aligned:
VDSLen	dd	ResEnd		;   Buffer length
%if $ != @ + 16
	%error VDSOffs is not 16
%endif	; Used as a multiplier^
VDSOffs dd	0		;   Buffer offset (32-bit), must be at @ + 16
VDSSeg	dd	0		;   Buffer segment (LSW) and ID (MSW)
VDSAddr dd	0		;   Buffer address (32-bit)
XMS	equ	DDS		; XMS move structure - SHARES DDS:
XMSLen	equ	VDSLen		;   32-bit number of bytes to transfer
XMSSrcH equ	VDSOffs		;   Source block handle	      (00h if DS:SI)
XMSSrcA equ	VDSOffs+2	;   32-bit source address     (may be DS:SI)
XMSDstH equ	VDSSeg+2	;   Destination block handle  (00h if ES:DI)
XMSDstA equ	VDSAddr		;   32-bit destination address(may be ES:DI)
DMAAddr equ	VDSAddr		; DMA buffer address - SHARES DDS address
DMALen	dd	80000000h+RBYTES; DMA buffer length + stop bit: SAME paragraph
PRDAddr dd	DMAAddr		; 32-bit PRD address, set by init
				; I/O Parameters:
Blocks	db	RBYTES/512	;   Number of blocks
LBA	dd	0		;   Logical Block Address and device bits
IOCmd	db	DRCMD		;   Command byte

; Execute an I/O request

BufIO	mov	dword [bx+DMAAddr-@],0; Buffered - set driver buffer address
BufBase equ	$-4		; (XMS buffer address, set by init)
DoIO	mov	cx,RDYTO	; Don't check for error, set timeout limit
	mov	es,bx		; Segment 0
	mov	di,BIOSTMR	; Point to BIOS timer
	add	cl,[es:di]	; 3MSB not needed as we check for equal
	call	ChkRdy		; Check if disk controller is ready
	jc	IORet		; Return if not ready
	mov	dx,0
PCIAddr equ	$-2		; PCI Base UDMA Address, set by init
	push	dx		; Save UDMA command register address
	add	dx,byte 4
	mov	si,PRDAddr	; Set controller PRD address pointer
	outsd
	mov	al,[IOCmd]	; Load ATA command (11001000b or 11001010b)
	add	al,0		; Get UDMA command (00001000b or 00000000b)
	aaa
	pop	dx		; Reset UDMA command register
	out	dx,al
	inc	ax		; Prepare to set Start/Stop
	xchg	ax,bp		; Save UDMA command byte
	inc	dx		; Reset UDMA control register
	inc	dx
	in	al,dx
	or	al,6		; Clear INTRPT and BM_ERR by SETTING them
	out	dx,al
	mov	dx,HD0DAT
IDEAddr equ	$-2		; I/O port base register, set by init
	inc	dx		; Point to sector count register
	inc	dx		; SI already points to our I/O parameters
DMAPar	outsb			; Output them
	inc	dx
	cmp	si,byte IOCmd+1
	jne	DMAPar
ChkDRQ	cmp	cl,[es:di]	; IDE timeout? (Unlikely, but...)
	je	Error		; Yes, give up
	mov	dx,HD0CTL	; No, read IDE alternate status
CtlAddr equ	$-2		; (Set by Init)
	in	al,dx
	test	al,DRQ		; Has first DRQ arrived?
	jz	ChkDRQ		; No, wait
	xchg	ax,bp		; Reload UDMA command byte
	mov	dx,[bx+PCIAddr-@]; Set UDMA Start/Stop bit
	out	dx,al		; (Transfer begins NOW)
	inc	dx		; Point to status register
	inc	dx
	mov	ch,FLT+ERR	; Check disk fault and error at end
ChkDMA	cmp	cl,[es:di]	; Has a UDMA transfer timed out?
	je	Error		; Yes, stop UDMA
	hlt			; No, wait for interrupt from disk or timer...
	in	al,dx		; (This minimises delay)
	shl	al,6		; CF = INTRPT, SF = BM_ERR
	js	Error		; Transfer error? Stop UDMA
	jnc	ChkDMA		; No interrupt yet? Loop back and check again
	call	StopDMA		; Interrupted - reset UDMA Start/Stop bit
	inc	dx
	inc	dx
	in	al,dx		; Read controller status once again
	test	al,BM_ERR	; Late bus master transfer error?
	jnz	Error		; Yes, give up
ChkRdy	cmp	cl,[es:di]	; No, too long without becoming ready?
	je	Error		; Yes, give up
	mov	dx,[bx+CtlAddr-@]; No, read IDE controller alternate status
	in	al,dx
	test	al,BSY+RDY	; Disk controller still busy?
	jle	ChkRdy		; Yes, loop back and check again
	and	al,ch		; Error or disk fault at I/O end?
	jnz	Error		; Yes
IORet	ret			; No, exit with no carry

; Reset the UDMA controller Start/Stop bit

Error	call	Unlock		; Buffer may still be locked
StopDMA mov	dx,[bx+PCIAddr-@]; Point to UDMA command register
	in	al,dx		; Reset UDMA Start/Stop bit
	and	al,-2		; (This will reset Active status bit too)
	out	dx,al
	stc			; Denote error
	ret			; Exit

; Perform a VDS call

Unlock	mov	ax,8104h	; Do VDS unlock on buffer
	xor	dx,dx
VDSInt	mov	es,bx		; Segment 0
	cli			; Prevent VDS mess
	test	byte [es:VDSFLAG],20h; VDS active? (Call 8102 tests installed)
	jz	VDSIntX		; No, exit (CF = 0)
	push	ds		; Point to VDS descriptor block
	pop	es
	mov	di,DDS
	int	4Bh
VDSIntX sti			; Become nice again
	ret

; Move data to or from the driver XMS buffer. The 48-bit user buffer
; address in VDSOffs/VDSSeg was converted to XMS format by the main
; routine and is ALREADY in the XMS move block source field.

MovData push	ds		; Point ES to driver data
	pop	es
	mov	di,XMSDstH	; Point to destination in XMS move block
	jnz	MovOut		; If output, XMS source OK, set XMS destination
	mov	si,XMSSrcH	; If input, move XMS source (user buffer
	push	si		;   address) up to XMS destination
	movsw
	movsd
	pop	di		; Point to source in XMS move block
MovOut	mov	si,XHandle	; Set XMS buffer handle/offset in move block
	movsw			;   as input source, output destination
	movsd
	mov	ah,0Bh		; Move data to or from XMS buffer
	mov	si,XMS
	call	0:0
XEntry	equ	$-4		; XMS driver entry address (set by init)
	cmp	al,1		; Success (was AX = 1)? (If so, BL still 0)
	ret			; Return with CF = 1 on error or CF = 0 if not

; Main driver routine, invoked by Int 13h (Disk Services) calls.
; For a CHS request, the registers contain the following at entry:
;
;	AH	Command code: we handle only 2 (read) and 3 (write)
;	AL	Sector count
;	CH	Lower 8 bits of starting cylinder number
;	CL	Starting sector number and upper 2 bits of cylinder number
;	DH	Starting head number
;	DL	Unit number: we handle only 80h (hard disk 0)
;	ES:BX	Buffer address
;
; For an LBA request, the registers contain the following at entry:
;
;	AH	Command code - we handle only 42h (read) and 43h (write)
;	DL	Unit number  - we handle only 80h (hard disk 0)
;	DS:SI	Pointer to Device Address Packet (DAP), described above

NotUs	pop	es		; Request not for us - reload registers
	popa
Old13h	jmp	0F000h:0EC59h	; Go to previous Int 13h vector, set by Init
Entry	cmp	dl,80h		; Is this request for our disk?
	jne	Old13h		; No, exit quick
	push	ax		; Save command code
	and	ah,0BEh		; Mask out LBA and write bits (6 and 0)
	cmp	ah,2		; Is command a read or write?
	pop	ax		; (Restore command code)
	jne	Old13h		; No, exit quick
	pusha			; Yes, save registers
	push	es
	shl	ah,1		; Make AH L00001W0b
	add	ah,DRCMD-4	; Get DMA command byte (C10010W0b). LBA or CHS?
	jnc	MkLBA		; CHS - compute LBA from CHS
	or	ah,dl		; LBA - restore command MSb
	mov	dx,[si+DAP.DABeg+2]; Get LBA MSW
	test	dh,-16		; Over 28-bit LBA (works for disks < 2 TB)?
	jnz	NotUs		; Yes, exit quick
	mov	al,[si+DAP.DABlks]; No, get LBA block count
	les	cx,[si+DAP.DABuf]; Get user buffer address
	mov	si,[si+DAP.DABeg]; Get LBA LSW
	jmp	short CkBlks	; Go check block count
MkLBA	push	ax		; Save DMA command and sector count
	mov	si,SECSHD	; Save starting sector in SI
	and	si,cx
	mov	di,dx		; Save starting head in DI
	shr	cl,6		; Get cylinder number in CX
	xchg	cl,ch
	mov	ax,SECSCYL	; Convert cylinder to sectors
	mul	cx
	xchg	ax,di		; Swap low-order and head number
	mov	al,SECSHD	; Convert head to sectors
	mul	ah
	add	di,ax		; Add to cylinder sectors
	adc	dl,dh
	dec	si		; Get starting sector number - 1
	add	si,di		; Add to cylinder/head sectors
	adc	dl,dh
	mov	cx,bx		; Save user buffer address
	pop	ax
CkBlks	dec	al		; Block count within 1 and 128?
	js	NotUs		; No, let BIOS handle this
	sti			; Yes, be nice
	cld			; Ensure forward moves
	push	ds		; Save and set DS
	push	cs
	pop	ds
	xor	bx,bx		; Clear BX to reference our data
	mov	[bx+LBA-@],si	; Save lower LBA value in I/O parameters
	or	dh,-32		; Set DEV/LBA bits
UNibble equ	$-1		; LBA device register upper nibble
	mov	[bx+LBA+2-@],dx ; Save upper LBA value
	mov	[bx+IOCmd-@],ah ; Save DMA command
	cbw			; Clear AH (AL is positive)
	inc	ax		; Recover block count
	mov	[Blocks],al	; Save it
	shl	ax,1		; Set VDS and DMA length
	mov	[VDSLen+1],ax
	mov	[DMALen+1],al	; (Don't touch the reserved MSW, 0 means 64 KB)
	xchg	ax,cx		; CX: length/256 for 64K cross check, AX: offset
	mov	si,VDSOffs	; = 16
	mov	[si],ax		; Save 32-bit user buffer offset
	mov	[si+2],bx
	test	al,3		; Is user buffer DWORD-aligned?
	mov	ax,es		; (Save 32-bit user buffer segment)
	mov	[VDSSeg],ax
	jnz	UseBuf		; No, use buffered logic below
	mul	si		; Yes, set 20-bit DMA address
	add	ax,[si]		; Add offset to scaled segment
	adc	dx,bx
	mov	[VDSAddr],ax	; Save address
	mov	[bx+VDSAddr+2-@],dx
	mov	ax,8103h	; Do VDS lock on our buffer
	mov	dx,0Ch		; Neither remap nor allocate
	call	VDSInt		; VDS error?
	jc	UseBuf		; Yes, use buffered logic below
	shl	cx,8		; No error or no VDS - CF:CX = length
	dec	cx		; Add to end address which is at length - 1
	add	cx,[bx+VDSAddr-@]; Will transfer cross a 64 KB boundary?
	jc	Locked		; Yes, use buffered logic below
	call	DoIO		; Do DMA input direct to user buffer
	jc	Done		; Error? Exit
	call	Unlock		; Do VDS unlock of buffer if needed
	jmp	short Done	; Done - exit successfully
Locked	call	Unlock		; Do VDS unlock of buffer if needed
UseBuf	shl	dword [bx+VDSOffs-@],16; Convert VDSOffs to XMS handle/offset
	cmp	byte [bx+IOCmd-@],DRCMD; Is this a read request?
	jne	Write		; No, use write logic below
	call	BufIO		; Read all blocks
	jc	Done		; Error? Exit
	call	MovData		; Move driver data to user buffer
	jmp	short Done	; All done - exit successfully
Write	call	MovData		; Move user data to driver buffer
	jc	Done		; Error? Exit
	call	BufIO		; Write all blocks
Done	pop	ds		; Reload registers
	pop	es
	popa
	sbb	ah,ah		; 0 (no error) or FF (sense operation failed)
	retf	2		; Discard entry flags

	align	16		; Pad to paragraph boundary
ResEnd	equ	$		; Resident driver part end

; Initialization Variables

ReqHdr	dd	0		; Device driver request header address

; Messages

ModTab	dd	'16. ','25. ','33. ','44. ','66. ','100.','133.','166.'
TTLMsg	db	'UDMA HDD Driver Version ',Version,CRLF,'$'
IEMsg	db	'Identify$'
NSMsg	db	'UDMA not supported$'
UMMsg	db	'UDMA mode '
CurMode db	'?, ATA-'
DspMode db	'???.',CRLF,'$'
SEMsg	db	'Set mode$'
VEMsg	db	'VDS lock$'
XEMsg	db	'XMS memory$'
NXMsg	db	'No XMS driver$'
notsup	db	'PCI BIOS 2.0c+ required$'
notfnd	db	'PCI IDE controller not found$'
no_lba	db	'Not an LBA mode HDD$'
busmer	db	'Bus master$'
rderor	db	'Read$'
suffix	db	' error - UDMA not loaded!',CRLF,'$'
xferat	db	'Transfer rate:   '
mbpstr	db	'? MB/s',CRLF,'$'
unknwn	db	'Unknown Id = '
id_hex	db	'????????$'
fndstr	db	' IDE controller found at:',CRLF,'PCI bus '
bus_no	db	'??, device '
dev_no	db	'??, function '
fun_no	db	'?, base '
basadr	db	'????',CRLF,'$'
no_edd	db	'No EDD BIOS HDD parameters',CRLF,'$'
master	db	'Master$'
slaved	db	'Slave$'
hddstr	db	' hard disk at '
hdbase	db	'????/'
hdctrl	db	'????$'
hdmods	db	': '
modeln	times 40 db 0	; 40 swapped bytes
newlin	db	CRLF,'$'
	align	4	; Required by the PCI table below
buffer	dw	30,0	; Result buffer, its size and flags

; Interface byte table - busmaster, legacy mode (bit writable or not)

itable	db	80h,8Ah,0F0h,0FAh
it_end	equ	$

; PCI vendor and device table. Format: dd <id>, db <dword-aligned name>

devtab:
%include "udma.pci"
%if $ - buffer < 1024		; PCI table too short
	%error IDE buffer overflow
%endif
dt_end	equ	$

; Strategy routine. This routine saves the device driver request header
; for handling below. At entry, ES:BX points to the header.

Strat	mov	[cs:ReqHdr],bx	; Save device driver request header address
	mov	[cs:ReqHdr+2],es
	retf			; Exit - await DOS Device Interrupt

; Device-Interrupt routine. This routine initializes the driver.

DevInt	push	ds		; Entry - save registers
	push	es
	pushf
	push	ax
	push	bx
	lds	bx,[cs:ReqHdr]	; Point to device driver request header
IsInit	cmp	byte [bx+RP.RPOp],0; Is this an Init command?
	jne	I_BadP		; No, post error and exit
	push	sp		; Yes, check if the CPU is a 386 or newer
	pop	ax
	cmp	ax,sp		; 80286+ push SP, then decrement it
	jne	No_386		; CPU is below 80286
	push	7000h		; CPU is at least an 80286 - try to set NT|IOPL
	popf
	pushf
	pop	ax
	test	ah,70h		; NT|IOPL stuck to 0?
	jnz	I_Init		; No, CPU is at least a 386
No_386	mov	word [bx+RP.RPSize],0; Yes, it's a 80286 - post zero size
	mov	[bx+RP.RPSize+2],cs; Silently fail and not crash uni-installers
I_BadP	mov	word [bx+RP.RPStat],RPERR; Unknown command
	pop	bx
	pop	ax
	jmp	I_Ret		; Return
I_Init	pop	bx
	pop	ax
	popf			; Restore original flags
	pushf			; and save them again
	sti			; Be nice
	cld			; Ensure forward moves
	pushad			; Save all extended general-purpose registers
	push	cs		; Set our DS and ES
	pop	ds
	push	cs
	pop	es
	mov	dx,TTLMsg	; Display our title message
	call	putstr

; Find the UDMA controller. Return its base I/O address in AX

	xor	edi,edi
	mov	ax,0B101h
	int	1Ah		; PCI BIOS v2.0c+ installation check
	cmp	edx,'PCI '	; BIOS OK?
	je	biosok		; yes, continue
	mov	dx,notsup	; no, BIOS too old
	jmp	short fnderr
biosok	mov	si,itable
findev	mov	ecx,10100h	; class 1 (storage), subclass 1 (IDE)
	lodsb			; interface byte
	mov	cl,al
	mov	ax,0B103h	; find PCI class code
	push	si
	xor	si,si		; prepare device index (0)
	int	1Ah		; BH: bus, BL: bit 7-3: device, 2-0: function
	pop	si
	jnc	found		; if found, break loop
	cmp	si,it_end	; end of table?
	jne	findev		; no, continue searching
	mov	dx,notfnd	; yes - not found, show error and exit
fnderr	jmp	short finderr
found	xor	di,di		; get vendor/device id
	mov	ax,0B10Ah	; read configuration dword in ECX
	push	bx		; bus/device/function may be distroyed
	int	1Ah
	pop	bx
	xchg	ecx,eax		; look up for the id in the PCI device table
	ror	eax,16		; swap words (MSW: vendor id, LSW: device id)
	mov	cx,(dt_end-devtab)/4
	mov	di,devtab
	repne	scasd		; is it there?
	jnz	unkdev		; no, show its id
	mov	dx,di		; yes, show its name
	call	putstr
	jmp	short putloc
unkdev	mov	di,id_hex	; unknown device - must not occur often
	call	xprint		; show vendor/device id
	mov	dx,unknwn
	call	putstr
putloc	mov	ax,bx		; get bus/device/function for display
	xchg	ah,al
	mov	di,bus_no
	call	_8print		; store bus
	rol	ax,5		; move bits 15:8 to 4:0,15:13
	and	al,11111b
	mov	di,dev_no
	call	_8print		; store device
	rol	ax,3		; move bits 15:13 to 2:0
	and	al,111b
	mov	di,fun_no
	call	_4print		; store function
	mov	di,4		; get command low byte
	mov	ax,0B108h	; read configuration byte
	push	bx		; bus/device/function may be distroyed
	int	1Ah
	pop	bx
	and	cl,101b		; mask Bus Master and I/O Space bits
	cmp	cl,101b		; asked bits supported?
	je	bitsup		; yes, continue
	mov	dx,busmer	; no, display error message and exit
finderr jmp	I_Err
bitsup	mov	di,20h		; point to base address register 4
	mov	ax,0B109h	; read configuration word
	int	1Ah
	xchg	cx,ax		; base address now in AX
	and	ax,0FFFCh	; mask non-signinficant 2LSb
	mov	di,basadr
	call	hprint		; store base address
	mov	dx,fndstr
	call	putstr		; show controller location
	mov	[PCIAddr],ax	; save command register address ( = base)

; Get parameters of the first physical drive from BIOS

	mov	ah,41h		; Check Int 13h (EDD, LBA) extensions present
	mov	bx,55AAh
	mov	dl,80h
	int	13h
	jc	I_NoEB		; Invalid Command error
	cmp	bx,0AA55h
	jne	I_NoEB		; Invalid magic return value
	test	cl,4
	jz	I_NoEB		; EDD support subset absent
	mov	ah,48h		; Get drive parameters of first BIOS drive
	mov	dl,80h
	mov	si,buffer
	int	13h
	jc	I_NoEB		; Invalid Command error
	les	si,[si+26]	; Point to DPTE
	mov	ax,es
	cmp	ax,si
	jne	I_DPTE
	cmp	ax,byte -1	; Pointer invalid (FFFF:FFFF)?
	jne	I_DPTE		; No, use it
I_NoEB	mov	dx,no_edd	; Yes, show "No EDD BIOS HDD info"
	push	byte 0		; But in case of a single HDD, try to find it:
	pop	es
	cmp	byte [es:HDISKS],1; Do we have only one hard disk?
	jne	near I_Quit	; No, don't know which to handle, so give up
	mov	al,[UNibble]	; Yes, try to find the primary master disk
	mov	dx,HD0DAT
	jmp	short I_IDev
I_DPTE	mov	cx,16		; Calculate DPTE checksum
	mov	al,0
	mov	bx,si
I_CkSm	add	al,[es:bx]
	inc	bx
	loop	I_CkSm
	cmp	al,0		; Is DPTE valid (checksum = 0)?
	jne	I_NoEB		; No, EDD BIOS error
	mov	al,[es:si+4]	; Yes, copy DPTE fields we need
	mov	[UNibble],al	; Device register upper nibble
	mov	[LBA+3],al	; Save it for read test
	les	dx,[es:si]	; I/O port base and control port address
	mov	[IDEAddr],dx
	mov	[CtlAddr],es

; Get IDE parameters from the drive

I_IDev	add	dx,byte 6	; Point to device register
	out	dx,al
	mov	al,IDCMD	; Issue Identify Device command
	inc	dx		; Point to command register
	call	I_Cmd		; Clear BX and do it
	mov	dx,IEMsg	; "Identify error"
	jc	I_Err1		; Error? Display message
	mov	dx,[bx+IDEAddr-@]; Point to controller PIO data register
	mov	cx,256		; Get the Identify data
	mov	di,buffer
	rep	insw
	mov	si,buffer+54	; Get model number (ID bytes 54-93)
	mov	di,modeln
	mov	cl,20
I_GetM	lodsw
	xchg	ah,al		; Swap its bytes
	stosw
	loop	I_GetM
	test	byte [UNibble],16; Master device?
	mov	dx,master
	jz	I_ShMS		; Yes, show "Master"
	mov	dx,slaved	; No, show "Slave"
I_ShMS	call	putstr
	mov	ax,[IDEAddr]	; Prepare I/O port base address
	test	al,al		; Primary IDE channel (base port 1F0h)?
	js	I_ShPt		; Yes, continue
	add	word [bx+PCIAddr-@],byte 8; Secondary (170h): update UDMA base
I_ShPt	mov	di,hdbase
	call	hprint
	mov	ax,[CtlAddr]	; and control address for display
	mov	di,hdctrl
	call	hprint
	mov	dx,hddstr	; Show the HDD port addresses
	call	putstr
	cmp	word [modeln],byte 0; Valid model number?
	mov	dx,newlin	; (just new line if not)
	jz	I_ModN		; No, don't show it
	mov	dx,hdmods	; Yes, show it
I_ModN	call	putstr

; Check the drive parameters and set UDMA mode

	mov	ah,8		; Get drive parameters
	mov	dl,80h		; for BIOS hard disk 0
	int	13h
	jc	I_ELBA		; Drive parameter activity failed
	and	cl,SECSHD	; Clear cylinder bits
	cmp	cl,SECSHD	; Sectors per cylinder = 63?
	jnz	I_ELBA		; No, error
	cmp	dh,HEADS-1	; Heads = 255 (maximum head number = 254)?
	je	I_SetM		; Yes, continue
I_ELBA	mov	dx,no_lba	; No, show "HDD not in LBA mode" and exit
I_Err1	jmp	short I_Err2
I_SetM	test	byte [buffer+106],4; Are UDMA flag bits valid?
	jz	I_NSup		; No, UDMA not supported error
	mov	al,[buffer+177] ; Yes, get selected UDMA mode flag byte
	xor	ah,ah
	bsr	ax,ax		; Get highest mode bit number
	jnz	I_DMod		; No mode bit is set - "Not supported" error
I_NSup	mov	dx,NSMsg	; Show "Not supported" message and exit
I_Err2	jmp	short I_Err3
I_DMod	mov	dx,UMMsg	; Set up to display "UDMA mode" message
	cwde
	mov	ebx,[ModTab+eax*4]
	mov	[DspMode],ebx	; Set displayed mode
	add	al,'0'
	mov	[CurMode],al	; Update current mode value
	call	putstr
	mov	dx,[IDEAddr]
	inc	dx		; Point to subcommand register
	mov	al,SETM		; Set Mode Select subcode
	out	dx,al
	inc	dx
	mov	al,[CurMode]	; Set desired UDMA mode value
	add	al,10h
	out	dx,al
	mov	al,SETF		; Issue Set Features command to disk
	add	dx,byte 5	; Point to command register
	call	I_Cmd		; Error (clears BX)?
	jnc	short I_Lock	; No, continue
I_SErr	mov	dx,SEMsg	; Set mode error - point to message
I_Err3	jmp	short I_Err4

; Lock resident part if VDS active. Set up PRD address and XMS buffer

I_Lock	xor	eax,eax		; Get driver code segment
	mov	ax,cs
	mov	[VDSSeg],ax	; Set code segment in VDS block
	shl	eax,4		; Save 20-bit driver physical address
	mov	[VDSAddr],eax
	mov	ax,8103h	; Lock our driver into memory (BX already 0)
	mov	dx,0Ch
	call	VDSInt		; Did lock succeed?
	jnc	I_SetA		; Yes, go set addresses
	mov	dx,VEMsg	; Point to VDS error message
I_Err4	jmp	short I_Err5	; Go display error message and exit
I_SetA	mov	eax,[VDSAddr]	; Get 32-bit starting driver address
	add	[bx+PRDAddr-@],eax; Set 32-bit PRD address
	mov	word [bx+VDSLen-@],0 ; Reset lower word of VDS length
	mov	ax,4300h	; Inquire about an XMS driver
	int	2Fh
	cmp	al,80h		; Is an XMS driver installed?
	je	I_SavX		; Yes, save XMS entry address
	mov	dx,NXMsg	; Point to "No XMS driver" message
I_Err5	jmp	short I_Err6	; Go display error message and exit
I_SavX	mov	ax,4310h	; Save XMS driver entry address
	int	2Fh
	mov	[XEntry],bx
	mov	[XEntry+2],es
	mov	ah,9		; Request 128K of XMS memory
	mov	dx,128
	call	far [XEntry]
	dec	ax		; Did we get our buffer memory?
	jnz	I_XErr		; No? Display error message and exit
	mov	[XHandle],dx	; Save our buffer handle
	mov	ah,0Ch		; Lock our XMS memory buffer
	call	far [XEntry]
	dec	ax		; Did buffer get locked?
	jz	I_SavB		; Yes, save buffer address
I_XErr	mov	dx,XEMsg	; Point to "XMS memory" error message
I_Err6	jmp	I_Err		; Go display error message and exit
I_SavB	mov	[BufBase],bx	; Save 32-bit XMS buffer address
	mov	[BufBase+2],dx
	mov	eax,[BufBase]	; Find 1st 64K boundary in our 128K
	add	eax,65536
	xor	ax,ax
	xor	bx,bx		; Needed by BufIO
	xchg	eax,[bx+BufBase-@]; Set final buffer address and get old
	neg	eax		; Set buffer offset in original 128K
	add	eax,[bx+BufBase-@]
	mov	[BufOffs],eax

; Test reading and load the driver if OK

	call	BufIO		; Do a primary read to start from same place
	jc	I_RdEr		; Error? Exit
	mov	ax,bx		; Clear read counter
	mov	cl,[es:di]	; Load current timer tick count LSB
I_Wait	cmp	cl,[es:di]	; Next tick arrived?
	je	I_Wait		; No, keep waiting
	add	cl,1+4		; Yes, update and prepare for 4 passes
I_Read	inc	ax		; Yes, count reads up
	push	ax		; Save counters
	push	cx
	call	BufIO		; Read RBYTES bytes
	pop	cx		; Recover counters
	pop	ax
	jc	I_RdEr		; Read error? Exit
	cmp	cl,[es:di]	; Next timer interrupt arrived?
	jne	I_Read		; No, read once more
	push	ds		; Yes, recover ES
	pop	es
	shr	ax,2		; Get average rate for the 4 passes
	mov	di,mbpstr	; Store transfer rate in MB/s
	call	itoa
	mov	dx,xferat	; Show it
	call	putstr
	mov	ax,3513h	; Get current Int 13h vector
	int	21h
	mov	[Old13h+1],bx	; Save vector for passed requests
	mov	[Old13h+3],es
	push	ds
	pop	es		; Recover ES
	mov	bx,buffer	; Read first block via the old Int 13h handler
	mov	si,bx		; Source pointer for the comparison
	call	Read1S
	jc	I_RdEr		; Error? Exit
	mov	ax,2513h	; Hook our driver into Int 13h
	mov	dx,Entry
	int	21h
	mov	bx,buffer+512	; Read first block via the new Int 13h handler
	mov	di,bx		; Destination pointer for the comparison
	call	Read1S
	jc	I_Back		; Error? Revert to the old one
	mov	cx,512/2	; Compare the two read blocks
	repe	cmpsw		; Same?
	jne	I_Back		; No, read error - revert back
	les	bx,[ReqHdr]	; Yes, post success code and driver size
	mov	word [es:bx+RP.RPStat],RPDONE
	mov	word [es:bx+RP.RPSize],ResEnd
	jmp	short I_Exit	; Go reload registers and exit
I_Back	mov	ax,2513h	; Set back the old Int 13h vector
	lds	dx,[Old13h+1]
	int	21h
	push	cs
	pop	ds		; Recover DS
I_RdEr	mov	dx,rderor	; Show "Read error" and exit
I_Err	call	putstr		; Display error message and suffix
I_Quit	mov	dx,suffix
	call	putstr
	les	bx,[ReqHdr]	; Post 0 size and error status
	mov	word [es:bx+RP.RPStat],RPERR; Unknown command
	mov	word [es:bx+RP.RPSize],0
I_Exit	mov	[es:bx+RP.RPSize+2],cs
	popad			; Reload registers and exit
I_Ret	popf
	pop	es
	pop	ds
	retf

; Issue initialization commands to our disk

I_Cmd	out	dx,al		; Issue desired initialization command
	xor	bx,bx		; Needed by ChkRdy
	mov	es,bx		; Segment 0
	mov	di,BIOSTMR	; Point to BIOS timer
	mov	cx,256*ERR+RDYTO; Set up command time limit and error check bit
	add	cl,[es:di]	; 3MSB not needed as we check for equal
	call	ChkRdy
	push	ds
	pop	es		; Restore ES
	ret			; Exit

; Read first disk block to buffer in ES:BX

Read1S	mov	ax,201h
	mov	cx,1
	mov	dx,80h
	int	13h
	ret

; Right-justified unsigned decimal AX output to ES:DI (points to buffer END)

itoa	std			; store in reverse direction
	mov	cx,10		; CX = divisor
nxtd	xor	dx,dx		; DX:AX = dividend
	div	cx
	xchg	dx,ax		; DX = quotient, AX = reminder
	add	al,'0'		; convert to ASCII
	stosb
	xchg	dx,ax		; AX = quotient
	or	ax,ax		; zero?
	jnz	nxtd		; no, continue
	cld			; yet, restore forward direction
	ret

; Tightest but cryptic hex output to ES:DI

xprint	call	_32p
_32p	ror	eax,16
hprint	call	_8p
_8p	xchg	al,ah
_8print call	_4p
_4p	ror	al,4
_4print push	ax
	and	al,0Fh
	cmp	al,10
	sbb	al,69h		; 0-9 => 96h-9Fh, 0Ah-0Fh => 0A1h-0A6h
	das			; subtract 66h from digits or 60h from letters
	stosb			; store 30h-39h ('0'-'9') or 41h-46h ('A'-'F')
	pop	ax
	ret

; Display string in DX

putstr	push	ax
	mov	ah,9
	int	21h
	pop	ax
	ret
