;
; UDMAJR.ASM    Written 19-Apr-2005 by Jack R. Ellis
;
; UDMAJR is free software.  You can redistribute and/or modify it under
; the terms of the GNU General Public License (hereafter called GPL) as
; published by the Free Software Foundation, either version 2 of GPL or
; any later versions at your option.  UDMAJR is distributed in the hope
; that it will be useful, but WITHOUT ANY WARRANTY and without even the
; implied warranties of MERCHANTABILITY nor of FITNESS FOR A PARTICULAR
; PURPOSE!  See the GPL for details.  You ought to have received a copy
; of the GPL with these UDMA files.  If not, write to the Free Software
; Foundation Inc., 59 Temple Place Ste. 330, Boston, MA 02111-1307 USA.
; http://www.gnu.org/licenses/
;
; Special thanks to Luchezar I. Georgiev for his INESTIMABLE advice and
; help in research, revising, enhancing, and test of the original UDMA!
;
; This is a DOS driver designed to handle 1 to 4 UltraDMA hard-disks on
; PC motherboards having a VIA 8235 or equivalent chipset.   The driver
; determines which of the IDE units are actually UltraDMA hard-disks at
; initialization and will run all such disks.	All UltraDMA disks from
; mode 0 ATA-16 thru mode 7 ATA-166 may be used.    An UltraDMA disk is
; assumed to handle full LBA mode (63 sectors, 255 heads and a designed
; cylinder count).   "LBA mode" I-O requests are supported for FreeDOS,
; MS-DOS V7.xx, and other systems that allow them.   LBA values over 28
; bits shall cause the driver to use "Read/Write Extended" DMA commands
; and need an ATA-6 or newer hard-disk.	  LBA values of 28 bits or less
; shall use regular DMA commands.   24-bit "CHS mode" is also supported
; for MS-DOS V6.xx and earlier.	  Data accessed using CHS calls must be
; located in the initial 8-GB of the disk.
;
; The driver intercepts BIOS INT13 read or write requests only.	  Other
; INT13 requests (including seeks) and read/write requests with invalid
; parameters will be "passed" back to the BIOS or some other driver for
; handling.   If a user I-O buffer is not DWORD aligned, crosses a 64K-
; boundary or fails a VDS "lock", the I-O request will use a 64K buffer
; in XMS memory with UltraDMA to or from the buffer, to avoid "passing"
; these requests to the BIOS for execution in slow PIO mode!   Although
; UltraDMA specifies word-aligned buffers, ERRATA in some chipsets does
; require DWORD alignment and avoiding a 64K DMA address boundary!
;
; NOTE:	  UDMAJR is a "short" variant of the full UDMA driver.	  It is
; intended for "RAM disk" and other space-limited systems.   UDMAJR has
; all UDMA run-time functions, i.e. it supports up to 4 disks, supports
; LBA-48 and any earlier address mode, provides all return codes (shown
; below), and permits "DMA only" use when an XMS driver is not present.
; To hold UDMAJR.SYS at 2048 bytes, the following items are omitted:
;   A) The check for an 80386 or better CPU.
;   B) Hard-disk names and controller "bus" data displays.
;   C) All initialization read tests and the read-rate display.
; Users who REQUIRE these items should employ the full UDMA driver.
;
; Beginning with version 1.6 of this driver, the following return codes
; have been added to help in diagnosing "problem" systems and chipsets.
; On exit from successful I-O requests, the AH-register is zero and the
; carry flag is reset.	 If an error occurs, the carry flag is SET, and
; the AH-register contains one of the following codes:
;
;  Code 08h - DMA timed out
;	0Fh - DMA error
;	20h - Controller busy before I-O
;	21h - Controller busy after I-O
;	80h - First DRQ timed out
;	AAh - Disk not ready before I-O
;	ABh - Disk not ready after I-O
;	CCh - Disk FAULT before I-O
;	CDh - Disk FAULT after I-O
;	E0h - Hard error at I-O end
;	FFh - XMS memory error
;
;
; Revision History:
; ----------------
;  V8.0  19-Apr-05   JE   Fixed "Math ERROR" in XMS buffer alignment
;  V7.9  11-Apr-05   JE   Revised to use "DVRCORE.ASM" core logic
;  V7.8  28-Mar-05   JE   SERIOUS init problem fixed!
;  V7.7  20-Mar-05   JE   Minor update "in step" with UDMA2/UDMA2A V2.2
;  V7.6  19-Feb-05   JE   Fixed error in setting LBA bits 32-47
;  V7.5   7-Jan-05   JE   (Version upped to V7.5; no changes in UDMAJR)
;  V7.4  18-Dec-04   JE   Fixed DRQ timeout code
;  V7.3  11-Dec-04   JE   Fixed FOOLISH disk-select bug (My apologies!)
;  V7.2  10-Dec-04   JE   No EDD BIOS error abort, more code reductions
;  V7.1	  2-Dec-04   JE	  Total revision, derived from V1.6 UDMA2
;  V7.0	 14-Feb-04   JE	  Merged new init, V6.8 run-time, V6.9 CHS code
;  V6.9	  8-Feb-04   JE	  Any CHS "geometry" O.K., buffered I.D. input
;  V6.8	 28-Jan-04   JE	  If no EDD/DPTE, 4 disks at 80h-83h units only
;  V6.7	 16-Jan-04   JE	  Renumbered to replace UDMA, init code reduced
;  V2.2	 25-Dec-03   JE	  Corrected "read test" diagnostic messages
;  V2.1	 24-Dec-03   JE	  Use XMS for read tests, to reduce UDMA size
;  V2.0	 21-Dec-03   JE	  Controller-name displays, multi-sector tests
;  V1.9	  6-Dec-03   JE	  Fixed VDS init bug, buffer/diagnostic "swap"
;  V1.8	  3-Dec-03   JE	  Fixed "STI" bug, "DMA only" now 528 bytes
;  V1.7	 25-Nov-03   JE	  If no XMS driver, allow "DMA only" usage
;  V1.6	 22-Nov-03   JE	  Fixed init reads, added full error codes
;  V1.5	 15-Nov-03   JE	  Added all UDMA init functions but ctlr. name
;  V1.4	 14-Nov-03   JE	  Corrected DMA-status reset
;  V1.3	 13-Nov-03   JE	  "DoIO" does ALL I-O, "XMS error" now 0FFh
;  V1.2	 12-Nov-03   JE	  No "timeout error", other size reductions
;  V1.1	  7-Nov-03   JE	  Used 80386 test from V5.9 UDMA
;  V1.0	  6-Nov-03   JE	  Initial release (had been named UDMA-E)
;
;
; Program-Specific Equations.
;
%define	DVRNAME	'UDMAJR$',0	    ;Driver name.
%define VERSION	'V8.0, 19-Apr-2005' ;Version name for title.
%define XMINPUT	XMSMov		    ;XMS input pointer.
%define	VLENGTH	ResEnd		    ;Initial VDS length.
%include "DVRCORE.ASM"
;
; Initialization Tables And Variables.
;
HDNames dw	PMMsg		;Table of hard-disk "name" pointers.
	dw	PSMsg
	dw	SMMsg
	dw	SSMsg
Modes	db	'16. '		;Mode 0 = ATA-16  UltraDMA mode table.
	db	'25. '		;Mode 1 = ATA-25.
	db	'33. '		;Mode 2 = ATA-33.
	db	'44. '		;Mode 3 = ATA-44  (Rare but possible).
	db	'66. '		;Mode 4 = ATA-66.
	db	'100.'		;Mode 5 = ATA-100.
	db	'133.'		;Mode 6 = ATA-133.
	db	'166.'		;Mode 7 = ATA-166.
BiosHD	db	0		;BIOS hard-disk count.
HDOffs	db	0		;Hard-disk "channel offset".
HDCount db	0		;Remaining hard-disk count.
EDDFlag db	0		;"EDD BIOS present" flag.
HDUnit	db	0		;Current BIOS unit number.
HDIndex db	0		;IDE "index" number.
	align	4
EDDBuff dd	30		;Start of 30-byte EDD input buffer.
;
; Initialization Messages.
;
UDMsg	db	CR,LF,'UDMAJR Disk Driver ',VERSION,'.',CR,LF,'$'
PEMsg	db	'PCI BIOS below V2.0C$'
NEMsg	db	'No controller found$'
MEMsg	db	'Bus-Master setup BAD$'
NXMsg	db	'No XMS manager$'
XEMsg	db	'XMS init error$'
NBMsg	db	'; using only DMA I-O!',CR,LF,'$'
VEMsg	db	'VDS lock error$'
PCMsg	db	'UltraDMA controller at I-O address '
DspAd	db	'0000h'
CRMsg	db	'.',CR,LF,'$'
NDMsg	db	'No disks to use$'
EBMsg	db	'EDD error!  BIOS unit ignored$'
PMMsg	db	'Primary-master $'
PSMsg	db	'Primary-slave $'
SMMsg	db	'Secondary-master $'
SSMsg	db	'Secondary-slave $'
MSMsg	db	'disk set to UltraDMA mode '
CurMode db	'0, ATA-'
DMode	db	'16. ',CR,LF,'$'
DEMsg	db	'is not UltraDMA$'
NPMsg	db	'CHS-values ERROR$'
SEMsg	db	'Set-Mode error$'
Suffix	db	'; driver NOT loaded!',CR,LF,'$'
;
; "Strategy" routine -- At entry, ES:BX points to the DOS init request
;   packet, whose address is saved for processing below.
;
Strat	push	ds		;Save DS-register.
	push	cs		;Set our DS-register.
	pop	ds
	push	es		;Save DOS request-packet address.
	push	bx
	pop	dword [LBA]
	pop	ds		;Reload DS-register.
	retf			;Exit & await DOS "Device Interrupt".
;
; "Device-Interrupt" routine -- This routine initializes the driver.
;
DevInt	pushf			;Entry -- save CPU flags.
	pushad			;Save all CPU registers.
	push	ds
	push	es
	push	cs		;Set our DS-register.
	pop	ds
	les	bx,[LBA]	;Point to DOS request packet.
	cmp	byte [es:bx+RPOp],0  ;Is this an "Init" packet?
	jne	near I_BadP	;No?  Go post errors and exit quick!
	mov	dx,UDMsg	;Display driver "title" message.
	call	I_Dspl
	xor	edi,edi		;Get PCI BIOS "I.D." code.
	mov	ax,0B101h
	int	01Ah
	push	cs		;Reload our DS-register.
	pop	ds
	cmp	edx,"PCI "	;Is PCI BIOS V2.0C or newer?
	mov	dx,PEMsg	;(Get error message pointer if not).
	jne	I_PCEr		;No?  Go display message and exit!
	mov	si,LBA2		;Point to interface byte table.
	cld			;Ensure FORWARD "string" commands!
I_GetD	mov	ecx,000010100h	;We want class 1 storage, subclass 1 IDE.
	lodsb			;Get next "valid" PCI interface byte.
	mov	cl,al
	push	si		;Search for our PCI class code.
	mov	ax,0B103h	;(Returns bus/device/function in BX).
	xor	si,si
	int	01Ah
	push	cs		;Reload our DS-register.
	pop	ds
	pop	si
	jnc	I_GotD		;Found our boy!  Go process it.
	cmp	si,LBA		;More interface bytes to try?
	jb	I_GetD		;Yes, go try next one.
	mov	dx,NEMsg	;BAAAD News!  Point to error message.
	jmp	short I_PCEr	;Go display error message and exit.
I_GotD	push	bx		;Save PCI bus/device/function.
	mov	ax,0B108h	;Get low-order PCI command byte.
	mov	di,4
	int	01Ah
	push	cs		;Reload our DS-register.
	pop	ds
	pop	bx		;Reload PCI bus/device/function.
	not	cl		;Mask Bus-Master and I-O Space bits.
	and	cl,005h		;Is this how our controller is set up?
	jz	I_Base		;Yes, get our PCI base address.
	mov	dx,MEMsg	;Cannot USE it -- point to error msg.
I_PCEr	jmp	I_EOut		;Go display "INVALID" message & exit!
I_Base	mov	ax,0B109h	;Get PCI base address (register 4).
	mov	di,32
	int	01Ah
	push	cs		;Reload our DS-register.
	pop	ds
	xchg	ax,cx		;Post our DMA controller address.
	and	al,0FCh
	mov	[DMAAd],ax
	mov	[@DMALo1],al	;Set low-order DMA address bytes.
	add	[@DMALo2],al
	mov	cx,4		;Set hex address in display message.
	mov	si,DspAd
I_Hex	rol	ax,4		;Get next hex digit in low-order.
	push	ax		;Save remaining digits.
	and	al,00Fh		;Mask off next hex digit.
	cmp	al,009h		;Is digit 0-9?
	jbe	I_HexA		;Yes, convert to ASCII.
	add	al,007h		;Add A-F offset.
I_HexA	add	al,030h		;Convert digit to ASCII.
	mov	[si],al		;Set next ASCII digit in message.
	inc	si		;Bump message address.
	pop	ax		;Reload remaining digits.
	loop	I_Hex		;If more digits to go, loop back.
	mov	dx,PCMsg	;Display controller I-O address.
	call	I_Dspl
	mov	ax,04300h	;Inquire about an XMS manager.
	int	02Fh
	push	cs		;Reload our DS-register.
	pop	ds
	mov	dx,NXMsg	;Point to "No XMS manager" message.
	cmp	al,080h		;Is an XMS manager installed?
	jne	I_XErr		;No, display message & disable XMS.
	mov	ax,04310h	;Get XMS manager "entry" address.
	int	02Fh
	push	cs		;Reload our DS-register.
	pop	ds
	push	es		;Save XMS manager "entry" address.
	push	bx
	pop	dword [@XEntry]
	mov	ah,009h		;Ask XMS manager for 128K of memory.
	mov	dx,128
	call	XMCall
	jc	I_XMErr		;If error, display msg. & disable XMS.
	mov	[XMHdl],dx	;Save XMS buffer handle number.
	mov	ah,00Ch		;"Lock" our XMS memory (direct call,
	call	far [@XEntry]	;  as "XMCall" saves & restores BX!).
	push	cs		;Reload our DS-register.
	pop	ds
	dec	ax		;Did XMS memory get locked?
	jnz	I_RidX		;No?  Unuseable -- get RID of it!
	shl	edx,16		;Get unaligned XMS buffer address.
	mov	dx,bx
	mov	eax,edx
	or	ax,ax		;Is buffer ALREADY on a 64K boundary?
	jz	I_XBAd		;Yes, use XMS buffer address as-is.
	add	eax,65536	;Find 1st 64K boundary after start.
	xor	ax,ax
I_XBAd	mov	[@XBufAd],eax	;Set final XMS 32-bit buffer address.
	sub	eax,edx		;Initialize "offset" into XMS memory.
	mov	[XMOfs],ax
	mov	ah,005h		;Local-enable "A20 line" FOREVER!
	call	XMCall		;("A20" CANNOT turn off during DMA!).
	jnc	I_Stop		;If no error, ensure DMA is stopped.
	mov	ah,00Dh		;Unuseable!  Unlock our XMS memory.
	mov	dx,[XMHdl]
	call	XMCall
I_RidX	xor	dx,dx		;Load & reset our XMS buffer handle.
	xchg	dx,[XMHdl]
	mov	ah,00Ah		;Free our XMS memory.
	call	XMCall
I_XMErr mov	dx,XEMsg	;Point to "XMS setup error" message.
I_XErr	call	I_Dspl		;Display desired XMS error message.
	mov	dx,NBMsg	;Display "no buffered I-O" message.
	call	I_Dspl
	mov	ax,(Pass-GoBuf-3) ;Reject buffered I-O using a
	mov	[GoBuf+1],ax	  ;  "dirty-nasty" code change!
	mov	ax,NonXEnd	  ;Reduce resident driver size.
	mov	[VDSLn],ax
I_Stop	mov	dx,[DMAAd]	;Ensure any previous DMA is stopped.
	in	al,dx		;(See "DoDMA" routine notes below).
	and	al,0FEh
	out	dx,al
	add	dx,byte 8	;Stop secondary-channel DMA, also!
	in	al,dx
	and	al,0FEh
	out	dx,al
	xor	eax,eax		;Zero EAX-reg. for 20-bit addressing.
	mov	es,ax		;Point ES-reg. to low memory.
	or	al,[es:HDISKS]	;Did BIOS find any hard-disks?
	jz	near I_RScn	;No?  Display "No disk" and exit!
	mov	[BiosHD],al	;Save BIOS hard-disk count.
	mov	ax,cs		;Set our code segment in VDS block.
	mov	[VDSSg],ax
	shl	eax,4		;Get 20-bit driver virtual address.
	cli			;Avoid interrupts during VDS tests.
	test	byte [es:VDSFLAG],020h ;Are "VDS services" active?
	jz	I_SetA		;No, set 20-bit virtual addresses.
	mov	ax,08103h	;"Lock" this driver into memory.
	mov	dx,0000Ch
	call	VDLock
	jc	near I_VErr	;Error?  Display error msg. & exit!
	inc	byte [VDSOf]	;Set initialization VDS "lock" flag.
	mov	eax,[IOAdr]	;Get 32-bit starting driver address.
I_SetA	sti			;Re-enable CPU interrupts.
	add	[PRDAd],eax	;Set relocated 32-bit PRD address.
	mov	ah,041h		;See if we have an EDD BIOS.
	mov	bx,055AAh
	mov	dl,080h
	int	013h
	push	cs
	pop	ds
	jc	I_Scan		;No, scan for disks without EDD.
	cmp	bx,0AA55h	;Did BIOS "reverse" our entry code?
	jne	I_Scan		;No, scan for disks without EDD.
	xchg	ax,cx		;Set "EDD BIOS present" flag.
	and	al,004h
	mov	[EDDFlag],al
	jmp	I_Scan		;Go scan for UltraDMA disks to use.
I_RScn	mov	dx,NDMsg	;Point to "No disk to use" message.
	xor	ax,ax		;Load & reset EDD BIOS flag.
	xchg	al,[EDDFlag]
	or	ax,ax		;Were we scanning v.s. DPTE data?
	jz	near I_Err	;No?  Display "No disk" and exit!
I_Scan	mov	ax,00080h	;Reset hard-disk unit number & index.
	mov	[HDUnit],ax
	mov	al,[BiosHD]	;Reset remaining hard-disk count.
	mov	[HDCount],al
I_Next	movzx	bx,[HDIndex]	;Get disk unit-number index.
	cmp	bh,[EDDFlag]	;Are we using DPTE data from BIOS?
	je	I_ChMS		;No, check disk at "fixed" addresses.
	mov	ah,048h		;Get next BIOS disk's EDD parameters.
	mov	dl,[HDUnit]
	mov	si,EDDBuff
	int	013h
	push	cs
	pop	ds
	jc	I_ErEDD		;Error?  Ignore this BIOS unit!
	cmp	dword [si+26],byte -1  ;Valid DPTE pointer?
	je	near I_More	;No, ignore unit & check for more.
	les	si,[si+26]	;Get this disk's DPTE pointer.
	mov	bx,15		;Calculate DPTE checksum.
	xor	cx,cx
I_CkSm	add	cl,[es:bx+si]
	dec	bx
	jns	I_CkSm
	jcxz	I_EDOK		;If checksum O.K., use parameters.
I_ErEDD	mov	dx,EBMsg	;Display "EDD error" and ignore unit!
	jmp	short I_ErrD
I_EDOK	mov	bx,00010h	;Initialize IDE unit number index.
	and	bl,[es:si+4]
	shr	bl,4
	mov	ax,[es:si]	;Get disk's IDE base address.
	cmp	ax,CDATA	;Is this a primary-channel disk?
	je	I_ChMS		;Yes, set disk channel and unit.
	cmp	ax,(CDATA-080h)	;Is this a secondary-channel disk?
	jne	I_More		;No, ignore unit & check for more.
	inc	bx		;Adjust for secondary channel.
	inc	bx
I_ChMS	mov	ax,bx		;Separate channel and master/slave.
	shr	al,1
	mov	ah,(LBABITS/32)	;Get drive-select "nibble".
	rcl	ah,5
	ror	al,1		;Set channel offset (2nd = 080h).
	mov	[HDOffs],al
	mov	dx,CDSEL	;Get IDE disk-select address.
	xor	dl,al
	mov	al,ah		;Select master or slave disk.
	out	dx,al
	shl	bx,2		;Save disk's "Units" table index.
	push	bx
	shr	bx,1		;Get "channel name" message index.
	mov	dx,[bx+HDNames] ;Display disk's IDE channel name.
	call	I_Dspl		;("Primary master", etc.).
	mov	ah,008h		;Get BIOS CHS values for this disk.
	mov	dl,[HDUnit]
	int	013h
	push	cs
	pop	ds
	mov	al,dh		;Set head-number value in AL-reg.
	pop	bx		;Reload disk's unit number index.
	mov	dx,NPMsg	;Point to "parameter ERROR" message.
	jc	I_ErrD		;Error -- display msg. & ignore disk!
	and	cl,03Fh		;Get sectors per head (lower 6 bits).
	inc	al		;Get heads/cylinder (BIOS value + 1).
	mul	cl		;Calculate sectors per cylinder.
	or	ax,ax		;Is either CHS parameter zero?
	jz	I_ErrD		;Yes?  Display message & ignore disk!
	mov	[bx+Units+1-@],cl  ;Save this disk's CHS parameters.
	mov	[bx+Units+2-@],ax
	mov	al,[HDUnit]	;Activate this disk in main driver.
	mov	[bx+Units-@],al
	push	bx		;Validate this UltraDMA disk.
	call	I_ValD
	pop	bx
	jnc	I_More		;If no errors, check for more disks.
	mov	byte [bx+Units-@],0FFh  ;DELETE disk in main driver!
I_ErrD	call	I_Dspl		;Display error for this disk.
	mov	dx,CRMsg	;Display error-message suffix.
	call	I_Dspl
I_More	add	word [HDUnit],00101h  ;Bump BIOS unit & disk index.
	cmp	word [EDDFlag],08400h ;No EDD and all 4 units tested?
	je	I_AnyD		;Yes, see if we found any disks.
	dec	byte [HDCount]	;More BIOS disks to check?
	jnz	I_Next		;Yes, loop back and do next one.
I_AnyD	mov	bx,16		;Set up to scan for last unit.
I_ChkU	sub	bx,byte 4	;Any more active units to check?
	js	near I_RScn	;No, see if we should do a re-scan.
	cmp	byte [bx+Units-@],0FFh  ;Is this unit active?
	je	I_ChkU		;No, loop back and check next unit.
	mov	ax,03513h	;Get current Int 13h vector.
	call	I_Int21
	push	es		;Save previous Int 13h vector.
	push	bx
	pop	dword [@PrvI13]
	mov	ax,02513h	;"Hook" this driver into Int 13h.
	mov	dx,Entry
	call	I_Int21
	xor	ax,ax		;Load & reset driver length.
	xchg	ax,[VDSLn]
	mov	dx,RPDON	;Go post "success" and exit.
	jmp	short I_Exit
I_VErr	mov	dx,VEMsg	;VDS "lock" error!  Point to message.
I_Err	push	dx		;Save error message pointer.
	shr	byte [VDSOf],1	;Was driver "locked" by VDS?
	jnc	I_XUnl		;No, get rid of our XMS memory.
	call	VDUnlX		;"Unlock" this driver from memory.
I_XUnl	mov	cx,[XMHdl]	;Did we reserve any XMS memory?
	jcxz	I_LdMP		;No, display desired error message.
	mov	ah,00Dh		;Unlock our XMS memory buffer.
	mov	dx,cx
	push	dx
	call	XMCall
	mov	ah,00Ah		;Free our XMS memory buffer.
	pop	dx
	call	XMCall
	mov	ah,006h		;Do local-disable of "A20 line".
	call	XMCall
I_LdMP	pop	dx		;Reload error message pointer.
I_EOut	call	I_Dspl		;Display error message and suffix.
	mov	dx,Suffix
	call	I_Dspl
I_BadP	xor	ax,ax		;Get "null" length & error flags.
	mov	dx,RPDON+RPERR
I_Exit	les	bx,[LBA]	;Post results in "init" packet.
	mov	[es:bx+RPSize],ax
	mov	[es:bx+RPSize+2],cs
	mov	[es:bx+RPStat],dx
	pop	es		;Reload all CPU registers and exit.
	pop	ds
	popad
	popf
	retf
;
; Subroutine to "validate" an UltraDMA hard-disk.
;
I_ValD	mov	al,0ECh		;Issue "Identify Device" command.
	call	I_Cmd
	jc	I_DErr		;If error, exit & display message!
	add	dx,byte (CDATA-CCMD)  ;Point to PIO data register.
	in	ax,dx		;Read I.D. bytes 0 and 1.
	xchg	ax,si		;Save "ATA/ATAPI" flag word.
	mov	cx,52		;Skip I.D. bytes 2-105.
I_Skp1	in	ax,dx
	loop	I_Skp1
	in	ax,dx		;Read I.D. bytes 106 and 107.
	mov	bh,al		;Save "DMA valid" flag byte.
	mov	cl,34		;Skip I.D. bytes 108-175.
I_Skp2	in	ax,dx
	loop	I_Skp2
	in	ax,dx		;Read I.D. bytes 176 and 177.
	mov	bl,ah		;Save "UltraDMA selected" flag byte.
	mov	cl,167		;Skip remaining I.D. data.
I_Skp3	in	ax,dx
	loop	I_Skp3
	shl	si,1		;Is this an "ATA" hard-disk?
	jc	I_DErr		;No?  Exit & display message!
	test	bh,004h		;Are UltraDMA flag bits valid?
	jz	I_DErr		;No?  Exit & display message!
	mov	di,Modes	;Point to UltraDMA mode table.
	mov	al,'0'		;Initialize "current mode" value.
	mov	cl,002h		;Set rotating mode-check bit.
	cmp	bl,001h		;Will disk do UltraDMA mode 0?
	jae	I_NxtM		;Yes, find its best UltraDMA mode.
I_DErr	mov	dx,DEMsg	;Not an UltraDMA disk!   Point to msg.
I_SErr	stc			;Set carry flag (error!) and exit.
	ret
I_NxtM	mov	[CurMode],al	;Update "current mode" value in message.
	cmp	bl,cl		;Will disk do next UltraDMA mode?
	jb	I_GotM		;No, use current mode.
	inc	ax		;Set up for next UltraDMA mode.
	add	di,byte 4
	shl	cl,1		;More UltraDMA modes to check?
	jnz	I_NxtM		;Yes, loop back.
I_GotM	push	ax		;Save "current mode" value.
	mov	eax,[di]	;Set UltraDMA mode in set-mode message.
	mov	[DMode],eax
	inc	dx		;Set mode-select subcode.
	mov	al,SETM
	out	dx,al
	pop	ax		;Set desired UltraDMA mode.
	add	al,010h
	inc	dx
	out	dx,al
	mov	al,SETF		;Issue set-features command to disk.
	call	I_Cmd
	mov	dx,SEMsg	;Point to "Set-mode" error message.
	jc	I_SErr		;If error, set carry flag and exit.
	mov	dx,MSMsg	;Display "Set to mode" message.
I_Dspl	mov	ah,009h
I_Int21	int	021h
	push	cs		;Reload our DS-register.
	pop	ds
	clc			;Clear carry (no errors!) and exit.
	ret
;
; Subroutine to issue disk initialization commands.
;
I_Cmd	mov	dx,CCMD		;Issue desired init command.
	xor	dl,[HDOffs]
	out	dx,al
	xor	si,si		;Point to low-memory BIOS timer.
	mov	es,si
	mov	si,BIOSTMR
	mov	cl,RDYTO	;Set I-O timeout limit in CL-reg.
	add	cl,[es:si]
I_CmdW	cmp	cl,[es:si]	;Has our command timed out?
	je	I_CmdE		;Yes, set CPU carry flag & exit.
	in	al,dx		;Get IDE controller status.
	test	al,BSY+RDY	;Controller or disk still busy?
	jle	I_CmdW		;Yes, loop back and check again.
	test	al,ERR		;Did command cause any errors?
	jz	I_CmdX		;No, leave carry flag off & exit.
I_CmdE	stc			;Error!  Set CPU carry flag.
I_CmdX	ret			;Exit.
