
lfn_change_dir:
		mov		si,dx
		call	get_short_name
		jc		?error
		mov		dx,di
		mov		ah,0x3b
		int		0x21
		jnc		?exit
	?error:
		mov		[bp+sf.AX],ax			; return error code
		orb		[bp+sf.FLAGS],1			; set carry
	?exit:
		ret
; end of lfn_change_dir

lfn_get_current_dir:
		push	cs
		pop		ds
		mov		si,filename_buffer
		; need to have the drive so we can convert the sfn returned by dos to
		; its lfn version.
		mov		al,dl
		cmp		al,0					; 0 is the default drive, not much good to us
		jne		?have_drive
		mov		ah,0x19					; get current drive
		int		0x21
		inc		al						; get current drive returns 0=a:, need 1=a:
	?have_drive:
		add		al,'A'-1				; convert to drive letter
		mov		[si],al
		movd	[si+1],0x00005c3a		; ":\"
		add		si,3					; skip over drive/root specifier
	?default_drive:
		mov		ah,0x47					; get current directory
		int		0x21
		jc		?error					; probably an invalid drive (error in ax)
		; now convert the sfn path returned by dos to its lfn form. Of course,
		; this could easily wind up being the same thing, but not very often
		mov		si,filename_buffer
		push	cs
		pop		es
		mov		di,path_buffer
		mov		ax,1					; get long file name
		call	get_true_file_path
		; the only way an error should ever happen here is if the drive
		; doesn't allow direct disk access (network or cdrom), in that case,
		; just return what dos gave us, which is in filename_buffer.
		setc	al
		movzx	si,al
		dec		si
		and		si,path_buffer-filename_buffer
		add		si,filename_buffer+3	; do not include drive and root slash
		mov		es,[bp+sf.DS]
		mov		di,[bp+sf.SI]
		cld
		call	strcpy
		jmp		?exit
	?error:
		mov		[bp+sf.AX],ax			; return error code
		orb		[bp+sf.FLAGS],1			; set carry
	?exit:
		ret
; end of lfn_get_current_dir

lfn_make_dir:
;        AX = 7139h
;        DS:DX -> ASCIZ long directory name (including path)
;Return: CF clear if successful
;        CF set on error
;            AX = error code (see #1332)
;                7100h if function not supported
;Note:   for compatibility with DOS versions prior to v7.00, the carry flag
;          should be set on call to ensure that it is set on exit
		mov		si,dx
		call	get_short_name
		jnc		?exists
		cmp		ax,DE_file_not_found
		stc
		jne		?error
		; generate an sfn for the file
		call	generate_short_filename
		mov		ah,0x39
		mov		dx,filename_buffer
		int		0x21
		jc		?error
		; insert lfn directory entries
		mov		di,filename_buffer
		call	insert_long_filename
		jnc		?exit
		push	ax
		mov		ah,0x3a
		mov		dx,filename_buffer
		int		0x21
		pop		ax
		stc
		jmp		?error
	?exists:
		stc
		mov		ax,DE_access_denied
	?error:
		mov		[bp+sf.AX],ax
		orb		[bp+sf.FLAGS],1
	?exit:
		ret
; end of lfn_make_dir

lfn_remove_dir:
		mov		si,dx
		call	get_short_name
		jc		?error
		mov		ah,0x3a
		mov		dx,di
		int		0x21
		jc		?error
		call	delete_lfn
		jmp		?exit
	?error:
		mov		[bp+sf.AX],ax			; return error code
		orb		[bp+sf.FLAGS],1			; set carry
	?exit:
		ret
; end of lfn_remove_dir
