		.struct BPB_2_00
bps		.dw			; unsigned short bytes per sector
spc		.db			; unsigned char sectors per cluster
nrsec	.dw			; unsigned short number of reserved sectors
nfat	.db			; unsigned char number of fat copies
nrde	.dw			; unsigned short number of root directory entries
stsec	.dw			; unsigned short number of sectors (if<65536) else 0
media	.db			; unsigned char
spf		.dw			; unsigned short sectors per fat
		.ends

		.struct BPB_2_13
bps		.dw			; unsigned short bytes per sector
spc		.db			; unsigned char sectors per cluster
nrsec	.dw			; unsigned short number of reserved sectors
nfat	.db			; unsigned char number of fat copies
nrde	.dw			; unsigned short number of root directory entries
tsec	.dw			; unsigned short number of sectors
media	.db			; unsigned char
spf		.dw			; unsigned short sectors per fat
spt		.dw			; unsigned short sectors per track
nhds	.dw			; unsigned short number of heads
nhsec	.dw			; unsigned short number of hidden sectors
		.ends

		.struct BPB_3_00
bps		.dw			; unsigned short bytes per sector
spc		.db			; unsigned char sectors per cluster
nrsec	.dw			; unsigned short number of reserved sectors
nfat	.db			; unsigned char number of fat copies
nrde	.dw			; unsigned short number of root directory entries
tsec	.dw			; unsigned short number of sectors
media	.db			; unsigned char
spf		.dw			; unsigned short sectors per fat
spt		.dw			; unsigned short sectors per track
nhds	.dw			; unsigned short number of heads
nhsec	.dd			; unsigned long number of hidden sectors
label	.db 11 .dup	; char [11]
		.ends

		.struct BPB_4_00
bps		.dw			; unsigned short bytes per sector
spc		.db			; unsigned char sectors per cluster
nrsec	.dw			; unsigned short number of reserved sectors
nfat	.db			; unsigned char number of fat copies
nrde	.dw			; unsigned short number of root directory entries
stsec	.dw			; unsigned short number of sectors (if<65536) else 0
media	.db			; unsigned char
spf		.dw			; unsigned short sectors per fat
spt		.dw			; unsigned short sectors per track
nhds	.dw			; unsigned short number of heads
nhsec	.dd			; unsigned long number of hidden sectors
tsec	.dd			; unsigned long total sectors (if>65535)
		.db 6 .dup	; ???
ncyl    .dw			; unsigned short number of cylinders
devtype .db
devattr .dw
		.ends


		.struct	BPB_5_00
bps		.dw			; unsigned short bytes per sector
spc		.db			; unsigned char sectors per cluster
nrsec	.dw			; unsigned short number of reserved sectors
nfat	.db			; unsigned char number of fat copies
nrde	.dw			; unsigned short number of root directory entries
stsec	.dw			; unsigned short number of sectors (if<65536) else 0
media	.db			; unsigned char
spf		.dw			; unsigned short sectors per fat
spt		.dw			; unsigned short sectors per track
nhds	.dw			; unsigned short number of heads
nhsec	.dd			; unsigned long number of hidden sectors
tsec	.dd			; unsigned long total sectors (if>65535)
drive	.db			; unsigned char
		.db			; reserved
sig		.db			; unsigned char
volID	.dd			; unsigned long
label	.db 11 .dup	; char [11]
type	.db 8 .dup	; char [8]
		.ends

		.struct	BPB_7_01	; FAT32
bps		.dw			; unsigned short bytes per sector
spc		.db			; unsigned char sectors per cluster
nrsec	.dw			; unsigned short number of reserved sectors
nfat	.db			; unsigned char number of fat copies
nrde	.dw			; unsigned short number of root directory entries (0 if fat32??)
stsec	.dw			; unsigned short number of sectors (if<65536) else 0
media	.db			; unsigned char
sspf	.dw			; unsigned short sectors per fat (0 if fat32??)
spt		.dw			; unsigned short sectors per track
nhds	.dw			; unsigned short number of heads
nhsec	.dd			; unsigned long number of hidden sectors
tsec	.dd			; unsigned long total sectors (if>65535)
spf		.dd			; unsigned long sectors per fat (fat32)
xflags	.dw			; unsigned short extended flags (fat32)
fsvers	.dw			; unsigned short file system version (fat32)
rdclust	.dd			; unsigned long root directory cluster (fat32)
fsinfo	.dw			; unsigned short file system info sector (fat32)
bupbb	.dw			; unsigned short backup boot block (fat32)
		.dw 6 .dup	; reserved
drive	.db			; unsigned char
		.db			; reserved
sig		.db			; unsigned char
volID	.dd			; unsigned long
label	.db 11 .dup	; char [11]
type	.db 8 .dup	; char [8]
		.ends

		.struct BPB_relevant
		.dw			; unsigned short bytes per sector
spc		.db			; unsigned char sectors per cluster
nrsec	.dw			; unsigned short number of reserved sectors
nfat	.db			; unsigned char number of fat copies
nrde	.dw			; unsigned short number of root directory entries (0 if fat32??)
stsec	.dw			; unsigned short number of sectors (if<65536) else 0
		.db
sspf	.dw			; unsigned short sectors per fat (0 if fat32??)
		.dw
		.dw
		.dd
tsec	.dd			; unsigned long total sectors (if>65535)
spf		.dd			; unsigned long sectors per fat (fat32)
xflags	.dw			; unsigned short extended flags (fat32)
fsvers	.dw			; unsigned short file system version (fat32)
rdclust	.dd			; unsigned long root directory cluster (fat32)
fsinfo	.dw			; unsigned short file system info sector (fat32)
		.ends

		.union BPB
v200	.struct	BPB_2_00
v213	.struct	BPB_2_13
v300	.struct	BPB_3_00
v400	.struct	BPB_4_00
v500	.struct	BPB_5_00
v701	.struct BPB_7_01
		.struct BPB_relevant
		.ends

		.struct	Boot_Sector
jump	.db 3 .dup
oem_name .db 8 .dup
bpb		.struct BPB
code	.db 512-3-8-BPB-2 .dup
magic	.dw
		.ends
